# ValueSet - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* **ValueSet**

## ValueSet

| | |
| :--- | :--- |
| [AIFA - AIC](ValueSet-aifa-aic.md) | AIFA - Codice identificativo dei medicinali ad uso umano |
| [AIFA - Note](ValueSet-vs-aifa-nota.md) | AIFA - Indicazioni terapeutiche per un determinato farmaco rimborsabile dal Servizio Sanitario Nazionale |
| [Additivo Campione](ValueSet-additivo-campione-it.md) | Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione dell’additivo utilizzato per il campione di laboratorio. |
| [Anagrafi Regionali](ValueSet-vs-anagrafi-regionali.md) | Anagrafi Regionali |
| [Container Campione](ValueSet-campione-container-lab-it.md) | Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del container del campione di laboratorio. |
| [EHIC Personal ID (system IDs - oid)](ValueSet-oid-ehicPersonalId.md) | Sistema di identificazione delle persone fisiche |
| [ISO 3166 - EHIC Country Codes](ValueSet-iso-ehicCountryCode.md) | Codifica geografica standardizzata |
| [ISTAT - Cittadinanza](ValueSet-istat-cittadinanza.md) | ISTAT - Cittadinanza |
| [ISTAT - Comune/Stato di Nascita](ValueSet-istat-luogoNascita.md) | ISTAT - Comune o Stato di nascita |
| [ISTAT - Comuni](ValueSet-istat-comune.md) | ISTAT - Comuni più sconosciuto |
| [ISTAT - DUG](ValueSet-istat-dug.md) | ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG) |
| [ISTAT - Professioni](ValueSet-istat-professione.md) | ISTAT - Classificazione delle professioni |
| [ISTAT - Province](ValueSet-istat-provincia.md) | ISTAT - Province più sconosciuto |
| [ISTAT - Stati](ValueSet-istat-stato.md) | ISTAT - Stati |
| [ISTAT - Stato Civile](ValueSet-istat-statoCivile-vs.md) | ISTAT - Stato Civile |
| [ISTAT - Titolo Studio](ValueSet-istat-titoloStudio.md) | ISTAT - Titolo Studio |
| [Identificativi per codici STP regionali](ValueSet-URI-idStp.md) | Identificativi per codici STP regionali. |
| [Identificativi regionali per ASL (3 char)](ValueSet-uri-idAslRegione.md) | Identificativi regionali per ASL a 3 caratteri, come da file ministeriale |
| [MDS - Codici delle Strutture Interne](ValueSet-minsan-idStruttureInterne.md) | MDS - Codici delle Strutture Interne |
| [MDS - Elenco Farmacie](ValueSet-vs-mds-farmacia.md) | MDS - Elenco Farmacie |
| [MDS - Codici Regionali](ValueSet-minsan-regione.md) | MDS - Codici Regionali usati nei file FLS11. La regione Trentino Alto-Adige è rappresentata dalle province autonome di cui è composta. |
| [MDS - Codici strutture di ricovero pubbliche](ValueSet-strutturePubbliche.md) | MDS - Codici strutture di ricovero pubbliche |
| [MDS - ID Aziende Ospedaliere](ValueSet-minsan-idAziendeOspedaliere.md) | MDS - Aziende Ospedaliere |
| [MDS - ID Aziende Ospedaliere Universitarie](ValueSet-minsan-idAou.md) | MDS - Azienda Ospedaliera integrata con l’Università |
| [MDS - Strutture Ricovero](ValueSet-minsan-idStrutture.md) | MDS - Strutture Ricovero |
| [Risultato osservazione codificato](ValueSet-valueset-valuecodeableconcept-obs-it.md) | Valueset contenente i codici per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Risultato osservazione codificato - presenza/assenza IPS di SNOMED CT](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md) | Questo valueset include i codici per i risultati di presenza o assenza dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. |
| [Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT](ValueSet-results-observation-bloodgroup.md) | Questo valueset include i codici per i risultati dei gruppi sanguigni dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. |
| [Risultato osservazione codificato - microorganismo IPS di SNOMED CT](ValueSet-results-microorganism-snomed-ct-ips-free-set.md) | Questo valueset include i codici per i microrganismi dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. |
| [Risultato osservazione codificato gruppo sanguigno](ValueSet-valueset-observation-value-bloodgroup.md) | Valueset contenente i codici SNOMED di gruppo sanguigno per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Risultato osservazione codificato microorganismi](ValueSet-valueset-observation-value-microorganism.md) | Valueset contenente i codici SNOMED di microorganismi per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Risultato osservazione codificato presenza/assenza](ValueSet-valueset-observation-value-presence-absence.md) | Valueset contenente i codici SNOMED di presenza/assenza per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Sezioni Composition Lab Report](ValueSet-sezione-referto-laboratorio.md) | Valueset contenente i codici LOINC per la specialità di laboratorio. |
| [Stato Civile](ValueSet-statoCivile.md) | Questo value set definisce una serie di codici per rappresentare lo stato civile di una persona. Specializza ed estende il value set http://hl7.org/fhir/ValueSet/marital-status |
| [Stato Esenzione](ValueSet-statoEsenzione.md) | Value Set basato sul vocabolario HL7 V3 ActStatus che descrive lo stato delle esenzioni. Questo value set è adottato da HL7 CDA R2 IG ‘DOCUMENTO DI ESENZIONE’ |
| [MDS - Esenzioni](ValueSet-vs-mds-esenzioni.md) | Valueset contenente i codici esenzione |
| [AIFA Gruppo di Equivalenza](ValueSet-aifa-ge.md) | AIFA - ValueSet gruppo di equivalenza |
| [HL7 Italia - HL7 V3 RoleCode (estensione)](ValueSet-vs-V3RoleCode.md) | ValueSet - estensione del Vocabolario HL7 V3 RoleCode |
| [Tipo Osservazione](ValueSet-risultato-osservazione.md) | Valueset contente i codici che identificano il tipo di osservazione nel referto di laboratorio. |
| [Tipo campione](ValueSet-tipo-campione-lab-it.md) | Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del tipo di campione di laboratorio. |
| [Tipo certificatore](ValueSet-tipoCertificatore.md) | Tipo di Entità (organizzazione o persona) che ha certificato un certo record |
| [Tipo identificatore](ValueSet-VstipoIdentificatore.md) | Value set che descrivie i diversi tipi di identificatori. Include i codici della tabella http://terminology.hl7.org/CodeSystem/v2-0203 piu’ ‘STP’ ed ‘ENI’ |
| [Tipo medico di famiglia](ValueSet-mmgOrPls.md) | Tipo medico di famiglia: Medico Medicina Generale o Pediatra di Libera Scelta |
| [Tipo organizzazione (esempio)](ValueSet-tipoOrganizzazione.md) | Tipo di organizzazione: value set di esempio |
| [Tipo organizzazione socio-sanitaria](ValueSet-tipoOrgSocioSanitaria.md) | Tipo di organizzazione socio-sanitaria |
| [WHO ATC](ValueSet-who-atc.md) | Sistema di classificazione anatomico, terapeutico e chimico per la classificazione sistematica dei farmaci |
| [WHO ICD-9-CM](ValueSet-who-icd9cm.md) | WHO ICD-9-CM |

