# Risultato osservazione codificato - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Risultato osservazione codificato**

## ValueSet: Risultato osservazione codificato 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/valueset-valuecodeableconcept-obs-it | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsObservationValueCodeableConcept |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Valueset contenente i codici per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

Profile: [Shareable ValueSet](http://hl7.org/fhir/R4/shareablevalueset.html)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [Risultato osservazione codificato microorganismi](ValueSet-valueset-observation-value-microorganism.md)
* Import all the codes that are contained in [Risultato osservazione codificato gruppo sanguigno](ValueSet-valueset-observation-value-bloodgroup.md)
* Import all the codes that are contained in [Risultato osservazione codificato presenza/assenza](ValueSet-valueset-observation-value-presence-absence.md)

 

### Expansion

Expansion from tx.fhir.org based on:

* SNOMED CT International edition 01-Feb 2025
* SNOMED CT International edition 01-Sep 2023
* [valueset Risultato osservazione codificato gruppo sanguigno v0.1.2 (ValueSet)](ValueSet-valueset-observation-value-bloodgroup.md)
* [valueset Risultato osservazione codificato microorganismi v0.1.2 (ValueSet)](ValueSet-valueset-observation-value-microorganism.md)
* [valueset Risultato osservazione codificato presenza/assenza v0.1.2 (ValueSet)](ValueSet-valueset-observation-value-presence-absence.md)

This value set cannot be fully expanded, but a selection (1,000 codes) of the whole set of codes is shown here.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "valueset-valuecodeableconcept-obs-it",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/valueset-valuecodeableconcept-obs-it",
  "version" : "0.1.2",
  "name" : "VsObservationValueCodeableConcept",
  "title" : "Risultato osservazione codificato",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset contenente i codici per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "https://www.hl7.it/fhir/terminology/ValueSet/valueset-observation-value-microorganism"
        ]
      },
      {
        "valueSet" : [
          "https://www.hl7.it/fhir/terminology/ValueSet/valueset-observation-value-bloodgroup"
        ]
      },
      {
        "valueSet" : [
          "https://www.hl7.it/fhir/terminology/ValueSet/valueset-observation-value-presence-absence"
        ]
      }
    ]
  }
}

```
