# Tipo campione - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Tipo campione**

## ValueSet: Tipo campione 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/tipo-campione-lab-it | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsLabSpecimenTypesIt |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del tipo di campione di laboratorio. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "tipo-campione-lab-it",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/tipo-campione-lab-it",
  "version" : "0.1.2",
  "name" : "VsLabSpecimenTypesIt",
  "title" : "Tipo campione",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del tipo di campione di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "119376003",
            "display" : "Tissue specimen"
          },
          {
            "code" : "119359002",
            "display" : "Bone marrow specimen"
          },
          {
            "code" : "122571007",
            "display" : "Pericardial fluid"
          },
          {
            "code" : "119297000",
            "display" : "Blood specimen"
          },
          {
            "code" : "418564007",
            "display" : "Pleural fluid"
          },
          {
            "code" : "119303007",
            "display" : "Microbial isolate"
          },
          {
            "code" : "122554006",
            "display" : "Capillary blood specimen"
          },
          {
            "code" : "119326000",
            "display" : "Hair specimen"
          },
          {
            "code" : "258450006",
            "display" : "CSF specimen"
          },
          {
            "code" : "119327009",
            "display" : "Nail specimen"
          },
          {
            "code" : "119361006",
            "display" : "Plasma specimen"
          },
          {
            "code" : "119334006",
            "display" : "Sputum specimen"
          },
          {
            "code" : "119373006",
            "display" : "Amniotic fluid"
          },
          {
            "code" : "119339001",
            "display" : "Faeces specimen"
          },
          {
            "code" : "122552005",
            "display" : "Arterial blood specimen"
          },
          {
            "code" : "119341000",
            "display" : "Bile specimen"
          },
          {
            "code" : "122555007",
            "display" : "Venous blood specimen"
          },
          {
            "code" : "119342007",
            "display" : "Saliva specimen"
          },
          {
            "code" : "122575003",
            "display" : "Urine specimen"
          },
          {
            "code" : "119347001",
            "display" : "Seminal fluid"
          },
          {
            "code" : "309051001",
            "display" : "Body fluid"
          },
          {
            "code" : "119351004",
            "display" : "Erythrocyte specimen"
          },
          {
            "code" : "119364003",
            "display" : "Serum specimen"
          },
          {
            "code" : "119312009",
            "display" : "Catheter tip submitted as specimen"
          },
          {
            "code" : "258566005",
            "display" : "Deoxyribonucleic acid specimen"
          },
          {
            "code" : "258529004",
            "display" : "Throat swab"
          },
          {
            "code" : "119323008",
            "display" : "Pus specimen"
          },
          {
            "code" : "258607008",
            "display" : "Bronchoalveolar lavage fluid"
          },
          {
            "code" : "122556008",
            "display" : "Cord blood specimen"
          },
          {
            "code" : "258470000",
            "display" : "Prostatic fluid specimen"
          },
          {
            "code" : "122569007",
            "display" : "Sweat specimen"
          },
          {
            "code" : "258530009",
            "display" : "Urethral swab"
          },
          {
            "code" : "440500007",
            "display" : "Dried blood spot specimen"
          },
          {
            "code" : "258574006",
            "display" : "Mid-stream urine specimen"
          },
          {
            "code" : "119340004",
            "display" : "Meconium specimen"
          },
          {
            "code" : "119360007",
            "display" : "Dialysis fluid"
          },
          {
            "code" : "119332005",
            "display" : "Synovial fluid"
          },
          {
            "code" : "258455001",
            "display" : "Drainage fluid"
          },
          {
            "code" : "119371008",
            "display" : "Specimen from abscess"
          },
          {
            "code" : "168139001",
            "display" : "Peritoneal fluid"
          },
          {
            "code" : "258565009",
            "display" : "Chorionic villi specimen"
          },
          {
            "code" : "442173007",
            "display" : "Urine specimen from nephrostomy tube"
          },
          {
            "code" : "309128003",
            "display" : "Eye fluid"
          },
          {
            "code" : "119348006",
            "display" : "Seminal plasma specimen"
          },
          {
            "code" : "258528007",
            "display" : "Rectal swab"
          },
          {
            "code" : "122594008",
            "display" : "Tears specimen"
          },
          {
            "code" : "258591005",
            "display" : "White blood cell specimen"
          },
          {
            "code" : "127479004",
            "display" : "Specimen from uterus"
          },
          {
            "code" : "432825001",
            "display" : "Body secretion specimen"
          },
          {
            "code" : "446952006",
            "display" : "Specimen from skin obtained by scraping"
          },
          {
            "code" : "258503004",
            "display" : "Skin swab"
          },
          {
            "code" : "447103002",
            "display" : "Foreign body submitted as specimen"
          },
          {
            "code" : "119318008",
            "display" : "Water specimen"
          },
          {
            "code" : "699287008",
            "display" : "Urine specimen obtained via suprapubic indwelling urinary catheter"
          },
          {
            "code" : "119298005",
            "display" : "Mixed venous blood specimen"
          },
          {
            "code" : "703431007",
            "display" : "Venous cord blood specimen"
          },
          {
            "code" : "122565001",
            "display" : "Urinary catheter specimen"
          },
          {
            "code" : "705054005",
            "display" : "Muscle specimen"
          },
          {
            "code" : "309210009",
            "display" : "Oesophageal brushings specimen"
          },
          {
            "code" : "708049000",
            "display" : "Plasma specimen with ethylenediamine tetraacetic acid"
          },
          {
            "code" : "440473005",
            "display" : "Contact lens submitted as specimen"
          },
          {
            "code" : "733056005",
            "display" : "Fluid specimen from ear"
          },
          {
            "code" : "446846006",
            "display" : "Urine specimen obtained via indwelling urinary catheter"
          },
          {
            "code" : "258428005",
            "display" : "Products of conception tissue specimen"
          },
          {
            "code" : "258508008",
            "display" : "Genital swab"
          },
          {
            "code" : "258441009",
            "display" : "Exudate specimen"
          },
          {
            "code" : "119338009",
            "display" : "Dentin specimen"
          },
          {
            "code" : "119350003",
            "display" : "Calculus specimen"
          },
          {
            "code" : "258564008",
            "display" : "Buccal smear specimen"
          },
          {
            "code" : "119399004",
            "display" : "Specimen from eye"
          },
          {
            "code" : "119329007",
            "display" : "Colostrum specimen"
          },
          {
            "code" : "258458004",
            "display" : "Fistula fluid"
          },
          {
            "code" : "258589002",
            "display" : "Lymph node specimen"
          },
          {
            "code" : "258459007",
            "display" : "Gastric fluid"
          },
          {
            "code" : "258603007",
            "display" : "Respiratory specimen"
          },
          {
            "code" : "258465007",
            "display" : "Lacrimal fluid"
          },
          {
            "code" : "122567009",
            "display" : "Urine sediment specimen"
          },
          {
            "code" : "258466008",
            "display" : "Middle ear fluid"
          },
          {
            "code" : "309176002",
            "display" : "Bronchial brushings specimen"
          },
          {
            "code" : "258469001",
            "display" : "Pharyngeal washings"
          },
          {
            "code" : "119300005",
            "display" : "Specimen from blood product"
          },
          {
            "code" : "119403008",
            "display" : "Specimen from placenta"
          },
          {
            "code" : "439961009",
            "display" : "Implant submitted as specimen"
          },
          {
            "code" : "258479004",
            "display" : "Interstitial fluid"
          },
          {
            "code" : "119336008",
            "display" : "Exhaled air specimen"
          },
          {
            "code" : "258482009",
            "display" : "Vesicle fluid"
          },
          {
            "code" : "445160003",
            "display" : "Swab of eye"
          },
          {
            "code" : "258498002",
            "display" : "Conjunctival swab"
          },
          {
            "code" : "122572000",
            "display" : "Vomitus specimen"
          },
          {
            "code" : "258500001",
            "display" : "Nasopharyngeal swab"
          },
          {
            "code" : "472929000",
            "display" : "Central venous catheter tip submitted as specimen"
          },
          {
            "code" : "168141000",
            "display" : "Nasal fluid"
          },
          {
            "code" : "703430008",
            "display" : "Arterial cord blood specimen"
          },
          {
            "code" : "257261003",
            "display" : "Swab"
          },
          {
            "code" : "703432000",
            "display" : "Venous plasma specimen"
          },
          {
            "code" : "258411007",
            "display" : "Nasopharyngeal aspirate"
          },
          {
            "code" : "708048008",
            "display" : "Plasma specimen with citrate"
          },
          {
            "code" : "258415003",
            "display" : "Biopsy specimen"
          },
          {
            "code" : "732976006",
            "display" : "Fluid specimen from external auditory canal"
          },
          {
            "code" : "258417006",
            "display" : "Bone tissue specimen"
          },
          {
            "code" : "898201001",
            "display" : "Specimen from device"
          },
          {
            "code" : "258424007",
            "display" : "Heart valve tissue"
          },
          {
            "code" : "1003705007",
            "display" : "Drain tip submitted as specimen"
          }
        ]
      }
    ]
  }
}

```
