# Stato Civile - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Stato Civile**

## ValueSet: Stato Civile 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/statoCivile | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsStatoCivile |

 
Questo value set definisce una serie di codici per rappresentare lo stato civile di una persona. Specializza ed estende il value set http://hl7.org/fhir/ValueSet/marital-status 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

This value set contains 10 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "statoCivile",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/statoCivile",
  "version" : "0.1.2",
  "name" : "VsStatoCivile",
  "title" : "Stato Civile",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Questo value set definisce una serie di codici per rappresentare lo stato civile di una persona. Specializza ed estende il value set http://hl7.org/fhir/ValueSet/marital-status",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
        "concept" : [
          {
            "code" : "D",
            "display" : "Divorziato/a"
          },
          {
            "code" : "M",
            "display" : "Coniugato/a"
          },
          {
            "code" : "S",
            "display" : "Celibe/nubile"
          },
          {
            "code" : "W",
            "display" : "Vedovo/a"
          },
          {
            "code" : "L",
            "display" : "Separato/a Legalmente"
          },
          {
            "code" : "A",
            "display" : "Annullato"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "concept" : [
          {
            "code" : "UNK",
            "display" : "Sconosciuto"
          }
        ]
      },
      {
        "system" : "https://www.hl7.it/fhir/terminology/CodeSystem/istat-statoCivile",
        "concept" : [
          {
            "code" : "6",
            "display" : "Unito civilmente"
          },
          {
            "code" : "7",
            "display" : "Stato libero a seguito di decesso della parte unita civilmente"
          },
          {
            "code" : "8",
            "display" : "Stato libero a seguito di scioglimento dell'unione"
          }
        ]
      }
    ]
  }
}

```
