# Sezioni Composition Lab Report - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Sezioni Composition Lab Report**

## ValueSet: Sezioni Composition Lab Report 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/sezione-referto-laboratorio | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsSezioniRefertoLaboratorio |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc | |

 
Valueset contenente i codici LOINC per la specialità di laboratorio. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "sezione-referto-laboratorio",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/sezione-referto-laboratorio",
  "version" : "0.1.2",
  "name" : "VsSezioniRefertoLaboratorio",
  "title" : "Sezioni Composition Lab Report",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset contenente i codici LOINC per la specialità di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "18718-7",
            "display" : "Studi di marcatori cellulari"
          },
          {
            "code" : "18719-5",
            "display" : "Studi di chimica"
          },
          {
            "code" : "18720-3",
            "display" : "Studi di coagulazione"
          },
          {
            "code" : "18721-1",
            "display" : "Studi di monitoraggio terapeutico dei farmaci"
          },
          {
            "code" : "18722-9",
            "display" : "Studi di fertilità"
          },
          {
            "code" : "18723-7",
            "display" : "Studi di ematologia"
          },
          {
            "code" : "18724-5",
            "display" : "Studi HLA"
          },
          {
            "code" : "18725-2",
            "display" : "Studi di microbiologia"
          },
          {
            "code" : "18727-8",
            "display" : "Studi sierologici"
          },
          {
            "code" : "18728-6",
            "display" : "Studi tossicologici"
          },
          {
            "code" : "18729-4",
            "display" : "Studi di analisi delle urine"
          },
          {
            "code" : "18767-4",
            "display" : "Emogasanalisi"
          },
          {
            "code" : "18768-2",
            "display" : "Conta cellulare+Studi differenziali"
          },
          {
            "code" : "18769-0",
            "display" : "Test di suscettibilità microbica"
          },
          {
            "code" : "26435-8",
            "display" : "Studi di patologia molecolare"
          },
          {
            "code" : "26436-6",
            "display" : "Esami di laboratorio"
          },
          {
            "code" : "26437-4",
            "display" : "Test di sensibilità a sostanze chimiche"
          },
          {
            "code" : "26438-2",
            "display" : "Studi di citologia"
          },
          {
            "code" : "18716-1",
            "display" : "Studi di allergologia"
          },
          {
            "code" : "26439-0",
            "display" : "Studi di patologia chirurgica"
          },
          {
            "code" : "18717-9",
            "display" : "Studi della banca del sangue"
          },
          {
            "code" : "92894-5",
            "display" : "Microbiologia studi sui batteri"
          },
          {
            "code" : "96397-5",
            "display" : "Microbiologia studi di micobatteriologia"
          },
          {
            "code" : "96398-3",
            "display" : "Microbiologia studi di micologia"
          },
          {
            "code" : "92892-9",
            "display" : "Microbiologia studi sui parassiti"
          },
          {
            "code" : "92893-7",
            "display" : "Microbiologia studi sui virus"
          },
          {
            "code" : "50008-2",
            "display" : "Studi di miscelazione"
          },
          {
            "code" : "27898-6",
            "display" : "Studi di patologia"
          },
          {
            "code" : "28620-3",
            "display" : "Studi di urologia"
          },
          {
            "code" : "28634-4",
            "display" : "Studi vari"
          },
          {
            "code" : "56874-1",
            "display" : "Sierologia & banca del sangue, studi"
          },
          {
            "code" : "92895-2",
            "display" : "Endocrinologia, studi"
          }
        ]
      }
    ]
  }
}

```
