# Tipo Osservazione - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Tipo Osservazione**

## ValueSet: Tipo Osservazione 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/risultato-osservazione | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsResultsLaboratoryObservation |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc | |

 
Valueset contente i codici che identificano il tipo di osservazione nel referto di laboratorio. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include codes from[`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server) where STATUS = ACTIVE and CLASSTYPE = 1

This value set excludes codes based on the following rules:

* Exclude codes from[`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server) where CLASS matches (by regex) CYTO|HL7\.CYTOGEN|HL7\.GENETICS|^PATH(\..*)?|^MOLPATH(\..*)?|NR STATS|H&P\.HX\.LAB|CHALSKIN|LABORDERS

 

### Expansion

This value set contains 0 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "risultato-osservazione",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/risultato-osservazione",
  "version" : "0.1.2",
  "name" : "VsResultsLaboratoryObservation",
  "title" : "Tipo Osservazione",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset contente i codici che identificano il tipo di osservazione nel referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "filter" : [
          {
            "property" : "STATUS",
            "op" : "=",
            "value" : "ACTIVE"
          },
          {
            "property" : "CLASSTYPE",
            "op" : "=",
            "value" : "1"
          }
        ]
      }
    ],
    "exclude" : [
      {
        "system" : "http://loinc.org",
        "filter" : [
          {
            "property" : "CLASS",
            "op" : "regex",
            "value" : "CYTO|HL7\\.CYTOGEN|HL7\\.GENETICS|^PATH(\\..*)?|^MOLPATH(\\..*)?|NR STATS|H&P\\.HX\\.LAB|CHALSKIN|LABORDERS"
          }
        ]
      }
    ]
  }
}

```
