# ISTAT - Titolo Studio - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **ISTAT - Titolo Studio**

## ValueSet: ISTAT - Titolo Studio 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/istat-titoloStudio | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsIstatTitoloStudio |

 
Classificazione dei titoli di studio italiani 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in [`https://www.hl7.it/fhir/terminology/CodeSystem/istat-ctsi03`](CodeSystem-istat-ctsi03.md)version 📦0.1.2

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "istat-titoloStudio",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/istat-titoloStudio",
  "version" : "0.1.2",
  "name" : "VsIstatTitoloStudio",
  "title" : "ISTAT - Titolo Studio",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Classificazione dei titoli di studio italiani",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://www.hl7.it/fhir/terminology/CodeSystem/istat-ctsi03"
      }
    ]
  }
}

```
