# ISTAT - Comune/Stato di Nascita - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **ISTAT - Comune/Stato di Nascita**

## ValueSet: ISTAT - Comune/Stato di Nascita 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/istat-luogoNascita | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsIstatLuogoNascita |

 
Codici ISTAT per Comune o Stato di nascita 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [ISTAT - Stati](ValueSet-istat-stato.md)
* Import all the codes that are contained in [ISTAT - Comuni](ValueSet-istat-comune.md)

 

### Expansion

This value set has 1,226 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "istat-luogoNascita",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/istat-luogoNascita",
  "version" : "0.1.2",
  "name" : "VsIstatLuogoNascita",
  "title" : "ISTAT - Comune/Stato di Nascita",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Codici ISTAT per Comune o Stato di nascita",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : ["https://www.hl7.it/fhir/terminology/ValueSet/istat-stato"]
      },
      {
        "valueSet" : ["https://www.hl7.it/fhir/terminology/ValueSet/istat-comune"]
      }
    ]
  }
}

```
