# ISO 3166 - EHIC Country Codes - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **ISO 3166 - EHIC Country Codes**

## ValueSet: ISO 3166 - EHIC Country Codes 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/iso-ehicCountryCode | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsEHICCountryCodes |
| **Copyright/Legal**: ISO Maintains the copyright on the country codes, and controls it's use carefully. For further details, see the ISO 3166 Home Page | |

 
Codifica geografica standardizzata 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on codesystem ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code version 2018

This value set contains 31 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "iso-ehicCountryCode",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/iso-ehicCountryCode",
  "version" : "0.1.2",
  "name" : "VsEHICCountryCodes",
  "title" : "ISO 3166 - EHIC Country Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Codifica geografica standardizzata",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "ISO Maintains the copyright on the country codes, and controls it's use carefully. For further details, see the ISO 3166 Home Page",
  "compose" : {
    "include" : [
      {
        "system" : "urn:iso:std:iso:3166",
        "concept" : [
          {
            "code" : "AT",
            "display" : "Austria"
          },
          {
            "code" : "BE",
            "display" : "Belgium"
          },
          {
            "code" : "BG",
            "display" : "Bulgaria"
          },
          {
            "code" : "HR",
            "display" : "Croatia"
          },
          {
            "code" : "CY",
            "display" : "Cyprus"
          },
          {
            "code" : "CZ",
            "display" : "Czech Republic"
          },
          {
            "code" : "DK",
            "display" : "Denmark"
          },
          {
            "code" : "EE",
            "display" : "Estonia"
          },
          {
            "code" : "FI",
            "display" : "Finland"
          },
          {
            "code" : "FR",
            "display" : "France"
          },
          {
            "code" : "GR",
            "display" : "Greece"
          },
          {
            "code" : "DE",
            "display" : "Germany"
          },
          {
            "code" : "HU",
            "display" : "Hungary"
          },
          {
            "code" : "IE",
            "display" : "Ireland"
          },
          {
            "code" : "IT",
            "display" : "Italy"
          },
          {
            "code" : "LV",
            "display" : "Latvia"
          },
          {
            "code" : "LT",
            "display" : "Lithuania"
          },
          {
            "code" : "LU",
            "display" : "Luxembourg"
          },
          {
            "code" : "MT",
            "display" : "Malta"
          },
          {
            "code" : "NL",
            "display" : "Netherlands"
          },
          {
            "code" : "PL",
            "display" : "Poland"
          },
          {
            "code" : "PT",
            "display" : "Portugal"
          },
          {
            "code" : "RO",
            "display" : "Romania"
          },
          {
            "code" : "SK",
            "display" : "Slovakia"
          },
          {
            "code" : "SI",
            "display" : "Slovenia"
          },
          {
            "code" : "ES",
            "display" : "Spain"
          },
          {
            "code" : "SE",
            "display" : "Sweden"
          },
          {
            "code" : "IS",
            "display" : "Iceland"
          },
          {
            "code" : "LI",
            "display" : "Liechtenstein"
          },
          {
            "code" : "NO",
            "display" : "Norway"
          },
          {
            "code" : "CH",
            "display" : "Switzerland"
          }
        ]
      }
    ]
  }
}

```
