# Container Campione - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Container Campione**

## ValueSet: Container Campione 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/campione-container-lab-it | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsLabSpecimenContainerIt |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del container del campione di laboratorio. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "campione-container-lab-it",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/campione-container-lab-it",
  "version" : "0.1.2",
  "name" : "VsLabSpecimenContainerIt",
  "title" : "Container Campione",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del container del campione di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "702290003",
            "display" : "Cervical cytology microscopy slide (physical object)"
          },
          {
            "code" : "706057008",
            "display" : "Cytology specimen container (physical object)"
          },
          {
            "code" : "706052002",
            "display" : "Evacuated blood collection tube (physical object)"
          },
          {
            "code" : "702292006",
            "display" : "Evacuated blood collection tube , K3EDTA/sodium fluoride (physical object)"
          },
          {
            "code" : "767387006",
            "display" : "Evacuated blood collection tube with citrate and theophylline and adenosine and dipyramidole (physical object)"
          },
          {
            "code" : "767384004",
            "display" : "Evacuated blood collection tube with clot activator (physical object)"
          },
          {
            "code" : "767390000",
            "display" : "Evacuated blood collection tube with heparin lithium and gelseparator (physical object)"
          },
          {
            "code" : "767382000",
            "display" : "Evacuated blood collection tube with heparin sodium (physical object)"
          },
          {
            "code" : "767660003",
            "display" : "Evacuated blood collection tube with sodium fluoride (physical object)"
          },
          {
            "code" : "767389009",
            "display" : "Evacuated blood collection tube with tripotassium and ethylene diamine tetraacetic acid and aprotinin (physical object)"
          },
          {
            "code" : "702279008",
            "display" : "Evacuated blood collection tube, gel separator (physical object)"
          },
          {
            "code" : "702293001",
            "display" : "Evacuated blood collection tube, K2EDTA/aprotinin (physical object)"
          },
          {
            "code" : "702278000",
            "display" : "Evacuated blood collection tube, no additive/metal-free (physical object)"
          },
          {
            "code" : "702280006",
            "display" : "Evacuated blood collection tube, RNA stabiliser (physical object)"
          },
          {
            "code" : "702281005",
            "display" : "Evacuated blood collection tube, thrombin/clot activator/gelseparator (physical object)"
          },
          {
            "code" : "702310001",
            "display" : "Evacuated saliva specimen container, sodium azide (physical object)"
          },
          {
            "code" : "706056004",
            "display" : "Evacuated urine specimen container (physical object)"
          },
          {
            "code" : "702302002",
            "display" : "Evacuated urine specimen container, boric acid (H3BO3) (physical object)"
          },
          {
            "code" : "702288004",
            "display" : "Evacuated urine specimen container, boric acid (H3BO3)/sodiumformate (physical object)"
          },
          {
            "code" : "702289007",
            "display" : "Evacuated urine specimen container, ethyl paraben/sodium propionate/chlorhexidine (physical object)"
          },
          {
            "code" : "702303007",
            "display" : "Evacuated urine specimen container, multiple preservative (physical object)"
          },
          {
            "code" : "702308003",
            "display" : "Evacuated urine specimen container, no additive (physical object)"
          },
          {
            "code" : "706047007",
            "display" : "Fecal specimen container (physical object)"
          },
          {
            "code" : "706053007",
            "display" : "General specimen container (physical object)"
          },
          {
            "code" : "702268003",
            "display" : "General specimen container, no additive, non-sterile (physical object)"
          },
          {
            "code" : "702269006",
            "display" : "General specimen container, no additive, sterile (physical object)"
          },
          {
            "code" : "874799005",
            "display" : "Microbial cryotube (physical object)"
          },
          {
            "code" : "706050005",
            "display" : "Microcapillary blood collection tube (physical object)"
          },
          {
            "code" : "702275002",
            "display" : "Microcapillary blood collection tube, ammonium heparin (physical object)"
          },
          {
            "code" : "702276001",
            "display" : "Microcapillary blood collection tube, K2EDTA (physical object)"
          },
          {
            "code" : "702277005",
            "display" : "Microcapillary blood collection tube, no additive (physical object)"
          },
          {
            "code" : "702304001",
            "display" : "Microcapillary blood transfer tube, clot activator (physical object)"
          },
          {
            "code" : "702306004",
            "display" : "Microcapillary blood transfer tube, EDTA (physical object)"
          },
          {
            "code" : "702307008",
            "display" : "Microcapillary blood transfer tube, heparin (physical object)"
          },
          {
            "code" : "702305000",
            "display" : "Microcapillary sodium fluoride blood transfer tube (physical object)"
          },
          {
            "code" : "702224000",
            "display" : "Midstream urine specimen container (physical object)"
          },
          {
            "code" : "706051009",
            "display" : "Non-evacuated blood collection tube (physical object)"
          },
          {
            "code" : "702283008",
            "display" : "Non-evacuated blood collection tube with gel separator (physical object)"
          },
          {
            "code" : "702297000",
            "display" : "Non-evacuated blood collection tube, clot activator (physical object)"
          },
          {
            "code" : "702295008",
            "display" : "Non-evacuated blood collection tube, clot activator/gel separator (physical object)"
          },
          {
            "code" : "702282003",
            "display" : "Non-evacuated blood collection tube, EDTA (physical object)"
          },
          {
            "code" : "702299002",
            "display" : "Non-evacuated blood collection tube, K2EDTA (physical object)"
          },
          {
            "code" : "702298005",
            "display" : "Non-evacuated blood collection tube, K3EDTA (physical object)"
          },
          {
            "code" : "702284002",
            "display" : "Non-evacuated blood collection tube, lithium heparin (physical object)"
          },
          {
            "code" : "702300005",
            "display" : "Non-evacuated blood collection tube, lithium heparin/gel separator,non-sterile (physical object)"
          },
          {
            "code" : "702285001",
            "display" : "Non-evacuated blood collection tube, lithium heparin/gel separator,sterile (physical object)"
          },
          {
            "code" : "702286000",
            "display" : "Non-evacuated blood collection tube, NaEDTA/sodium fluoride (physical object)"
          },
          {
            "code" : "702256007",
            "display" : "Non-evacuated blood collection tube, no additive (physical object)"
          },
          {
            "code" : "702287009",
            "display" : "Non-evacuated blood collection tube, potassium oxalate/sodiumfluoride (physical object)"
          },
          {
            "code" : "702296009",
            "display" : "Non-evacuated blood collection tube, sodium citrate (physical object)"
          },
          {
            "code" : "702264001",
            "display" : "Non-sterile urine specimen container (physical object)"
          },
          {
            "code" : "702309006",
            "display" : "Saliva specimen container, no additive (physical object)"
          },
          {
            "code" : "706058003",
            "display" : "Secretory specimen container (physical object)"
          },
          {
            "code" : "706046003",
            "display" : "Specimen receptacle (physical object)"
          },
          {
            "code" : "702223006",
            "display" : "Sputum specimen container (physical object)"
          },
          {
            "code" : "702244006",
            "display" : "Sterile urine specimen container (physical object)"
          },
          {
            "code" : "702232008",
            "display" : "Sweat specimen container (physical object)"
          },
          {
            "code" : "702294007",
            "display" : "Syringe-blood collection tube transfer (physical object)"
          },
          {
            "code" : "706054001",
            "display" : "Urine specimen container (physical object)"
          },
          {
            "code" : "767385003",
            "display" : "Aerobic blood culture bottle (physical object)"
          },
          {
            "code" : "767383005",
            "display" : "Anaerobic blood culture bottle (physical object)"
          }
        ]
      }
    ]
  }
}

```
