# Ministero della Salute - ASL - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Ministero della Salute - ASL**

## CodeSystem: Ministero della Salute - ASL 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/cs-asl | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsMDSASL |

 
Ministero della Salute - ASL 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsAsl](ValueSet-mds-asl-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cs-asl",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/cs-asl",
  "version" : "0.1.2",
  "name" : "CsMDSASL",
  "title" : "Ministero della Salute - ASL",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Ministero della Salute - ASL",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "filter" : [
    {
      "code" : "regione",
      "description" : "Permette di ricercare i codici secondo il codice Regionale di appartenenza",
      "operator" : ["="],
      "value" : "codice della Regione"
    },
    {
      "code" : "comune",
      "description" : "Permette di ricercare i codici secondo il codice del comune di appartenenza",
      "operator" : ["="],
      "value" : "codice del Comune"
    },
    {
      "code" : "provincia",
      "description" : "Permette di ricercare i codici secondo il codice della provincia di appartenenza",
      "operator" : ["="],
      "value" : "codice della Provincia"
    }
  ],
  "property" : [
    {
      "code" : "regione",
      "description" : "Proprietà che identifica la regione di appartenenza dell'ASL",
      "type" : "code"
    },
    {
      "code" : "comune",
      "description" : "Proprietà che identifica il comune di appartenenza dell'ASL",
      "type" : "code"
    },
    {
      "code" : "provincia",
      "description" : "Proprietà che identifica la provincia di appartenenza dell'ASL",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "010203",
      "display" : "TO3",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001090"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "010204",
      "display" : "TO4",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001082"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "010205",
      "display" : "TO5",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001078"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "010206",
      "display" : "VC",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "002158"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "010207",
      "display" : "BI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "096047"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        }
      ]
    },
    {
      "code" : "010208",
      "display" : "NO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "010209",
      "display" : "VCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "103050"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        }
      ]
    },
    {
      "code" : "010210",
      "display" : "CN1",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004078"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "010211",
      "display" : "CN2",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004003"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "010212",
      "display" : "AT",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "005005"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "010213",
      "display" : "AL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "006003"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "010301",
      "display" : "ASL CITTA' DI TORINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "020101",
      "display" : "AZIENDA U.S.L. VALLE D'AOSTA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "comune",
          "valueCode" : "007003"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "030321",
      "display" : "ATS DELLA CITTA' METROPOLITANA DI MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "030322",
      "display" : "ATS DELL'INSUBRIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012133"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "030323",
      "display" : "ATS DELLA MONTAGNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "014061"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "030324",
      "display" : "ATS DELLA BRIANZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015149"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "030325",
      "display" : "ATS DI BERGAMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "030326",
      "display" : "ATS DI BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "030327",
      "display" : "ATS DELLA VAL PADANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020030"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "030328",
      "display" : "ATS DI PAVIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "041201",
      "display" : "AZIENDA SANITARIA DELLA P.A. DI BOLZANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021008"
        },
        {
          "code" : "provincia",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "042101",
      "display" : "TRENTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022205"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "050501",
      "display" : "AZIENDA ULSS N. 1 DOLOMITI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "025006"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "050502",
      "display" : "AZIENDA ULSS N. 2 MARCA TREVIGIANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "026086"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "050503",
      "display" : "AZIENDA ULSS N. 3 SERENISSIMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "050504",
      "display" : "AZIENDA ULSS N. 4 VENETO ORIENTALE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "027033"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "050505",
      "display" : "AZIENDA ULSS N. 5 POLESANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "029041"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "050506",
      "display" : "AZIENDA ULSS N. 6 EUGANEA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "050507",
      "display" : "AZIENDA ULSS N. 7 PEDEMONTANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "024012"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "050508",
      "display" : "AZIENDA ULSS N. 8 BERICA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "050509",
      "display" : "AZIENDA ULSS N. 9 SCALIGERA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "060205",
      "display" : "AS FRIULI OCCIDENTALE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "093033"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "060206",
      "display" : "ASU FRIULI CENTRALE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "060207",
      "display" : "ASU GIULIANO ISONTINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "070101",
      "display" : "IMPERIESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "008055"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "070102",
      "display" : "SAVONESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "009056"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "070103",
      "display" : "GENOVESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "070104",
      "display" : "CHIAVARESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010015"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "070105",
      "display" : "SPEZZINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "011015"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "080101",
      "display" : "AZIENDA USL PIACENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "080102",
      "display" : "AZIENDA USL PARMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "080103",
      "display" : "AZIENDA USL REGGIO EMILIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "080104",
      "display" : "AZIENDA USL MODENA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "080105",
      "display" : "AZIENDA USL BOLOGNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "080106",
      "display" : "AZIENDA USL IMOLA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037032"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "080109",
      "display" : "AZIENDA USL FERRARA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "080114",
      "display" : "AZIENDA USL DELLA ROMAGNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "090201",
      "display" : "AZIENDA USL TOSCANA CENTRO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "090202",
      "display" : "AZIENDA USL TOSCANA NORD-OVEST",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "090203",
      "display" : "AZIENDA USL TOSCANA SUD-EST",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "100201",
      "display" : "AUSL UMBRIA N. 1",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "100202",
      "display" : "AUSL UMBRIA N. 2",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "110301",
      "display" : "AST1 DI PESARO E URBINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "041044"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "110302",
      "display" : "AST2 DI ANCONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "042002"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "110303",
      "display" : "AST3 DI MACERATA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "043023"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "110304",
      "display" : "AST4 DI FERMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "044019"
        },
        {
          "code" : "provincia",
          "valueCode" : "109"
        }
      ]
    },
    {
      "code" : "110305",
      "display" : "AST5 DI ASCOLI PICENO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "044007"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "120109",
      "display" : "VITERBO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "120110",
      "display" : "RIETI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "057059"
        },
        {
          "code" : "provincia",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "120111",
      "display" : "LATINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "120112",
      "display" : "FROSINONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060038"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "120201",
      "display" : "ROMA 1",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "120202",
      "display" : "ROMA 2",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "120203",
      "display" : "ROMA 3",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "120204",
      "display" : "ROMA 4",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058032"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "120205",
      "display" : "ROMA 5",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058104"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "120206",
      "display" : "ROMA 6",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058003"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "130201",
      "display" : "AVEZZANO-SULMONA-L'AQUILA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066049"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "130202",
      "display" : "LANCIANO-VASTO-CHIETI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "130203",
      "display" : "PESCARA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "130204",
      "display" : "TERAMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "067041"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "140201",
      "display" : "ASREM",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "comune",
          "valueCode" : "070006"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "150201",
      "display" : "A.S.L. AVELLINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "150202",
      "display" : "A.S.L. BENEVENTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "062008"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "150203",
      "display" : "A.S.L. CASERTA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061022"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "150204",
      "display" : "A.S.L. NAPOLI 1 CENTRO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "150205",
      "display" : "A.S.L. NAPOLI 2 NORD",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063032"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "150206",
      "display" : "A.S.L. NAPOLI 3 SUD",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063084"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "150207",
      "display" : "A.S.L. SALERNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "160106",
      "display" : "ASL BR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "160112",
      "display" : "ASL TA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "160113",
      "display" : "ASL BT",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072005"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        }
      ]
    },
    {
      "code" : "160114",
      "display" : "ASL BA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "160115",
      "display" : "ASL FG",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "160116",
      "display" : "ASL LE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "170201",
      "display" : "AZIENDA SANITARIA LOCALE DI POTENZA ASP",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "076063"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "170202",
      "display" : "AZIENDA SANITARIA LOCALE DI MATERA  ASM",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "077014"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "180201",
      "display" : "A.S.P. COSENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "180202",
      "display" : "A.S.P. CROTONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        }
      ]
    },
    {
      "code" : "180203",
      "display" : "A.S.P. CATANZARO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "180204",
      "display" : "A.S.P. VIBO VALENTIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "102047"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        }
      ]
    },
    {
      "code" : "180205",
      "display" : "A.S.P. REGGIO CALABRIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        }
      ]
    },
    {
      "code" : "190201",
      "display" : "ASP AGRIGENTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "084001"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        }
      ]
    },
    {
      "code" : "190202",
      "display" : "ASP CALTANISSETTA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "085004"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "190203",
      "display" : "ASP CATANIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "190204",
      "display" : "ASP ENNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "086009"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        }
      ]
    },
    {
      "code" : "190205",
      "display" : "ASP MESSINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "190206",
      "display" : "ASP PALERMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "190207",
      "display" : "ASP RAGUSA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "088009"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "190208",
      "display" : "ASP SIRACUSA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        }
      ]
    },
    {
      "code" : "190209",
      "display" : "ASP DI TRAPANI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081021"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        }
      ]
    },
    {
      "code" : "200301",
      "display" : "ASL N. 1 DI SASSARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "200302",
      "display" : "ASL N. 2 DELLA GALLURA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090047"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "200303",
      "display" : "ASL N. 3 DI NUORO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "091051"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "200304",
      "display" : "ASL N. 4 DELL'OGLIASTRA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "091037"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "200305",
      "display" : "ASL N. 5 DI ORISTANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "095038"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        }
      ]
    },
    {
      "code" : "200306",
      "display" : "ASL N. 6 DEL MEDIO CAMPIDANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092057"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        }
      ]
    },
    {
      "code" : "200307",
      "display" : "ASL N. 7 DEL SULCIS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092012"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        }
      ]
    },
    {
      "code" : "200308",
      "display" : "ASL N. 8 DI CAGLIARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        }
      ]
    }
  ]
}

```
