# AIFA - Farmaci equivalenti - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **AIFA - Farmaci equivalenti**

## CodeSystem: AIFA - Farmaci equivalenti 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/aifa-ge | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsFarmaciEquivalenti |

 
Farmaci Equivalenti 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "aifa-ge",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/aifa-ge",
  "version" : "0.1.2",
  "name" : "CsFarmaciEquivalenti",
  "title" : "AIFA - Farmaci equivalenti",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Farmaci Equivalenti",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "filter" : [
    {
      "code" : "ATC",
      "description" : "Classificazione ATC farmaco",
      "operator" : ["="],
      "value" : "Codice ATC"
    },
    {
      "code" : "gruppoEquivalenza",
      "description" : "Gruppo di equivalenza del farmaco",
      "operator" : ["=", "not-in", "in"],
      "value" : "Codice del gruppo di equivalenza"
    }
  ],
  "property" : [
    {
      "code" : "ATC",
      "description" : "Codice ATC del farmaco",
      "type" : "code"
    },
    {
      "code" : "gruppoEquivalenza",
      "description" : "Gruppo di equivalenza del farmaco",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "44155024",
      "display" : "ACARBOSIO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "39716182",
      "display" : "ACARBOSIO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "38835144",
      "display" : "ACARPHAGE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "26851016",
      "display" : "GLUCOBAY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "47612027",
      "display" : "ACARBOSIO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "44155012",
      "display" : "ACARBOSIO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "39716170",
      "display" : "ACARBOSIO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "38835043",
      "display" : "ACARPHAGE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "47923014",
      "display" : "GLUCOBAY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "45461011",
      "display" : "GLUCOBAY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "45430016",
      "display" : "GLUCOBAY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "26851028",
      "display" : "GLUCOBAY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BF01"
        }
      ]
    },
    {
      "code" : "32773032",
      "display" : "AIRTAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB16"
        }
      ]
    },
    {
      "code" : "31220027",
      "display" : "GLADIO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB16"
        }
      ]
    },
    {
      "code" : "31842026",
      "display" : "KAFENAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB16"
        }
      ]
    },
    {
      "code" : "42403042",
      "display" : "ACECLOFENAC ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB16"
        }
      ]
    },
    {
      "code" : "43259035",
      "display" : "ACECLOFENAC EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB16"
        }
      ]
    },
    {
      "code" : "32773020",
      "display" : "AIRTAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB16"
        }
      ]
    },
    {
      "code" : "31220015",
      "display" : "GLADIO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB16"
        }
      ]
    },
    {
      "code" : "31842014",
      "display" : "KAFENAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB16"
        }
      ]
    },
    {
      "code" : "28614129",
      "display" : "ACICLIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33482023",
      "display" : "ACICLOVIR ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "31846025",
      "display" : "ACICLOVIR ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33868023",
      "display" : "ACICLOVIR ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "36035032",
      "display" : "ACICLOVIR AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33551060",
      "display" : "ACICLOVIR DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "28467049",
      "display" : "ACICLOVIR DOROM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "32307035",
      "display" : "ACICLOVIR EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33429022",
      "display" : "ACICLOVIR GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "34738056",
      "display" : "ACICLOVIR MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33731035",
      "display" : "ACICLOVIR SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "25298086",
      "display" : "ZOVIRAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "46032013",
      "display" : "ACICLOVIR AUROBINDO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "32307011",
      "display" : "ACICLOVIR EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "50312014",
      "display" : "ACICLOVIR PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "46277012",
      "display" : "ACICLOVIR ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "25298050",
      "display" : "ZOVIRAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "28614055",
      "display" : "ACICLIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "46032049",
      "display" : "ACICLOVIR AUROBINDO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33551021",
      "display" : "ACICLOVIR DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "28467037",
      "display" : "ACICLOVIR DOROM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "32307023",
      "display" : "ACICLOVIR EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "34738031",
      "display" : "ACICLOVIR MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "50312026",
      "display" : "ACICLOVIR PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33731011",
      "display" : "ACICLOVIR SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "46277036",
      "display" : "ACICLOVIR ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "28920039",
      "display" : "CIVRAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "37290018",
      "display" : "SINAFID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "25298074",
      "display" : "ZOVIRAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "28614081",
      "display" : "ACICLIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33482047",
      "display" : "ACICLOVIR ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "31846049",
      "display" : "ACICLOVIR ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33868011",
      "display" : "ACICLOVIR ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "36110017",
      "display" : "ACICLOVIR ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "36035018",
      "display" : "ACICLOVIR AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "46032052",
      "display" : "ACICLOVIR AUROBINDO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33551072",
      "display" : "ACICLOVIR DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "28467064",
      "display" : "ACICLOVIR DOROM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "32307086",
      "display" : "ACICLOVIR EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33429046",
      "display" : "ACICLOVIR GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "34738043",
      "display" : "ACICLOVIR MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "34583031",
      "display" : "ACICLOVIR PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33731050",
      "display" : "ACICLOVIR SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "46277063",
      "display" : "ACICLOVIR ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "33471018",
      "display" : "AMODIVYR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "28528077",
      "display" : "CITIVIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "25299126",
      "display" : "CYCLOVIRAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "35005014",
      "display" : "TUCLOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "25298124",
      "display" : "ZOVIRAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "26E"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB01"
        }
      ]
    },
    {
      "code" : "46280018",
      "display" : "ACIDO ACETILSALICILICO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "48150015",
      "display" : "ACIDO ACETILSALICILICO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "42179010",
      "display" : "ACIDO ACETILSALICILICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "42180048",
      "display" : "ACIDO ACETILSALICILICO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "44822029",
      "display" : "ACIDO ACETILSALICILICO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "47065014",
      "display" : "ACIDO ACETILSALICILICO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "48958019",
      "display" : "ACIDO ACETILSALICILICO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "42207011",
      "display" : "ACIDO ACETILSALICILICO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "49648013",
      "display" : "ACIDO ACETILSALICILICO ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "24840074",
      "display" : "CARDIOASPIRIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC06"
        }
      ]
    },
    {
      "code" : "41256241",
      "display" : "ACIDO ALENDRONICO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37520020",
      "display" : "ALENDRONATO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37194103",
      "display" : "ALENDRONATO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38408047",
      "display" : "ALENDRONATO SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38317044",
      "display" : "ALENDRONATO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37444027",
      "display" : "ASTON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38031163",
      "display" : "DRALENOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38296024",
      "display" : "LOSS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38649024",
      "display" : "NEADRALE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37519028",
      "display" : "PORODRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "41538024",
      "display" : "ACIDO ALENDRONICO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "41256227",
      "display" : "ACIDO ALENDRONICO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37515018",
      "display" : "ACIDO ALENDRONICO EUROGENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "43119015",
      "display" : "ACIDO ALENDRONICO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37514015",
      "display" : "ACIDO ALENDRONICO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "29053079",
      "display" : "ADRONAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37499011",
      "display" : "ALENDRONATO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37520018",
      "display" : "ALENDRONATO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37194089",
      "display" : "ALENDRONATO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37198013",
      "display" : "ALENDRONATO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38408023",
      "display" : "ALENDRONATO SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38006108",
      "display" : "ALENDRONATO SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38317020",
      "display" : "ALENDRONATO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "29051075",
      "display" : "ALENDROS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37521010",
      "display" : "ALENIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37444015",
      "display" : "ASTON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37644010",
      "display" : "DORYX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "50142013",
      "display" : "FOSAMAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "47397017",
      "display" : "FOSAMAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "29052077",
      "display" : "FOSAMAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "34172054",
      "display" : "GENALEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37500016",
      "display" : "GLAMOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38296012",
      "display" : "LOSS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38649012",
      "display" : "NEADRALE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "38297014",
      "display" : "NOFRATTIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37085089",
      "display" : "OSTEUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37519016",
      "display" : "PORODRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37443013",
      "display" : "PORONAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "37461011",
      "display" : "REALEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA04"
        }
      ]
    },
    {
      "code" : "44670014",
      "display" : "ACIDO ALENDRONICO E COLECALCIFEROLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "44520029",
      "display" : "ACIDO ALENDRONICO E COLECALCIFEROLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "37603026",
      "display" : "ADROVANCE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "46006019",
      "display" : "ALENDRONATO E COLECALCIFEROLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "44579011",
      "display" : "ALENDRONATO E COLECALCIFEROLO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "45284015",
      "display" : "ALENDRONATO E COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "44986014",
      "display" : "ALENDRONATO E COLECALCIFEROLO MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "44405037",
      "display" : "ALENDRONATO E COLECALCIFEROLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "36845028",
      "display" : "FOSAVANCE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "39641028",
      "display" : "VANTAVO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "44670026",
      "display" : "ACIDO ALENDRONICO E COLECALCIFEROLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "44520056",
      "display" : "ACIDO ALENDRONICO E COLECALCIFEROLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "37603077",
      "display" : "ADROVANCE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "46006033",
      "display" : "ALENDRONATO E COLECALCIFEROLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "44579035",
      "display" : "ALENDRONATO E COLECALCIFEROLO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "45284027",
      "display" : "ALENDRONATO E COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "44986026",
      "display" : "ALENDRONATO E COLECALCIFEROLO MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "48970026",
      "display" : "ALENDRONATO E COLECALCIFEROLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "44405114",
      "display" : "ALENDRONATO E COLECALCIFEROLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "36845079",
      "display" : "FOSAVANCE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "39641081",
      "display" : "VANTAVO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H6B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BB03"
        }
      ]
    },
    {
      "code" : "45647017",
      "display" : "ACIDO CARGLUMICO WAYMADE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A16AA05"
        }
      ]
    },
    {
      "code" : "35983030",
      "display" : "CARBAGLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A16AA05"
        }
      ]
    },
    {
      "code" : "45647031",
      "display" : "ACIDO CARGLUMICO WAYMADE*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A16AA05"
        }
      ]
    },
    {
      "code" : "35983028",
      "display" : "CARBAGLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A16AA05"
        }
      ]
    },
    {
      "code" : "45485012",
      "display" : "UCEDANE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A16AA05"
        }
      ]
    },
    {
      "code" : "26372058",
      "display" : "CLASTEON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "38B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA02"
        }
      ]
    },
    {
      "code" : "34721050",
      "display" : "CLODRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "38B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA02"
        }
      ]
    },
    {
      "code" : "26510053",
      "display" : "DIFOSFONAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "38B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA02"
        }
      ]
    },
    {
      "code" : "26372033",
      "display" : "CLASTEON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "38A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA02"
        }
      ]
    },
    {
      "code" : "35129030",
      "display" : "CLODRONATO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "38A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA02"
        }
      ]
    },
    {
      "code" : "34294037",
      "display" : "CLODY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "38A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA02"
        }
      ]
    },
    {
      "code" : "26510038",
      "display" : "DIFOSFONAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "38A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M05BA02"
        }
      ]
    },
    {
      "code" : "40274072",
      "display" : "ACIDO FOLICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "GSG"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45545062",
      "display" : "ACIDO FOLICO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "GSG"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "42186015",
      "display" : "BALFOLIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "GSG"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "36346029",
      "display" : "FERTIFOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "GSG"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "36345027",
      "display" : "FOLIDEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "GSG"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "48957068",
      "display" : "ACIDO FOLICO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JHI"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "40274058",
      "display" : "ACIDO FOLICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JHI"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45545047",
      "display" : "ACIDO FOLICO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JHI"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45533041",
      "display" : "ACIDO FOLICO SF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JHI"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45534043",
      "display" : "FOLATEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JHI"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "40627022",
      "display" : "FOLIFILL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JHI"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "2309072",
      "display" : "FOLINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JHI"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45532049",
      "display" : "NOVACID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JHI"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "48957017",
      "display" : "ACIDO FOLICO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "40274019",
      "display" : "ACIDO FOLICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45545011",
      "display" : "ACIDO FOLICO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45534017",
      "display" : "FOLATEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "42972012",
      "display" : "FOLICOM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "2309045",
      "display" : "FOLINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "40274060",
      "display" : "ACIDO FOLICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45545050",
      "display" : "ACIDO FOLICO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "36346017",
      "display" : "FERTIFOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "36345015",
      "display" : "FOLIDEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "48957029",
      "display" : "ACIDO FOLICO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "40274033",
      "display" : "ACIDO FOLICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45545023",
      "display" : "ACIDO FOLICO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45534029",
      "display" : "FOLATEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "40627010",
      "display" : "FOLIFILL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "2309060",
      "display" : "FOLINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "48957043",
      "display" : "ACIDO FOLICO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "40274045",
      "display" : "ACIDO FOLICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45545035",
      "display" : "ACIDO FOLICO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "45534031",
      "display" : "FOLATEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "42972024",
      "display" : "FOLICOM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "2309058",
      "display" : "FOLINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "H7E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03BB01"
        }
      ]
    },
    {
      "code" : "43305034",
      "display" : "ACIDO MICOFENOLICO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F6C"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AA06"
        }
      ]
    },
    {
      "code" : "44778037",
      "display" : "CEPTAVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F6C"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AA06"
        }
      ]
    },
    {
      "code" : "36511032",
      "display" : "MYFORTIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F6C"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AA06"
        }
      ]
    },
    {
      "code" : "43305061",
      "display" : "ACIDO MICOFENOLICO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F6D"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AA06"
        }
      ]
    },
    {
      "code" : "44778064",
      "display" : "CEPTAVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F6D"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AA06"
        }
      ]
    },
    {
      "code" : "36511069",
      "display" : "MYFORTIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F6D"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AA06"
        }
      ]
    },
    {
      "code" : "44760039",
      "display" : "ACIDO TRANEXAMICO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CAE"
        },
        {
          "code" : "ATC",
          "valueCode" : "B02AA02"
        }
      ]
    },
    {
      "code" : "22019032",
      "display" : "TRANEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CAE"
        },
        {
          "code" : "ATC",
          "valueCode" : "B02AA02"
        }
      ]
    },
    {
      "code" : "21458031",
      "display" : "UGUROL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CAE"
        },
        {
          "code" : "ATC",
          "valueCode" : "B02AA02"
        }
      ]
    },
    {
      "code" : "23605076",
      "display" : "DEURSIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "24615078",
      "display" : "LITURSOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "26893038",
      "display" : "URDES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "23630039",
      "display" : "URSACOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "24444034",
      "display" : "URSOBIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "25430063",
      "display" : "URSOLISIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "23605153",
      "display" : "DEURSIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01D"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "26893065",
      "display" : "URDES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01D"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "24173066",
      "display" : "URSILON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01D"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "33090010",
      "display" : "ACIDO URSODESOSSICOLICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "28366019",
      "display" : "ACIDO URSODESOSSICOLICO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "28931018",
      "display" : "ACIDO URSODESOSSICOLICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "33512031",
      "display" : "ACIDO URSODESOSSICOLICO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "23605114",
      "display" : "DEURSIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "28404010",
      "display" : "LITOFF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "24615080",
      "display" : "LITURSOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "26893040",
      "display" : "URDES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "24173080",
      "display" : "URSILON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "24444123",
      "display" : "URSOBIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "26073027",
      "display" : "URSOFLOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "25430101",
      "display" : "URSOLISIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "33090034",
      "display" : "ACIDO URSODESOSSICOLICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "28931032",
      "display" : "ACIDO URSODESOSSICOLICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "33512017",
      "display" : "ACIDO URSODESOSSICOLICO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "23605138",
      "display" : "DEURSIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "28404022",
      "display" : "LITOFF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "26893053",
      "display" : "URDES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "24173054",
      "display" : "URSILON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "29038027",
      "display" : "URSOBIL HT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "26073039",
      "display" : "URSOFLOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "01B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A05AA02"
        }
      ]
    },
    {
      "code" : "22483034",
      "display" : "DEPAKIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "39A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AG01"
        }
      ]
    },
    {
      "code" : "47431010",
      "display" : "SODIO VALPROATO AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "39A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AG01"
        }
      ]
    },
    {
      "code" : "27480021",
      "display" : "NEOTIGASON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05BB02"
        }
      ]
    },
    {
      "code" : "41619065",
      "display" : "ZORIAS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05BB02"
        }
      ]
    },
    {
      "code" : "27480019",
      "display" : "NEOTIGASON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05BB02"
        }
      ]
    },
    {
      "code" : "41619014",
      "display" : "ZORIAS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05BB02"
        }
      ]
    },
    {
      "code" : "29824051",
      "display" : "ACQUA PER PREPARAZIONI INIETTABILI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "40C"
        },
        {
          "code" : "ATC",
          "valueCode" : "V07AB"
        }
      ]
    },
    {
      "code" : "30779033",
      "display" : "ACQUA PER PREPARAZIONI INIETTABILI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "40C"
        },
        {
          "code" : "ATC",
          "valueCode" : "V07AB"
        }
      ]
    },
    {
      "code" : "29824024",
      "display" : "ACQUA PER PREPARAZIONI INIETTABILI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "40A"
        },
        {
          "code" : "ATC",
          "valueCode" : "V07AB"
        }
      ]
    },
    {
      "code" : "30779019",
      "display" : "ACQUA PER PREPARAZIONI INIETTABILI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "40A"
        },
        {
          "code" : "ATC",
          "valueCode" : "V07AB"
        }
      ]
    },
    {
      "code" : "30650016",
      "display" : "ADRENALINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "41A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01CA24"
        }
      ]
    },
    {
      "code" : "30780011",
      "display" : "ADRENALINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "41A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01CA24"
        }
      ]
    },
    {
      "code" : "29825015",
      "display" : "ADRENALINA GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "41A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01CA24"
        }
      ]
    },
    {
      "code" : "30650030",
      "display" : "ADRENALINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "41B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01CA24"
        }
      ]
    },
    {
      "code" : "30780023",
      "display" : "ADRENALINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "41B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01CA24"
        }
      ]
    },
    {
      "code" : "29825039",
      "display" : "ADRENALINA GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "41B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01CA24"
        }
      ]
    },
    {
      "code" : "43043013",
      "display" : "ALFUZOSINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "38423012",
      "display" : "ALFUZOSINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "37419064",
      "display" : "ALFUZOSINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "37589037",
      "display" : "ALFUZOSINA HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "37413034",
      "display" : "ALFUZOSINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "38779031",
      "display" : "ALFUZOSINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "37197050",
      "display" : "ALFUZOSINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "38155038",
      "display" : "ALFUZOSINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "38661029",
      "display" : "ALFUZOSINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "27878038",
      "display" : "ALFUZOSINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "38422010",
      "display" : "FARALZIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "26670051",
      "display" : "MITTOVAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "41657014",
      "display" : "OFUXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "27314044",
      "display" : "XATRAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA01"
        }
      ]
    },
    {
      "code" : "46453104",
      "display" : "ALLOPURINOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "43337029",
      "display" : "ALLOPURINOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "22441048",
      "display" : "ALLOPURINOLO MOLTENI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "45054057",
      "display" : "ALLOPURINOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "39060292",
      "display" : "ALLOPURINOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "40180147",
      "display" : "ALLOPURINOLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "21259027",
      "display" : "ZYLORIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "46453041",
      "display" : "ALLOPURINOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "43337017",
      "display" : "ALLOPURINOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "22441036",
      "display" : "ALLOPURINOLO MOLTENI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "45054020",
      "display" : "ALLOPURINOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "39060076",
      "display" : "ALLOPURINOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "40180059",
      "display" : "ALLOPURINOLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "21259015",
      "display" : "ZYLORIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "33B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA01"
        }
      ]
    },
    {
      "code" : "34996013",
      "display" : "ALMOGRAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "34995011",
      "display" : "ALMOTREX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "49838016",
      "display" : "ALMOGRAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "50204015",
      "display" : "ALMOGRAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "34996037",
      "display" : "ALMOGRAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "34995035",
      "display" : "ALMOTREX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "43075047",
      "display" : "ALMOTRIPTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "43074020",
      "display" : "ALMOTRIPTAN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "43073042",
      "display" : "ALMOTRIPTAN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "41813039",
      "display" : "ALMOTRIPTAN MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "43340076",
      "display" : "ALMOTRIPTAN TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "43662030",
      "display" : "ALMOTRIPTAN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC05"
        }
      ]
    },
    {
      "code" : "40351013",
      "display" : "ALOPERIDOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HKF"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AD01"
        }
      ]
    },
    {
      "code" : "25373059",
      "display" : "HALDOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HKF"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AD01"
        }
      ]
    },
    {
      "code" : "48211041",
      "display" : "AMBRISENTAN ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "47062068",
      "display" : "AMBRISENTAN DR. REDDY'S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "46559047",
      "display" : "AMBRISENTAN MEDAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "48081032",
      "display" : "AMBRISENTAN MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "47049147",
      "display" : "AMBRISENTAN TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "49229127",
      "display" : "AMBRISENTAN ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "38528042",
      "display" : "VOLIBRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "48211027",
      "display" : "AMBRISENTAN ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "47062029",
      "display" : "AMBRISENTAN DR. REDDY'S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "46559023",
      "display" : "AMBRISENTAN MEDAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "48081018",
      "display" : "AMBRISENTAN MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "47049061",
      "display" : "AMBRISENTAN TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "49229040",
      "display" : "AMBRISENTAN ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "38528028",
      "display" : "VOLIBRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX02"
        }
      ]
    },
    {
      "code" : "33586025",
      "display" : "AMIKACINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "42D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01GB06"
        }
      ]
    },
    {
      "code" : "27484031",
      "display" : "AMIKAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "42D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01GB06"
        }
      ]
    },
    {
      "code" : "25513045",
      "display" : "CHEMACIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "42D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01GB06"
        }
      ]
    },
    {
      "code" : "24475067",
      "display" : "LIKACIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "42D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01GB06"
        }
      ]
    },
    {
      "code" : "24527071",
      "display" : "LUKADIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "42D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01GB06"
        }
      ]
    },
    {
      "code" : "28423022",
      "display" : "MIKAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "42D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01GB06"
        }
      ]
    },
    {
      "code" : "33190036",
      "display" : "NEKACIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "42D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01GB06"
        }
      ]
    },
    {
      "code" : "27484043",
      "display" : "AMIKAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "42C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01GB06"
        }
      ]
    },
    {
      "code" : "24475055",
      "display" : "LIKACIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "42C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01GB06"
        }
      ]
    },
    {
      "code" : "22033031",
      "display" : "AMIODAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "44B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD01"
        }
      ]
    },
    {
      "code" : "44112023",
      "display" : "AMIODARONE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "44B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD01"
        }
      ]
    },
    {
      "code" : "47255029",
      "display" : "AMIODARONE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "44B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD01"
        }
      ]
    },
    {
      "code" : "40758029",
      "display" : "AMIODARONE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "44B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD01"
        }
      ]
    },
    {
      "code" : "35729019",
      "display" : "AMIODARONE RATIOPHARM ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "44B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD01"
        }
      ]
    },
    {
      "code" : "33200015",
      "display" : "AMIODARONE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "44B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD01"
        }
      ]
    },
    {
      "code" : "32801019",
      "display" : "AMIODARONE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "44B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD01"
        }
      ]
    },
    {
      "code" : "25035015",
      "display" : "CORDARONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "44B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD01"
        }
      ]
    },
    {
      "code" : "48964047",
      "display" : "AMISULPRIDE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "37126075",
      "display" : "AMISULPRIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "43003096",
      "display" : "AMISULPRIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "46308096",
      "display" : "GEALEVIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "33462021",
      "display" : "SOLIAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "48964062",
      "display" : "AMISULPRIDE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "37126101",
      "display" : "AMISULPRIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "43003211",
      "display" : "AMISULPRIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "46308159",
      "display" : "GEALEVIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "33462045",
      "display" : "SOLIAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AL05"
        }
      ]
    },
    {
      "code" : "45218017",
      "display" : "AMITRIPTILINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HOD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AA09"
        }
      ]
    },
    {
      "code" : "44532012",
      "display" : "AMITRIPTILINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HOD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AA09"
        }
      ]
    },
    {
      "code" : "45418011",
      "display" : "AMITRIPTILINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HOD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AA09"
        }
      ]
    },
    {
      "code" : "19906054",
      "display" : "LAROXYL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HOD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AA09"
        }
      ]
    },
    {
      "code" : "38038028",
      "display" : "ABIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37674025",
      "display" : "ALMIDIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37701238",
      "display" : "AMLODIPINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "41408194",
      "display" : "AMLODIPINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39389212",
      "display" : "AMLODIPINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37329024",
      "display" : "AMLODIPINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "40789226",
      "display" : "AMLODIPINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38092021",
      "display" : "AMLODIPINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37479159",
      "display" : "AMLODIPINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38648022",
      "display" : "AMLODIPINA EPIFARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37675028",
      "display" : "AMLODIPINA FG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38102303",
      "display" : "AMLODIPINA HEXAL AG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39612155",
      "display" : "AMLODIPINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39799174",
      "display" : "AMLODIPINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37987056",
      "display" : "AMLODIPINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38072308",
      "display" : "AMLODIPINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37676020",
      "display" : "AMLODIPINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38654024",
      "display" : "AMLODIPINA TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38548160",
      "display" : "AMLODIPINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "41785116",
      "display" : "AMLODIPINA ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38075026",
      "display" : "AMLOPOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "27461021",
      "display" : "ANTACAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38055024",
      "display" : "BALARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37679026",
      "display" : "KRUDIPIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38056026",
      "display" : "LOSEDIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38058020",
      "display" : "NATAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43817030",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43348061",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43348073",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "44428074",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43348034",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43663044",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39670017",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39670082",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43995012",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43994019",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "44503023",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43348010",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43704016",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43817016",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "44428011",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "44428023",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "44428035",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43663032",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "27428022",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37008024",
      "display" : "PRESSAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38038016",
      "display" : "ABIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37674013",
      "display" : "ALMIDIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37701036",
      "display" : "AMLODIPINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "41408030",
      "display" : "AMLODIPINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39389186",
      "display" : "AMLODIPINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37329012",
      "display" : "AMLODIPINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "40789063",
      "display" : "AMLODIPINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38092019",
      "display" : "AMLODIPINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37479060",
      "display" : "AMLODIPINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38102048",
      "display" : "AMLODIPINA HEXAL AG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39612041",
      "display" : "AMLODIPINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39799034",
      "display" : "AMLODIPINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37987029",
      "display" : "AMLODIPINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "50045018",
      "display" : "AMLODIPINA PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38072043",
      "display" : "AMLODIPINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37676018",
      "display" : "AMLODIPINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38654012",
      "display" : "AMLODIPINA TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38548032",
      "display" : "AMLODIPINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "41785155",
      "display" : "AMLODIPINA ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38075014",
      "display" : "AMLOPOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "27461019",
      "display" : "ANTACAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38055012",
      "display" : "BALARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37679014",
      "display" : "KRUDIPIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38056014",
      "display" : "LOSEDIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38058018",
      "display" : "NATAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "50281017",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43995036",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43348046",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "44628016",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43348022",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43704030",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "44428047",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "44428050",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "43663018",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "27428010",
      "display" : "NORVASC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37008012",
      "display" : "PRESSAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39389263",
      "display" : "AMLODIPINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37329036",
      "display" : "AMLODIPINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "40789265",
      "display" : "AMLODIPINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38092045",
      "display" : "AMLODIPINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "37479209",
      "display" : "AMLODIPINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38102339",
      "display" : "AMLODIPINA HEXAL AG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39612181",
      "display" : "AMLODIPINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "39799198",
      "display" : "AMLODIPINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "50045032",
      "display" : "AMLODIPINA PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38072334",
      "display" : "AMLODIPINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "38548210",
      "display" : "AMLODIPINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "41785054",
      "display" : "AMLODIPINA ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA01"
        }
      ]
    },
    {
      "code" : "44091039",
      "display" : "AMLODIPINA E VALSARTAN DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGI"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB01"
        }
      ]
    },
    {
      "code" : "44196172",
      "display" : "ASBIMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGI"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB01"
        }
      ]
    },
    {
      "code" : "49198296",
      "display" : "DIPPERAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGI"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB01"
        }
      ]
    },
    {
      "code" : "44091027",
      "display" : "AMLODIPINA E VALSARTAN DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGH"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB01"
        }
      ]
    },
    {
      "code" : "44196107",
      "display" : "ASBIMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGH"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB01"
        }
      ]
    },
    {
      "code" : "49198169",
      "display" : "DIPPERAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGH"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB01"
        }
      ]
    },
    {
      "code" : "44091015",
      "display" : "AMLODIPINA E VALSARTAN DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGG"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB01"
        }
      ]
    },
    {
      "code" : "44196032",
      "display" : "ASBIMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGG"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB01"
        }
      ]
    },
    {
      "code" : "49198031",
      "display" : "DIPPERAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGG"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB01"
        }
      ]
    },
    {
      "code" : "49098015",
      "display" : "AMLODIPINA VALSARTAN IDROCLOROTIAZIDE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LXQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DX01"
        }
      ]
    },
    {
      "code" : "49912025",
      "display" : "DIPPERAM HCT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LXQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DX01"
        }
      ]
    },
    {
      "code" : "33151034",
      "display" : "AMOXICILLINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "44209068",
      "display" : "AMOXICILLINA ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23966106",
      "display" : "AMOXINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23086097",
      "display" : "ZIMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "34338018",
      "display" : "AMOSOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23909031",
      "display" : "AMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "35223015",
      "display" : "AMOXICILLINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "33676014",
      "display" : "AMOXICILLINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "28964043",
      "display" : "AMOXICILLINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "32918029",
      "display" : "AMOXICILLINA ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "45674090",
      "display" : "AMOXICILLINA AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23108184",
      "display" : "AMOXICILLINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "29487016",
      "display" : "AMOXICILLINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "33290014",
      "display" : "AMOXICILLINA GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "49038033",
      "display" : "AMOXICILLINA HCS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "39493034",
      "display" : "AMOXICILLINA HEXAL AG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "34812038",
      "display" : "AMOXICILLINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "44067027",
      "display" : "AMOXICILLINA MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "46905028",
      "display" : "AMOXICILLINA PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "34614026",
      "display" : "AMOXICILLINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "39492032",
      "display" : "AMOXICILLINA SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "32892010",
      "display" : "AMOXICILLINA TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23966094",
      "display" : "AMOXINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "34981011",
      "display" : "SIEVERT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23053123",
      "display" : "SINTOPEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23097102",
      "display" : "VELAMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23086150",
      "display" : "ZIMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23086174",
      "display" : "ZIMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "45674025",
      "display" : "AMOXICILLINA AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18K"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23097013",
      "display" : "VELAMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18K"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "23086162",
      "display" : "ZIMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "18K"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CA04"
        }
      ]
    },
    {
      "code" : "36816015",
      "display" : "ABBA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36816027",
      "display" : "ABBA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37350016",
      "display" : "ABIOCLAV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37856022",
      "display" : "ACADIMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37828023",
      "display" : "AKLAV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "45173010",
      "display" : "AMOCLA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "45173022",
      "display" : "AMOCLA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36819011",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "46580015",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ALMUS GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "46285019",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36944015",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36944027",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37813019",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37813021",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "39545076",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37165014",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36848012",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO BIOPHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36848024",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO BIOPHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36802015",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36802027",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42173029",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42173068",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37042013",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "43207125",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36969044",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36744011",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37188024",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO P-CARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37501020",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "46908051",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36707014",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO RATIOPHARM ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36980047",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "41933033",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36815013",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36815025",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "46355020",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "46355018",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "39743024",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO TEVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "44262018",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "43981012",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ZENTIVA LAB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36801013",
      "display" : "ANIVAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36801025",
      "display" : "ANIVAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "38291124",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42902041",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "39785100",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42902039",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37954070",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37954082",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37954094",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37954106",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37954118",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "40488049",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "40488052",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "40488076",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42212023",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42918058",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42918060",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "41267030",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "41267042",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "43388026",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26089019",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26089108",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "39785050",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "39785062",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "39785074",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "39785086",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "39785098",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "38291047",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "38291050",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "38291086",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37217066",
      "display" : "AVEGGIO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42174045",
      "display" : "CLAUTERO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37185028",
      "display" : "CLAVOMED",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26138139",
      "display" : "CLAVULIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26138192",
      "display" : "CLAVULIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36791010",
      "display" : "HOMER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36791022",
      "display" : "HOMER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37335015",
      "display" : "KLAVUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37335027",
      "display" : "KLAVUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36896013",
      "display" : "KRUXADE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36896025",
      "display" : "KRUXADE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36847010",
      "display" : "MONDEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36847022",
      "display" : "MONDEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26141147",
      "display" : "NEODUPLAMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26141198",
      "display" : "NEODUPLAMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36808018",
      "display" : "POSMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37912021",
      "display" : "PURICLAV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "44107023",
      "display" : "SAROMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37747045",
      "display" : "STEMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37747033",
      "display" : "STEMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36829024",
      "display" : "XINAMOD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "45173059",
      "display" : "AMOCLA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42173118",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36980201",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37526074",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO TEVA GROUP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "48462067",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ZENTIVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26089514",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26138228",
      "display" : "CLAVULIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26141224",
      "display" : "NEODUPLAMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42173070",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36980148",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37526011",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO TEVA GROUP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26089464",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26138204",
      "display" : "CLAVULIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26141200",
      "display" : "NEODUPLAMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37350028",
      "display" : "ABIOCLAV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "42173094",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "36980175",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "37526047",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO TEVA GROUP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "48462055",
      "display" : "AMOXICILLINA E ACIDO CLAVULANICO ZENTIVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26089502",
      "display" : "AUGMENTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26138216",
      "display" : "CLAVULIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "26141212",
      "display" : "NEODUPLAMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CJC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01CR02"
        }
      ]
    },
    {
      "code" : "45524016",
      "display" : "ANAGRELIDE ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRH"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01XX35"
        }
      ]
    },
    {
      "code" : "45581016",
      "display" : "ANAGRELIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRH"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01XX35"
        }
      ]
    },
    {
      "code" : "46101010",
      "display" : "ANAGRELIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRH"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01XX35"
        }
      ]
    },
    {
      "code" : "45355017",
      "display" : "ANAGRELIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRH"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01XX35"
        }
      ]
    },
    {
      "code" : "45705023",
      "display" : "ANAGRELIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRH"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01XX35"
        }
      ]
    },
    {
      "code" : "36745014",
      "display" : "XAGRID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRH"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01XX35"
        }
      ]
    },
    {
      "code" : "39777014",
      "display" : "ADIUNASTROL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "39548019",
      "display" : "ANASTROZOLO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "39632043",
      "display" : "ANASTROZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "49178027",
      "display" : "ANASTROZOLO AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "39793017",
      "display" : "ANASTROZOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "39147020",
      "display" : "ANASTROZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "37952049",
      "display" : "ANASTROZOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "49569015",
      "display" : "ANASTROZOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "38924039",
      "display" : "ANASTROZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "40195012",
      "display" : "ANASTROZOLO SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "38101034",
      "display" : "ANASTROZOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "37953041",
      "display" : "ANASTROZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "40008043",
      "display" : "ANTABREST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "49435011",
      "display" : "ARIMIDEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "31809015",
      "display" : "ARIMIDEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "39547017",
      "display" : "ERISTROL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "39094014",
      "display" : "EXTROPLEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "39897018",
      "display" : "GRISET",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "39896016",
      "display" : "RAOLOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "40073013",
      "display" : "RENAZOLE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG03"
        }
      ]
    },
    {
      "code" : "36582183",
      "display" : "ABILIFY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "46053029",
      "display" : "ARIPIPRAZOLO AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "49300015",
      "display" : "ARIPIPRAZOLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44737017",
      "display" : "ARIPIPRAZOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44868026",
      "display" : "ABERIPRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "36582029",
      "display" : "ABILIFY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "36582094",
      "display" : "ABILIFY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44543080",
      "display" : "ARIPIPRAZOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43653043",
      "display" : "ARIPIPRAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43730023",
      "display" : "ARIPIPRAZOLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43801063",
      "display" : "ARIPIPRAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43737129",
      "display" : "ARIPIPRAZOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43733043",
      "display" : "ARIPIPRAZOLO MYLAN ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44285056",
      "display" : "ARIPIPRAZOLO MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44407183",
      "display" : "ARIPIPRAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43743208",
      "display" : "ARIPIPRAZOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43732039",
      "display" : "ARIPIPRAZOLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44265078",
      "display" : "ARIPIPRAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44868038",
      "display" : "ABERIPRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "36582031",
      "display" : "ABILIFY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "36582120",
      "display" : "ABILIFY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44543142",
      "display" : "ARIPIPRAZOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43653068",
      "display" : "ARIPIPRAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43730035",
      "display" : "ARIPIPRAZOLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43801101",
      "display" : "ARIPIPRAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43737220",
      "display" : "ARIPIPRAZOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43572128",
      "display" : "ARIPIPRAZOLO MACLEODS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43733056",
      "display" : "ARIPIPRAZOLO MYLAN ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44285082",
      "display" : "ARIPIPRAZOLO MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44407310",
      "display" : "ARIPIPRAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43743347",
      "display" : "ARIPIPRAZOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43732155",
      "display" : "ARIPIPRAZOLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44265128",
      "display" : "ARIPIPRAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44868014",
      "display" : "ABERIPRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "36582017",
      "display" : "ABILIFY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44543027",
      "display" : "ARIPIPRAZOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43653029",
      "display" : "ARIPIPRAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43730011",
      "display" : "ARIPIPRAZOLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43801024",
      "display" : "ARIPIPRAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43737028",
      "display" : "ARIPIPRAZOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44285029",
      "display" : "ARIPIPRAZOLO MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44407043",
      "display" : "ARIPIPRAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "43743069",
      "display" : "ARIPIPRAZOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "44265027",
      "display" : "ARIPIPRAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "HSD"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AX12"
        }
      ]
    },
    {
      "code" : "33789013",
      "display" : "ATENOLOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "34052011",
      "display" : "ATENOLOLO RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29486038",
      "display" : "ATENOLOLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "33378023",
      "display" : "ATENOLOLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "36542013",
      "display" : "ATENOLOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "33279023",
      "display" : "ATENOLOLO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "46688077",
      "display" : "ATENOLOLO AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "33789025",
      "display" : "ATENOLOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29776073",
      "display" : "ATENOLOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "36544017",
      "display" : "ATENOLOLO FG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29468028",
      "display" : "ATENOLOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29533027",
      "display" : "ATENOLOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "34052035",
      "display" : "ATENOLOLO RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "36543015",
      "display" : "ATENOLOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "24016038",
      "display" : "TENORMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "36541011",
      "display" : "TENSIBLOCK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "25070020",
      "display" : "ATENOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29776059",
      "display" : "ATENOLOLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "34052023",
      "display" : "ATENOLOLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29486026",
      "display" : "ATENOLOLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "33378035",
      "display" : "ATENOLOLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "41098233",
      "display" : "ATENOLOLO AHCL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "33279035",
      "display" : "ATENOLOLO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "46688089",
      "display" : "ATENOLOLO AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "33789037",
      "display" : "ATENOLOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29468030",
      "display" : "ATENOLOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29533041",
      "display" : "ATENOLOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "36543027",
      "display" : "ATENOLOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "24325060",
      "display" : "SELES BETA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29420015",
      "display" : "TENOMAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29776022",
      "display" : "ATENOLOLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "29486014",
      "display" : "ATENOLOLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "41098221",
      "display" : "ATENOLOLO AHCL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "46688038",
      "display" : "ATENOLOLO AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "09C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB03"
        }
      ]
    },
    {
      "code" : "25987037",
      "display" : "ATENIGRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "33159017",
      "display" : "ATENOLOLO CLORTALIDONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "33054026",
      "display" : "ATENOLOLO CLORTALIDONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "34167015",
      "display" : "ATENOLOLO CLORTALIDONE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "34069017",
      "display" : "ATENOLOLO E CLORTALIDONE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "24763056",
      "display" : "IGROSELES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "25089032",
      "display" : "TARGET",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "24737025",
      "display" : "TENORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "33159029",
      "display" : "ATENOLOLO CLORTALIDONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "33054014",
      "display" : "ATENOLOLO CLORTALIDONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "34167027",
      "display" : "ATENOLOLO CLORTALIDONE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "24763068",
      "display" : "IGROSELES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "24737037",
      "display" : "TENORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "32805018",
      "display" : "ATENOLOLO CLORTALIDONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "26027021",
      "display" : "CLORTANOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "10D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07CB03"
        }
      ]
    },
    {
      "code" : "40234027",
      "display" : "ATORVASTATINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33007016",
      "display" : "TORVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33006014",
      "display" : "TOTALIP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40234179",
      "display" : "ATORVASTATINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33007030",
      "display" : "TORVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33006038",
      "display" : "TOTALIP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41460054",
      "display" : "ARKAS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40561072",
      "display" : "ATORIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40908028",
      "display" : "ATORVASTATINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "44963078",
      "display" : "ATORVASTATINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45614029",
      "display" : "ATORVASTATINA ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "39996032",
      "display" : "ATORVASTATINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "48731032",
      "display" : "ATORVASTATINA ARISTO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42978078",
      "display" : "ATORVASTATINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41321035",
      "display" : "ATORVASTATINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45140011",
      "display" : "ATORVASTATINA DOCGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "44144018",
      "display" : "ATORVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40909020",
      "display" : "ATORVASTATINA GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40899041",
      "display" : "ATORVASTATINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42181230",
      "display" : "ATORVASTATINA MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45067016",
      "display" : "ATORVASTATINA NISURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40090058",
      "display" : "ATORVASTATINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40400057",
      "display" : "ATORVASTATINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40497087",
      "display" : "ATORVASTATINA SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40678310",
      "display" : "ATORVASTATINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42949026",
      "display" : "ATORVASTATINA TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40234066",
      "display" : "ATORVASTATINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41443197",
      "display" : "ATORVASTATINA VIATRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "43009051",
      "display" : "ATORVASTATINA ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40665022",
      "display" : "KOLESTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42771016",
      "display" : "MELEMIB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41470028",
      "display" : "OMEGASTATIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41101066",
      "display" : "SOPAVI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42772018",
      "display" : "TAXAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40666024",
      "display" : "TORVACOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33007028",
      "display" : "TORVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33006026",
      "display" : "TOTALIP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41199023",
      "display" : "TOVANIRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41325022",
      "display" : "VASTAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41460243",
      "display" : "ARKAS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40561211",
      "display" : "ATORIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40908042",
      "display" : "ATORVASTATINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "44963268",
      "display" : "ATORVASTATINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45614056",
      "display" : "ATORVASTATINA ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "39996069",
      "display" : "ATORVASTATINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "48731095",
      "display" : "ATORVASTATINA ARISTO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42978080",
      "display" : "ATORVASTATINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41321098",
      "display" : "ATORVASTATINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45140023",
      "display" : "ATORVASTATINA DOCGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "44144044",
      "display" : "ATORVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40909044",
      "display" : "ATORVASTATINA GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40899142",
      "display" : "ATORVASTATINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42181279",
      "display" : "ATORVASTATINA MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45067028",
      "display" : "ATORVASTATINA NISURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40090223",
      "display" : "ATORVASTATINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40400145",
      "display" : "ATORVASTATINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40497291",
      "display" : "ATORVASTATINA SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40678385",
      "display" : "ATORVASTATINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42949040",
      "display" : "ATORVASTATINA TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40234217",
      "display" : "ATORVASTATINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41443437",
      "display" : "ATORVASTATINA VIATRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "43009176",
      "display" : "ATORVASTATINA ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40665046",
      "display" : "KOLESTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42771028",
      "display" : "MELEMIB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41470042",
      "display" : "OMEGASTATIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41101332",
      "display" : "SOPAVI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42772020",
      "display" : "TAXAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40666048",
      "display" : "TORVACOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33007042",
      "display" : "TORVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33006040",
      "display" : "TOTALIP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41199062",
      "display" : "TOVANIRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41325046",
      "display" : "VASTAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45140035",
      "display" : "ATORVASTATINA DOCGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KMP"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45067030",
      "display" : "ATORVASTATINA NISURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KMP"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41460445",
      "display" : "ARKAS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40561351",
      "display" : "ATORIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40908067",
      "display" : "ATORVASTATINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "44963458",
      "display" : "ATORVASTATINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45614082",
      "display" : "ATORVASTATINA ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "39996095",
      "display" : "ATORVASTATINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "48731196",
      "display" : "ATORVASTATINA ARISTO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42978054",
      "display" : "ATORVASTATINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41321151",
      "display" : "ATORVASTATINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45140047",
      "display" : "ATORVASTATINA DOCGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "44144071",
      "display" : "ATORVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40909069",
      "display" : "ATORVASTATINA GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40899243",
      "display" : "ATORVASTATINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42181317",
      "display" : "ATORVASTATINA MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45067042",
      "display" : "ATORVASTATINA NISURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40090312",
      "display" : "ATORVASTATINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40400234",
      "display" : "ATORVASTATINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40497505",
      "display" : "ATORVASTATINA SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40678450",
      "display" : "ATORVASTATINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42949053",
      "display" : "ATORVASTATINA TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40234369",
      "display" : "ATORVASTATINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41443678",
      "display" : "ATORVASTATINA VIATRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "43009291",
      "display" : "ATORVASTATINA ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40665061",
      "display" : "KOLESTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42771030",
      "display" : "MELEMIB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41470067",
      "display" : "OMEGASTATIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41101484",
      "display" : "SOPAVI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42772032",
      "display" : "TAXAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40666051",
      "display" : "TORVACOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33007067",
      "display" : "TORVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33006065",
      "display" : "TOTALIP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41199100",
      "display" : "TOVANIRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41325061",
      "display" : "VASTAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45140050",
      "display" : "ATORVASTATINA DOCGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KMQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45067055",
      "display" : "ATORVASTATINA NISURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KMQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40561779",
      "display" : "ATORIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40908079",
      "display" : "ATORVASTATINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "44963647",
      "display" : "ATORVASTATINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45614118",
      "display" : "ATORVASTATINA ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "48731285",
      "display" : "ATORVASTATINA ARISTO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42978066",
      "display" : "ATORVASTATINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41321213",
      "display" : "ATORVASTATINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "45140062",
      "display" : "ATORVASTATINA DOCGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "44144107",
      "display" : "ATORVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "42181356",
      "display" : "ATORVASTATINA MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40090488",
      "display" : "ATORVASTATINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40497719",
      "display" : "ATORVASTATINA SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40678524",
      "display" : "ATORVASTATINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "40234510",
      "display" : "ATORVASTATINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "41443918",
      "display" : "ATORVASTATINA VIATRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "43009416",
      "display" : "ATORVASTATINA ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33007307",
      "display" : "TORVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "33006305",
      "display" : "TOTALIP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FTD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA05"
        }
      ]
    },
    {
      "code" : "30653012",
      "display" : "ATROPINA SOLFATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "47A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A03BA01"
        }
      ]
    },
    {
      "code" : "30783031",
      "display" : "ATROPINA SOLFATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "47A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A03BA01"
        }
      ]
    },
    {
      "code" : "37534017",
      "display" : "AZAFOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "48A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AX01"
        }
      ]
    },
    {
      "code" : "20957039",
      "display" : "AZATIOPRINA ASPEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "48A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AX01"
        }
      ]
    },
    {
      "code" : "36292050",
      "display" : "AZATIOPRINA HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "48A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AX01"
        }
      ]
    },
    {
      "code" : "39510019",
      "display" : "AZACID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38825016",
      "display" : "AZEPTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38557017",
      "display" : "AZIPROME",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39213018",
      "display" : "AZITREDIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38650014",
      "display" : "AZITROERRE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38758013",
      "display" : "AZITROMICINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38756019",
      "display" : "AZITROMICINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39257011",
      "display" : "AZITROMICINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "44589012",
      "display" : "AZITROMICINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39508015",
      "display" : "AZITROMICINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "37495025",
      "display" : "AZITROMICINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "42798049",
      "display" : "AZITROMICINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "40104022",
      "display" : "AZITROMICINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39509017",
      "display" : "AZITROMICINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "27897040",
      "display" : "AZITROMICINA PFIZER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38757011",
      "display" : "AZITROMICINA PHARMEG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "37600057",
      "display" : "AZITROMICINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "37555341",
      "display" : "AZITROMICINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38667022",
      "display" : "AZITROMICINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "42433019",
      "display" : "AZITROX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38761019",
      "display" : "BATIF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39123017",
      "display" : "MACROZIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39214010",
      "display" : "PORTEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39256019",
      "display" : "REZAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38762011",
      "display" : "TETRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39069012",
      "display" : "TROZAMIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "27948064",
      "display" : "TROZOCINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39039019",
      "display" : "ZIMACROL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39306016",
      "display" : "ZINDEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38755017",
      "display" : "ZITROBIOTIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39215013",
      "display" : "ZITROGRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "27860042",
      "display" : "ZITROMAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38733010",
      "display" : "ZITRONOVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "39852052",
      "display" : "AZITROMICINA EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "42798090",
      "display" : "AZITROMICINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "37972054",
      "display" : "AZITROMICINA MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "27897026",
      "display" : "AZITROMICINA PFIZER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "37973056",
      "display" : "AZITROMICINA SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "38929042",
      "display" : "AZITROMICINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "27948052",
      "display" : "TROZOCINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "27860028",
      "display" : "ZITROMAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EGB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA10"
        }
      ]
    },
    {
      "code" : "48166019",
      "display" : "BACLOFENE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M03BX01"
        }
      ]
    },
    {
      "code" : "37930029",
      "display" : "BACLOFENE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M03BX01"
        }
      ]
    },
    {
      "code" : "22999027",
      "display" : "LIORESAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M03BX01"
        }
      ]
    },
    {
      "code" : "29136013",
      "display" : "CLIPPER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50J"
        },
        {
          "code" : "ATC",
          "valueCode" : "A07EA07"
        }
      ]
    },
    {
      "code" : "31115049",
      "display" : "TOPSTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50J"
        },
        {
          "code" : "ATC",
          "valueCode" : "A07EA07"
        }
      ]
    },
    {
      "code" : "43276132",
      "display" : "BECLOMETASONE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50G"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "23103132",
      "display" : "CLENIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50G"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "32798023",
      "display" : "PRONTINAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50G"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "48102026",
      "display" : "BECLOMETASONE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JGE"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "23103171",
      "display" : "CLENIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JGE"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "34179046",
      "display" : "CLENILEXX*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "34179085",
      "display" : "CLENILEXX*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "23378072",
      "display" : "BECOTIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "23103068",
      "display" : "CLENIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "28825014",
      "display" : "CLENIL JET",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "23378019",
      "display" : "BECOTIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "50A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA01"
        }
      ]
    },
    {
      "code" : "37778038",
      "display" : "FORMODUAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "37789031",
      "display" : "FOSTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "37798030",
      "display" : "INUVER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "50213014",
      "display" : "BECLOMETASONE E FORMOTEROLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "49494014",
      "display" : "BECLOMETASONE E FORMOTEROLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "37778014",
      "display" : "FORMODUAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "37789017",
      "display" : "FOSTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "37798016",
      "display" : "INUVER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "37778103",
      "display" : "FORMODUAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JYV"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "37789106",
      "display" : "FOSTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JYV"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK08"
        }
      ]
    },
    {
      "code" : "37507213",
      "display" : "BENAZEPRIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA07"
        }
      ]
    },
    {
      "code" : "37465111",
      "display" : "BENAZEPRIL SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA07"
        }
      ]
    },
    {
      "code" : "27516020",
      "display" : "CIBACEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA07"
        }
      ]
    },
    {
      "code" : "27573029",
      "display" : "ZINADRIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA07"
        }
      ]
    },
    {
      "code" : "37507035",
      "display" : "BENAZEPRIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA07"
        }
      ]
    },
    {
      "code" : "37465034",
      "display" : "BENAZEPRIL SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA07"
        }
      ]
    },
    {
      "code" : "27516032",
      "display" : "CIBACEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA07"
        }
      ]
    },
    {
      "code" : "27573031",
      "display" : "ZINADRIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA07"
        }
      ]
    },
    {
      "code" : "38460174",
      "display" : "BENAZEPRIL IDROCLOROTIAZIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA07"
        }
      ]
    },
    {
      "code" : "37422019",
      "display" : "BENAZEPRIL IDROCLOROTIAZIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA07"
        }
      ]
    },
    {
      "code" : "28037024",
      "display" : "CIBADREX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA07"
        }
      ]
    },
    {
      "code" : "28193011",
      "display" : "ZINADIUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA07"
        }
      ]
    },
    {
      "code" : "19655012",
      "display" : "BENTELAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "42863011",
      "display" : "BETAMETASONE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "42827016",
      "display" : "BETAMETASONE EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "45799018",
      "display" : "BETAMETASONE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "42821013",
      "display" : "ETASON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "19655051",
      "display" : "BENTELAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "42863023",
      "display" : "BETAMETASONE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "42827028",
      "display" : "BETAMETASONE EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "45799020",
      "display" : "BETAMETASONE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "42821025",
      "display" : "ETASON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "41354022",
      "display" : "ALBAFLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "19655152",
      "display" : "BENTELAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "34030015",
      "display" : "BETAMETASONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "39659026",
      "display" : "BETAMETASONE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "39731029",
      "display" : "BETAMETASONE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "39604020",
      "display" : "IBET",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "41354010",
      "display" : "ALBAFLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53D"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "19655315",
      "display" : "BENTELAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53D"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "39659014",
      "display" : "BETAMETASONE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53D"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "39731017",
      "display" : "BETAMETASONE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "53D"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB01"
        }
      ]
    },
    {
      "code" : "38534160",
      "display" : "BICALUTAMIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "39671021",
      "display" : "BICALUTAMIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "37812219",
      "display" : "BICALUTAMIDE RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "40072035",
      "display" : "BICALUTAMIDE SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "38876126",
      "display" : "BICALUTAMIDE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "38352124",
      "display" : "BICALUTAMIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "38959247",
      "display" : "BIKADER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "31113020",
      "display" : "CASODEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "39241082",
      "display" : "MIDELUT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "39243011",
      "display" : "BICALUTAMIDE AHCL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "37791062",
      "display" : "BICALUTAMIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "38534044",
      "display" : "BICALUTAMIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "38399010",
      "display" : "BICALUTAMIDE EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "37751068",
      "display" : "BICALUTAMIDE IBIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "37812068",
      "display" : "BICALUTAMIDE RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "40072011",
      "display" : "BICALUTAMIDE SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "38876025",
      "display" : "BICALUTAMIDE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "38352023",
      "display" : "BICALUTAMIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "38959060",
      "display" : "BIKADER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "31113018",
      "display" : "CASODEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "39241029",
      "display" : "MIDELUT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BB03"
        }
      ]
    },
    {
      "code" : "44345015",
      "display" : "BIMADOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "45448038",
      "display" : "BIMATOPROST MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "44572028",
      "display" : "BITOPRIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "44570024",
      "display" : "BRINUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "44573020",
      "display" : "BROSTIMAB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "35447022",
      "display" : "LUMIGAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "49725017",
      "display" : "VISUPLAIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I6A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "44573018",
      "display" : "BIALVIZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNU"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "44572016",
      "display" : "BIMANEXT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNU"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "44345039",
      "display" : "BIMADOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I6C"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "35447059",
      "display" : "LUMIGAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I6C"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EE03"
        }
      ]
    },
    {
      "code" : "45144033",
      "display" : "BIMATOPROST E TIMOLOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "49043019",
      "display" : "BIMATOPROST E TIMOLOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "45146014",
      "display" : "BIMATOPROST TIMOLOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "45147030",
      "display" : "BIMATOPROST TIMOLOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "46336018",
      "display" : "BIMATOPROST TIMOLOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "45145012",
      "display" : "BISANTIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "37140011",
      "display" : "GANFORT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "49576010",
      "display" : "VISUBLEND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "38810040",
      "display" : "BISOPROLOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42962011",
      "display" : "BISOPROLOLO DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "39870035",
      "display" : "BISOPROLOLO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40486019",
      "display" : "BISOPROLOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44644019",
      "display" : "BISOPROLOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "38811042",
      "display" : "BISOPROLOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40147023",
      "display" : "BISOPROLOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "48314025",
      "display" : "BISOPROLOLO ZENTIVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43830025",
      "display" : "CARDICOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34954014",
      "display" : "CARDICOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43654021",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34953024",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "39829039",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42875029",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34952022",
      "display" : "SEQUACOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40444349",
      "display" : "BISOPROLOLO AHCL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "38810533",
      "display" : "BISOPROLOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "41498421",
      "display" : "BISOPROLOLO AUROBINDO PHARMA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42962050",
      "display" : "BISOPROLOLO DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "37130174",
      "display" : "BISOPROLOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42442234",
      "display" : "BISOPROLOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40486211",
      "display" : "BISOPROLOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44640098",
      "display" : "BISOPROLOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "38811535",
      "display" : "BISOPROLOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40147340",
      "display" : "BISOPROLOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "37690260",
      "display" : "BISOPROLOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "48314660",
      "display" : "BISOPROLOLO ZENTIVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34954420",
      "display" : "CARDICOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "26573016",
      "display" : "CONCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34953416",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34952426",
      "display" : "SEQUACOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40444022",
      "display" : "BISOPROLOLO ACCORD HEALTHCARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "38810141",
      "display" : "BISOPROLOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "41498104",
      "display" : "BISOPROLOLO AUROBINDO PHARMA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42962023",
      "display" : "BISOPROLOLO DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "39870124",
      "display" : "BISOPROLOLO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42442032",
      "display" : "BISOPROLOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40486058",
      "display" : "BISOPROLOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44640011",
      "display" : "BISOPROLOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "38811143",
      "display" : "BISOPROLOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40147100",
      "display" : "BISOPROLOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "41462019",
      "display" : "BISOPROLOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "48314203",
      "display" : "BISOPROLOLO ZENTIVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44799017",
      "display" : "CARDICOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43830013",
      "display" : "CARDICOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34954103",
      "display" : "CARDICOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43654045",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "50203013",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44139020",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42667016",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "39829015",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43818018",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43706011",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44048015",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43828019",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43654019",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43651025",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34953099",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42875017",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34952109",
      "display" : "SEQUACOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42962035",
      "display" : "BISOPROLOLO DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "39870213",
      "display" : "BISOPROLOLO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40486096",
      "display" : "BISOPROLOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44644033",
      "display" : "BISOPROLOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "38811232",
      "display" : "BISOPROLOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40147187",
      "display" : "BISOPROLOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "48314304",
      "display" : "BISOPROLOLO ZENTIVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34954180",
      "display" : "CARDICOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34953176",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34952186",
      "display" : "SEQUACOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40444186",
      "display" : "BISOPROLOLO AHCL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "38810331",
      "display" : "BISOPROLOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "41498268",
      "display" : "BISOPROLOLO AUROBINDO PHARMA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42962047",
      "display" : "BISOPROLOLO DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "37130046",
      "display" : "BISOPROLOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42442133",
      "display" : "BISOPROLOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40486134",
      "display" : "BISOPROLOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44640035",
      "display" : "BISOPROLOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "38811333",
      "display" : "BISOPROLOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40147264",
      "display" : "BISOPROLOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "48314429",
      "display" : "BISOPROLOLO ZENTIVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34954267",
      "display" : "CARDICOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "39829054",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42875031",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43654033",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "42667028",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43818020",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44139018",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "43651013",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34953253",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34952263",
      "display" : "SEQUACOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "44644058",
      "display" : "BISOPROLOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "38811434",
      "display" : "BISOPROLOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "48314544",
      "display" : "BISOPROLOLO ZENTIVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34954343",
      "display" : "CARDICOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34953339",
      "display" : "CONGESCOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "34952349",
      "display" : "SEQUACOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CYF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AB07"
        }
      ]
    },
    {
      "code" : "40426037",
      "display" : "BISOPROLOLO E IDROCLOROTIAZIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "35583261",
      "display" : "LODOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "35583119",
      "display" : "LODOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "48000018",
      "display" : "BISOPROLOLO E IDROCLOROTIAZIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "40426013",
      "display" : "BISOPROLOLO E IDROCLOROTIAZIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "35583018",
      "display" : "LODOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "35583160",
      "display" : "LODOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "48000032",
      "display" : "BISOPROLOLO E IDROCLOROTIAZIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "40426025",
      "display" : "BISOPROLOLO E IDROCLOROTIAZIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "35583069",
      "display" : "LODOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "35583210",
      "display" : "LODOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "I9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07BB07"
        }
      ]
    },
    {
      "code" : "44094023",
      "display" : "BOSENTAN ABDI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "43079045",
      "display" : "BOSENTAN ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "44876187",
      "display" : "BOSENTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "42590125",
      "display" : "BOSENTAN MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "44353050",
      "display" : "BOSENTAN SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "43919063",
      "display" : "BOSENTAN SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "44204093",
      "display" : "BOSENTAN TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "35609041",
      "display" : "TRACLEER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "44094011",
      "display" : "BOSENTAN ABDI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "43079021",
      "display" : "BOSENTAN ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "44876050",
      "display" : "BOSENTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "42590051",
      "display" : "BOSENTAN MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "43919024",
      "display" : "BOSENTAN SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "44204042",
      "display" : "BOSENTAN TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "35609027",
      "display" : "TRACLEER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02KX01"
        }
      ]
    },
    {
      "code" : "45769015",
      "display" : "ALPHAGAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "45633017",
      "display" : "ALPHAGAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "45282011",
      "display" : "ALPHAGAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "33490020",
      "display" : "ALPHAGAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "44819011",
      "display" : "ALPHAGAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "38714010",
      "display" : "BRIMOFTAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "38644011",
      "display" : "BRIMONIDINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "38634010",
      "display" : "BRIMONIDINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "39098013",
      "display" : "BRIMONIDINA OMNIVISION",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "40101014",
      "display" : "GLAUBRIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ECA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EA05"
        }
      ]
    },
    {
      "code" : "44638017",
      "display" : "BRIMOCOMB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "44245013",
      "display" : "BRIMONIDINA E TIMOLOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "44246015",
      "display" : "BRIMONIDINA E TIMOLOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "37083019",
      "display" : "COMBIGAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "34770014",
      "display" : "AZOPT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC04"
        }
      ]
    },
    {
      "code" : "42249019",
      "display" : "BRINZAFLUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC04"
        }
      ]
    },
    {
      "code" : "42406013",
      "display" : "BRINZOLAMIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC04"
        }
      ]
    },
    {
      "code" : "43204015",
      "display" : "BRINZOLAMIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC04"
        }
      ]
    },
    {
      "code" : "42648016",
      "display" : "BRINZOLAMIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC04"
        }
      ]
    },
    {
      "code" : "38837011",
      "display" : "AZARGA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC54"
        }
      ]
    },
    {
      "code" : "48087011",
      "display" : "BRINTIDOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC54"
        }
      ]
    },
    {
      "code" : "48089015",
      "display" : "BRINZOLAMIDE E TIMOLOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC54"
        }
      ]
    },
    {
      "code" : "46179014",
      "display" : "BRINZOLAMIDE E TIMOLOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC54"
        }
      ]
    },
    {
      "code" : "48153011",
      "display" : "BRINZOLAMIDE E TIMOLOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC54"
        }
      ]
    },
    {
      "code" : "35720010",
      "display" : "BRIVIRAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB15"
        }
      ]
    },
    {
      "code" : "48048019",
      "display" : "BRIVUDINA ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB15"
        }
      ]
    },
    {
      "code" : "48969012",
      "display" : "BRIVUDINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB15"
        }
      ]
    },
    {
      "code" : "35722014",
      "display" : "ZECOVIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB15"
        }
      ]
    },
    {
      "code" : "29068018",
      "display" : "BROMOCRIPTINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "17A"
        },
        {
          "code" : "ATC",
          "valueCode" : "G02CB01"
        }
      ]
    },
    {
      "code" : "23781014",
      "display" : "PARLODEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "17A"
        },
        {
          "code" : "ATC",
          "valueCode" : "G02CB01"
        }
      ]
    },
    {
      "code" : "36004012",
      "display" : "BUDESONIDE VIATRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "27621022",
      "display" : "PULMAXAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "33736063",
      "display" : "AIRCORT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "36923011",
      "display" : "BODINET",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "36924013",
      "display" : "BODIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "37018013",
      "display" : "BUDESONIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "35586015",
      "display" : "BUDESONIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "36922019",
      "display" : "BUDEXAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "36921017",
      "display" : "BUDINEB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "44734010",
      "display" : "ELTAIRNEB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "27621059",
      "display" : "PULMAXAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "33736075",
      "display" : "AIRCORT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "36923023",
      "display" : "BODINET",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "36924025",
      "display" : "BODIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "37018049",
      "display" : "BUDESONIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "35586027",
      "display" : "BUDESONIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "36922021",
      "display" : "BUDEXAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "36921029",
      "display" : "BUDINEB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "44734022",
      "display" : "ELTAIRNEB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "27621061",
      "display" : "PULMAXAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "50057037",
      "display" : "BUDESONIDE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4M"
        },
        {
          "code" : "ATC",
          "valueCode" : "A07EA06"
        }
      ]
    },
    {
      "code" : "34734018",
      "display" : "ENTOCIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4M"
        },
        {
          "code" : "ATC",
          "valueCode" : "A07EA06"
        }
      ]
    },
    {
      "code" : "36507046",
      "display" : "INTESTICORT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4M"
        },
        {
          "code" : "ATC",
          "valueCode" : "A07EA06"
        }
      ]
    },
    {
      "code" : "36004149",
      "display" : "BUDESONIDE VIATRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "27621034",
      "display" : "PULMAXAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C4D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA02"
        }
      ]
    },
    {
      "code" : "45958042",
      "display" : "AIRBUFO FORSPIRO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MBU"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK07"
        }
      ]
    },
    {
      "code" : "43369077",
      "display" : "FOBULER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MBU"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AK07"
        }
      ]
    },
    {
      "code" : "43426093",
      "display" : "BUSETTE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KBR"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AE01"
        }
      ]
    },
    {
      "code" : "49142021",
      "display" : "SEPTRAPAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KBR"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AE01"
        }
      ]
    },
    {
      "code" : "43426232",
      "display" : "BUSETTE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KCO"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AE01"
        }
      ]
    },
    {
      "code" : "49142033",
      "display" : "SEPTRAPAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KCO"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AE01"
        }
      ]
    },
    {
      "code" : "43426028",
      "display" : "BUSETTE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KBS"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AE01"
        }
      ]
    },
    {
      "code" : "49142019",
      "display" : "SEPTRAPAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KBS"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AE01"
        }
      ]
    },
    {
      "code" : "48268015",
      "display" : "BUPROPIONE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "P1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX12"
        }
      ]
    },
    {
      "code" : "43095013",
      "display" : "BUPROPIONE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "P1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX12"
        }
      ]
    },
    {
      "code" : "48234013",
      "display" : "BUPROPIONE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "P1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX12"
        }
      ]
    },
    {
      "code" : "37697024",
      "display" : "ELONTRIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "P1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX12"
        }
      ]
    },
    {
      "code" : "49440011",
      "display" : "WELLBUTRIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "P1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX12"
        }
      ]
    },
    {
      "code" : "37685029",
      "display" : "WELLBUTRIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "P1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX12"
        }
      ]
    },
    {
      "code" : "37576016",
      "display" : "CABERGOLINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CZB"
        },
        {
          "code" : "ATC",
          "valueCode" : "G02CB03"
        }
      ]
    },
    {
      "code" : "28988018",
      "display" : "DOSTINEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CZB"
        },
        {
          "code" : "ATC",
          "valueCode" : "G02CB03"
        }
      ]
    },
    {
      "code" : "33359035",
      "display" : "ACTUALENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G02CB03"
        }
      ]
    },
    {
      "code" : "37576028",
      "display" : "CABERGOLINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G02CB03"
        }
      ]
    },
    {
      "code" : "45770017",
      "display" : "DOSTINEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G02CB03"
        }
      ]
    },
    {
      "code" : "28988032",
      "display" : "DOSTINEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G02CB03"
        }
      ]
    },
    {
      "code" : "24139014",
      "display" : "DIDROGYL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ILA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC06"
        }
      ]
    },
    {
      "code" : "48177012",
      "display" : "VIDENKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ILA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC06"
        }
      ]
    },
    {
      "code" : "27476023",
      "display" : "CACIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "03A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AA04"
        }
      ]
    },
    {
      "code" : "33871017",
      "display" : "CALCIO CARBONATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "03A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AA04"
        }
      ]
    },
    {
      "code" : "33373010",
      "display" : "CALCIODIE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "03A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AA04"
        }
      ]
    },
    {
      "code" : "5259041",
      "display" : "CALCIUM SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "03A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AA20"
        }
      ]
    },
    {
      "code" : "33486010",
      "display" : "IDRACAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "03A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AA04"
        }
      ]
    },
    {
      "code" : "32033019",
      "display" : "CACIT VITAMINA D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34801011",
      "display" : "CADTRE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34871018",
      "display" : "CALCIO CARBONATO E VITAMINA D3 AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34799015",
      "display" : "CALCIO CARBONATO E VITAMINA D3 DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34794014",
      "display" : "CALCIO CARBONATO VITAMINA D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "35007018",
      "display" : "CALCIO CARBONATO+VITAMINA D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34800019",
      "display" : "CALCIO CARBONATO+VITAMINA D3 PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34642013",
      "display" : "CALCIUM D3 SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "32840023",
      "display" : "EUROCAL D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34213049",
      "display" : "IDEOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "33861028",
      "display" : "OROTRE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "35027034",
      "display" : "METOCAL VITAMINA D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34899017",
      "display" : "NATECAL D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34899043",
      "display" : "NATECAL D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "34932018",
      "display" : "TONACAL D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQD"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "33711019",
      "display" : "CALPLUS D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "33700016",
      "display" : "OSTEOFOS D3",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AQZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A12AX"
        }
      ]
    },
    {
      "code" : "37726015",
      "display" : "CALCIPOTRIOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX02"
        }
      ]
    },
    {
      "code" : "28253019",
      "display" : "DAIVONEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX02"
        }
      ]
    },
    {
      "code" : "28253021",
      "display" : "DAIVONEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX02"
        }
      ]
    },
    {
      "code" : "49447016",
      "display" : "ARIBEC*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "47840020",
      "display" : "CALBETA*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "35675141",
      "display" : "DOVOBET*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "46861023",
      "display" : "PSOTRIOL*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "38767024",
      "display" : "XAMIOL*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "47576020",
      "display" : "ZORIPOT*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "49447028",
      "display" : "ARIBEC*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQB"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "47840057",
      "display" : "CALBETA*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQB"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "46861050",
      "display" : "PSOTRIOL*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQB"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "47576032",
      "display" : "ZORIPOT*",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "IQB"
        },
        {
          "code" : "ATC",
          "valueCode" : "D05AX52"
        }
      ]
    },
    {
      "code" : "35237015",
      "display" : "CALCITRIOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "35238017",
      "display" : "CALCITRIOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "35238031",
      "display" : "CALCITRIOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "35102019",
      "display" : "CALCITRIOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "35297199",
      "display" : "CALCITRIOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "24280012",
      "display" : "ROCALTROL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "35237027",
      "display" : "CALCITRIOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "35238029",
      "display" : "CALCITRIOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "35238043",
      "display" : "CALCITRIOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "35102021",
      "display" : "CALCITRIOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "35297389",
      "display" : "CALCITRIOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "24280024",
      "display" : "ROCALTROL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC04"
        }
      ]
    },
    {
      "code" : "33451269",
      "display" : "BLOPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "43896012",
      "display" : "BLOPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "44804019",
      "display" : "BLOPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "39318023",
      "display" : "BLOPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "39742097",
      "display" : "CANDESARTAN ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "42841027",
      "display" : "CANDESARTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41341191",
      "display" : "CANDESARTAN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41376310",
      "display" : "CANDESARTAN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41993282",
      "display" : "CANDESARTAN HCS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "40913131",
      "display" : "CANDESARTAN MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "42739185",
      "display" : "CANDESARTAN PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41138304",
      "display" : "CANDESARTAN SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "40161212",
      "display" : "CANDESARTAN TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41259197",
      "display" : "CANDESARTAN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41459037",
      "display" : "FLORTITENS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "33577305",
      "display" : "RATACAND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "44804021",
      "display" : "BLOPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "33451360",
      "display" : "BLOPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "39742123",
      "display" : "CANDESARTAN ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "42841039",
      "display" : "CANDESARTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41341278",
      "display" : "CANDESARTAN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41376486",
      "display" : "CANDESARTAN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41993407",
      "display" : "CANDESARTAN HCS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "40913182",
      "display" : "CANDESARTAN MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "42739312",
      "display" : "CANDESARTAN PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41138431",
      "display" : "CANDESARTAN SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "40161376",
      "display" : "CANDESARTAN TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41259274",
      "display" : "CANDESARTAN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41459049",
      "display" : "FLORTITENS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "33577469",
      "display" : "RATACAND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "44804033",
      "display" : "BLOPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "33451168",
      "display" : "BLOPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "42841015",
      "display" : "CANDESARTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41341114",
      "display" : "CANDESARTAN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41376144",
      "display" : "CANDESARTAN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41993167",
      "display" : "CANDESARTAN HCS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "40913081",
      "display" : "CANDESARTAN MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "42739058",
      "display" : "CANDESARTAN PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41138177",
      "display" : "CANDESARTAN SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "40161059",
      "display" : "CANDESARTAN TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "41259110",
      "display" : "CANDESARTAN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "33577180",
      "display" : "RATACAND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA06"
        }
      ]
    },
    {
      "code" : "45214018",
      "display" : "CANDETENS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNT"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB07"
        }
      ]
    },
    {
      "code" : "45122013",
      "display" : "LODICAND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNT"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DB07"
        }
      ]
    },
    {
      "code" : "34187144",
      "display" : "BLOPRESID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42490033",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42971022",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "40508119",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41379126",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41126210",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE HCS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "40753028",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41145309",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "40868198",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41448111",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42190037",
      "display" : "FORUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41474040",
      "display" : "IDROTENS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "34186167",
      "display" : "RATACAND PLUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "34187233",
      "display" : "BLOPRESID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42490060",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42971059",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "40508196",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42264325",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41126398",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE HCS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "43485085",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41145525",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "40868349",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41786029",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "34187322",
      "display" : "BLOPRESID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42490096",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42971085",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "40508311",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42264477",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41126576",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE HCS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "43485251",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41145653",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "40868491",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "41786070",
      "display" : "CANDESARTAN E IDROCLOROTIAZIDE ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FXC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA06"
        }
      ]
    },
    {
      "code" : "42640274",
      "display" : "CAPECITABINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRI"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01BC06"
        }
      ]
    },
    {
      "code" : "42501357",
      "display" : "CAPECITABINA MEDAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRI"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01BC06"
        }
      ]
    },
    {
      "code" : "41927043",
      "display" : "CAPECITABINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRI"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01BC06"
        }
      ]
    },
    {
      "code" : "41928045",
      "display" : "CAPECITABINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRI"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01BC06"
        }
      ]
    },
    {
      "code" : "35219029",
      "display" : "XELODA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRI"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01BC06"
        }
      ]
    },
    {
      "code" : "42640209",
      "display" : "CAPECITABINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01BC06"
        }
      ]
    },
    {
      "code" : "42501041",
      "display" : "CAPECITABINA MEDAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01BC06"
        }
      ]
    },
    {
      "code" : "41927029",
      "display" : "CAPECITABINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01BC06"
        }
      ]
    },
    {
      "code" : "35219017",
      "display" : "XELODA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01BC06"
        }
      ]
    },
    {
      "code" : "35036161",
      "display" : "CAPTOPRIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "57B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA01"
        }
      ]
    },
    {
      "code" : "35317561",
      "display" : "CAPTOPRIL MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "57B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA01"
        }
      ]
    },
    {
      "code" : "35036159",
      "display" : "CAPTOPRIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "57A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA01"
        }
      ]
    },
    {
      "code" : "35317559",
      "display" : "CAPTOPRIL MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "57A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA01"
        }
      ]
    },
    {
      "code" : "25767017",
      "display" : "ACEDIUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA01"
        }
      ]
    },
    {
      "code" : "36770016",
      "display" : "CAPTOPRIL E IDROCLOROTIAZIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA01"
        }
      ]
    },
    {
      "code" : "47982018",
      "display" : "CARBAMAZEPINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "58B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF01"
        }
      ]
    },
    {
      "code" : "20602049",
      "display" : "TEGRETOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "58B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF01"
        }
      ]
    },
    {
      "code" : "33878024",
      "display" : "CARBAMAZEPINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "58D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF01"
        }
      ]
    },
    {
      "code" : "20602025",
      "display" : "TEGRETOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "58D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF01"
        }
      ]
    },
    {
      "code" : "47982069",
      "display" : "CARBAMAZEPINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "58E"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF01"
        }
      ]
    },
    {
      "code" : "20602052",
      "display" : "TEGRETOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "58E"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF01"
        }
      ]
    },
    {
      "code" : "33878012",
      "display" : "CARBAMAZEPINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "58C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF01"
        }
      ]
    },
    {
      "code" : "20602013",
      "display" : "TEGRETOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "58C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF01"
        }
      ]
    },
    {
      "code" : "36339012",
      "display" : "CARAVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36335014",
      "display" : "CARVEDILOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36471011",
      "display" : "CARVEDILOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36548016",
      "display" : "CARVEDILOLO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "42234017",
      "display" : "CARVEDILOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36462012",
      "display" : "CARVEDILOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36355055",
      "display" : "CARVEDILOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36457202",
      "display" : "CARVEDILOLO HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36453278",
      "display" : "CARVEDILOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36407017",
      "display" : "CARVEDILOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36779080",
      "display" : "CARVEDILOLO RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36454027",
      "display" : "CARVEDILOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36338010",
      "display" : "CARVEDILOLO SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36400012",
      "display" : "CARVEDILOLO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "37144033",
      "display" : "CARVEDILOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36470019",
      "display" : "COLVER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36512010",
      "display" : "CURCIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "27604040",
      "display" : "DILATREND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36522011",
      "display" : "OMERIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36339024",
      "display" : "CARAVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36471023",
      "display" : "CARVEDILOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36548028",
      "display" : "CARVEDILOLO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "42234068",
      "display" : "CARVEDILOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36462024",
      "display" : "CARVEDILOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36355283",
      "display" : "CARVEDILOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36457556",
      "display" : "CARVEDILOLO HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36453607",
      "display" : "CARVEDILOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36407029",
      "display" : "CARVEDILOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36779256",
      "display" : "CARVEDILOLO RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36454320",
      "display" : "CARVEDILOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36400024",
      "display" : "CARVEDILOLO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "37144209",
      "display" : "CARVEDILOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "27606019",
      "display" : "CARVIPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36470021",
      "display" : "COLVER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36512022",
      "display" : "CURCIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "39312018",
      "display" : "DILATREND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "27604014",
      "display" : "DILATREND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "39328024",
      "display" : "DILATREND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36522023",
      "display" : "OMERIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "36401026",
      "display" : "TRAKOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C07AG02"
        }
      ]
    },
    {
      "code" : "34619015",
      "display" : "BACTIGRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34636023",
      "display" : "CEFACLOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34287045",
      "display" : "CEFACLOR DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "33083027",
      "display" : "KLIACEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "33114036",
      "display" : "MACOVAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "24227050",
      "display" : "PANACEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34504023",
      "display" : "PERFORMER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34587028",
      "display" : "VALECLOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34619039",
      "display" : "BACTIGRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34610042",
      "display" : "CEFACLOR EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "28678035",
      "display" : "CLORAZER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "33114048",
      "display" : "MACOVAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34514036",
      "display" : "NECLORAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "24227098",
      "display" : "PANACEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34504035",
      "display" : "PERFORMER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34652014",
      "display" : "SELVICLOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34619027",
      "display" : "BACTIGRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "34636011",
      "display" : "CEFACLOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "24227023",
      "display" : "PANACEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "21C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC04"
        }
      ]
    },
    {
      "code" : "23916051",
      "display" : "CEFAZIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "20A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DB04"
        }
      ]
    },
    {
      "code" : "33575010",
      "display" : "CEFAZOLINA GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "20A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DB04"
        }
      ]
    },
    {
      "code" : "24127019",
      "display" : "CEFAZOLINA PHARMACARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "20A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DB04"
        }
      ]
    },
    {
      "code" : "23853031",
      "display" : "CEFAZOLINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "20A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DB04"
        }
      ]
    },
    {
      "code" : "33123011",
      "display" : "NEFAZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "20A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DB04"
        }
      ]
    },
    {
      "code" : "47003025",
      "display" : "CEFIXIMA AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "41391083",
      "display" : "CEFIXIMA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "27134105",
      "display" : "CEFIXORAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "28855056",
      "display" : "SUPRACEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "27152091",
      "display" : "UNIXIME",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "44331015",
      "display" : "CEFIXIMA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "42117010",
      "display" : "CEFIXIMA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "41391018",
      "display" : "CEFIXIMA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "27134030",
      "display" : "CEFIXORAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "27134081",
      "display" : "CEFIXORAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "39308010",
      "display" : "STADIUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "28855068",
      "display" : "SUPRACEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "27152038",
      "display" : "UNIXIME",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "27152077",
      "display" : "UNIXIME",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD08"
        }
      ]
    },
    {
      "code" : "35207024",
      "display" : "BATIXIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35207036",
      "display" : "BATIXIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35375029",
      "display" : "CEFOTAXIMA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35441017",
      "display" : "CEFOTAXIMA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35374038",
      "display" : "CEFOTAXIMA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35374040",
      "display" : "CEFOTAXIMA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35118013",
      "display" : "CEFOTAXIME IBI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35118025",
      "display" : "CEFOTAXIME IBI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "34994032",
      "display" : "CEFOTAXIME MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "34994044",
      "display" : "CEFOTAXIME MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35192020",
      "display" : "SPECTROCEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35068028",
      "display" : "TAXIME",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "35068030",
      "display" : "TAXIME",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "24259032",
      "display" : "ZARIVIZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "24259044",
      "display" : "ZARIVIZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "34426015",
      "display" : "ZIMANEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ASA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD01"
        }
      ]
    },
    {
      "code" : "28463038",
      "display" : "CEFODOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "41859164",
      "display" : "CEFPODOXIMA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "39962168",
      "display" : "CEFPODOXIMA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "27970033",
      "display" : "ORELOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "27969031",
      "display" : "OTREON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "40010035",
      "display" : "PROXEDOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "28463014",
      "display" : "CEFODOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "41859190",
      "display" : "CEFPODOXIMA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "39962194",
      "display" : "CEFPODOXIMA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "27970019",
      "display" : "ORELOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "27969017",
      "display" : "OTREON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "40010011",
      "display" : "PROXEDOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "28463040",
      "display" : "CEFODOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "41859087",
      "display" : "CEFPODOXIMA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "39962117",
      "display" : "CEFPODOXIMA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "27970045",
      "display" : "ORELOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "27969043",
      "display" : "OTREON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "40010023",
      "display" : "PROXEDOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FFC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD13"
        }
      ]
    },
    {
      "code" : "36579035",
      "display" : "CEFTAZIDIMA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36459016",
      "display" : "CEFTAZIDIMA ASTRO-PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36571038",
      "display" : "CEFTAZIDIMA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36566038",
      "display" : "CEFTAZIDIMA EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36591030",
      "display" : "CEFTAZIDIMA KABI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36604027",
      "display" : "CEFTAZIDIMA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36494021",
      "display" : "CEFTAZIDIMA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36209017",
      "display" : "CEFTAZIDIMA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36590038",
      "display" : "DELTAZIME",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36490023",
      "display" : "ETAZIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36568032",
      "display" : "FRIBAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "25212034",
      "display" : "GLAZIDIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36545010",
      "display" : "LIOTIXIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "25859036",
      "display" : "STARCEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36495024",
      "display" : "TAZIDIF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "36501029",
      "display" : "TOTTIZIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "25212022",
      "display" : "GLAZIDIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "25859024",
      "display" : "STARCEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C7B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD02"
        }
      ]
    },
    {
      "code" : "35958026",
      "display" : "BIXON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36154019",
      "display" : "CARITEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36101020",
      "display" : "CEFRAG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35921028",
      "display" : "CEFTAGES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35924048",
      "display" : "CEFTRIAXONE ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "39216027",
      "display" : "CEFTRIAXONE ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36065035",
      "display" : "CEFTRIAXONE ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36021032",
      "display" : "CEFTRIAXONE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36095014",
      "display" : "CEFTRIAXONE ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36138028",
      "display" : "CEFTRIAXONE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35814021",
      "display" : "CEFTRIAXONE BIOPHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35800034",
      "display" : "CEFTRIAXONE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35869039",
      "display" : "CEFTRIAXONE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36516021",
      "display" : "CEFTRIAXONE GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35868037",
      "display" : "CEFTRIAXONE HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35878038",
      "display" : "CEFTRIAXONE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35964030",
      "display" : "CEFTRIAXONE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35881022",
      "display" : "CEFTRIAXONE PHARMACARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35802038",
      "display" : "CEFTRIAXONE RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35902030",
      "display" : "CEFTRIAXONE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35905013",
      "display" : "CEFTRIAXONE SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "37334051",
      "display" : "CEFTRIAXONE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35887037",
      "display" : "CEFTRIAXONE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36642066",
      "display" : "CLAXON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35816040",
      "display" : "DAVIXON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36093033",
      "display" : "DAYTRIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36314021",
      "display" : "DIAXONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36102010",
      "display" : "EFTRY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35801036",
      "display" : "ERAXITRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35867035",
      "display" : "FIDATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35866033",
      "display" : "FRINEG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35965033",
      "display" : "KOCEFAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35925027",
      "display" : "NILSON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36015030",
      "display" : "PANATRIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35952023",
      "display" : "PANTOXON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "36212037",
      "display" : "POKECEF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35927033",
      "display" : "RAGEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "25202058",
      "display" : "ROCEFIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35922032",
      "display" : "SETRIOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35815024",
      "display" : "SIRTAP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35824010",
      "display" : "VALEXIME",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35800010",
      "display" : "CEFTRIAXONE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35878026",
      "display" : "CEFTRIAXONE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35867023",
      "display" : "FIDATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "35952011",
      "display" : "PANTOXON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C0B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DD04"
        }
      ]
    },
    {
      "code" : "23576046",
      "display" : "CUROXIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "24105013",
      "display" : "ITOREX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "48025035",
      "display" : "CEFUROXIMA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "37732082",
      "display" : "CEFUROXIMA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "27002029",
      "display" : "ORAXIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "26915025",
      "display" : "ZINNAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "26917031",
      "display" : "CEFUROXIMA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "48025062",
      "display" : "CEFUROXIMA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "37732308",
      "display" : "CEFUROXIMA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "27002031",
      "display" : "ORAXIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "27020039",
      "display" : "TILEXIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "26915037",
      "display" : "ZINNAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "63D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01DC02"
        }
      ]
    },
    {
      "code" : "42559031",
      "display" : "CELARTROX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "34624460",
      "display" : "CELEBREX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "43500014",
      "display" : "CELECOXIB ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "44073017",
      "display" : "CELECOXIB AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "41938174",
      "display" : "CELECOXIB DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "42332181",
      "display" : "CELECOXIB EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "42533125",
      "display" : "CELECOXIB MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "42328082",
      "display" : "CELECOXIB SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "41955028",
      "display" : "CELECOXIB TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "40512220",
      "display" : "CELECOXIB TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "40788198",
      "display" : "CELECOXIB VIATRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "42258095",
      "display" : "CELECOXIB ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "43133026",
      "display" : "COXIBEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH01"
        }
      ]
    },
    {
      "code" : "37639022",
      "display" : "AXERAMIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37736028",
      "display" : "CERCHIO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37819036",
      "display" : "CETERIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37911029",
      "display" : "CETIRIZINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37635024",
      "display" : "CETIRIZINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38054021",
      "display" : "CETIRIZINA AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37654023",
      "display" : "CETIRIZINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37655026",
      "display" : "CETIRIZINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38619019",
      "display" : "CETIRIZINA MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37827021",
      "display" : "CETIRIZINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37318021",
      "display" : "CETIRIZINA TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "27329022",
      "display" : "FORMISTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38628018",
      "display" : "GENERIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38628020",
      "display" : "GENERIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37638020",
      "display" : "PRIZITEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38629010",
      "display" : "RITECAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38629022",
      "display" : "RITECAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37895036",
      "display" : "SOTRIZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37339025",
      "display" : "STAMIDIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38035034",
      "display" : "SUSPIRIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43824022",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "50206010",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "42955031",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43824034",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38777013",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "41894015",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43629029",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38386013",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43476011",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43707013",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "42955017",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "39316029",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "26894028",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37639010",
      "display" : "AXERAMIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37736016",
      "display" : "CERCHIO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37819024",
      "display" : "CETERIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37911017",
      "display" : "CETIRIZINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37635012",
      "display" : "CETIRIZINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "36910014",
      "display" : "CETIRIZINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43111018",
      "display" : "CETIRIZINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37654011",
      "display" : "CETIRIZINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37655014",
      "display" : "CETIRIZINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37713082",
      "display" : "CETIRIZINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37827019",
      "display" : "CETIRIZINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37629045",
      "display" : "CETIRIZINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37653019",
      "display" : "CETIRIZINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "42741049",
      "display" : "CETIRIZINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37300047",
      "display" : "CETIRIZINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "27329010",
      "display" : "FORMISTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37638018",
      "display" : "PRIZITEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37895024",
      "display" : "SOTRIZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37339013",
      "display" : "STAMIDIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38035022",
      "display" : "SUSPIRIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "37637016",
      "display" : "TEZASTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38386049",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38386037",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "49842014",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43824046",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43824059",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38386052",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43629031",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43629043",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38777049",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "42955056",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "41894027",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38386025",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "38777025",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43098019",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43015015",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43629017",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43707025",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "42955029",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "43824010",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "39316031",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "26894016",
      "display" : "ZIRTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AE07"
        }
      ]
    },
    {
      "code" : "42787299",
      "display" : "CIQORIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AD01"
        }
      ]
    },
    {
      "code" : "29453038",
      "display" : "SANDIMMUN NEORAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AD01"
        }
      ]
    },
    {
      "code" : "42787251",
      "display" : "CIQORIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J5C"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AD01"
        }
      ]
    },
    {
      "code" : "29453053",
      "display" : "SANDIMMUN NEORAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J5C"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AD01"
        }
      ]
    },
    {
      "code" : "42787263",
      "display" : "CIQORIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J5D"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AD01"
        }
      ]
    },
    {
      "code" : "29453014",
      "display" : "SANDIMMUN NEORAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J5D"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AD01"
        }
      ]
    },
    {
      "code" : "42787275",
      "display" : "CIQORIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J5E"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AD01"
        }
      ]
    },
    {
      "code" : "29453026",
      "display" : "SANDIMMUN NEORAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J5E"
        },
        {
          "code" : "ATC",
          "valueCode" : "L04AD01"
        }
      ]
    },
    {
      "code" : "45169024",
      "display" : "CINACALCET ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "47326018",
      "display" : "CINACALCET ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46947026",
      "display" : "CINACALCET AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46894010",
      "display" : "CINACALCET DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "47567021",
      "display" : "CINACALCET DR REDDY'S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46284016",
      "display" : "CINACALCET EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "44554018",
      "display" : "CINACALCET MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46022012",
      "display" : "CINACALCET TILLOMED",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "36598023",
      "display" : "MIMPARA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "45169051",
      "display" : "CINACALCET ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "47326032",
      "display" : "CINACALCET ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46947089",
      "display" : "CINACALCET AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46894022",
      "display" : "CINACALCET DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "47567058",
      "display" : "CINACALCET DR REDDY'S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46284055",
      "display" : "CINACALCET EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "44554057",
      "display" : "CINACALCET MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46022048",
      "display" : "CINACALCET TILLOMED",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "36598050",
      "display" : "MIMPARA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "45169087",
      "display" : "CINACALCET ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "47326057",
      "display" : "CINACALCET ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46947141",
      "display" : "CINACALCET AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46894034",
      "display" : "CINACALCET DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "47567084",
      "display" : "CINACALCET DR REDDY'S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46284081",
      "display" : "CINACALCET EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "44554083",
      "display" : "CINACALCET MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "45766033",
      "display" : "CINACALCET SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "46022075",
      "display" : "CINACALCET TILLOMED",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "36598098",
      "display" : "MIMPARA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "J9C"
        },
        {
          "code" : "ATC",
          "valueCode" : "H05BX01"
        }
      ]
    },
    {
      "code" : "37321015",
      "display" : "BASEMAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "38108015",
      "display" : "BATTIZER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37929015",
      "display" : "CIPROFLOXACINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "41019011",
      "display" : "CIPROFLOXACINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37904012",
      "display" : "CIPROFLOXACINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "36901015",
      "display" : "CIPROFLOXACINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "43573029",
      "display" : "CIPROFLOXACINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37718018",
      "display" : "CIPROFLOXACINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37661016",
      "display" : "CIPROFLOXACINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37695018",
      "display" : "CIPROFLOXACINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37219060",
      "display" : "CIPROFLOXACINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37525019",
      "display" : "CIPROFLOXACINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37464029",
      "display" : "CIPROFLOXACINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37584012",
      "display" : "CIPROFLOXACINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "38208017",
      "display" : "CIPROFLOXACINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "26664019",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37938014",
      "display" : "SAMPER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37321039",
      "display" : "BASEMAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "38108039",
      "display" : "BATTIZER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37285032",
      "display" : "BOSIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37293038",
      "display" : "CHINOCID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37913035",
      "display" : "CIPERUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "41019252",
      "display" : "CIPROFLOXACINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37904036",
      "display" : "CIPROFLOXACINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "43573082",
      "display" : "CIPROFLOXACINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37718032",
      "display" : "CIPROFLOXACINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37695172",
      "display" : "CIPROFLOXACINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37219452",
      "display" : "CIPROFLOXACINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37464498",
      "display" : "CIPROFLOXACINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "38208031",
      "display" : "CIPROFLOXACINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "26664096",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37687035",
      "display" : "CUSPIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37345030",
      "display" : "EOXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "26663056",
      "display" : "FLONTALEXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37287036",
      "display" : "GENERFLON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37663034",
      "display" : "GERBAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37289030",
      "display" : "KINOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37915030",
      "display" : "MACAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37342033",
      "display" : "PROCIFLOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37938038",
      "display" : "SAMPER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37270028",
      "display" : "ULLAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37321027",
      "display" : "BASEMAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "38108027",
      "display" : "BATTIZER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37285020",
      "display" : "BOSIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37293026",
      "display" : "CHINOCID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37913023",
      "display" : "CIPERUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37929027",
      "display" : "CIPROFLOXACINA ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "41019237",
      "display" : "CIPROFLOXACINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37904024",
      "display" : "CIPROFLOXACINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "36901027",
      "display" : "CIPROFLOXACINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "43573043",
      "display" : "CIPROFLOXACINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37718020",
      "display" : "CIPROFLOXACINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37661028",
      "display" : "CIPROFLOXACINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37269014",
      "display" : "CIPROFLOXACINA GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37695160",
      "display" : "CIPROFLOXACINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37219247",
      "display" : "CIPROFLOXACINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37292024",
      "display" : "CIPROFLOXACINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37344025",
      "display" : "CIPROFLOXACINA PHARMACARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37525072",
      "display" : "CIPROFLOXACINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37464587",
      "display" : "CIPROFLOXACINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37584101",
      "display" : "CIPROFLOXACINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37749025",
      "display" : "CIPROFLOXACINA TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "38208029",
      "display" : "CIPROFLOXACINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "49695012",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "50278011",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "45334012",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "45858014",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "45631013",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "44941019",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "26664021",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "44542013",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "43270014",
      "display" : "CIPROXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37687023",
      "display" : "CUSPIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37345028",
      "display" : "EOXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "26663029",
      "display" : "FLONTALEXIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37287024",
      "display" : "GENERFLON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37663022",
      "display" : "GERBAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "38360020",
      "display" : "IBIXACIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37289028",
      "display" : "KINOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37915028",
      "display" : "MACAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37342021",
      "display" : "PROCIFLOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37938026",
      "display" : "SAMPER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "37270016",
      "display" : "ULLAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "D8B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01MA02"
        }
      ]
    },
    {
      "code" : "23777030",
      "display" : "DIANE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "66A"
        },
        {
          "code" : "ATC",
          "valueCode" : "G03HB01"
        }
      ]
    },
    {
      "code" : "35368012",
      "display" : "VISOFID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "66A"
        },
        {
          "code" : "ATC",
          "valueCode" : "G03HB01"
        }
      ]
    },
    {
      "code" : "35976036",
      "display" : "CITALOPRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36266029",
      "display" : "CITALOPRAM DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36503124",
      "display" : "CITALOPRAM EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36367340",
      "display" : "CITALOPRAM HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36046302",
      "display" : "CITALOPRAM MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36392037",
      "display" : "CITALOPRAM PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "35892052",
      "display" : "CITALOPRAM RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "38238198",
      "display" : "CITALOPRAM SANDOZ BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "37111224",
      "display" : "CITALOPRAM SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36057053",
      "display" : "CITALOPRAM TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "28681029",
      "display" : "ELOPRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "28759025",
      "display" : "SEROPRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36043014",
      "display" : "CITALOPRAM ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36971012",
      "display" : "CITALOPRAM ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36675039",
      "display" : "CITALOPRAM AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36653018",
      "display" : "CITALOPRAM DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36869016",
      "display" : "CITALOPRAM EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36662017",
      "display" : "CITALOPRAM HEXAL AG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36657017",
      "display" : "CITALOPRAM MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "38199016",
      "display" : "CITALOPRAM PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36038014",
      "display" : "CITALOPRAM RATIOPHARM ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36039016",
      "display" : "CITALOPRAM SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36651014",
      "display" : "CITALOPRAM SUN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36057014",
      "display" : "CITALOPRAM TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36254011",
      "display" : "CITALOPRAM ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "28681056",
      "display" : "ELOPRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36246015",
      "display" : "KAIDOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36302014",
      "display" : "PERCITALE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36792036",
      "display" : "RETURN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36056012",
      "display" : "RICAP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "28759049",
      "display" : "SEROPRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36327017",
      "display" : "SINTOPRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "35976024",
      "display" : "CITALOPRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36043026",
      "display" : "CITALOPRAM ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36434013",
      "display" : "CITALOPRAM ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36660013",
      "display" : "CITALOPRAM AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36266017",
      "display" : "CITALOPRAM DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36503023",
      "display" : "CITALOPRAM EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36367151",
      "display" : "CITALOPRAM HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36046047",
      "display" : "CITALOPRAM MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36392025",
      "display" : "CITALOPRAM PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "35892025",
      "display" : "CITALOPRAM RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "38238061",
      "display" : "CITALOPRAM SANDOZ BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "37111147",
      "display" : "CITALOPRAM SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36057040",
      "display" : "CITALOPRAM TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36656015",
      "display" : "CITALOPRAM ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "28681017",
      "display" : "ELOPRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36143016",
      "display" : "FRIMAIND",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "36056024",
      "display" : "RICAP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "28759013",
      "display" : "SEROPRAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "B7D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB04"
        }
      ]
    },
    {
      "code" : "41557051",
      "display" : "CLARITROMICINA SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "45652043",
      "display" : "CLARITROMICINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27370067",
      "display" : "KLACID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27530068",
      "display" : "MACLADIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27529041",
      "display" : "VECLAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPD"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "41557099",
      "display" : "CLARITROMICINA SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPE"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "45652094",
      "display" : "CLARITROMICINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPE"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27370117",
      "display" : "KLACID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPE"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27530120",
      "display" : "MACLADIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPE"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27529104",
      "display" : "VECLAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPE"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37446022",
      "display" : "WINCLAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPE"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "44779027",
      "display" : "CLARITROMICINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37374055",
      "display" : "CLARITROMICINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "44759025",
      "display" : "CLARITROMICINA HCS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "38361010",
      "display" : "CLARITROMICINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37720036",
      "display" : "CLARITROMICINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37586043",
      "display" : "CLARITROMICINA SUN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37559085",
      "display" : "CLARITROMICINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27370055",
      "display" : "KLACID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27530056",
      "display" : "MACLADIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27529054",
      "display" : "VECLAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "38658023",
      "display" : "CLAMODIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "38887028",
      "display" : "CLARITROL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "44779128",
      "display" : "CLARITROMICINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "39688039",
      "display" : "CLARITROMICINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37670027",
      "display" : "CLARITROMICINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "38497032",
      "display" : "CLARITROMICINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37374257",
      "display" : "CLARITROMICINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "44759088",
      "display" : "CLARITROMICINA HCS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37833151",
      "display" : "CLARITROMICINA HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37516438",
      "display" : "CLARITROMICINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "38361022",
      "display" : "CLARITROMICINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37720202",
      "display" : "CLARITROMICINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37586144",
      "display" : "CLARITROMICINA SUN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37559212",
      "display" : "CLARITROMICINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "39820030",
      "display" : "CLARITROMICINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "38728022",
      "display" : "CLARMAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27370129",
      "display" : "KLACID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "38889022",
      "display" : "KRUKLAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27530118",
      "display" : "MACLADIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37456062",
      "display" : "SORICLAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27529116",
      "display" : "VECLAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "37446061",
      "display" : "WINCLAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "41395029",
      "display" : "CLARITROMICINA EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPF"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27370143",
      "display" : "KLACID RM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPF"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "40286027",
      "display" : "KLORENISS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPF"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27530144",
      "display" : "MACLADIN RM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPF"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "27529130",
      "display" : "VECLAM RM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DPF"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01FA09"
        }
      ]
    },
    {
      "code" : "47968019",
      "display" : "CLOBECARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EVC"
        },
        {
          "code" : "ATC",
          "valueCode" : "D07AD01"
        }
      ]
    },
    {
      "code" : "37769039",
      "display" : "ETRIVEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EVC"
        },
        {
          "code" : "ATC",
          "valueCode" : "D07AD01"
        }
      ]
    },
    {
      "code" : "50172016",
      "display" : "SUBLASOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EVC"
        },
        {
          "code" : "ATC",
          "valueCode" : "D07AD01"
        }
      ]
    },
    {
      "code" : "23639026",
      "display" : "CLOBESOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D07AD01"
        }
      ]
    },
    {
      "code" : "23639040",
      "display" : "CLOBESOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D07AD01"
        }
      ]
    },
    {
      "code" : "42402014",
      "display" : "AVERELIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "42850014",
      "display" : "CLOPIDOGREL ACTAVIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "44616011",
      "display" : "CLOPIDOGREL ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "39678026",
      "display" : "CLOPIDOGREL ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "42557025",
      "display" : "CLOPIDOGREL AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "39643022",
      "display" : "CLOPIDOGREL DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "44415267",
      "display" : "CLOPIDOGREL EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "39482031",
      "display" : "CLOPIDOGREL KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "39458029",
      "display" : "CLOPIDOGREL PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "39951025",
      "display" : "CLOPIDOGREL SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "39397031",
      "display" : "CLOPIDOGREL TAW PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "41490020",
      "display" : "CLOPIDOGREL TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "41878113",
      "display" : "CLOPIDOGREL TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "43035017",
      "display" : "CLOPIDOGREL TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "49579030",
      "display" : "CLOPIDOGREL VIATRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "39599030",
      "display" : "CLOPIDOGREL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "39494024",
      "display" : "CLOPINOVO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "41625017",
      "display" : "FLODIGREL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "40215016",
      "display" : "NOGREG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "50145010",
      "display" : "PLAVIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "49461015",
      "display" : "PLAVIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "43220019",
      "display" : "PLAVIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "44418010",
      "display" : "PLAVIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "44667018",
      "display" : "PLAVIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "44811014",
      "display" : "PLAVIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "43976012",
      "display" : "PLAVIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "34128013",
      "display" : "PLAVIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "42361030",
      "display" : "ZYLLT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC04"
        }
      ]
    },
    {
      "code" : "48430060",
      "display" : "CLOPIDOGREL E ACIDO ACETILSALICILICO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC30"
        }
      ]
    },
    {
      "code" : "48521013",
      "display" : "DUOPLAVIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC30"
        }
      ]
    },
    {
      "code" : "47392016",
      "display" : "DUOPLAVIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC30"
        }
      ]
    },
    {
      "code" : "46590016",
      "display" : "DUOPLAVIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC30"
        }
      ]
    },
    {
      "code" : "44723017",
      "display" : "DUOPLAVIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC30"
        }
      ]
    },
    {
      "code" : "39763091",
      "display" : "DUOPLAVIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JGA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC30"
        }
      ]
    },
    {
      "code" : "43807130",
      "display" : "CLOZAPINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "46028027",
      "display" : "CLOZAPINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "35390032",
      "display" : "CLOZAPINA CHIESI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "44326027",
      "display" : "CLOZAPINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "36638221",
      "display" : "CLOZAPINA HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "44349090",
      "display" : "CLOZAPINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "28824047",
      "display" : "LEPONEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "43807039",
      "display" : "CLOZAPINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "46028015",
      "display" : "CLOZAPINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "35390018",
      "display" : "CLOZAPINA CHIESI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "44326015",
      "display" : "CLOZAPINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "36638029",
      "display" : "CLOZAPINA HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "44349037",
      "display" : "CLOZAPINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "28824035",
      "display" : "LEPONEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "AZB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N05AH02"
        }
      ]
    },
    {
      "code" : "42223077",
      "display" : "ANNISTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "47252059",
      "display" : "BALAVITA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46454056",
      "display" : "COLCAD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46468056",
      "display" : "COLECALCIFEROLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42754059",
      "display" : "COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42751053",
      "display" : "COLECALCIFEROLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43913058",
      "display" : "COLECALCIFEROLO IPSO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43942059",
      "display" : "COLECALCIFEROLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43926056",
      "display" : "COLECALCIFEROLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43910052",
      "display" : "COLECALCIFEROLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46470050",
      "display" : "COLECALCIFEROLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "36635062",
      "display" : "DIBASE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46220051",
      "display" : "DISTEOMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46451050",
      "display" : "DIVOD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "44774053",
      "display" : "LAMPARD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "45457049",
      "display" : "MEDIVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43901053",
      "display" : "TOMAINO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42753057",
      "display" : "TREDIMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "48392043",
      "display" : "TREVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "37564061",
      "display" : "XARENEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43474055",
      "display" : "ZIBENAK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNF"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42223053",
      "display" : "ANNISTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "47252010",
      "display" : "BALAVITA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46454017",
      "display" : "COLCAD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46468017",
      "display" : "COLECALCIFEROLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42754010",
      "display" : "COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42751014",
      "display" : "COLECALCIFEROLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43913019",
      "display" : "COLECALCIFEROLO IPSO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43942010",
      "display" : "COLECALCIFEROLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43935016",
      "display" : "COLECALCIFEROLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43926017",
      "display" : "COLECALCIFEROLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43910013",
      "display" : "COLECALCIFEROLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46470011",
      "display" : "COLECALCIFEROLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "36635011",
      "display" : "DIBASE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46166017",
      "display" : "DICOLEV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46451011",
      "display" : "DIVOD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46085015",
      "display" : "IBITRED",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "44774014",
      "display" : "LAMPARD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "45457013",
      "display" : "MEDIVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43901014",
      "display" : "TOMAINO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42753018",
      "display" : "TREDIMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "48392017",
      "display" : "TREVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "37564010",
      "display" : "XARENEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43474016",
      "display" : "ZIBENAK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42223065",
      "display" : "ANNISTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "47252034",
      "display" : "BALAVITA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46454031",
      "display" : "COLCAD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46468031",
      "display" : "COLECALCIFEROLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42754046",
      "display" : "COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42751040",
      "display" : "COLECALCIFEROLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43913033",
      "display" : "COLECALCIFEROLO IPSO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43942034",
      "display" : "COLECALCIFEROLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43935030",
      "display" : "COLECALCIFEROLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43926031",
      "display" : "COLECALCIFEROLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43910037",
      "display" : "COLECALCIFEROLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46470035",
      "display" : "COLECALCIFEROLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "36635098",
      "display" : "DIBASE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46166031",
      "display" : "DICOLEV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46366035",
      "display" : "DIPRONT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46220036",
      "display" : "DISTEOMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46451035",
      "display" : "DIVOD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46085039",
      "display" : "IBITRED",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "44774038",
      "display" : "LAMPARD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "45457037",
      "display" : "MEDIVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43901038",
      "display" : "TOMAINO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42753044",
      "display" : "TREDIMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "48392031",
      "display" : "TREVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "37564097",
      "display" : "XARENEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43474030",
      "display" : "ZIBENAK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNH"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42754111",
      "display" : "COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "49895016",
      "display" : "DITRALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "49895030",
      "display" : "DITRALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46543017",
      "display" : "VITENSON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42754135",
      "display" : "COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46029043",
      "display" : "NODIGAP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42223089",
      "display" : "ANNISTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "47252061",
      "display" : "BALAVITA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46454068",
      "display" : "COLCAD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46468068",
      "display" : "COLECALCIFEROLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42754061",
      "display" : "COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42751065",
      "display" : "COLECALCIFEROLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43913060",
      "display" : "COLECALCIFEROLO IPSO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43942061",
      "display" : "COLECALCIFEROLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43935067",
      "display" : "COLECALCIFEROLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43926068",
      "display" : "COLECALCIFEROLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43910064",
      "display" : "COLECALCIFEROLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46470062",
      "display" : "COLECALCIFEROLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "36635086",
      "display" : "DIBASE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46166068",
      "display" : "DICOLEV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46220063",
      "display" : "DISTEOMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46451062",
      "display" : "DIVOD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "44774065",
      "display" : "LAMPARD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "45457052",
      "display" : "MEDIVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43901065",
      "display" : "TOMAINO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42753069",
      "display" : "TREDIMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "48392056",
      "display" : "TREVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "37564085",
      "display" : "XARENEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43474067",
      "display" : "ZIBENAK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNG"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "49895028",
      "display" : "DITRALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "49895042",
      "display" : "DITRALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42223038",
      "display" : "ANNISTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "47252022",
      "display" : "BALAVITA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46454029",
      "display" : "COLCAD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46468029",
      "display" : "COLECALCIFEROLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42754022",
      "display" : "COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42751026",
      "display" : "COLECALCIFEROLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43913021",
      "display" : "COLECALCIFEROLO IPSO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43942022",
      "display" : "COLECALCIFEROLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43935028",
      "display" : "COLECALCIFEROLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43926029",
      "display" : "COLECALCIFEROLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43910025",
      "display" : "COLECALCIFEROLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46470023",
      "display" : "COLECALCIFEROLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "36635047",
      "display" : "DIBASE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46220024",
      "display" : "DISTEOMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46451023",
      "display" : "DIVOD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "44774026",
      "display" : "LAMPARD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "45457025",
      "display" : "MEDIVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43901026",
      "display" : "TOMAINO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42753020",
      "display" : "TREDIMIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "48392029",
      "display" : "TREVID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "37564046",
      "display" : "XARENEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43474028",
      "display" : "ZIBENAK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42223103",
      "display" : "ANNISTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JED"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "44774089",
      "display" : "LAMPARD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JED"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "43474081",
      "display" : "ZIBENAK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JED"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "42754123",
      "display" : "COLECALCIFEROLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MBR"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "50181078",
      "display" : "COLECALCIFEROLO MYLAN ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MBR"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46543029",
      "display" : "VITENSON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MBR"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "48122028",
      "display" : "FEDIVELLE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LOK"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "46029031",
      "display" : "NODIGAP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LOK"
        },
        {
          "code" : "ATC",
          "valueCode" : "A11CC05"
        }
      ]
    },
    {
      "code" : "48730030",
      "display" : "DEFERASIROX ABDI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48432064",
      "display" : "DEFERASIROX ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "49556107",
      "display" : "DEFERASIROX AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48501023",
      "display" : "DEFERASIROX DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48252062",
      "display" : "DEFERASIROX MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "49404116",
      "display" : "DEFERASIROX SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "47674039",
      "display" : "DEFERASIROX ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "37421144",
      "display" : "EXJADE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48730055",
      "display" : "DEFERASIROX ABDI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXK"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48432102",
      "display" : "DEFERASIROX ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXK"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "49556160",
      "display" : "DEFERASIROX AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXK"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48501035",
      "display" : "DEFERASIROX DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXK"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48252112",
      "display" : "DEFERASIROX MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXK"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "49404217",
      "display" : "DEFERASIROX SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXK"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "47674054",
      "display" : "DEFERASIROX ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXK"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "37421171",
      "display" : "EXJADE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXK"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48730016",
      "display" : "DEFERASIROX ABDI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXI"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48432025",
      "display" : "DEFERASIROX ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXI"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "49556044",
      "display" : "DEFERASIROX AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXI"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48501011",
      "display" : "DEFERASIROX DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXI"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "48252011",
      "display" : "DEFERASIROX MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXI"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "49404015",
      "display" : "DEFERASIROX SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXI"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "47674015",
      "display" : "DEFERASIROX ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXI"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "37421118",
      "display" : "EXJADE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXI"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC03"
        }
      ]
    },
    {
      "code" : "45565025",
      "display" : "DEFERIPRONE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC02"
        }
      ]
    },
    {
      "code" : "34525042",
      "display" : "FERRIPROX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JXA"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC02"
        }
      ]
    },
    {
      "code" : "43361017",
      "display" : "DEFEROXAMINA NORIDEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "73A"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC01"
        }
      ]
    },
    {
      "code" : "20417022",
      "display" : "DESFERAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "73A"
        },
        {
          "code" : "ATC",
          "valueCode" : "V03AC01"
        }
      ]
    },
    {
      "code" : "14729141",
      "display" : "DECADRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "K3B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB02"
        }
      ]
    },
    {
      "code" : "19499072",
      "display" : "SOLDESAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "K3B"
        },
        {
          "code" : "ATC",
          "valueCode" : "H02AB02"
        }
      ]
    },
    {
      "code" : "49800016",
      "display" : "AERIUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "35201096",
      "display" : "AERIUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "43766017",
      "display" : "AERIUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "40983025",
      "display" : "AREMAS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "41725033",
      "display" : "DASSELTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "45156015",
      "display" : "DESLORATADINA AUROBINDO ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "40718037",
      "display" : "DESLORATADINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "40733040",
      "display" : "DESLORATADINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "41081074",
      "display" : "DESLORATADINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "40810071",
      "display" : "DESLORATADINA MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "42376044",
      "display" : "DESLORATADINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "40722098",
      "display" : "DESLORATADINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "41621044",
      "display" : "DESLORATADINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "40872044",
      "display" : "DESLORATADINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "40855037",
      "display" : "EFESTAD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX27"
        }
      ]
    },
    {
      "code" : "28943025",
      "display" : "DEALGIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "32243014",
      "display" : "DICLOFAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "24515088",
      "display" : "DICLOREUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "32141018",
      "display" : "FENADOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "33803014",
      "display" : "FENDER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "28943013",
      "display" : "DEALGIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28H"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "28534016",
      "display" : "DEFLAMAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28H"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "29456050",
      "display" : "DICLOFENAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "33727025",
      "display" : "DICLOFENAC DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "36053015",
      "display" : "DICLOFENAC HEXAL AG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "33062050",
      "display" : "DICLOFENAC MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "23181035",
      "display" : "VOLTAREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "29456011",
      "display" : "DICLOFENAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28C"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "32786028",
      "display" : "DICLOFENAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28C"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "24515049",
      "display" : "DICLOREUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28C"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "23181011",
      "display" : "VOLTAREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28C"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "28945020",
      "display" : "VOLTFAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28C"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "28945032",
      "display" : "VOLTFAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28C"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "33727013",
      "display" : "DICLOFENAC DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28D"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "47332022",
      "display" : "DICLOFENAC MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28D"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "38531012",
      "display" : "VOLTAREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28D"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "41671025",
      "display" : "VOLTAREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28D"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "23181074",
      "display" : "VOLTAREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28D"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "29456035",
      "display" : "DICLOFENAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28E"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "29457037",
      "display" : "DICLOFENAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28E"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "32786042",
      "display" : "DICLOFENAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28E"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "35242015",
      "display" : "DICLOFENAC ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28E"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "35248018",
      "display" : "DICLOFENAC DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28E"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "23181047",
      "display" : "VOLTAREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28E"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "32243038",
      "display" : "DICLOFAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28F"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "24515076",
      "display" : "DICLOREUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "28F"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AB05"
        }
      ]
    },
    {
      "code" : "45242068",
      "display" : "SOLACUTAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JTI"
        },
        {
          "code" : "ATC",
          "valueCode" : "D11AX18"
        }
      ]
    },
    {
      "code" : "34129039",
      "display" : "SOLARAZE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JTI"
        },
        {
          "code" : "ATC",
          "valueCode" : "D11AX18"
        }
      ]
    },
    {
      "code" : "45242070",
      "display" : "SOLACUTAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGF"
        },
        {
          "code" : "ATC",
          "valueCode" : "D11AX18"
        }
      ]
    },
    {
      "code" : "34129041",
      "display" : "SOLARAZE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGF"
        },
        {
          "code" : "ATC",
          "valueCode" : "D11AX18"
        }
      ]
    },
    {
      "code" : "25271040",
      "display" : "ALTIAZEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14G"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25275037",
      "display" : "DILADEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14G"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "33581048",
      "display" : "DILTIAZEM DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14G"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "26675049",
      "display" : "DILTIAZEM MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14G"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "33682030",
      "display" : "DILTIAZEM SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14G"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25277070",
      "display" : "DILZENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14G"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25278060",
      "display" : "TILDIEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14G"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25271038",
      "display" : "ALTIAZEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25280049",
      "display" : "ANGIZEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25275025",
      "display" : "DILADEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "33581024",
      "display" : "DILTIAZEM DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "32808091",
      "display" : "DILTIAZEM EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "26675025",
      "display" : "DILTIAZEM MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "33682028",
      "display" : "DILTIAZEM SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25277068",
      "display" : "DILZENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25278058",
      "display" : "TILDIEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "32808014",
      "display" : "DILTIAZEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "33175023",
      "display" : "DILTIAZEM RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25280064",
      "display" : "ANGIZEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14I"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25275049",
      "display" : "DILADEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14I"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "42274062",
      "display" : "DILTIAZEM SANDOZ BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14I"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25278072",
      "display" : "TILDIEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14I"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25271014",
      "display" : "ALTIAZEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25280025",
      "display" : "ANGIZEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25275013",
      "display" : "DILADEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "32808040",
      "display" : "DILTIAZEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "33581012",
      "display" : "DILTIAZEM DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "26675013",
      "display" : "DILTIAZEM MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25277017",
      "display" : "DILZENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "25278019",
      "display" : "TILDIEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "14B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08DB01"
        }
      ]
    },
    {
      "code" : "43017021",
      "display" : "BLIXIE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40394025",
      "display" : "DESTEZIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41015126",
      "display" : "DONEPEZIL ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "38768091",
      "display" : "DONEPEZIL ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "39741020",
      "display" : "DONEPEZIL ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41885094",
      "display" : "DONEPEZIL AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40721072",
      "display" : "DONEPEZIL DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40085045",
      "display" : "DONEPEZIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "38605236",
      "display" : "DONEPEZIL MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41088170",
      "display" : "DONEPEZIL MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "39145192",
      "display" : "DONEPEZIL SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40538187",
      "display" : "DONEPEZIL SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41733128",
      "display" : "DONEPEZIL TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40159182",
      "display" : "DONEPEZIL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41791068",
      "display" : "LIZIDRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "42613024",
      "display" : "MEMAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40896159",
      "display" : "YASNAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41796121",
      "display" : "YASNORO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "43017019",
      "display" : "BLIXIE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40394013",
      "display" : "DESTEZIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41015025",
      "display" : "DONEPEZIL ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "38768038",
      "display" : "DONEPEZIL ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "39741018",
      "display" : "DONEPEZIL ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41885029",
      "display" : "DONEPEZIL AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40721019",
      "display" : "DONEPEZIL DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40085019",
      "display" : "DONEPEZIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "38605109",
      "display" : "DONEPEZIL MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41088042",
      "display" : "DONEPEZIL MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "39145040",
      "display" : "DONEPEZIL SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40538136",
      "display" : "DONEPEZIL SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41733027",
      "display" : "DONEPEZIL TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40159042",
      "display" : "DONEPEZIL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41791017",
      "display" : "LIZIDRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "42613012",
      "display" : "MEMAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "40896045",
      "display" : "YASNAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "41796020",
      "display" : "YASNORO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FSA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA02"
        }
      ]
    },
    {
      "code" : "39967017",
      "display" : "DORZOCLAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC03"
        }
      ]
    },
    {
      "code" : "40609012",
      "display" : "DORZOLAMIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC03"
        }
      ]
    },
    {
      "code" : "40083014",
      "display" : "DORZOLAMIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC03"
        }
      ]
    },
    {
      "code" : "40189019",
      "display" : "DORZONORM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC03"
        }
      ]
    },
    {
      "code" : "39620012",
      "display" : "DORZOSTILL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC03"
        }
      ]
    },
    {
      "code" : "31848056",
      "display" : "TRUSOPT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC03"
        }
      ]
    },
    {
      "code" : "42570010",
      "display" : "ZOLIOP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01EC03"
        }
      ]
    },
    {
      "code" : "41858010",
      "display" : "BETACLAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "34242103",
      "display" : "COSOPT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "40815019",
      "display" : "DORZAMOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "41137011",
      "display" : "DORZOLAMIDE E TIMOLOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "40792018",
      "display" : "DORZOLAMIDE E TIMOLOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "43861018",
      "display" : "DORZOLAMIDE E TIMOLOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "47051014",
      "display" : "DORZOLAMIDE E TIMOLOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "40797019",
      "display" : "DORZOLAMIDE TIMOLOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "41580010",
      "display" : "DORZOLAMIDE TIMOLOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "41907027",
      "display" : "TIDOCOMB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "41908029",
      "display" : "ZITODOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "F3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "S01ED51"
        }
      ]
    },
    {
      "code" : "29467026",
      "display" : "BENUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CA"
        }
      ]
    },
    {
      "code" : "39353014",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "40734016",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "41749021",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "43639018",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "39462015",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "39462041",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "26821025",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37247069",
      "display" : "CHIARIDOXINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "27062025",
      "display" : "DEDRALEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37243060",
      "display" : "DILUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37246081",
      "display" : "DOXAFIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "40243180",
      "display" : "DOXAZOSIN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37397027",
      "display" : "DOXAZOSIN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37494111",
      "display" : "DOXAZOSIN RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37618117",
      "display" : "DOXAZOSIN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37650025",
      "display" : "DOXAZOSINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37275029",
      "display" : "DOXAZOSINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "34434187",
      "display" : "DOXAZOSINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37750116",
      "display" : "DOXAZOSINA HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37829025",
      "display" : "DOXAZOSINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37773114",
      "display" : "DOXAZOSINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37244062",
      "display" : "DOXAZOSINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37248061",
      "display" : "KIMURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37840028",
      "display" : "LENAXOLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37740026",
      "display" : "NORADOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "26818029",
      "display" : "NORMOTHEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37927023",
      "display" : "QUORUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "38647020",
      "display" : "SAIDOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "39353026",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "39353038",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "40734028",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "43633027",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "41749019",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "39462027",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "39462039",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "26821013",
      "display" : "CARDURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37247057",
      "display" : "CHIARIDOXINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "27062013",
      "display" : "DEDRALEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37243058",
      "display" : "DILUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37246079",
      "display" : "DOXAFIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "40243065",
      "display" : "DOXAZOSIN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37397015",
      "display" : "DOXAZOSIN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37494046",
      "display" : "DOXAZOSIN RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37618016",
      "display" : "DOXAZOSIN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37650013",
      "display" : "DOXAZOSINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37275017",
      "display" : "DOXAZOSINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "34434047",
      "display" : "DOXAZOSINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37829013",
      "display" : "DOXAZOSINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37773013",
      "display" : "DOXAZOSINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37244050",
      "display" : "DOXAZOSINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37248059",
      "display" : "KIMURA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37840016",
      "display" : "LENAXOLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37740014",
      "display" : "NORADOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "26818017",
      "display" : "NORMOTHEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37927011",
      "display" : "QUORUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "38647018",
      "display" : "SAIDOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "40243204",
      "display" : "DOXAZOSIN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQO"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37397039",
      "display" : "DOXAZOSIN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQO"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37494135",
      "display" : "DOXAZOSIN RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQO"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37650037",
      "display" : "DOXAZOSINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQO"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "34434201",
      "display" : "DOXAZOSINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQO"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37750066",
      "display" : "DOXAZOSINA HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQO"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37829037",
      "display" : "DOXAZOSINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQO"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37773064",
      "display" : "DOXAZOSINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQO"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37244074",
      "display" : "DOXAZOSINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQO"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37829049",
      "display" : "DOXAZOSINA MYLAN  GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LCM"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "37244086",
      "display" : "DOXAZOSINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LCM"
        },
        {
          "code" : "ATC",
          "valueCode" : "C02CA04"
        }
      ]
    },
    {
      "code" : "21635065",
      "display" : "BASSADO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "76D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01AA02"
        }
      ]
    },
    {
      "code" : "21856051",
      "display" : "FARMODOXI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "76D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01AA02"
        }
      ]
    },
    {
      "code" : "22211039",
      "display" : "MIRACLIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "76D"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01AA02"
        }
      ]
    },
    {
      "code" : "46652044",
      "display" : "DRONEDARONE ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD07"
        }
      ]
    },
    {
      "code" : "39589039",
      "display" : "MULTAQ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BD07"
        }
      ]
    },
    {
      "code" : "44641025",
      "display" : "ALIKRES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "36683011",
      "display" : "CYMBALTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44408021",
      "display" : "DULEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43842020",
      "display" : "DULOXETINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43587031",
      "display" : "DULOXETINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43595040",
      "display" : "DULOXETINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43943024",
      "display" : "DULOXETINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43859026",
      "display" : "DULOXETINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44267452",
      "display" : "DULOXETINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43594050",
      "display" : "DULOXETINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44699041",
      "display" : "DULOXETINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "48010033",
      "display" : "DULOXETINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44472114",
      "display" : "DULOXETINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43548041",
      "display" : "EZEQUA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43590013",
      "display" : "SILOXEZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44641037",
      "display" : "ALIKRES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "47516012",
      "display" : "CYMBALTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "36683023",
      "display" : "CYMBALTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44408033",
      "display" : "DULEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43842044",
      "display" : "DULOXETINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43587118",
      "display" : "DULOXETINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43595065",
      "display" : "DULOXETINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43943048",
      "display" : "DULOXETINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43859065",
      "display" : "DULOXETINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44267502",
      "display" : "DULOXETINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43594098",
      "display" : "DULOXETINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44699080",
      "display" : "DULOXETINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "48010096",
      "display" : "DULOXETINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44472153",
      "display" : "DULOXETINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43548066",
      "display" : "EZEQUA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43590025",
      "display" : "SILOXEZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "36683062",
      "display" : "CYMBALTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44408019",
      "display" : "DULEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43587017",
      "display" : "DULOXETINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43595038",
      "display" : "DULOXETINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43943012",
      "display" : "DULOXETINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43859014",
      "display" : "DULOXETINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44267425",
      "display" : "DULOXETINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44699015",
      "display" : "DULOXETINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "48010019",
      "display" : "DULOXETINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "44472102",
      "display" : "DULOXETINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "43548027",
      "display" : "EZEQUA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AX21"
        }
      ]
    },
    {
      "code" : "35895010",
      "display" : "AVODART",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44102022",
      "display" : "DECUSTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "35896012",
      "display" : "DUAGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "46973018",
      "display" : "DURITAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "45997018",
      "display" : "DUTAS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "45364027",
      "display" : "DUTASTERIDE ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "45117025",
      "display" : "DUTASTERIDE ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "45302027",
      "display" : "DUTASTERIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "43231012",
      "display" : "DUTASTERIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "43941020",
      "display" : "DUTASTERIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44777023",
      "display" : "DUTASTERIDE KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "45395011",
      "display" : "DUTASTERIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44746028",
      "display" : "DUTASTERIDE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44410025",
      "display" : "DUTASTERIDE SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "45063017",
      "display" : "DUTASTERIDE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "42747030",
      "display" : "DUTASTERIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44103024",
      "display" : "DUTASTERIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "45115019",
      "display" : "PRODUTAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44106021",
      "display" : "PRODUXEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44105029",
      "display" : "TASDURIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44104026",
      "display" : "VIVISTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44102059",
      "display" : "DECUSTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "43912056",
      "display" : "PRODIREXAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44106058",
      "display" : "PRODUXEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "44104053",
      "display" : "VIVISTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOB"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB02"
        }
      ]
    },
    {
      "code" : "29353012",
      "display" : "CLEVER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "44598035",
      "display" : "EBASTINA ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "47251032",
      "display" : "EBASTINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "42598033",
      "display" : "EBASTINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "43728029",
      "display" : "EBASTINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "42599035",
      "display" : "EBASTINA MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "42597031",
      "display" : "EBASTINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "40840035",
      "display" : "EBASTINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "34930014",
      "display" : "KESTINE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "34930141",
      "display" : "KESTINE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX22"
        }
      ]
    },
    {
      "code" : "46713020",
      "display" : "ELETRIPTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "35307103",
      "display" : "RELPAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "46713071",
      "display" : "ELETRIPTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "35307281",
      "display" : "RELPAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "46713095",
      "display" : "ELETRIPTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "43436068",
      "display" : "ELETRIPTAN DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "45017124",
      "display" : "ELETRIPTAN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "42589150",
      "display" : "ELETRIPTAN MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "43584022",
      "display" : "ELETRIPTAN TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "42410148",
      "display" : "ELETRIPTAN VIATRIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "49946015",
      "display" : "RELPAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "35307305",
      "display" : "RELPAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KQC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC06"
        }
      ]
    },
    {
      "code" : "25681026",
      "display" : "CONVERTEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36595027",
      "display" : "ENALAPRIL ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "46073223",
      "display" : "ENALAPRIL AUROBINDO PHARMA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "34749337",
      "display" : "ENALAPRIL DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36171332",
      "display" : "ENALAPRIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "38401028",
      "display" : "ENALAPRIL EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36488486",
      "display" : "ENALAPRIL MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "38651028",
      "display" : "ENALAPRIL PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36175228",
      "display" : "ENALAPRIL SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "41693060",
      "display" : "ENALAPRIL SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "42121107",
      "display" : "ENALAPRIL TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "39914054",
      "display" : "ENALAPRIL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "25682028",
      "display" : "ENAPREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36596029",
      "display" : "LANEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "25725021",
      "display" : "NAPRILENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "37961012",
      "display" : "NAPRILENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "39317019",
      "display" : "NAPRILENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "44547014",
      "display" : "NAPRILENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "44487015",
      "display" : "NAPRILENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "44805012",
      "display" : "NAPRILENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "42833018",
      "display" : "NAPRILENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36595039",
      "display" : "ENALAPRIL ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNR"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "46073235",
      "display" : "ENALAPRIL AUROBINDO PHARMA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNR"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "34749251",
      "display" : "ENALAPRIL DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNR"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36171193",
      "display" : "ENALAPRIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNR"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36488500",
      "display" : "ENALAPRIL MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNR"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "38651030",
      "display" : "ENALAPRIL PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNR"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36175026",
      "display" : "ENALAPRIL SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNR"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "42121121",
      "display" : "ENALAPRIL TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KNR"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "25681038",
      "display" : "CONVERTEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36595015",
      "display" : "ENALAPRIL ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "46073084",
      "display" : "ENALAPRIL AUROBINDO PHARMA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "34749097",
      "display" : "ENALAPRIL DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36171039",
      "display" : "ENALAPRIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36488334",
      "display" : "ENALAPRIL MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "38651016",
      "display" : "ENALAPRIL PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36175139",
      "display" : "ENALAPRIL SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "41693021",
      "display" : "ENALAPRIL SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "42121020",
      "display" : "ENALAPRIL TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "39914015",
      "display" : "ENALAPRIL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "25682042",
      "display" : "ENAPREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "36596017",
      "display" : "LANEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "37961024",
      "display" : "NAPRILENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "25725045",
      "display" : "NAPRILENE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BAB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA02"
        }
      ]
    },
    {
      "code" : "27395021",
      "display" : "ACESISTEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "27135019",
      "display" : "CONDIUREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37378027",
      "display" : "ELEKTRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37630011",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37545011",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37741016",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "41917129",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38866012",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38039018",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37631013",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37371022",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38435020",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37804059",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37967027",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37641014",
      "display" : "ENEFIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38062016",
      "display" : "LANETIK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "42954026",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "45409012",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38491027",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38491039",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "39867015",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "43891011",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "43385018",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "44541011",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "41754019",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "43955018",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "42954014",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "43892013",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "43347018",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "43347020",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "27056011",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38781011",
      "display" : "VASORETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37382025",
      "display" : "ENALAPRIL + IDROCLOROTIAZIDE EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38012112",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE HEXAL AG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37486115",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "33267016",
      "display" : "GENTIPRESS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "33266014",
      "display" : "SINERTEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37378041",
      "display" : "ELEKTRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOU"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37741028",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOU"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "41917143",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOU"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38866024",
      "display" : "ENALAPRIL E IDROCLOROTIAZIDE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOU"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37371046",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOU"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38435044",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOU"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37804010",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOU"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "37967041",
      "display" : "ENALAPRIL IDROCLOROTIAZIDE SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KOU"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA02"
        }
      ]
    },
    {
      "code" : "38576144",
      "display" : "ATOVER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "38568147",
      "display" : "CORIPREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "45468028",
      "display" : "ENALAPRIL E LERCANIDIPINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "45015118",
      "display" : "ENALAPRIL E LERCANIDIPINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "45043041",
      "display" : "ENALAPRIL E LERCANIDIPINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "45342021",
      "display" : "ENALAPRIL E LERCANIDIPINA MYLAN PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "45178062",
      "display" : "ENALAPRIL E LERCANIDIPINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "38565141",
      "display" : "LERCAPREL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "38502148",
      "display" : "ZANIPRIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "38576258",
      "display" : "ATOVER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KAP"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "38568251",
      "display" : "CORIPREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KAP"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "47875024",
      "display" : "ENALAPRIL E LERCANIDIPINA EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KAP"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "45178163",
      "display" : "ENALAPRIL E LERCANIDIPINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KAP"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "38565255",
      "display" : "LERCAPREL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KAP"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "38502252",
      "display" : "ZANIPRIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KAP"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BB02"
        }
      ]
    },
    {
      "code" : "37221076",
      "display" : "BARACLUDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45675028",
      "display" : "ENTECAVIR ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45443013",
      "display" : "ENTECAVIR ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45447012",
      "display" : "ENTECAVIR AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45276019",
      "display" : "ENTECAVIR DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45165026",
      "display" : "ENTECAVIR DR REDDY'S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "44996015",
      "display" : "ENTECAVIR KABI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45672021",
      "display" : "ENTECAVIR MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45155013",
      "display" : "ENTECAVIR SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "47070014",
      "display" : "ENTECAVIR SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45065087",
      "display" : "ENTECAVIR TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRS"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "37221088",
      "display" : "BARACLUDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45675055",
      "display" : "ENTECAVIR ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45443049",
      "display" : "ENTECAVIR ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45447063",
      "display" : "ENTECAVIR AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45276033",
      "display" : "ENTECAVIR DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45165065",
      "display" : "ENTECAVIR DR REDDY'S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "44996041",
      "display" : "ENTECAVIR KABI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45672072",
      "display" : "ENTECAVIR MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45155052",
      "display" : "ENTECAVIR SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "47070053",
      "display" : "ENTECAVIR SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "45065202",
      "display" : "ENTECAVIR TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRT"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AF10"
        }
      ]
    },
    {
      "code" : "24939148",
      "display" : "ECASOLV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "77B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AB01"
        }
      ]
    },
    {
      "code" : "31126055",
      "display" : "REOFLUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "77B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AB01"
        }
      ]
    },
    {
      "code" : "32916013",
      "display" : "SOSEFLUSS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "77B"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AB01"
        }
      ]
    },
    {
      "code" : "30705014",
      "display" : "EPSOCLAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "78A"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AB01"
        }
      ]
    },
    {
      "code" : "34692032",
      "display" : "PHAREPA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "78A"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AB01"
        }
      ]
    },
    {
      "code" : "43722038",
      "display" : "EPLERENONE ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "44092043",
      "display" : "EPLERENONE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "46618043",
      "display" : "EPLERENONE KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "43626023",
      "display" : "EPLERENONE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "43802014",
      "display" : "EPLERENONE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "37298092",
      "display" : "INSPRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "43722139",
      "display" : "EPLERENONE ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARI"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "44092120",
      "display" : "EPLERENONE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARI"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "46618183",
      "display" : "EPLERENONE KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARI"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "43626062",
      "display" : "EPLERENONE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARI"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "43802026",
      "display" : "EPLERENONE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARI"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "37298217",
      "display" : "INSPRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARI"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03DA04"
        }
      ]
    },
    {
      "code" : "41825023",
      "display" : "CIPRALEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "35767654",
      "display" : "CIPRALEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42396010",
      "display" : "DINOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "35768656",
      "display" : "ENTACT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42042010",
      "display" : "ESCITALOPRAM ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41838018",
      "display" : "ESCITALOPRAM DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41646011",
      "display" : "ESCITALOPRAM EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42038012",
      "display" : "ESCITALOPRAM MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41644016",
      "display" : "ESCITALOPRAM PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41643014",
      "display" : "ESCITALOPRAM SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42395018",
      "display" : "ESCITALOPRAM TEVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42651012",
      "display" : "ESCITALOPRAM ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41688033",
      "display" : "GIACHELA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "44396036",
      "display" : "GOMEISA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "44271031",
      "display" : "PRAMEFFEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42120016",
      "display" : "AMASCI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "47407010",
      "display" : "CIPRALEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "45337019",
      "display" : "CIPRALEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "35767250",
      "display" : "CIPRALEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "35768252",
      "display" : "ENTACT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42256053",
      "display" : "ESCERTAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "43592029",
      "display" : "ESCITALOPRAM ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41976034",
      "display" : "ESCITALOPRAM AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42563066",
      "display" : "ESCITALOPRAM DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41975020",
      "display" : "ESCITALOPRAM DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42578068",
      "display" : "ESCITALOPRAM EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42762031",
      "display" : "ESCITALOPRAM EG STADA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "43190127",
      "display" : "ESCITALOPRAM KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42182030",
      "display" : "ESCITALOPRAM LABORATORI ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "44258046",
      "display" : "ESCITALOPRAM MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42975021",
      "display" : "ESCITALOPRAM PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42022234",
      "display" : "ESCITALOPRAM SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42458036",
      "display" : "ESCITALOPRAM SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "43497015",
      "display" : "ESCITALOPRAM TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42116222",
      "display" : "ESCITALOPRAM TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "43069044",
      "display" : "ESCITALOPRAM ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41688019",
      "display" : "GIACHELA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "44271017",
      "display" : "PRAMEFFEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42001014",
      "display" : "SOSECIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42120042",
      "display" : "AMASCI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "35767375",
      "display" : "CIPRALEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "35768377",
      "display" : "ENTACT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42256154",
      "display" : "ESCERTAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "43592120",
      "display" : "ESCITALOPRAM ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41976123",
      "display" : "ESCITALOPRAM AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42563268",
      "display" : "ESCITALOPRAM DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41975044",
      "display" : "ESCITALOPRAM DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42578260",
      "display" : "ESCITALOPRAM EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42762157",
      "display" : "ESCITALOPRAM EG STADA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "43190305",
      "display" : "ESCITALOPRAM KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42182067",
      "display" : "ESCITALOPRAM LABORATORI ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "44258236",
      "display" : "ESCITALOPRAM MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42975072",
      "display" : "ESCITALOPRAM PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42022590",
      "display" : "ESCITALOPRAM SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42458101",
      "display" : "ESCITALOPRAM SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "43497027",
      "display" : "ESCITALOPRAM TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "42116588",
      "display" : "ESCITALOPRAM TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "43069119",
      "display" : "ESCITALOPRAM ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "41688021",
      "display" : "GIACHELA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "44271029",
      "display" : "PRAMEFFEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L2A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB10"
        }
      ]
    },
    {
      "code" : "48222020",
      "display" : "ARUPSAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EIH"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF04"
        }
      ]
    },
    {
      "code" : "49368020",
      "display" : "ESLICARBAZEPINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EIH"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF04"
        }
      ]
    },
    {
      "code" : "39910171",
      "display" : "ZEBINIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EIH"
        },
        {
          "code" : "ATC",
          "valueCode" : "N03AF04"
        }
      ]
    },
    {
      "code" : "49818014",
      "display" : "ABIGERD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40200038",
      "display" : "ARILIAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "35035157",
      "display" : "AXAGON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41804028",
      "display" : "COLLEZOES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "43241025",
      "display" : "ESODOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44705010",
      "display" : "ESOMEPRAZOLO ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "42973026",
      "display" : "ESOMEPRAZOLO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40293300",
      "display" : "ESOMEPRAZOLO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41951031",
      "display" : "ESOMEPRAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40837116",
      "display" : "ESOMEPRAZOLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40201030",
      "display" : "ESOMEPRAZOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44678011",
      "display" : "ESOMEPRAZOLO DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40235069",
      "display" : "ESOMEPRAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41803026",
      "display" : "ESOMEPRAZOLO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "43243029",
      "display" : "ESOMEPRAZOLO GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40198297",
      "display" : "ESOMEPRAZOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "46185043",
      "display" : "ESOMEPRAZOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40124024",
      "display" : "ESOMEPRAZOLO MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44677019",
      "display" : "ESOMEPRAZOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44677134",
      "display" : "ESOMEPRAZOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40199299",
      "display" : "ESOMEPRAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40839019",
      "display" : "ESOMEPRAZOLO SUN PHARMACEUTICAL INDUSTRIES (EUROPE) BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40839209",
      "display" : "ESOMEPRAZOLO SUN PHARMACEUTICAL INDUSTRIES (EUROPE) BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40068330",
      "display" : "ESOMEPRAZOLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40562035",
      "display" : "ESOMEPRAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "49819016",
      "display" : "ESOPIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "35433022",
      "display" : "ESOPRAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40838070",
      "display" : "EZORAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "43242027",
      "display" : "GASTRES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "35367263",
      "display" : "LUCEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "34972265",
      "display" : "NEXIUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "49818038",
      "display" : "ABIGERD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40200091",
      "display" : "ARILIAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "35035563",
      "display" : "AXAGON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41804042",
      "display" : "COLLEZOES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "43241049",
      "display" : "ESODOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44705034",
      "display" : "ESOMEPRAZOLO ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "42973040",
      "display" : "ESOMEPRAZOLO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40293324",
      "display" : "ESOMEPRAZOLO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41951219",
      "display" : "ESOMEPRAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40837128",
      "display" : "ESOMEPRAZOLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40201067",
      "display" : "ESOMEPRAZOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44678035",
      "display" : "ESOMEPRAZOLO DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40235172",
      "display" : "ESOMEPRAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41803040",
      "display" : "ESOMEPRAZOLO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "43243043",
      "display" : "ESOMEPRAZOLO GIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40198424",
      "display" : "ESOMEPRAZOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "46185120",
      "display" : "ESOMEPRAZOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40124099",
      "display" : "ESOMEPRAZOLO MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44677060",
      "display" : "ESOMEPRAZOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44677161",
      "display" : "ESOMEPRAZOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40199426",
      "display" : "ESOMEPRAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40839110",
      "display" : "ESOMEPRAZOLO SUN PHARMACEUTICAL INDUSTRIES (EUROPE) BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40839298",
      "display" : "ESOMEPRAZOLO SUN PHARMACEUTICAL INDUSTRIES (EUROPE) BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40068456",
      "display" : "ESOMEPRAZOLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40562213",
      "display" : "ESOMEPRAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "49819030",
      "display" : "ESOPIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "35433174",
      "display" : "ESOPRAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40838106",
      "display" : "EZORAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "43242041",
      "display" : "GASTRES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "35367414",
      "display" : "LUCEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "34972416",
      "display" : "NEXIUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CVB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "49818026",
      "display" : "ABIGERD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40200053",
      "display" : "ARILIAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44705059",
      "display" : "ESOMEPRAZOLO ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "42973065",
      "display" : "ESOMEPRAZOLO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40293161",
      "display" : "ESOMEPRAZOLO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41951068",
      "display" : "ESOMEPRAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40837130",
      "display" : "ESOMEPRAZOLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40201042",
      "display" : "ESOMEPRAZOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44678050",
      "display" : "ESOMEPRAZOLO DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40235083",
      "display" : "ESOMEPRAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41803115",
      "display" : "ESOMEPRAZOLO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40198311",
      "display" : "ESOMEPRAZOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "46185068",
      "display" : "ESOMEPRAZOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40124048",
      "display" : "ESOMEPRAZOLO MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44677110",
      "display" : "ESOMEPRAZOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44677146",
      "display" : "ESOMEPRAZOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40199313",
      "display" : "ESOMEPRAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40839223",
      "display" : "ESOMEPRAZOLO SUN PHARMACEUTICAL INDUSTRIES (EUROPE) BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40068355",
      "display" : "ESOMEPRAZOLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40562062",
      "display" : "ESOMEPRAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "49819028",
      "display" : "ESOPIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40838082",
      "display" : "EZORAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "43242078",
      "display" : "GASTRES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "35367299",
      "display" : "LUCEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "34972291",
      "display" : "NEXIUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDP"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "49818040",
      "display" : "ABIGERD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40200115",
      "display" : "ARILIAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44705061",
      "display" : "ESOMEPRAZOLO ALMUS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "42973077",
      "display" : "ESOMEPRAZOLO ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40293235",
      "display" : "ESOMEPRAZOLO ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41951245",
      "display" : "ESOMEPRAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40837142",
      "display" : "ESOMEPRAZOLO DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40201079",
      "display" : "ESOMEPRAZOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44678062",
      "display" : "ESOMEPRAZOLO DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40235196",
      "display" : "ESOMEPRAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "41803127",
      "display" : "ESOMEPRAZOLO EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40198448",
      "display" : "ESOMEPRAZOLO KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "46185144",
      "display" : "ESOMEPRAZOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40124113",
      "display" : "ESOMEPRAZOLO MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44677122",
      "display" : "ESOMEPRAZOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "44677173",
      "display" : "ESOMEPRAZOLO PENSA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40199440",
      "display" : "ESOMEPRAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40839312",
      "display" : "ESOMEPRAZOLO SUN PHARMACEUTICAL INDUSTRIES (EUROPE) BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40068470",
      "display" : "ESOMEPRAZOLO TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40562249",
      "display" : "ESOMEPRAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "49819042",
      "display" : "ESOPIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "40838118",
      "display" : "EZORAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "43242080",
      "display" : "GASTRES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "35367440",
      "display" : "LUCEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "34972442",
      "display" : "NEXIUM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "A02BC05"
        }
      ]
    },
    {
      "code" : "30183014",
      "display" : "CLIMARA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "81D"
        },
        {
          "code" : "ATC",
          "valueCode" : "G03CA03"
        }
      ]
    },
    {
      "code" : "29966013",
      "display" : "FEMSEVEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "81D"
        },
        {
          "code" : "ATC",
          "valueCode" : "G03CA03"
        }
      ]
    },
    {
      "code" : "29001017",
      "display" : "DERMESTRIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "81F"
        },
        {
          "code" : "ATC",
          "valueCode" : "G03CA03"
        }
      ]
    },
    {
      "code" : "31773017",
      "display" : "ESTRADERM MX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "81F"
        },
        {
          "code" : "ATC",
          "valueCode" : "G03CA03"
        }
      ]
    },
    {
      "code" : "36170013",
      "display" : "ANGELIQ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "G03FA17"
        }
      ]
    },
    {
      "code" : "47143019",
      "display" : "PAOSONELLE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "L5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "G03FA17"
        }
      ]
    },
    {
      "code" : "35821065",
      "display" : "ALGIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "35820063",
      "display" : "ARCOXIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "45221013",
      "display" : "ETORICOXIB ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44821039",
      "display" : "ETORICOXIB AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43688011",
      "display" : "ETORICOXIB DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44451084",
      "display" : "ETORICOXIB EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44632026",
      "display" : "ETORICOXIB KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43546050",
      "display" : "ETORICOXIB MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "45220023",
      "display" : "ETORICOXIB PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43004151",
      "display" : "ETORICOXIB SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44969018",
      "display" : "ETORICOXIB TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43684075",
      "display" : "ETORICOXIB TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43747068",
      "display" : "ETORICOXIB ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "49864236",
      "display" : "QUANTICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "35890060",
      "display" : "TAUXIB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "45916018",
      "display" : "XETORIB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "35821204",
      "display" : "ALGIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "35820202",
      "display" : "ARCOXIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "45221049",
      "display" : "ETORICOXIB ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44821066",
      "display" : "ETORICOXIB AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43688023",
      "display" : "ETORICOXIB DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44451185",
      "display" : "ETORICOXIB EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44632038",
      "display" : "ETORICOXIB KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43546086",
      "display" : "ETORICOXIB MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "45220050",
      "display" : "ETORICOXIB PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43004252",
      "display" : "ETORICOXIB SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44969020",
      "display" : "ETORICOXIB TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43684164",
      "display" : "ETORICOXIB TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43747120",
      "display" : "ETORICOXIB ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "49864402",
      "display" : "QUANTICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "35890209",
      "display" : "TAUXIB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "45916020",
      "display" : "XETORIB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYC"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "35821305",
      "display" : "ALGIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "35820303",
      "display" : "ARCOXIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43688035",
      "display" : "ETORICOXIB DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44451250",
      "display" : "ETORICOXIB EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44632040",
      "display" : "ETORICOXIB KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43546112",
      "display" : "ETORICOXIB MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "44969032",
      "display" : "ETORICOXIB TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "43684226",
      "display" : "ETORICOXIB TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "49864539",
      "display" : "QUANTICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "35890425",
      "display" : "TAUXIB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "SYA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AH05"
        }
      ]
    },
    {
      "code" : "47266034",
      "display" : "AROMASIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "47266022",
      "display" : "AROMASIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "45700010",
      "display" : "AROMASIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "34678033",
      "display" : "AROMASIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "40012015",
      "display" : "AXELTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "40011013",
      "display" : "EXEGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "39850019",
      "display" : "EXEMESTANE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "40320018",
      "display" : "EXEMESTANE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "40886044",
      "display" : "EXEMESTANE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "40535041",
      "display" : "EXEMESTANE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "40275048",
      "display" : "EXEMESTANE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "40940013",
      "display" : "EXEMESTANE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "41398013",
      "display" : "MESTANE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "40900045",
      "display" : "MEXABREST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "41190048",
      "display" : "NIBESTAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "42474015",
      "display" : "STANEXAM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "FIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L02BG06"
        }
      ]
    },
    {
      "code" : "36018149",
      "display" : "ABSORCOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "44596017",
      "display" : "CORINTUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "45116023",
      "display" : "EZELIP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "45314162",
      "display" : "EZETIMIBE ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "44521021",
      "display" : "EZETIMIBE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "46509030",
      "display" : "EZETIMIBE ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "45835042",
      "display" : "EZETIMIBE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "44595015",
      "display" : "EZETIMIBE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "44282046",
      "display" : "EZETIMIBE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "44716037",
      "display" : "EZETIMIBE KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "42752030",
      "display" : "EZETIMIBE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "42752461",
      "display" : "EZETIMIBE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "44747018",
      "display" : "EZETIMIBE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "42785067",
      "display" : "EZETIMIBE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "45963028",
      "display" : "EZETIMIBE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "44272045",
      "display" : "EZETIMIBE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "45008024",
      "display" : "EZETIMIBE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "45008214",
      "display" : "EZETIMIBE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "36016145",
      "display" : "EZETROL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "45223017",
      "display" : "LEZIMIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "44597019",
      "display" : "MIBECOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "46620011",
      "display" : "TRIZIBE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "36017147",
      "display" : "ZETIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AX09"
        }
      ]
    },
    {
      "code" : "47583012",
      "display" : "ANCILLEG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNM"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "48574014",
      "display" : "EZETIMIBE E ATORVASTATINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNM"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "48444020",
      "display" : "EZEVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNM"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49746023",
      "display" : "TOVASTIBE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNM"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "47583087",
      "display" : "ANCILLEG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNX"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "48574026",
      "display" : "EZETIMIBE E ATORVASTATINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNX"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "48444069",
      "display" : "EZEVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNX"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49746062",
      "display" : "TOVASTIBE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNX"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "47583152",
      "display" : "ANCILLEG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "48574038",
      "display" : "EZETIMIBE E ATORVASTATINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "48444107",
      "display" : "EZEVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49746100",
      "display" : "TOVASTIBE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "48444145",
      "display" : "EZEVAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LSJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49746148",
      "display" : "TOVASTIBE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LSJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49976018",
      "display" : "EZETIMIBE E ATORVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNM"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49542018",
      "display" : "HIMAVAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNM"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49976032",
      "display" : "EZETIMIBE E ATORVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNX"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49542020",
      "display" : "HIMAVAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LNX"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49976071",
      "display" : "EZETIMIBE E ATORVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49542032",
      "display" : "HIMAVAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KGQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "49976119",
      "display" : "EZETIMIBE E ATORVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LSJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA05"
        }
      ]
    },
    {
      "code" : "46223018",
      "display" : "AMISITELA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "48258026",
      "display" : "EZETIMIBE E SIMVASTATINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "45909013",
      "display" : "EZETIMIBE E SIMVASTATINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "46952026",
      "display" : "EZETIMIBE E SIMVASTATINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "46655027",
      "display" : "EZETIMIBE E SIMVASTATINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44602011",
      "display" : "EZETIMIBE E SIMVASTATINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44609028",
      "display" : "EZETIMIBE E SIMVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44787036",
      "display" : "EZETIMIBE E SIMVASTATINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "43413032",
      "display" : "EZETIMIBE E SIMVASTATINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44781033",
      "display" : "EZETIMIBE E SIMVASTATINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44087017",
      "display" : "EZETIMIBE E SIMVASTATINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "46167019",
      "display" : "EZETIMIBE E SIMVASTATINA TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "45711037",
      "display" : "EZETIMIBE E SIMVASTATINA TEVA B.V.",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "47147018",
      "display" : "EZETIMIBE E SIMVASTATINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "36678100",
      "display" : "GOLTOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "36679064",
      "display" : "INEGY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44605018",
      "display" : "STATICOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "36690067",
      "display" : "VYTORIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44606010",
      "display" : "ZESTAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "45000041",
      "display" : "ZEVISTAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "46223020",
      "display" : "AMISITELA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "48258065",
      "display" : "EZETIMIBE E SIMVASTATINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "45909025",
      "display" : "EZETIMIBE E SIMVASTATINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "46952065",
      "display" : "EZETIMIBE E SIMVASTATINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "46655078",
      "display" : "EZETIMIBE E SIMVASTATINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44602035",
      "display" : "EZETIMIBE E SIMVASTATINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44609093",
      "display" : "EZETIMIBE E SIMVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44787113",
      "display" : "EZETIMIBE E SIMVASTATINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "43413119",
      "display" : "EZETIMIBE E SIMVASTATINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44781173",
      "display" : "EZETIMIBE E SIMVASTATINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44087029",
      "display" : "EZETIMIBE E SIMVASTATINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "46167033",
      "display" : "EZETIMIBE E SIMVASTATINA TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "45711090",
      "display" : "EZETIMIBE E SIMVASTATINA TEVA B.V.",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "47147044",
      "display" : "EZETIMIBE E SIMVASTATINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "36678213",
      "display" : "GOLTOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "36679215",
      "display" : "INEGY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44605032",
      "display" : "STATICOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "36690218",
      "display" : "VYTORIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44606034",
      "display" : "ZESTAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "45000054",
      "display" : "ZEVISTAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "48258127",
      "display" : "EZETIMIBE E SIMVASTATINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "45909037",
      "display" : "EZETIMIBE E SIMVASTATINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "46952127",
      "display" : "EZETIMIBE E SIMVASTATINA ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "46655130",
      "display" : "EZETIMIBE E SIMVASTATINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44602050",
      "display" : "EZETIMIBE E SIMVASTATINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44609168",
      "display" : "EZETIMIBE E SIMVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44787190",
      "display" : "EZETIMIBE E SIMVASTATINA KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "43413246",
      "display" : "EZETIMIBE E SIMVASTATINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44781300",
      "display" : "EZETIMIBE E SIMVASTATINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44087031",
      "display" : "EZETIMIBE E SIMVASTATINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "45711177",
      "display" : "EZETIMIBE E SIMVASTATINA TEVA B.V.",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "47147071",
      "display" : "EZETIMIBE E SIMVASTATINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "36678365",
      "display" : "GOLTOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "36679367",
      "display" : "INEGY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44605057",
      "display" : "STATICOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "36690360",
      "display" : "VYTORIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "44606059",
      "display" : "ZESTAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10BA02"
        }
      ]
    },
    {
      "code" : "39252034",
      "display" : "FAMCICLOVIR MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "39356011",
      "display" : "FAMCICLOVIR PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "38106112",
      "display" : "FAMCICLOVIR TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "29172018",
      "display" : "FAMVIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5A"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "39428026",
      "display" : "COIRGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "39252085",
      "display" : "FAMCICLOVIR MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "39356023",
      "display" : "FAMCICLOVIR PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "38106213",
      "display" : "FAMCICLOVIR TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "29172057",
      "display" : "FAMVIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "39432024",
      "display" : "MACIVIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "39431022",
      "display" : "VILACIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E5B"
        },
        {
          "code" : "ATC",
          "valueCode" : "J05AB09"
        }
      ]
    },
    {
      "code" : "39538032",
      "display" : "ADENURIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45367075",
      "display" : "ALPHABUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47825183",
      "display" : "DYMAURIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45560024",
      "display" : "FEBUXEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45988072",
      "display" : "FEBUXOSTAT ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47005083",
      "display" : "FEBUXOSTAT ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "46043168",
      "display" : "FEBUXOSTAT AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45412044",
      "display" : "FEBUXOSTAT DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45877065",
      "display" : "FEBUXOSTAT EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47770060",
      "display" : "FEBUXOSTAT KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45479159",
      "display" : "FEBUXOSTAT MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45391202",
      "display" : "FEBUXOSTAT SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "44976088",
      "display" : "FEBUXOSTAT TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47082084",
      "display" : "FEBUXOSTAT ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "46770044",
      "display" : "GAUTI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45559022",
      "display" : "GOTTART",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47957042",
      "display" : "URIQUID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPA"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "39538018",
      "display" : "ADENURIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45367036",
      "display" : "ALPHABUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45564010",
      "display" : "ARBUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47825031",
      "display" : "DYMAURIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45560012",
      "display" : "FEBUXEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45988021",
      "display" : "FEBUXOSTAT ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47005057",
      "display" : "FEBUXOSTAT ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "46043028",
      "display" : "FEBUXOSTAT AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45412020",
      "display" : "FEBUXOSTAT DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45877026",
      "display" : "FEBUXOSTAT EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47770021",
      "display" : "FEBUXOSTAT KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45479072",
      "display" : "FEBUXOSTAT MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45366034",
      "display" : "FEBUXOSTAT PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45391087",
      "display" : "FEBUXOSTAT SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "46424026",
      "display" : "FEBUXOSTAT TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "44976025",
      "display" : "FEBUXOSTAT TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47082021",
      "display" : "FEBUXOSTAT ZENTIVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "46770020",
      "display" : "GAUTI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "45559010",
      "display" : "GOTTART",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "47957028",
      "display" : "URIQUID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LPB"
        },
        {
          "code" : "ATC",
          "valueCode" : "M04AA03"
        }
      ]
    },
    {
      "code" : "38623106",
      "display" : "FELODIPINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "38527053",
      "display" : "FELODIPINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "37565241",
      "display" : "FELODIPINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "37168248",
      "display" : "FELODIPINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "28162030",
      "display" : "PLENDIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "27372022",
      "display" : "PREVEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "38623031",
      "display" : "FELODIPINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "38527026",
      "display" : "FELODIPINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "37565049",
      "display" : "FELODIPINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "37168046",
      "display" : "FELODIPINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "28162042",
      "display" : "PLENDIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "27372010",
      "display" : "PREVEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EBB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C08CA02"
        }
      ]
    },
    {
      "code" : "36054017",
      "display" : "FENOFIBRATO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB05"
        }
      ]
    },
    {
      "code" : "33557036",
      "display" : "FENOFIBRATO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB05"
        }
      ]
    },
    {
      "code" : "28590014",
      "display" : "FULCRO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB05"
        }
      ]
    },
    {
      "code" : "29257019",
      "display" : "LIPSIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB05"
        }
      ]
    },
    {
      "code" : "41071046",
      "display" : "FENOFIBRATO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB05"
        }
      ]
    },
    {
      "code" : "43837018",
      "display" : "FENOFIBRATO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB05"
        }
      ]
    },
    {
      "code" : "35928151",
      "display" : "FULCROSUPRA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB05"
        }
      ]
    },
    {
      "code" : "37160049",
      "display" : "LIPERIAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB05"
        }
      ]
    },
    {
      "code" : "48270019",
      "display" : "DOGETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIF"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "49018029",
      "display" : "SUBLIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIF"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "48270033",
      "display" : "DOGETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "49018056",
      "display" : "SUBLIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "48270058",
      "display" : "DOGETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIM"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "49018070",
      "display" : "SUBLIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIM"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "48270072",
      "display" : "DOGETIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIV"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "49018106",
      "display" : "SUBLIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIV"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660027",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGH"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963020",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGH"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660041",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGI"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963044",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGI"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660066",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963069",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660080",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGK"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963083",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGK"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660104",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGL"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963107",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LGL"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39014206",
      "display" : "ALGHEDON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CID"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "43518051",
      "display" : "DURFENTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CID"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "29212089",
      "display" : "DUROGESIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CID"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37563133",
      "display" : "FENPATCH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CID"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39359043",
      "display" : "FENTALGON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CID"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37609132",
      "display" : "FENTANIL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CID"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38407223",
      "display" : "FENTICER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CID"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39784588",
      "display" : "FENVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CID"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37405228",
      "display" : "MATRIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CID"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39014269",
      "display" : "ALGHEDON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIE"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "43518012",
      "display" : "DURFENTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIE"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "29212091",
      "display" : "DUROGESIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIE"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37563222",
      "display" : "FENPATCH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIE"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37405026",
      "display" : "MATRIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIE"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39014028",
      "display" : "ALGHEDON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "43518024",
      "display" : "DURFENTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "29212053",
      "display" : "DUROGESIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37563018",
      "display" : "FENPATCH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39359017",
      "display" : "FENTALGON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37609017",
      "display" : "FENTANIL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38407019",
      "display" : "FENTICER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39784020",
      "display" : "FENVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37405077",
      "display" : "MATRIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39014081",
      "display" : "ALGHEDON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "43518036",
      "display" : "DURFENTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "29212065",
      "display" : "DUROGESIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37563057",
      "display" : "FENPATCH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39359029",
      "display" : "FENTALGON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37609056",
      "display" : "FENTANIL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38407084",
      "display" : "FENTICER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39784261",
      "display" : "FENVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37405127",
      "display" : "MATRIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39014143",
      "display" : "ALGHEDON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "43518048",
      "display" : "DURFENTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "29212077",
      "display" : "DUROGESIC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37563095",
      "display" : "FENPATCH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39359031",
      "display" : "FENTALGON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37609094",
      "display" : "FENTANIL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38407159",
      "display" : "FENTICER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "39784347",
      "display" : "FENVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "37405178",
      "display" : "MATRIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIC"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660015",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CII"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963018",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CII"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47697014",
      "display" : "FENTANIL ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CII"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660039",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIU"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963032",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIU"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47697038",
      "display" : "FENTANIL ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIU"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660054",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIW"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963057",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIW"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47697053",
      "display" : "FENTANIL ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CIW"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660078",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CI1"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963071",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CI1"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47697077",
      "display" : "FENTANIL ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CI1"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "38660092",
      "display" : "EFFENTORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CI5"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47963095",
      "display" : "FENROO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CI5"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "47697091",
      "display" : "FENTANIL ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CI5"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02AB03"
        }
      ]
    },
    {
      "code" : "26689051",
      "display" : "CROMATONFERRO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03AA03"
        }
      ]
    },
    {
      "code" : "16443071",
      "display" : "FERRO COMPLEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03AA03"
        }
      ]
    },
    {
      "code" : "35366018",
      "display" : "FERRO GLUCONATO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03AA03"
        }
      ]
    },
    {
      "code" : "34532010",
      "display" : "FERROGYN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03AA03"
        }
      ]
    },
    {
      "code" : "34924023",
      "display" : "GLOROS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03AA03"
        }
      ]
    },
    {
      "code" : "27731013",
      "display" : "LOSFERRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03AA03"
        }
      ]
    },
    {
      "code" : "34453011",
      "display" : "PRONTOFERRO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "ARA"
        },
        {
          "code" : "ATC",
          "valueCode" : "B03AA03"
        }
      ]
    },
    {
      "code" : "38223044",
      "display" : "FEXOFENADINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX26"
        }
      ]
    },
    {
      "code" : "33304078",
      "display" : "FEXOFENADINA OPELLA HEALTHCARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX26"
        }
      ]
    },
    {
      "code" : "38229047",
      "display" : "FIXODIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX26"
        }
      ]
    },
    {
      "code" : "33303330",
      "display" : "TELFAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX26"
        }
      ]
    },
    {
      "code" : "38223121",
      "display" : "FEXOFENADINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX26"
        }
      ]
    },
    {
      "code" : "33304080",
      "display" : "FEXOFENADINA OPELLA HEALTHCARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX26"
        }
      ]
    },
    {
      "code" : "38229124",
      "display" : "FIXODIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX26"
        }
      ]
    },
    {
      "code" : "33303417",
      "display" : "TELFAST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R06AX26"
        }
      ]
    },
    {
      "code" : "38410015",
      "display" : "ASTERID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38414013",
      "display" : "FINASTERIDE ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "39595071",
      "display" : "FINASTERIDE AHCL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "39680018",
      "display" : "FINASTERIDE ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38160014",
      "display" : "FINASTERIDE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "39905017",
      "display" : "FINASTERIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38415016",
      "display" : "FINASTERIDE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "37837022",
      "display" : "FINASTERIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38412019",
      "display" : "FINASTERIDE IPSO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "39485014",
      "display" : "FINASTERIDE MYLAN ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "43495098",
      "display" : "FINASTERIDE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "37717028",
      "display" : "FINASTERIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "37963016",
      "display" : "FINASTERIDE SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38829026",
      "display" : "FINASTERIDE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38791024",
      "display" : "FINASTERIDE TEVA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "37722244",
      "display" : "FINASTERIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "28309019",
      "display" : "FINASTID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "39417011",
      "display" : "FINEDOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38413011",
      "display" : "FINESTAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "28371019",
      "display" : "GENAPROST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38894010",
      "display" : "ORMICTON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "28308017",
      "display" : "PROSCAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "28356018",
      "display" : "PROSTIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38411017",
      "display" : "RIDESTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38670117",
      "display" : "SITAS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38443014",
      "display" : "STECUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "39681010",
      "display" : "TERIP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38410027",
      "display" : "ASTERID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KVL"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "38415028",
      "display" : "FINASTERIDE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KVL"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "37837059",
      "display" : "FINASTERIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KVL"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "39485026",
      "display" : "FINASTERIDE MYLAN ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KVL"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "43495124",
      "display" : "FINASTERIDE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "KVL"
        },
        {
          "code" : "ATC",
          "valueCode" : "G04CB01"
        }
      ]
    },
    {
      "code" : "25728015",
      "display" : "ALMARYTM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42225019",
      "display" : "FLECAINIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "43544016",
      "display" : "FLECAINIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "46041063",
      "display" : "FLECAINIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "37415015",
      "display" : "FLECAINIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "38100018",
      "display" : "FLECAINIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DHA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42225033",
      "display" : "FLECAINIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LFQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "37415039",
      "display" : "FLECAINIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LFQ"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42864049",
      "display" : "FLEIDERINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42854048",
      "display" : "FREQUIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDD"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42864064",
      "display" : "FLEIDERINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42854063",
      "display" : "FREQUIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDE"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42864088",
      "display" : "FLEIDERINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42854087",
      "display" : "FREQUIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDF"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42864025",
      "display" : "FLEIDERINA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "42854024",
      "display" : "FREQUIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JDC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01BC04"
        }
      ]
    },
    {
      "code" : "37540010",
      "display" : "ALOZOF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37688025",
      "display" : "AVIFLUCOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "47327010",
      "display" : "AZONAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37235052",
      "display" : "CANACID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37539018",
      "display" : "CRINOZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "27267044",
      "display" : "DIFLUCAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37928013",
      "display" : "DIZOLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "27268046",
      "display" : "ELAZOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37931019",
      "display" : "FLUCONAZOLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "40916049",
      "display" : "FLUCONAZOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37864016",
      "display" : "FLUCONAZOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "41353273",
      "display" : "FLUCONAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37879107",
      "display" : "FLUCONAZOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "36904213",
      "display" : "FLUCONAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37343148",
      "display" : "FLUCONAZOLO HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "38646016",
      "display" : "FLUCONAZOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37672021",
      "display" : "FLUCONAZOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37394095",
      "display" : "FLUCONAZOLO RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37380110",
      "display" : "FLUCONAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37900026",
      "display" : "FLUCONAZOLO SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37492117",
      "display" : "FLUCONAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37238058",
      "display" : "FLUMICON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37649011",
      "display" : "FLUMOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37743010",
      "display" : "FLUORES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37810013",
      "display" : "FUNGUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37236054",
      "display" : "GEMIFLUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37853013",
      "display" : "KLAIDER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37237056",
      "display" : "LEFUNZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37691019",
      "display" : "LUCANDIOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37658022",
      "display" : "MICONIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37673023",
      "display" : "MUKES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37249051",
      "display" : "RIFLAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37901016",
      "display" : "TEDIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37902018",
      "display" : "TRIMIKOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37766019",
      "display" : "WINCH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37234059",
      "display" : "ZAMIZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37543016",
      "display" : "ZERFUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37662018",
      "display" : "ZOLODER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37540022",
      "display" : "ALOZOF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "47327022",
      "display" : "AZONAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37539020",
      "display" : "CRINOZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "45623028",
      "display" : "DIFLUCAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "45623016",
      "display" : "DIFLUCAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "27267020",
      "display" : "DIFLUCAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37928025",
      "display" : "DIZOLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "27268022",
      "display" : "ELAZOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37931021",
      "display" : "FLUCONAZOLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "40916114",
      "display" : "FLUCONAZOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37864028",
      "display" : "FLUCONAZOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "41353400",
      "display" : "FLUCONAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37879172",
      "display" : "FLUCONAZOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "36904326",
      "display" : "FLUCONAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37343213",
      "display" : "FLUCONAZOLO HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "38646028",
      "display" : "FLUCONAZOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37672033",
      "display" : "FLUCONAZOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37394158",
      "display" : "FLUCONAZOLO RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37380298",
      "display" : "FLUCONAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37900014",
      "display" : "FLUCONAZOLO SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "43055021",
      "display" : "FLUCONAZOLO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37492129",
      "display" : "FLUCONAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "38418036",
      "display" : "FLUCOSTENOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37238060",
      "display" : "FLUMICON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37649023",
      "display" : "FLUMOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37743022",
      "display" : "FLUORES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37810025",
      "display" : "FUNGUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37236066",
      "display" : "GEMIFLUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37853025",
      "display" : "KLAIDER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37237068",
      "display" : "LEFUNZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37691021",
      "display" : "LUCANDIOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37658034",
      "display" : "MICONIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37673035",
      "display" : "MUKES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37249063",
      "display" : "RIFLAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37901028",
      "display" : "TEDIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37902020",
      "display" : "TRIMIKOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37766021",
      "display" : "WINCH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37543028",
      "display" : "ZERFUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37662020",
      "display" : "ZOLODER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCB"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37688049",
      "display" : "AVIFLUCOX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "47327034",
      "display" : "AZONAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37235076",
      "display" : "CANACID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37539032",
      "display" : "CRINOZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "27267095",
      "display" : "DIFLUCAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37928037",
      "display" : "DIZOLO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "27268097",
      "display" : "ELAZOR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37931033",
      "display" : "FLUCONAZOLO ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "40916140",
      "display" : "FLUCONAZOLO ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37864030",
      "display" : "FLUCONAZOLO ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "41353626",
      "display" : "FLUCONAZOLO AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37879234",
      "display" : "FLUCONAZOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "36904504",
      "display" : "FLUCONAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37343225",
      "display" : "FLUCONAZOLO HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "38646030",
      "display" : "FLUCONAZOLO MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37672045",
      "display" : "FLUCONAZOLO PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37394172",
      "display" : "FLUCONAZOLO RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37380197",
      "display" : "FLUCONAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37900038",
      "display" : "FLUCONAZOLO SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "43055033",
      "display" : "FLUCONAZOLO TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37492081",
      "display" : "FLUCONAZOLO ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37268036",
      "display" : "FLUKIMEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37238072",
      "display" : "FLUMICON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37649035",
      "display" : "FLUMOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37810037",
      "display" : "FUNGUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37236078",
      "display" : "GEMIFLUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37853037",
      "display" : "KLAIDER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37237070",
      "display" : "LEFUNZOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37691033",
      "display" : "LUCANDIOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37658046",
      "display" : "MICONIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37673047",
      "display" : "MUKES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37249075",
      "display" : "RIFLAX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37901030",
      "display" : "TEDIM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37902032",
      "display" : "TRIMIKOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37766033",
      "display" : "WINCH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37543030",
      "display" : "ZERFUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "37662032",
      "display" : "ZOLODER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "DCC"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC01"
        }
      ]
    },
    {
      "code" : "34494029",
      "display" : "ASMAFLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "36321026",
      "display" : "ELIOSID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34980021",
      "display" : "EUROFLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "35069032",
      "display" : "FLUNITOP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "35063039",
      "display" : "PLAUDIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "33339045",
      "display" : "PULMIST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87C"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34493027",
      "display" : "AERFLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34494031",
      "display" : "ASMAFLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "36371021",
      "display" : "ASTIAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "36611010",
      "display" : "CHARLYN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "35354024",
      "display" : "CITIFLUX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "36321014",
      "display" : "ELIOSID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34980019",
      "display" : "EUROFLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "35351028",
      "display" : "LEVONIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "35063027",
      "display" : "PLAUDIT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "33339033",
      "display" : "PULMIST",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87D"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34493015",
      "display" : "AERFLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34869014",
      "display" : "AEROLID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34494017",
      "display" : "ASMAFLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34988028",
      "display" : "ASSOLID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34699013",
      "display" : "DORICOFLU",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34968014",
      "display" : "FLUNIGAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "35148016",
      "display" : "FLUNISOLIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "35352032",
      "display" : "FLUNISOLIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "35351030",
      "display" : "LEVONIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "26886059",
      "display" : "LUNIBRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "34803015",
      "display" : "NEBULCORT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "87B"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA03"
        }
      ]
    },
    {
      "code" : "33555018",
      "display" : "FLUOXETINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "34207011",
      "display" : "FLUOXETINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "34667028",
      "display" : "FLUOXETINA EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "34850026",
      "display" : "FLUOXETINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "25959040",
      "display" : "FLUOXEREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "25959053",
      "display" : "FLUOXEREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "41111042",
      "display" : "FLUOXETINA ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "35033024",
      "display" : "FLUOXETINA ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "33555032",
      "display" : "FLUOXETINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "34207047",
      "display" : "FLUOXETINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "34667042",
      "display" : "FLUOXETINA EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "34917043",
      "display" : "FLUOXETINA FIDIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "34917056",
      "display" : "FLUOXETINA FIDIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "37053105",
      "display" : "FLUOXETINA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "35301136",
      "display" : "FLUOXETINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "34850053",
      "display" : "FLUOXETINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "33569056",
      "display" : "FLUOXETINA SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "39430018",
      "display" : "PROZAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "25970043",
      "display" : "PROZAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "34974042",
      "display" : "XEREDIEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35D"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "25959026",
      "display" : "FLUOXEREN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "33555020",
      "display" : "FLUOXETINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "35B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB03"
        }
      ]
    },
    {
      "code" : "28667095",
      "display" : "FLIXOTIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "M8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA05"
        }
      ]
    },
    {
      "code" : "28675179",
      "display" : "FLUSPIRAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "M8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA05"
        }
      ]
    },
    {
      "code" : "43082015",
      "display" : "FLUTICASONE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "M8A"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA05"
        }
      ]
    },
    {
      "code" : "28667107",
      "display" : "FLIXOTIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "M8F"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA05"
        }
      ]
    },
    {
      "code" : "28675181",
      "display" : "FLUSPIRAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "M8F"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA05"
        }
      ]
    },
    {
      "code" : "43082027",
      "display" : "FLUTICASONE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "M8F"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BA05"
        }
      ]
    },
    {
      "code" : "29014014",
      "display" : "FLIXODERM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "M8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "D07AC17"
        }
      ]
    },
    {
      "code" : "39738012",
      "display" : "FLUTICREM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "M8C"
        },
        {
          "code" : "ATC",
          "valueCode" : "D07AC17"
        }
      ]
    },
    {
      "code" : "38602037",
      "display" : "FLUVASTATINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA04"
        }
      ]
    },
    {
      "code" : "38580027",
      "display" : "FLUVASTATINA DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA04"
        }
      ]
    },
    {
      "code" : "38582021",
      "display" : "FLUVASTATINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA04"
        }
      ]
    },
    {
      "code" : "38659049",
      "display" : "FLUVASTATINA MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA04"
        }
      ]
    },
    {
      "code" : "38581029",
      "display" : "FLUVASTATINA TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA04"
        }
      ]
    },
    {
      "code" : "38831032",
      "display" : "FLUVASTATINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA04"
        }
      ]
    },
    {
      "code" : "29163033",
      "display" : "LESCOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA04"
        }
      ]
    },
    {
      "code" : "29199041",
      "display" : "LIPAXAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E9A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AA04"
        }
      ]
    },
    {
      "code" : "26104048",
      "display" : "DUMIROX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB08"
        }
      ]
    },
    {
      "code" : "27045044",
      "display" : "FEVARIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB08"
        }
      ]
    },
    {
      "code" : "34669174",
      "display" : "FLUVOXAMINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB08"
        }
      ]
    },
    {
      "code" : "26102044",
      "display" : "MAVERAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB08"
        }
      ]
    },
    {
      "code" : "26104036",
      "display" : "DUMIROX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB08"
        }
      ]
    },
    {
      "code" : "27045032",
      "display" : "FEVARIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB08"
        }
      ]
    },
    {
      "code" : "34669059",
      "display" : "FLUVOXAMINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB08"
        }
      ]
    },
    {
      "code" : "26102032",
      "display" : "MAVERAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06AB08"
        }
      ]
    },
    {
      "code" : "35791058",
      "display" : "ATIMOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CR8"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "35793052",
      "display" : "LIFEROL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CR8"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "36218028",
      "display" : "FOROTAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CR9"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "36213027",
      "display" : "FORTASINT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CR9"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "36210021",
      "display" : "LEVOVENT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CR9"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "27660075",
      "display" : "FORADIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "36215010",
      "display" : "FORMOTEROLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "37316066",
      "display" : "FORMOTEROLO VIATRIS NOVOLIZER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "36213015",
      "display" : "FORTASINT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "36939066",
      "display" : "KUROVENT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "36210019",
      "display" : "LEVOVENT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "33312024",
      "display" : "OXIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CRA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03AC13"
        }
      ]
    },
    {
      "code" : "37943026",
      "display" : "BERNY",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "41355025",
      "display" : "DANIFOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "37280043",
      "display" : "FOSFOMICINA ARISTO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "37995026",
      "display" : "FOSFOMICINA AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "38516023",
      "display" : "FOSFOMICINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "38040022",
      "display" : "FOSFOMICINA EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "37994023",
      "display" : "FOSFOMICINA MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "38597023",
      "display" : "FOSFOMICINA PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "37993021",
      "display" : "FOSFOMICINA RATIOPHARM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "37273048",
      "display" : "FOSFOMICINA SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "37272046",
      "display" : "FOSFOMICINA SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "37031046",
      "display" : "FOSFOMICINA ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "42196028",
      "display" : "INFEUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "42195026",
      "display" : "INTERFOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "25680024",
      "display" : "MONURIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "38556027",
      "display" : "UROFOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J01XX01"
        }
      ]
    },
    {
      "code" : "27735024",
      "display" : "ELITEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA09"
        }
      ]
    },
    {
      "code" : "41340175",
      "display" : "FOSINOPRIL AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA09"
        }
      ]
    },
    {
      "code" : "38074175",
      "display" : "FOSINOPRIL DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA09"
        }
      ]
    },
    {
      "code" : "37594088",
      "display" : "FOSINOPRIL TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA09"
        }
      ]
    },
    {
      "code" : "37462280",
      "display" : "FOSINOPRIL ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA09"
        }
      ]
    },
    {
      "code" : "27747029",
      "display" : "FOSIPRES",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA09"
        }
      ]
    },
    {
      "code" : "27824022",
      "display" : "TENSOGARD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EEA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09AA09"
        }
      ]
    },
    {
      "code" : "29020017",
      "display" : "FOSICOMBI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E0A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA09"
        }
      ]
    },
    {
      "code" : "39714062",
      "display" : "FOSINOPRIL IDROCLOROTIAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E0A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA09"
        }
      ]
    },
    {
      "code" : "37832060",
      "display" : "FOSINOPRIL IDROCLOROTIAZIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E0A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA09"
        }
      ]
    },
    {
      "code" : "29004013",
      "display" : "TENSOZIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "E0A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09BA09"
        }
      ]
    },
    {
      "code" : "35673021",
      "display" : "AURADOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC07"
        }
      ]
    },
    {
      "code" : "35674023",
      "display" : "RILAMIG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MDA"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC07"
        }
      ]
    },
    {
      "code" : "35673033",
      "display" : "AURADOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC07"
        }
      ]
    },
    {
      "code" : "42941056",
      "display" : "FROVATRIPTAN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC07"
        }
      ]
    },
    {
      "code" : "42911053",
      "display" : "FROVATRIPTAN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC07"
        }
      ]
    },
    {
      "code" : "42611020",
      "display" : "FROVATRIPTAN MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC07"
        }
      ]
    },
    {
      "code" : "42910051",
      "display" : "FROVATRIPTAN TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC07"
        }
      ]
    },
    {
      "code" : "35674035",
      "display" : "RILAMIG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MDB"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02CC07"
        }
      ]
    },
    {
      "code" : "35213014",
      "display" : "FUROSEMIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "32898013",
      "display" : "FUROSEMIDE HEXAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "35211010",
      "display" : "FUROSEMIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "40642011",
      "display" : "FUROSEMIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "23993037",
      "display" : "LASIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "46015018",
      "display" : "FUROSEMIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "35213040",
      "display" : "FUROSEMIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "30210013",
      "display" : "FUROSEMIDE L.F.M.",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "35211046",
      "display" : "FUROSEMIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "35206034",
      "display" : "FUROSEMIDE TEVA GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "23993013",
      "display" : "LASIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "89D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "30210025",
      "display" : "FUROSEMIDE L.F.M.",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LBS"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "35211109",
      "display" : "FUROSEMIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "LBS"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03CA01"
        }
      ]
    },
    {
      "code" : "46685119",
      "display" : "GABANEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36519039",
      "display" : "GABAPENTIN ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36009037",
      "display" : "GABAPENTIN ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36574034",
      "display" : "GABAPENTIN ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "40566198",
      "display" : "GABAPENTIN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "35944038",
      "display" : "GABAPENTIN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36131035",
      "display" : "GABAPENTIN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38242184",
      "display" : "GABAPENTIN HEXAL A/S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36607190",
      "display" : "GABAPENTIN MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36190039",
      "display" : "GABAPENTIN PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38547232",
      "display" : "GABAPENTIN SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38346159",
      "display" : "GABAPENTIN SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38816118",
      "display" : "GABAPENTIN TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36698468",
      "display" : "GABAPENTIN TEVA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36777365",
      "display" : "GABAPENTIN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "42166025",
      "display" : "NEURONTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "28740037",
      "display" : "NEURONTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "46685020",
      "display" : "GABANEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36519015",
      "display" : "GABAPENTIN ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36009013",
      "display" : "GABAPENTIN ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "40566046",
      "display" : "GABAPENTIN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "35944014",
      "display" : "GABAPENTIN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36131011",
      "display" : "GABAPENTIN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38242032",
      "display" : "GABAPENTIN HEXAL A/S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36607048",
      "display" : "GABAPENTIN MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36190015",
      "display" : "GABAPENTIN PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38547055",
      "display" : "GABAPENTIN SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38346021",
      "display" : "GABAPENTIN SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38816169",
      "display" : "GABAPENTIN TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36698037",
      "display" : "GABAPENTIN TEVA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36777047",
      "display" : "GABAPENTIN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "28740013",
      "display" : "NEURONTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "46685071",
      "display" : "GABANEX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36519027",
      "display" : "GABAPENTIN ABC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36009025",
      "display" : "GABAPENTIN ALMUS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36574022",
      "display" : "GABAPENTIN ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "40566123",
      "display" : "GABAPENTIN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "35944026",
      "display" : "GABAPENTIN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36131023",
      "display" : "GABAPENTIN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38242107",
      "display" : "GABAPENTIN HEXAL A/S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36607125",
      "display" : "GABAPENTIN MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36190027",
      "display" : "GABAPENTIN PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38547143",
      "display" : "GABAPENTIN SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38346060",
      "display" : "GABAPENTIN SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "38816171",
      "display" : "GABAPENTIN TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36698189",
      "display" : "GABAPENTIN TEVA PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "36777213",
      "display" : "GABAPENTIN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "42166013",
      "display" : "NEURONTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "28740025",
      "display" : "NEURONTIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N02BF01"
        }
      ]
    },
    {
      "code" : "39889314",
      "display" : "GALNORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA04"
        }
      ]
    },
    {
      "code" : "34752131",
      "display" : "REMINYL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G1B"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA04"
        }
      ]
    },
    {
      "code" : "39889504",
      "display" : "GALNORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA04"
        }
      ]
    },
    {
      "code" : "34752170",
      "display" : "REMINYL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G1C"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA04"
        }
      ]
    },
    {
      "code" : "39889136",
      "display" : "GALNORA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA04"
        }
      ]
    },
    {
      "code" : "34752117",
      "display" : "REMINYL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "G1A"
        },
        {
          "code" : "ATC",
          "valueCode" : "N06DA04"
        }
      ]
    },
    {
      "code" : "34080022",
      "display" : "GEMFIBROZIL DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "15A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB04"
        }
      ]
    },
    {
      "code" : "29512011",
      "display" : "GEMFIBROZIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "15A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB04"
        }
      ]
    },
    {
      "code" : "26737039",
      "display" : "GENLIP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "15A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB04"
        }
      ]
    },
    {
      "code" : "25445053",
      "display" : "LOPID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "15A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB04"
        }
      ]
    },
    {
      "code" : "34080010",
      "display" : "GEMFIBROZIL DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "15B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB04"
        }
      ]
    },
    {
      "code" : "29512023",
      "display" : "GEMFIBROZIL EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "15B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB04"
        }
      ]
    },
    {
      "code" : "25445026",
      "display" : "LOPID",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "15B"
        },
        {
          "code" : "ATC",
          "valueCode" : "C10AB04"
        }
      ]
    },
    {
      "code" : "35418060",
      "display" : "COPAXONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "TUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L03AX13"
        }
      ]
    },
    {
      "code" : "45673023",
      "display" : "COPEMYLTRI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "TUB"
        },
        {
          "code" : "ATC",
          "valueCode" : "L03AX13"
        }
      ]
    },
    {
      "code" : "35418021",
      "display" : "COPAXONE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "TUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L03AX13"
        }
      ]
    },
    {
      "code" : "43860028",
      "display" : "COPEMYL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "TUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "L03AX13"
        }
      ]
    },
    {
      "code" : "45637016",
      "display" : "DIAMICRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "23404231",
      "display" : "DIAMICRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "35564222",
      "display" : "DRAMION",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "45026059",
      "display" : "GLEUKOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "49080029",
      "display" : "GLICLAZIDE DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "44754012",
      "display" : "GLICLAZIDE EG STADA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "39038195",
      "display" : "GLICLAZIDE KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "44076089",
      "display" : "GLICLAZIDE SANDOZ BV",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "44883066",
      "display" : "GLICLAZIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92C"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "31844018",
      "display" : "DIABREZIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "33363019",
      "display" : "GLICLAZIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "36528014",
      "display" : "GLICLAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "36282010",
      "display" : "GLICLAZIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "36643017",
      "display" : "GLICLAZIDE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "36376010",
      "display" : "GLICLAZIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92A"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "49694021",
      "display" : "DIAMICRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "50129016",
      "display" : "DIAMICRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "49694019",
      "display" : "DIAMICRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "45454016",
      "display" : "DIAMICRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "45630011",
      "display" : "DIAMICRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "45637028",
      "display" : "DIAMICRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "23404092",
      "display" : "DIAMICRON",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "35564083",
      "display" : "DRAMION",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "45026022",
      "display" : "GLEUKOS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "49080017",
      "display" : "GLICLAZIDE DOC GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "42462085",
      "display" : "GLICLAZIDE EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "39038070",
      "display" : "GLICLAZIDE KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "39038587",
      "display" : "GLICLAZIDE KRKA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "38469072",
      "display" : "GLICLAZIDE MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "43430038",
      "display" : "GLICLAZIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "38372076",
      "display" : "GLICLAZIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "42893014",
      "display" : "GLICLAZIDE ZENTIVA LAB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "42893038",
      "display" : "GLICLAZIDE ZENTIVA LAB",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "92B"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB09"
        }
      ]
    },
    {
      "code" : "32845012",
      "display" : "AMARYL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "39162060",
      "display" : "GLIMEPIRIDE ACCORD HEALTHCARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "45365020",
      "display" : "GLIMEPIRIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "36962037",
      "display" : "GLIMEPIRIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "38724249",
      "display" : "GLIMEPIRIDE SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "32117018",
      "display" : "SOLOSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "32845164",
      "display" : "AMARYL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "39162108",
      "display" : "GLIMEPIRIDE ACCORD HEALTHCARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "45365095",
      "display" : "GLIMEPIRIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "38724415",
      "display" : "GLIMEPIRIDE SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "32117160",
      "display" : "SOLOSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "32845226",
      "display" : "AMARYL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "39162146",
      "display" : "GLIMEPIRIDE ACCORD HEALTHCARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "45365160",
      "display" : "GLIMEPIRIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "38724581",
      "display" : "GLIMEPIRIDE SANDOZ GMBH",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "32117222",
      "display" : "SOLOSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CMC"
        },
        {
          "code" : "ATC",
          "valueCode" : "A10BB12"
        }
      ]
    },
    {
      "code" : "29863139",
      "display" : "GLUCOSIO GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93F"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30793020",
      "display" : "GLUCOSIO MONICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93F"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "29863255",
      "display" : "GLUCOSIO GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93J"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30793044",
      "display" : "GLUCOSIO MONICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93J"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "29863471",
      "display" : "GLUCOSIO GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93L"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30793069",
      "display" : "GLUCOSIO MONICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93L"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "29863014",
      "display" : "GLUCOSIO GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93A"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30793626",
      "display" : "GLUCOSIO MONICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93A"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30923128",
      "display" : "GLUCOSIO BAXTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93H"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "32387058",
      "display" : "GLUCOSIO BIOINDUSTRIA L.I.M.",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93H"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "33851080",
      "display" : "GLUCOSIO DIACO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93H"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "29863178",
      "display" : "GLUCOSIO GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93H"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30793158",
      "display" : "GLUCOSIO MONICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93H"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30672202",
      "display" : "GLUCOSIO SALF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93H"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30923039",
      "display" : "GLUCOSIO BAXTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93D"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "32387021",
      "display" : "GLUCOSIO BIOINDUSTRIA L.I.M.",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93D"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "33851039",
      "display" : "GLUCOSIO DIACO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93D"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "32183028",
      "display" : "GLUCOSIO EUROSPITAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93D"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30769032",
      "display" : "GLUCOSIO FRESENIUS KABI ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93D"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "29863053",
      "display" : "GLUCOSIO GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93D"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30793107",
      "display" : "GLUCOSIO MONICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93D"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30672152",
      "display" : "GLUCOSIO SALF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93D"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30923130",
      "display" : "GLUCOSIO BAXTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93I"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "32387060",
      "display" : "GLUCOSIO BIOINDUSTRIA L.I.M.",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93I"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "33851092",
      "display" : "GLUCOSIO DIACO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93I"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "32183055",
      "display" : "GLUCOSIO EUROSPITAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93I"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30769095",
      "display" : "GLUCOSIO FRESENIUS KABI ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93I"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "29863180",
      "display" : "GLUCOSIO GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93I"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30793160",
      "display" : "GLUCOSIO MONICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93I"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30672214",
      "display" : "GLUCOSIO SALF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93I"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30899049",
      "display" : "GLUCOSIO B.BRAUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30923041",
      "display" : "GLUCOSIO BAXTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "32387033",
      "display" : "GLUCOSIO BIOINDUSTRIA L.I.M.",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "33851041",
      "display" : "GLUCOSIO DIACO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "32183030",
      "display" : "GLUCOSIO EUROSPITAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30769044",
      "display" : "GLUCOSIO FRESENIUS KABI ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "29863065",
      "display" : "GLUCOSIO GALENICA SENESE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30793119",
      "display" : "GLUCOSIO MONICO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "30672164",
      "display" : "GLUCOSIO SALF",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "93E"
        },
        {
          "code" : "ATC",
          "valueCode" : "B05BA03"
        }
      ]
    },
    {
      "code" : "37950072",
      "display" : "GRANISETRON MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A04AA02"
        }
      ]
    },
    {
      "code" : "28093021",
      "display" : "KYTRIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A04AA02"
        }
      ]
    },
    {
      "code" : "46096018",
      "display" : "PANDIOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EFA"
        },
        {
          "code" : "ATC",
          "valueCode" : "A04AA02"
        }
      ]
    },
    {
      "code" : "37950223",
      "display" : "GRANISETRON MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A04AA02"
        }
      ]
    },
    {
      "code" : "28093084",
      "display" : "KYTRIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A04AA02"
        }
      ]
    },
    {
      "code" : "46096020",
      "display" : "PANDIOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "EFB"
        },
        {
          "code" : "ATC",
          "valueCode" : "A04AA02"
        }
      ]
    },
    {
      "code" : "16762015",
      "display" : "FULCIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "94A"
        },
        {
          "code" : "ATC",
          "valueCode" : "D01BA01"
        }
      ]
    },
    {
      "code" : "15642010",
      "display" : "GRISOVINA FP",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "94A"
        },
        {
          "code" : "ATC",
          "valueCode" : "D01BA01"
        }
      ]
    },
    {
      "code" : "49168014",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "50198011",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "41240033",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "22593204",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "39693039",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "45557016",
      "display" : "IBUPROFENE AUROBINDO PHARMA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43109026",
      "display" : "IBUPROFENE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "49150042",
      "display" : "ZEBUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95A"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43521018",
      "display" : "ALGOPIRINDOL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "41240058",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "39693041",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43890021",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "41746025",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "42859052",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "42859037",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43101017",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "42996013",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "42859013",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "22593216",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "22593103",
      "display" : "BRUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43525017",
      "display" : "IBUMAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "44042051",
      "display" : "IBUPROFENE ABC FARMACEUTICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "37029028",
      "display" : "IBUPROFENE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "40576011",
      "display" : "IBUPROFENE ANGELINI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "47553033",
      "display" : "IBUPROFENE ARISTO PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "45557028",
      "display" : "IBUPROFENE AUROBINDO PHARMA ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43109038",
      "display" : "IBUPROFENE DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "41312036",
      "display" : "IBUPROFENE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43834011",
      "display" : "IBUPROFENE EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43834023",
      "display" : "IBUPROFENE EG STADA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43526019",
      "display" : "IBUPROFENE FG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "43529015",
      "display" : "IBUPROFENE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "26916142",
      "display" : "SPIDIFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "49150117",
      "display" : "ZEBUFEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "95B"
        },
        {
          "code" : "ATC",
          "valueCode" : "M01AE01"
        }
      ]
    },
    {
      "code" : "15094016",
      "display" : "ESIDREX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "96A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03AA03"
        }
      ]
    },
    {
      "code" : "47245016",
      "display" : "IDROCLOROTIAZIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "96A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03AA03"
        }
      ]
    },
    {
      "code" : "46074011",
      "display" : "IDROSSICLOROCHINA DOC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "P01BA02"
        }
      ]
    },
    {
      "code" : "13967056",
      "display" : "PLAQUENIL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MUA"
        },
        {
          "code" : "ATC",
          "valueCode" : "P01BA02"
        }
      ]
    },
    {
      "code" : "46536076",
      "display" : "ILOPROST ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNS"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC11"
        }
      ]
    },
    {
      "code" : "36019091",
      "display" : "VENTAVIS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNS"
        },
        {
          "code" : "ATC",
          "valueCode" : "B01AC11"
        }
      ]
    },
    {
      "code" : "35372059",
      "display" : "GLIVEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "43760038",
      "display" : "IMANIVEC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "42867186",
      "display" : "IMATINIB ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "45053067",
      "display" : "IMATINIB DR. REDDY'S",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "43805047",
      "display" : "IMATINIB SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "43805050",
      "display" : "IMATINIB SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "43126046",
      "display" : "IMATINIB SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "42644310",
      "display" : "IMATINIB TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "BRZ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "42867287",
      "display" : "IMATINIB ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "42867200",
      "display" : "IMATINIB ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "42644183",
      "display" : "IMATINIB TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "JNJ"
        },
        {
          "code" : "ATC",
          "valueCode" : "L01EA01"
        }
      ]
    },
    {
      "code" : "34405011",
      "display" : "ALDARA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D06BB10"
        }
      ]
    },
    {
      "code" : "41393012",
      "display" : "IMUNOCARE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "MWA"
        },
        {
          "code" : "ATC",
          "valueCode" : "D06BB10"
        }
      ]
    },
    {
      "code" : "38708057",
      "display" : "INDAPAMIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "06C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03BA11"
        }
      ]
    },
    {
      "code" : "39505021",
      "display" : "INDAPAMIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "06C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03BA11"
        }
      ]
    },
    {
      "code" : "39463017",
      "display" : "INDAPAMIDE MYLAN GENERICS ITALIA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "06C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03BA11"
        }
      ]
    },
    {
      "code" : "24032031",
      "display" : "NATRILIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "06C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03BA11"
        }
      ]
    },
    {
      "code" : "33616020",
      "display" : "INDAPAMIDE MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "06A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03BA11"
        }
      ]
    },
    {
      "code" : "25154030",
      "display" : "INDAPAMIDE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "06A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03BA11"
        }
      ]
    },
    {
      "code" : "24150029",
      "display" : "IPAMIX",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "06A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03BA11"
        }
      ]
    },
    {
      "code" : "25686015",
      "display" : "MILLIBAR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "06A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03BA11"
        }
      ]
    },
    {
      "code" : "24666024",
      "display" : "PRESSURAL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "06A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C03BA11"
        }
      ]
    },
    {
      "code" : "24153052",
      "display" : "ATEM",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BB01"
        }
      ]
    },
    {
      "code" : "39465125",
      "display" : "IPRAXA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NIA"
        },
        {
          "code" : "ATC",
          "valueCode" : "R03BB01"
        }
      ]
    },
    {
      "code" : "40915098",
      "display" : "ABESART",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "33264045",
      "display" : "APROVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41666088",
      "display" : "IFIRMASTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41870092",
      "display" : "IRBESARTAN ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "42107019",
      "display" : "IRBESARTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40865065",
      "display" : "IRBESARTAN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40755086",
      "display" : "IRBESARTAN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40936027",
      "display" : "IRBESARTAN MACLEODS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41458175",
      "display" : "IRBESARTAN MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40836292",
      "display" : "IRBESARTAN SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40818128",
      "display" : "IRBESARTAN SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41139078",
      "display" : "IRBESARTAN TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41763160",
      "display" : "IRBESARTAN TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41974243",
      "display" : "IRBESARTAN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41888025",
      "display" : "IRBETENS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "33263043",
      "display" : "KARVEA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "39734013",
      "display" : "RABESAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "39735016",
      "display" : "RETENSIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40915163",
      "display" : "ABESART",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "33264072",
      "display" : "APROVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41666140",
      "display" : "IFIRMASTA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41870155",
      "display" : "IRBESARTAN ACCORD",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "42107045",
      "display" : "IRBESARTAN AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40865103",
      "display" : "IRBESARTAN DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40755148",
      "display" : "IRBESARTAN EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41458314",
      "display" : "IRBESARTAN MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40836684",
      "display" : "IRBESARTAN SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40818217",
      "display" : "IRBESARTAN SUN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41139128",
      "display" : "IRBESARTAN TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41763297",
      "display" : "IRBESARTAN TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41974130",
      "display" : "IRBESARTAN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41974306",
      "display" : "IRBESARTAN ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "41888037",
      "display" : "IRBETENS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "33263070",
      "display" : "KARVEA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "39734025",
      "display" : "RABESAT",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "39735028",
      "display" : "RETENSIR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NJB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09CA04"
        }
      ]
    },
    {
      "code" : "40951016",
      "display" : "COABESART",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "34191015",
      "display" : "COAPROVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41633025",
      "display" : "IFIRMACOMBI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "43503010",
      "display" : "IRBEDIUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40133074",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41243039",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40799025",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40664029",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42012017",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE MACLEODS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40973024",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "44893028",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41311123",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42224016",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42500025",
      "display" : "IRBESARTAN HYDROCLOROTIAZIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42500126",
      "display" : "IRBESARTAN HYDROCLOROTIAZIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41851054",
      "display" : "IRBESARTAN/IDROCLOROTIAZIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "34190013",
      "display" : "KARVEZIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41517020",
      "display" : "RATIPRED",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKA"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40951028",
      "display" : "COABESART",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "34191041",
      "display" : "COAPROVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41633102",
      "display" : "IFIRMACOMBI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "43503022",
      "display" : "IRBEDIUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40133062",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41243142",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40799064",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40664106",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42012029",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE MACLEODS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40973125",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41311592",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42224028",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42500076",
      "display" : "IRBESARTAN HYDROCLOROTIAZIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42500189",
      "display" : "IRBESARTAN HYDROCLOROTIAZIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41851294",
      "display" : "IRBESARTAN/IDROCLOROTIAZIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "34190049",
      "display" : "KARVEZIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41517044",
      "display" : "RATIPRED",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKB"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40951030",
      "display" : "COABESART",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "34191080",
      "display" : "COAPROVEL",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41633189",
      "display" : "IFIRMACOMBI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "43503034",
      "display" : "IRBEDIUR",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40133023",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE ALTER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41243256",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE AUROBINDO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40799102",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40664171",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42012031",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE MACLEODS PHARMA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "40973226",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE MYLAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "44893105",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE PENSA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41311325",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42224030",
      "display" : "IRBESARTAN E IDROCLOROTIAZIDE TECNIGEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "42500241",
      "display" : "IRBESARTAN HYDROCLOROTIAZIDE ZENTIVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41851534",
      "display" : "IRBESARTAN/IDROCLOROTIAZIDE TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "34190088",
      "display" : "KARVEZIDE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "41517069",
      "display" : "RATIPRED",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "NKC"
        },
        {
          "code" : "ATC",
          "valueCode" : "C09DA04"
        }
      ]
    },
    {
      "code" : "26888026",
      "display" : "ELAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "29558032",
      "display" : "ISOSORBIDE MONONITRATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "33684022",
      "display" : "ISOSORBIDE MONONITRATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "32025025",
      "display" : "ISOSORBIDE MONONITRATO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "25623012",
      "display" : "MONOCINQUE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "25200027",
      "display" : "MONOKET",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05D"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "26888038",
      "display" : "ELAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "29558018",
      "display" : "ISOSORBIDE MONONITRATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "32025049",
      "display" : "ISOSORBIDE MONONITRATO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "25623024",
      "display" : "MONOCINQUE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05A"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "26760013",
      "display" : "DURONITRIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05E"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "29558044",
      "display" : "ISOSORBIDE MONONITRATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05E"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "33684034",
      "display" : "ISOSORBIDE MONONITRATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05E"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "32025037",
      "display" : "ISOSORBIDE MONONITRATO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05E"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "25200041",
      "display" : "MONOKET",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05E"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "26888014",
      "display" : "ELAN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "25764010",
      "display" : "ISMO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "29558020",
      "display" : "ISOSORBIDE MONONITRATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "33684010",
      "display" : "ISOSORBIDE MONONITRATO",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "32025013",
      "display" : "ISOSORBIDE MONONITRATO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "25623051",
      "display" : "MONOCINQUE",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "25200015",
      "display" : "MONOKET",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "05C"
        },
        {
          "code" : "ATC",
          "valueCode" : "C01DA14"
        }
      ]
    },
    {
      "code" : "35258019",
      "display" : "AISOSKIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "41853045",
      "display" : "ISDIBEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "45513076",
      "display" : "ISODIFA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "37551025",
      "display" : "ISORIAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "36083020",
      "display" : "ISOTRETINOINA DIFA COOPER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "45046024",
      "display" : "NOIDAK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3A"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "35258021",
      "display" : "AISOSKIN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3B"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "41853072",
      "display" : "ISDIBEN",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3B"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "45513126",
      "display" : "ISODIFA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3B"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "37551076",
      "display" : "ISORIAC",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3B"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "36083071",
      "display" : "ISOTRETINOINA DIFA COOPER",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3B"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "45046087",
      "display" : "NOIDAK",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "C3B"
        },
        {
          "code" : "ATC",
          "valueCode" : "D10BA01"
        }
      ]
    },
    {
      "code" : "35874015",
      "display" : "ITRACONAZOLO DOC GENERICI",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC02"
        }
      ]
    },
    {
      "code" : "37080037",
      "display" : "ITRACONAZOLO EG",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC02"
        }
      ]
    },
    {
      "code" : "37122049",
      "display" : "ITRACONAZOLO MYLAN GENERICS",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC02"
        }
      ]
    },
    {
      "code" : "35899018",
      "display" : "ITRACONAZOLO SANDOZ",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CBA"
        },
        {
          "code" : "ATC",
          "valueCode" : "J02AC02"
        }
      ]
    },
    {
      "code" : "36377012",
      "display" : "ITRACONAZOLO TEVA",
      "property" : [
        {
          "code" : "gruppoEquivalenza",
          "valueCode" : "CBA"
        },
        {
          "code" : "ATC",
   