# hl7.fhir.it.terminology#0.1.2: HL7 Italia Terminology

## Pages

* [Home](index.md)
* [Specifiche](specifiche_properties.md)
* [Specifiche farmaci equivalenti](specifiche_farmEquivalenti.md)
* [ValueSet](allValueset.md)
* [Codesystems Derivati](anotherCodesystem.md)
* [Specifiche per le farmacie](specifiche_farma.md)
* [Specifiche per le strutture di ricovero](specifiche_struttureRicovero.md)
* [Copyrights](copyright.md)
* [Specifiche per le ASL](specifiche_Asl.md)
* [Specifiche per le parafarmacie](specifiche_parafarm.md)
* [Specifiche per le unità amministrative estere](specifice_unitaAmministrativeEstere.md)
* [Downloads](downloads.md)
* [Codesystems Prinicipali](principalCodesystem.md)
* [Specifiche per le unità amministrative](specifice_unitaAmministrative.md)
* [Concept Map](allConceptmap.md)
* [Indice Artefatti](artifacts.md)

## Resources

### CodeSystems

* [HL7 Italia - AdministrativeGender (translation)](CodeSystem-administrative-gender.md)
* [AIFA - Autorizzazione Immissione in Commercio](CodeSystem-aifa-aic.md)
* [AIFA - ATC](CodeSystem-aifa-atc.md)
* [AIFA - Farmaci equivalenti](CodeSystem-aifa-ge.md)
* [AIFA - Gruppo di equivalenza](CodeSystem-aifa-gruppo-equivalenza.md)
* [AIFA - Indicazioni terapeutiche (Nota AIFA)](CodeSystem-aifa-nota.md)
* [Ministero della Salute - ASL](CodeSystem-cs-asl.md)
* [MDS - ID Strutture Interne di Ricovero](CodeSystem-cs-mds-idStruttureInterne.md)
* [ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG)](CodeSystem-dug.md)
* [ISTAT - Comuni](CodeSystem-istat-comuni.md)
* [ISTAT - Continente](CodeSystem-istat-continente.md)
* [ISTAT - Classificazione dei titoli di studio italiani](CodeSystem-istat-ctsi03.md)
* [ISTAT - Classificazione delle professioni](CodeSystem-istat-professioni.md)
* [ISTAT - Ripartizione Geografica](CodeSystem-istat-ripartizione-geografica.md)
* [ISTAT - Stato Civile](CodeSystem-istat-statoCivile.md)
* [ISTAT - Unità Amministrative Territoriali](CodeSystem-istat-unitaAmministrativeTerritoriali.md)
* [ISTAT - Unita Amministrative Territoriali Estere](CodeSystem-istat-unitaAmministrativeTerritorialiEstere.md)
* [HL7 Italia - HL7 V3 RoleCode (estensione)](CodeSystem-it-V3RoleCode.md)
* [HL7 Italia - Tipi di identificatore](CodeSystem-it-identifier-type.md)
* [HL7 Italia - Tipo di Entità](CodeSystem-it-tipoEntita.md)
* [MDS - Esenzione dal ticket](CodeSystem-mds-esenzioni.md)
* [MDS - Tipo di Struttura per Srutture di ricovero](CodeSystem-mds-tipo-struttura.md)
* [MDS - Tipo di Farmacia](CodeSystem-mds-tipologia-farmacia.md)
* [MDS - Elenco Farmacie](CodeSystem-minsan-farmacie.md)
* [MDS - Strutture di Ricovero](CodeSystem-minsan-hsp.md)
* [MDS - Elenco Parafarmacie](CodeSystem-minsan-parafarmacie.md)
* [Ministero della Salute - Codici Regioni / PPAA](CodeSystem-minsan-regione.md)
* [ISTAT - Province](CodeSystem-province-istat.md)
* [HL7 Italia - v3 Code System MaritalStatus (translation)](CodeSystem-v3-MaritalStatus.md)

### ValueSets

* [Identificativi per codici STP regionali](ValueSet-URI-idStp.md)
* [Tipo identificatore](ValueSet-VstipoIdentificatore.md)
* [Additivo Campione](ValueSet-additivo-campione-it.md)
* [AIFA AIC](ValueSet-aifa-aic.md)
* [AIFA Gruppo di Equivalenza](ValueSet-aifa-ge.md)
* [Container Campione](ValueSet-campione-container-lab-it.md)
* [ISO 3166 - EHIC Country Codes](ValueSet-iso-ehicCountryCode.md)
* [ISTAT - Cittadinanza](ValueSet-istat-cittadinanza.md)
* [ISTAT - Comuni](ValueSet-istat-comune.md)
* [ISTAT - DUG](ValueSet-istat-dug.md)
* [ISTAT - Comune/Stato di Nascita](ValueSet-istat-luogoNascita.md)
* [ISTAT - Professioni](ValueSet-istat-professione.md)
* [ISTAT - Province](ValueSet-istat-provincia.md)
* [ISTAT - Stati](ValueSet-istat-stato.md)
* [ISTAT - Stato Civile](ValueSet-istat-statoCivile-vs.md)
* [ISTAT - Titolo Studio](ValueSet-istat-titoloStudio.md)
* [MDS - ASL](ValueSet-mds-asl-vs.md)
* [Ministero della Salute - ID Aziende Ospedaliere Universitarie](ValueSet-minsan-idAou.md)
* [Ministero della Salute - ID Aziende Ospedaliere](ValueSet-minsan-idAziendeOspedaliere.md)
* [Ministero della Salute - ID Strutture Ricovero](ValueSet-minsan-idStrutture.md)
* [Ministero della Salute - ID Strutture Interne di Ricovero](ValueSet-minsan-idStruttureInterne.md)
* [Ministero della Salute - Codici Regionali](ValueSet-minsan-regione.md)
* [Tipo medico di famiglia](ValueSet-mmgOrPls.md)
* [EHIC Personal ID (system IDs - oid)](ValueSet-oid-ehicPersonalId.md)
* [Risultato osservazione codificato - microorganismo IPS di SNOMED CT](ValueSet-results-microorganism-snomed-ct-ips-free-set.md)
* [Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT](ValueSet-results-observation-bloodgroup.md)
* [Risultato osservazione codificato -  presenza/assenza IPS di SNOMED CT](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md)
* [Tipo Osservazione](ValueSet-risultato-osservazione.md)
* [Sezioni Composition Lab Report](ValueSet-sezione-referto-laboratorio.md)
* [Stato Civile](ValueSet-statoCivile.md)
* [Stato Esenzione](ValueSet-statoEsenzione.md)
* [Ministero della Salute - Codici strutture di ricovero pubbliche](ValueSet-strutturePubbliche.md)
* [Tipo campione](ValueSet-tipo-campione-lab-it.md)
* [Tipo certificatore](ValueSet-tipoCertificatore.md)
* [Tipo organizzazione socio-sanitaria](ValueSet-tipoOrgSocioSanitaria.md)
* [Tipo organizzazione (esempio)](ValueSet-tipoOrganizzazione.md)
* [Identificativi regionali per ASL (3 char)](ValueSet-uri-idAslRegione.md)
* [Risultato osservazione codificato gruppo sanguigno](ValueSet-valueset-observation-value-bloodgroup.md)
* [Risultato osservazione codificato microorganismi](ValueSet-valueset-observation-value-microorganism.md)
* [Risultato osservazione codificato presenza/assenza](ValueSet-valueset-observation-value-presence-absence.md)
* [Risultato osservazione codificato](ValueSet-valueset-valuecodeableconcept-obs-it.md)
* [HL7 Italia - HL7 V3 RoleCode (estensione)](ValueSet-vs-V3RoleCode.md)
* [AIFA Note](ValueSet-vs-aifa-nota.md)
* [VS-Anagrafi Regionali](ValueSet-vs-anagrafi-regionali.md)
* [Ministero della Salute - Esenzioni](ValueSet-vs-mds-esenzioni.md)
* [MDS - Farmacia](ValueSet-vs-mds-farmacia.md)
* [WHO ATC](ValueSet-who-atc.md)
* [WHO ICD-9-CM](ValueSet-who-icd9cm.md)

### ConceptMaps

* [Mapping fra VS HL7 e Tabella ISTAT Stato Civile](ConceptMap-ConceptMap-statoCivile.md)

### ImplementationGuides

* [HL7 Italia Terminology](index.md)
