# Copyrights - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* **Copyrights**

## Copyrights

### Condizioni d’uso

Questa guida, così come gli altri artefatti sviluppati da HL7 Italia, sono prodotti da HL7 Italia nei termini previsti dal proprio statuto e regolamento riguardo la Proprietà Intellettuale, in particolare per copyright, trademark e brevetti.

Questa guida inoltre contiene materiale sviluppato da HL7®, incluso terminologie, prodotte da HL7 International nei termini previsti da HL7® Governance and Operations Manual (Section 16).

Questo documento è rilasciato in licenza Creative Commons (CC BY-SA 4.0) “Attribution-ShareAlike 4.0 International”.

Questa guida di HL7 Italia contiene e fa riferimento a materiale la cui proprietà intellettuale è di terzi (“Third Party IP”).

Gli implementatori e chi testa questa specifica DEVONO attenersi ai termini di licenza previsto da ciascun artefatto, incluso le terminologie.

Le licenze associate a questi prodotti DEVONO essere ottenute dal proprietario dell'IP per ciascun sistema di codifica e / o altro artefatto utilizzato. È esclusiva responsabilità di ciascuna organizzazione che implementa o verifica questa specifica garantire che le proprie implementazioni siano conformi ai requisiti di licenza di ciascuna IP di terze parti.

### Riferimenti

La seguente tabella riporta una lista non esaustiva di terminologie di terze parti che potrebbero essere usate da guide sviluppate da HL7 Italia o presenti in guide da cui queste guide possono dipendereche potrebbero richiedere licenze separate:

| | | |
| :--- | :--- | :--- |
| Varie codifiche (e.g. DUG, Professioni, unità territoriali, ...) | ISTAT | [https://www.istat.it/it/note-legali](https://www.istat.it/it/note-legali) |
| Varie Codifiche (e.g. esenzioni, codifica ASL e strutture di ricovero, …) | Ministero della Salute | [http://www.salute.gov.it/portale/p5_0.jsp?lingua=italiano&id=50](http://www.salute.gov.it/portale/p5_0.jsp?lingua=italiano&id=50) |
| Autorizzazione Immissione in Commercio (AIC) | Agenzia italiana del farmaco (AIFA) | [https://www.aifa.gov.it/copyright](https://www.aifa.gov.it/copyright) |
| SNOMED CT® | SNOMED International | [http://www.snomed.org/snomed-ct/get-snomed-ct](http://www.snomed.org/snomed-ct/get-snomed-ct) |
| SNOMED CT® Global Patient Set (GPS) | SNOMED International | [https://www.snomed.org/snomed-international/learn-more/global-patient-set](https://www.snomed.org/snomed-international/learn-more/global-patient-set) |
| Logical Observation Identifiers Names & Codes (LOINC®) | Regenstrief Institute, Inc. and the LOINC Committee | [https://loinc.org/license/](https://loinc.org/license/) |
| Unified Codes for Units of Measures (UCUM) | Regenstrief Institute, Inc. and the UCUM Organization | [http://unitsofmeasure.org/trac/wiki/TermsOfUse](http://unitsofmeasure.org/trac/wiki/TermsOfUse) |
| International Classification of Diseases (ICD) classification system | World Health Organization (WHO) | [https://www.who.int/publishing/copyright/en/](https://www.who.int/publishing/copyright/en/) |
| Anatomical Therapeutic Chemical (ATC) classification system | World Health Organization (WHO) Collaborating Centre for Drug Statistics Methodology | [https://www.whocc.no/use_of_atc_ddd/](https://www.whocc.no/use_of_atc_ddd/) |
| EDQM Standard Terms | European Directorate for the Quality of Medicines | [https://www.edqm.eu/en/standard-terms-database](https://www.edqm.eu/en/standard-terms-database) |
| ISO 3166 Country Code | International Organization for Standardization (ISO) | [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html) |
| DICOM® | National Electrical Manufacturers Association (NEMA) | [https://www.nema.org/About/Pages/Terms-and-Conditions.aspx](https://www.nema.org/About/Pages/Terms-and-Conditions.aspx) |
| BCP 47 Tags for Identifying Languages | IETF Trust and the persons identified as the document authors. | [http://trustee.ietf.org/license-info](http://trustee.ietf.org/license-info) |
| International Standard Classification of Occupations (ISCO) | International Labour Organization (ILO) | [http://www.ilo.org/global/copyright/lang–en/index.htm](http://www.ilo.org/global/copyright/lang--en/index.htm) |

HL7®, HEALTH LEVEL SEVEN®, FHIR® and the FHIR ® are trademarks owned by Health Level Seven International, registered with the United States Patent and Trademark Office.

### Intellectual Property Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [CSItTipoEntita](CodeSystem-it-tipoEntita.md), [CsAifaAic](CodeSystem-aifa-aic.md)...Show 77 more,[CsAifaGruppoEquivalenza](CodeSystem-aifa-gruppo-equivalenza.md),[CsAifaNota](CodeSystem-aifa-nota.md),[CsAtcPrincipio](CodeSystem-aifa-atc.md),[CsContinente](CodeSystem-istat-continente.md),[CsEsenzioni](CodeSystem-mds-esenzioni.md),[CsFarmaciEquivalenti](CodeSystem-aifa-ge.md),[CsFarmacie](CodeSystem-minsan-farmacie.md),[CsIstatComuni](CodeSystem-istat-comuni.md),[CsIstatDug](CodeSystem-dug.md),[CsIstatEstere](CodeSystem-istat-unitaAmministrativeTerritorialiEstere.md),[CsIstatProfessioni](CodeSystem-istat-professioni.md),[CsIstatStatoCivile](CodeSystem-istat-statoCivile.md),[CsIstatTitoliStudio](CodeSystem-istat-ctsi03.md),[CsIstatUnitaAmministrativeTerritoriali](CodeSystem-istat-unitaAmministrativeTerritoriali.md),[CsItIdentifierType](CodeSystem-it-identifier-type.md),[CsItRoleCode](CodeSystem-it-V3RoleCode.md),[CsMDSASL](CodeSystem-cs-asl.md),[CsMDSIdStruttureInterne](CodeSystem-cs-mds-idStruttureInterne.md),[CsMDStruttureRicovero](CodeSystem-minsan-hsp.md),[CsMinSanRegioni](CodeSystem-minsan-regione.md),[CsParafarmacie](CodeSystem-minsan-parafarmacie.md),[CsProvinceISTAT](CodeSystem-province-istat.md),[CsRipartizionegeografica](CodeSystem-istat-ripartizione-geografica.md),[CsSupItAdministrativeGender](CodeSystem-administrative-gender.md),[CsSupItV3MaritalStatus](CodeSystem-v3-MaritalStatus.md),[CsTipoStruttura](CodeSystem-mds-tipo-struttura.md),[CsTipologiaFarmacia](CodeSystem-mds-tipologia-farmacia.md),[HL7ITTerminology](index.md),[HL7_ISTAT_StatoCivile](ConceptMap-ConceptMap-statoCivile.md),[VsAic](ValueSet-aifa-aic.md),[VsAnagrafiRegionali](ValueSet-vs-anagrafi-regionali.md),[VsAsl](ValueSet-mds-asl-vs.md),[VsAtc](ValueSet-who-atc.md),[VsEHICCountryCodes](ValueSet-iso-ehicCountryCode.md),[VsEHICPersonalIdOid](ValueSet-oid-ehicPersonalId.md),[VsFarmacia](ValueSet-vs-mds-farmacia.md),[VsGruppoEquivalenza](ValueSet-aifa-ge.md),[VsGruppoSanguigno](ValueSet-results-observation-bloodgroup.md),[VsIcd9cm](ValueSet-who-icd9cm.md),[VsIstatCittadinanza](ValueSet-istat-cittadinanza.md),[VsIstatComune](ValueSet-istat-comune.md),[VsIstatDug](ValueSet-istat-dug.md),[VsIstatLuogoNascita](ValueSet-istat-luogoNascita.md),[VsIstatProfessionePaziente](ValueSet-istat-professione.md),[VsIstatProvincia](ValueSet-istat-provincia.md),[VsIstatStato](ValueSet-istat-stato.md),[VsIstatStatoCivile](ValueSet-istat-statoCivile-vs.md),[VsIstatTitoloStudio](ValueSet-istat-titoloStudio.md),[VsItRoleCode](ValueSet-vs-V3RoleCode.md),[VsLabSpecimenAdditiveIt](ValueSet-additivo-campione-it.md),[VsLabSpecimenContainerIt](ValueSet-campione-container-lab-it.md),[VsLabSpecimenTypesIt](ValueSet-tipo-campione-lab-it.md),[VsMicroorganismiOsservazioni](ValueSet-results-microorganism-snomed-ct-ips-free-set.md),[VsMinisteroSaluteEsenzioni](ValueSet-vs-mds-esenzioni.md),[VsMinisteroSaluteIdAOU](ValueSet-minsan-idAou.md),[VsMinisteroSaluteIdAziendeOspedaliere](ValueSet-minsan-idAziendeOspedaliere.md),[VsMinisteroSaluteIdStrutture](ValueSet-minsan-idStrutture.md),[VsMinisteroSaluteIdStruttureInterne](ValueSet-minsan-idStruttureInterne.md),[VsMinsanregione](ValueSet-minsan-regione.md),[VsMmgPlsRoles](ValueSet-mmgOrPls.md),[VsNotaAifa](ValueSet-vs-aifa-nota.md),[VsObservationBloodGroup](ValueSet-valueset-observation-value-bloodgroup.md),[VsObservationMicroorganismi](ValueSet-valueset-observation-value-microorganism.md),[VsObservationPresenzaAssenza](ValueSet-valueset-observation-value-presence-absence.md),[VsObservationValueCodeableConcept](ValueSet-valueset-valuecodeableconcept-obs-it.md),[VsResultsLaboratoryObservation](ValueSet-risultato-osservazione.md),[VsResultsPresenceAbsenceSnomedCtIpsFreeSet](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md),[VsSezioniRefertoLaboratorio](ValueSet-sezione-referto-laboratorio.md),[VsStatoCivile](ValueSet-statoCivile.md),[VsStatoEsenzione](ValueSet-statoEsenzione.md),[VsStrutturePubbliche](ValueSet-strutturePubbliche.md),[VsTipoCertificatore](ValueSet-tipoCertificatore.md),[VsTipoOrgSocioSanitaria](ValueSet-tipoOrgSocioSanitaria.md),[VsTipoOrganizzazione](ValueSet-tipoOrganizzazione.md),[VsURIIdStp](ValueSet-URI-idStp.md),[VsUriIdAslRegione](ValueSet-uri-idAslRegione.md)and[VstipoIdentificatore](ValueSet-VstipoIdentificatore.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [VsResultsLaboratoryObservation](ValueSet-risultato-osservazione.md) and [VsSezioniRefertoLaboratorio](ValueSet-sezione-referto-laboratorio.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [VsGruppoSanguigno](ValueSet-results-observation-bloodgroup.md), [VsLabSpecimenAdditiveIt](ValueSet-additivo-campione-it.md)...Show 7 more,[VsLabSpecimenContainerIt](ValueSet-campione-container-lab-it.md),[VsLabSpecimenTypesIt](ValueSet-tipo-campione-lab-it.md),[VsMicroorganismiOsservazioni](ValueSet-results-microorganism-snomed-ct-ips-free-set.md),[VsObservationBloodGroup](ValueSet-valueset-observation-value-bloodgroup.md),[VsObservationMicroorganismi](ValueSet-valueset-observation-value-microorganism.md),[VsObservationPresenzaAssenza](ValueSet-valueset-observation-value-presence-absence.md)and[VsResultsPresenceAbsenceSnomedCtIpsFreeSet](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [VstipoIdentificatore](ValueSet-VstipoIdentificatore.md)
* [ActStatus](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActStatus.html): [VsStatoEsenzione](ValueSet-statoEsenzione.md)
* [MaritalStatus](http://terminology.hl7.org/6.5.0/CodeSystem-v3-MaritalStatus.html): [CsSupItV3MaritalStatus](CodeSystem-v3-MaritalStatus.md) and [VsStatoCivile](ValueSet-statoCivile.md)
* [NullFlavor](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html): [VsIstatProvincia](ValueSet-istat-provincia.md), [VsStatoCivile](ValueSet-statoCivile.md) and [VsStatoEsenzione](ValueSet-statoEsenzione.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [VsTipoCertificatore](ValueSet-tipoCertificatore.md)


