# WHO ATC - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **WHO ATC**

## ValueSet: WHO ATC 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/who-atc | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsAtc |
| **Copyright/Legal**: This artifact includes content from Anatomical Therapeutic Chemical (ATC) classification system. ATC codes are copyright World Health Organization (WHO) Collaborating Centre for Drug Statistics Methodology. Terms & Conditions in https://www.whocc.no/use_of_atc_ddd/ | |

 
Sistema di classificazione anatomico, terapeutico e chimico per la classificazione sistematica dei farmaci 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in [`http://www.whocc.no/atc`](http://www.whocc.no/atc)version Not Stated (use latest from terminology server)

 

### Expansion

Expansion from tx.fhir.org based on codesystem WHO ATC version 2025

This value set has 6,897 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "who-atc",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/who-atc",
  "version" : "0.1.2",
  "name" : "VsAtc",
  "title" : "WHO ATC",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Sistema di classificazione anatomico, terapeutico e chimico per la classificazione sistematica dei farmaci",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This artifact includes content from Anatomical Therapeutic Chemical (ATC) classification system. ATC codes are copyright World Health Organization (WHO) Collaborating Centre for Drug Statistics Methodology. Terms & Conditions in https://www.whocc.no/use_of_atc_ddd/",
  "compose" : {
    "include" : [
      {
        "system" : "http://www.whocc.no/atc"
      }
    ]
  }
}

```
