# Stato Esenzione - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Stato Esenzione**

## ValueSet: Stato Esenzione 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/statoEsenzione | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsStatoEsenzione |

 
Value Set basato sul vocabolario HL7 V3 ActStatus che descrive lo stato delle esenzioni. Questo value set è adottato da HL7 CDA R2 IG 'DOCUMENTO DI ESENZIONE' 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

This value set contains 5 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "statoEsenzione",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/statoEsenzione",
  "version" : "0.1.2",
  "name" : "VsStatoEsenzione",
  "title" : "Stato Esenzione",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Value Set basato sul vocabolario HL7 V3 ActStatus che descrive lo stato delle esenzioni. Questo value set è adottato da HL7 CDA R2 IG 'DOCUMENTO DI ESENZIONE'",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActStatus",
        "concept" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments",
                "valueString" : "Esenzione in corso di validità"
              }
            ],
            "code" : "active",
            "display" : "attivo"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments",
                "valueString" : "Esenzione momentaneamente sospesa (ad esempio in attesa del rinnovo di un’iscrizione temporanea)"
              }
            ],
            "code" : "suspended",
            "display" : "sospeso"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments",
                "valueString" : "Esenzione mai stata valida (ad esempio è stata assegnata per errore e il documento corrispondente era già stato prodotto in stato active)"
              }
            ],
            "code" : "aborted",
            "display" : "abortito"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments",
                "valueString" : "Esenzione non più in corso di validità"
              }
            ],
            "code" : "completed",
            "display" : "completato"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "concept" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments",
                "valueString" : "Lo stato dell'esenzione non è noto"
              }
            ],
            "code" : "UNK",
            "display" : "sconosciuto"
          }
        ]
      }
    ]
  }
}

```
