# Ministero della Salute - ID Aziende Ospedaliere Universitarie - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Ministero della Salute - ID Aziende Ospedaliere Universitarie**

## ValueSet: Ministero della Salute - ID Aziende Ospedaliere Universitarie 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/minsan-idAou | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsMinisteroSaluteIdAOU |

 
Ministero della Salute - Azienda Ospedaliera integrata con l'Università (HSP11) 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "minsan-idAou",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/minsan-idAou",
  "version" : "0.1.2",
  "name" : "VsMinisteroSaluteIdAOU",
  "title" : "Ministero della Salute - ID Aziende Ospedaliere Universitarie",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Ministero della Salute - Azienda Ospedaliera integrata con l'Università (HSP11)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://www.hl7.it/fhir/terminology/CodeSystem/minsan-hsp",
        "concept" : [
          {
            "code" : "010904",
            "display" : "AZIENDA OSPEDALIERO UNIVERSITARIA S.LUIG"
          },
          {
            "code" : "010905",
            "display" : "AZIENDA OSPED. NOVARA E GALLIATE"
          },
          {
            "code" : "010909",
            "display" : "AOU CITTA' DELLA SALUTE E DELLA SCIENZA"
          },
          {
            "code" : "050912",
            "display" : "AZ.OSP.UNIVERSITARIA INTEGRATA VERONA"
          },
          {
            "code" : "080902",
            "display" : "AZIENDA OSPEDALIERO-UNIVERSITARIA DI PAR"
          },
          {
            "code" : "080904",
            "display" : "AZIENDA OSPEDALIERO-UNIVERSITARIA DI MOD"
          },
          {
            "code" : "080908",
            "display" : "AZIENDA OSPEDALIERO-UNIVERSITARIA DI BOL"
          },
          {
            "code" : "080909",
            "display" : "AZIENDA OSPEDALIERO-UNIVERSITARIA DI FER"
          },
          {
            "code" : "090901",
            "display" : "AZIENDA OSPEDALIERO-UNIVERSITARIA PISANA"
          },
          {
            "code" : "090902",
            "display" : "AZIENDA OSPEDALIERA UNIVERSITARIA SENESE"
          },
          {
            "code" : "090903",
            "display" : "AZ. OSPEDALIERO - UNIVERSITARIA CAREGGI"
          },
          {
            "code" : "090904",
            "display" : "AZIENDA OSPEDALIERA MEYER"
          },
          {
            "code" : "120919",
            "display" : "AZIENDA OSPEDALIERA SANT`ANDREA"
          },
          {
            "code" : "120920",
            "display" : "AZ. OSP. UNIV. POLICLINICO TOR VERGATA"
          },
          {
            "code" : "150904",
            "display" : "A.O.OO.RR.S.GIOVANNI DI DIO E RUGGI D`AR"
          },
          {
            "code" : "160910",
            "display" : "AO UNIV. 'OO RR FOGGIA'"
          }
        ]
      }
    ]
  }
}

```
