# ISTAT - Comuni - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **ISTAT - Comuni**

## ValueSet: ISTAT - Comuni 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/istat-comune | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsIstatComune |

 
Codici ISTAT Comune più sconosciuto 

 **References** 

* Included into [VsIstatLuogoNascita](ValueSet-istat-luogoNascita.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include all codes defined in [`https://www.hl7.it/fhir/terminology/CodeSystem/istat-unitaAmministrativeTerritoriali`](CodeSystem-istat-unitaAmministrativeTerritoriali.md)version 📦0.1.2
* Include all codes defined in [`https://www.hl7.it/fhir/terminology/CodeSystem/istat-unitaAmministrativeTerritoriali`](CodeSystem-istat-unitaAmministrativeTerritoriali.md)version 📦0.1.2

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "istat-comune",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/istat-comune",
  "version" : "0.1.2",
  "name" : "VsIstatComune",
  "title" : "ISTAT - Comuni",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Codici ISTAT Comune più sconosciuto",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://www.hl7.it/fhir/terminology/CodeSystem/istat-unitaAmministrativeTerritoriali"
      },
      {
        "system" : "https://www.hl7.it/fhir/terminology/CodeSystem/istat-unitaAmministrativeTerritoriali"
      }
    ]
  }
}

```
