# Additivo Campione - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **Additivo Campione**

## ValueSet: Additivo Campione 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/ValueSet/additivo-campione-it | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:VsLabSpecimenAdditiveIt |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione dell'additivo utilizzato per il campione di laboratorio. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "additivo-campione-it",
  "url" : "https://www.hl7.it/fhir/terminology/ValueSet/additivo-campione-it",
  "version" : "0.1.2",
  "name" : "VsLabSpecimenAdditiveIt",
  "title" : "Additivo Campione",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione dell'additivo utilizzato per il campione di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "1259913003",
            "display" : "Heparin ammonium (substance)"
          },
          {
            "code" : "386961008",
            "display" : "Aprotinin (substance)"
          },
          {
            "code" : "29725000",
            "display" : "Heparin calcium (substance)"
          },
          {
            "code" : "21611007",
            "display" : "Boric acid (substance)"
          },
          {
            "code" : "30531001",
            "display" : "Calcium oxalate (substance)"
          },
          {
            "code" : "69519002",
            "display" : "Edetic acid (substance)"
          },
          {
            "code" : "372628006",
            "display" : "Edetate (substance)"
          },
          {
            "code" : "27763000",
            "display" : "Hydrochloric acid (substance)"
          },
          {
            "code" : "414407009",
            "display" : "Hirudin (substance)"
          },
          {
            "code" : "1256100007",
            "display" : "Edetate dipotassium (substance)"
          },
          {
            "code" : "1256101006",
            "display" : "Edetate tripotassium (substance)"
          },
          {
            "code" : "1256102004",
            "display" : "Heparin lithium (substance)"
          },
          {
            "code" : "387418006",
            "display" : "Edetate disodium (substance)"
          },
          {
            "code" : "412546005",
            "display" : "Sodium citrate (substance)"
          },
          {
            "code" : "50045009",
            "display" : "Heparin sodium (substance)"
          },
          {
            "code" : "6910009",
            "display" : "Sodium fluoride (substance)"
          },
          {
            "code" : "50306007",
            "display" : "Sodium tetraborate (substance)"
          },
          {
            "code" : "387168006",
            "display" : "Mannitol (substance)"
          },
          {
            "code" : "115281000146102",
            "display" : "Sodium formate (substance)"
          }
        ]
      }
    ]
  }
}

```
