# MDS - Elenco Parafarmacie - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **MDS - Elenco Parafarmacie**

## CodeSystem: MDS - Elenco Parafarmacie 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/minsan-parafarmacie | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsParafarmacie |

 
Ministero della Salute - Elenco Parafarmacie. Source 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "minsan-parafarmacie",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/minsan-parafarmacie",
  "version" : "0.1.2",
  "name" : "CsParafarmacie",
  "title" : "MDS - Elenco Parafarmacie",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Ministero della Salute - Elenco Parafarmacie. Source",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "filter" : [
    {
      "code" : "regione",
      "description" : "Permette di ricercare i codici secondo il codice Regionale di appartenenza",
      "operator" : ["="],
      "value" : "codice della Regione"
    },
    {
      "code" : "comune",
      "description" : "Permette di ricercare i codici secondo il codice del comune di appartenenza",
      "operator" : ["="],
      "value" : "codice del Comune"
    },
    {
      "code" : "provincia",
      "description" : "Permette di ricercare i codici secondo il codice della provincia di appartenenza",
      "operator" : ["="],
      "value" : "codice della Provincia"
    },
    {
      "code" : "dataInizio",
      "description" : "Permette di ricercare i codici inserendo la data di inzio validità",
      "operator" : ["=", "not-in", "in"],
      "value" : "data"
    },
    {
      "code" : "dataFine",
      "description" : "Permette di ricercare i codici inserendo la data di fine validità",
      "operator" : ["=", "not-in", "in"],
      "value" : "data"
    }
  ],
  "property" : [
    {
      "code" : "regione",
      "description" : "Proprietà che identifica la regione di appartenenza della parafarmacia",
      "type" : "code"
    },
    {
      "code" : "comune",
      "description" : "Proprietà che identifica il comune di appartenenza della parafarmacia",
      "type" : "code"
    },
    {
      "code" : "provincia",
      "description" : "Proprietà che identifica la provincia di appartenenza della parafarmacia",
      "type" : "code"
    },
    {
      "code" : "dataInizio",
      "description" : "Proprietà che identifica la data di inizio validità della parafarmacia",
      "type" : "dateTime"
    },
    {
      "code" : "dataFine",
      "description" : "Proprietà che identifica la data di fine validità della parafarmacia",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "2112",
      "display" : "Parafarmacia S.F.A. Fasani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071028"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-10-01"
        }
      ]
    },
    {
      "code" : "2113",
      "display" : "eurosan",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-10-01"
        }
      ]
    },
    {
      "code" : "2118",
      "display" : "PARAFARMACIA NATURESTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028037"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-10-01"
        }
      ]
    },
    {
      "code" : "2120",
      "display" : "FARMA+ dott.Giuseppe moscariello",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064057"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-10-01"
        }
      ]
    },
    {
      "code" : "2130",
      "display" : "PARAFARMACIA MAMELI S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006039"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2131",
      "display" : "Erb. La Verbena Dr. Gregorio Puglisi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087042"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2135",
      "display" : "L'OFFICINA DELLE ERBE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2144",
      "display" : "Parafarmacia Sanitaria Dr.ssa Nicoletta Bonfanti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023044"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2145",
      "display" : "Pharma shop srl c/o C. C. Le Porte di Napoli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063002"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2151",
      "display" : "Parafarmacia In Herbis Salus",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029027"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2152",
      "display" : "Farmasanitaria IL PETTIROSSO S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063037"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2154",
      "display" : "PARAFARMACIA DI NOVE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024073"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-10-01"
        }
      ]
    },
    {
      "code" : "2155",
      "display" : "PARAFARMACIA OPITERGINA DI GIROTTO E SEGAT SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026051"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2156",
      "display" : "Erboristeria Diva",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100002"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2161",
      "display" : "PARAFARMACIA ROSSI DOTT.SSA RITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035030"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2168",
      "display" : "La Parafarmacia Snc di Dott.ssa Mauri Edda & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015149"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2170",
      "display" : "IPERCOOP CENTRO LAME",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2171",
      "display" : "IPERCOOP CENTRO PIAVE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027033"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2172",
      "display" : "IPERCOOP ESP",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2173",
      "display" : "PESARO BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041044"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-03-01"
        }
      ]
    },
    {
      "code" : "2174",
      "display" : "IPERCOOP CENTRO D'ABRUZZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069081"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2175",
      "display" : "Sanilandia di Malis Antonella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027008"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-09-01"
        }
      ]
    },
    {
      "code" : "2176",
      "display" : "DOCTOREMEDY SRL UNIPERSONALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045010"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-02-01"
        }
      ]
    },
    {
      "code" : "2178",
      "display" : "PARA ELIOS la bottega del benessere",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2180",
      "display" : "Farmafree",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048043"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2181",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005005"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2189",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-11-01"
        }
      ]
    },
    {
      "code" : "2195",
      "display" : "Erboristeria-Sanitaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044019"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2196",
      "display" : "Parafarmia San Nicolò di LAmparelli A.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023006"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-01-01"
        }
      ]
    },
    {
      "code" : "2197",
      "display" : "Sanitaria Dr Carlo Poletto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2198",
      "display" : "L'Angolo della salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029033"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2200",
      "display" : "Di raimondo Rosalba",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087004"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2202",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004215"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "2203",
      "display" : "Parafarmacia Conad",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-11-01"
        }
      ]
    },
    {
      "code" : "2204",
      "display" : "PARAFARMACIA  I GRANAI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2205",
      "display" : "PARAFARMACIA CINECITTA'2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2206",
      "display" : "PARAFARMACIA PANTHEON",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2208",
      "display" : "PARAFARMACIA CASETTA MATTEI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2209",
      "display" : "parafarmacia dr.ssa cecchini silvia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041044"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2227",
      "display" : "LA FARMACISTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2228",
      "display" : "LA PARAFARMACIA DEL DR. ALBERTO ESPOSITO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078148"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2229",
      "display" : "FARMACIA NUOVA DOTT.SSA ALESSANDRA PAPALEO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060085"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2232",
      "display" : "Pedrini Natura By Kutubia srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2237",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-05-01"
        }
      ]
    },
    {
      "code" : "2239",
      "display" : "IL FARMACISTA dott. TORTELLO MATTEO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008031"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2241",
      "display" : "LA FARMOTEKA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090023"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2243",
      "display" : "Pedrini Natura SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2245",
      "display" : "parafarmacia farmaigea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041013"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2246",
      "display" : "Sanitas di Resta Marcella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072036"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2248",
      "display" : "L'angolo della Salute di E. Patti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "2249",
      "display" : "Sma-Gravina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087019"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2250",
      "display" : "Farmoteca Il Viale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2251",
      "display" : "Parafarmacia dott. Sabbatini Srl Unipersonale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044019"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-02-01"
        }
      ]
    },
    {
      "code" : "2253",
      "display" : "Parafarmacia - Erboristeria dr. A. Colasanti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060038"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2254",
      "display" : "Parafarmacia Conad",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004003"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-09-01"
        }
      ]
    },
    {
      "code" : "2256",
      "display" : "NATURE SHOP DI OMEOPHYTO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009034"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-06-01"
        }
      ]
    },
    {
      "code" : "2257",
      "display" : "farmasanity",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078081"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2261",
      "display" : "PARAFARMACIA BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2262",
      "display" : "PARAFARMACIA BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029041"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2266",
      "display" : "PARAFARMACIA BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026081"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-11-01"
        }
      ]
    },
    {
      "code" : "2268",
      "display" : "erboristeria dandelion della dr.ssa valeria cocco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2269",
      "display" : "FARMASHOP SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2270",
      "display" : "IPERCOOP I MALATESTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2272",
      "display" : "l'oasi del benessere",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028085"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2275",
      "display" : "PARAFARMACIA POLIFARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "2276",
      "display" : "paraFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059016"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2278",
      "display" : "IPERCOOP CENTRO PORTO GRANDE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044066"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2280",
      "display" : "PARAFARMACIA DR. GIOVANNI CAMMARANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065050"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2286",
      "display" : "056042",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056"
        },
        {
          "code" : "provincia",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-02-01"
        }
      ]
    },
    {
      "code" : "2287",
      "display" : "Parafarmacia s. Martino di Zampis dott. Davide",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030072"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2289",
      "display" : "parafarmacia dott.ssa marchesini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "2293",
      "display" : "Parafarmacia dott.ssa Pedone Rosa Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2294",
      "display" : "Parafarmacia Dott. Andrea Galante",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-11-01"
        }
      ]
    },
    {
      "code" : "2296",
      "display" : "RINALDI GIORGIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099018"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "2299",
      "display" : "NOVAFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2302",
      "display" : "decafarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090047"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2304",
      "display" : "CO.DI.PA Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2308",
      "display" : "Parafarmacia Alma Mater di Esposito Clara",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070078"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2310",
      "display" : "IPERCOOP BORGOGIOIOSO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036005"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2311",
      "display" : "IPERCOOP LE MURA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2312",
      "display" : "IPERCOOP BARI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2313",
      "display" : "SUPERMERCATO SASSUOLO MEZZAVIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036040"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2314",
      "display" : "IPERCOOP GRANDEMILIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2315",
      "display" : "IPERCOOP LECCE c/o C.C. SALENTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075083"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2316",
      "display" : "IPERCOOP BARI JAPIGIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2317",
      "display" : "IPERCOOP PORTALI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2318",
      "display" : "IPERCOOP DELLA MIRANDOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036022"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2319",
      "display" : "IPERCOOP CENTRO BORGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2322",
      "display" : "IPERCOOP ANDRIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072005"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2323",
      "display" : "IPERCOOP CITTA' DELLE STELLE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044007"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2324",
      "display" : "IPERCOOP IL CASTELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2325",
      "display" : "IPERCOOP BARLETTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072007"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2326",
      "display" : "IPERCOOP TARANTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2327",
      "display" : "CENTRO COMMERCIALE I TIGLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038001"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2328",
      "display" : "CENTRO COMMERCIALE LE MAGNOLIE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036006"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2329",
      "display" : "IPERCOOP FOGGIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2330",
      "display" : "Coop Salute Vignola",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036046"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2332",
      "display" : "DISTRIBUZIONE LAZIO UMBRIA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "2335",
      "display" : "BIOFARM PARAFARMACIA D.SSA IUALE' SAMANTHA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043028"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2336",
      "display" : "CBF SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-01-01"
        }
      ]
    },
    {
      "code" : "2340",
      "display" : "PARAFARMACIA DOTT.SSA GALLUCCI SONIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2343",
      "display" : "New Chimifarm srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "2344",
      "display" : "Ipercoop Collestrada",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2346",
      "display" : "Ipercoop",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2348",
      "display" : "SANITARIA PROGRESSO S.A.S. DI GIOVANNA TOLOMEI E C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2350",
      "display" : "Plant Pharma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2354",
      "display" : "Arrò & Zingarelli snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "007003"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2356",
      "display" : "Parafarmacia Sanitas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072031"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2358",
      "display" : "Parafarmacia Isola",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016046"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2362",
      "display" : "naturpharma snc di cassinelli c e risso p",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010015"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2363",
      "display" : "Sanitari-Erboristeria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092050"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2365",
      "display" : "FARMA+CHIC S.R.L.S. DI GENZALE E GUARINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064050"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "2373",
      "display" : "Farmaverde dr. G. LACAITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073028"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2374",
      "display" : "Farmaverde dr. G. LACAITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073028"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2378",
      "display" : "albakos srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009003"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2380",
      "display" : "INTERSPAR SARMEOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028072"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2381",
      "display" : "INTERSPAR ALBIGNASEGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028003"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2382",
      "display" : "INTERSPAR ABANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028001"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2383",
      "display" : "INTERSPAR ADRIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029001"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2385",
      "display" : "INTERSPAR ROVIGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029041"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2387",
      "display" : "INTERSPAR CASSACCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030019"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2390",
      "display" : "cityper",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026046"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2394",
      "display" : "001120",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "2395",
      "display" : "001090",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "2396",
      "display" : "015121",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "2397",
      "display" : "015011",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "2399",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087051"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "2400",
      "display" : "Farmaci06",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2401",
      "display" : "parafarmacia don orione di pareti claudia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006174"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2404",
      "display" : "FARMANATURA DI BENESSERE SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052035"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "2405",
      "display" : "COOP LIGURIA S.C.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-12-01"
        }
      ]
    },
    {
      "code" : "2406",
      "display" : "COOP LIGURIA  S.C.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009056"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2408",
      "display" : "COOP LIGURIA S.C.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011015"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-12-01"
        }
      ]
    },
    {
      "code" : "2409",
      "display" : "Parafarmacia srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065003"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2415",
      "display" : "Farmacia del Benessere",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2416",
      "display" : "PARAFARMACIA DR.SSA LETIZIA LE PERA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078106"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2420",
      "display" : "LA VETERINARIA DR.SSA NISI PATRIZIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078081"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2421",
      "display" : "Parafarmedica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004029"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2423",
      "display" : "Farmasanitaria della Dr. Marcella Latorre",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074007"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2427",
      "display" : "Studio erboristico Dot.essa Cascione Maria Teresa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077014"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2428",
      "display" : "La Bottega del Verde",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078148"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2429",
      "display" : "Parafarmacia dott.ssa Toma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077014"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2433",
      "display" : "Baby MArket Frosinone srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060038"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-03-01"
        }
      ]
    },
    {
      "code" : "2434",
      "display" : "L'ANGOLO DELLA SALUTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2436",
      "display" : "Erboristeria Articoli Sanitari SANERBA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017148"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2438",
      "display" : "farmacenter",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2440",
      "display" : "ERBORISTERIA-SANITARIA DOTT. ENEA FERRAMOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020047"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2444",
      "display" : "NOVA COOP S.C. IPER TORINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2445",
      "display" : "parafarmacia dott fortunato santina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077021"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2446",
      "display" : "FARMAOVER AUCELLO PIETRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048014"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2450",
      "display" : "PARAFARMACIA del CORSO di POULIOU DR.SSA KALLIOPI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2451",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026034"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2452",
      "display" : "GIEFFE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012095"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2453",
      "display" : "marchese maria luisa parafarmacia di via verdi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018182"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2454",
      "display" : "medicalvet s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084001"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2455",
      "display" : "L'ARIOSTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-02-01"
        }
      ]
    },
    {
      "code" : "2456",
      "display" : "VIRGILIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020069"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-02-01"
        }
      ]
    },
    {
      "code" : "2457",
      "display" : "SOGEFISAN SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076063"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2458",
      "display" : "ERBORISTERIA DR.SSA ORTENZIA TRAVAGLINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044066"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-11-01"
        }
      ]
    },
    {
      "code" : "2459",
      "display" : "Il farmastore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045001"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2460",
      "display" : "LA FAVORITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020030"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-02-01"
        }
      ]
    },
    {
      "code" : "2461",
      "display" : "MEDUNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093033"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-02-01"
        }
      ]
    },
    {
      "code" : "2463",
      "display" : "CENTRO TORRI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-02-01"
        }
      ]
    },
    {
      "code" : "2465",
      "display" : "parafarmacia falsetta dott gianfranco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079012"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2467",
      "display" : "UBALDO CERCHIA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2473",
      "display" : "ESSE TRE s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084041"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2474",
      "display" : "Erboristeria Gioconda De Luca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059032"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2476",
      "display" : "Ipercoop Gran Rondò",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019035"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "2477",
      "display" : "Ipercoop Cremona Po",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019036"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "2479",
      "display" : "Ipercoop Metropoli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015157"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2481",
      "display" : "La Farmaceutica di Di Mauro dr.ssa  Mara",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004203"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-02-01"
        }
      ]
    },
    {
      "code" : "2485",
      "display" : "parafarmacia dott.ssa vicenti maria stella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072004"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2486",
      "display" : "agrimony parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2487",
      "display" : "PARAFARMACIA BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024119"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2488",
      "display" : "farmabio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092108"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2490",
      "display" : "Parafarmacia Gallucci D.ssa Rosanna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065022"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2491",
      "display" : "ESSERE BENESSERE SPA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016150"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2494",
      "display" : "PHARMASINERGY L'AQUILA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066049"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "2495",
      "display" : "CELESTE NATURA DELLA D.SSA CANALINI MARIA GRAZIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036018"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2496",
      "display" : "erboristeria-sanitaria PuntoSalute Dott.Camardella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072015"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2497",
      "display" : "015107",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "2498",
      "display" : "012070",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-11-01"
        }
      ]
    },
    {
      "code" : "2499",
      "display" : "FREL SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015168"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "2505",
      "display" : "erboristeria dott.ssa carla di iorio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2506",
      "display" : "erboristeria lu.cri",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054024"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "2507",
      "display" : "Coop Superstore Centro Comm.Dir.Trento Sud",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022205"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2508",
      "display" : "Coop Superstore Millenium",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022161"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-05-01"
        }
      ]
    },
    {
      "code" : "2509",
      "display" : "Herbaria di Franchini Francesca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-06-01"
        }
      ]
    },
    {
      "code" : "2510",
      "display" : "PARAFARMACIA BUSIA DOTT.SSA GIOVANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091024"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2511",
      "display" : "farma.med",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078081"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2513",
      "display" : "parafarmacia dott.ssa pugliese",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078033"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2516",
      "display" : "Masi Mariapina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076043"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2517",
      "display" : "Il farmastore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011015"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2519",
      "display" : "Parafarmacia di Busatti Consuelo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035021"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2523",
      "display" : "Parafarmacia Dottoressa Cresto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004078"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2524",
      "display" : "PARAFARMACIA GALASSIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2525",
      "display" : "PARAFARMACIA CASTELLANZA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012042"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2526",
      "display" : "PARAFARMACIA FARMATUA DI LUCIA CAPPARELLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-10-01"
        }
      ]
    },
    {
      "code" : "2527",
      "display" : "PARAFARMACIA SESIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003130"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2528",
      "display" : "ERBOCOSMOSAN SC ARL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080088"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2530",
      "display" : "Erb. San. La Ginestra Dott. E. Agresti & C. S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077014"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2531",
      "display" : "TOGATI TIZIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072036"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2532",
      "display" : "ERBORISTERIA Dott.ssa Cantoro Rosaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072003"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2536",
      "display" : "parafarmacia della dott.ssa del bello & C snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042006"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-06-01"
        }
      ]
    },
    {
      "code" : "2537",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068011"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2538",
      "display" : "Parafarmacia Conad",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098049"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-10-01"
        }
      ]
    },
    {
      "code" : "2539",
      "display" : "Parafarmacia Conad",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017165"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-10-01"
        }
      ]
    },
    {
      "code" : "2540",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2541",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063034"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2542",
      "display" : "LA PARAFARMACIA Dott.ssa Lopedota Maraiangela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-03-01"
        }
      ]
    },
    {
      "code" : "2544",
      "display" : "Parafarmacia Beggio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027014"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-09-01"
        }
      ]
    },
    {
      "code" : "2545",
      "display" : "IPERCOOP AREZZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2546",
      "display" : "COOP GAVINANA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2547",
      "display" : "La Masseria srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063016"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2549",
      "display" : "PARAFARMACIAITALIANA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018177"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2550",
      "display" : "PARAFRMACIA PHARM-NATUR",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2552",
      "display" : "VETEFARMACO DELLA DRSSA LOGROSCINO RAFFAELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072036"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2553",
      "display" : "parafarm s.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018182"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2554",
      "display" : "Parafarmacia dott. Sartirano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001059"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2556",
      "display" : "Ladis srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046015"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-01-01"
        }
      ]
    },
    {
      "code" : "2557",
      "display" : "D'ALESSIO ANTONIO CARMINE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2558",
      "display" : "Parafarmacia Pelle Dott.ssa Anna Rita",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075010"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2559",
      "display" : "unofarma s.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2560",
      "display" : "erboristeria e sanitaria del dott. f. carbonara &",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2561",
      "display" : "IL FARMACISTA DOTT. FENU",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091014"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2563",
      "display" : "ERBORISTERIA - SANITARIA  Dott.ssa Amalia Nava",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078132"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-06-01"
        }
      ]
    },
    {
      "code" : "2565",
      "display" : "farma verde della dottoressa longo maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2568",
      "display" : "PARAFARMACIA SANTA MARIA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001309"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2570",
      "display" : "erboristeria panacea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2573",
      "display" : "parafarmacia puntofarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092032"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2575",
      "display" : "PARAFARMACIA STORICA COLONNA MARIANNINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078119"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-07-01"
        }
      ]
    },
    {
      "code" : "2576",
      "display" : "pharmaverde srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015149"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2577",
      "display" : "Parafarmacia Sirianni dott. Francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-08-01"
        }
      ]
    },
    {
      "code" : "2578",
      "display" : "Parafarmacia del Dr. Francesco Micciulli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078031"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2581",
      "display" : "Parafarmacia Dott.sa Savoia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063035"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2583",
      "display" : "PARAFARMACIA di PUGGIONI MARCELLA C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2584",
      "display" : "PARAFARMACY DR. LUCIA PEPE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078070"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2585",
      "display" : "Far Medica di Chiappori Angelo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009024"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2586",
      "display" : "PUNTO CASA GIOCHI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2588",
      "display" : "Farmanatura SaS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088006"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2591",
      "display" : "SPAZIO CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042002"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-04-01"
        }
      ]
    },
    {
      "code" : "2593",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015074"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2594",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008059"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-08-01"
        }
      ]
    },
    {
      "code" : "2599",
      "display" : "PARAFARMACIA CONAD PADOVA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-04-01"
        }
      ]
    },
    {
      "code" : "2601",
      "display" : "PARAFARMACIA I GIGLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048006"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2602",
      "display" : "parafarmacia dott. campesato giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024071"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2603",
      "display" : "CAPPARELLI RENATA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078019"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-08-01"
        }
      ]
    },
    {
      "code" : "2604",
      "display" : "Punto verde di Angelantonio Errico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2605",
      "display" : "EUROPHARMA S.A.S. di ESPOSITO ENRICO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061052"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2606",
      "display" : "PARAFARMACIA BIO-NATUR",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013245"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2607",
      "display" : "mittsu s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-11-01"
        }
      ]
    },
    {
      "code" : "2610",
      "display" : "erboristeria specializzata",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078044"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2612",
      "display" : "SCIPIONI CLAUDIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2616",
      "display" : "OBIETTIVO SALUTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075097"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2617",
      "display" : "Parafarmacia Cartolano Vito",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-03-01"
        }
      ]
    },
    {
      "code" : "2619",
      "display" : "ALESAR snc di Russo R. & Greco A.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087017"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2620",
      "display" : "Cosmos del Dr. A. Severino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084028"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2622",
      "display" : "ERBORISTERIA L'ERBAVOGLIO di Casse Elena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001044"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2623",
      "display" : "Officina del Benessere",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085004"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-04-01"
        }
      ]
    },
    {
      "code" : "2626",
      "display" : "IPERCOOP CENTRO LEONARDO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037032"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2628",
      "display" : "COOP SALUTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039012"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-08-01"
        }
      ]
    },
    {
      "code" : "2629",
      "display" : "OMNIA SANITAL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080051"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2630",
      "display" : "LINEA SANITARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075052"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2642",
      "display" : "Erboristeria Erbamica snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044066"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2644",
      "display" : "herba salus",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037019"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2647",
      "display" : "Rengis s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2649",
      "display" : "Parafarmacia dott.ssa Ferrari",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075090"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2650",
      "display" : "Centro Commerciale le Zagare",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087041"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-08-01"
        }
      ]
    },
    {
      "code" : "2652",
      "display" : "Bio-sanitas sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "2653",
      "display" : "Farmanatura di Cecchini Raffaella e C. snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-10-01"
        }
      ]
    },
    {
      "code" : "2654",
      "display" : "Parafarmacia Conad",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098010"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-05-01"
        }
      ]
    },
    {
      "code" : "2656",
      "display" : "Rimedi Naturali snc di gatto renzo e c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026091"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-12-01"
        }
      ]
    },
    {
      "code" : "2657",
      "display" : "Ipercoop Il Ducale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018177"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "2658",
      "display" : "NEW PHARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2659",
      "display" : "S.g.i.Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-12-01"
        }
      ]
    },
    {
      "code" : "2661",
      "display" : "L'OFFICINA DELLE ERBE DELLA DOTT.SSA LOREDANA MERLINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012133"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "2664",
      "display" : "PARAFARMACIA DOTT.SSA NADIA MOCELLINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2006-12-01"
        }
      ]
    },
    {
      "code" : "2667",
      "display" : "PARAFARMACIA CONAD CURNO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016089"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-03-01"
        }
      ]
    },
    {
      "code" : "2669",
      "display" : "Farmacoteca di Verrastro Pietro Antonio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076063"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2670",
      "display" : "Parafarmacia Dott.ri Oliva e Cavaliere",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078138"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2672",
      "display" : "PARAFARMACIA SUSY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063058"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2676",
      "display" : "FARMALUNAESOLE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2677",
      "display" : "PARAFARMACIA DSSE SAINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018102"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2678",
      "display" : "FARMACI E RIMEDI DI DOTT. ENRIA MASSIMO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004029"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2681",
      "display" : "PARAFARMACIA DSSE SAINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2682",
      "display" : "CENTRO SALUTE ASCLEPIOS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095006"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2683",
      "display" : "PRATOFARM di Biancu Giovanni Pietro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091051"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-03-01"
        }
      ]
    },
    {
      "code" : "2684",
      "display" : "SILVESAN DOTT.SSA MANDRAS GIUSEPPINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090017"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2685",
      "display" : "PARAFARMACIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073007"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2687",
      "display" : "SPAZIO CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072015"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-02-01"
        }
      ]
    },
    {
      "code" : "2688",
      "display" : "ERBORISTERIA MESA VERDE DEL DOTT. VILLAGROSSI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020026"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2692",
      "display" : "Mazza srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-01-01"
        }
      ]
    },
    {
      "code" : "2694",
      "display" : "maria teresa montalbano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084001"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2696",
      "display" : "Aita Maria Pia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078121"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2698",
      "display" : "Parafarmacia del Lago dott. Mainetti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003008"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2700",
      "display" : "COMAS OPITAL SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2701",
      "display" : "Pharma & Shop",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2702",
      "display" : "RESCINA PALMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072032"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2704",
      "display" : "Farmasanitaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058104"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "2706",
      "display" : "La Sanitaria srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2708",
      "display" : "Parafarmacia di Gattei Giorgio e c. sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2711",
      "display" : "AUTOFARMA by HEALTHY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2713",
      "display" : "sanitaria dott.ssa m.ederiferi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058013"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2718",
      "display" : "ERBORISTERIA DITRANI ANTONIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072032"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2720",
      "display" : "Coop Liguria s.c.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010010"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-12-01"
        }
      ]
    },
    {
      "code" : "2721",
      "display" : "Coop Liguria S.C.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011027"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-12-01"
        }
      ]
    },
    {
      "code" : "2722",
      "display" : "D.G.Z.  Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078033"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2723",
      "display" : "IPERCOOP IL MAESTRALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042045"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "2726",
      "display" : "DIFARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086010"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-07-01"
        }
      ]
    },
    {
      "code" : "2727",
      "display" : "FARMACIA VETERINARIA DEL DR MARIO DOMENICO CAPECE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062044"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "2730",
      "display" : "Parafarmacia Aldo Fraso S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-07-01"
        }
      ]
    },
    {
      "code" : "2733",
      "display" : "Parafarmacia D.ssa Ricciardello Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083007"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2735",
      "display" : "Parafarmacia dott. Leandro Cuzzocrea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2736",
      "display" : "Banco Farmaceutico S.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087017"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2737",
      "display" : "Parafarmacia Conad",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-10-01"
        }
      ]
    },
    {
      "code" : "2738",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017107"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2739",
      "display" : "Parafarmacia Codinfarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065135"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "2740",
      "display" : "Pharma Project di I & C srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2741",
      "display" : "Parafarmacia Dott. Tonucci",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041027"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2743",
      "display" : "Parafarmacia Le NORD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2745",
      "display" : "PARAFARMACIA DR.SSA PENZO LUISA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026091"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2749",
      "display" : "Farmapoint Fortuna S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044007"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-10-01"
        }
      ]
    },
    {
      "code" : "2751",
      "display" : "paraFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084011"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2752",
      "display" : "Ipercoop Acquario",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015237"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "2754",
      "display" : "Parafarmacia Tommasone Dott.ssa Tiziana di Tiziana Tommasone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "2755",
      "display" : "Healthcare Point s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2756",
      "display" : "Autofarma by Healthy",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002163"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2760",
      "display" : "ERBOFARM",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075002"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2761",
      "display" : "L'ERBORISTERIA DI A. CHIAROLINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010006"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "2763",
      "display" : "015166",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "2764",
      "display" : "HERBARIUM A. & C. di E. Cavaliere & C. Sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065068"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2766",
      "display" : "Farmasalus",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043007"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2769",
      "display" : "DANIFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090057"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2770",
      "display" : "ditte",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091017"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2775",
      "display" : "Parafarmacia FARMADES",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078134"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2779",
      "display" : "Nocentini Group Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049014"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "2782",
      "display" : "Monpharma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090003"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2784",
      "display" : "FARMASANITARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075006"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2785",
      "display" : "Free-Farmacy",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046033"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2786",
      "display" : "CARLI & CARLI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038006"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2788",
      "display" : "ANIMALFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2791",
      "display" : "KALERBA S.A.S. DI DR. LAIN ANDREA GAETANO &amp;amp; C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2793",
      "display" : "Erboristeria Stramonio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063087"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2794",
      "display" : "parafarmacia elma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009056"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2796",
      "display" : "dott. ParaFarmacia-Erboristeria-Omeopatia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043042"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2799",
      "display" : "Parafarmacia Dott.ssa Frazzitta Antonina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081013"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2800",
      "display" : "Sanitaria Dr Rum Gabriele Mario",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090058"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2801",
      "display" : "Il Giardino dei Semplici",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037011"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-07-01"
        }
      ]
    },
    {
      "code" : "2802",
      "display" : "desan s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084011"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2803",
      "display" : "Parafarmacia dott.ssa Peluso Cesarina Rosa Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2806",
      "display" : "Parafarmacia del Tanka Village",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092100"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2810",
      "display" : "COOP LIGURIA S.C.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2812",
      "display" : "La Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015115"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2813",
      "display" : "SPAZIO CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "109034"
        },
        {
          "code" : "provincia",
          "valueCode" : "109"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "2814",
      "display" : "Nonsolofarma S.r.l. Sede",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020021"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-02-01"
        }
      ]
    },
    {
      "code" : "2815",
      "display" : "Gli Speziali della Dott.sa Grossi Franca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027020"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "2822",
      "display" : "Parafarmacia Fontò Agata",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075084"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2823",
      "display" : "mittsu srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-11-01"
        }
      ]
    },
    {
      "code" : "2825",
      "display" : "Parafarmacia Fontò Agata",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075090"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2828",
      "display" : "Spazio Conad",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074010"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-09-01"
        }
      ]
    },
    {
      "code" : "2830",
      "display" : "CONAD PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-11-01"
        }
      ]
    },
    {
      "code" : "2831",
      "display" : "JONICA RETAIL SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-02-01"
        }
      ]
    },
    {
      "code" : "2832",
      "display" : "INSIEME SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090047"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-08-01"
        }
      ]
    },
    {
      "code" : "2833",
      "display" : "PARAFARMACIA CONAD RESCALDINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015181"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-04-01"
        }
      ]
    },
    {
      "code" : "2834",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058120"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2835",
      "display" : "PARAFARMACIA CONAD BUSSOLENGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023015"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-04-01"
        }
      ]
    },
    {
      "code" : "2836",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-11-01"
        }
      ]
    },
    {
      "code" : "2837",
      "display" : "PARAFARMACIA CONAD VIMODRONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015242"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-08-01"
        }
      ]
    },
    {
      "code" : "2840",
      "display" : "D&M Group s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2841",
      "display" : "IPERCOOP MIRABELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013041"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "2842",
      "display" : "IPERCOOP CENTRO SARCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015209"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "2844",
      "display" : "FARMANIMAL di BELLOMO DOTT.SSA ROSITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089002"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2846",
      "display" : "laltrafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081021"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2849",
      "display" : "parafarmacia altea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015123"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2853",
      "display" : "001164",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "2854",
      "display" : "Parafarmacia Dott.ssa Ledda S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044066"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2856",
      "display" : "Parafarmacia d.ssa Antonella Fusaro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078003"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2857",
      "display" : "PARAFARMACIA MARRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101017"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2858",
      "display" : "Il Fior di Loto di Catoni Mauro & c. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058060"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2859",
      "display" : "Erboristeria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070078"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2860",
      "display" : "Farmashop Dr.Balbo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087040"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2861",
      "display" : "058091",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058"
        },
        {
          "code" : "provincia",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "2862",
      "display" : "Erbasan",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065025"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2864",
      "display" : "FARMASANITARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2865",
      "display" : "VOEGEL PATRICIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008055"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2866",
      "display" : "Parafarmacia Dr.ssa Monica Isabella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034018"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2867",
      "display" : "croce verde",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089020"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2870",
      "display" : "PARAFARMACIA DELLA DOTT.SSA LUCIA FODDAI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090069"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2873",
      "display" : "Parafarmacia Alma Viva",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054002"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-10-01"
        }
      ]
    },
    {
      "code" : "2874",
      "display" : "Parafarmacia s.n.c dei dottori E. Aloisio e P.L.Br",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078010"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2875",
      "display" : "Farma-Salus",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064080"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2877",
      "display" : "LA SANITARIA SAS DI ESTEBAN POSSO PAULA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2878",
      "display" : "ALCHIMIE SRL SALUTE BENESSERE BELLEZZA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2879",
      "display" : "PARAFARMACIA DOTT.SA MAZZA DONATELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044019"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2881",
      "display" : "Ipersalute srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087004"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2882",
      "display" : "Samara di Giuseppe Sanna e Sara Saiu snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "106013"
        },
        {
          "code" : "provincia",
          "valueCode" : "106"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-07-01"
        }
      ]
    },
    {
      "code" : "2883",
      "display" : "parafarmacia g.moscati snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063030"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2885",
      "display" : "mariapaola lenzi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049003"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2887",
      "display" : "erboristeria in sole",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058029"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2892",
      "display" : "ESERCIZIO FARMACEUTICO DE.CA.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065009"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2893",
      "display" : "ESERCIZIO FARMACEUTICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086004"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2894",
      "display" : "parafarmacia rotondo' maria stella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078123"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2895",
      "display" : "Parafarmacia Dr.ssa Laura Marsili",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053006"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "2896",
      "display" : "SANITARFARM S.N.C DEI F.LLI RONSISVALLE C.&S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087047"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2897",
      "display" : "Farmasalutis",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089002"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2898",
      "display" : "PARAFARMACYA S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098031"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2899",
      "display" : "sanitaria schirone giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2906",
      "display" : "QuiSalute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036005"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2908",
      "display" : "PARAFARMACIA SALUS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035020"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2915",
      "display" : "farmasanitaria io pupo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2920",
      "display" : "Parafarmacia Moroni Ada",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062074"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2921",
      "display" : "FARMAPOINT",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069046"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2922",
      "display" : "farmaover",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "047014"
        },
        {
          "code" : "provincia",
          "valueCode" : "047"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2923",
      "display" : "FARMA SI' S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-03-01"
        }
      ]
    },
    {
      "code" : "2924",
      "display" : "Parafarmacia dott. Venneri Joe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078075"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2926",
      "display" : "Parafarmacia dr.Brembati",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2927",
      "display" : "PARAFARMACIA Dott.ssa VITALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076034"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2928",
      "display" : "SANIFARMA DI DE LUCA ROBERTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2931",
      "display" : "ERBORISTERIA I TIGLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2932",
      "display" : "Parafarmacia Il Sorriso srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063064"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "2935",
      "display" : "SANITAS SNC DI P. CERATTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080050"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2937",
      "display" : "MEDIC'S POINT SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2939",
      "display" : "L'ERBORISTERIA DI TIZIANA MUGNIECO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088003"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2943",
      "display" : "Erboristeria dott. Liddo Agata",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071060"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2947",
      "display" : "PARAFARMACIA DOTT.SSA FERRARO EMERENZIANA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063004"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2954",
      "display" : "parafarmacia europea s.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006174"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2955",
      "display" : "PARAFARMACIA MARCOZ",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008039"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2958",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050029"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2962",
      "display" : "AL HAJI ABDEL WAHAB",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090023"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2963",
      "display" : "maxifarma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2969",
      "display" : "PARAFARMACIA DOTT.SSA MARISTELLA DISANTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072041"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-02-01"
        }
      ]
    },
    {
      "code" : "2971",
      "display" : "La Farmoteka della Dott.ssa Romana Carta & C. sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092105"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2974",
      "display" : "parafarmacia dott.ssa luisa paragliola",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2975",
      "display" : "Parafarmacia Sant'Antonio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087032"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2976",
      "display" : "l'erboristeria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2977",
      "display" : "MEDI-MARKET ITALIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108051"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-08-01"
        }
      ]
    },
    {
      "code" : "2980",
      "display" : "Salus Pharma s.r.l. parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010054"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2981",
      "display" : "PARAFARMACIA STE.MAR. srls",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-11-01"
        }
      ]
    },
    {
      "code" : "2983",
      "display" : "Parafarmacia di Shatat Nasser",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2984",
      "display" : "CENTRO AGROVETE CALABRIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2988",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069050"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2989",
      "display" : "Panacea Sud del Dott.Agostino Esposito",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2992",
      "display" : "Parafarmacia San Leopoldo s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053009"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2994",
      "display" : "Tirrenopharma s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092012"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2996",
      "display" : "il cesto della salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038006"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2997",
      "display" : "BIANCO LUCIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030118"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "2999",
      "display" : "Esercizio Farmaceutico dott. Pirlo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092084"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3000",
      "display" : "ADRIANA ALBANESE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3008",
      "display" : "PARAFARMACIA RAVALDINO SAS DI BARTOLINI MONIA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "3009",
      "display" : "ditta esterna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3010",
      "display" : "Polivalente s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093018"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3013",
      "display" : "parafarmacia la lampada di Alladin",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072007"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3014",
      "display" : "Erboristeria NATURA E SALUTE di DANIELA MATTIOLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3016",
      "display" : "Parafarmacia Aiello Giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101017"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3021",
      "display" : "filrodi s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3027",
      "display" : "parafarmacia alba serena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001038"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3028",
      "display" : "Erboristeria Farmasanitaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075076"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3029",
      "display" : "parafarmacia dott.F.Landolfi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062047"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3031",
      "display" : "parafarmacia dott. pertici",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049003"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3032",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-02-01"
        }
      ]
    },
    {
      "code" : "3033",
      "display" : "DAFFARMsrl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3037",
      "display" : "Punto Salute s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3040",
      "display" : "OTTICA PICCOLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036043"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3041",
      "display" : "PARAFARMACO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061018"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-03-01"
        }
      ]
    },
    {
      "code" : "3042",
      "display" : "New Pharm del Dr.Francesco Lampis & C. S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095065"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-03-01"
        }
      ]
    },
    {
      "code" : "3045",
      "display" : "Herbapharma di Gò Annalisa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028106"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3046",
      "display" : "parafarmacia san giovanni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009034"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3048",
      "display" : "IPERAL ADAMELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017065"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-04-01"
        }
      ]
    },
    {
      "code" : "3054",
      "display" : "DACO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063080"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3055",
      "display" : "ERBAFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036039"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3059",
      "display" : "raggio di sole",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024012"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3060",
      "display" : "ASFODELO L'ERBORISTERIA DELLA DR.SSA LOCCI GRAZIAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028023"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3061",
      "display" : "015195",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "3064",
      "display" : "PARAFARMACIA BENNET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018137"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3065",
      "display" : "DUEPIU' srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070006"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3066",
      "display" : "Parafarmaciadott.ssa Santina Ferraro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078003"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3068",
      "display" : "PHARMAPIU'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090003"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3070",
      "display" : "Erboristeria dri Floris - Erboristici e Salutari-",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092032"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-01-01"
        }
      ]
    },
    {
      "code" : "3071",
      "display" : "Erboristeria Ginseng",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028064"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3073",
      "display" : "li.far.pa del dott. rocco flavio patroni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072001"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3075",
      "display" : "NATURAL WAY della D.ssa Polverino Anna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065055"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3087",
      "display" : "PARAFARMACIA  Dr  FICANI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084023"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3088",
      "display" : "GOTICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-02-01"
        }
      ]
    },
    {
      "code" : "3089",
      "display" : "pharmapoint di cau dott. ssa maurizia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "3095",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091013"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3096",
      "display" : "L'Erboristeria di Tullia Bianchini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092105"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3101",
      "display" : "FARMASANITARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083096"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3102",
      "display" : "PARAFARMACIA TERRANEGRA DI BOCCHI ARMANDINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023044"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3103",
      "display" : "Il Giardino del Re",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009049"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3104",
      "display" : "PARAFARMACIA DI VULCANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083041"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3105",
      "display" : "officine ortopediche policlinico srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "3106",
      "display" : "HEALTH PHARMACS BEAUTY parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039007"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3107",
      "display" : "PARAFARMACIA CAVOUR",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004203"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3108",
      "display" : "Laboratorio Erboristico Dott. Parla roberta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081015"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-03-01"
        }
      ]
    },
    {
      "code" : "3109",
      "display" : "024105",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "3110",
      "display" : "Parafarmacia Violante",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3111",
      "display" : "sopharma della dott.ssa rita soro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090063"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-12-01"
        }
      ]
    },
    {
      "code" : "3114",
      "display" : "parafarmacia Ducale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-08-01"
        }
      ]
    },
    {
      "code" : "3115",
      "display" : "IL FARMACISTA di DR.PIETRO PIERGROSSI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069043"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3116",
      "display" : "L'Angolo dei Sensi di Shojaei Baghini Dina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049011"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3117",
      "display" : "LAL  snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006003"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3118",
      "display" : "PARAFARMACIA DI GRECO SANTINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078079"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3122",
      "display" : "Parafarmacia C & D S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3123",
      "display" : "ASSFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087033"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3126",
      "display" : "OXA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3128",
      "display" : "erboristeria optime",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063024"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3129",
      "display" : "parafarmacia torre",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084021"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3131",
      "display" : "VETERFARM SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061015"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3132",
      "display" : "Evoli Nicolino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080082"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3134",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048043"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3135",
      "display" : "PARAFARMACIA MP",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052015"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-02-01"
        }
      ]
    },
    {
      "code" : "3136",
      "display" : "IL DECALOGO DELLA DOTT.SSA MARIA PERLA CLEMENTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3138",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048044"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3139",
      "display" : "Pharm-Natur srl Dott. Compostini Ermanno",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018153"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "3142",
      "display" : "BEAUTY MARKET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041013"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3144",
      "display" : "PARAFARMACIA BENNET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015034"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3146",
      "display" : "parafarmacia dott. Maria Conte",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059014"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3147",
      "display" : "PARAFARMACIA DR.SSA CHIAPPETTA MARILINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3148",
      "display" : "parafarmacia dott.ssa Carbone Concetta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3150",
      "display" : "Parafarmacia del Dottor Creazzo Antonino Bruno",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-04-01"
        }
      ]
    },
    {
      "code" : "3151",
      "display" : "Ipercoop La Torre",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "3152",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076063"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3153",
      "display" : "MARKET VALTREBBIA S.N.C. DI CARELLA MARINA E C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033038"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3154",
      "display" : "Parafarmacia  Valdemone  Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-05-01"
        }
      ]
    },
    {
      "code" : "3155",
      "display" : "NOVA COOP S.C. IPER CASALE MONFERRATO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006039"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3156",
      "display" : "Parafarmatre S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092050"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3157",
      "display" : "Parafarmatre S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092101"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3159",
      "display" : "Farmaci senza obbligo di ricetta s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063044"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3164",
      "display" : "LA Parafarmacia Dott.ssa Alessandra Venturini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012119"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3165",
      "display" : "MEDI-FARM Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065037"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3166",
      "display" : "MEDI-FARM Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3172",
      "display" : "Parafarmacia Dr. Santoro Alessandro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058119"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3173",
      "display" : "INTERSPAR ESTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028037"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3174",
      "display" : "INTERSPAR FERRARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3177",
      "display" : "AESCULAPIUS DI DEL PONTANO SIMONA E C. snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044060"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-01-01"
        }
      ]
    },
    {
      "code" : "3178",
      "display" : "IPER DE SANDI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3180",
      "display" : "GERMANO PIERPAOLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088003"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3181",
      "display" : "Parafarmacia Conad",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058032"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-03-01"
        }
      ]
    },
    {
      "code" : "3182",
      "display" : "parafarmacia del porto srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3183",
      "display" : "PARAFARMACIA LA MARGHERITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043024"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3185",
      "display" : "Parafarmacia dei Nebrodi S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-10-01"
        }
      ]
    },
    {
      "code" : "3191",
      "display" : "FARMAMEDICA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075057"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3198",
      "display" : "PARAFARMACIA BIOSANITARIA DR. TISI DANIELE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-12-01"
        }
      ]
    },
    {
      "code" : "3199",
      "display" : "SANIPHARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073011"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3201",
      "display" : "parafarmacia-erboristeria dr. mara pesavento",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024008"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3204",
      "display" : "profarma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3205",
      "display" : "per salute  s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027044"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3207",
      "display" : "FARMACIA BENETTI DOTT.SSE TANIA E PAOLA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029041"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-06-01"
        }
      ]
    },
    {
      "code" : "3213",
      "display" : "FRISENDA IVONNE EUGENIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-07-01"
        }
      ]
    },
    {
      "code" : "3214",
      "display" : "erbosan",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091085"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-02-01"
        }
      ]
    },
    {
      "code" : "3215",
      "display" : "nuova erboristeria domani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3216",
      "display" : "CO.DI.PA Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006039"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3217",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3218",
      "display" : "PUNTOFARMA del Dott. Giovinazzo Domenico Corrado",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087019"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-03-01"
        }
      ]
    },
    {
      "code" : "3219",
      "display" : "Parafarmacia-Dott.ssa Capraro Anna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075051"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-07-01"
        }
      ]
    },
    {
      "code" : "3221",
      "display" : "PARAFARMACIA SAN MARTINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3222",
      "display" : "parafarmacia farma.co 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016183"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3223",
      "display" : "045010",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "3225",
      "display" : "Parafarmacia Lorian",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3226",
      "display" : "PARAFARMACIA DOTT. CRINISIO ADOLFO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3227",
      "display" : "settefamiglie",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037056"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3228",
      "display" : "Coop Salute Afragola",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063002"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-02-01"
        }
      ]
    },
    {
      "code" : "3230",
      "display" : "FARMASTORE DI TRISCHITTA MASSIMO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3231",
      "display" : "FARMANOSTRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090051"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3232",
      "display" : "Zerbo Antonino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087022"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3234",
      "display" : "PARAFARMACIA SALUTE E BENESSERE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068006"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3236",
      "display" : "zooagricoli s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-10-01"
        }
      ]
    },
    {
      "code" : "3238",
      "display" : "G3 s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3239",
      "display" : "NEW PHARMA DI SABATO NOVIELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064054"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3241",
      "display" : "Monili Store",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3243",
      "display" : "BRUALFARM S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083049"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3244",
      "display" : "MEDICAL SERVICE DEL DOTT. GINO RICCIOTTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3246",
      "display" : "parafarmacia idea salute s.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054015"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3248",
      "display" : "BELLUCCI ELISA PARAFARMACIA SALUTE E BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099020"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3249",
      "display" : "PARAFARMACIA VIVERE SANI F.LLI ORTOLANI E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040045"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3252",
      "display" : "Il Trifoglio del Dr. G. Caruso & C. sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078108"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3253",
      "display" : "Maria Stella Spasari",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089001"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-02-01"
        }
      ]
    },
    {
      "code" : "3255",
      "display" : "PARAFARMACIA LUCREZIA ROMANA SNC DEI DOTTORI MARISA VANNI E GIANLUCA SANZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-03-01"
        }
      ]
    },
    {
      "code" : "3256",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008031"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3258",
      "display" : "centro farmaceutico veterinario",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082014"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3263",
      "display" : "Erboristeria Nova Salus",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "096020"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3266",
      "display" : "salus zoo srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001059"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-07-01"
        }
      ]
    },
    {
      "code" : "3267",
      "display" : "biofarma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3268",
      "display" : "PARAFARMACIA DELLA DOTT.SSA ELVIRA DEMETRIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077014"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3271",
      "display" : "TRE PER TE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012026"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3272",
      "display" : "L'elisir",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3274",
      "display" : "IPERCOOP PIAZZA LODI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "3277",
      "display" : "Naturalba",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027034"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-05-01"
        }
      ]
    },
    {
      "code" : "3278",
      "display" : "Parafarmacia Ruspaggiari Dott. Stefano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035028"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3283",
      "display" : "PARAFARMACIA SAN CARLO di CIESSE PHARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3285",
      "display" : "Alchemilla di Dray Carlo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004081"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3286",
      "display" : "Parafarmacia S.Margherita di Cristante dssa Alice",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093013"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3287",
      "display" : "Parafarmacia S.Margherita di Cristante dssa Alice",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030049"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3288",
      "display" : "Parafarmacia S.Margherita di Cristante dssa Alice",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093043"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3289",
      "display" : "Parafarmacia Sanitaria Dott.ssa Ercolani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3290",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044060"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3295",
      "display" : "017092",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "3296",
      "display" : "parafarmacia dottor Ciccarello",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3297",
      "display" : "ALIPHARMA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006001"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3298",
      "display" : "PARAFARMACIAPIU' SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3299",
      "display" : "PARAFARMACIA SANT'ANDREA DI PELIZZIARI MONICA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3300",
      "display" : "PARAFARMACIA DOTT. ANNA MARIA SAMBATARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087007"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3303",
      "display" : "GIOFARM",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069046"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3304",
      "display" : "Pharma Beautyque",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015182"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3305",
      "display" : "FARMAPIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3308",
      "display" : "la sanitaria di Castaldo Mario",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063069"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3309",
      "display" : "FARMASHOP",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3312",
      "display" : "Farma Aroma di dr.Tacchini Emanuela Marina Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018139"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3314",
      "display" : "Anna S.a.s. di Codina Miriam & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042010"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3315",
      "display" : "Parafarmacia San Michele",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009001"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3317",
      "display" : "Erboristeria Parafarmacia I Semplici",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028001"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3318",
      "display" : "gaaspharma grandemela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023083"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-09-01"
        }
      ]
    },
    {
      "code" : "3321",
      "display" : "Parafarmacia Dott.ssa Duce Elena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001249"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3323",
      "display" : "Parafarmacia Montanari Maria Grazia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030046"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-06-01"
        }
      ]
    },
    {
      "code" : "3324",
      "display" : "Phytochemistry",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074007"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3325",
      "display" : "Salus santa Barbara S.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092070"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-02-01"
        }
      ]
    },
    {
      "code" : "3327",
      "display" : "Farmaservice Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071020"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3328",
      "display" : "san basilio sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077020"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3331",
      "display" : "sanitaria bf srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3332",
      "display" : "Parafarmacia Muliero Tommaso & C. snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077020"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-04-01"
        }
      ]
    },
    {
      "code" : "3334",
      "display" : "015051",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "3335",
      "display" : "SANITARIA COVIELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "057027"
        },
        {
          "code" : "provincia",
          "valueCode" : "057"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3336",
      "display" : "PHARMASHOP",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063053"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3337",
      "display" : "016198",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "3341",
      "display" : "farmogliastra srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091095"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3347",
      "display" : "Le erbe medicinali",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063052"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3348",
      "display" : "NATURAMICA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3349",
      "display" : "CORNER ROZZANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015189"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-12-01"
        }
      ]
    },
    {
      "code" : "3350",
      "display" : "Parafarmacia Dott.ssa Barbara Bertin",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028044"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3351",
      "display" : "FARMAROSA della dott.ssa daniela cuccaru",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090058"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3352",
      "display" : "+Medical Quartu Sant'Elena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092051"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "3353",
      "display" : "farmaover",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3355",
      "display" : "EuroC7 srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072025"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3359",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093044"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3362",
      "display" : "PARAFARMACIA dr.ssa Solidoro Marianna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075064"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-01-01"
        }
      ]
    },
    {
      "code" : "3364",
      "display" : "Raone Antonietta Grazia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075016"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3365",
      "display" : "Bio PArafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-03-01"
        }
      ]
    },
    {
      "code" : "3366",
      "display" : "PARAFARMACIA SAN FRANCESCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009001"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3367",
      "display" : "Il Frutteto s.a.s. della Dott. Rosalina Costa & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010015"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-01-01"
        }
      ]
    },
    {
      "code" : "3368",
      "display" : "AQUILEGIA SNC - IL GIARDINO DELLA SALUTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "031016"
        },
        {
          "code" : "provincia",
          "valueCode" : "031"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-11-01"
        }
      ]
    },
    {
      "code" : "3371",
      "display" : "erb.farmacia delle erbe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3374",
      "display" : "MSG DI LAURA SORGENTONE &C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067040"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3375",
      "display" : "MSG DI LAURA SORGENTONE &C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044007"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3376",
      "display" : "MSG DI LAURA SORGENTONE &C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3377",
      "display" : "treffe farma salute srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078033"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3380",
      "display" : "PARAFARMACIA D.SSA FILOMENA AGNESE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078083"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3383",
      "display" : "Farma Point",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008065"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-03-01"
        }
      ]
    },
    {
      "code" : "3385",
      "display" : "NATURALFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069099"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3387",
      "display" : "erbofarmasan sud",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073024"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3388",
      "display" : "centro commerciale  i decumani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061100"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3389",
      "display" : "centro commeriale appia center",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061092"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3390",
      "display" : "Parafarmacia delle Grazie",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063035"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3392",
      "display" : "FARMA-IN SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3394",
      "display" : "Erboristeria Ancusa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022139"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3397",
      "display" : "lafalce rossella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083089"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3399",
      "display" : "DR.SSA MELIS STEFANIA PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092050"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3400",
      "display" : "Erboristeria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072011"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3401",
      "display" : "Parafarmacia Dott. Rivetti Marco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004025"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3402",
      "display" : "Parapharmacia di Molandi Pierantonio e Alberto s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-09-01"
        }
      ]
    },
    {
      "code" : "3403",
      "display" : "FARMASANITARIA DELLA DOTT.SSA R.ROMEO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3404",
      "display" : "PARAFARMACIA DOTT. LENZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3408",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-01-01"
        }
      ]
    },
    {
      "code" : "3411",
      "display" : "Parafarmacia San Martino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078150"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3413",
      "display" : "B.& G. TRADE PHARM S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048021"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3414",
      "display" : "MARESCALCO CHIARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087004"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3415",
      "display" : "ME.PI FARMA s.a.s diAndrea Picchie C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033021"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-02-01"
        }
      ]
    },
    {
      "code" : "3418",
      "display" : "Parafarmacia alla Stazione srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "3420",
      "display" : "IPERCOOP CENTRO NOVA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037021"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "3421",
      "display" : "parafarmacia salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015182"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-01-01"
        }
      ]
    },
    {
      "code" : "3423",
      "display" : "benessere sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052021"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-05-01"
        }
      ]
    },
    {
      "code" : "3426",
      "display" : "Supermercato al Risparmio cinque srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072012"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3427",
      "display" : "SANIFARM SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054001"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-04-01"
        }
      ]
    },
    {
      "code" : "3429",
      "display" : "parafarmacia dr.ssa Giacalone Maria Concetta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081012"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3431",
      "display" : "ORTHOFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111071"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-02-01"
        }
      ]
    },
    {
      "code" : "3432",
      "display" : "FARMAMICA di Fiumarella Dario",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078122"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3433",
      "display" : "Parafarmacia Dott. Filippo Spasari",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079081"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3434",
      "display" : "parafarmacia regina elena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004089"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3435",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078051"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3436",
      "display" : "My Farma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090047"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3437",
      "display" : "Friscia Michela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084041"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3438",
      "display" : "Pharmacenter di Albano Alfonso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082027"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-04-01"
        }
      ]
    },
    {
      "code" : "3442",
      "display" : "Parafarmacia Dr.ssa Salmeri Marina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-03-01"
        }
      ]
    },
    {
      "code" : "3443",
      "display" : "PHYTOFARMACIA DELLA DOTT.SSA PINTO ANNA LAURA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078103"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "3445",
      "display" : "Parafarmacia Dott. Federico Ferrari",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079146"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3446",
      "display" : "PARAFARMACIA Dott. Luigi Buono",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063031"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3447",
      "display" : "Parafarmacia-Erboristeria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3450",
      "display" : "PHARMASINERGY TORTORETO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067044"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "3453",
      "display" : "PARAFARMACIA L'ALOE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3455",
      "display" : "la parafarmacia s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092090"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3456",
      "display" : "MV Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083032"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3458",
      "display" : "Parafarmacia Due Fiumi di Tancredi & Naccarato snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3459",
      "display" : "PARAFARMACIA DR.SSA LUISA SCAPPIN & C.SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026086"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3460",
      "display" : "Pharmastore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3461",
      "display" : "Dott. Bearzot di Bearzot Francesca & C.s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032001"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3462",
      "display" : "Parafarmacia Erboristeria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078058"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3464",
      "display" : "PARAPHARMACIA LA CICOGNA S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061027"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3465",
      "display" : "ERBORISTERIA LA GINESTRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078003"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3466",
      "display" : "Parafarmacia Sacro Cuore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095038"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3467",
      "display" : "Parafarmacia NewPharm di Tondi Silvana e C. s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075023"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3468",
      "display" : "Parafarmacia Farmadel",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090047"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3470",
      "display" : "Parafarmacia Dott. Pinna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090006"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3477",
      "display" : "Parafarmacia del viale del Dott. Roberto Zichichi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081021"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-01-01"
        }
      ]
    },
    {
      "code" : "3478",
      "display" : "Parafarmacia loiacono dott. Fortunato",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102030"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3484",
      "display" : "FARMACOM Parafarmacia di Sechi Rossana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091044"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3485",
      "display" : "farmaverde di pignatelli maddalena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017170"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3486",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3488",
      "display" : "Esercizio Farmaceutico Dott.ssa Luisa Tramatzu",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092039"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3489",
      "display" : "Farmaover",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048040"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3492",
      "display" : "erbosanitaria finalpa srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-01-01"
        }
      ]
    },
    {
      "code" : "3493",
      "display" : "FARMA HERBE PARAFARMACIA DOTT.SSA FERRARO PIERA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082049"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3495",
      "display" : "Ditta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078101"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3496",
      "display" : "ERBOR FARMA SALUTE E NATURA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037038"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3497",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018171"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3498",
      "display" : "Parafarmacia Salute e benessere di Ravera Angela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006012"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-05-01"
        }
      ]
    },
    {
      "code" : "3499",
      "display" : "PARAFARMACIA SAN MICHELE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009002"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3501",
      "display" : "Ambra S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046024"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "3502",
      "display" : "Parafarmacia srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073007"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3503",
      "display" : "Parafarmacia Mediacenter",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015081"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3505",
      "display" : "PARAFARMACIA BENNET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013095"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3506",
      "display" : "PARAFARMACIA BEAUTY & PHARM",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063037"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3507",
      "display" : "Parafarmacia Baby & Beauty",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063019"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3509",
      "display" : "PARAFARMACIA D.SSA LAURA MANFREDI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101025"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3510",
      "display" : "PARAFARMACIA DELLA STAZIONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3511",
      "display" : "PARAFARMACIA BELLINZAGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003016"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-06-01"
        }
      ]
    },
    {
      "code" : "3512",
      "display" : "parafarmacia dott.nappi maria carmen",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3518",
      "display" : "PARAFARMACIA DEL MARE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075052"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3520",
      "display" : "Fitodermosan di Lusci anna Rita",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090029"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "3521",
      "display" : "Parafarmacia Tellus Dt.ssa Lavinia Vistoli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053018"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-05-01"
        }
      ]
    },
    {
      "code" : "3522",
      "display" : "NOVA COOP S.C. BEINASCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001024"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3523",
      "display" : "001272",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "3524",
      "display" : "Pharmacorner",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075090"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3525",
      "display" : "farmapoint",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060063"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3526",
      "display" : "Parafarmacia Kennedy",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3528",
      "display" : "PARAFARMACIA DR.SSA BERTOLINI LILIANA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001013"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3529",
      "display" : "L'ALBERO AL SOLE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072027"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3531",
      "display" : "elisir",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063052"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3532",
      "display" : "GATTU FRANCESCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090049"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3533",
      "display" : "Punto Salute Dott.ssa Toti Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060058"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-02-01"
        }
      ]
    },
    {
      "code" : "3541",
      "display" : "FARMANTICA MAMELI s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089002"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-03-01"
        }
      ]
    },
    {
      "code" : "3542",
      "display" : "parafarmacia d.ssa Rivela Elisabetta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3543",
      "display" : "FARMAVERDE SNC dei Dott Ferraretto S e Magarotto S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3544",
      "display" : "AREAFARMA DI TRINACRIA PHARMA SERVIZI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087004"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3545",
      "display" : "CORNER PARAFARMACIA c/o IPER SIMPLY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087004"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3549",
      "display" : "ESSERE BENESSERE SPA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017069"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3553",
      "display" : "Parafarmacia Natura & Benessere",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083105"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3554",
      "display" : "dott.alagna giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3555",
      "display" : "parafarmacia dott.a.caruso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3561",
      "display" : "farmaconf",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087008"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3562",
      "display" : "erboristeria, parafarmacia drssa Franz Sabrina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3564",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3566",
      "display" : "FARMAPOINT",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087011"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3568",
      "display" : "PARAFARMACIA VERCELLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002158"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3569",
      "display" : "parafarmacia verdeaqua",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018078"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3572",
      "display" : "PARAFARMACIA Dott.ssa DAZIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004078"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3574",
      "display" : "PARAFARMACIA D.SSA LO RUSSO CLORINDA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3578",
      "display" : "norma garbarino parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009002"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3582",
      "display" : "aloi  grazia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083005"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3584",
      "display" : "CENTRO SALUTE ASCLEPIOS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095038"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3588",
      "display" : "PARAFARMACIA L'ERBAMEDICA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075003"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3590",
      "display" : "R.S.M Maria snc di Saravi R.-Esmaily Z. e M.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3591",
      "display" : "PARAFARMACIA DR. DI LENA CLAUDIO LUIGI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070078"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3594",
      "display" : "LaFarmacista Alfa sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075057"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "3595",
      "display" : "FARMASHOP",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064038"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3596",
      "display" : "durante nunzia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062037"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3597",
      "display" : "Dermofarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3598",
      "display" : "002158",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "3599",
      "display" : "Ipermercato CARREFOUR Novara",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3600",
      "display" : "027020",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "3604",
      "display" : "sanipharm parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065132"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3605",
      "display" : "Medipharm srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3607",
      "display" : "NGS Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087048"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3609",
      "display" : "Sosta Salute Igea 4",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048001"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3611",
      "display" : "La Clorofilla di Eliseo Elisa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3615",
      "display" : "parafarmacia dott Carmela Moscariello",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064057"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3618",
      "display" : "PHARMAPETRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018073"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3619",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3620",
      "display" : "Parafarmacia Starbene",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087033"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3621",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3622",
      "display" : "Parafarmacia dottoressa Denina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004130"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3623",
      "display" : "MAPIFAR srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060038"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "3625",
      "display" : "rossi claudia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3629",
      "display" : "erboristeria il fiore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3630",
      "display" : "FARMAPIU' SRL UNIPERSONALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069017"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-09-01"
        }
      ]
    },
    {
      "code" : "3633",
      "display" : "PARAFARMACIA CASTEL PORZIANO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3638",
      "display" : "PARAFARMACIA TORRINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3639",
      "display" : "parafarmacia Dr. Adbaya",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017081"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3640",
      "display" : "Parapharmacia srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072027"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3644",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015077"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3645",
      "display" : "SALICE BIANCO snc di Barcaglioni Laura & Todesco E",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026076"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3650",
      "display" : "012133",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "3652",
      "display" : "Parafarmacia Kennedy",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015192"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3653",
      "display" : "PARAFARMACIA Dott. Gheza",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017156"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3654",
      "display" : "SAVA PHARMA S.A.S. DI IDA NADIA ZANIRATO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002158"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3656",
      "display" : "La Farmacista",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "3658",
      "display" : "Farma-donna S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "3659",
      "display" : "Parafarmacia della salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3660",
      "display" : "Parafarmacia-erboristeria d.ssa Naclerio Maria Ser",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063003"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3661",
      "display" : "PARAFARMACIA OMEO NATUR FARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3662",
      "display" : "PARAFARMACI dott.ssa SEGHIZZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017159"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "3665",
      "display" : "pharma house srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3670",
      "display" : "Erboristeria-Articoli Sanitari",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091009"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3675",
      "display" : "Parafarmacia dr.R.D'Urso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3679",
      "display" : "FARMACIA DEI SOP & OTC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061103"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3681",
      "display" : "CELI MARCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3684",
      "display" : "erboristeria sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081011"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3686",
      "display" : "ARS MEDICA DI LAURA BALDUCCI & LORENZA VENTURA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022143"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3690",
      "display" : "erboristeria parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087049"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3692",
      "display" : "HOSPITAL S.a.S. DEL Dr. COLOSI NICOLO' & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3696",
      "display" : "APOTECA BENESSERE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3697",
      "display" : "parafarmacia dott.ssa iolanda milie'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079127"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3702",
      "display" : "bio.vet",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092078"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3703",
      "display" : "parafarmacia l'assenzio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009057"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3705",
      "display" : "FARMA + ERBE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058043"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-01-01"
        }
      ]
    },
    {
      "code" : "3706",
      "display" : "SANITARIA D'AMBROGI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058072"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3708",
      "display" : "NOVE LUNE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076039"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3712",
      "display" : "PARAFARMACIA SANITARIA DOTT.SSA CETTY MOLLICA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3713",
      "display" : "Ditta individuale Giammarresi Carmela Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026063"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3715",
      "display" : "Parafarmacia Dott. Barone Antonio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080057"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3718",
      "display" : "Farmaceutica Sanitaria Erb. dott. Angelina Lodi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058059"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3720",
      "display" : "PARAFARMACIA DEL CORSO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3721",
      "display" : "Parafarmacia Dr. lembo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3724",
      "display" : "erboristeria parafarmacia dott salvatore grasso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075006"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3729",
      "display" : "parafarmacia dott.ssa Cesarini Antonella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053014"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3731",
      "display" : "FARMAPOINT di Salvatore Scianna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082004"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-07-01"
        }
      ]
    },
    {
      "code" : "3733",
      "display" : "Parafarmacia Dr. Francesco Maiorana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006001"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-06-01"
        }
      ]
    },
    {
      "code" : "3735",
      "display" : "Farmasanitaria Longo Stefana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083054"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3737",
      "display" : "Dueffe Farmaceutici S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001249"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3738",
      "display" : "Parafarmacia Dott. Gucciardino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084017"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3739",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091063"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3740",
      "display" : "Parafarmacia Palladium",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017179"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-07-01"
        }
      ]
    },
    {
      "code" : "3742",
      "display" : "PARAFARMACIA ROMEA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040007"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3744",
      "display" : "gioima.snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061015"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3746",
      "display" : "Farma Salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3747",
      "display" : "PARAFARMACIA DOTT. G. LACROCE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079137"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3749",
      "display" : "GDL no food Spendidi & Splendenti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080067"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3750",
      "display" : "GDL no food Splendidi & Splendenti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102047"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3751",
      "display" : "Vetar Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095006"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-05-01"
        }
      ]
    },
    {
      "code" : "3755",
      "display" : "FARMAVET DI INTURRI DR. PAOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3756",
      "display" : "FARMAS SNC di Licari Giuseppina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081011"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3758",
      "display" : "SHOPPING PHARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098031"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3760",
      "display" : "Parafarmacia Dr Di Novella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065114"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3762",
      "display" : "PARAFARMACIA SANT'ANTONIO ABATE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087007"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-11-01"
        }
      ]
    },
    {
      "code" : "3763",
      "display" : "PARAFARMACIA PIEVE DI SOLIGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026057"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3764",
      "display" : "PARAFARMACIA ADRIATICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027029"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3766",
      "display" : "PARAFARMACIA MISIANI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037020"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3767",
      "display" : "parafarmacia dr.khorassani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001078"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3768",
      "display" : "Farmaci 01 s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082035"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3771",
      "display" : "Parafarmacia D.ssa Rivela Rita",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3773",
      "display" : "la bottega della salute di ma.vi.si",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084017"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3775",
      "display" : "ERBORISTERIA DOTT.SSA G.TUMINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098019"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3777",
      "display" : "MONTI SALUTE SNC DI MONTI LAURA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002133"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3780",
      "display" : "LA PARAFARMACIA DI PAOLA E SILVIA STRIGAZZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018069"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3781",
      "display" : "parafarmacia dott.ssa piluso annafranca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3786",
      "display" : "Parafarmacia La Coccinella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063074"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3787",
      "display" : "Borgo Natura",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037052"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-08-01"
        }
      ]
    },
    {
      "code" : "3794",
      "display" : "FARMASAN di G.Asuni &C S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092074"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3796",
      "display" : "PARAFARMACIA DOTT. PASQUALE PAGANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065099"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3797",
      "display" : "ANTONELLI GUIDO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030038"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3800",
      "display" : "Parafarmacia Dott.ssa M. Coscarella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046011"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3803",
      "display" : "parafarmacia auranova di rodegher alessandra&c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3808",
      "display" : "PARAFARMACIA Dott.ssa Ruffin S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3809",
      "display" : "Parafarmacia Gruppioni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037059"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3810",
      "display" : "parafarmacia dot.ssa Cafaro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065099"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3811",
      "display" : "PARAFARMACIA DR. STELLA LAURA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099002"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3812",
      "display" : "FARMAPIU' di Aliberti Sofia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065013"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-04-01"
        }
      ]
    },
    {
      "code" : "3815",
      "display" : "Iperfarma Seriate",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016198"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3817",
      "display" : "PARAFARMACIA FARNESE DI NANI CAMILLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3818",
      "display" : "Parafarmacia di Pratolino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048046"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3821",
      "display" : "PARAFARMACIA MONDO ROSA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3824",
      "display" : "parafarmacia d.ssa paiano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078108"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3828",
      "display" : "PHARMA SOP S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076063"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3829",
      "display" : "PHARMA SOP S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061005"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3830",
      "display" : "PHARMA SOP S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3831",
      "display" : "PARAFARMACIA DOTT.SSA NADIA MOCELLINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028099"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3833",
      "display" : "P&P S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079059"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3834",
      "display" : "PARAFARMACIA CARIDI PASQUALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080029"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3836",
      "display" : "FARMAREGNO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042045"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-02-01"
        }
      ]
    },
    {
      "code" : "3838",
      "display" : "PARAFARMACIA DR. TENTI MARINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3843",
      "display" : "Farmamia snc di Buoni Marianne e Donato Carla",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052017"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3844",
      "display" : "PARAFARMACIA DG&A",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3845",
      "display" : "PARAFARMACIA S FAUSTINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-03-01"
        }
      ]
    },
    {
      "code" : "3846",
      "display" : "PARAFARMACIA INSIEME SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019036"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-03-01"
        }
      ]
    },
    {
      "code" : "3848",
      "display" : "lenta marzia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001171"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3849",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3850",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3851",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001191"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3852",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001038"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3854",
      "display" : "DI BARTOLOMEO MARIA ROSA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059032"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3855",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001214"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3856",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001156"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3857",
      "display" : "Parafarmacia San Defendente",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006001"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3860",
      "display" : "ERBORISTERIA NATUR",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083032"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3861",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034014"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-01-01"
        }
      ]
    },
    {
      "code" : "3862",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048021"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3863",
      "display" : "PARAFARMACIA UMBRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3865",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050008"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3866",
      "display" : "FARMA SANT'ANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087011"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-04-01"
        }
      ]
    },
    {
      "code" : "3867",
      "display" : "Parafarmacia Villa Mosca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067041"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3868",
      "display" : "Polivalente s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027029"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3875",
      "display" : "BELICITTA'  Centro Commerciale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081006"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3876",
      "display" : "Farmavitae uno",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-08-01"
        }
      ]
    },
    {
      "code" : "3877",
      "display" : "MOSCARIELLO IRENE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063081"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3878",
      "display" : "PARAFARMACIA DR.SSA MASINI MARIATERESA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3879",
      "display" : "GE.MA. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3880",
      "display" : "GE.MA. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3881",
      "display" : "PARAFARMACIA AZZURRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3882",
      "display" : "FARMAVITA Sas di Secchi Battistina & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091063"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "3883",
      "display" : "Parafarmacia Centro Salute Attiva",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041013"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3886",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017061"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3887",
      "display" : "NORDOVEST INSIEME SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-01-01"
        }
      ]
    },
    {
      "code" : "3890",
      "display" : "Iper Montebello Spa - Iper Castelfranco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026012"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3892",
      "display" : "luppino domenico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3894",
      "display" : "PARAFARMACIA CASELLE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001063"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3896",
      "display" : "pharmacenter",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075030"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3899",
      "display" : "CARTA MARIA CLAUDIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3900",
      "display" : "l' angolo della salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048041"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3902",
      "display" : "Europarafarmacie",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012070"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-03-01"
        }
      ]
    },
    {
      "code" : "3903",
      "display" : "PARAFARMACIA OLIVIA DOTT.SSA ROBERTA RINALDUCCI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054051"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "3909",
      "display" : "Parafarmacia Valentini Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013075"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-03-01"
        }
      ]
    },
    {
      "code" : "3910",
      "display" : "NATURPHARM S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3914",
      "display" : "De Nisco Bianca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062002"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3915",
      "display" : "Parafarmacia dott.ssa Sittoni Angela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022139"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3918",
      "display" : "mittsu srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027038"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3919",
      "display" : "mittsu srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3921",
      "display" : "Parafarmacia Erboristeria l'angolo della natura",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089010"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "3923",
      "display" : "Parafarmacia Orlando",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070078"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3924",
      "display" : "parafarmacia sant'emilio snc di bruna-rosso camill",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3925",
      "display" : "Parafarmacia Orlando",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "094023"
        },
        {
          "code" : "provincia",
          "valueCode" : "094"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3926",
      "display" : "DARMA IL FARMASTORE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3930",
      "display" : "elisir bottega delle erbe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3932",
      "display" : "FARMASHOP SNC DI G. E M.M. SAGHEDDU",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092092"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3934",
      "display" : "PARAFARMACIA CASA DELLA SALUTE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3935",
      "display" : "PARAFARMACIA SALUTE E NATURA S.N.C. DI VISANI MARIA NIVES E SCUDELLARI MARIAPIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039010"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "3936",
      "display" : "PARAFARMACIA Dott. SATTA srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104004"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3938",
      "display" : "mittsu srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3939",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065055"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3940",
      "display" : "Dr. Stival Giancarlo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093032"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3941",
      "display" : "Siderfarma di Romanello Teresa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080088"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3942",
      "display" : "MONDO FARMA di Pescosolido Teresa & C. S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065014"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3943",
      "display" : "PARAFARMACIA CASA DELLA SALUTE SRL.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3944",
      "display" : "PARAFARMACIA CASA DELLA SALUTE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3946",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009056"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3949",
      "display" : "ALVIN DI TRUPIA ALESSIO S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-09-01"
        }
      ]
    },
    {
      "code" : "3950",
      "display" : "GEOPHARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080029"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-11-01"
        }
      ]
    },
    {
      "code" : "3951",
      "display" : "PARAFARMACIA MADIO SANI. FARM.di MADIO GIACOMO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3952",
      "display" : "Apoteka S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092080"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "3955",
      "display" : "PARAFARMACIA MASSETANA DI PARISI ROBERTA & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "3957",
      "display" : "parafarmacia s. maria delle grazie",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3958",
      "display" : "Parafarmacia delladott.ssa Rota Alessandra",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078028"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3959",
      "display" : "cuzzocrea filomena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3960",
      "display" : "LA GINESTRA di ELISABETTA DE MICHELE S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3961",
      "display" : "DADO SRLS UNIPERSONALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009049"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-06-01"
        }
      ]
    },
    {
      "code" : "3963",
      "display" : "PUNTOFARMA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095038"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3964",
      "display" : "Parafarmacia Dott.ssa Ambrosini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036005"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-03-01"
        }
      ]
    },
    {
      "code" : "3967",
      "display" : "012122",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "3968",
      "display" : "026012",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "3971",
      "display" : "' U SPIZIALI DI AIELLO GERMANA  C.SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087030"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-06-01"
        }
      ]
    },
    {
      "code" : "3973",
      "display" : "FARMAPIU' DI LUITPRANDI LORETTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020039"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3975",
      "display" : "BARCA DENTAL 3.0 S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-03-01"
        }
      ]
    },
    {
      "code" : "3976",
      "display" : "Inserra Anna Lisa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087005"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "3981",
      "display" : "GPFARMACI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089005"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3984",
      "display" : "PARAFARMACIA EUROPA DI FILOMENA RUSSANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028058"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3985",
      "display" : "parafarmacia venezia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085007"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3991",
      "display" : "PARAPHARMACIA SALUS DI DR. MANZO MASSIMILIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065137"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3993",
      "display" : "BOCCHIARO MARIA GRAZIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082048"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3994",
      "display" : "PARAFARMACIA SAN ROCCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004180"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3995",
      "display" : "Parafarmacia, Dott. Falsone Lillo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084027"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "3996",
      "display" : "NUOVA FARMA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006121"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-10-01"
        }
      ]
    },
    {
      "code" : "3998",
      "display" : "PARAFARMACIA CONAD MERATE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "097048"
        },
        {
          "code" : "provincia",
          "valueCode" : "097"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4005",
      "display" : "FARMAMIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "057059"
        },
        {
          "code" : "provincia",
          "valueCode" : "057"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4009",
      "display" : "Farmaflor Pavia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-11-01"
        }
      ]
    },
    {
      "code" : "4010",
      "display" : "farmacity",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042018"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4012",
      "display" : "Parafarmacia dott.ssa  Barbara Brancaccio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076039"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4015",
      "display" : "Metafarm s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058007"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4016",
      "display" : "NOVA COOP S.C. IPER CUNEO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004078"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-10-01"
        }
      ]
    },
    {
      "code" : "4018",
      "display" : "Parafarmacia Farma.Gi di Dr.ssa Pistoni & C. snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043047"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4020",
      "display" : "Coop Liguria s.c.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004130"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4021",
      "display" : "SIMONE IRMA VITTORIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080067"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4022",
      "display" : "Parafarmacia Kalos della Dr.ssa Flesca Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-03-01"
        }
      ]
    },
    {
      "code" : "4024",
      "display" : "parafarmacia dott.ssa de angelis fabrizia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063080"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4025",
      "display" : "parafarmacia gea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040008"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4026",
      "display" : "PARAFARMACIA CRUCIANI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043042"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4027",
      "display" : "FARMAtutto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011016"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4028",
      "display" : "parafarmacia farmaitalia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065035"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-09-01"
        }
      ]
    },
    {
      "code" : "4031",
      "display" : "Parafarmacia Capocasa Stefania",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044057"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4033",
      "display" : "PARAFARMACIA MADONNA DELLE GRAZIE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4034",
      "display" : "FARMASHOP INTERNAZIONALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063053"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4035",
      "display" : "VALDIMAGRA STORE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011026"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-12-01"
        }
      ]
    },
    {
      "code" : "4036",
      "display" : "PARAFARMACIA VIBO CENTER SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102047"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-11-01"
        }
      ]
    },
    {
      "code" : "4038",
      "display" : "IUXTAPHARMA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-06-01"
        }
      ]
    },
    {
      "code" : "4040",
      "display" : "Flora.it s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050035"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4042",
      "display" : "PARAFARMACIA PIGA Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-12-01"
        }
      ]
    },
    {
      "code" : "4043",
      "display" : "PARAFARMACIA DEL CORSO di Perri Dr.ssa Debora",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078081"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-06-01"
        }
      ]
    },
    {
      "code" : "4045",
      "display" : "Parafarmacia di Civran dr. Marco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026021"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4046",
      "display" : "'EUROSPAR' GRUPPO 6 GDO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084001"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4047",
      "display" : "'EUROSPAR' GRUPPO 6 GDO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084011"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4049",
      "display" : "Farmasalute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075052"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4050",
      "display" : "parafarmacia giulio cesare",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4056",
      "display" : "SG international srl unipersonale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065122"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-05-01"
        }
      ]
    },
    {
      "code" : "4057",
      "display" : "PARAFARMACIA SAN MARTINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059010"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4058",
      "display" : "QUINTESSENZA DELLA DOTT.SSA PATRIZIA RAGUSA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4061",
      "display" : "BUDETTA FARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065073"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "4063",
      "display" : "Parafarmacia Dott.ri Palmieri JVs.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071056"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4064",
      "display" : "Parafarmacia dott.sa Pacetti Luana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042014"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4067",
      "display" : "EUPHARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4069",
      "display" : "CORNER AREAFARMA CITYPER OGNINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4070",
      "display" : "MATTIA LILIANA IRENE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4072",
      "display" : "Farmaover",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026086"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4073",
      "display" : "Gaia di Tondo Manlio e c. s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030118"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4077",
      "display" : "PARAFARMACIA SANITARIA DI ANNALISA BLASI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058057"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4080",
      "display" : "Parafarmacia Salute & Bellezza Dott.ssa Mancino R.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076036"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-09-01"
        }
      ]
    },
    {
      "code" : "4082",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092011"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4083",
      "display" : "Corner Cremona",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019046"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "4084",
      "display" : "IPERCOOP SCHIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024100"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "4085",
      "display" : "Ignazio Picone s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084041"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4088",
      "display" : "La Parafarmacia sas della Dott.ssa Sterni Lucia Maria e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015209"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "4089",
      "display" : "Pharma 2 di Rispoli e Lauretano s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065102"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4090",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102044"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4091",
      "display" : "BIANCHINI MASSONI ALESSANDRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4092",
      "display" : "Bancofarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087051"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-01-01"
        }
      ]
    },
    {
      "code" : "4093",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064101"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4094",
      "display" : "Erboristeria Dott. Mora Roberta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4097",
      "display" : "Parafarmacia D.ssa Casella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083076"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4098",
      "display" : "Parafarmacia Dott.Marchisio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009018"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4100",
      "display" : "PARAFARMACIA DOTT.SSA VITA RITA ANGILERI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081011"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-09-01"
        }
      ]
    },
    {
      "code" : "4101",
      "display" : "Parafarmacia Vivasalute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4102",
      "display" : "Parafarmacia Vivasalute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4103",
      "display" : "Parafarmacia Vivasalute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4106",
      "display" : "dott.ssa Maria Concetta-Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085005"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "4109",
      "display" : "RIZZOLA SERGIO E OGLIETTI PIERA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002049"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4110",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046033"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4112",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023095"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4113",
      "display" : "Farmanova srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070078"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4114",
      "display" : "parafarmacia del corso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061019"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4117",
      "display" : "capa's srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066098"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4118",
      "display" : "PARAFARMACIA CENTRALE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4122",
      "display" : "LA PARAFARMACIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061087"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-10-01"
        }
      ]
    },
    {
      "code" : "4124",
      "display" : "PARAFARMACIA VIA GIULIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4126",
      "display" : "PARAFARMACIA CENTRO COMMERCIALE DIMA SHOPPING",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4130",
      "display" : "Parafarmacia Italia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001059"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "4133",
      "display" : "medicalsan2007",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4134",
      "display" : "farmafamily",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042021"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4135",
      "display" : "PHARMA NATUR",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070078"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4136",
      "display" : "erboristeria parafarmacia alimento puro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4137",
      "display" : "PARAFARMACIA DEL DOTT. LA MALFA TOMMASO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083049"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4138",
      "display" : "Pharmasi Farmashop",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4139",
      "display" : "Erboristeria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4140",
      "display" : "supersanitariadue sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4142",
      "display" : "PARAFARMACIA  DOTT. DI FRANCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078029"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4144",
      "display" : "LIVI FARM di Vitellino Maria elisa Carla",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087033"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-11-01"
        }
      ]
    },
    {
      "code" : "4145",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4148",
      "display" : "PARAFARMACIA DOTT.SSA SIMONETTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4151",
      "display" : "Parafarmacia Dott.Didonna & Dott.ssa Mancuso s.n.c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078108"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4152",
      "display" : "Parafarmacia Dott.ssa Tiziana Nocera",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4153",
      "display" : "PARAFARMACIA DI CIRILLO ANNUNZIATA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063031"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4154",
      "display" : "parafarmacia dr fadda annarita",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095021"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4156",
      "display" : "Parafarmacia Millennium di Dueffe Farmaceutici Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044011"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4157",
      "display" : "Farmaceuticamente",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029041"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4159",
      "display" : "parafarmacia punto salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087013"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4160",
      "display" : "fornatti snc di fabio forno e guido nattino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006121"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4161",
      "display" : "FARMACONTEA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088006"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4162",
      "display" : "SANITARIA ORTOPEDIA CARDONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062008"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4164",
      "display" : "PARAFARMACIA DOTT.SA MAZZA DONATELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043031"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4166",
      "display" : "PARAFARMACIA CAIROLI DOTT. MASCHERPA MAURO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4169",
      "display" : "PARAFARMACIA L'ELISIR del Dr.Pierpaolo Montagna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "4170",
      "display" : "PARAFARMACIA DOTT. SSA FRANCESCA BAUDONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045010"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4176",
      "display" : "SOGIPER S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067041"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-10-01"
        }
      ]
    },
    {
      "code" : "4180",
      "display" : "DARMA IL FARMASTORE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022139"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4181",
      "display" : "PARAFARMACIA DI BULGARI ANDREA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017143"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-10-01"
        }
      ]
    },
    {
      "code" : "4182",
      "display" : "beautyemedical sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4185",
      "display" : "Parafarmacia Dr.ssa Garofalo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053006"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4186",
      "display" : "FARMAPIU'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4187",
      "display" : "TIRRENO INSIEME SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050031"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-10-01"
        }
      ]
    },
    {
      "code" : "4188",
      "display" : "PARAFARMACIA PUNTO SALUTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080093"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-03-01"
        }
      ]
    },
    {
      "code" : "4190",
      "display" : "dr.ssa SOLIMANDO Maria Antonietta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071004"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4191",
      "display" : "PARAFARMACIA MEDIFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "4196",
      "display" : "Parafarmacia Dott.ssa Coco Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "4198",
      "display" : "farma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022153"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-06-01"
        }
      ]
    },
    {
      "code" : "4199",
      "display" : "Parafarmacia del Dott. Foà",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "007022"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4200",
      "display" : "Parafarmacia Villasanta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108049"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "4201",
      "display" : "PARAFARMACIA GUICCIARDI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4203",
      "display" : "parafarmacia M&S di Serpi M. e Aramu A. s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092051"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-02-01"
        }
      ]
    },
    {
      "code" : "4204",
      "display" : "PARAFARMACIA SAN FRANCESCO DI FRANCESCA CAMMARELLA E MARIA VOMMARO S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078091"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-09-01"
        }
      ]
    },
    {
      "code" : "4205",
      "display" : "FARMACIA DELL'INDIPENDENZA DOTT. PALERMO ANTONINO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083097"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "4206",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050001"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4207",
      "display" : "PARAFARMACIA DOTT.SSA FERRANTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071036"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4208",
      "display" : "Parafarmacia Dott. Viglione S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004003"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "4209",
      "display" : "PARAFARMACIA DOTT.SSA RICCHIO MARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078081"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4210",
      "display" : "MCD SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4213",
      "display" : "parafarmacia dottoressa fiorella felli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066032"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4214",
      "display" : "PARAFARMACIA del Dr.Giovanni D'Anna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063024"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4219",
      "display" : "ERBORISTERIA IL CICLAMINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063048"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4220",
      "display" : "PHARMACARE DI CAROLINA DI GAETANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078091"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4221",
      "display" : "DOTT.SSA VATTIMO DORINA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078146"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4223",
      "display" : "novafarm",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005017"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4225",
      "display" : "SupermercatoGS-Tarantini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074007"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4229",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084041"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-12-01"
        }
      ]
    },
    {
      "code" : "4231",
      "display" : "Parafarmacia San Matteo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009033"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4240",
      "display" : "Parafarmacia Dott. Piazza",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4241",
      "display" : "FARMASANITARIA ANNO ZERO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061083"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-11-01"
        }
      ]
    },
    {
      "code" : "4243",
      "display" : "PARAFARMACIA DELLA DOTT.SSA LUISA SPOSATO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078017"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4247",
      "display" : "Parafarmacia Ygeia Srls",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092003"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-01-01"
        }
      ]
    },
    {
      "code" : "4249",
      "display" : "Farmaover",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050008"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4250",
      "display" : "parafarmacia centrale di giacchello g &c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009042"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4251",
      "display" : "PHARMABEAUTY SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4255",
      "display" : "PARAFARMACIA corso alessandria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005005"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4256",
      "display" : "Parafarmacia di E.Messina e dott A.Polizzotto srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082017"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4257",
      "display" : "Bruno Umberto Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4258",
      "display" : "GDL no food Splendidi & Splendenti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080057"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4263",
      "display" : "FEDERALFARM SRL (PARAFARMACIA)",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082011"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4264",
      "display" : "PARAFARMACIA NOVI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006114"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4266",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102044"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4268",
      "display" : "piu isabella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4270",
      "display" : "PARAFARMACIA SANITARIA dott.ssa DI CELLO TERESA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "4273",
      "display" : "CADUCEO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099013"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4274",
      "display" : "PARAFARMACIA DOTT.SSA ESPOSITO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4275",
      "display" : "PARAFARMACIA GIORDANO BRUNO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4277",
      "display" : "FOX PHAMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082020"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "4278",
      "display" : "PARAFARMACIA DELLA D.SSA PULVIRENTI FRANCESCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087044"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4280",
      "display" : "carluccio antonio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059008"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4281",
      "display" : "croce verde srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085007"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4282",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050008"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4283",
      "display" : "OPHELIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-11-01"
        }
      ]
    },
    {
      "code" : "4284",
      "display" : "PARAFARMACIA D.SSA MONICA BURATTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015151"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4287",
      "display" : "parafarmacia dott. alberto cavenago",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040043"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-01-01"
        }
      ]
    },
    {
      "code" : "4289",
      "display" : "PARAFARMACIA ALETRIUM",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060003"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4292",
      "display" : "Parafarmacia di Barbara Demaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001259"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-08-01"
        }
      ]
    },
    {
      "code" : "4293",
      "display" : "GEVICA FARM SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084001"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4294",
      "display" : "ditta individuale Vittorio Lucheschi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026020"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4295",
      "display" : "FARMAUNO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050017"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4298",
      "display" : "MED & CO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4300",
      "display" : "VETERSHOP",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063034"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4301",
      "display" : "Free Pharm s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052022"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4302",
      "display" : "Parafarmacia LPFARMA s.a.s. di Pacifici Lorenzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4304",
      "display" : "PARAFARMACIA S. DONATO DI ZIPPI FEDERICA E C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-08-01"
        }
      ]
    },
    {
      "code" : "4305",
      "display" : "Garbo di Zoccola Domenico e Floriana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065118"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4307",
      "display" : "NATURASI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4308",
      "display" : "PARAFARMACIA PIEMONTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4310",
      "display" : "Parafarmacia il girasole",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066006"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4312",
      "display" : "Parafarmacia s.a.s. di Moncada Eleonora & c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089014"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4314",
      "display" : "Parafarmacia Dott.ssa Oberto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4315",
      "display" : "Parafarmacia San Giuseppe di Cantarelli & Casotti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034014"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4316",
      "display" : "parafarmacia-ortopedia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059014"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4317",
      "display" : "Etna Parafarmacia S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087006"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4319",
      "display" : "FARMAVITA-SINISCOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091085"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4320",
      "display" : "Centro Ortopedico di Fallani Eliana & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050029"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4322",
      "display" : "ParaFarmacia S. Rita - D.ssa Curiale Lucia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071028"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4323",
      "display" : "Leuzzi Sanitaria s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079137"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4325",
      "display" : "saluszoo srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001130"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-07-01"
        }
      ]
    },
    {
      "code" : "4326",
      "display" : "E' QUI-PARAFARMACIA PARMA CAMPUS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-05-01"
        }
      ]
    },
    {
      "code" : "4327",
      "display" : "CAVALLOTTO S.N.C. DI CAVALLOTTO LUISA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004003"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4330",
      "display" : "Parafarmacia San Giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009029"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-03-01"
        }
      ]
    },
    {
      "code" : "4331",
      "display" : "LA SVOLTA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075068"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4337",
      "display" : "bosio angelo s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4345",
      "display" : "PARAFARMACIA DR. ZUNINO GIOVANNI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009002"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4346",
      "display" : "FARMA DRUGSTORE - ESERCIZIO FARMACEUTICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104023"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4347",
      "display" : "FARMA DRUGSTORE - FARMALDIA-ESERCIZIO FARMACEUTICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104023"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4348",
      "display" : "PARAFARMACIA DR. ZUNINO GIOVANNI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009001"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4352",
      "display" : "PARAFARMACIA DELLE COLLINE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050029"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4353",
      "display" : "DE CIMMA ROCCO GIANLUCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4357",
      "display" : "DE NATALE GIUSEPPA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087045"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4358",
      "display" : "098040",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "4359",
      "display" : "PARAFARMACIA Dr.ssa A.Senes",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104017"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4360",
      "display" : "BI-EMME SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081021"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4361",
      "display" : "Parafarmacia Dott. Mantovanelli Marco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028037"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4364",
      "display" : "Sanitaria Del Corso Della dr.ssa Ramaschiello Giu",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4365",
      "display" : "Parafarmacia Internazionale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040008"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4366",
      "display" : "ALIDA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4368",
      "display" : "PARAFARMACIA D.ssa FAZZARI Romina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083038"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4370",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4371",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001164"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4374",
      "display" : "PARAFARMACIA SANTOSUOSSO PIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064006"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-10-01"
        }
      ]
    },
    {
      "code" : "4375",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4376",
      "display" : "Parafarmacia Gran Madre snc dr.ssa D'Avino D. e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-05-01"
        }
      ]
    },
    {
      "code" : "4378",
      "display" : "drug store libia s.r.l-",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4383",
      "display" : "PARAFARMACIA BALESTRINO DI BARBARA DR. BALESTRINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005080"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-02-01"
        }
      ]
    },
    {
      "code" : "4385",
      "display" : "PARAFARMACIA DOTTORESSA AVIAN GABRIELLA & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4387",
      "display" : "ERBORISTERIA SCANDELLARI DOTT.essa ANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036027"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4388",
      "display" : "parafarmacia croce verde",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087028"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4390",
      "display" : "salus picena snc di pavoni e. & c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044007"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-12-01"
        }
      ]
    },
    {
      "code" : "4391",
      "display" : "PARAFARMACIA Dott.ssa MICELI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4393",
      "display" : "Corner Rubicone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040045"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "4395",
      "display" : "Parafarmacia dottor Nanni Nicola",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070010"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4396",
      "display" : "Parafarmacia Dott. Coresi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042017"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-03-01"
        }
      ]
    },
    {
      "code" : "4398",
      "display" : "salus zoob srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004203"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-07-01"
        }
      ]
    },
    {
      "code" : "4399",
      "display" : "LONGO & PATERNO' S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073012"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4400",
      "display" : "Parafarmacia dott. Guido Francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078081"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4401",
      "display" : "Parafarmacia dott.ssa Madia Giuseppina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102020"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4403",
      "display" : "Parafarmacia Ra.Mo. Salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4405",
      "display" : "PARAFARMACIA DI CORSO RISORGIMENTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4406",
      "display" : "La nuova sanitaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066049"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4407",
      "display" : "NATURAL PHARMA della dott.ssa Laura Motta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087030"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4408",
      "display" : "Parafarmacia dott.ssa Maria Carmela Savarino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084035"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4410",
      "display" : "parafarmacia naturalfarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058047"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4413",
      "display" : "ESAFARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025006"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4417",
      "display" : "parafarmacia dott.ssa lena antonella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084036"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4419",
      "display" : "PARAFARMACIA SALUTE E BENESSERE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4420",
      "display" : "Paramed del.dott.VincenzoAntonioAgatinoPappalardo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087029"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4423",
      "display" : "AGRICOLA CAERE SNC DI DANILO ROMANELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058029"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4424",
      "display" : "Toffoli oltre il benessere di Toffoli Silvia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020033"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-04-01"
        }
      ]
    },
    {
      "code" : "4427",
      "display" : "cofarm sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080043"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4428",
      "display" : "PARAFARMACIA DELLA DOTT.SSA G. MAIOLINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087034"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4429",
      "display" : "CONSORZIO CO. FA. MED.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4431",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-01-01"
        }
      ]
    },
    {
      "code" : "4432",
      "display" : "FILANGERA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "4433",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015154"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4434",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4435",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4436",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089012"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2024-01-01"
        }
      ]
    },
    {
      "code" : "4437",
      "display" : "PARAFARMACIA EFFEPI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038006"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-06-01"
        }
      ]
    },
    {
      "code" : "4439",
      "display" : "Parafarmacia S. Caterina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035024"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4440",
      "display" : "PARAFARMACIA LA CASA DELLA SALUTE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078154"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4441",
      "display" : "PARAFARMACIA LAGARIA DI REMEDI OTTAVIANO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078056"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4443",
      "display" : "VARESE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012133"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "4450",
      "display" : "ROSSI STEFANIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004067"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4452",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4454",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090033"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-05-01"
        }
      ]
    },
    {
      "code" : "4455",
      "display" : "Spaziofarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018037"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4456",
      "display" : "La Farmacista",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4458",
      "display" : "Parafarmacia S. Leopoldo della Dott.ssa Trifance Tiziana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053009"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-02-01"
        }
      ]
    },
    {
      "code" : "4461",
      "display" : "parafarmacia care line",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001120"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4463",
      "display" : "Parafarmacia De.Fal.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4465",
      "display" : "audace srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044003"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4466",
      "display" : "fedelfarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-01-01"
        }
      ]
    },
    {
      "code" : "4467",
      "display" : "parafarmacia di dott.essa Adamo Corradina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087003"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4468",
      "display" : "PHARMASALUTE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081024"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4470",
      "display" : "FARMAFIERA di agostini tatiana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4471",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052022"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4478",
      "display" : "Parafarmacia Foletto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "096012"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4480",
      "display" : "PARAFARMACIA Dott.ssa PAOLA PUGLIESE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078136"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4482",
      "display" : "Parafarmacia Amato dr. Pasquale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4483",
      "display" : "Beanato Paola",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4484",
      "display" : "Parafarmacia Dr.ssa Di Gloria S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-10-01"
        }
      ]
    },
    {
      "code" : "4486",
      "display" : "Parafarmacia Martire Francesca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078151"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4487",
      "display" : "parafarmacia dr. Bianchi di Bianchi Fabio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006003"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4488",
      "display" : "023073",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "4489",
      "display" : "Serviam S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4491",
      "display" : "Prafarmacia Dott.ssa Mattucci",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067035"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4492",
      "display" : "Farma & Co. di Silvio Betti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017043"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4497",
      "display" : "Parafarmacia Dott. Perego",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013147"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4498",
      "display" : "MEDI-MARKET ITALIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-08-01"
        }
      ]
    },
    {
      "code" : "4499",
      "display" : "IPERCOOP MOLFETTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072029"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "4501",
      "display" : "Iper Montebello Spa - Iper Busnago",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108051"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-09-01"
        }
      ]
    },
    {
      "code" : "4502",
      "display" : "Pharm@shop di Pier Luigi Guida",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065038"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4503",
      "display" : "La Parafarmacia del dr. Mario Grande",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076042"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4504",
      "display" : "La parafarmacia del dr.ssa Santo Maria Domenica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076085"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "4505",
      "display" : "la Parafarmacia del de. mario grande",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065097"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4508",
      "display" : "LaCoccinella della salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034025"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4509",
      "display" : "Parafarmacia Dott. G. Montanaro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061058"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4511",
      "display" : "PARAFARMACIA MALIES",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062008"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4512",
      "display" : "Parafarmacia d.ssa Marisa Latronico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4514",
      "display" : "Gabriella Buffardo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065077"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4516",
      "display" : "Farma-House s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4517",
      "display" : "Farma-House s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4519",
      "display" : "Parafarmacia Dr.ssa M. S. Calderone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "4520",
      "display" : "Corner Serravalle",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006160"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "4523",
      "display" : "PARAFARMACIA Dott.ssa Lovino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072029"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-12-01"
        }
      ]
    },
    {
      "code" : "4524",
      "display" : "parafarmacia dott. coppola",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065021"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4527",
      "display" : "Parafarmacia di Porretta della Dott.ssa M. Di Luca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037049"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4533",
      "display" : "RA.RI.FARMA srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093005"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2007-12-01"
        }
      ]
    },
    {
      "code" : "4534",
      "display" : "D'AGOSTINO IOLANDA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063014"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4538",
      "display" : "La Parafarmacia del dott. Mario Grande",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065097"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4539",
      "display" : "Parafarma snc di Ercolanoni N. e Nofrini R.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4540",
      "display" : "SALUTE & BENESSERE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044054"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4541",
      "display" : "PARAFARMACIA UDINE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4542",
      "display" : "015039",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "4543",
      "display" : "parafarmacia san chiaffredo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004203"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4545",
      "display" : "FOX PHARMA ONE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082021"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4546",
      "display" : "PAGANOFARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4547",
      "display" : "PARAFARMACIA GUERCIO MASSIMO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081020"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4548",
      "display" : "T.L. DENTAL SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036003"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "4552",
      "display" : "PARAFARMACIA BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093021"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4553",
      "display" : "ROSSI CLAUDIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033037"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4554",
      "display" : "PARAFARMACIA NATURFARMA dott.ssa Katia Giaquinto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064062"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4557",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050008"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4558",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050008"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4559",
      "display" : "Erboristeria In Natura Salus",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4561",
      "display" : "PARAFARMACIA S. ANNA SNC DI E. MORETTI E M.S. TORDONI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054050"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-03-01"
        }
      ]
    },
    {
      "code" : "4562",
      "display" : "S & N Pharma snc di Sabrina Roccia e Norma Garbarino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005017"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-05-01"
        }
      ]
    },
    {
      "code" : "4563",
      "display" : "PHARMA BIOCEUTICAL SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4564",
      "display" : "L'angolo della salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4566",
      "display" : "PARAFARMACIA DOTT. ALONGE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084020"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-06-01"
        }
      ]
    },
    {
      "code" : "4567",
      "display" : "NATURA STREET 1970",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4575",
      "display" : "Ipercoop Avezzano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066006"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-02-01"
        }
      ]
    },
    {
      "code" : "4577",
      "display" : "parafarmacia minoliti tiziana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4580",
      "display" : "PARAFARMACIA KEIMAR SNC DI RAJABI A.S. E CANTONE R",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001063"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4585",
      "display" : "037011",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "4587",
      "display" : "FARMAFELIX",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4591",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065089"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-12-01"
        }
      ]
    },
    {
      "code" : "4593",
      "display" : "PARAFARMACIA LA SELICE DI FARINA LAVINIA E TASSINARI CARLA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037032"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-12-01"
        }
      ]
    },
    {
      "code" : "4595",
      "display" : "ICHNOS RE S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095038"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "4596",
      "display" : "PARAFARMACIA MARCONI DELLA DOTT.SSA SARA CASSOLARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4597",
      "display" : "farmit s.n.c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4602",
      "display" : "Società Angiolina s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-02-01"
        }
      ]
    },
    {
      "code" : "4603",
      "display" : "Parafarmacia dr.Salvatore Rongone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072048"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4604",
      "display" : "La Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090057"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4605",
      "display" : "PARAFARMACIA DON BOSCO DEL DR.FRANCESCO CINA'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4608",
      "display" : "Parafarmacia Stella Marina s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009057"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-07-01"
        }
      ]
    },
    {
      "code" : "4609",
      "display" : "società Al.Pi S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4613",
      "display" : "NOVA COOP SOC. COOP. IPERMERCATO GRAVELLONA TOCE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "103035"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4614",
      "display" : "NOVA COOP SOC.COOP. IPERMERCATO NOVARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4615",
      "display" : "Parafarmacia dr Campagna Francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018177"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-07-01"
        }
      ]
    },
    {
      "code" : "4616",
      "display" : "UM.AN.CI.SA. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087007"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4618",
      "display" : "farmapia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092068"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4619",
      "display" : "NUOVA VETERINARIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028023"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-01-01"
        }
      ]
    },
    {
      "code" : "4622",
      "display" : "Parafarmacia dott.ssa Natale Roberta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061054"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4624",
      "display" : "DALTEA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053011"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4626",
      "display" : "BIOPHARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4627",
      "display" : "parafarmacia lalla",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069028"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4629",
      "display" : "Corner Pesaro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041044"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-03-01"
        }
      ]
    },
    {
      "code" : "4632",
      "display" : "PARAFARMACIA FAVARIN dr. ALESSANDRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027028"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "4633",
      "display" : "Farma Boutique",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-11-01"
        }
      ]
    },
    {
      "code" : "4637",
      "display" : "NOVA COOP S.C. IPERMERCATO BORGOMANERO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003024"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4638",
      "display" : "RONDINI E CAPORALETTI SNC DI RONDINI L. E CAPORALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054026"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4639",
      "display" : "PARAFARMACIA MARCONI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-05-01"
        }
      ]
    },
    {
      "code" : "4641",
      "display" : "PHARMA&SALUTE della dott.ssa PULIERI Caterina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073022"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4642",
      "display" : "IPER SIDIS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058118"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4646",
      "display" : "PARAFARMACIA MONTEBELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018095"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4647",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-08-01"
        }
      ]
    },
    {
      "code" : "4648",
      "display" : "N&F parafarm S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078049"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4651",
      "display" : "FARMAGRECA DI APREA SABRINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4657",
      "display" : "Corner Tortona",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006174"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "4658",
      "display" : "018095",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "4660",
      "display" : "inpharma s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061013"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4662",
      "display" : "pivaro renzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029001"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4668",
      "display" : "FARMA POINT SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065067"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4669",
      "display" : "Iper MONTEBELLO - Iper Montebello Spa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018095"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4670",
      "display" : "GIVIFARM",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088009"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "4673",
      "display" : "Parafarmacia Vittoria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091064"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4675",
      "display" : "016150",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "4677",
      "display" : "EmFra srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058032"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4681",
      "display" : "La bottega delle erbe erboristeria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030043"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4683",
      "display" : "PARAFARMACIA CENTRO COMMERCIALE ANAGNINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4686",
      "display" : "Parafarmacia della salute e del benessere ...",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069033"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4694",
      "display" : "SOGIPER S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066049"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-10-01"
        }
      ]
    },
    {
      "code" : "4698",
      "display" : "PARAFARMACIA CORRADINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034042"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-06-01"
        }
      ]
    },
    {
      "code" : "4701",
      "display" : "Parafarmacia di Bartucci Olga",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-09-01"
        }
      ]
    },
    {
      "code" : "4704",
      "display" : "KAIROS s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066049"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4705",
      "display" : "Spaziofarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4707",
      "display" : "parafarmacia due esse",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4708",
      "display" : "SALUTE E BENESSERE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006114"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4710",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054051"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4712",
      "display" : "Ludo farma parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087039"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-08-01"
        }
      ]
    },
    {
      "code" : "4715",
      "display" : "parafarmacia dott.ssa Mazzotta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079137"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4716",
      "display" : "FARMAERBA DI POTENZA DOTT.SSA MARISTELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075030"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4717",
      "display" : "Esercizio Farmaceutico Del Dott. Gullotta Davide",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087023"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4718",
      "display" : "ERBORISTERIA MADIA DR. ROBERTO  sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015208"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4723",
      "display" : "PARAFARMACIA RICCI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-08-01"
        }
      ]
    },
    {
      "code" : "4724",
      "display" : "PARAFARMACIA CASA DELLA SALUTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4725",
      "display" : "Parafarmacia Sanifarm",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065014"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4726",
      "display" : "VARRASO ANTONIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4727",
      "display" : "FARMASANITARIA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089002"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4729",
      "display" : "SCHIAVONE ALFONSINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061019"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4733",
      "display" : "PARAFARMACIA GARDANI CENTER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020066"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4734",
      "display" : "GEA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069058"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-04-01"
        }
      ]
    },
    {
      "code" : "4735",
      "display" : "PARAFARMACIA DR.SSA MARIA ELENA MENZANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077017"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-12-01"
        }
      ]
    },
    {
      "code" : "4736",
      "display" : "PARAFARMACIA SALUS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072002"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4737",
      "display" : "Farmacisti Associati srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4740",
      "display" : "parafarmacia del Dr. Ferdinando Corcione",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063080"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4742",
      "display" : "L'ANGOLO DELLA SALUTE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-12-01"
        }
      ]
    },
    {
      "code" : "4744",
      "display" : "Parafarmacia Dott. D'Amore sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4746",
      "display" : "IL MONDO DEI BIMBI di GAROFALO ASSUNTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063075"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4747",
      "display" : "Iper Conad",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068012"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-07-01"
        }
      ]
    },
    {
      "code" : "4748",
      "display" : "PARAFARMACIA MARCON",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027020"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4749",
      "display" : "PARAFARMACIA DOTT.SSA NADIA MOCELLINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028016"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4751",
      "display" : "Parafarmacia s.a.s di Marchesini Nicola & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023045"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4752",
      "display" : "parafarmacia natura benessere",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015248"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4755",
      "display" : "Farma.vet centro salute animale S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029033"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4756",
      "display" : "Parafarmacia Schettino Antonia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064015"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-06-01"
        }
      ]
    },
    {
      "code" : "4759",
      "display" : "PAOLETTI s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079081"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4760",
      "display" : "Parafarmacia Bio Salus",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4761",
      "display" : "PARAFARMACIA  TANZI MARIA PAOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4762",
      "display" : "Centro Botanico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4766",
      "display" : "ERBORISTERIA PARAFARMACIA DR. ANNA RITA CALABRESE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075050"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4767",
      "display" : "DECA CHEMIST'S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063021"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4768",
      "display" : "Natura e salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010046"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4770",
      "display" : "Parafarmacia Dr. Bizzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023069"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-08-01"
        }
      ]
    },
    {
      "code" : "4773",
      "display" : "Parafarmacia Medi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-05-01"
        }
      ]
    },
    {
      "code" : "4774",
      "display" : "Farmashop",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092073"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4776",
      "display" : "Fitofarma di Meloni Antonello",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090091"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "4777",
      "display" : "Parafarmacia di Speranza Claudia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4779",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102036"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4781",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4782",
      "display" : "BORGONUOVO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035024"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4785",
      "display" : "Parafarmacia dott.ssa Giulia Murgese",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072023"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4787",
      "display" : "FARMAFREE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058079"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4788",
      "display" : "parafarmacia dott.ssa biondaro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023069"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4789",
      "display" : "parafarmacia baby birba",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060038"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4790",
      "display" : "parafarmacia viale liberta'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-03-01"
        }
      ]
    },
    {
      "code" : "4791",
      "display" : "PARAFARMACIA SPOTTI ELISABETTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4795",
      "display" : "DEVITALFARM",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4802",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065039"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4803",
      "display" : "Parafarmacia Trasimeno di Centogambe Sofia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054038"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4804",
      "display" : "Corner Colonnella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067019"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "4805",
      "display" : "NATURAL WAY della D.ssa Polverino Anna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065056"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4806",
      "display" : "PARAFARMACIA COLLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008055"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4807",
      "display" : "PARAFARMACIA XXIII MARZO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-04-01"
        }
      ]
    },
    {
      "code" : "4809",
      "display" : "PARAFARMACIA ARMMES DEI DOTT.RI ANDREA RUSSO, MAILA MASCELLO ED ELISABETTA SOLITO S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075029"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-11-01"
        }
      ]
    },
    {
      "code" : "4810",
      "display" : "massimo guglielmino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062008"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4815",
      "display" : "S.B. Pharma di Bonadio dott.ssa Stefania",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018076"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4816",
      "display" : "Parafarmacia Vaticale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061019"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4817",
      "display" : "Parafarmacia Santa Marina,Dott.ssa Cioni Serena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083087"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4819",
      "display" : "profarma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4820",
      "display" : "profarma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087008"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4821",
      "display" : "profarma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083104"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4822",
      "display" : "profarma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083080"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4824",
      "display" : "FarmaciaSop",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075097"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4825",
      "display" : "CENTRO FARMACEUTICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069099"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4827",
      "display" : "PALERMO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4829",
      "display" : "TULIPANO NERO SRL UNIPERSONALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063080"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4830",
      "display" : "MORENI NADIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043034"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4831",
      "display" : "Parafarmacia Dott. Piergiorgio Milazzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087006"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4832",
      "display" : "TEKNO PHILIAS SNC DI TERRANA CLAUDIO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084001"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4835",
      "display" : "SANITARIA ORTOPEDIA DI CARDONE PIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062074"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-04-01"
        }
      ]
    },
    {
      "code" : "4839",
      "display" : "SPAZIO CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043023"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "4840",
      "display" : "Parafarmacia Accoto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075090"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4842",
      "display" : "Travaglini snc di Travaglini Domenico e Giulia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069099"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-06-01"
        }
      ]
    },
    {
      "code" : "4843",
      "display" : "Italiasalute srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4845",
      "display" : "PARAFARMACIA PORTU FRAILIS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091095"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "4846",
      "display" : "PARAFARMACIA DEL DOTT.LEANZA UGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083017"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4847",
      "display" : "ESERCIZIO FARMACEUTICO DOTT.SSA LUISA TRAMATZU",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092039"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4854",
      "display" : "Farmastore Celano srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065099"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-11-01"
        }
      ]
    },
    {
      "code" : "4855",
      "display" : "Parafarmacia Abate di Galzerano Maria Cristina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-05-01"
        }
      ]
    },
    {
      "code" : "4858",
      "display" : "FarmaciAdInterim",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075052"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4859",
      "display" : "Parafarmacia Roberta Pace",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066098"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-02-01"
        }
      ]
    },
    {
      "code" : "4862",
      "display" : "MARIPOSA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4865",
      "display" : "Parafarmacia Dott. Mica Di Mica Federico.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-07-01"
        }
      ]
    },
    {
      "code" : "4868",
      "display" : "FarmaPoint",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005005"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4874",
      "display" : "PHARMALIVENZA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093037"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4875",
      "display" : "farmashop s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063065"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4876",
      "display" : "PARAFARMACIA DELLA DOTTORESSA MONTI MICHELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039007"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4884",
      "display" : "CLODIA COMMERCIALE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053011"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-10-01"
        }
      ]
    },
    {
      "code" : "4886",
      "display" : "La Farmacista della Dott.ssa Brigante Fabiola - Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075061"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-11-01"
        }
      ]
    },
    {
      "code" : "4888",
      "display" : "ERBORISTERIA LA MADRESELVA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4890",
      "display" : "My Farma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012119"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4892",
      "display" : "PEDIA FITO PHARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072047"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4897",
      "display" : "paraFarmacia dott.ssa Ravizza",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4901",
      "display" : "030118",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "4902",
      "display" : "PARAFARMACIA BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020021"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4903",
      "display" : "parafarmacia di Sabrina Scorzafave",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078044"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4904",
      "display" : "pharmashop",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076046"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4905",
      "display" : "pharmashop2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076080"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4906",
      "display" : "C&M di Minutolo Cristina S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062038"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4907",
      "display" : "DISTRIBUZIONE LAZIO UMBRIA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "4908",
      "display" : "PARAFARMACIA FLORENCE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4909",
      "display" : "Benessere del dott. Filomeno Nunziata",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063066"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4913",
      "display" : "NORDOVEST INSIEME SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-02-01"
        }
      ]
    },
    {
      "code" : "4914",
      "display" : "FARMAXIMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072015"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4916",
      "display" : "Parafarmacia Dott. Farzad Dabiri",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088009"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4917",
      "display" : "RUFFATO DOTT.SSA ORIANA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028104"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4921",
      "display" : "La Salute di...Ferro Parafarmacia del D. Amico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089002"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4925",
      "display" : "Parafarmacia Scarlatti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4928",
      "display" : "Cityper sma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074012"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4929",
      "display" : "Parafarmacia di Dora Grande",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078154"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4930",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078029"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4931",
      "display" : "Parafarmacia Liberi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4932",
      "display" : "parfarmacia internazionale srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4933",
      "display" : "Il Tulipano di Ammendola Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061022"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4934",
      "display" : "FARMA PIU' S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4936",
      "display" : "PARAFARMACIA  dott. papaleo carmine",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078009"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4937",
      "display" : "RUOCCO MARIA MADDALENA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063066"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4938",
      "display" : "PARAFARMACIA SOLARI SNC DI CALDELLI RICCARDO & c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-11-01"
        }
      ]
    },
    {
      "code" : "4939",
      "display" : "FARMAOVER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048014"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4941",
      "display" : "SERVIAM SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4943",
      "display" : "Parafarmacia S.Croce SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-05-01"
        }
      ]
    },
    {
      "code" : "4946",
      "display" : "PARAFARMACIA NATURALMENTE 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099001"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4949",
      "display" : "GIULIANI ANNA CELESTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071027"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4950",
      "display" : "IL FARO PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053009"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4951",
      "display" : "la parafarmacia s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053011"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4953",
      "display" : "PARAFARMACIA SAN MATTEO SAS DI ALBERTO de PAOLI AM",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017201"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-02-01"
        }
      ]
    },
    {
      "code" : "4955",
      "display" : "012123",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-10-01"
        }
      ]
    },
    {
      "code" : "4958",
      "display" : "PARAFARMACIA LA GINESTRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041012"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4961",
      "display" : "PARAFARMACIA ERBORISTERIA PRECERUTI DI PRECERUTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018068"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4962",
      "display" : "Antonio Tamburro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067044"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4965",
      "display" : "Parafarmacia Cassia 340",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-06-01"
        }
      ]
    },
    {
      "code" : "4967",
      "display" : "parafarmacia Gela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085007"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4970",
      "display" : "farmapiu'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089011"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4971",
      "display" : "PARAFARMACIA SAN ROCCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060074"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4975",
      "display" : "CHESSA & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "107009"
        },
        {
          "code" : "provincia",
          "valueCode" : "107"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4976",
      "display" : "030057",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "4978",
      "display" : "La Veterinaria di Belvedere Dott.ssa Caterina SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102019"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "4980",
      "display" : "FLAG SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4981",
      "display" : "PARAFARMACIA PIM",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-07-01"
        }
      ]
    },
    {
      "code" : "4982",
      "display" : "salute e benessere s.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4983",
      "display" : "CAPI ARDIANA VIA CAVALIERE D'ITALIA N.3",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075038"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4985",
      "display" : "Parafarmacia Nappi dott.ssa Nappi Carmela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4986",
      "display" : "Deposito Farmacia Punto Salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075052"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4987",
      "display" : "parafarmacia sul corso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079096"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-05-01"
        }
      ]
    },
    {
      "code" : "4991",
      "display" : "Parafarmacia dott.ssa M. Mancini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4992",
      "display" : "Parafarmacia Dr. Grandesso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028086"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4996",
      "display" : "PARAFARMACIA RONCADELLE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017165"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4997",
      "display" : "Farmacia Mancini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049017"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4998",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049017"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "4999",
      "display" : "Parafarmacia del Dr. Ricci Daniele S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049006"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "5000",
      "display" : "erbofarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "5001",
      "display" : "GALROS AIR PHARMACY SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5003",
      "display" : "D.F.D. FARMACEUTICA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087009"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-11-01"
        }
      ]
    },
    {
      "code" : "5004",
      "display" : "Parafarmacia Dott.ssa Siciliano Maria Giovanna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078110"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "5012",
      "display" : "optima sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061057"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "5014",
      "display" : "Parafarmacia Holonfarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058118"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "5016",
      "display" : "PARAFARMACIA SAN PROSPERO DI OPPICI DR.SSA MARGHERITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-11-01"
        }
      ]
    },
    {
      "code" : "5021",
      "display" : "Iperfarma Iper Udine - Iper Montebello Spa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030057"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "5024",
      "display" : "PARAFARMACIA BENESSERE FARMACITY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024021"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-11-01"
        }
      ]
    },
    {
      "code" : "5025",
      "display" : "PARAFARMACIA BENESSERE FARMACITY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028065"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-07-01"
        }
      ]
    },
    {
      "code" : "5026",
      "display" : "PARAFARMACIA BENESSERE FARMACITY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-11-01"
        }
      ]
    },
    {
      "code" : "5027",
      "display" : "PARAFARMACIA BENESSERE FARMACITY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028001"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-11-01"
        }
      ]
    },
    {
      "code" : "5028",
      "display" : "PARAFARMACIA BENESSERE FARMACITY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029041"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-09-01"
        }
      ]
    },
    {
      "code" : "5029",
      "display" : "SANA SALUS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024086"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-11-01"
        }
      ]
    },
    {
      "code" : "5030",
      "display" : "PARAFARMACIA BENESSERE FARMACITY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024124"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-10-01"
        }
      ]
    },
    {
      "code" : "5036",
      "display" : "Andora parafarmacia Sas del Borgarello Simone e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009006"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-12-01"
        }
      ]
    },
    {
      "code" : "5039",
      "display" : "Parafarmacia del Polo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061049"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5043",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018034"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5046",
      "display" : "Parafarmacia Dott.ssa Romano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080043"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5047",
      "display" : "Salus Farma s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092097"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5050",
      "display" : "Parafarmacia Erboristeria Trapper",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009006"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5051",
      "display" : "pharmastazione di luca stagi e c. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049009"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5052",
      "display" : "pharmastazione di luca stagi e c. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5053",
      "display" : "PARAFARMACIA SANTA LUCIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065037"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5060",
      "display" : "fulvio natale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "5061",
      "display" : "Corner Magenta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015130"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "5062",
      "display" : "Realfarma di Orazio Reale & C.S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087002"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5065",
      "display" : "POLIGEST s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-06-01"
        }
      ]
    },
    {
      "code" : "5069",
      "display" : "Sanitas S.r.l. a Socio Unico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5073",
      "display" : "MARCANTONIO ABBATE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-06-01"
        }
      ]
    },
    {
      "code" : "5076",
      "display" : "Orsini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037054"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5081",
      "display" : "PARAFARMACIA DEL PORTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009006"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5085",
      "display" : "FARMASI S.A.S. di dott. Abiad Yaser",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-02-01"
        }
      ]
    },
    {
      "code" : "5092",
      "display" : "Parafarmacia Le Crete",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052002"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5093",
      "display" : "Vivere snc Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006039"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5094",
      "display" : "CASPIAN SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5095",
      "display" : "PHARMABEAUTY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5096",
      "display" : "Farma De Lucia del dott.Achille De Lucia s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062005"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5097",
      "display" : "parafarmacia de lucia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062005"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5098",
      "display" : "PARAFARMACIA DEL DOTT. DE LUCIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062005"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5101",
      "display" : "Parafarmacia Foce di Dott.ssa Paola De Angelis",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5102",
      "display" : "lunafarm srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063076"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5103",
      "display" : "parafarmacia d.ssa Colli Nedda snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035020"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5105",
      "display" : "NOVA COOP S.C.IPERMERCATO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006177"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-10-01"
        }
      ]
    },
    {
      "code" : "5108",
      "display" : "PHARMA SANIPROF SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074012"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5109",
      "display" : "Parafarmacia Galermo & C snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5110",
      "display" : "Parafarmacia Dr. Franco Borsò",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059024"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5112",
      "display" : "SANITARIA MARZOTTO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5113",
      "display" : "parafarmacia madonna dei fiori dr fissore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004029"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5115",
      "display" : "Erbaria di Ara srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024086"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-07-01"
        }
      ]
    },
    {
      "code" : "5116",
      "display" : "parafarmacia s. ambrogio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009065"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5117",
      "display" : "PARAFARMACIA DOTT. Maria POTENZA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044019"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5120",
      "display" : "PARAFARMACIA CUMANA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063060"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5132",
      "display" : "salute+sore peschici di sacco soave maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071038"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5133",
      "display" : "Parafarmacia D.ssa Deffenu Mirella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053011"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5134",
      "display" : "ERBORISTERIA LA CAMOMILLA - PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036005"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5135",
      "display" : "DITTA INDIVIDUALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004022"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5136",
      "display" : "FARMA SAN MICHELE DI FOIS MARIA PAOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090052"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-06-01"
        }
      ]
    },
    {
      "code" : "5142",
      "display" : "FARMAOVER DI UGOLINI DANIELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048013"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5145",
      "display" : "PANTA FARMA srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063053"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5147",
      "display" : "Kiasarai",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061057"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5148",
      "display" : "Parafarmacia dott. Della Monica Carmine",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065050"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-08-01"
        }
      ]
    },
    {
      "code" : "5158",
      "display" : "BETA MARKET S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5159",
      "display" : "PARAFARMACIA LEGNAGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023044"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5160",
      "display" : "LUGLI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5161",
      "display" : "PROVENZANO FRANCESCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078077"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5162",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061094"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "5166",
      "display" : "Erboristeria di Scola Lorenzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099013"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5167",
      "display" : "Rosa-Farm di Massi A. e Bucci D. snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042013"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5173",
      "display" : "Il Farmacista del dott. Salvatore Rosselli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081013"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5177",
      "display" : "GEST.S.D.B. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008031"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5178",
      "display" : "SANIFARM S.a.s. di Loconte Luca & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072005"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5180",
      "display" : "FARMA IMPRESA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5181",
      "display" : "PARAFARMACIA EPOMEO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5182",
      "display" : "Parafarma di Urbano G. e Varani A. s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059007"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5184",
      "display" : "BENESSERE SNC DI DE ROSA A. E GIARDINIERI M.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042021"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5186",
      "display" : "Parafarmacia Fitoterapica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030057"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5188",
      "display" : "PARAFARMACIA BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026092"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5189",
      "display" : "parafarmacia vallebormida",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004073"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5193",
      "display" : "UNICOOP TIRRENO SOC. COOP.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049012"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5195",
      "display" : "Masterpharma s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5197",
      "display" : "FARMAPADOVA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5201",
      "display" : "PARAFARMACIA CONAD FANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041013"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-03-01"
        }
      ]
    },
    {
      "code" : "5204",
      "display" : "MURGIA VETERINARIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072021"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5205",
      "display" : "Parafarmacia-ortopedia Orlandi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066006"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5207",
      "display" : "Vetzoo Di Buglione Antonio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061068"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5211",
      "display" : "ettu john ogbu",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063001"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5212",
      "display" : "L'isola verde di Marolato Dr. Roberto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023038"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-06-01"
        }
      ]
    },
    {
      "code" : "5214",
      "display" : "secondonatura srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5216",
      "display" : "Kurhaus srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060026"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5218",
      "display" : "parafarmacia rossini di al.fra sas di F.Acerboni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-02-01"
        }
      ]
    },
    {
      "code" : "5219",
      "display" : "BIANCOFARMA sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020030"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5220",
      "display" : "Parafarmacia Dott. Bizzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028056"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5221",
      "display" : "GDL no food - Splendidi e Splendenti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080061"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5222",
      "display" : "parafarmacia cernuzio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065034"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5223",
      "display" : "Parafarmacia Santa Petronilla",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044019"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5231",
      "display" : "Parafarmacia del Corso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072032"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-09-01"
        }
      ]
    },
    {
      "code" : "5233",
      "display" : "DFD ZOOTECNIA e VETERINARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084036"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5234",
      "display" : "PARAFARMACIA CIALDINI DI VENTURINI FILIPPO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041044"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5235",
      "display" : "NOVA COOP SOC. COOP.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "096004"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5238",
      "display" : "Parafarmacia Marco Meconi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044057"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5242",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013041"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5244",
      "display" : "SUPERMERCATO NUOVO DORO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "5245",
      "display" : "Lo speziale srl - paraFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058110"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5246",
      "display" : "Migliozzi s.r.l forniture dentali",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061005"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5247",
      "display" : "Parafarmacia Dott.ssa Medori",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044061"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5249",
      "display" : "Paraf. Erboristeria De Materia Medica Dr. Enrico D'Alberti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-08-01"
        }
      ]
    },
    {
      "code" : "5252",
      "display" : "blu dental s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-10-01"
        }
      ]
    },
    {
      "code" : "5253",
      "display" : "013110",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "5254",
      "display" : "Parafarmacia Del Mare",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-08-01"
        }
      ]
    },
    {
      "code" : "5257",
      "display" : "Parafarmacia Dott. Flavio Palladino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065154"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5258",
      "display" : "CELIACOOP LA PARAFARMACIA SENZA GLUTINE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030057"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-10-01"
        }
      ]
    },
    {
      "code" : "5262",
      "display" : "CORREALE ANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063086"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5264",
      "display" : "PARAFARMACIA TORELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069016"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5266",
      "display" : "unicorno bianco srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5267",
      "display" : "LOMBARDI PHARMA GROUP SNC DI LOMBARID ANTONIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065037"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-02-01"
        }
      ]
    },
    {
      "code" : "5268",
      "display" : "Supermercato castellucchio snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035024"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5269",
      "display" : "Parafarmacia La Stazione",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100005"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5270",
      "display" : "Erboristeria medicinale parafarmacia Dr.ssa Corren",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037046"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5274",
      "display" : "Supermercato SMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5275",
      "display" : "Parafarmacia Sicuramente",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5276",
      "display" : "Parafarmacia Sicuramente",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5277",
      "display" : "Parafarmacia Dott.ssa Adriana Valente",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102037"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5278",
      "display" : "001156",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-02-01"
        }
      ]
    },
    {
      "code" : "5279",
      "display" : "l'A. Fenice di Boria Eleonora",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5281",
      "display" : "naturasì",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5282",
      "display" : "PARAFAMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5283",
      "display" : "MEDICAL ZOO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090052"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5285",
      "display" : "PARAFARMACIA dott.ssa Recca G.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5288",
      "display" : "PARAFARMACIA ROMA EST",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5289",
      "display" : "Parafarmacia San Lazzaro Milo' D' Abruzzo Sergio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "094023"
        },
        {
          "code" : "provincia",
          "valueCode" : "094"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5294",
      "display" : "4 mori stores srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5297",
      "display" : "FRI.AL. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036030"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-03-01"
        }
      ]
    },
    {
      "code" : "5299",
      "display" : "PHARMAPOINT SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058047"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5300",
      "display" : "PHARMAPOINT SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5304",
      "display" : "castelfarm snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026012"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5305",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001315"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5310",
      "display" : "Parafarmacia Nova Farma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "107008"
        },
        {
          "code" : "provincia",
          "valueCode" : "107"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5311",
      "display" : "PARAFARMACIA VERONA UNO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023071"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5313",
      "display" : "parafarmacia Dr.khorassani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042035"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-10-01"
        }
      ]
    },
    {
      "code" : "5323",
      "display" : "Parafarmacia Tenore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065016"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "5324",
      "display" : "Farmafree",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001217"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5325",
      "display" : "Farmaregno Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044023"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-12-01"
        }
      ]
    },
    {
      "code" : "5326",
      "display" : "016037",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-05-01"
        }
      ]
    },
    {
      "code" : "5334",
      "display" : "Parafarmacia Dr. Scaramuzzino Andrea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5336",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-02-01"
        }
      ]
    },
    {
      "code" : "5338",
      "display" : "NOVA COOP SOC. COOP.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001191"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5339",
      "display" : "Parafarmacia S.Matteo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-08-01"
        }
      ]
    },
    {
      "code" : "5341",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059009"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5342",
      "display" : "SPIZZIRRI  DR. GAETANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5343",
      "display" : "PARAFARMACIA TOSCANELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037025"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5344",
      "display" : "PARAFARMACIA MERAVILLE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-03-01"
        }
      ]
    },
    {
      "code" : "5345",
      "display" : "PARAFARMACIA DOTT.SSA RUGGERO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027003"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-10-01"
        }
      ]
    },
    {
      "code" : "5350",
      "display" : "PARAFARMACIA BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027037"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5352",
      "display" : "PARAFARMACIA EUROMA 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5357",
      "display" : "PHARMASALUS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010015"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5360",
      "display" : "HOMEOPATHIC & BEAUTY CENTER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028019"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-09-01"
        }
      ]
    },
    {
      "code" : "5365",
      "display" : "Parafarmacia della Dida",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "097057"
        },
        {
          "code" : "provincia",
          "valueCode" : "097"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5366",
      "display" : "parafarmacia Cellura",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084021"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5368",
      "display" : "CICIGI srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "5369",
      "display" : "Bancofarmacia Dott.ssa Lazzaro Ida",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087009"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5371",
      "display" : "LSG di Longobardi Pasquale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072017"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5372",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043013"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5373",
      "display" : "Farmaover",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5374",
      "display" : "Corner farmaci Iper Brembate - Iper Montebello Spa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016037"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5375",
      "display" : "L'Angolo del Farmaco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059014"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5377",
      "display" : "Parafarmacia Dott.E.Zaccone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089013"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5378",
      "display" : "MEDICAL ZOO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104017"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-12-01"
        }
      ]
    },
    {
      "code" : "5381",
      "display" : "Parafarmacia Umberto I srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054015"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5383",
      "display" : "CARUSO MARIA SANTINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087029"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-11-01"
        }
      ]
    },
    {
      "code" : "5385",
      "display" : "Samara di Giuseppe Sanna e Sara Saiu snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092037"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5392",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001164"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5394",
      "display" : "Farma Service L'Arca Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068041"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5396",
      "display" : "LA PARAFARMACIA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092015"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5397",
      "display" : "Parafarmacia Salute e Bellezza e C. S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5398",
      "display" : "Salus Romulea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064011"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5400",
      "display" : "PARAFARMACIA ALBERO DELLA VITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043023"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5403",
      "display" : "PARA FARMACIA Santa Maria Dott.SCARRONE PAOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004179"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5409",
      "display" : "NATURAMONDO SAS DI LUCA COLOMBO & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015208"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5411",
      "display" : "parafarmacia pharmabeauty",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006174"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5413",
      "display" : "Parafarmacia Gambardella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5414",
      "display" : "PHARMASANIPROFSRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074008"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5415",
      "display" : "LA MAMMOLA S.n.c. di Barbato Francesco & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078048"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-01-01"
        }
      ]
    },
    {
      "code" : "5417",
      "display" : "medifarm.care srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5418",
      "display" : "PARAFARMACIA-ERBORISTERIA DOTT.SA MARGHERITA ROCCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077031"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5419",
      "display" : "PARAFARMACIA DOTT. MUZZIO ANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018014"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-10-01"
        }
      ]
    },
    {
      "code" : "5421",
      "display" : "FARVEMA s.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5423",
      "display" : "Faro della Salute di Fazio Salvatore & C. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5424",
      "display" : "PARAFARMACIA DI LORI STEFANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053009"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5427",
      "display" : "S.P.F. s.p.a. PHARMAHOUSE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061022"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5429",
      "display" : "parafarmacia all'olmo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027021"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-09-01"
        }
      ]
    },
    {
      "code" : "5431",
      "display" : "Coop Salute Copparo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038007"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "5432",
      "display" : "PARAFARMACIA Astolfi Angela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001219"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-01-01"
        }
      ]
    },
    {
      "code" : "5433",
      "display" : "GEA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040016"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5434",
      "display" : "parafarmacia dott. bertolin claudio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026012"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5436",
      "display" : "FARMAX di Massimo Montello",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063023"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5437",
      "display" : "HEALTHY CENTER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058015"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2008-12-01"
        }
      ]
    },
    {
      "code" : "5445",
      "display" : "FARMACENTER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "107016"
        },
        {
          "code" : "provincia",
          "valueCode" : "107"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5447",
      "display" : "SANITARIA MARZOTTO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028003"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5450",
      "display" : "Parafarmacia e Benessere SaluteStore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5453",
      "display" : "PARAFARMACIA dott. Carlo Sansone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071031"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "5454",
      "display" : "Medivet",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095001"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5455",
      "display" : "FARMASOP",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072017"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5456",
      "display" : "Parafarmacia Comunale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026092"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5458",
      "display" : "Parafarmacia La Maddalena OPEN MIND S.N.C. di Moizo Elda & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009015"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-10-01"
        }
      ]
    },
    {
      "code" : "5462",
      "display" : "T&B S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5464",
      "display" : "Parafarmacia dr.ssa Bellafronte Enrica Antonella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5465",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078119"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5469",
      "display" : "PARAFARMACIA SAN GERMANO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006039"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5474",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078047"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5478",
      "display" : "Farmafree",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032003"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5480",
      "display" : "Parafarmacie Fr.Er. srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092051"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5485",
      "display" : "Sanifar dei dottori Pompamea di A. Pompamea - sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5486",
      "display" : "senette farmaceutici",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092080"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-09-01"
        }
      ]
    },
    {
      "code" : "5489",
      "display" : "La Cicogna di Scotellaro Luigi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5490",
      "display" : "Drugs & More",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5491",
      "display" : "Drugs & More",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5492",
      "display" : "farmacenter",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5493",
      "display" : "Drugs & More",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5494",
      "display" : "Drugs & More",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5495",
      "display" : "Sanitaria Parafarmacia Progresso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028054"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5498",
      "display" : "parafarmacia de franceschi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058104"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5501",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028079"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5504",
      "display" : "Parafarmacia Valconca di LeF",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099011"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5506",
      "display" : "PARAFARMACIA DOTT.SSA F.GIORDANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087050"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-05-01"
        }
      ]
    },
    {
      "code" : "5508",
      "display" : "PARAFARMACIA ALBERTINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037024"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5510",
      "display" : "SALUTE STORE ROMA DI LINSALATA DOMENICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5511",
      "display" : "PARAFARMACIA COSCO GENNARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5512",
      "display" : "PARAFARMACIA COSCO GENNARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079127"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5513",
      "display" : "PARAFARMACIA COSCO GENNARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5514",
      "display" : "parafarma.gi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043047"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5515",
      "display" : "Parafarmacia dott.ssa Amato Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065032"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5517",
      "display" : "mojabi mir shafi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5518",
      "display" : "Parafarmacia dott. Rocco Chiriaco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5522",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5523",
      "display" : "parafamacia giuliani dott.ssa tiziana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065096"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5524",
      "display" : "ANIMAL FARM DI APICE GENNARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060038"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-10-01"
        }
      ]
    },
    {
      "code" : "5525",
      "display" : "parafarmacia giuliani dott.ssa tiziana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065039"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5529",
      "display" : "FARMA GROUP SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5534",
      "display" : "PARAFARMACIA DOTT.SSA ZAINO ANTONELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068033"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-01-01"
        }
      ]
    },
    {
      "code" : "5535",
      "display" : "Parafarmacia Ricciuti dott.ssa Elisa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065067"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5536",
      "display" : "Parafarmacia Dott.ssa Isabella Rosito",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072033"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5540",
      "display" : "PARAFARMACIA DEL TINTORETTO DI CARACCIOLO GIANLUCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5541",
      "display" : "MV S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083032"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5542",
      "display" : "R.T.B. sas di RABBIONE dott.ssa ELENA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001112"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5545",
      "display" : "Parafarmacia della Dott.ssa Urbinati Roberta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039007"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5549",
      "display" : "Parafarmacia Igea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068024"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5553",
      "display" : "PARAFARMACIA IBD SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "5554",
      "display" : "APOTHEKE SAS di Beggio Alessandro & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028015"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-11-01"
        }
      ]
    },
    {
      "code" : "5555",
      "display" : "FGARMA-POINT-SAN LEONARDO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5558",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001292"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-11-01"
        }
      ]
    },
    {
      "code" : "5560",
      "display" : "parafrmacia N.S. Misericordia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009029"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5562",
      "display" : "Drugs & More",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5563",
      "display" : "Parafarmacia D.ssa Salerno",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5565",
      "display" : "Raspante Dorotea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082073"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5566",
      "display" : "Italiasalute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5567",
      "display" : "FARMAOVER DI UGOLINI DANIELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048004"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5569",
      "display" : "farmashop",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092093"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5571",
      "display" : "Corner Vittuone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015243"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "5573",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016010"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5574",
      "display" : "PARAFARMACIA CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5575",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072046"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5576",
      "display" : "capa's srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066098"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5577",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-02-01"
        }
      ]
    },
    {
      "code" : "5581",
      "display" : "parafarmacia mercato albinelli s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5582",
      "display" : "Erboristeria Stramonio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063034"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5584",
      "display" : "PARAFARMACIA D.ssa ROSSELLA TURCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-07-01"
        }
      ]
    },
    {
      "code" : "5586",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004078"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5587",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072027"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5590",
      "display" : "SPAZIO CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001219"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-08-01"
        }
      ]
    },
    {
      "code" : "5591",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063089"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5592",
      "display" : "Farmaplanet Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058038"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5593",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063058"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5594",
      "display" : "AUCHAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063048"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5598",
      "display" : "MEDI-MARKET ITALIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-08-01"
        }
      ]
    },
    {
      "code" : "5601",
      "display" : "FARMAUNO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050005"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5602",
      "display" : "parafarmacia Dott. Angelo Sacco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071059"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5603",
      "display" : "L'ARMONIA S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028085"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5604",
      "display" : "Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5606",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083033"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-11-01"
        }
      ]
    },
    {
      "code" : "5613",
      "display" : "PARAFARMACIA AMARANTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044068"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5614",
      "display" : "LA MELA snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004029"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5615",
      "display" : "FB PHARMA Sas di Baroni Giancarlo & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5617",
      "display" : "PARAFARMACIA ALLA CORTE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028048"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-10-01"
        }
      ]
    },
    {
      "code" : "5622",
      "display" : "Parafarmacia Auchan Centro Comm.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5626",
      "display" : "FARMAVITA del Dott. Andrea Murgia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "105010"
        },
        {
          "code" : "provincia",
          "valueCode" : "105"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-02-01"
        }
      ]
    },
    {
      "code" : "5629",
      "display" : "PARAFRMACIA Dott. Oliverio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078138"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5631",
      "display" : "Parafarmacia Dott. D'Amico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065097"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5633",
      "display" : "parafarmacia dott.ssa caterina posterino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080057"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5635",
      "display" : "Drugstore San Domenico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-07-01"
        }
      ]
    },
    {
      "code" : "5637",
      "display" : "D.M.O. Dettaglio Moderno Organizzato SPA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036006"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-10-01"
        }
      ]
    },
    {
      "code" : "5639",
      "display" : "farmat",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "106015"
        },
        {
          "code" : "provincia",
          "valueCode" : "106"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5641",
      "display" : "Erboristeria Il Narciso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5644",
      "display" : "Parafarmacia Dott.ssa A. Lella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072041"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5645",
      "display" : "ARSAN VENERE SAS di Alessandra &c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5647",
      "display" : "parafarmacia sant'elena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061092"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5649",
      "display" : "parafarmacia dott.ssa montagna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015241"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5650",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063080"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5651",
      "display" : "PARAFARMACIA MANESCHI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051017"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5655",
      "display" : "Biofarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101027"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5657",
      "display" : "Parafarmacia salute e benessere snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099020"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-06-01"
        }
      ]
    },
    {
      "code" : "5659",
      "display" : "farmavet sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078121"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5662",
      "display" : "parafarmacia baby birba",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060043"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5663",
      "display" : "ester brunicella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-03-01"
        }
      ]
    },
    {
      "code" : "5665",
      "display" : "PARAFARMACIE MILANO DI ALESSANDRA DEL MARE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5668",
      "display" : "PARAFARMACIA Dr.ssa QUINTO MARIA GIUSEPPINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077014"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-07-01"
        }
      ]
    },
    {
      "code" : "5669",
      "display" : "SUPERMARKET RG",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046013"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5671",
      "display" : "PARAFARMACIA TECNOMEDICAL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076063"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5673",
      "display" : "SCARAMUZZO ROSSELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078012"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5674",
      "display" : "ISIPHARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078033"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-05-01"
        }
      ]
    },
    {
      "code" : "5675",
      "display" : "parafarmacia dott.ssa ciano carmela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5676",
      "display" : "Margherita Gerardi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076089"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5677",
      "display" : "Farmabiotica Società Responsabilità Limitata SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048043"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5678",
      "display" : "EURALCOOP Società Cooperativa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111009"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "5680",
      "display" : "Parafarmacia La Fonte",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099001"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5681",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5686",
      "display" : "PARAFARMACIA Dott.sa Concetta De Mare",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056052"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5688",
      "display" : "gea 4",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040008"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5689",
      "display" : "PARAFARMACIA Dr.Moussavi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037004"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "5692",
      "display" : "Bonvissuto Nunziata",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084021"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5695",
      "display" : "parafarmacia Dott Volcan Sergio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004040"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5697",
      "display" : "biofarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-04-01"
        }
      ]
    },
    {
      "code" : "5698",
      "display" : "PARAFARMACIA CPRI DI ANDREA CAPRI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5702",
      "display" : "PARAFARMACIA Salus",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001300"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-02-01"
        }
      ]
    },
    {
      "code" : "5703",
      "display" : "stila sas parafarmacia del sole",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003084"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5707",
      "display" : "Perfo Sanitas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5709",
      "display" : "LA GALENICA PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046024"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-07-01"
        }
      ]
    },
    {
      "code" : "5711",
      "display" : "IPERCOOP LE MAIOLICHE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039010"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "5712",
      "display" : "PARAFARMACIA DOTT.SSA BUCCIARELLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068024"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5715",
      "display" : "parafarmacia dr bresciani srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016051"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5716",
      "display" : "LA PARAFARMACIA  SNC DI GAMBINA MARIANNA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081008"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5717",
      "display" : "FARMACI E SALUTE DELLA DOTT.SSA FURLAN CHIARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028071"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-12-01"
        }
      ]
    },
    {
      "code" : "5723",
      "display" : "Farmaover",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5724",
      "display" : "S.P.Pharma Wholesale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092011"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-01-01"
        }
      ]
    },
    {
      "code" : "5727",
      "display" : "Pandosia Life snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078079"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5730",
      "display" : "parafarmacia le ginestre s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065156"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5733",
      "display" : "Parafarmacia dr.ssa Filomena Schiavoni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076044"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-05-01"
        }
      ]
    },
    {
      "code" : "5735",
      "display" : "parafarmacia farmabenessere di dott.ssa Bissoli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5737",
      "display" : "Salupharma sas di Turturici Ignazio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082073"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5739",
      "display" : "MEDI-FARM Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065037"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5740",
      "display" : "parafarmacia del viale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089014"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5744",
      "display" : "PARAFARMACIA PESCE DELLA DOTT.SSA ANGELA PESCE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065031"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2022-08-01"
        }
      ]
    },
    {
      "code" : "5747",
      "display" : "Ortopedia Leone Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2013-03-01"
        }
      ]
    },
    {
      "code" : "5754",
      "display" : "vivere bene",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5756",
      "display" : "parafarmacia pedemontana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087035"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5757",
      "display" : "Parafarmacia Dott.ssa Dessì Katia Lorena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092097"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5758",
      "display" : "Parafarmacia Scalioti di Scalioti Dott. Leonardo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078025"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "5759",
      "display" : "NATURA STREET 1970 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5760",
      "display" : "NUTRISHOP S.A.S. DI CORRADO MALANDRINO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089013"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5762",
      "display" : "PARAFARMACIA BENNET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013075"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5764",
      "display" : "PARAFARMACIA BENNET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013154"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5767",
      "display" : "PARAFARMACIA BENNET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001181"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5768",
      "display" : "PARAFARMACIA BENNET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003016"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5769",
      "display" : "BUSATTA NICOLETTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028076"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5770",
      "display" : "PARAFARMACIA MODERNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054018"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-05-01"
        }
      ]
    },
    {
      "code" : "5774",
      "display" : "billone salvatore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086012"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5775",
      "display" : "Parafarmacia Murales",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091062"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5779",
      "display" : "Parafarmacia dr.ssa Caparello Antonella Angelina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078010"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-05-01"
        }
      ]
    },
    {
      "code" : "5780",
      "display" : "REMEDIUM",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5782",
      "display" : "Vetzoo di Buglione Antonio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059008"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5784",
      "display" : "Parafarmacia Mauri della Dott.ssa Eloisa Mauri",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079087"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-10-01"
        }
      ]
    },
    {
      "code" : "5785",
      "display" : "Parafarmacia Sant'Ignazio Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092074"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-03-01"
        }
      ]
    },
    {
      "code" : "5786",
      "display" : "Parafarmacia Donato",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080095"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5790",
      "display" : "Parafarmacie Le Piazze",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017125"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5791",
      "display" : "Farmaseiano S.a.s. di Matachione Emanuele Roberto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063086"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5792",
      "display" : "SPAZIO CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042022"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5796",
      "display" : "DRAGONE GIANLUCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078154"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5799",
      "display" : "Parafarmacia della Granda",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004078"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5801",
      "display" : "PARAFARMACIA PUNTO BENESSERE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5802",
      "display" : "DOCIMO RENATO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5803",
      "display" : "Parafarmacia San Francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019036"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5807",
      "display" : "PARAFARMACIA IL GABBIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104026"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-03-01"
        }
      ]
    },
    {
      "code" : "5808",
      "display" : "PARAFARMACIA DELLA STAZIONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5809",
      "display" : "parafarmacia bellariva",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5811",
      "display" : "FARMA CAPPONI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5812",
      "display" : "Parafarmacia di Adriano Dr. Cuozzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065002"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5815",
      "display" : "EFFE.TI. di fabini fazio e c  sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042045"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5816",
      "display" : "SFERRUZZA SANDRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004016"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5817",
      "display" : "farmapoint",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059008"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5818",
      "display" : "SUPERSTORE CONAD",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072037"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5820",
      "display" : "Farma Point Lancusi SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065052"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "5821",
      "display" : "CAPASSO LORENZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099013"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-04-01"
        }
      ]
    },
    {
      "code" : "5822",
      "display" : "Parafarmacia San Bartolomeo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015034"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5826",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026049"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5827",
      "display" : "PARAFARMACIA GOLOSINE SAS DI ZANETTI LARA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5829",
      "display" : "salvioni 1905 healthcare s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052014"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5830",
      "display" : "ESERCIZIO FARMACEUTICO DR.SSA ANNA CONTINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075082"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-11-01"
        }
      ]
    },
    {
      "code" : "5831",
      "display" : "Parafarmacia T.M. s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086011"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5833",
      "display" : "Parafarmacia Giovanna Perugini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056049"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5835",
      "display" : "Parafarmacia Orlacchio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054018"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5836",
      "display" : "paraFarmacia snc Dott.ssa Francesca Peluso e c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5840",
      "display" : "MULTIPHARMA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081021"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5842",
      "display" : "Drugs & More",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "057054"
        },
        {
          "code" : "provincia",
          "valueCode" : "057"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5844",
      "display" : "parafarmacia d.ssa Polillo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5846",
      "display" : "PARAFARMACIA D'ANGELO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078148"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5847",
      "display" : "PARAFARMACIA D'ERCOLE della dottoressa D'Ercole Marilena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069028"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "5849",
      "display" : "PARAFARMACIA DR. ZUNINO GIOVANNI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009002"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5851",
      "display" : "FARVET di CARDARELLI GIANCARLO & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043034"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5852",
      "display" : "parafarmacia sicuramente",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-06-01"
        }
      ]
    },
    {
      "code" : "5853",
      "display" : "PARAFARMACIA POLIFARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "5855",
      "display" : "parafarmacia san francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006039"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5856",
      "display" : "farma express srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5858",
      "display" : "ser.me.san srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5859",
      "display" : "PARAFARMACIA DR. VALENTE ALESSIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-08-01"
        }
      ]
    },
    {
      "code" : "5864",
      "display" : "supermercato PAM CLUB",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5865",
      "display" : "PHARMAGEST SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5868",
      "display" : "FILANGERA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-05-01"
        }
      ]
    },
    {
      "code" : "5870",
      "display" : "IL POINT SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5872",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024118"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5873",
      "display" : "Parafarmacia San Matteo 3",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5874",
      "display" : "Parafarmacia San Matteo 4",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001028"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5875",
      "display" : "parafarmacia castiglionese di Rahmatian Masouleh F",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037022"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5876",
      "display" : "NOVA COOP S.C. IPERMERCATO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001086"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5878",
      "display" : "Drugs & More",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061091"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5880",
      "display" : "ASTRA s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072021"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5882",
      "display" : "parafarmacia cristelli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102027"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5885",
      "display" : "C.d.d. di Rizzato Ido",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027005"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5890",
      "display" : "parafarmacia lina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-07-01"
        }
      ]
    },
    {
      "code" : "5894",
      "display" : "IPERCOOP BRINDISI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-02-01"
        }
      ]
    },
    {
      "code" : "5896",
      "display" : "IPERCOOP MATERA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077014"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "5897",
      "display" : "IPERCOOP BARI PASTEUR",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-01-01"
        }
      ]
    },
    {
      "code" : "5900",
      "display" : "Erboristeria Giovagnoli e C. snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043009"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "5902",
      "display" : "FARMATEST del Dott. Testoni Giovannino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090071"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "5903",
      "display" : "LABORATORIO ORTOPEDICO MAZZOCCHI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001217"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-02-01"
        }
      ]
    },
    {
      "code" : "5907",
      "display" : "parafarmacia del borgo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "5911",
      "display" : "Parafarmacia Dott.Marino Deplano s.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092105"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "5912",
      "display" : "Ipermercato E. LECLERC CAVALLINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-03-01"
        }
      ]
    },
    {
      "code" : "5913",
      "display" : "Parafarmacia Sanitaria Dott.ssa Veronica Ripoli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078148"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-09-01"
        }
      ]
    },
    {
      "code" : "5914",
      "display" : "EIKOS srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069081"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-03-01"
        }
      ]
    },
    {
      "code" : "5916",
      "display" : "esercizio commerciale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076063"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "5924",
      "display" : "FARMA & CHIC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036015"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "5925",
      "display" : "PARAFARMACIA CAPUTO LEONILDA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065079"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-03-01"
        }
      ]
    },
    {
      "code" : "5928",
      "display" : "PARAFARMACIA AZIENDA FELTRINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025011"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "5930",
      "display" : "SALUTE & BENESSERE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012013"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-08-01"
        }
      ]
    },
    {
      "code" : "5931",
      "display" : "Ditta individuale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065134"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "5934",
      "display" : "Parafarmacia Sant'Anna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "5935",
      "display" : "Sport Town Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "5937",
      "display" : "Parafarmacia Bruziches",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056038"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-11-01"
        }
      ]
    },
    {
      "code" : "5941",
      "display" : "Ranieri Rosamaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102047"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "5942",
      "display" : "SANTA LUCIA 2009 SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "5944",
      "display" : "PARAFARMACIA DOTTSSA PILUSO ANNAFRANCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054001"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "5945",
      "display" : "PARAFARMACIA VIVER SANI di Malomo Dott. Graziano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078029"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "5946",
      "display" : "PARAFARMACIA COMACCHIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038006"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-02-01"
        }
      ]
    },
    {
      "code" : "5948",
      "display" : "BIMBO STORE ROVIGO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029041"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "5949",
      "display" : "EURALCOOP Società Cooperativa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111035"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "5957",
      "display" : "la Farmoteka della dott.ssa trincas claudia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092003"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-06-01"
        }
      ]
    },
    {
      "code" : "5959",
      "display" : "salute store",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008065"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-09-01"
        }
      ]
    },
    {
      "code" : "5969",
      "display" : "Drugs & More srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061091"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "5973",
      "display" : "Parafarmacia Lotus di De Vito Antonella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064011"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5979",
      "display" : "Ideal Farm S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017066"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5980",
      "display" : "Accorsam",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095045"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5982",
      "display" : "PARAFARMACIA DOTT.SSA PALMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075019"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5983",
      "display" : "INTERSPAR BASSANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024012"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5987",
      "display" : "CIB FARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061057"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5990",
      "display" : "Parafarmacia Dott. Cardone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5991",
      "display" : "Parafarmacia Santa Barbara della Dr.ssa Dotta C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009023"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5993",
      "display" : "kydos srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092051"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5996",
      "display" : "PARAFARMACIA DOTT.FARINARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061094"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "5998",
      "display" : "Parafarmacia dott.ssa Deiana M.G.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "105017"
        },
        {
          "code" : "provincia",
          "valueCode" : "105"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6000",
      "display" : "LORETO MULTISERVIZI S.R.L",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042022"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6006",
      "display" : "Parafarmacia Vivasalute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6007",
      "display" : "FARMA LUNAE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011011"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6012",
      "display" : "Parafarmacia Naturfarma del dott. A. Barone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081006"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6014",
      "display" : "Parafarmacia Piemonte",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087013"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6015",
      "display" : "FIORE RITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072020"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6016",
      "display" : "ORTOPEDIA SANITARIA CMA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059032"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6017",
      "display" : "ORTOPEDIA SANITARIA CMA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059007"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6019",
      "display" : "PARAFARMACIA PERINELLI DOTT. ROMEO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6020",
      "display" : "Parafarmacia del dott. Serra",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076048"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6021",
      "display" : "PARAFARMACIA HEALTHING AXA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6022",
      "display" : "PHARMAPOINT TINTORETTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6024",
      "display" : "Parafarmacia Vittorio Emanuele",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015241"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-10-01"
        }
      ]
    },
    {
      "code" : "6030",
      "display" : "NOVAFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072030"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6032",
      "display" : "PeS srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-06-01"
        }
      ]
    },
    {
      "code" : "6033",
      "display" : "PARAFARMACIA DOTT.SSA ENRICA BORELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003119"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-12-01"
        }
      ]
    },
    {
      "code" : "6034",
      "display" : "FONTANA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036015"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-11-01"
        }
      ]
    },
    {
      "code" : "6037",
      "display" : "L'Angolo del Farmaco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6038",
      "display" : "PARAFARMACIA DEL BUON CONSIGLIO DI LASAGNI E C SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035010"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6039",
      "display" : "NOVA COOP SOC. COOP.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003068"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-10-01"
        }
      ]
    },
    {
      "code" : "6040",
      "display" : "Parafarmacia Dott. Paolo Giordano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083052"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6042",
      "display" : "SIGNO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100005"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6045",
      "display" : "PARAFARMACIA D.SSA SCORDO MARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080001"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6048",
      "display" : "Centro Commerciale Porte di Catania",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-05-01"
        }
      ]
    },
    {
      "code" : "6050",
      "display" : "AGHAZADEH TABRIZI MOJGAN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6052",
      "display" : "PARAFARMACIA DOTT.SSA MARINA BARTOCCINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054014"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6058",
      "display" : "PARAF. SANT'ANTONIO DELLA DOTTORESSA CARDASCO OLIMPIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064121"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-10-01"
        }
      ]
    },
    {
      "code" : "6060",
      "display" : "dott.nicola fizzarotti srl sanitaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6061",
      "display" : "Dott.Nicola Fizzarotti srl Sanitaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6065",
      "display" : "Il Farmacista",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078119"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6066",
      "display" : "MEDI-FARM PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065037"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6067",
      "display" : "Parafarmacia Gallinotti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004082"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-11-01"
        }
      ]
    },
    {
      "code" : "6069",
      "display" : "PARAFARMACIA DI TORTORELLI D'AMBROSIO ALBA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060074"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6071",
      "display" : "parafarmacia dott. smaldone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065007"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6073",
      "display" : "Parafarmacia Drugs & More",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "057054"
        },
        {
          "code" : "provincia",
          "valueCode" : "057"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6074",
      "display" : "Parafarmacia Wild Rose",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065025"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6078",
      "display" : "Parafarmacie FRER s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6079",
      "display" : "Parafarmacia ARTEMISIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088012"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6080",
      "display" : "PARAFARMACIA DR. PIETRO AGAMENNONE SOC. COOP.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "057059"
        },
        {
          "code" : "provincia",
          "valueCode" : "057"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6081",
      "display" : "PARAFARMACIA DOTT.SSA ANZALDO S.R.L. S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088012"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-12-01"
        }
      ]
    },
    {
      "code" : "6083",
      "display" : "PARAFARMACIA DOTT.SSA MIRIAM CRISTOFARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087018"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6087",
      "display" : "HEALTHING DOMUS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6088",
      "display" : "PARAFARMACIA HEALTHING DA VINCI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058120"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6091",
      "display" : "parafarmacia Le due baie",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010059"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-03-01"
        }
      ]
    },
    {
      "code" : "6092",
      "display" : "PARAFARMACIA STADIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029046"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6093",
      "display" : "FARMAVET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078108"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6095",
      "display" : "A. & C. Immobiliare S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054055"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6096",
      "display" : "FA di FILOMENA E ANTONIO TARANTINO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6097",
      "display" : "Erede Parafarmacia Dr. Tripaldi Francesco di Tripaldi  I.E.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102025"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "6099",
      "display" : "EsercizioFarmaceutico del Dr.Alessio Lecca &csas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2009-12-01"
        }
      ]
    },
    {
      "code" : "6100",
      "display" : "Parafarmacia San Raffaele S.A.S. di Maggioni Paolo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "097006"
        },
        {
          "code" : "provincia",
          "valueCode" : "097"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "6103",
      "display" : "Parafarmacia San Matteo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-12-01"
        }
      ]
    },
    {
      "code" : "6107",
      "display" : "all'angolo delle alpi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002002"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "6110",
      "display" : "fratto vincenza",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6116",
      "display" : "F.I.A. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079127"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6121",
      "display" : "parafarmacia d'amore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6123",
      "display" : "parafarmacia artemisia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054024"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6131",
      "display" : "Parafarmacia del dott. Mohsen Tcherassen",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6133",
      "display" : "FARMACENTER SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043007"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6141",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066098"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6144",
      "display" : "Parafarmacia Gocce di Salute della d.sa Laguardia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042012"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6145",
      "display" : "Parafarmacia Dr. Cristofalo Vincenzo & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-04-01"
        }
      ]
    },
    {
      "code" : "6146",
      "display" : "Parafarmacia Torelli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6147",
      "display" : "S.P.Pharma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-01-01"
        }
      ]
    },
    {
      "code" : "6148",
      "display" : "Salute e servizi srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015211"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-08-01"
        }
      ]
    },
    {
      "code" : "6149",
      "display" : "parafarmacia centro salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6152",
      "display" : "PARAFARMACIA TRAVAGLINI DOMENICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069046"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6153",
      "display" : "S.F. S.A.S. DI SACCO ANNALISA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004091"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6154",
      "display" : "parafarmacia dott. imparato",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061083"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6155",
      "display" : "PARAFARMACIA DEL CONSIGLIO DI PASQUALE DOTT. DARIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004034"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6158",
      "display" : "parafarmacia dott.ssa francesca citterio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015123"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6160",
      "display" : "PARAFARMACIA ETNAPOLIS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087007"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-11-01"
        }
      ]
    },
    {
      "code" : "6166",
      "display" : "HEALTHING SEDE CENTRALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058119"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6168",
      "display" : "PARAF. HEALTHING  C.C. TIBURTINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058047"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6169",
      "display" : "PHARMAPOINT SRL SEDE CENTRALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058119"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6170",
      "display" : "PARAF.HEALTHING C.C.PETROCELLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6178",
      "display" : "Arnone Company sas di Arnone Raffaele e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-10-01"
        }
      ]
    },
    {
      "code" : "6182",
      "display" : "PARAFARMACIA SAN LUCA srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065154"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6184",
      "display" : "Parafarmacia Erboristeria Neofarma s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6185",
      "display" : "Parafarmacia Crepet Dott Luca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026040"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6195",
      "display" : "portodiromafarma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6197",
      "display" : "farmaregno srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067041"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "6198",
      "display" : "PHARMAGEST SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058119"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6200",
      "display" : "FARMAPADOVA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6201",
      "display" : "Parafarmacia di Speranza Claudia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-02-01"
        }
      ]
    },
    {
      "code" : "6204",
      "display" : "PARAFARMACIA SAN LORENZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023058"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6205",
      "display" : "parafarmacia tranchina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6206",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063019"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6207",
      "display" : "PHARMA SALUS di Tiberio N. F. & c. sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069090"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6209",
      "display" : "Parafarmacia Biondi di BIONDI Maria Paola s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-07-01"
        }
      ]
    },
    {
      "code" : "6210",
      "display" : "Parafarmacia D.ssaLasandra",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6211",
      "display" : "Parafarmacia Dott.ssa Giulia Pedone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083097"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6213",
      "display" : "Farmasanitaria Parafarmacia Dott.ssa M. Cristodaro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101013"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6214",
      "display" : "parafarmacia-erboristeria dott.ssa baratta rita",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082070"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6215",
      "display" : "parafarmacia babybirba",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060003"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6216",
      "display" : "F.G. di D'Alessandro Flavia & C. snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066025"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6219",
      "display" : "Parafarmacia San Leone Dott.ssa Ida Ansalone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059030"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-02-01"
        }
      ]
    },
    {
      "code" : "6224",
      "display" : "PARAFARMACIA DOTT.SSA FABBRICATORE PAMELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078003"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6227",
      "display" : "Parafarmacia Dott. Marchisio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6229",
      "display" : "parafarmacia badesse",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052016"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6235",
      "display" : "BLUE FLAX Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6236",
      "display" : "SALUTE E + S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072016"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6237",
      "display" : "parafarmacia erboristeria il girasole",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078101"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6240",
      "display" : "PARAFARMACIA DOTT MARCHESE TERESA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065133"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6241",
      "display" : "Parafarmacia Benaco Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017170"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6244",
      "display" : "L'ALBERO DELLA SALUTE S.A.S. DI FROSONI FRANCO & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053018"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "6251",
      "display" : "PUNTOFARMA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6252",
      "display" : "parafarmacia omeopatica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088009"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6254",
      "display" : "erbofarma",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010006"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6256",
      "display" : "LD PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100005"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6261",
      "display" : "PARAFARMACIA DOTTORESSA RESTIVO GRAZIA LUCIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084012"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6262",
      "display" : "Parafarmacia Dott. Gianluca Cristiano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6263",
      "display" : "Parafarmacia S.Ambrogio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6265",
      "display" : "Parafarmacia dott.ssa Meletis Olga",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028028"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6272",
      "display" : "BOLOGNA EST SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2020-12-01"
        }
      ]
    },
    {
      "code" : "6273",
      "display" : "Parafarmacia oltretorrente Dott. Martinelli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6274",
      "display" : "PARAFARM di domenico silvano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076010"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-07-01"
        }
      ]
    },
    {
      "code" : "6275",
      "display" : "parafarmacia del dott. sammarco silvio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074008"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6276",
      "display" : "Parafarmacia di via Missaglia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6279",
      "display" : "WWW.FARMACORNER.IT S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-12-01"
        }
      ]
    },
    {
      "code" : "6280",
      "display" : "Archangelica S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6281",
      "display" : "PARAFARMACIA DELLA STAZIONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060019"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-03-01"
        }
      ]
    },
    {
      "code" : "6287",
      "display" : "PARAFARMACIA RUSSO DOTT.AUGUSTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087005"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6289",
      "display" : "farmavet",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091086"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6291",
      "display" : "PARAFARMACIA alchimia portocervo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104004"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6293",
      "display" : "Parafarmacia di Emanuele Maria Grazia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083101"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6295",
      "display" : "Parafarmacia dott.ssa A.Lodi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058059"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6298",
      "display" : "PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6302",
      "display" : "PARAFARMACIA ERB. PRA DELLE TORRI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027005"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6306",
      "display" : "Parafarmacia dott. Colucci Giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064010"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6309",
      "display" : "Parafarmacia Dr.ssa Donatella Sacco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061091"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6311",
      "display" : "Parafarmacia Sanipharm",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050037"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6315",
      "display" : "cadifarm s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6318",
      "display" : "PARAFARMACIA A.VIETTI DI Iris S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6319",
      "display" : "Novafarmas srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6321",
      "display" : "parafarmacia babybirba",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060003"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6322",
      "display" : "parafarmacia di Leonardo Vitale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101004"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6323",
      "display" : "Erboristeria-Sanitaria dr. Fiammengo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026004"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6327",
      "display" : "mida s.a.s. di riccio dott cosimo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6328",
      "display" : "SARA DI BARRELLA PATRIZIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6330",
      "display" : "parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059001"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6331",
      "display" : "FARMA PIU' SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046033"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-04-01"
        }
      ]
    },
    {
      "code" : "6333",
      "display" : "PARAFARMACIA BIANCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072021"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6334",
      "display" : "Parafarmacia Panecaldo Miriam",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058047"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6335",
      "display" : "PUNTO SALUTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027005"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6337",
      "display" : "Parafarmacia di Apa Vittoria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6344",
      "display" : "PARAFARMACIA TECNOMEDICAL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065002"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6345",
      "display" : "DELTA OIL COMPANY SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6346",
      "display" : "Parafarmacia Erboristeria Dr. Massimo Corona",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002158"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6347",
      "display" : "parafarmacia san francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059032"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6348",
      "display" : "parafarmaciaC.R.P snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054054"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6350",
      "display" : "Parafarmacia Dott.ssa De Luca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078015"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6353",
      "display" : "L'ALTRA FARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075024"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-04-01"
        }
      ]
    },
    {
      "code" : "6354",
      "display" : "parafarmacia borgo belli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-03-01"
        }
      ]
    },
    {
      "code" : "6355",
      "display" : "Parafarmacia Bini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104017"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6358",
      "display" : "ERBORISTERIA ELISIR DOTT.SSA ADRIANI SARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044066"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6384",
      "display" : "parafarmacia kastalia di bordonaro leonardo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088009"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6387",
      "display" : "Parafarmacia Configni s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "057024"
        },
        {
          "code" : "provincia",
          "valueCode" : "057"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6388",
      "display" : "PARAFARMACIA RUGGIERO FRANCESCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064025"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6393",
      "display" : "parafarmacia kursaal",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009034"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-05-01"
        }
      ]
    },
    {
      "code" : "6394",
      "display" : "PARAFARMACIA PUDDU",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104013"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6395",
      "display" : "PARAFARMACIA MOLINERIS Dr.ssa SONIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004225"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2012-12-01"
        }
      ]
    },
    {
      "code" : "6396",
      "display" : "HEALTHCARE TIBURTINO SHOPPING CENTER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058047"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6407",
      "display" : "Parapharmacia D.ssa Rita Tacconelli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6409",
      "display" : "Parafarmacia Dr.ssa Donatella Sacco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061091"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6412",
      "display" : "PARAFARMACIA NONSOLOFARMA DR DE PASQUAL MONICA & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025006"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6413",
      "display" : "Parafarmacia San Pietro del dr Francesco Iovine",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "094022"
        },
        {
          "code" : "provincia",
          "valueCode" : "094"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6414",
      "display" : "GONTIER SILVANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001191"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6415",
      "display" : "PARAFARMACIA SAN GIOVANNI S.N.C. DI PASSARINO GABR",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004143"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-05-01"
        }
      ]
    },
    {
      "code" : "6421",
      "display" : "Parafarmacia Aloe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065029"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6424",
      "display" : "POSEIDON S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082021"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6428",
      "display" : "PARAFARMACIA MENELAO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063001"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-01-01"
        }
      ]
    },
    {
      "code" : "6429",
      "display" : "GIORIAN S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058046"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6432",
      "display" : "PHARMAVILLAGE DI PALUDI ORIELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6436",
      "display" : "Parafarmacia Orthomedisan di Parente Rosanna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076062"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6439",
      "display" : "parafarmacia corso cavour",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6440",
      "display" : "Futurfarma Parafarmacia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046005"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6443",
      "display" : "Furba sara S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009002"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6445",
      "display" : "Eudaimonia s.n.c. di A. Bernieri e I. Di Rosa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6447",
      "display" : "PARAFARMACIA XX SETTEMBRE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6452",
      "display" : "PARAFARMACIA SALUS SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078029"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6453",
      "display" : "Farmarisparmio Dssa Angela Mercuri",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6454",
      "display" : "D e V Pharma parafarmacia dott.ssa Malandra",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069008"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6473",
      "display" : "Parafarmacia Villa iris s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001189"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2018-12-01"
        }
      ]
    },
    {
      "code" : "6476",
      "display" : "Parafarmacia Su Planu",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092068"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6477",
      "display" : "parafarmacia s. caterina dott.ssa michela cini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053009"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6478",
      "display" : "PARAFARMACIA SAN MATTEO 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6481",
      "display" : "parafarmacia Il carro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064050"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6487",
      "display" : "PARAFARMACIA TERME & SALUTE FIUGGI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060035"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-06-01"
        }
      ]
    },
    {
      "code" : "6506",
      "display" : "LA NATURA DELLE COSE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075090"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6531",
      "display" : "mida s.a.s di Riccio dott Cosimo & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6540",
      "display" : "Parafarmacia 'Biofarm'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090079"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6556",
      "display" : "PARAFARMACIA MIGLIORI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056057"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6575",
      "display" : "Parafarmacia San Pietro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004009"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6576",
      "display" : "Parafarmacia musto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001191"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6577",
      "display" : "SANNIA ANNA PARAFARMACIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095079"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2015-05-01"
        }
      ]
    },
    {
      "code" : "6579",
      "display" : "PARAFARMACIA GIACCI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6580",
      "display" : "PARAFARMACIA DR.TAVIAN GIANANTONIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026019"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6581",
      "display" : "PARAFARMACIA Nini Sas di Alfio Allera & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003043"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2014-01-01"
        }
      ]
    },
    {
      "code" : "6582",
      "display" : "PARAFARMACIA CUSMANO DR.SSA CARMELA SANTANGELO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084041"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6584",
      "display" : "parafarmacia di via sopramuro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6619",
      "display" : "Disalus Sas di Mealli Giovanni & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6622",
      "display" : "MANCINI GIOVANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058103"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6623",
      "display" : "PARAFARMACIA DOTT. MELLA DI MELLA MATTEO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023044"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2021-09-01"
        }
      ]
    },
    {
      "code" : "6626",
      "display" : "ORTOPEDIA SANIFARM DELLA D.SSA ANNA DAGLIO&C.SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006114"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6633",
      "display" : "COOP LIGURIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009002"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-07-01"
        }
      ]
    },
    {
      "code" : "6639",
      "display" : "FARMAVET LUCANA DI FRANCESCO STOLFI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076036"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6641",
      "display" : "L'Angolo della Salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088009"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6658",
      "display" : "Health Retail Centro Commerciale Cinecitta' 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6659",
      "display" : "Health Retail Centro Commeciale Casetta Mattei",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6660",
      "display" : "Health Retail Centro Commeciale Anagnina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6661",
      "display" : "Health Retail Centro Commeciale Dima Shopping",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6662",
      "display" : "Health Retail Market Cental Da Vinci",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058120"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6663",
      "display" : "Health Retail Pantheon",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6664",
      "display" : "Health Retail Centro Commeciale Torrino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6665",
      "display" : "Health Retail Axa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6666",
      "display" : "Health Retail Centro Commeciale Domus",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6667",
      "display" : "Health Retail Casilina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6668",
      "display" : "Health Retail Terni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6669",
      "display" : "Health Retail Centro Commeciale Tiburtino Shop.Cen",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6670",
      "display" : "parafarmacia dott.ssa Genca Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062003"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6678",
      "display" : "PARAFARMACIA REGINA PACIS DI BORDIGNON MICHELE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026050"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6679",
      "display" : "FARMAVITA S.A.S OLIENA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091055"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6681",
      "display" : "Cooperativa Farmaceutica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075057"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2011-06-01"
        }
      ]
    },
    {
      "code" : "6715",
      "display" : "Parafarmacia ARTEMISIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088012"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-09-01"
        }
      ]
    },
    {
      "code" : "6716",
      "display" : "Health Retail Tintoretto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6717",
      "display" : "NAZOKIAN MONFARED ROGHAYED",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6721",
      "display" : "Parafarmacia Dr.ssa Nigro A.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6726",
      "display" : "Farmacenter S.a.s. di A. Sciarrone & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080012"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-08-01"
        }
      ]
    },
    {
      "code" : "6728",
      "display" : "Erboristeria Parafarmacia Kayapò",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072046"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-01-01"
        }
      ]
    },
    {
      "code" : "6733",
      "display" : "Lattanzio Tiberio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072007"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-09-01"
        }
      ]
    },
    {
      "code" : "6735",
      "display" : "PITRELLI ILARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078031"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-09-01"
        }
      ]
    },
    {
      "code" : "6737",
      "display" : "PARAFARMACIA PERRI, DOTT.SSA TANIA PERRI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078070"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-07-01"
        }
      ]
    },
    {
      "code" : "6739",
      "display" : "Parafarmacia Dott.ssa Donatella Sarubbo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078029"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-09-01"
        }
      ]
    },
    {
      "code" : "6745",
      "display" : "NOVA COOP S.C. IPER CUORGNE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001098"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-09-01"
        }
      ]
    },
    {
      "code" : "6748",
      "display" : "PARAFARMACIA CATALANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084041"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-09-01"
        }
      ]
    },
    {
      "code" : "6751",
      "display" : "Parafarmacia Vittorio Emanuele",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017125"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-09-01"
        }
      ]
    },
    {
      "code" : "6752",
      "display" : "DARMA IL FARMASTORE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022205"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-09-01"
        }
      ]
    },
    {
      "code" : "6756",
      "display" : "PARAFARMACIA Dott.ssa Ruffin S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-09-01"
        }
      ]
    },
    {
      "code" : "6759",
      "display" : "Parafarmacia l'Amamalide",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059025"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-09-01"
        }
      ]
    },
    {
      "code" : "6761",
      "display" : "LA PARAFARMACIA DOTT. MARIA ROSA GRAMEGNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098050"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-10-01"
        }
      ]
    },
    {
      "code" : "6764",
      "display" : "Perry Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072030"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-10-01"
        }
      ]
    },
    {
      "code" : "6767",
      "display" : "Parafarmacia della Dott.ssa ALI Jamila Isabella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069099"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-10-01"
        }
      ]
    },
    {
      "code" : "6768",
      "display" : "Tirreno Insieme",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058013"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-07-01"
        }
      ]
    },
    {
      "code" : "6772",
      "display" : "PARAFARMACIA BABY BIRBA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060038"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-10-01"
        }
      ]
    },
    {
      "code" : "6779",
      "display" : "Parafarmacia San Domenico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072031"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2016-05-01"
        }
      ]
    },
    {
      "code" : "6783",
      "display" : "NATUR VITAE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-10-01"
        }
      ]
    },
    {
      "code" : "6788",
      "display" : "ABBATE LUISA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059009"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-12-01"
        }
      ]
    },
    {
      "code" : "6795",
      "display" : "Parafarmacia Dott.ssa Eliana Mancuso",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2019-08-01"
        }
      ]
    },
    {
      "code" : "6801",
      "display" : "FARMAPADOVA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-10-01"
        }
      ]
    },
    {
      "code" : "6802",
      "display" : "PARAFARMACIA Dott. Alessandro Benedetto Ferlito",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2017-09-01"
        }
      ]
    },
    {
      "code" : "6803",
      "display" : "Obiettivosalute di Pigollo Rosa Giulia Rita",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009004"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2010-10-01"
        }