# MDS - Strutture di Ricovero - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **MDS - Strutture di Ricovero**

## CodeSystem: MDS - Strutture di Ricovero 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/minsan-hsp | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsMDStruttureRicovero |

 
Ministero della Salute - Strutture di Ricovero 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsMinisteroSaluteIdAOU](ValueSet-minsan-idAou.md)
* [VsMinisteroSaluteIdAziendeOspedaliere](ValueSet-minsan-idAziendeOspedaliere.md)
* [VsMinisteroSaluteIdStrutture](ValueSet-minsan-idStrutture.md)
* [VsStrutturePubbliche](ValueSet-strutturePubbliche.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "minsan-hsp",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/minsan-hsp",
  "version" : "0.1.2",
  "name" : "CsMDStruttureRicovero",
  "title" : "MDS - Strutture di Ricovero",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Ministero della Salute - Strutture di Ricovero",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "filter" : [
    {
      "code" : "regione",
      "description" : "Permette di ricercare i codici secondo il codice regionale",
      "operator" : ["="],
      "value" : "code"
    },
    {
      "code" : "comune",
      "description" : "Permette di ricercare i codici secondo il codice comunale",
      "operator" : ["="],
      "value" : "code"
    },
    {
      "code" : "aslTerritoriale",
      "description" : "Permette di ricercare i codici secondo il codice dell'asl territoriale",
      "operator" : ["="],
      "value" : "code"
    },
    {
      "code" : "codiceAzienda",
      "description" : "Permette di ricercare i codici secondo il codice azienda",
      "operator" : ["="],
      "value" : "code"
    },
    {
      "code" : "tipoStruttura",
      "description" : "Permette di ricercare i codici secondo il codice del tipo di struttura",
      "operator" : ["="],
      "value" : "code"
    },
    {
      "code" : "naturaGiuridica",
      "description" : "Permette di ricercare i codici secondo la natura giuridica",
      "operator" : ["="],
      "value" : "code"
    }
  ],
  "property" : [
    {
      "code" : "regione",
      "description" : "proprietà che identifica la regione di appartenenza delle strutture di ricovero",
      "type" : "code"
    },
    {
      "code" : "comune",
      "description" : "proprietà che identifica il comune di appartenenza delle strutture di ricovero",
      "type" : "code"
    },
    {
      "code" : "aslTerritoriale",
      "description" : "proprietà che identifica l'ASL di appartenenza delle strutture di ricovero",
      "type" : "code"
    },
    {
      "code" : "codiceAzienda",
      "description" : "proprietà che identifica il codice dell'azienda",
      "type" : "code"
    },
    {
      "code" : "tipoStruttura",
      "description" : "proprietà che identifica il tipo di struttura delle strutture di ricovero",
      "type" : "code"
    },
    {
      "code" : "naturaGiuridica",
      "description" : "Proprietà che identifica la natura giurdica delle strutture di ricovero",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "010904",
      "display" : "AZIENDA OSPEDALIERO UNIVERSITARIA S.LUIG",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001171"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "904"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010030",
      "display" : "OSPEDALI RIUNITI PINEROLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001191"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010079",
      "display" : "OSPEDALI RIUNITI RIVOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001219"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010614",
      "display" : "CASA DI CURA VILLE AUGUSTA - S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001038"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010615",
      "display" : "CASA DI CURA VILLA PATRIZIA - S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001194"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010621",
      "display" : "CASA DI CURA VILLA SERENA - S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001194"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010623",
      "display" : "VILLA PAPA GIOVANNI XXIII",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001189"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010646",
      "display" : "CASA DI CURA VILLA IRIS SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001189"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010651",
      "display" : "CASA DI CURA MADONNA DEI BOSCHI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010663",
      "display" : "MEDICAL SERVICE S.A.S",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001191"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010017",
      "display" : "OSPEDALE CIVICO CHIVASSO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001082"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010019",
      "display" : "PRESIDI OSPED. RIUNITI A.S.L. 6 CIRIE'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001086"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010023",
      "display" : "OSPEDALI RIUNITI DEL CANAVESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001125"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010616",
      "display" : "CASA DI CURA CLINICA EPOREDIESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001125"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010617",
      "display" : "CASA DI CURA VILLE TURINA AMIONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001248"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010622",
      "display" : "CASA DI CURA VILLA IDA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001128"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010644",
      "display" : "CASA DI CURA VILLA GRAZIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001237"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010667",
      "display" : "STUDIO MEDICO AURORA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001020"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010891",
      "display" : "BEATA VERGINE CONSOLATA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001248"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "010922",
      "display" : "FONDAZIONE DEL PIEMONTE PER L'ONCOLOGIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "922"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "010004",
      "display" : "OSPEDALI RIUNITI A.S.L. TO 5",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001078"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010618",
      "display" : "CASA DI CURA E RIPOSO S. LUCA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001183"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010620",
      "display" : "CASA DI CURA VILLA DI SALUTE SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001280"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010648",
      "display" : "ADRIANA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010661",
      "display" : "POLICLINICO SAN LUCA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001059"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010009",
      "display" : "OSPEDALE UNICO DEL VERCELLESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "002158"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010626",
      "display" : "POLICLINICO DI MONZA SPA - CASA DI CURA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "002158"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010657",
      "display" : "CASA DI CURA CENTRO R.R.F. MONS. LUIGI N",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "002079"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010032",
      "display" : "OSPEDALE DEGLI INFERMI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "096047"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010627",
      "display" : "CASA DI CURA SAN GIORGIO SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "096080"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010656",
      "display" : "POLICLINICO DI MONZA S.P.A. PRESIDIO CLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "096004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010905",
      "display" : "AZIENDA OSPED. NOVARA E GALLIATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "905"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010921",
      "display" : "FONDAZIONE SALVATORE MAUGERI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "003166"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "921"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "010006",
      "display" : "ISTITUTO SS. TRINITA - BORGOMANERO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "003024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010628",
      "display" : "POLICLINICO DI MONZA SPA - PRESIDIO CLIN",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010630",
      "display" : "CASA DI CURA S.CARLO DI ARONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "003008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010649",
      "display" : "HABILITA S.P.A. - PRESIDIO I CEDRI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "003065"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010660",
      "display" : "CENTRO MEDICO POLISPECIALISTICO AMBULATO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "003024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010665",
      "display" : "CASA DI CURA VILLA CRISTINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "003103"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010920",
      "display" : "ISTITUTO AUXOLOGICO ITALIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "103049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "920"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "010005",
      "display" : "OSPEDALE UNICO PLURISEDE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "103050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010629",
      "display" : "CASA DI CURA L'EREMO DI MIAZZINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "103015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010896",
      "display" : "CENTRO ORTOPEDICO DI QUADRANTE - COQ SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "103050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "010906",
      "display" : "AZ. OSPEDAL. S. CROCE E CARLE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004078"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010210"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "906"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010124",
      "display" : "PRESIDIO OSPEDALIERO AREA SUD - CN1",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004130"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010210"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "210"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010126",
      "display" : "PRESIDIO OSPEDALIERO AREA NORD - CN1",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004215"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010210"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "210"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010633",
      "display" : "ISTITUTO CLIMATICO DI ROBILANTE S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004185"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010210"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "210"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010634",
      "display" : "CASA DI CURA MONTESERRAT S.R.L",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004040"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010210"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "210"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010647",
      "display" : "FONDAZIONE ORIZZONTE SPERANZA - ONLUS CA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004028"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010210"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "210"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010659",
      "display" : "S.R.L. TERAPEUTICENTER - ISTITUTO MEDICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004041"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010210"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "210"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010670",
      "display" : "BIOMED SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004089"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010210"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "210"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010038",
      "display" : "OSPEDALE MICHELE FERRERO E PIETRO FERRER",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004238"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010211"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "211"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010631",
      "display" : "CASA DI CURA SAN MICHELE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010211"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "211"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010632",
      "display" : "CASA DI CURA CITTA' DI BRA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010211"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "211"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010635",
      "display" : "CASA DI CURA LA RESIDENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "004196"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010211"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "211"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010008",
      "display" : "OSPEDALI RIUNITI ASL AT",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "005005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010212"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "212"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010639",
      "display" : "CASA DI CURA S. ANNA SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "005005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010212"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "212"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010026",
      "display" : "OSPEDALI RIUNITI ASL AL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "006003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010213"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "213"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010641",
      "display" : "CASA DI CURA VILLA IGEA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "006001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010213"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "213"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010642",
      "display" : "CASA DI CURA SANT'ANNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "006039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010213"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "213"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010666",
      "display" : "POLICLINICO DI MONZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "006003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010213"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "213"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010907",
      "display" : "AZ. SS.ANTONIO E BIAGIO E C.ARRIGO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "006003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010213"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "907"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010909",
      "display" : "AOU CITTA' DELLA SALUTE E DELLA SCIENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "909"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010003",
      "display" : "OSPEDALE MARIA VITTORIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010007",
      "display" : "OSPEDALE MARTINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010010",
      "display" : "OSPEDALE OFTALMICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010011",
      "display" : "TORINO NORD EMERGENZA SAN GIOVANNI BOSCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010013",
      "display" : "OSPEDALE AMEDEO DI SAVOIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "010601",
      "display" : "CLINICA PINNA PINTOR SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010603",
      "display" : "CLINICA SANTA CATERINA DA SIENA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010604",
      "display" : "SEDES SAPIENTIAE SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010610",
      "display" : "CASA DI CURA FORNACA DISESSANT",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010611",
      "display" : "VILLA MARIA PIA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010612",
      "display" : "CASA DI CURA KOELLIKER OSPEDALINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010653",
      "display" : "PROMEA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010655",
      "display" : "CASA DI CURA CELLINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010662",
      "display" : "MOD CENTRO MEDICO CHIRURGICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010664",
      "display" : "LARC 2 S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010668",
      "display" : "LARC SPA DAY SURGERY TIPO C",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "010892",
      "display" : "PRESIDIO SANITARIO GRADENIGO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "010893",
      "display" : "PRESIDIO SANITARIO SAN CAMILLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "010897",
      "display" : "PRESIDIO SANITARIO OSPEDALE COTTOLENGO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "010898",
      "display" : "PRESIDIO MAJOR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "010999",
      "display" : "AUSILIATRICE DON GNOCCHI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "010908",
      "display" : "OSPEDALE MAURIZIANO UMBERTO I - TORINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "010301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "908"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "020001",
      "display" : "OSPEDALE REGIONALE UMBERTO PARINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "comune",
          "valueCode" : "007003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "020101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "020002",
      "display" : "ISAV SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "comune",
          "valueCode" : "007063"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "020101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030067",
      "display" : "OSPEDALE MAGGIORE DI LODI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "098031"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "709"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030079",
      "display" : "OSPEDALE CIVICO - CODOGNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "098019"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "709"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030080",
      "display" : "OSPEDALE ROSSI - CASALPUSTERLENGO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "098010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "709"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030083",
      "display" : "OSPEDALE DELMATI - SANT'ANGELO LODIGIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "098050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "709"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030709",
      "display" : "ASST DI LODI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "098031"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "709"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030056",
      "display" : "PRESIDIO OSPED. V. BUZZI - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "703"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030057",
      "display" : "OSPEDALE M. MELLONI - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "703"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030703",
      "display" : "ASST FATEBENEFRATELLI SACCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "703"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030910",
      "display" : "OSPEDALE FATEBENEFRATELLI E OFTALMICO -",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "703"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030916",
      "display" : "OSPEDALE L. SACCO - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "703"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030701",
      "display" : "ASST GRANDE OSPEDALE METROPOLITANO NIGUA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "701"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030913",
      "display" : "OSPEDALE CA' GRANDA-NIGUARDA - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "701"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030071",
      "display" : "OSPEDALE S. MARIA DELLE STELLE MELZO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015142"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "708"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030072",
      "display" : "OSPEDALE DI VIZZOLO PREDABISSI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015244"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "708"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030085",
      "display" : "OSPEDALE UBOLDO - CERNUSCO S/NAVIGLIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015070"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "708"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030708",
      "display" : "ASST MELEGNANO E DELLA MARTESANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015244"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "708"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030051",
      "display" : "P.O. CITTA' DI SESTO S. GIOVANNI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015209"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "707"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030058",
      "display" : "OSPEDALE BASSINI - CINISELLO BALSAMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015077"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "707"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030707",
      "display" : "ASST NORD MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015209"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "707"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030074",
      "display" : "OSPEDALE DI MAGENTA - ABBIATEGRASSO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015130"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "705"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030281",
      "display" : "OSPEDALE DI LEGNANO E CUGGIONO-LEGNANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015118"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "705"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030705",
      "display" : "ASST OVEST MILANESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015118"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "705"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030066",
      "display" : "OSPEDALE G.SALVINI-GARBAGNATE MIL.SE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015105"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "706"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030073",
      "display" : "OSPEDALE DI CIRCOLO - RHO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015182"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "706"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030283",
      "display" : "OSPEDALE G.CASATI-PASSIRANA RHO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015182"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "706"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030706",
      "display" : "ASST RHODENSE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015105"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "706"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030702",
      "display" : "ASST SANTI PAOLO E CARLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "702"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030914",
      "display" : "OSPEDALE S. PAOLO - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "702"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030915",
      "display" : "OSPEDALE S. CARLO BORROMEO - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "702"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030704",
      "display" : "ASST SPEC.ORT.TRAUMATOLOGICO G.PINI/CTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "704"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030911",
      "display" : "ISTITUTO ORTOPEDICO GAETANO PINI - MILAN",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "704"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030912",
      "display" : "P.O. CENTRO TRAUMATOLOGICO ORTOPEDICO -",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "704"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030096",
      "display" : "CASA DI CURA DEL POLICLINICO - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030097",
      "display" : "ISTITUTO CLINICO CITTA' STUDI - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030100",
      "display" : "CASA DI CURA IGEA - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030101",
      "display" : "CASA DI CURA VILLA LETIZIA - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030103",
      "display" : "CASA DI CURA PALAZZOLO-FOND.DON GNOCCHI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030105",
      "display" : "CASA DI CURA S. CAMILLO - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030110",
      "display" : "CASA DI CURA S. GIOVANNI - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030113",
      "display" : "CASA DI CURA LA MADONNINA - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030116",
      "display" : "CLINICA POLISPECIALISTICA SAN CARLO - S.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015166"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030121",
      "display" : "CASA DI CURA S. PIO X - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030124",
      "display" : "ISTITUTO STOMATOLOGICO ITALIANO - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030125",
      "display" : "CASA DI CURA AMBROSIANA SPA-CESANO B.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015074"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030266",
      "display" : "CASA DI CURA COLUMBUS - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030352",
      "display" : "POLO GERIATRICO RIABILITATIVO-CINISELLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015077"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030359",
      "display" : "FONDAZIONE EUROPEA DI RICERCA BIOMEDICA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015059"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030363",
      "display" : "RESIDENZA ANNI AZZURRI MIRASOLE - OPERA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015159"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030367",
      "display" : "OSPEDALE S. GIUSEPPE - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030378",
      "display" : "CENTRO CLINICO NEMO - FOND. SERENA - MIL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "321"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030934",
      "display" : "CENTRO CARDIOLOGICO FOND. MONZINO - MI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "934"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030925",
      "display" : "FONDAZ.IRCCS CA' GRANDA - OSPEDALE MAGGI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "925"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "030922",
      "display" : "FOND.IRCCS ISTIT.NAZ.LE TUMORIMILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "922"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "030923",
      "display" : "FOND.IRCCS IST.NAZ.NEUROLOGICO C.BESTA-M",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "923"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "030949",
      "display" : "IRCCS IST. SCIENTIFICO DI RIABILITAZIONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "949"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030947",
      "display" : "I.R.C.C.S. POLICLINICO SAN DONATO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015192"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "947"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030937",
      "display" : "IRCCS S.M.NASCENTE-FOND.DON C.GNOCCHI-MI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "937"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030935",
      "display" : "IRCCS S. RAFFAELE - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "935"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030936",
      "display" : "IST.AUXOLOGICO ITALIANO - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "936"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030943",
      "display" : "IST. CLIN. HUMANITAS - ROZZANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015189"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "943"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030941",
      "display" : "ISTITUTO EUROPEO DI ONCOLOGIA-MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "941"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030946",
      "display" : "OSPEDALE GALEAZZI SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "946"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030950",
      "display" : "SAN RAFFAELE TURRO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030321"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "950"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030010",
      "display" : "OSPEDALE GALMARINI - TRADATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012127"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "710"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030012",
      "display" : "OSPEDALE CARLO ONDOLI - ANGERA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "710"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030282",
      "display" : "PRESIDIO OSPEDALIERO DEL VERBANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "710"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030710",
      "display" : "ASST DEI SETTE LAGHI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012133"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "710"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030901",
      "display" : "PRESIDIO OSPEDALIERO DI VARESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012133"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "710"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030004",
      "display" : "OSPEDALE DI CIRCOLO - BUSTO ARSIZIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "711"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030006",
      "display" : "OSP. S. ANTONIO ABATE - GALLARATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012070"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "711"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030008",
      "display" : "OSP. GENERALE PROVINCIALE - SARONNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012119"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "711"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030009",
      "display" : "OSPEDALE A.BELLINI - SOMMA LOMBARDO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012123"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "711"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030711",
      "display" : "ASST DELLA VALLE OLONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "711"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030022",
      "display" : "UNICO PRESIDIO CANTU' MARIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013041"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "712"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030026",
      "display" : "OSPEDALE ERBA- RENALDI - MENAGGIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013145"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "712"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030712",
      "display" : "ASST LARIANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013075"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "712"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030902",
      "display" : "OSPEDALE S. ANNA - COMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013206"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "712"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030015",
      "display" : "CASA DI CURA SANTA MARIA - CASTELLANZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030017",
      "display" : "CASA DI CURA MATER DOMINI - CASTELLANZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030029",
      "display" : "OSP.SACRA FAMIGLIA - F.B.F. - ERBA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013095"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030030",
      "display" : "OSPEDALE VALDUCE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013075"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030032",
      "display" : "IST.CLINICO VILLA APRICA SPA-COMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013075"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030035",
      "display" : "C.O.F. LANZO HOSPITAL - ALTA VALLE INTEL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013253"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030037",
      "display" : "CASA DI CURA VILLA S. BENEDETTO-ALBESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030038",
      "display" : "CASA DI CURA LE BETULLE-APPIANO GENTILE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030347",
      "display" : "CASA DI CURA VILLA S. GIUSEPPE-ANZANO DE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030364",
      "display" : "FOND. GAETANO E PIERA BORGHI - BREBBIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030372",
      "display" : "SINLAB ITALIA S.R.L. - COMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013075"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030388",
      "display" : "IST. RIV. E CURA-GRUPPO ISENI SANITA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012090"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030397",
      "display" : "CASA DI CURA LE TERRAZZE - CUNARDO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "322"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030930",
      "display" : "IRCCS CENTRO MEDICO TRADATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "012127"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030322"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "930"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030274",
      "display" : "OSPEDALE VALCAMONICA - ESINE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017070"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030323"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "714"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030714",
      "display" : "ASST DELLA VALCAMONICA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017028"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030323"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "714"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030042",
      "display" : "OSPEDALE SONDRIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "014061"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030323"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "713"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030044",
      "display" : "OSPEDALE DI CHIAVENNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "014018"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030323"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "713"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030045",
      "display" : "OSPEDALE MORBEGNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "014045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030323"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "713"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030713",
      "display" : "ASST DELLA VALTELLINA E DELL'ALTO LARIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "014061"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030323"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "713"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030904",
      "display" : "OSPEDALE MORELLI - SONDALO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "014060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030323"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "713"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030031",
      "display" : "OSP. MORIGGIA PELASCINI - GRAVEDONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "013249"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030323"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "323"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030068",
      "display" : "PRESIDIO OSPEDALIERO DI DESIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "717"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030070",
      "display" : "PRESIDIO OSPEDALIERO DI CARATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "717"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030078",
      "display" : "PRESIDIO OSPEDALIERO DI VIMERCATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "717"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030082",
      "display" : "P.O. TRABATTONI RONZONI DI SEREGNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "717"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030717",
      "display" : "ASST DELLA BRIANZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "717"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030023",
      "display" : "OSPEDALE UMBERTO I - BELLANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "097008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "715"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030024",
      "display" : "OSPEDALE DI CIRCOLO S.L.MANDIC-MERATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "097048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "715"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030715",
      "display" : "ASST DI LECCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "097042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "715"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030903",
      "display" : "OSPEDALE DI CIRCOLO A. MANZONI - LECCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "097042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "715"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030033",
      "display" : "CASA DI CURA BEATO L.TALAMONI-LECCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "097042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "324"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030034",
      "display" : "CASA DI CURA G.B. MANGIONI - LECCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "097042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "324"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030106",
      "display" : "CASA DI CURA POLICLINICO - MONZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "324"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030107",
      "display" : "ISTITUTI CLINICI ZUCCHI SPA-MONZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "324"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030108",
      "display" : "CASA DI CURA ZUCCHI - CARATE BRIANZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "324"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030109",
      "display" : "CASA DI CURA VILLA BIANCA - LIMBIATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "324"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030284",
      "display" : "CENTRO DI RIABIL.VILLA BERETTA-COSTA M",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "097026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "324"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030417",
      "display" : "ISTITUTI CLINICI SCIENTIFICI MAUGERI - L",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108028"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "324"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030926",
      "display" : "FONDAZIONE IRCCS SAN GERARDO DEI TINTORI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "108033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "926"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "030920",
      "display" : "I.N.R.C.A.- PRESIDIO DI CASATENOVO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "097016"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "920"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030948",
      "display" : "IRCCS MULTIMEDICA - MILANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "015209"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "948"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030931",
      "display" : "ISTITUTO SCIENTIFICO MEDEA-BOSISIO P.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "097009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030324"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "931"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030133",
      "display" : "OSPEDALE PESENTI FENAROLI - ALZANO L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "720"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030136",
      "display" : "OSPEDALE BRIOLINI - GAZZANIGA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016111"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "720"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030137",
      "display" : "OSP.LE SS.CAPITANIO E GEROSA - LOVERE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016128"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "720"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030140",
      "display" : "OSPEDALE BOLOGNINI - SERIATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016198"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "720"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030382",
      "display" : "OSPEDALE M. O. ANTONIO LOCATELLI-PIARIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016163"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "720"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030720",
      "display" : "ASST DI BERGAMO EST",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016198"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "720"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030131",
      "display" : "OSPEDALE DI TREVIGLIO E CARAVAGGIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016219"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "719"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030138",
      "display" : "OSP.LE SS.TRINITA'-ROMANO DI LOMBARDIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016183"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "719"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030719",
      "display" : "ASST DI BERGAMO OVEST",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016219"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "719"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030132",
      "display" : "OSPEDALE CIVILE - S.GIOVANNI BIANCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016188"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "718"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030718",
      "display" : "ASST PAPA GIOVANNI XXIII",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "718"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030905",
      "display" : "OSPEDALE PAPA GIOVANNI XXIII - BG",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "718"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030143",
      "display" : "HUMANITAS GAVAZZENI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030144",
      "display" : "CASA DI CURA BEATO PALAZZOLO - BERGAMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030145",
      "display" : "HUMANITAS CASTELLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030146",
      "display" : "CASA DI CURA S. FRANCESCO - BERGAMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030147",
      "display" : "POLICLINICO SAN MARCO - OSIO SOTTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016153"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030148",
      "display" : "POLICLINICO SAN PIETRO - PONTE S. PIETR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016170"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030149",
      "display" : "ISTITUTO CLINICO QUARENGHI SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016190"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030337",
      "display" : "VILLA SANT'APOLLONIA S.R.L. - BERGAMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030350",
      "display" : "OSPEDALE S.ISIDORO - TRESCORE B.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016218"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030354",
      "display" : "NEPHROCARE S.P.A. - SERIATE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016198"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030356",
      "display" : "ISTITUTO CLINICO HABILITA - CISERANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016075"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030360",
      "display" : "FERB-ONLUS C.TRO ALZHEIMER-GAZZANIGA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016111"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030379",
      "display" : "HABILITA IST.CLINICO-OSP.LE DI SARNICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016193"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030384",
      "display" : "C.R.C. MALATTIE RARE ALDO E CELE DACCO'-",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "016178"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030325"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "325"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030159",
      "display" : "PRESIDIO OSPEDALIERO DI MONTICHIARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017113"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "721"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030162",
      "display" : "PRESIDIO OSPEDALIERO GARDONE V.T.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017075"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "721"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030167",
      "display" : "OSPEDALE DEI BAMBINI - BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "721"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030721",
      "display" : "ASST DEGLI SPEDALI CIVILI DI BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "721"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030906",
      "display" : "PRES.OSPEDAL.SPEDALI CIVILI BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "721"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030156",
      "display" : "OSPEDALE DI DESENZANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017067"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "723"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030157",
      "display" : "OSPEDALE CIVILE LA MEMORIA DI GAVARDO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017077"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "723"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030158",
      "display" : "OSPEDALE DI LENO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017088"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "723"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030161",
      "display" : "PRESIDIO OSPEDALIERO DI SALO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017170"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "723"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030183",
      "display" : "OSPEDALE VILLA DEI COLLI DI LONATO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017092"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "723"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030184",
      "display" : "OSPEDALE DI MANERBIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017103"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "723"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030723",
      "display" : "ASST DEL GARDA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017067"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "723"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030154",
      "display" : "PRESIDIO OSPEDALIERO DI CHIARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017052"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "722"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030163",
      "display" : "PRESIDIO OSPEDALIERO DI ISEO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017085"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "722"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030722",
      "display" : "ASST DELLA FRANCIACORTA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017052"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "722"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030175",
      "display" : "CASA DI CURA S. CAMILLO - BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030176",
      "display" : "ISTITUTO CLINICO S. ANNA - BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030177",
      "display" : "CASA DI CURA VILLA GEMMA-GARDONE RIV",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017074"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030178",
      "display" : "IST.CLIN. CITTA' DI BRESCIA - BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030275",
      "display" : "ISTITUTO CLINICO S. ROCCO S.P.A. - OME",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017123"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030294",
      "display" : "CASA DI CURA DOMUS SALUTIS - BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030295",
      "display" : "FONDAZIONE POLIAMBULANZA - BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030348",
      "display" : "CASA DI CURA VILLA BARBARANO - SALO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017170"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030362",
      "display" : "RESIDENZA ANNI AZZURRI - REZZATO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017161"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030368",
      "display" : "C.TRO RIAB.E.SPALENZA-FOND.DON GNOCCHI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017166"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030369",
      "display" : "CENTRO MEDICO RICHIEDEI-PALAZZOLO S/O",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017133"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030408",
      "display" : "CENTRO CLINICO NEMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017081"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "326"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030932",
      "display" : "IRCCS CENTRO MEDICO DI LUMEZZANE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017096"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "932"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030942",
      "display" : "IRCCS S.GIOVANNI DI DIO-FBF- BRESCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030326"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "942"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030209",
      "display" : "OSPEDALE MAGGIORE - CREMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "019035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "726"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030215",
      "display" : "OSPEDALE S. MARTA - RIVOLTA D'ADDA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "019084"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "726"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030726",
      "display" : "ASST DI CREMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "019035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "726"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030273",
      "display" : "OSPEDALE OGLIO PO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "019021"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "724"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030724",
      "display" : "ASST DI CREMONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "019036"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "724"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030908",
      "display" : "OSPEDALE DI CREMONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "019036"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "724"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030227",
      "display" : "PRESIDIO OSPEDALIERO - ASOLA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "725"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030239",
      "display" : "OSP.CIVILE DESTRA SECCHIA-PIEVE CORIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020072"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "725"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030725",
      "display" : "ASST DI MANTOVA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020030"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "725"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030907",
      "display" : "OSPEDALE C. POMA - MANTOVA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020030"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "725"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030217",
      "display" : "CASA DI CURA ANCELLE DELLA CARITA'-CR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "019036"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "327"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030218",
      "display" : "CASA DI CURA S. CAMILLO - CREMONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "019036"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "327"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030219",
      "display" : "CASA DI CURA FIGLIE DI S.CAMILLO-CR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "019036"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "327"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030259",
      "display" : "CASA DI CURA S. CLEMENTE - MANTOVA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020030"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "327"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030353",
      "display" : "OSPEDALE CIVILE DI VOLTA MANTOVANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020070"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "327"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030355",
      "display" : "OSPEDALE DI SUZZARA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020065"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "327"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030357",
      "display" : "OSP. SAN PELLEGRINO - CASTIGLIONE D/S",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "327"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030933",
      "display" : "IRCCS CENTRO MEDICO DI CASTEL GOFFREDO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "020015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030327"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "933"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030190",
      "display" : "OSPEDALE CARLO MIRA-CASORATE PRIMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018034"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "727"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030191",
      "display" : "OSPEDALE S.MARTINO - MEDE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018088"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "727"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030192",
      "display" : "OSPEDALE SS.ANNUNZIATA - VARZI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018171"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "727"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030193",
      "display" : "OSPEDALE CIVILE - VIGEVANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018177"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "727"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030194",
      "display" : "OSPEDALE CIVILE - VOGHERA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018182"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "727"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030203",
      "display" : "OSPEDALE ASILO VITTORIA - MORTARA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018102"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "727"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030383",
      "display" : "NUOVO OSPEDALE DI BRONI E STRADELLA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018153"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "727"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030727",
      "display" : "ASST DI PAVIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "727"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "030197",
      "display" : "CASA DI CURA VILLA ESPERIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018073"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "328"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030198",
      "display" : "ISTITUTO CLINICO BEATO MATTEO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018177"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "328"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030201",
      "display" : "CASA DI CURA CITTADELLA SOCIALE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018113"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "328"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030202",
      "display" : "IST.DI CURA CITTA'DI PAVIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "328"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "030939",
      "display" : "FOND.IST.NEUROL.C.MONDINO-PAVIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "939"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030938",
      "display" : "IRCCS CENTRO MEDICO DI PAVIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "938"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030940",
      "display" : "IRCCS CENTRO MEDICO MONTESCANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018097"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "940"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "030924",
      "display" : "POLICLINICO S. MATTEO - PAVIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "comune",
          "valueCode" : "018110"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "030328"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "924"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "041001",
      "display" : "OSPEDALE CENTRALE DI BOLZANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "041002",
      "display" : "OSPEDALE AZIENDALE DI MERANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "041004",
      "display" : "OSPEDALE AZIENDALE DI BRESSANONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "041005",
      "display" : "OSPEDALE AZIENDALE DI BRUNICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "041006",
      "display" : "OSPEDALE DI BASE DI VIPITENO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021115"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "041007",
      "display" : "OSPEDALE DI BASE DI SAN CANDIDO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021077"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "041011",
      "display" : "OSPEDALE DI BASE DI SILANDRO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021093"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "041013",
      "display" : "MARIA Srl impresa sociale",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041014",
      "display" : "CASA DI CURA VILLA SANT'ANNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041015",
      "display" : "CASA DI CURA BONVICINI S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041017",
      "display" : "MELITTAKLINIK 1",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041026",
      "display" : "CASA DI CURA SALUS CENTER SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021099"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041028",
      "display" : "Centro di Chirurgia S.Anna",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041030",
      "display" : "DOLOMITI SPORTCLINIC SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021061"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041031",
      "display" : "Brixsana private clinic GmbH/srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041032",
      "display" : "CITY CLINIC SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041033",
      "display" : "MELITTAKLINIK 2",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "041034",
      "display" : "SANITAS BRUNICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "comune",
          "valueCode" : "021013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "041201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "042001",
      "display" : "OSPEDALE DI TRENTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022205"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "042004",
      "display" : "PRESIDIO OSPEDALIERO DI BORGO VALSUGANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "042005",
      "display" : "PRESIDIO OSPEDALIERO DI CLES",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022062"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "042006",
      "display" : "OSPEDALE DI ROVERETO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022161"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "042007",
      "display" : "PRESIDIO OSPEDALIERO DI TIONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022199"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "042010",
      "display" : "PRESIDIO OSPEDALIERO DI ARCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "042014",
      "display" : "PRESIDIO OSPEDALIERO DI CAVALESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "042015",
      "display" : "OSPEDALE SAN CAMILLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022205"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "042016",
      "display" : "KOS CARE SRL - U.O. OSP. S.PANCRAZIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "042018",
      "display" : "CASA DI CURA EREMO DI ARCO SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "042019",
      "display" : "CASA DI CURA REGINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "042020",
      "display" : "CASA DI CURA SOLATRIX",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022161"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "042022",
      "display" : "CASA DI CURA VILLA BIANCA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "comune",
          "valueCode" : "022205"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "042101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050149",
      "display" : "GVM CORTINA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "025016"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050501"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "501"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050501",
      "display" : "OSPEDALI ULSS 1 DOLOMITI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "025006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050501"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "501"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050072",
      "display" : "OSPEDALE DI MOTTA DI LIVENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "026049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050502"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "502"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050079",
      "display" : "OSPEDALE CLASSIFICATO SAN CAMILLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "026086"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050502"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "502"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050080",
      "display" : "CASA DI CURA PARK VILLA NAPOLEON",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "026063"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050502"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "502"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050081",
      "display" : "CASA DI CURA GIOVANNI XXIII",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "026044"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050502"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "502"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050140",
      "display" : "IRCSS MEDEA CONEGLIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "026021"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050502"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "502"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050502",
      "display" : "OSPEDALI DI TREVISO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "026086"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050502"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "502"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050097",
      "display" : "OSP. S.RAFFAELE ARCANG. FATEBENEFRATELLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050503"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "503"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050098",
      "display" : "FONDAZIONE VILLA SALUS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050503"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "503"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050099",
      "display" : "CASA DI CURA POLICLINICO SAN MARCO SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050503"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "503"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050503",
      "display" : "OSPEDALI AZIENDA ULSS N. 3 SERENISSIMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050503"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "503"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050951",
      "display" : "SAN CAMILLO IRCCS SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050503"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "503"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050100",
      "display" : "CASA DI CURA SILENO E ANNA RIZZOLA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "027033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050504"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "504"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050504",
      "display" : "OSPEDALE AZIENDA U.L.S.S. N.4",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "027033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050504"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "504"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050141",
      "display" : "CASA DI CURA CITTÀ DI ROVIGO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "029041"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050505"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "505"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050150",
      "display" : "Casa di Cura Santa Maria Maddalena",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "029033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050505"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "505"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050151",
      "display" : "Casa di Cura Madonna della Salute",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "029052"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050505"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "505"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050505",
      "display" : "OSPEDALI DI ROVIGO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "029041"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050505"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "505"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050901",
      "display" : "AZIENDA OSPEDALE - UNIVERSITA' PADOVA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050506"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050120",
      "display" : "CASA DI CURA DIAZ",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050506"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "506"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050121",
      "display" : "CASA DI CURA VILLA MARIA SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050506"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "506"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050122",
      "display" : "CASA DI CURA 'TRIESTE'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050506"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "506"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050123",
      "display" : "CASA DI CURA ABANO TERME POLISPEC. E TER",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "028001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050506"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "506"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050124",
      "display" : "CASA DI CURA PARCO DEI TIGLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "028089"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050506"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "506"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050506",
      "display" : "OSPEDALI EUGANEA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050506"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "506"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050952",
      "display" : "IOV",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050506"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "952"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050507",
      "display" : "OSPEDALI DI BASSANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "024012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050507"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "507"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050045",
      "display" : "CASA DI CURA ERETENIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050508"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "508"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050046",
      "display" : "CASA DI CURA VILLA BERICA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050508"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "508"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050047",
      "display" : "CASA DI CURA VILLA MARGHERITA KOS CARE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "024006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050508"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "508"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050508",
      "display" : "OSPEDALI DI VICENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050508"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "508"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050017",
      "display" : "OSPEDALE SACRO CUORE DON CALABRIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023052"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050509"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "509"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050018",
      "display" : "OSPEDALE CLASSIFICATO VILLA S. GIULIANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050509"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "509"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050019",
      "display" : "CASA DI CURA CENTRO RIABILIT VERONESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050509"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "509"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050021",
      "display" : "CASA DI CURA VILLA GARDA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023036"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050509"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "509"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050022",
      "display" : "OSPEDALE PEDERZOLI CASA DI CURA SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023059"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050509"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "509"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "050023",
      "display" : "CLINICA SAN FRANCESCO SPA - Casa di cura",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050509"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "509"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050025",
      "display" : "CASA DI CURA VILLA SANTA CHIARA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050509"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "509"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "050509",
      "display" : "OSPEDALI DI LEGNAGO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050509"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "509"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "050912",
      "display" : "AZ.OSP.UNIVERSITARIA INTEGRATA VERONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "050509"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "912"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060902",
      "display" : "CENTRO RIFERIMENTO ONCOLOGICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "093004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "902"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060040",
      "display" : "CASA DI CURA PRIVATA 'S.GIORGIO' SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "093033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "060041",
      "display" : "Presidio ospedaliero Santa Maria degli A",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "093033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060042",
      "display" : "Presidio ospedaliero San Vito al Tagliam",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "093041"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060002",
      "display" : "IST.DI MEDICINA FISICA E RIABILITAZIONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060011",
      "display" : "POLICLINICO CITTA` DI UDINE - CC PRIVATA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "060044",
      "display" : "PO 'Latisana e Palmanova'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "030070"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060045",
      "display" : "P.O. 'San Daniele del Friuli e Tolmezzo'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "030043"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060047",
      "display" : "PRESIDIO OSPEDALIERO 'S.M.M' DI UDINE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060029",
      "display" : "SANATORIO TRIESTINO S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "060033",
      "display" : "POLICLINICO TRIESTINO SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "060043",
      "display" : "PO 'Gorizia e Monfalcone'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "031007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060046",
      "display" : "Presidio Osp. Cattinara e Maggiore di Ts",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "060901",
      "display" : "I.R.C.C.S. BURLO GAROFOLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "060207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "070001",
      "display" : "PRESIDIO OSPEDALIERO UNIFICATO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "008055"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "070113",
      "display" : "SANT'ANNA Srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "008031"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "070016",
      "display" : "Casa di Cura San Michele - ENNE S.r.l.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "009002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "070211",
      "display" : "PRESIDIO PONENTE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "009056"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "070212",
      "display" : "PRESIDIO LEVANTE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "009056"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "070025",
      "display" : "E.O. OSPEDALI GALLIERA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "070051",
      "display" : "OSPEDALE EVANGELICO INTERNAZIONALE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "070065",
      "display" : "CASA DI CURA VILLA MONTALLEGRO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "070066",
      "display" : "VILLA SERENA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "070074",
      "display" : "ISTITUTO CARDIOVASCOLARE CAMOGLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "070301",
      "display" : "PRESIDIO OSPEDALIERO METROPOLITANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "070321",
      "display" : "IST. BIOMEDICAL S.p.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "070960",
      "display" : "FONDAZIONE SALVATORE MAUGERI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "070901",
      "display" : "IRCCS OSPEDALE POLICLINICO SAN MARTINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "070940",
      "display" : "IST.G.GASLINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "940"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "070039",
      "display" : "PRESIDIO OSPEDALIERO ASL4 CHIAVARESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010028"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "104"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "070069",
      "display" : "ICLAS s.r.l.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "010046"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "104"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "070058",
      "display" : "PRESIDIO OSPEDALIERO DEL LEVANTE LIGURE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "011015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "070070",
      "display" : "CASA DI CURA 'ALMA MATER'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "011015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "070114",
      "display" : "CENTRO RIABILITAZIONE DON CARLO GNOCCHI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "comune",
          "valueCode" : "011015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "070105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080004",
      "display" : "PRESIDIO UNICO PIACENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080203",
      "display" : "CASA DI CURA PRIVATA PIACENZA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080204",
      "display" : "CASA DI CURA PRIVATA S. ANTONINO S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080205",
      "display" : "CASA DI CURA S.GIACOMO S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "033036"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080101"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "101"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080902",
      "display" : "AZIENDA OSPEDALIERO-UNIVERSITARIA DI PAR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "902"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080013",
      "display" : "PRESIDIO OSPEDALIERO AZIENDALE (AUSL PAR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080206",
      "display" : "CASA DI CURA CITTA' DI PARMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080207",
      "display" : "HOSPITAL PICCOLE FIGLIE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080208",
      "display" : "VILLA MARIA LUIGIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080209",
      "display" : "CASA DI CURA VILLA IGEA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080210",
      "display" : "HOSPITAL VAL PARMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034018"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080253",
      "display" : "FONDAZIONE DON CARLO GNOCCHI ONLUS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080254",
      "display" : "CENTRO CARDINAL FERRARI S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "034015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080102"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "102"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080021",
      "display" : "PRESIDIO OSPEDALIERO PROVINCIALE DI REGG",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080211",
      "display" : "SALUS HOSPITAL (CASA DI CURA PRIVATA)",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080212",
      "display" : "CASA DI CURA PRIVATA POLISPECIALISTICA V",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080103"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "103"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080904",
      "display" : "AZIENDA OSPEDALIERO-UNIVERSITARIA DI MOD",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "904"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080031",
      "display" : "PRESIDIO OSPEDALIERO PROVINCIALE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "036005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "104"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080096",
      "display" : "NUOVO OSPEDALE CIVILE DI SASSUOLO S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "036040"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "104"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080213",
      "display" : "HESPERIA HOSPITAL MODENA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "104"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080214",
      "display" : "PROF. FOGLIANI CASA DI CURA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "104"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080215",
      "display" : "OSPEDALE PRIVATO VILLA IGEA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "104"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080216",
      "display" : "OSPEDALE PRIVATO ACCREDITATO VILLA ROSA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "104"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080218",
      "display" : "VILLA PINETA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "036030"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080104"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "104"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080053",
      "display" : "PRESIDIO OSPEDALIERO UNICO - AZIENDA DI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080153",
      "display" : "ISTITUTO DELLE SCIENZE NEUROLOGICHE DI B",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080219",
      "display" : "OSPEDALE PRIVATO ACCREDITATO VILLA CHIAR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080220",
      "display" : "CASA DI CURA PROF. NOBILI S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080221",
      "display" : "CASA DI CURA VILLA ERBOSA OSPEDALE PRIVA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080222",
      "display" : "OSPEDALE PRIVATO ACCREDITATO NIGRISOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080223",
      "display" : "OSPEDALE PRIVATO ACCREDITATO VILLA TORRI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080224",
      "display" : "OSPEDALE PRIVATO ACCREDITATO CASA DI CUR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080225",
      "display" : "CASA DI CURA MADRE FORTUNATA TONIOLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080226",
      "display" : "OSPEDALE PRIVATO VILLALBA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080227",
      "display" : "OSPEDALE PRIVATO ACCREDITATO VILLA BARUZ",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080228",
      "display" : "OSPEDALE PRIVATO ACCREDITATO VILLA BELLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080229",
      "display" : "OSPEDALE PRIVATO ACCREDITATO VILLA LAURA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080231",
      "display" : "OSPEDALE PRIVATO ACCREDITATO VILLA REGIN",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080255",
      "display" : "OSPEDALE PRIVATO SANTA VIOLA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080256",
      "display" : "CASA DI CURA EUGENIO GRUPPIONI OSPEDALE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037047"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "105"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080908",
      "display" : "IRCCS AZIENDA OSPEDALIERO-UNIVERSITARIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "908"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080960",
      "display" : "ISTITUTO ORTOPEDICO RIZZOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080105"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "960"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080044",
      "display" : "PRESIDIO OSPEDALIERO IMOLA - CASTEL S. P",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080106"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "106"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080045",
      "display" : "OSPEDALE MONTECATONE REHABILITATION INST",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "037032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080106"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "106"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "080909",
      "display" : "AZIENDA OSPEDALIERO-UNIVERSITARIA DI FER",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "909"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080068",
      "display" : "PRESIDIO OSPEDALIERO UNICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "038006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080235",
      "display" : "CASA DI CURA QUISISANA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080236",
      "display" : "CASA DI CURA SALUS S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080072",
      "display" : "OSPEDALE SANTA MARIA DELLE CROCI RAVEN",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080079",
      "display" : "OSPEDALE UMBERTO 1° LUGO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "039012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080082",
      "display" : "OSPEDALE DEGLI INFERMI  FAENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "039010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080085",
      "display" : "PRESIDIO OSPEDALIERO FORLI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080091",
      "display" : "PRESIDIO OSPEDALIERO CESENA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "040007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080095",
      "display" : "PRESIDIO OSPEDALIERO RIMINI-SANTARCANGEL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080100",
      "display" : "PRESIDIO OSPEDALIERO RICCIONE-CATTOLICA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "099013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "080237",
      "display" : "OSPEDALE PRIVATO DOMUS NOVA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080238",
      "display" : "CASA DI CURA SAN FRANCESCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080239",
      "display" : "VILLA MARIA CECILIA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "039009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080240",
      "display" : "OSPEDALE PRIVATO SAN PIER DAMIANO HOSPI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "039010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080242",
      "display" : "CASA DI CURA PRIVATA VILLA AZZURRA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "039015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080243",
      "display" : "OSPEDALE PRIVATO ACCREDITATO VILLA IGEA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080244",
      "display" : "VILLA SERENA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080245",
      "display" : "MALATESTA NOVELLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "040007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080246",
      "display" : "CASA DI CURA PRIVATA SAN LORENZINO S.P.A",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "040007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080247",
      "display" : "SOL ET SALUS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080249",
      "display" : "CASA DI CURA VILLA MARIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080250",
      "display" : "LUCE SUL MARE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "099001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080251",
      "display" : "VILLA SALUS S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080252",
      "display" : "CASA DI CURA PROF. E. MONTANARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "099011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "080921",
      "display" : "I.R.S.T. SRL IRCCS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "comune",
          "valueCode" : "040019"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "080114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "090904",
      "display" : "AZIENDA OSPEDALIERA MEYER",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "904"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090207",
      "display" : "CASA DI CURA S. RITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "047011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090210",
      "display" : "CASA DI CURA VILLA FIORITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "100005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090213",
      "display" : "CASA DI CURA VILLA DONATELLO SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048043"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090214",
      "display" : "CASA DI CURA VILLA CHERUBINI PROSPERIUS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090216",
      "display" : "KOS CARE S.R.L. VILLA DEI PINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090218",
      "display" : "IFCA SPA CASA DI CURA ULIVELLA E GLICINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090219",
      "display" : "VILLA MARIA TERESA HOSPITAL SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090229",
      "display" : "VILLA DELLE TERME SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090230",
      "display" : "CASA DI CURA VAL DI SIEVE SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090235",
      "display" : "CASA DI CURA LEONARDO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090240",
      "display" : "CASA DI CURA FRATE SOLE SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048052"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090243",
      "display" : "CENTRO DAY SURGERY MAURIZIO BUFALINI SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090245",
      "display" : "CASA DI CURA SAN PAOLO SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "047014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090606",
      "display" : "SPEDALI RIUNITI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "047014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090607",
      "display" : "OSPEDALE DELLA VALDINIEVOLE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "047012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090608",
      "display" : "NUOVO OSPEDALE DI PRATO S.STEFANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "100005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090627",
      "display" : "OSPEDALE DI BORGO SAN LORENZO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090629",
      "display" : "OSPEDALE FIORENTINO SUD-EST",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090632",
      "display" : "OSPEDALE FIORENTINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090642",
      "display" : "PRESIDIO OSPEDALIERO ASL 11 EMPOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090910",
      "display" : "FONDAZIONE DON CARLO GNOCCHI - ONLUS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "090903",
      "display" : "AZ. OSPEDALIERO - UNIVERSITARIA CAREGGI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "903"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090901",
      "display" : "AZIENDA OSPEDALIERO-UNIVERSITARIA PISANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090906",
      "display" : "FONDAZIONE STELLA MARIS - CALAMBRONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "090907",
      "display" : "FONDAZIONE CNR-RT G. MONASTERIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "9"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "090202",
      "display" : "CASA CURA S.CAMILLO FORTE DEI MARMI SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "046013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090203",
      "display" : "CASA DI CURA MD BARBANTINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "046033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090204",
      "display" : "C. DI CURA M.D. BARBANTINI SANTA CHIARA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090205",
      "display" : "CASA DI CURA S.ZITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090206",
      "display" : "CASA DI CURA VILLE DI NOZZANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090231",
      "display" : "CASA DI CURA SUORE DELL'ADDOLORATA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090233",
      "display" : "CASA DI CURA PRIVATA SAN ROSSORE S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090234",
      "display" : "CASA DI CURA VILLA TIRRENA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "049009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090241",
      "display" : "CEN.S. MARIA ALLA PINETA F. DON GNOCCHI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "045010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090601",
      "display" : "PRESIDIO OSPEDALIERO ZONA LUNIGIANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "045007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090602",
      "display" : "PRESIDIO OSPEDALIERO ZONA DELLE APUANE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "045003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090603",
      "display" : "PRESIDIO OSPEDALIERO VALLE DEL SERCHIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "046009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090604",
      "display" : "PRESIDIO OSPEDALIERO SAN LUCA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090609",
      "display" : "PRESIDIO OSPEDALIERO S.MARIA MADDALENA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "050039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090610",
      "display" : "PRESIDIO OSPEDALIERO FELICE LOTTI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "050029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090613",
      "display" : "OSPEDALE LIVORNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "049009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090614",
      "display" : "OSP. ZONA B.VAL DI CECINA VAL DI CORNIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "049012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090615",
      "display" : "OSPEDALE DI PORTOFERRAIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "049014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090640",
      "display" : "OSPEDALE VERSILIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "046005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090909",
      "display" : "AUXILIUM VITAE VOLTERRA SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "050039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "090902",
      "display" : "AZIENDA OSPEDALIERA UNIVERSITARIA SENESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "902"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090236",
      "display" : "CENTRO CHIRURGICO TOSCANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090237",
      "display" : "SAN GIUSEPPE HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090239",
      "display" : "RUGANI HOSPITAL SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "052016"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "090618",
      "display" : "OSPEDALE DEL CASENTINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "051004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090619",
      "display" : "OSPEDALE DELLA VALTIBERINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "051034"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090621",
      "display" : "OSPEDALE AREA ARETINA NORD",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090623",
      "display" : "OSPEDALE S.ANDREA MASSA MARITTIMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "053015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090624",
      "display" : "OSPEDALE DELLE COLLINE DELL'ALBEGNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "053018"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090625",
      "display" : "OSPEDALE CIVILE DI CASTEL DEL PIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "053004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090626",
      "display" : "OSPEDALE DELLA MISERICORDIA GROSSETO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "053011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090634",
      "display" : "SERVIZIO PSICHIATRICO DIAGNOSI E CURA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090637",
      "display" : "PRESIDIO OSPEDALIERO AMIATA SENESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "052001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090638",
      "display" : "OSPEDALE DELL'ALTA VAL D'ELSA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "052022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090639",
      "display" : "OSPEDALI RIUNITI DELLA VAL DI CHIANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "052015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090641",
      "display" : "OSPEDALE NUOVO VALDARNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "051026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090643",
      "display" : "NUOVO OSPEDALE VALDICHIANA S. MARGHERITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "051017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "090911",
      "display" : "CENTRO RIABILITAZIONE TERRANUOVA B. SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "comune",
          "valueCode" : "051026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "090203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "100701",
      "display" : "CASA DI CURA VILLA FIORITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "100702",
      "display" : "Istituto Clinico Porta Sole Casa di Cura",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "100703",
      "display" : "CLINICA LAMI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "100704",
      "display" : "CASA DI CURA LIOTTI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "100801",
      "display" : "PRESIDIO OSPEDALIERO ALTO TEVERE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "100803",
      "display" : "PRESIDIO OSPEDALIERO UNIFICATO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "100810",
      "display" : "PRESIDIO OSPEDALIERO GUBBIO E G.TADINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "100901",
      "display" : "AZIENDA OSPEDALIERA DI PERUGIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "100602",
      "display" : "SERVIZIO PSICHIATRICO DIAGNOSI E CURA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "100705",
      "display" : "CASA DI CURA VILLA AURORA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054018"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "100805",
      "display" : "POLO OSPEDALIERO SPOLETO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "100806",
      "display" : "SANTA MARIA DELLA STELLA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "055023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "100807",
      "display" : "PRESIDIO OSPEDALIERO NARNI AMELIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "055022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "100809",
      "display" : "POLO OSPEDALIERO FOLIGNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "054018"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "100902",
      "display" : "AZIENDA OSPEDALIERA 'S. MARIA' - TERNI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "100202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "902"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "110001",
      "display" : "PRESIDIO OSPEDALIERO AST1",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "041013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "110002",
      "display" : "PRESIDIO OSPEDALIERO AST2",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "042017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "302"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "110037",
      "display" : "CASA DI CURA VILLA SILVIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "042045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "302"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "110039",
      "display" : "KOS CARE SRL - CLINICA VILLA JOLANDA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "042023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "302"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "110076",
      "display" : "CDC MARCHE - RETE IMPRESA AST2",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "042002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "302"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "110905",
      "display" : "AZIENDA OSP. UNIVERSITARIA DELLE MARCHE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "042002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "905"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "110995",
      "display" : "CENTRO CLINICO NEMO ANCONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "042002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "905"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "110921",
      "display" : "INRCA MARCHE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "042002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "921"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "110003",
      "display" : "PRESIDIO OSPEDALIERO AST3",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "043023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110303"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "303"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "110077",
      "display" : "CDC MARCHE - RETE IMPRESA AST3",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "043013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110303"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "303"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "110079",
      "display" : "CENTRO OSPEDALIERO SANTO STEFANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "043043"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110303"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "303"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "110004",
      "display" : "PRESIDIO OSPEDALIERO AST4",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "109006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110304"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "304"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "110078",
      "display" : "CDC MARCHE - RETE IMPRESA AST4/5",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "109006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110304"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "304"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "110005",
      "display" : "PRESIDIO OSPEDALIERO AST5",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "044007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110305"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "305"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "110071",
      "display" : "CASA DI CURA 'SAN GIUSEPPE'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "comune",
          "valueCode" : "044007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "110305"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "305"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120002",
      "display" : "OSPEDALE DI ACQUAPENDENTE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "056001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120003",
      "display" : "OSPEDALE DI CIVITACASTELLANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "056021"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120007",
      "display" : "OSPEDALE DI TARQUINIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "056050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120014",
      "display" : "NUOVA S.TERESA DEL BAMBIN GESU`",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120015",
      "display" : "VILLA IMMACOLATA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120271",
      "display" : "POLO OSPEDALIERO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120304",
      "display" : "CASA DI CURA NEPI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "056039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120109"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "109"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120019",
      "display" : "POLO OSPEDALIERO UNICO INTEGRATO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "057059"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120110"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "110"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120200",
      "display" : "PRESIDIO OSPEDALIERO NORD",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120111"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "111"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120204",
      "display" : "PRESIDIO OSPEDALIERO CENTRO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120111"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "111"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120206",
      "display" : "PRESIDIO OSPEDALIERO SUD",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120111"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "111"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120209",
      "display" : "CASA DEL SOLE CLINICA TOMMASO COSTA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120111"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "111"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120212",
      "display" : "ISTIT CHIR ORTOP TRAUMATOLOGICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120111"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "111"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120213",
      "display" : "CASA DI CURA SAN MARCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120111"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "111"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120214",
      "display" : "ISTITUTO FISIOTERAPICO C.FRANCESCHINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120111"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "111"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120215",
      "display" : "CASA DI CURA CITTA` DI APRILIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120111"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "111"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120278",
      "display" : "CASA DI CURA 'VILLA SILVANA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "059001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120111"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "111"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120216",
      "display" : "PO UNIFICATO :: FROSINONE - ALATRI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060038"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120226",
      "display" : "OSPEDALE CIVILE S.S.TRINITA` N.SEDE SORA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060074"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120228",
      "display" : "OSPEDALE S. SCOLASTICA CASSINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060019"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120230",
      "display" : "CASA DI CURA PRIV. S. ANNA S.R.L CASSINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060019"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120235",
      "display" : "CASA DI CURA PRIV. VILLA SERENA CASSINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060019"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120236",
      "display" : "CASA DI CURA PRIV. SANTA TERESA ISOLA L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060043"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120277",
      "display" : "CASA CURA PRIVATA'SAN RAFFAELE' CASSINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060019"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120279",
      "display" : "I.N.I. DIV.DISTACCAT CITTA` BIANCA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060085"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120291",
      "display" : "CASA DI CURA SRL 'SORA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "060074"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120919",
      "display" : "AZIENDA OSPEDALIERA SANT`ANDREA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "919"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120902",
      "display" : "AZIENDA OSP. S.GIOVANNI/ADDOLORATA ROMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "902"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120908",
      "display" : "ISTITUTI FISIOTERAPICI OSPITALIERI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "908"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120904",
      "display" : "OSPEDALE PEDIATRICO BAMBINO GESU`",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "904"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120905",
      "display" : "POLICLINICO A. GEMELLI E C.I.C.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "905"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120906",
      "display" : "POLICLINICO U. I",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "906"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120026",
      "display" : "POLO OSPEDALIERO SANTO SPIRITO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120030",
      "display" : "OSPEDALE REGIONALE OFTALMICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120071",
      "display" : "OSPEDALE SAN PIETRO - FBF",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120073",
      "display" : "OSPEDALE SAN CARLO DI NANCY",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120074",
      "display" : "OSP. GEN. DI ZONA 'CRISTO RE'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120079",
      "display" : "CASA DI CURA VILLA DOMELIA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120087",
      "display" : "CASA DI CURA POLICLINICO ITALIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120090",
      "display" : "CASA DI CURA VILLA BENEDETTA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120092",
      "display" : "CASA DI CURA SANATRIX",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120098",
      "display" : "CASA DI CURA N.SIGNORA DELLA MERCEDE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120105",
      "display" : "CASA DI CURA MARCO POLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120108",
      "display" : "CASA DI CURA ASSUNZIONE DI MARIA SS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120114",
      "display" : "CASA DI CURA QUISISANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120115",
      "display" : "CASA DI CURA SANTA FAMIGLIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120118",
      "display" : "CASA DI CURA VILLA DEL ROSARIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120119",
      "display" : "CASA DI CURA VILLA MAFALDA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120120",
      "display" : "CASA DI CURA SAN DOMENICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120123",
      "display" : "CASA DI CURA VILLA STUART",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120129",
      "display" : "CASA DI CURA VILLA MARGHERITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120141",
      "display" : "CASA DI CURA SANTO VOLTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120144",
      "display" : "CLINICA VALLE GIULIA SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120146",
      "display" : "CASA DI CURA S.RITA DA CASCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120150",
      "display" : "CASA DI CURA PIO XI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120158",
      "display" : "CASA DI CURA PAIDEIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120159",
      "display" : "CASA DI CURA NUOVA VILLA CLAUDIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120163",
      "display" : "CASA DI CURA SAN FELICIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120172",
      "display" : "CASA DI CURA MATER DEI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120180",
      "display" : "AURELIA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120254",
      "display" : "ARS MEDICA SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120256",
      "display" : "ARSBIOMEDICA DELLA SAF GESTIONI SANITARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120257",
      "display" : "CASA DI CURA S. MARIA DI LEUCA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120264",
      "display" : "CASA DI CURA VILLA VERDE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120285",
      "display" : "PRESIDIO OSPEDALIERO SAN FILIPPO NERI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120288",
      "display" : "VILLA TIBERIA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120293",
      "display" : "CASA DI CURA VILLA AURORA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120296",
      "display" : "CASA DI CURA VILLA BETANIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120297",
      "display" : "CLINICA FENICE PARIOLI srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120298",
      "display" : "CASA DI CURA SALUS INFIRMORUM",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120300",
      "display" : "CASA DI CURA VILLA VALERIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120301",
      "display" : "C.di C. AUXOLOGICO ROMA - BUON PASTORE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120303",
      "display" : "VILLA SALARIA HOSPITAL S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120305",
      "display" : "Ospedale Fatebenefatelli-Isola Tiberina",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120306",
      "display" : "CASA DI CURA S. DOMENICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120328",
      "display" : "CASA DI CURA PRIVATA `DON CARLO GNOCCHI`",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120911",
      "display" : "I.D.I. - FONDAZIONE LUIGI MARIA MONTI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "120913",
      "display" : "IRCCS - FONDAZIONE G.B. BIETTI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "120920",
      "display" : "AZ. OSP. UNIV. POLICLINICO TOR VERGATA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "920"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120909",
      "display" : "I.R.C.C.S. S. LUCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "909"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "120915",
      "display" : "POLICL. UNIV. CAMPUS BIO MEDICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "915"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "120066",
      "display" : "OSPEDALE S. EUGENIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120076",
      "display" : "MADRE GIUSEPPINA VANNINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120085",
      "display" : "MADONNA DELLA FIDUCIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120089",
      "display" : "N.C.L. ISTITUTO DI NEUROSCIENZE S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120104",
      "display" : "CASA DI CURA VILLA FULVIA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120132",
      "display" : "CASA DI CURA GUARNIERI SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120135",
      "display" : "C.D.C. MATER MISERICORDIAE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120139",
      "display" : "CLINICA LATINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120143",
      "display" : "CONCORDIA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120157",
      "display" : "C.D.C. FABIA MATER",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120166",
      "display" : "CASA DI CURA NUOVA ITOR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120169",
      "display" : "NUOVA CLINICA ANNUNZIATELLA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120245",
      "display" : "CENTRO RESIDENZIALE MEDICA GROUP",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120249",
      "display" : "C.D.C. VILLA ANNA MARIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120265",
      "display" : "ROME AMERICAN HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120267",
      "display" : "OSPEDALE SANDRO PERTINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120290",
      "display" : "CASA DI CURA KAROL WOJTYLA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120294",
      "display" : "POLICLINICO CASILINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120901",
      "display" : "AZ.OSP.SAN CAMILLO-FORLANINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120918",
      "display" : "INMI 'L.SPALLANZANI' - IRCCS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "918"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120910",
      "display" : "IRCCS SAN RAFFAELE PISANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "910"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120061",
      "display" : "OSPEDALE G. B. GRASSI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120065",
      "display" : "CENTRO PARAPLEGICI OSTIA ' Gennaro Di Ro",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120075",
      "display" : "OSPEDALE ISRAELITICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120113",
      "display" : "CASA DI CURA VILLA PIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120130",
      "display" : "CASA DI CURA VILLA SANDRA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120133",
      "display" : "CASA DI CURA SALVATOR MUNDI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120138",
      "display" : "OSPEDALE SAN GIOVANNI BATTISTA-ACISMOM",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "120171",
      "display" : "CASA DI CURA CITTA` DI ROMA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120173",
      "display" : "EUROPEAN HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120191",
      "display" : "CASA DI CURA MERRY HOUSE/C.GERIATRICO RO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120262",
      "display" : "CASA DI CURA VILLA MARIA IMMACOLATA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120283",
      "display" : "C. DI C. 'ISTITUTO CLINICO CARDIOLOGICO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120295",
      "display" : "POLICLINICO LUIGI DI LIEGRO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120606",
      "display" : "CASA DI CURA S. RAFFAELE PORTUENSE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120045",
      "display" : "OSPEDALE SAN PAOLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120059",
      "display" : "OSPEDALE PADRE PIO DI BRACCIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120140",
      "display" : "CASA DI CURA SILIGATO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120046",
      "display" : "OSPEDALE L.PARODI DELFINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058034"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120049",
      "display" : "OSPEDALE SS. GONFALONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058065"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120051",
      "display" : "OSPEDALE CIVILE CONIUGI BERNARDINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058074"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120052",
      "display" : "OSPEDALE A. ANGELUCCI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058103"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120053",
      "display" : "OSPEDALE S. GIOVANNI EVANGELISTA(TIVOLI)",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058104"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120088",
      "display" : "I.N.I. Srl Divisione Medicus Hotel",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058104"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120199",
      "display" : "I.N.I. Srl Divisione Villa Dante",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058047"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120284",
      "display" : "Nomentana Hospital srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058122"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120286",
      "display" : "Casa di Cura Villa Luana",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058078"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120043",
      "display" : "OSP. ANZIO-NETTUNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120047",
      "display" : "OSP. S.SEBASTIANO FRASCATI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120048",
      "display" : "OSP. S.GIUSEPPE MARINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058057"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120054",
      "display" : "OSP.'PAOLO COLOMBO' VELLETRI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058111"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120082",
      "display" : "VILLA DELLE QUERCE-POLIGEST",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058070"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120096",
      "display" : "C.D.C. MADONNA DELLE GRAZIE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058111"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120122",
      "display" : "C.D.C. SAN RAFFAELE ROCCA DI PAPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058086"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120134",
      "display" : "CASA DI CURA S.ANNA POMEZIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058079"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120176",
      "display" : "C.D.C. I.N.I. SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058046"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120280",
      "display" : "C.d.C San Raffaele Montecompatri",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120289",
      "display" : "VILLA DEI PINI ASA srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "120292",
      "display" : "Ospedale dei Castelli",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "120302",
      "display" : "OSPEDALE REGINA APOSTOLORUM",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "comune",
          "valueCode" : "058003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "120206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "130001",
      "display" : "P.O.SAN SALVATORE L'AQUILA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130002",
      "display" : "PO SULMONA ' DELL' ANNUNZIATA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066098"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130003",
      "display" : "PO AVEZZANO 'S. FILIPPO E NICOLA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130005",
      "display" : "PRESIDIO OSPEDALIERO CASTEL DI SANGRO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066028"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130006",
      "display" : "PO TAGLIACOZZO ' UMBERTO I'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066099"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130010",
      "display" : "CASA DI CURA 'DI LORENZO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130012",
      "display" : "CASA DI CURA L'IMMACOLATA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130013",
      "display" : "CASA DI CURA 'S RAFFAELE SPA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066098"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130039",
      "display" : "CASA DI CURA I.N.I. CANISTRO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130040",
      "display" : "CASA DI CURA PRIVATA VILLA LETIZIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130041",
      "display" : "NOVA SALUS SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "066102"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130026",
      "display" : "P.O. CLINICIZZ. 'SS. ANNUNZIATA' CHIETI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130028",
      "display" : "P.O. LANCIANO 'RENZETTI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "069046"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130029",
      "display" : "P.O. VASTO 'S. PIO DA PIETRALCINA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "069099"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130030",
      "display" : "P.O. ATESSA 'SAN CAMILLO DE LELLIS'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "069005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130032",
      "display" : "P.O. ORTONA 'G. BERNABEO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "069058"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130035",
      "display" : "CASA DI CURA PRIVATA 'DOTT. SPATOCCO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130042",
      "display" : "CASA DI CURA S. FRANCESCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "069099"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130018",
      "display" : "P.O. 'SPIRITO SANTO' PESCARA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130019",
      "display" : "P.O. S. MASSIMO di PENNE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "068027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130020",
      "display" : "P.O.'S.S. TRINITA'' POPOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "068033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130022",
      "display" : "CASA DI CURA PIERANGELI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130024",
      "display" : "CASA di CURA VILLA SERENA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "068012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "130014",
      "display" : "OSPEDALE MAZZINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "067041"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130015",
      "display" : "OSPEDALE MARIA S.S. DELLO SPLENDORE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "067025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130016",
      "display" : "OSPEDALE SAN LIBERATORE DI ATRI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "067004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "130017",
      "display" : "OSPEDALE-VAL VIBRATA SANT'OMERO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "comune",
          "valueCode" : "067039"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "130204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "140001",
      "display" : "PRESIDIO OSPEDALIERO 'A.CARDARELLI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "comune",
          "valueCode" : "070006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "140201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "140002",
      "display" : "PLESSO OSPEDALIERO 'S TIMOTEO- TERMOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "comune",
          "valueCode" : "070078"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "140201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "140003",
      "display" : "COMPLESSO OSPEDALIERO ISERNIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "comune",
          "valueCode" : "094023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "140201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "140004",
      "display" : "CASA DI CURA VILLA MARIA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "comune",
          "valueCode" : "070006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "140201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "140005",
      "display" : "CASA DI CURA PRIVATA VILLA ESTHER s.r.l.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "comune",
          "valueCode" : "070003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "140201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "140007",
      "display" : "GEMELLI MOLISE S.PA. - CAMPOBASSO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "comune",
          "valueCode" : "070006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "140201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "9"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "140008",
      "display" : "GEA MEDICA IST. EUROPEO di RIABILITAZION",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "comune",
          "valueCode" : "094023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "140201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "140911",
      "display" : "NEUROMED I.R.C.C.S.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "comune",
          "valueCode" : "094038"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "140201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "150140",
      "display" : "OSPEDALE ARIANO IRPINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150143",
      "display" : "Pineta Grande SpA - CdiC Villa Esther",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150144",
      "display" : "CASA DI CURA VILLA MARIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150145",
      "display" : "CASA DI CURA S.RITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150146",
      "display" : "CASA DI CURA VILLA MARIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150148",
      "display" : "CASA DI CURA MONTEVERGINE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150149",
      "display" : "CASA DI CURA VILLA DEI PLATANI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150150",
      "display" : "OSPEDALE S.ANGELO DEI LOMBARDI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064092"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150449",
      "display" : "Casa di Cura Privata Villa Dei Pini SpA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150905",
      "display" : "AZIENDA OSPEDALIERA S. G. MOSCATI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "905"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150032",
      "display" : "OSP.SACRO CUORE DI GESU`FATEBENEFRATELLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "062008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "150033",
      "display" : "CASA DI CURA GE.P.O.S. SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "062074"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150034",
      "display" : "CASA DI CURA NUOVA CLINICA S.RITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "062008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150035",
      "display" : "CASA DI CURA SAN FRANCESCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "062074"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150350",
      "display" : "C.M.R. S.P.A.- CENTRO MED.DIAGN.E RIAB.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "062070"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150371",
      "display" : "KOS CARE s.r.l.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "062008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150911",
      "display" : "Istituti Clinici Scient. Maugeri s.p.a",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "062074"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "150906",
      "display" : "AZIENDA OSPEDALE `AO SAN PIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "062008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "906"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150907",
      "display" : "A.O. SANT'ANNA E SAN SEBASTIANO CASERTA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "907"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150004",
      "display" : "OSPEDALE SAN GIUSEPPE E MELORIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061083"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150010",
      "display" : "PRESIDIO OSPEDALIERO 'SAN ROCCO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061088"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150013",
      "display" : "PRESIDIO OSPEDALIERO S.G.MOSCATI AVERSA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150014",
      "display" : "CLINICA SANT`ANNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150016",
      "display" : "VILLA DEL SOLE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150017",
      "display" : "CASA DI CURA VILLA FIORITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150018",
      "display" : "CASA DI CURA SAN PAOLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150019",
      "display" : "CASA DI CURA 'VILLA FIORITA' SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150020",
      "display" : "CLINICA SAN MICHELE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150021",
      "display" : "CASA DI CURA PINETA GRANDE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150022",
      "display" : "MINERVA S.P.A. SANTA MARIA DELLA SALUTE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061083"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150023",
      "display" : "VILLA DEI PINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061057"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150024",
      "display" : "CASA DI CURA VILLA ORTENSIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150025",
      "display" : "VILLA DEGLI ULIVI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150028",
      "display" : "VILLA DELLE MAGNOLIE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061026"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150437",
      "display" : "PRESIDIO OSPEDALIERO MADDALONI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150438",
      "display" : "PRESIDIO OSPEDALIERO MARCIANISE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150439",
      "display" : "PRESIDIO OSPEDALIERO S.FELICE A CANCELLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061075"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150440",
      "display" : "PRESIDIO OSPEDALIERO PIEDIMONTE MATESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "061057"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150902",
      "display" : "A.O.R.N. SANTOBONO-PAUSILIPON",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "902"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150909",
      "display" : "A.O.U. 'FEDERICO II' DI NAPOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "909"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150073",
      "display" : "CASA DI CURA OSPEDALE FATEBENEFRATELLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "150075",
      "display" : "CASA DI CURA OSP. INTERNAZIONALE srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150078",
      "display" : "ALMA MATER S.p.A. 'Villa Camaldoli' SpA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150079",
      "display" : "CASA DI CURA VILLA ANGELA srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150081",
      "display" : "CASA DI CURA CLINIC CENTER SpA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150088",
      "display" : "HERMITAGE CAPODIMONTE SpA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150092",
      "display" : "CASA DI CURA VILLA DELLE QUERCE SpA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150093",
      "display" : "CASA DI CURA RUESCH SpA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150094",
      "display" : "CLINICA VESUVIO srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150095",
      "display" : "CLINICA MEDITERRANEA SpA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150099",
      "display" : "CLINICA SANTA PATRIZIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150104",
      "display" : "CASA DI CURA VILLA CINZIA srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150106",
      "display" : "CLINICA PINETA GRANDE SpA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150109",
      "display" : "CLINICA SANATRIX SpA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150196",
      "display" : "FONDAZIONE EVANGELICA BETANIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "150442",
      "display" : "PRESIDIO OSPEDALIERO OSPEDALE DEL MARE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150443",
      "display" : "P.O. SAN PAOLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150444",
      "display" : "P.O. SAN GIOVANNI BOSCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150445",
      "display" : "P.O. dei PELLEGRINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150446",
      "display" : "PO SANTA MARIA DI LORETO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150901",
      "display" : "AZIENDA OSPEDALIERA 'A. CARDARELLI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150903",
      "display" : "Azienda Ospedaliera dei Colli",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "903"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150908",
      "display" : "AZIENDA OSPEDALIERA UNIVERSITARIA UNICAM",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "908"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150910",
      "display" : "ISTITUTO NAZIONALE TUMORI DI NAPOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "910"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150057",
      "display" : "OSPEDALE CIVILE S. GIOVANNI DI DIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063032"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150058",
      "display" : "OSPEDALE SAN GIULIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063034"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150070",
      "display" : "OSPEDALE RIZZOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063038"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150084",
      "display" : "CASA DI CURA VILLA DEI FIORI SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150097",
      "display" : "CASA DI CURA VILLA MAIONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063087"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150101",
      "display" : "CASA DI CURA 'CLINICA S.ANTIMO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063020"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150116",
      "display" : "CASA DI CURA VILLA DEI FIORI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150118",
      "display" : "ISTITUTO DI CURA MARIA SS.DELLA PIETA`",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "150189",
      "display" : "OSP.CIV. GAETANINA SCOTTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063061"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150191",
      "display" : "OSPEDALE S.M.DELLE GRAZIE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063060"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150082",
      "display" : "CASA DI CURA ' LA MADONNINA ' SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063066"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150100",
      "display" : "CASA DI CURA ' N.S. DI LOURDES ' SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063092"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150102",
      "display" : "CASA DI CURA S. MARIA LA BRUNA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063084"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150105",
      "display" : "CASA DI CURA VILLA STABIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150108",
      "display" : "CASA DI CURA CARDIOMED S.p.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150110",
      "display" : "CASA DI CURA MARIA ROSARIA SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063058"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150111",
      "display" : "STAZIONE CLIMATICA BIANCHI srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063059"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150113",
      "display" : "CASA DI SALUTE S.LUCIA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063068"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150114",
      "display" : "CASA DI CURA A.GRIMALDI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063067"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150117",
      "display" : "IOS - EX CASA DI CURA ' MELUCCIO' SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063057"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150121",
      "display" : "IOS - EX CLINICA ' S. FELICE' SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063057"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150192",
      "display" : "CASA DI CURA S.MARIA DEL POZZO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063079"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150416",
      "display" : "OSPEDALI RIUNITI AREA STABIESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150417",
      "display" : "OSPEDALI RIUNITI PENISOLA SORRENTINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063080"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150436",
      "display" : "OSPEDALI RIUNITI AREA NOLANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150447",
      "display" : "P.O. TORRE DEL GRECO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063084"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150448",
      "display" : "P.O. BOSCOTRECASE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "063009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150904",
      "display" : "A.O.OO.RR.S.GIOVANNI DI DIO E RUGGI D`AR",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "904"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150154",
      "display" : "DEA UMBERTO I NOCERA INFERIORE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150158",
      "display" : "P.O. S. FRANCESCO D ASSISI OLIVETO CITRA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065083"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150160",
      "display" : "PRESIDIO OSPEDALIERO LUIGI CURTO- POLLA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065097"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150161",
      "display" : "PRESIDIO OSPEDALIERO 'IMMACOLATA' SAPRI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065134"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150162",
      "display" : "DEA EBOLI BATTIPAGLIA ROCCADASPIDE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150163",
      "display" : "P.O. MARTIRI DI VILLA MALTA SARNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065135"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150165",
      "display" : "DEA VALLO DELLA LUCANIA-AGROPOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065154"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "150167",
      "display" : "HYPPOCRATICA SPA CDC VILLA DEL SOLE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150170",
      "display" : "ICM-Istituto Clinico Mediterraneo S.p.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150171",
      "display" : "LA QUIETE - S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065090"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150173",
      "display" : "CASA DI CURA PRIVATA SALUS S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150175",
      "display" : "Campolongo Hospital S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150176",
      "display" : "'CASA DI CURA PROF.DOTT. LUIGI COBELLIS'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065154"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150177",
      "display" : "CASA DI CURA TORTORELLA SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150178",
      "display" : "VILLA CHIARUGI SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "150420",
      "display" : "VILLA SILVIA 'G.F.MONTESANO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "comune",
          "valueCode" : "065108"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "150207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160101",
      "display" : "CASA DI CURA 'SALUS' - BRINDISI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160106"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "106"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160151",
      "display" : "IRCCS 'E.MEDEA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160106"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "106"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "160161",
      "display" : "OSPEDALE OSTUNI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "074012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160106"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "106"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160162",
      "display" : "OSPEDALE FRANCAVILLA FONTANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "074008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160106"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "106"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160170",
      "display" : "OSPEDALE BRINDISI 'PERRINO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160106"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "106"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160074",
      "display" : "OSPEDALE MANDURIA 'GIANNUZZI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160075",
      "display" : "OSPEDALE CIVILE MARTINA FRANCA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160111",
      "display" : "CASA DI CURA BERNARDINI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160112",
      "display" : "CASA DI CURA D'AMORE S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160114",
      "display" : "CASA DI CURA SAN CAMILLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160115",
      "display" : "CASA DI CURA SANTA RITA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160116",
      "display" : "CASA DI CURA VILLA VERDE S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160141",
      "display" : "CASA DI CURA VILLA BIANCA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160146",
      "display" : "CENTRO MEDICO RIABILITAZIONE ICS MAUGERI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160149",
      "display" : "FONDAZIONE CITTADELLA DELLA CARITA`",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160168",
      "display" : "OSPEDALE CASTELLANETA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160172",
      "display" : "PRESIDIO OSPEDALERO CENTRALE TARANTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160112"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "112"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160174",
      "display" : "OSPEDALE ANDRIA - 'L. BONOMO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "110001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160113"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "113"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160177",
      "display" : "OSPEDALE BARLETTA - 'MONS. R. DIMICCOLI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "110002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160113"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "113"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160178",
      "display" : "OSPEDALE BISCEGLIE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "110003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160113"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "113"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160180",
      "display" : "UNIVERSO SALUTE OSP. DON UVA - BISCEGLIE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "110003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160113"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "113"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160907",
      "display" : "AO UNIV. CONS. POLICLINICO BARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "907"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160078",
      "display" : "EE OSPEDALE REGIONALE 'F. MIULLI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "160087",
      "display" : "CASA DI CURA SANTA MARIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160098",
      "display" : "CASA DI CURA - VILLA LUCIA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072019"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160100",
      "display" : "CASA DI CURA PRIVATA MONTE IMPERATORE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072031"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160140",
      "display" : "ANTHEA HOSPITAL S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160147",
      "display" : "CASA DI CURA C.B.H. MATER DEI HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160157",
      "display" : "OSPEDALE DELLA MURGIA 'F. PERINEI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160158",
      "display" : "OSPEDALE BARI 'SAN PAOLO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160159",
      "display" : "OSPEDALE MONOPOLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072030"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160160",
      "display" : "OSPEDALE PUTIGNANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072036"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160169",
      "display" : "OSPEDALE BARI 'DI VENERE' - TRIGGIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "114"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160906",
      "display" : "ICS MAUGERI SPA SOCIETA' BENEFIT",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072016"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "906"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "160902",
      "display" : "IRCCS 'SAVERIO DE BELLIS'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "902"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160901",
      "display" : "ISTITUTO TUMORI GIOVANNI PAOLO II",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160114"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160910",
      "display" : "AO UNIV. 'OO RR FOGGIA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "910"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160047",
      "display" : "OSPEDALE CERIGNOLA 'G.TATARELLA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071020"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "115"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160102",
      "display" : "CASA DI CURA PROF. BRODETTI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "115"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160105",
      "display" : "CASA DI CURA LEONARDO DE LUCA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "115"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160106",
      "display" : "CASA DI CURA 'S.MICHELE' gest. Brodetti",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "115"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160125",
      "display" : "CASA DI CURA UNIVERSO SALUTE - DON UVA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "115"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160163",
      "display" : "OSPEDALE SAN SEVERO - TERESA MASSELLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "115"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160164",
      "display" : "OSPEDALE MANFREDONIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "115"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160181",
      "display" : "CASE CURA RIUNITE VILLA SERENA-S. FRANCE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "115"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160905",
      "display" : "OSPEDALE CASA SOLLIEVO DELLA SOFFERENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "071046"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160115"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "905"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.3"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico), in Lombardia Pubblico"
        }
      ]
    },
    {
      "code" : "160062",
      "display" : "OSPEDALE GALATINA 'S. CATERINA NOVELLA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160063",
      "display" : "OSPEDALE GALLIPOLI 'SACRO CUORE DI GESU'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075031"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160080",
      "display" : "OSPEDALE REGIONALE EE 'G. PANICO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075088"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "160107",
      "display" : "CASA DI CURA 'PROF. PETRUCCIANI' S.r.l.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160108",
      "display" : "CASA DI CURA VILLA BIANCA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160109",
      "display" : "CASA DI CURA VILLA VERDE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160110",
      "display" : "CASA DI CURA SAN FRANCESCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160150",
      "display" : "CASA DI CURA CITTA' DI LECCE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160152",
      "display" : "CASA DI CURA RIABILITATIVA EUROITALIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075016"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "160165",
      "display" : "OSPEDALE COPERTINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075022"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160166",
      "display" : "OSPEDALE SCORRANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075073"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160167",
      "display" : "OSPEDALE CASARANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075016"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "160171",
      "display" : "OSPEDALE LECCE - 'V FAZZI' (SAN CESARIO)",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "160116"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "116"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "170901",
      "display" : "AZIENDA OSPEDALIERA REGIONALE 'S. CARLO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "076063"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "901"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "170032",
      "display" : "Fondazione Don Carlo Gnocchi - Onlus",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "076002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "170034",
      "display" : "LUNGODEGENZA RIABILITATIVA CHIAROMONTE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "076028"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "170035",
      "display" : "LUNGODEGENZA E RIABILITAZIONE VENOSA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "076095"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "170036",
      "display" : "LUNGODEGENZA RIABILITATIVA LAURIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "076042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "170037",
      "display" : "UNIVERSO SALUTE BASILICATA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "076063"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "170910",
      "display" : "C.R.O.B. - I.R.C.C.S.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "076066"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "910"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "170010",
      "display" : "PRESIDIO DISTRETTUALE STIGLIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "077027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "170011",
      "display" : "PRESIDIO OSPEDALIERO - MATERA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "077014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "170012",
      "display" : "PRESIDIO DISTRETTUALE TRICARICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "comune",
          "valueCode" : "077028"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "170202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180001",
      "display" : "IGRECO Ospedali Riuniti ex La Madonnina",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180002",
      "display" : "IGRECO Osp. Riuniti Madonna della Catena",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180003",
      "display" : "IGRECO Ospedali Riuniti ex Sacro Cuore",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180006",
      "display" : "OSPEDALE CIVILE FERRARI - CASTROVILLARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180008",
      "display" : "P.O. PRAIA A MARE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078101"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180010",
      "display" : "OSPEDALE SPOKE ROSSANO-CORIGLIANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078157"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180011",
      "display" : "P.O.BEATO ANGELICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180012",
      "display" : "Ospedale Spoke Cetraro-Paola",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078040"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180015",
      "display" : "OSPEDALE CIVILE SGF",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078119"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180016",
      "display" : "OSPEDALE GUDO CHIDICHIMO TREBISACCE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078150"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180019",
      "display" : "CASA DI CURA VILLA DEL SOLE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180025",
      "display" : "CASA DI CURA TRICARICO ROSANO SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180027",
      "display" : "CASA DI CURA CASCINI SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180029",
      "display" : "CASA DI CURA SCARNATI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180081",
      "display" : "CASA DI CURA M.MISASI GR.S.BARTOLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180084",
      "display" : "MEDICAL HOTEL CLIMAT. SPES PIETR.'ARENA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078117"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180086",
      "display" : "CASA DI CURA SAN FRANCESCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078079"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180912",
      "display" : "AZIENDA OSPEDALIERA DI COSENZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "912"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180916",
      "display" : "I.N.R.C.A. Cosenza",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "916"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180004",
      "display" : "ISTITUTO S.ANNA VIA SIRIS 11",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180005",
      "display" : "ISTITUTO S.ANNA SS - 106 KM 243",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180032",
      "display" : "OSPEDALE CIVILE SAN GIOVANNI DI DIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180045",
      "display" : "CASA DI CURA S.RITA DOTT. CAPARRA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180085",
      "display" : "ROMOLO HOSPITAL ( EX VILLA EVA )",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101019"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180101",
      "display" : "CALABRODENTAL SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180102",
      "display" : "SADEL DI SALVATORE BAFFA SPA ( EX OLIVET",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180103",
      "display" : "CASA DI CURA MADONNA DELLO SCOGLIO SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180107",
      "display" : "marrelli hospital",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180914",
      "display" : "A.O.U. MATER DOMINI CATANZARO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "914"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180033",
      "display" : "PO LAMEZIA TERME",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180040",
      "display" : "OSPEDALE DI SOVERIA MANNELLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079138"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180043",
      "display" : "CASA DI CURA VILLA DEL SOLE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180050",
      "display" : "CASA DI CURA VILLA SERENA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180051",
      "display" : "CASA DI CURA VILLA MICHELINO SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180053",
      "display" : "CASA DI CURA SANT`ANNA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180055",
      "display" : "OSPEDALE BASSO IONIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079137"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180150",
      "display" : "Villa Rachele S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079069"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180913",
      "display" : "Azienda Ospedaliera Pugliese - Ciaccio",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "913"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180034",
      "display" : "P.O. JAZZOLINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "102047"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180035",
      "display" : "P.O. TROPEA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "102044"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180047",
      "display" : "VILLA DEI GERANI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "102047"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180057",
      "display" : "P.O. SERRA SAN BRUNO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "102037"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180059",
      "display" : "OSPEDALE CIVILE LOCRI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080043"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180061",
      "display" : "P.O. 'S. MARIA DEGLI UNGHERESI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080061"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180062",
      "display" : "OSPEDALE 'TIBERIO EVOLI' - MELITO P.S.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080050"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180068",
      "display" : "P.O. 'GIOVANNI XXIII'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080038"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "180071",
      "display" : "ISTITUTO ORTOPEDICO MEZZOGIORNO D`ITALIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180073",
      "display" : "CASA DI CURA 'VILLA AURORA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180074",
      "display" : "POLICLINICO 'MADONNA DELLA CONSOLAZIONE'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180075",
      "display" : "CASA DI CURA 'VILLA CAMINITI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080096"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180076",
      "display" : "CASA DI CURA 'VILLA S.ANNA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180077",
      "display" : "CASA DI CURA 'VILLA ELISA' S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "180915",
      "display" : "Azienda Osped. Bianchi Melacrino Morelli",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "180205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "915"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190301",
      "display" : "P.O. S. GIOVANNI DI DIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "084001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190302",
      "display" : "P.O. BARONE LOMBARDO - CANICATTI'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "084011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190303",
      "display" : "P.O. S. GIACOMO D'ALTOPASSO LICATA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "084021"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190304",
      "display" : "P.O. F.LLI PARLAPIANO - RIBERA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "084033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190305",
      "display" : "P.O. GIOVANNI PAOLO II",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "084041"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190503",
      "display" : "CASA DI SALUTE IGNAZIO ATTARDI S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "084040"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190504",
      "display" : "SIA CASA DI CURA S. ANNA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "084001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190201"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "201"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190306",
      "display" : "P.O. Sant'Elia (ex AO)",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "085004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190307",
      "display" : "P.O. M. IMMACOLATA LONGO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "085012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190308",
      "display" : "P.O.MADDALENA RAIMONDI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "085016"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190309",
      "display" : "P.O. VITTORIO EMANUELE (ex AO)",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "085007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190310",
      "display" : "P.O. SANTO STEFANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "085009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190311",
      "display" : "P.O. SUOR CECILIA BASAROCCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "085013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190505",
      "display" : "CASA DI CURA 'REGINA PACIS'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "085016"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190506",
      "display" : "SO.GE.SA.SPA.C.DI.C.S.BARBARA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "085007"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190202"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "202"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190921",
      "display" : "A.O. per l'Emergenza Cannizzaro",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "921"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190923",
      "display" : "A.O.U. POLICLINICO - VITTORIO EMANUELE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "923"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190922",
      "display" : "ARNAS GARIBALDI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "922"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190312",
      "display" : "P.O. S. Marta e S. Venera Acireale",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190313",
      "display" : "S.Giovanni Di Dio e S.Isidoro Giarre",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190314",
      "display" : "P.O. Maria SS.Addolorata Biancavilla",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190315",
      "display" : "P.O. Castiglione Prestianni Bronte",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190316",
      "display" : "P.O. SS. Salvatore Paternò",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087033"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190317",
      "display" : "P.O. Gravina e S. Pietro Caltagirone",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190318",
      "display" : "P.O. Basso Ragusa Militello",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087025"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190511",
      "display" : "CENTRO CLIN.MORGAGNI srl c/o Di Stef Vel",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190512",
      "display" : "CASA DI CURA MADONNA DEL ROSARIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190513",
      "display" : "CASA DI CURA G.B. MORGAGNI S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190516",
      "display" : "MATER DEI DI G.NESI & C. S.P.A",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190517",
      "display" : "CASA DI CURA VILLA DEI GERANI SrL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190519",
      "display" : "HUMANITAS ISTITUTO CLINICO CATANESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087029"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190520",
      "display" : "CASA CURA CENTRO CATANESE MED. E CH.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190521",
      "display" : "CASA DI CURA CARMIDE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190523",
      "display" : "CASA DI CURA GIBIINO SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190553",
      "display" : "CASA DI CURA RIABILITATIVA VILLA SOFIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087004"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190554",
      "display" : "ISTITUTO ONCOLOGICO DEL MEDITERRANEO SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190555",
      "display" : "CASA DI CURA MONS. G. CALACIURA Cenacolo",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190710",
      "display" : "CASA DI CURA PROF.E.FALCIDIA SrL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190712",
      "display" : "Casa di Cura MUSUMECI Gescas",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087019"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190715",
      "display" : "CASA DI CURA VILLA S.FRANCESCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190723",
      "display" : "CASA DI CURA VALSALVA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190724",
      "display" : "ISCAS MORGAGNI NORD SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087034"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190725",
      "display" : "PRIVATE HOSPITAL ARGENTO srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190726",
      "display" : "ISTITUTO CLINICO VIDIMURA srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190727",
      "display" : "LUCINA RESIDENCE srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190728",
      "display" : "CLINICA SANT'AGATA Tigano srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190729",
      "display" : "CENTRO CLIN.MORGAGNI srl.c/o Check Point",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "087042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190203"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "203"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190319",
      "display" : "P. O. 'UMBERTO I'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "086009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190320",
      "display" : "P. O. 'M. CHIELLO'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "086014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190321",
      "display" : "P. O. 'FERRO-CAPRA-BRANCIFORTE'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "086011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190322",
      "display" : "P. O. 'CARLO BASILOTTA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "086012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "204"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190950",
      "display" : "ASSOCIAZIONE OASI MARIA SS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "086018"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190204"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "950"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "190323",
      "display" : "P.O. 'NUOVO CUTRONI ZODDA' BARCELLONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083005"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190324",
      "display" : "P.O. LIPARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083041"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190325",
      "display" : "P.O. 'G. FOGLIANI' MILAZZO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083049"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190326",
      "display" : "P.O.' S. VINCENZO' TAORMINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083097"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190327",
      "display" : "P.O. 'SS. SALVATORE' MISTRETTA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083052"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190328",
      "display" : "P.O. 'BARONE-ROMEO' PATTI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083066"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190329",
      "display" : "STABILIMENTO OSPED. S. AGATA MILITELLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083084"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190524",
      "display" : "I.O.M.I. F.SCALABRINO GANZIRRI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190525",
      "display" : "CASA DI CURA S.CAMILLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190526",
      "display" : "CASA DI CURA CRISTO RE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190527",
      "display" : "CASA DI CURA CARMONA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190528",
      "display" : "CASA DI CURA VILLA SALUS S.A.S.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190530",
      "display" : "C.O.T. S.P.A. (CURE ORTOPED. TRAUM.)",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190531",
      "display" : "CASA DI CURA VILLA IGEA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190601",
      "display" : "CENTRO CHIRURGICO VILLA MARIA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190716",
      "display" : "CASA DI CURA CAPPELLANI GIOMI S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "205"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190924",
      "display" : "Azienda Ospedaliera Papardo",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "924"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190925",
      "display" : "Azienda Osp. Univ. G. Martino",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "925"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190960",
      "display" : "IRCCS Centro Neurolesi 'Bonino Pulejo'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190205"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "960"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190926",
      "display" : "A.O.R Villa Sofia Cervello",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "926"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190179",
      "display" : "FOND. IST. S. RAFFAELE - GIGLIO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082027"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "8"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "190199",
      "display" : "OSP. BUCCHERI LA FERLA FATEBENEFRATELLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "4"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "190330",
      "display" : "P.O. DEI BIANCHI CORLEONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082034"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190332",
      "display" : "P.O. CIVICO PARTINICO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082054"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190333",
      "display" : "P.O. MADONNA DELL'ALTO - PETR. SOTTANA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082056"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190334",
      "display" : "P.O. S. CIMINO TERMINI IMERESE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082070"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190335",
      "display" : "P.O. G. F. INGRASSIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190337",
      "display" : "P.O. VILLA DELLE GINESTRE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190532",
      "display" : "CASA DI CURA IGEA S.N.C.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082054"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190533",
      "display" : "CASA DI CURA CANDELA SPA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190534",
      "display" : "CASA DI CURE ORESTANO S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190536",
      "display" : "CASA DI CURA 'TRIOLO ZANCLA' S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190537",
      "display" : "CASA DI CURA SERENA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190538",
      "display" : "CASA DI CURA NOTO PASQUALINO S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190539",
      "display" : "NUOVA CASA DI CURA D`ANNA PIA ASS. SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190540",
      "display" : "NUOVA CASA DI CURA DEMMA srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190541",
      "display" : "CASA DI CURA MACCHIARELLA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190542",
      "display" : "CASA DI CURA TORINA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190543",
      "display" : "CASA DI CURA VILLA MARGHERITA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190545",
      "display" : "CASA DI CURE COSENTINO DI KAROL S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190551",
      "display" : "CASA DI CURA LA MADDALENA S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190602",
      "display" : "CENTRO ANDROS S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190718",
      "display" : "CASA DI CURA LATTERI VALSAVA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190720",
      "display" : "CASA DI CURA MARIA ELEONORA HOSPITAL srl",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "206"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190927",
      "display" : "Azienda Ospedaliera 'Civico-Di Cristina-",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "927"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190928",
      "display" : "AZ.OSP.UNIV.P.GIACCONE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "928"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190970",
      "display" : "Dipartimento Rizzoli-Sicilia",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "970"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190929",
      "display" : "IRCCS Ismett",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190206"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "929"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "3.2"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato (Equiparato a pubblico)"
        }
      ]
    },
    {
      "code" : "190338",
      "display" : "OSPEDALE 'Giovanni Paolo II° M.P. A.'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "088009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190339",
      "display" : "OSPEDALE REGINA MARGHERITA COMISO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "088003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190340",
      "display" : "OSPEDALE MAGGIORE MODICA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "088006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190341",
      "display" : "OSPEDALE BUSACCA SCICLI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "088011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190342",
      "display" : "OSPEDALE GUZZARDI VITTORIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "088012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190552",
      "display" : "CASA DI CURA CLINICA DEL MEDITERRANEO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "088009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190207"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "207"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190343",
      "display" : "P.O. DI MARIA AVOLA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089002"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190344",
      "display" : "P.O. TRIGONA NOTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089013"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190345",
      "display" : "P.O. UMBERTO I (EX A.O.)",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190346",
      "display" : "P.O. MUSCATELLO AUGUSTA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190347",
      "display" : "OSPEDALE GENERALE DI ZONA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190348",
      "display" : "P.O. A. Rizza",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190507",
      "display" : "CASA DI CURA SANTA LUCIA GLEF",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190508",
      "display" : "CASA DI CURA VILLA MAURITIUS ARC",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190509",
      "display" : "IST.ORT. VILLA SALUS I. GALATIOTO SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190550",
      "display" : "C. DI CURA 'VILLA AZZURRA' - GESIN SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190701",
      "display" : "CLINICA VILLA RIZZO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190702",
      "display" : "CASA DI CURA 'VILLA AURELIA' SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190208"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "208"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190349",
      "display" : "P.O. SAN VITO E SANTO SPIRITO -ALCAMO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081001"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190350",
      "display" : "P.O. 'B. NAGAR' - PANTELLERIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081014"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190351",
      "display" : "P.O. S. ANTONIO ABATE - TRAPANI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190352",
      "display" : "P.O. V.EMANUELE II CASTELVETRANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190353",
      "display" : "P.O.PAOLO BORSELLINO - MARSALA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190354",
      "display" : "P.O.ABELE AJELLO-MAZARA D.VALLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081012"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190355",
      "display" : "P.O. VITTORIO EMANUELE III - SALEMI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081018"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "190501",
      "display" : "CASA DI CURA VILLA DEI GERANI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190502",
      "display" : "CASA DI CURA SANT`ANNA SRL.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081008"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190549",
      "display" : "CASA DI CURA MORANA SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081011"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "190556",
      "display" : "CASA DI CURA RIABIL. VITTORIA S.r.l",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "comune",
          "valueCode" : "081006"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "190209"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "209"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200002",
      "display" : "OSPEDALE CIVILE ALGHERO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090003"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200003",
      "display" : "OSPEDALE CIVILE OZIERI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090052"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200013",
      "display" : "POLICLINICO SASSARESE - LABOR S.p.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "301"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200905",
      "display" : "AZIENDA OSPEDALIERO UNIVERSITARIA SS",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200301"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "905"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200006",
      "display" : "P.O. PAOLO DETTORI - TEMPIO P.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090070"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "302"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200011",
      "display" : "P.O. PAOLO MERLO LA MADDALENA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "302"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200012",
      "display" : "P.O. GIOVANNI PAOLO II OLBIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090047"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "302"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200057",
      "display" : "MATER OLBIA HOSPITAL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "090047"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200302"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "302"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200017",
      "display" : "P.O. SAN FRANCESCO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "091051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200303"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "303"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200018",
      "display" : "P.O. C. ZONCHELLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "091051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200303"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "303"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200020",
      "display" : "P.O. SAN CAMILLO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "091086"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200303"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "303"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200019",
      "display" : "P.O. 'NOSTRA SIGNORA DELLA MERCEDE'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "091037"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200304"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "304"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200023",
      "display" : "CLINICA TOMMASINI SRL",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "091035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200304"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "304"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200021",
      "display" : "P.O. 'A.G. MASTINO' - BOSA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "095079"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200305"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "305"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200052",
      "display" : "P. OSPEDALIERO 'SAN MARTINO' - ORISTANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "095038"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200305"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "305"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200053",
      "display" : "P. OSPEDALIERO 'G.P. DELOGU' - GHILARZA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "095021"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200305"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "305"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200054",
      "display" : "C.C. 'MADONNA DEL RIMEDIO' - ORISTANO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "095038"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200305"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "305"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200034",
      "display" : "PRESIDIO OSPEDALIERO N.S. DI BONARIA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "111062"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200306"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "306"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200028",
      "display" : "P.O.SIRAI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "111009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200307"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "307"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200029",
      "display" : "P.O.SANTA BARBARA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "111035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200307"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "307"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200030",
      "display" : "P.O.CTO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "111035"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200307"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "307"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200906",
      "display" : "A.O.U. CAGLIARI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "906"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "2.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200022",
      "display" : "P.O. S.GIUSEPPE",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "111036"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200025",
      "display" : "P.O. R. BINAGHI",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200026",
      "display" : "P.O. MARINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200031",
      "display" : "P.O. SS. TRINITA'",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200035",
      "display" : "P.O. SAN MARCELLINO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "111042"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200040",
      "display" : "CASA DI CURA S.ANNA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200042",
      "display" : "CASA DI CURA S. ANTONIO S.P.A.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200044",
      "display" : "CASA DI CURA VILLA ELENA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200045",
      "display" : "NUOVA CASA DI CURA S.R.L.",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092015"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200056",
      "display" : "KINETIKA SARDEGNA",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092051"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "5.1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Privato"
        }
      ]
    },
    {
      "code" : "200060",
      "display" : "P.O MICROCITEMICO A.CAO",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "308"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "1"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    },
    {
      "code" : "200904",
      "display" : "AZIENDA OSPEDALIERA G.BROTZU",
      "property" : [
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "aslTerritoriale",
          "valueCode" : "200308"
        },
        {
          "code" : "codiceAzienda",
          "valueCode" : "904"
        },
        {
          "code" : "tipoStruttura",
          "valueCode" : "0"
        },
        {
          "code" : "naturaGiuridica",
          "valueString" : "Pubblico"
        }
      ]
    }
  ]
}

```
