# MDS - Elenco Farmacie - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **MDS - Elenco Farmacie**

## CodeSystem: MDS - Elenco Farmacie 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/minsan-farmacie | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsFarmacie |

 
Ministero della Salute - Elenco Farmacie. Source: www.dati.salute.gov.it/dataset/farmacie.jsp 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsFarmacia](ValueSet-vs-mds-farmacia.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "minsan-farmacie",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/minsan-farmacie",
  "version" : "0.1.2",
  "name" : "CsFarmacie",
  "title" : "MDS - Elenco Farmacie",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Ministero della Salute - Elenco Farmacie. Source: www.dati.salute.gov.it/dataset/farmacie.jsp",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "filter" : [
    {
      "code" : "regione",
      "description" : "Permette di ricercare i codici secondo il codice Regionale di appartenenza",
      "operator" : ["="],
      "value" : "codice della Regione"
    },
    {
      "code" : "comune",
      "description" : "Permette di ricercare i codici secondo il codice del comune di appartenenza",
      "operator" : ["="],
      "value" : "codice del Comune"
    },
    {
      "code" : "provincia",
      "description" : "Permette di ricercare i codici secondo il codice della provincia di appartenenza",
      "operator" : ["="],
      "value" : "codice della Provincia"
    },
    {
      "code" : "dataInizio",
      "description" : "Permette di ricercare i codici inserendo la data di inzio validità",
      "operator" : ["=", "not-in", "in"],
      "value" : "data"
    },
    {
      "code" : "dataFine",
      "description" : "Permette di ricercare i codici inserendo la data di inzio validità",
      "operator" : ["=", "not-in", "in"],
      "value" : "data"
    },
    {
      "code" : "tipologia",
      "description" : "Permette di ricercare i codici secondo la Tipologia di appartenenza",
      "operator" : ["="],
      "value" : "codice della Tipologia"
    }
  ],
  "property" : [
    {
      "code" : "regione",
      "uri" : "http://regione",
      "description" : "Proprietà che identifica la regione di appartenenza della farmacia",
      "type" : "code"
    },
    {
      "code" : "comune",
      "description" : "Proprietà che identifica il comune di appartenenza della farmacia",
      "type" : "code"
    },
    {
      "code" : "provincia",
      "description" : "Proprietà che identifica la provincia di appartenenza della farmacia",
      "type" : "code"
    },
    {
      "code" : "dataInizio",
      "description" : "Proprietà che identifica la data di inizio validità della farmacia",
      "type" : "dateTime"
    },
    {
      "code" : "dataFine",
      "description" : "Proprietà che identifica la data di fine validità della farmacia",
      "type" : "dateTime"
    },
    {
      "code" : "tipologia",
      "description" : "Proprietà che identifica la tipologia di farmacia",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "220",
      "display" : "farmacia stradella srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "253",
      "display" : "FARMACIA CERVINO DR.SSA MOLINENGO COSTA GIULIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "714",
      "display" : "farmacia ferretti sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002015"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "1636",
      "display" : "COMUNALE CARAVAGGIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016053"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "3212",
      "display" : "S. SIRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108032"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "3799",
      "display" : "FARMAGORA' MANTELLOS.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014039"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "3844",
      "display" : "Farmacia Eredi Dott. Mario Lodoletti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012098"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "3882",
      "display" : "Farmacia Bertoni Dei Dottori  Alessandra E Luigi Bertoni S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012025"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "3890",
      "display" : "FARMACIA FORNI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012119"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "3969",
      "display" : "DI GRANTOLA DEL DOTT.NICOLA FERRETTI & C. S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012081"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4306",
      "display" : "FASSA DOTT. PIETRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025003"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4514",
      "display" : "FARMACIA ALLA CONCEZIONE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024074"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4515",
      "display" : "FARMACIA DI ORGIANO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024075"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4538",
      "display" : "FARMAGORA' VICENZA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4546",
      "display" : "Ai Laghi-Farmacie Marson S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4550",
      "display" : "FARMACIE MARSON SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024036"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4552",
      "display" : "FARMACIE MARSON ANTONINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4603",
      "display" : "FARMACIA CARLI SNC DELLA DR.SSA DELLA LIBERA FEDERICA E DEL DR. SARDI ROBERTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026021"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4660",
      "display" : "FARMACIA DI CASTELMINIO SNC DELLA DR.SSA BERTUZZO MARIA LUISA E DELLA DR.SSA COLDEBELLA CRISTINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026066"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4676",
      "display" : "FARMACIA TONICELLO SNC DEI DR. TONICELLO VINCENZO E LUCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026047"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4862",
      "display" : "Farmacia Centrale S.n.c. Dei Dottori Alessandro Tiso E Andrea Paccagnella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "4894",
      "display" : "FARMACIA ALL'AEROPORTO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "5145",
      "display" : "FARMACIA SAN MARTINO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028055"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "5538",
      "display" : "FARMACIA ALLA SALUTE DI ALESSANDRO E CRISTINA CANDIANI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "5549",
      "display" : "FARMACIA SANT'ANTONIO DELLA DOTT.SSA MILENA VITTORI & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "031012"
        },
        {
          "code" : "provincia",
          "valueCode" : "031"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "6352",
      "display" : "CENTRALE AMBROSI LA SPEZIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011015"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "6374",
      "display" : "FARMACIA TONELLI  di Tonelli Mario & C. s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011002"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "7333",
      "display" : "FARMACIA DEL CORSO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040007"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "7524",
      "display" : "FARMACIA DI COLLE DI COMPITO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046007"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "7705",
      "display" : "FARMACIA BARONI S.A.S. DEL DOTT. CAVERA GIOVANNI BRUNO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050012"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "7872",
      "display" : "FARMACIA 1- AZIENDA SPEC. COMUNALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052012"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "7965",
      "display" : "FARMACIA CASENTINESE SAS DELLA DR.SSA MARIARITA PORROZZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051004"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "8335",
      "display" : "FARMACIA DR MAX CAMAIORE SARZANESE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046005"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "8487",
      "display" : "MIAFARMACIA SAN VENANZO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055030"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "8544",
      "display" : "FLAMINIA SNC - ZINGARINI ANNUNZIATA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054051"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "8709",
      "display" : "FARMACIA DRMAX ITALIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041013"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "9031",
      "display" : "OLIVIERI SNC DI BONFIGLI ANNIBALE E FABIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044066"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "9774",
      "display" : "MEDICAMENTA  FARMA  S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "9985",
      "display" : "FARFARELLI ENZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058007"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "10261",
      "display" : "DRMAX ITALIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059001"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "10287",
      "display" : "PALMIERI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059001"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "10427",
      "display" : "Farmacia Rama",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060076"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "10618",
      "display" : "BERNABEI MAURO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069073"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "10769",
      "display" : "FARMACIA DRMAX MONTESILVANO DI DRMAX ITALIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068024"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "11132",
      "display" : "FARMACIA DEL CAPRIO SNC DELLA DOTT.SSA ALDA GIORDANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064090"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "11193",
      "display" : "FARMACIA BAIANO DEL DOTT. RAFFAELE MASI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064010"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "11638",
      "display" : "FARMAHEALTH SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "11803",
      "display" : "FARMACIA SCAMARCIO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "12121",
      "display" : "Farmacia Grilli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063067"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "12302",
      "display" : "FARMACIA SOGLIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065116"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "12359",
      "display" : "FARMACIA VOLPE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065050"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "12740",
      "display" : "FARMACIA  DALENA ROSANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072037"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "13824",
      "display" : "FARMACIA SCORPINITI DI SCORPINITI DR. LEONARDO & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078099"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "13827",
      "display" : "FARMACIA TATEO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078103"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "13884",
      "display" : "Farmacia MINARDI Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "14014",
      "display" : "Cotroneo Giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079160"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "15411",
      "display" : "FARMACIA  CHIARA GIUFFRE' S.R.L. a socio unico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "16041",
      "display" : "FARMACIA CONGIU della Dott.ssa Laura Scaramella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091040"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "16473",
      "display" : "Farmacia Zanchi S. N. C. Di Zanchi Enrico & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024061"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "16781",
      "display" : "Farmacia Comunale Di Calenzano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048005"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "16792",
      "display" : "comunale I Gigli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048006"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "17575",
      "display" : "Dispensario Farmaceutico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018134"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "17748",
      "display" : "FARMACIA SAN MARCO DOTT.SSA ANGELA BIONDANI SUCCURSALE ESTIVA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027008"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "18057",
      "display" : "La Carinatese Di Farmacie Più Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026077"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "18768",
      "display" : "Comunale Dott.ssa Bongiorni Sara",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098003"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "19008",
      "display" : "ASM F26",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001063"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "19441",
      "display" : "DRMAX ITALIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "19816",
      "display" : "Farmacia DrMax Valmontone Artena di DrMax Italia srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058110"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "20204",
      "display" : "FARMACIA DI TREVIGLIO S.N.C. DI TREVIGLIO FARMA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016219"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "20563",
      "display" : "Farmacia Selvana s.a.s. della dr.ssa Roberta Bottaro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026086"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "20592",
      "display" : "ALGIPHARMA S.A.S. - DR. ALFREDO CURTI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016212"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-08-01"
        }
      ]
    },
    {
      "code" : "001",
      "display" : "SAN FRANCESCO DA PAOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "033",
      "display" : "FARMACIA EUROPEA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "079",
      "display" : "BAGGIO ROBA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "087",
      "display" : "FARMACIA GUARINO SAS DELLA DOTT.SA GUARINO PATRIZIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "091",
      "display" : "BORGO CRIMEA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "114",
      "display" : "BERNARDI sas di Baffico Ilaria e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "118",
      "display" : "MADONNA DEI FIORI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "121",
      "display" : "DEL BENESSERE DI FEDELI Srl DEL DOTT. MARINELLO STEFANO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "438",
      "display" : "FARMACIA SANTA CHIARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001265"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "448",
      "display" : "Farmacia Borca SNC di Borca Fiorenzo & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001068"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "542",
      "display" : "SAN MARTINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001309"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "559",
      "display" : "ANTONINI MONICA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001102"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "600",
      "display" : "Farmacia Pierucci di Alessandro Francisco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001050"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "604",
      "display" : "SAN DOMENICO DI VIMAR SAS DELLA DR.SSA VIETTI MICHELINA ANNA RINA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001047"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "623",
      "display" : "FARMACIA DEL PRINCIPIO S.A.S. DI GALSAP S.A.S. DI DAVIDE GALLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001186"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "630",
      "display" : "ANTICA MUSTON di BERGER DR.SSA CARLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001275"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "808",
      "display" : "OSPEDALE SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002148"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "892",
      "display" : "Comunale risorgimento",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "929",
      "display" : "FARMACIA MAIRATE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003149"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "939",
      "display" : "Farmacia San Clemente snc di Bolognino dott.ssa Silvia & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003016"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "983",
      "display" : "FARMACIA AGAZZONE DI AGAZZONE ROBERTA &C SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003021"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1050",
      "display" : "Farmacia Allegri dott.ssa Elisabetta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "103019"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1066",
      "display" : "Monchiero Maria Maddalena",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004061"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1104",
      "display" : "Dott. Invernelli Davide",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004233"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1203",
      "display" : "GIUGLEUR",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004012"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1208",
      "display" : "DELL'ARCO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004067"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1227",
      "display" : "OPERTI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004176"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1228",
      "display" : "FARMACIA CLERICI S.N.C. DI CLERICI ANNA MARIA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004213"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1233",
      "display" : "MAFFEI S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004148"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1254",
      "display" : "FARMACIA ANTICA TORRE DI CORINO DOTT.SSA ANNAMARIA E SARNINI DOTT.SSA SILVIA S.N.C.SIGLABILE OVE CONSENTITO FARMACIA ANTICA TORRE S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004072"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1275",
      "display" : "FARMACIA MARELLO SNC DEI DOTTORI MARELLO CARLOTTA, MARELLO MARCO, ROBINO STEFANO & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005007"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1296",
      "display" : "FARMACIA GARELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005005"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1324",
      "display" : "DOVA di STEFANO e SIMONETTA BOSCHI S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005080"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1327",
      "display" : "CENTRALE SAS DI VERRI DR. PAOLO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005050"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1338",
      "display" : "FARMACIA FILIPPA DI FILIPPA GIORGIO MARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005030"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1348",
      "display" : "FARMACIA GATTI SNC DI FRANCO E PAOLO GATTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006141"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1430",
      "display" : "FARMACIA SAN GIORGIO DI DOTT.LAURA SCARRONE & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006153"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1436",
      "display" : "FARMACIA QUARTERO M.V EREDE FARMACIA DR. QUARTERO FERDINANDO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006120"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1445",
      "display" : "FARMACIA SANTA RITA DELLA DOTT.SSA PISANO ILARIA & c. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006026"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1462",
      "display" : "FARMACIA BODO DI DOTTORESSA FERNANDA BODO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006039"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1463",
      "display" : "POPOLO SRL.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006039"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1467",
      "display" : "FARMACIA BAROZZI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006042"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1499",
      "display" : "DEL BORGO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006033"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1555",
      "display" : "PIAZZOLI LOREDANA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1579",
      "display" : "farmacia Faletti srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016183"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1584",
      "display" : "LAGO D'ISEO GUATTERI GLAUCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016211"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1597",
      "display" : "DE RUEDA DI GHISELLI FEDERICA & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016246"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1611",
      "display" : "COMUNALE ROMANO DI LOMBARDIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016183"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1715",
      "display" : "LAFARMACIA.MORELLO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016219"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1732",
      "display" : "AREZZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016128"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1739",
      "display" : "Farmacia di Brusaporto sas del Dr. Alberto Francesco Pinto & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016042"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1756",
      "display" : "BONVINI DR.SSA BEATRICE CANTONI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016142"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1770",
      "display" : "ANTICA SPEZIERIA DELLA COMUNITA' DI CONELLI VALERIA & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016133"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1786",
      "display" : "MORLOTTI s.a.s. dr Luca Morlotti & c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016007"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1787",
      "display" : "QUATTRO STRADE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1810",
      "display" : "FARMACIA CROCE BIANCA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1869",
      "display" : "FARMACIA DOTT. ABBIATI ERNESTO E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017173"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1876",
      "display" : "COMUNALE TRAVAGLIATO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017188"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1913",
      "display" : "FENAROLI S.A.S DELLE DOTT.SSE AURELIA E LUDOVICA FENAROLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017038"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1925",
      "display" : "farmacia baronio mario e c. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017046"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1966",
      "display" : "Farmacia Clusane",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017085"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "1978",
      "display" : "FARMACIA SIMONI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2095",
      "display" : "FARMACIA SUBINI S.N.C. DEI DOTTORI ACHILLE E FILIPPO SUBINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013245"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2110",
      "display" : "FARMACIA COMUNALE E SERVIZI DI MONTANO LUCINO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013154"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2121",
      "display" : "BULGORELLO s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013036"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2164",
      "display" : "MELLI PETAZZI SNC DEI DOTTORI SERGIO E VALENTINA PETAZZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013064"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2239",
      "display" : "FARMACIA DR. VECCHIA S.A.S. DI VECCHIA MAURIZIO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019081"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2317",
      "display" : "SOLZI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019098"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2374",
      "display" : "MAURI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "097020"
        },
        {
          "code" : "provincia",
          "valueCode" : "097"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2376",
      "display" : "FARMACIA S.ANTONIO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "097092"
        },
        {
          "code" : "provincia",
          "valueCode" : "097"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2455",
      "display" : "FARMACIA GORLA della Dott.ssa PAOLA GORLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098032"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2602",
      "display" : "FARMACIA BERTA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2645",
      "display" : "FARMACIA FARINATTI S.N.C. DEI DOTTORI SILVIA E GIUSEPPE FARINATTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2684",
      "display" : "FARMACIA MALPIGHI S.N.C. DI GUFFANTI GIAN PAOLO, CHIARA E GIORGIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2705",
      "display" : "Farmacia Palmanova sas dr.ssa Barbara Gallo & co.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2812",
      "display" : "farmacia dott. Vincenzo Parente SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061008"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2894",
      "display" : "M&T Farmacia dei Consoli di Mariani A.M.M. & C. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2946",
      "display" : "ROMA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "2956",
      "display" : "DELLA TORRETTA SAS DI MONICA ROCCHI E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3011",
      "display" : "CADORNA SNC DR. TIEGHI GIORGIO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3014",
      "display" : "S.Antonio snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3046",
      "display" : "FARMACIA COMUNALE 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015213"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3062",
      "display" : "GIANESE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015072"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3066",
      "display" : "FARMACIA MARTINONI SNC DI VITTORIO E MARILISA MARTINONI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015038"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3095",
      "display" : "FARMACIA MEAZZA S.N.C. DI RASTALDI CESARE E RASTALDI ELENA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015182"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3096",
      "display" : "COMUNALE N.2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015213"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3098",
      "display" : "AZIENDA FARMACIA MUNICIPALIZZATA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015131"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3121",
      "display" : "AZIENDA SPECIALE FARAMCIE COMUNALI DI SEDRIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015204"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3175",
      "display" : "STELVIO Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015157"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3205",
      "display" : "Farmacia Della Basilica Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015130"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3252",
      "display" : "FARMACIA PELLEGRINI SAS DEL DR LUCA PELLEGRINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015195"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3287",
      "display" : "SAN GIUSEPPE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015060"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3319",
      "display" : "VERNATE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015236"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3327",
      "display" : "S. ANNA DI BROGLIA ALESSANDRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015189"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3501",
      "display" : "San Carlo Snc di Alessandro e Paolo Motta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108034"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3566",
      "display" : "MAZZOCCHI SNC DI MAZZOCCHI ANTONELLA E C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018030"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3625",
      "display" : "FARMACIA ASM 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018182"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3627",
      "display" : "farmacia asm3",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018182"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3629",
      "display" : "Farmacia ASM 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018182"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3652",
      "display" : "FARMACIA DEL CARMINE DOTT.SSA NOVELLO ELIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018029"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3684",
      "display" : "Farmacia Rognone SNC di Rognone Gabriella e C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018168"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3698",
      "display" : "PORTALUPI GRAZIELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018069"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3715",
      "display" : "Farmacia Pizzocaro & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018163"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3730",
      "display" : "SAN MICHELE DI DOTT. GIRALDELLI BARBARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018100"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3753",
      "display" : "MARTINELLI DI MARTINELLI CLAUDIA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014065"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3755",
      "display" : "FARMACIA DELL'AUSILIATRICE SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071020"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3774",
      "display" : "VITALI DI VITALI MARCELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014002"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3775",
      "display" : "FARMACIA EMMEPI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014009"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3776",
      "display" : "Emmepi SRL- Succursale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014009"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3846",
      "display" : "MARASSI  DR. MARIO DELLE DR.SSE CRISTINA ED ELENA MARASSI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012077"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3859",
      "display" : "FARMACIA DI DAVERIO DELLA D.SSA SAMANTA ROSSONI & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012064"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3894",
      "display" : "PAGANI ERMANNO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012016"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3904",
      "display" : "Farmacia Sant'Anna di Dott. Refraschini Danilo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012026"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3914",
      "display" : "Farmacia di Castelveccana srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012045"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3920",
      "display" : "FARMACIA LATTUADA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012070"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "3990",
      "display" : "AZIENDA GESTIONE SERVIZI UBOLDO S.R.L . (A.GE.S UBOLDO S.R.L.)",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012130"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4021",
      "display" : "TABONI DR.SSA CRISTINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017124"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4039",
      "display" : "FARMACIA PETROBONI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017148"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4071",
      "display" : "ST. ANNA APOTHEKE DES DR. PETER VON AUFSCHNAITER & CO. K.G.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "021008"
        },
        {
          "code" : "provincia",
          "valueCode" : "021"
        },
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4162",
      "display" : "LaFarmacia.DellaRoggia S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022001"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4311",
      "display" : "FARMACIA SANT'ANNA DI TAMBRE S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025060"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4423",
      "display" : "FARMACIA SELLA DELLE DOTT.SSE  ALBERTA E MATILDE SELLA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024100"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4424",
      "display" : "KALIDEA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024100"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4426",
      "display" : "Farmacia Alle Due Sirene Di Termini Sara E C. S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024105"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4465",
      "display" : "Farmacia Ceccato SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024061"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4505",
      "display" : "MADONNA DELL'AIUTO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024048"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4548",
      "display" : "FARMACIA CAMPEDELLO S.N.C. DEI DOTTORI RAPPO MARISA E GUIZZON LUCA E CRISTINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4570",
      "display" : "Farmacia Carraro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026020"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4575",
      "display" : "Farmacia Loschi S.R.L",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026026"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4581",
      "display" : "farmacia di miane sas della dr.ssa da ruos luisa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026042"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4597",
      "display" : "Farmacia Comunale 2 - San Giacomo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026092"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4601",
      "display" : "PANCOTTO  DOTT.SSA CHIARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026092"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4666",
      "display" : "Farmacia Peressini snc delle Dr.sse Scotini Elisabetta e Bigal Erica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026016"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4702",
      "display" : "FARMACIA SANTAGOSTINO DELLA DR.SSA MADDALENA CALZAVARA & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026086"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4708",
      "display" : "S.MARIA MAGGIORE SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026086"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4737",
      "display" : "Lafarmacia.Castagnole SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026055"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4779",
      "display" : "DE PRATO SNC DELLA DR.SSA GIOVANNA GIROTTO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027034"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4797",
      "display" : "Farmacia Alla Salute Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4830",
      "display" : "MAGNAGUAGNO SNC DEI DR.I MAGNAGUAGNO BARBARA E UGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4995",
      "display" : "CARMIGNOTO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028032"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "4999",
      "display" : "BORDIGNON ANTONELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028041"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5055",
      "display" : "FARMACIE BELLATO DEI DOTTORI CARLA ED ALBERTO BELLATO S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5097",
      "display" : "Farmacia Forcellini dei dottori Avella Filippo e Menga Antonella snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5099",
      "display" : "Farmacia Nicolazzi S.a.s. Della Dr.ssa Marta Nicolazzi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028016"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5201",
      "display" : "FARMACIA ALLA SALUTE DEL DOTT. ROBERTO GUIRDORZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029019"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5247",
      "display" : "CENTRALE SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029001"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5277",
      "display" : "S. NAZARO S.A.S DI NIGRI MARCO E MATTEO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5291",
      "display" : "Farmacia Dott. Fasoli Francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023067"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5408",
      "display" : "BOSELLI RAFFAELE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023053"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5412",
      "display" : "FARMACIA DANI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023056"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5430",
      "display" : "FARMACIE BRAGHETTA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023077"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5554",
      "display" : "COMUNALE N.1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "031007"
        },
        {
          "code" : "provincia",
          "valueCode" : "031"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5564",
      "display" : "COMUNALE N.2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "031007"
        },
        {
          "code" : "provincia",
          "valueCode" : "031"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5621",
      "display" : "Farmacia Sabbadini dott.ssa Monica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030014"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5646",
      "display" : "Rossi snc di Barbara e Fabio Rossi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030106"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5682",
      "display" : "FARMACIA AIELLO DELLA DOTT.SSA ANNA AIELLO E DEL DOTT. LORENZO LASTRUCCI S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5691",
      "display" : "FARMACIA STRAZZOLINI DI STRAZZOLINI CLAUDIA & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030103"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5694",
      "display" : "Farmacia Trojani del Dott.Valentino Trojani S.a.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030053"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5708",
      "display" : "San Marco Benessere e c.sas del Dott. Sartori di Borgoricco Ferruccio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5713",
      "display" : "Farmacia Beivars della Dott.ssa Tiziana Cossio sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5716",
      "display" : "FARMACIA LOVISONI DEI DOTTORI LOVROVICH G. E BONINI D. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030023"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5719",
      "display" : "FARMACIA TROJANI DEL DOTT. VALENTINO TROJANI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030070"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5738",
      "display" : "FARMACIA ROMANO L. &  C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030064"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5754",
      "display" : "FARMACIA SAN GIORGIO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027034"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5768",
      "display" : "FIORETTI FRANCESCO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093025"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5775",
      "display" : "IOGNA PRAT DOTT. STEFANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093047"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5893",
      "display" : "SAN PIETRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008028"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "5967",
      "display" : "URBE DI SAN PIETRO FARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009063"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6097",
      "display" : "FARMACIA BARABINO S.A.S.  DELLA DOTTORESSA DRAGO VALENTINA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6103",
      "display" : "OLIVIERI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6156",
      "display" : "NOSTRA SIGNORA ASSUNTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6174",
      "display" : "SAN ROCCO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6204",
      "display" : "DAGNINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6218",
      "display" : "Farmacia Armonia SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010007"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6264",
      "display" : "S. GOTTARDO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6271",
      "display" : "Farmacia MODIGLIANI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6315",
      "display" : "FARMACIA PILA DEL DOTT. BONELLI MICHELE E FIGLI S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010059"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6325",
      "display" : "MODERNA (SUCCURSALE)",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010054"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6353",
      "display" : "CESENA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011029"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6397",
      "display" : "FARMACIA BELLO DI GIUDICI GIORGIO  &  C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011016"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6405",
      "display" : "FARMACIA VEZZANESE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011031"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6410",
      "display" : "Farmacia Santa Franca Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033028"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6413",
      "display" : "FIORANI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6431",
      "display" : "ANTICA FARMACIA ANTONIO CORVI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6434",
      "display" : "FARMACIE DI CORTEMAGGIORE SNC DI BORRINI SILVIA E ERBA TITO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033018"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6435",
      "display" : "FARMACIE DI CORTEMAGGIORE SNC DI BORRINI SILVIA E ERBA TITO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033018"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6445",
      "display" : "Buroni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033033"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6458",
      "display" : "Bianchi Di Bianchi dr. Marco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033004"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6459",
      "display" : "farmacia reggi sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033019"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6463",
      "display" : "Farmacia di Vernasca SNC di Colombini I. e Quetti M.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033044"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6494",
      "display" : "San Francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033034"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6497",
      "display" : "Farmacia Fornari s.n.c. di Fornari dott.ssa Maria Beatrice & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6508",
      "display" : "FARMACIA BAGANZADUE SNC DEL DOTT. MARCO BARBIERI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6514",
      "display" : "MALCHIODI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034014"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6527",
      "display" : "FARMACIA CUOGHI ELISABETTA E C. S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034032"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6603",
      "display" : "farmacia baganza snc del dott. marco barbieri & c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6630",
      "display" : "FARMACIA BERTOLANI della Dott.ssa Bertolani Giulia & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035008"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6636",
      "display" : "Farmacia Serri Casina snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035013"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6648",
      "display" : "FARMACIA DOTT:SACCARDI GIUSEPPINAS.N.C. DEI DOTT.MANFREDI LUCA EANGELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035022"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6692",
      "display" : "FARMACIA ZIROLDI TINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035022"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6703",
      "display" : "RONZONI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6717",
      "display" : "GULMANELLI S.R.L",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036006"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6880",
      "display" : "DI MONGHIDORO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037040"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6882",
      "display" : "OSTI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037061"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6908",
      "display" : "NUOVA FARMACIA CENTRALE S.R.L",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037001"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6910",
      "display" : "VENTURINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037029"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6933",
      "display" : "DEL SANTERNO DI MONTANARI MARISA E BACCILIERI STEFANO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037032"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6936",
      "display" : "DI TOSCANELLA DI  FLORIO DR.SSA LUCIANA ZELINDA ELISABETTA E C SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037025"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6937",
      "display" : "SAN PROSPERO  DI CENNI FEDERICA E GERARDO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037032"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6941",
      "display" : "Farmacia dell'Immacolata del Dott. Baraldi Mariano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037048"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6942",
      "display" : "MADONNA DA SERA DI ZOCCOLI GAETANO E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037024"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6946",
      "display" : "CROCI DEI DR.I  ALVISI STEFANO E MICHELE SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037028"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6948",
      "display" : "FARMACIA CENTRALE DI MASSARINI MARIA CHIARA E C. S.A.S. IN BREVE   FARMACIA CENTRALE S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037053"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6963",
      "display" : "STORI DI STORI DR.SSA FIAMMETTA & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037035"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6967",
      "display" : "ZOCCOLI DI ZOCCOLI DOTT. GAETANO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037024"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6976",
      "display" : "FARMACIA AICARDI DEL DOTTOR FEDERICO AICARDI &C S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6984",
      "display" : "TEFIFARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "6988",
      "display" : "CROCE BIANCA snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7005",
      "display" : "DELLO STERLINO DI DIMARCO DOTT.SSE FRANCESCA E PAOLA E C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7006",
      "display" : "DI CORTICELLA DR.SSA BRAGAGLIA ANNA & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7019",
      "display" : "SACCHETTI DELLA DR.SSA FRANCHI ANNA E C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7043",
      "display" : "farmacia del reno della dott..ssa mazzoni manuela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7063",
      "display" : "GRIMALDI DELLA DOTT.SSA FRANZAROLI ANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7072",
      "display" : "TRENTO E TRIESTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7097",
      "display" : "FARMACIA DELLA SALUTE S.N.C. DELLA DOTT.SSA GIULIA GHISELLINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7175",
      "display" : "ANNUNZIATA -DR. HOUMANI AKRAM & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038019"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7201",
      "display" : "DRADI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7219",
      "display" : "FARMACIA DELLA PIEVE DELLA DOTT.SSA DOLCINI CHIARA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039007"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7246",
      "display" : "MARGOTTI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039008"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7250",
      "display" : "SAN PAOLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039013"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7257",
      "display" : "FARMACIA CENTRALE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039007"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7281",
      "display" : "FARMACIA NANNI DEL DOTT. GIORGIO NANNI E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7364",
      "display" : "Farmacia Comunale San Giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040007"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7382",
      "display" : "FARMACIA MATTOZZI SNC DEL DR. FRANCESCO ANTONIO MATTOZZI & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099010"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7386",
      "display" : "DELL'ALBA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099013"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7390",
      "display" : "COLANTONIO - FARMACIE VISERBESI DEL DOTT. FABIO ZECCA E C. S.N.C. IN BREVE FARMACIE VISERBESI S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7413",
      "display" : "FARMACIA RIVAZZURRA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7423",
      "display" : "FARMACIA VILLAGGIO NUOVO Dr Pagnini srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7499",
      "display" : "SCAPPARONE CLAUDIO LUIGI & C SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045013"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7512",
      "display" : "Farmacia Comunale Lucca Fornoli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046002"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7520",
      "display" : "FARMACIA DI MARLIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046007"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7528",
      "display" : "Farmacia Le Ville SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046007"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7539",
      "display" : "FARMACIA COMUNALE MONTE SAN QUIRICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7540",
      "display" : "Farmacia Comunale Lucca Sant'Angelo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7541",
      "display" : "Farmacia Comunale Lucca 24 ore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7542",
      "display" : "Farmacia Comunale Lucca San Vito",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7553",
      "display" : "Farmacia Landi Dr. Alessandro Pellegrini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7648",
      "display" : "COMUNALE SAN MARCELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "047024"
        },
        {
          "code" : "provincia",
          "valueCode" : "047"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7657",
      "display" : "DI BAGNOLO di Farmacie Costagli. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100003"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7667",
      "display" : "San Giorgio A Colonica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100005"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7669",
      "display" : "FALCHI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100005"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7675",
      "display" : "FARMACIA DELLA PIETA' DEL DR. U. BOTTARI E C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100005"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7753",
      "display" : "FARMACIA PIERONI S.N.C. DEL DOTT. PIERONI RAFFAELE E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050035"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7755",
      "display" : "MAGGIOLI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050036"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7960",
      "display" : "PONTE ALLA CHIASSA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "7993",
      "display" : "FARMACIA DI LATERINA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051019"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8004",
      "display" : "FARMACIA GALEFFI DELLA FARMACIA BARTOLINI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051026"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8092",
      "display" : "COSANA SAS DELLA DR.SSA VITTORIA CAMBI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053018"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8104",
      "display" : "PETITTO ROBERTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053024"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8113",
      "display" : "FARMACIA BRONZINI DEL DR. ALBERTO PERROUD S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048001"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8130",
      "display" : "FARMACIA  ROSSI ETTORE DELLA DR.SSA MONICA ROSSI E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048006"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8132",
      "display" : "LA FENICE DI SIMONETTA VALERIANI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048013"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8148",
      "display" : "FARMACIE BIGAGLI E S. JACOPINO SAS DI RICCARDO LANINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8153",
      "display" : "FARMACIA DELLE PANCHE S.A.S. DI BRESSAN FRANCESCO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8154",
      "display" : "BRIZIO MAZZEI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8172",
      "display" : "SCILLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8218",
      "display" : "PORTA ROSSA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8246",
      "display" : "FARMACIA SELLARI DELLA D.SSA FIORELLA SELLARI E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048024"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8255",
      "display" : "Farmacia Grb Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048033"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8261",
      "display" : "PRATELLESI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048036"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8305",
      "display" : "farmacia bizzarri snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048014"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8306",
      "display" : "NUOVA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048014"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8328",
      "display" : "FARMACIA G.T. SCATOLA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048050"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8330",
      "display" : "FARMACIA ZITO S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048050"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8345",
      "display" : "Comunale Nr. 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046018"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8444",
      "display" : "FARMACIA DR. VALENTE S.N.C. DI VALENTE ALESSIO E PIER GIORGIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8462",
      "display" : "COMUNALE TODI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054052"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8478",
      "display" : "AFAS N.1 PERUGIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8488",
      "display" : "COMUNALE N.5 PERUGIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8498",
      "display" : "COMUNALE SAN FELICIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054026"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8523",
      "display" : "COMUNALE PRECI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054043"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8571",
      "display" : "Farmacia MONTI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8600",
      "display" : "FARMACIA TRIPPETTA  SNC DI U. TRIPPETTA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055021"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8626",
      "display" : "TINTORI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041019"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8649",
      "display" : "FARMACIA DI CANDELARA & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041044"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8706",
      "display" : "FARMACIA DEL PORTO ROSSI RENATA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041013"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8804",
      "display" : "Farmacia Giuseppucci srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042017"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8950",
      "display" : "farmacia natali srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043047"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "8983",
      "display" : "FARMACIA FARRONI ENRICO CARLO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "109017"
        },
        {
          "code" : "provincia",
          "valueCode" : "109"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9049",
      "display" : "FARMACIA R. LOFFREDA SAS DI RAFFAELE LOFFREDA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044007"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9062",
      "display" : "FARMACIA VILLA PIGNA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044020"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9073",
      "display" : "VALERI DI VALERI SILVIA E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044064"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9107",
      "display" : "ANTICA FARMACIA SAN FRANCESCO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9119",
      "display" : "Piazzale Ionio 46",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9124",
      "display" : "BETA DELLA DR.SSA BAVUSO MANUELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9126",
      "display" : "FARMACIA D'AGOSTINO S.A.S. DEL DR. ANTONINO FRANCESCO D'AGOSTINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9149",
      "display" : "farmacia boito sas dr.ssa francesca di filippo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9153",
      "display" : "FARMACIA MUZI SAS DI FABRIZIO MUZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9180",
      "display" : "FARMACIA  DELLE VALLI DI MARIA LUISA RITA ROVERE & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9275",
      "display" : "Farmacia Cerilli S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9296",
      "display" : "CROCE EMILIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9298",
      "display" : "Farmacie Flavia Servizi Srl N.1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058116"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9438",
      "display" : "farmacia borghesi sas della dottssa giulia borghesi & co",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9465",
      "display" : "SACRO CUORE DEL DR. DAVID GIAMPIERO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9471",
      "display" : "Farmacia Tedone s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9510",
      "display" : "FARMACIA AQUILONIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9519",
      "display" : "Farmacia Zelli Giulio S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9551",
      "display" : "FARMACIA SCARFO' SOCIETA' A RESPONSABILITA' LIMITATA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9555",
      "display" : "Farmacia Bastelica S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9593",
      "display" : "CENTONZE snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9670",
      "display" : "Farmacia Ragoni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9684",
      "display" : "SPAGNOLI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9691",
      "display" : "FARMACIA BEDESCHI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9739",
      "display" : "FARMACIA RALLO  DI SANDRA E SILVIA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9758",
      "display" : "FARMACIA CONTARINA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9912",
      "display" : "FARMAVENTITRE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058017"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9955",
      "display" : "FARMACIA COMUNALE N.2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058043"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9976",
      "display" : "FARMACIA COMUNALE NR 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058043"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "9996",
      "display" : "FARMACIA MILO SAS DI FRANCESCO MILO DI VILLAGRAZIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058007"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10037",
      "display" : "Farmacia Comunale Buero",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058088"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10053",
      "display" : "FARMACIA RIPOLI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058118"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10066",
      "display" : "CASSINI RENZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056016"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10088",
      "display" : "MORELLI DOTT. FABIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10273",
      "display" : "FARMACIA REALE SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059030"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10317",
      "display" : "Farmacia Comunale Sezze",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059028"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10355",
      "display" : "ALFONSI VENTURINI GIOVANNI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060036"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10362",
      "display" : "Farmacia Giordano dott.ssa Marini Giulia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060004"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10379",
      "display" : "PIETRANDREA VALENTINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060033"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10385",
      "display" : "Farmacia Patricelli SAS di Simeoni Emanuele e Francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060081"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10469",
      "display" : "PADRE PIO-CIOTTI MASSIMO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060053"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10478",
      "display" : "FARMACIA MESSORE SAS DEL DR. MESSORE PASQUALE & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060051"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10481",
      "display" : "FARMACIA MADONNA DI TUFANO SAS DI PINA PIU & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060006"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10509",
      "display" : "Farmacia De Marco sas del Dr. Massimo De Marco & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066064"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10531",
      "display" : "SALTARELLI LUISA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066078"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10630",
      "display" : "ANTICA FARMACIA D'ANNUNZIO S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069014"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10657",
      "display" : "De Mia Veronica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069074"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10684",
      "display" : "Farmacia San Lorenzo S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069079"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10710",
      "display" : "DI NARDO DI MARIA DI NARDO & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069031"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10875",
      "display" : "SAVINI GUERINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067045"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "10890",
      "display" : "Farmacia Montefino Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067027"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11229",
      "display" : "Di Giovinazzo Francesca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064074"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11311",
      "display" : "Franco Umberto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062023"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11409",
      "display" : "Marcello srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061095"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11519",
      "display" : "DELICA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061032"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11537",
      "display" : "SAGRIPANTI MARIA LUISA SAS DELLA DOTT.SSA MARIA LUISA SAGRIPANTI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061053"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11571",
      "display" : "Farmacia Vittorio Emanuele della dott.ssa Russo Gelsomina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11572",
      "display" : "Farmacia Ferrari Teresa erede unico Dott. Antonio Mazzella di Bosco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11697",
      "display" : "LA RANA MICHELE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11720",
      "display" : "FARMACIA FORIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11770",
      "display" : "SAN FRANCESCO S.R.L",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11796",
      "display" : "FARMACIA ZETA S.N.C. DEI DOTTORI VIVIANI RODOLFO E PIER PAOLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11798",
      "display" : "FARMACIA ZETA S.N.C. DEI DOTTORI VIVIANI RODOLFO E PIER PAOLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11815",
      "display" : "FARMACIA S.ANTONIO DI LULLO DR GIUSEPPE LORITO & C SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "11995",
      "display" : "CMS farma srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063017"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12001",
      "display" : "Farmacia peluso s.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063017"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12129",
      "display" : "FARMACIA KYROS UMBERTO I DI ZENIT S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063083"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12131",
      "display" : "DR MAX TORRE ANNUNZIATA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063083"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12150",
      "display" : "Farmacia San Felice Eredi Dr. Figliola s.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063084"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12168",
      "display" : "Farmacia Lourdes Eredi Dr. Figliola s.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063084"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12175",
      "display" : "FARMACIA KYROS MADONNA DI POMPEI DI NADIR S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063058"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12213",
      "display" : "FARMACIA BRANCATI SAS DEL DOTTOR BRANCATI DIEGO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12496",
      "display" : "Farmacia Del Monaco Dott. Lorenzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110001"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12547",
      "display" : "FARMACIA FRATE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110001"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12555",
      "display" : "Farmacia Lombardi Sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110002"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12558",
      "display" : "FARMACIA MASTROMATTEO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110002"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12585",
      "display" : "FARMACIA DE CANDIA NICOLA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072029"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12612",
      "display" : "DORONZO CLAUDIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110002"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12624",
      "display" : "FARMACIA ORESTE ROSA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072004"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12663",
      "display" : "STANZIONE MASSIMO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12695",
      "display" : "MASFARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12698",
      "display" : "MASFARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12773",
      "display" : "MASFARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12861",
      "display" : "FARMACIA DORIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12888",
      "display" : "ALIOTH SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074010"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12902",
      "display" : "FARMACIA DELLA PIAZZA  SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074015"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12958",
      "display" : "Farmacia San Rocco di Paola Niro sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071012"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "12960",
      "display" : "SCARDIGNO MICHELE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071026"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13037",
      "display" : "FARMACIA SINISI ANGELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071036"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13108",
      "display" : "DEL VENTO ANDREA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071052"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13138",
      "display" : "Stoduto Antonio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13162",
      "display" : "Farmacia San Lorenzo snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075038"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13163",
      "display" : "Farmacia Polito della Dr.ssa Tamara Alda Toccafondi snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075034"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13182",
      "display" : "MARZANO UMBERTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13183",
      "display" : "FARMACIA MARZO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075055"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13219",
      "display" : "FARMACIA VALZANO DI GIUSEPPE VALZANO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075079"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13274",
      "display" : "DOTT. FABIO DE BELVIS S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075031"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13276",
      "display" : "FARMACIA SALUS DEL DOTTOR DE NOTARIIS MASSIMO S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075059"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13284",
      "display" : "COLAFATI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075061"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13291",
      "display" : "SALUS SNC DEL DR.MASSIMO DE NOTARIIS SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075090"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13311",
      "display" : "FARMACIA RAGUSA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075009"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13341",
      "display" : "FARMACIA URSO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075027"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13357",
      "display" : "FARMACIA CONGEDI DEL DOTT. ROSARIO CONGEDI S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075016"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13442",
      "display" : "GRECO ANTONIO PIO ANGELO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073020"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13742",
      "display" : "CALABRESE & GROPPA SNC DI CALABRESE RITA E GROPPA BILOTTA BRUNO GIUSEP",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078057"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13751",
      "display" : "FARMACIA DI FRANCO DE GREGORIO MARCO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078129"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13817",
      "display" : "FARMACIA DI LEO S.N.C. DI DI LEO GIUSEPPE & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078082"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13965",
      "display" : "Farmacia Caputo Crotone SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "13979",
      "display" : "FARMACIA AIELLO GIUSEPPE  S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101015"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14003",
      "display" : "FARMACIA MEGNA DOTT. ANTONIO S.A.S. E FIGLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101010"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14041",
      "display" : "MERCURI MANNY",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079114"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14065",
      "display" : "FARMACIA CORAPI SAS DEL DR CORAPI VITALIANO & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079029"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14096",
      "display" : "Griffo Francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079005"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14098",
      "display" : "Farmacia Del Sole Della D.ssa Clara Ruffa & C. S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14274",
      "display" : "Farmacia Salus S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080088"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14420",
      "display" : "Farmacia Aschenez",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080063"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14484",
      "display" : "Ganduscio Gaspare",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084033"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14554",
      "display" : "Dott.ssa Fiori Caterina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084021"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14635",
      "display" : "Ferreri s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087005"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14655",
      "display" : "FARMACIA DEL VIALE SAN PIETRO CLARENZA DEI DOTTORI CLAUDIA PARRINO E PAOLO PITITTO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087044"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14665",
      "display" : "Farmacia Gulino Cusumano Dott.ssa Rossella Gulino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087011"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14674",
      "display" : "Leone G. & C. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14678",
      "display" : "Lizzio Del Dr. Lizzio Alfio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087039"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14691",
      "display" : "farmacia arico' dott.ssa arico'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087004"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14714",
      "display" : "Farmacia Russo dott.ssa Maria Bianca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087039"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14723",
      "display" : "SAN PAOLO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087019"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14767",
      "display" : "D.ssa Bertino Nicoletta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087006"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14768",
      "display" : "Farmacia Di Luca s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087029"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14814",
      "display" : "Farmacia Roma s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14836",
      "display" : "FARMACIA DOTT. F. VIRGILLITO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087029"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14884",
      "display" : "Russo Eleonora",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087035"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14903",
      "display" : "Farmacia Paladino Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087008"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14916",
      "display" : "Greco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086007"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14917",
      "display" : "GRECO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086007"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14939",
      "display" : "Farmacia Santa Croce Della D.ssa Cannata Maria Rosa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086015"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14962",
      "display" : "FARMACIA MANGANARO DR.SSA ANGELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083034"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14978",
      "display" : "SCIACCA ELOISA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083102"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14987",
      "display" : "FARMACIA ABBATE S.N.C. DI LORENZO RESTIFO E ALESSANDRA TERESA SAG GIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083084"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "14993",
      "display" : "FARMACIA BRUNI CELIA DI GIOVANNI MARCO SCRIBANO & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15018",
      "display" : "FARMACIA LA FALCE SNC DELLA DR.ssa LA FALCE ROSSELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083089"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15039",
      "display" : "Spinnato Vega Dr. Alessandro Cannata",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083052"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15043",
      "display" : "Farmacia Germana' S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15068",
      "display" : "farmacia alma snc  di aliquo' a. e c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15141",
      "display" : "FARMACIA MOLLICA DI MOLLICA VINCENZO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083096"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15175",
      "display" : "ARENA FRANCESCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083055"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15204",
      "display" : "ANTICA FARMACIA MICHELANGELO DI COTTONE C., L. E P. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15222",
      "display" : "FARMACIA DI CARLO EPIFANIO E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082046"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15233",
      "display" : "Governanti F.p. E M.l. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082021"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15234",
      "display" : "MORREALE DIEGA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082070"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15251",
      "display" : "Cortegiani D.ssa Marina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15271",
      "display" : "Polizzotto Anthony",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082082"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15280",
      "display" : "Farmacia Micale dei Dott.ri La Porta Alberto e Alessandro snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15294",
      "display" : "Cassisi Salvatore",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082058"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15295",
      "display" : "D'Arrigo Antonina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082007"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15323",
      "display" : "Inglima Antonino & C. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15332",
      "display" : "Alioto Piero Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15337",
      "display" : "Farmacia Nuova Di dott Gullo Roberta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15345",
      "display" : "PRAINITO FARMACIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082013"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15359",
      "display" : "Farmacia Blesi Margherita e C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082002"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15361",
      "display" : "FARMACIA VIOLA RANDAZZO SNC DELLA DOTTORESSA VIOLA LOREDANA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082031"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15366",
      "display" : "Cali' Giovanni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082045"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15379",
      "display" : "Farmacia Re del Dott. G. Re & C. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15400",
      "display" : "FARMACIA DELLA FIERA DEL DR. GIUSEPPE RE & C. S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15412",
      "display" : "Antica Farmacia San Pietro S.A.S.  della Magica srl con socio unico & c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082021"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15415",
      "display" : "Cucchiara Carlo Alberto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15420",
      "display" : "Farmacia Viola snc della D.ssa Valeria Viola & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15458",
      "display" : "Del Duomo Dr.ssa A. Riccio e C. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082071"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15470",
      "display" : "839 Del Dr Lo Brutto Vittorio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082047"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15481",
      "display" : "Villa Serena Snc di La Rizza G.nni & F.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15490",
      "display" : "Farmacia Messina SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082028"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15495",
      "display" : "FARMACIA DEL VILLAGGIO DEL DOTT. SIMONETTI DOMENICO & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15505",
      "display" : "Vetro Domenico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15532",
      "display" : "farmacia NOTO di Marilisa Cannizzo srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088003"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15561",
      "display" : "FARMACIA CHIARA DI FERRARO CROCE ENRICO & FERRARO BRUNO MARIO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088012"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15592",
      "display" : "FARMACIA FAVARA SCATA' SNC DEI DOTTORI CLAUDIO E MARCO FAVARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089011"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15675",
      "display" : "Sangiorgio Giuseppe E C.  Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089006"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15729",
      "display" : "Farmacia Alberti di Antonella Alberti s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081009"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15732",
      "display" : "Oddo Filippo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081014"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "15802",
      "display" : "farmacia gallo antonino snc della dott.ssa Gallo Loredana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081003"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16039",
      "display" : "Farmacia Fadda & C. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091085"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16072",
      "display" : "Chessa-massidda Di Maria Giovanna Massidda Sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095018"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16104",
      "display" : "Urgu Daniela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095037"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16115",
      "display" : "Farmacia Todde Remo SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095043"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16126",
      "display" : "Concas Vanda",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095018"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16158",
      "display" : "FARMACIA GRANDESSO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092042"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16163",
      "display" : "Obino Di S. Obino E Borghero Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092024"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16176",
      "display" : "FARMACIA DR.SSA IRENE MURRU",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111094"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16193",
      "display" : "Farmacia Dell'Apa Di Maria Nicoletta E Angelo Aresu Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "107005"
        },
        {
          "code" : "provincia",
          "valueCode" : "107"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16197",
      "display" : "Farmacia Col Di Lana di Manuela Ghisu & C. Sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111035"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16240",
      "display" : "S. Antonio Pirastu-cozzoli Di Francesca Cozzoli & C. S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16270",
      "display" : "FARMACIA COIS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092011"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16298",
      "display" : "Nuti Andrea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092105"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16387",
      "display" : "PUCCI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011011"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16492",
      "display" : "RIBAUDO GIORGIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026009"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16575",
      "display" : "COMUNALE N.3 LATIGNANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050008"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16622",
      "display" : "COMUNALE S. ROCCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039011"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16632",
      "display" : "COMUNALE  FELINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035016"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16637",
      "display" : "COMUNALE N.3 RAVENNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16687",
      "display" : "COMUNALE 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099013"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16699",
      "display" : "Farmacia Comunale di Rimini n. 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16700",
      "display" : "Farmacia Comunale di Rimini n. 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16701",
      "display" : "Farmacia Comunale di Rimini n. 3",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16703",
      "display" : "Farmacia Comunale di Rimini n. 4",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16704",
      "display" : "Farmacia Comunale di Rimini n. 5",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16708",
      "display" : "COMUNALE N.4 RICCIONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099013"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16710",
      "display" : "Farmacia Comunale di Rimini n. 6",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16722",
      "display" : "Farmacia Misano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099005"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16758",
      "display" : "Farm. Comunale Paliano Amea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060046"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16777",
      "display" : "COMUNALE N.1 CENTRALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045003"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16789",
      "display" : "COMUNALE CASALE MARITTIMO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050006"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16808",
      "display" : "COMUNALE N.1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048010"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16809",
      "display" : "Farmacia Comunale 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048010"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16894",
      "display" : "COMUNALE RIPABELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050030"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "16948",
      "display" : "FARMACIA SANTA SOFIA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065037"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17035",
      "display" : "Farmacia Dott. Silvio Di Giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067030"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17065",
      "display" : "Farmacia Comunale di Villafranca Padovana s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028103"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17203",
      "display" : "Ghirardi Maddalena Esterina e C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017110"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17261",
      "display" : "Farmacia Galdiero della dott.ssa Valeria Galdiero s.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17313",
      "display" : "FARMACIA MASCIA DEI DOTT.RI MAURA E DINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063041"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17326",
      "display" : "Farmacia di Lardirago Dr Maggi Pier Carlo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018080"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17371",
      "display" : "LA FARMACIA DI ORIO DI NATURETIKA S.A.S. DEL DOTT. DARAIO ANDREA E  C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001172"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17672",
      "display" : "Dispensario Dr.ssa Mazzocchi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018179"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17702",
      "display" : "Farmacia Dubino srl di Bianchini Dr. Rocco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014027"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17759",
      "display" : "SUCCURSALE FARMACIA SAN GIORGIO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027034"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17774",
      "display" : "Monte San Giovanni SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037042"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17786",
      "display" : "FARMACIA SAVONUZZI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038006"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17903",
      "display" : "Farmacia Armungia del Dott. Alessio Coni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111002"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17905",
      "display" : "COMUNALE TAGLIATA SUCC.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039007"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17941",
      "display" : "FARMACIA PELAGIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071020"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17942",
      "display" : "SAN ROCCO Dr. De Notaris Vincenzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063041"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17943",
      "display" : "Farmacia Comunale Apm 5",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058065"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17948",
      "display" : "LIPPO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037009"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17951",
      "display" : "PROSPIANO DELLA DR.SSA CAIRONI ELISA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012079"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17956",
      "display" : "PALUMBO DEI DOTTORI SALVATORE PALUMBO E PALMA PALUMBO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071049"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17966",
      "display" : "FARMACIA GALLO  SAS DEL DOTT BIAGIO GALLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082014"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "17997",
      "display" : "FARMACIA SANT'EUFEMIA S.N.C. DELLA DOTTORESSA POLITANO CARLA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063016"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18012",
      "display" : "Monteriggioni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052016"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18026",
      "display" : "Farmacia Fornase' di Tivolesi Raffaele e C. snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015086"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18044",
      "display" : "Farmacia Santo Spirito srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028019"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18089",
      "display" : "FARMACIA USSIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013022"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18195",
      "display" : "Farmacia Comunale Nozzano Castello",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18220",
      "display" : "FARMACIA SAN PIO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071046"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18233",
      "display" : "Piuro Farmacia srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014050"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18239",
      "display" : "FARMACIA CORSI SAS DELLA DR.SSA RITA CORSI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058079"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18391",
      "display" : "Farmacia Comunale di Rimini N.7",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18392",
      "display" : "Sacripanti Maria Grazia srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059028"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18402",
      "display" : "Farmacia Califano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035038"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18452",
      "display" : "azienda speciale sirmione",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017179"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18601",
      "display" : "farmacia Fracassini S.A.S. della Dottoressa Maria Cristina Lorenzini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054015"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18602",
      "display" : "FARMACIA TRIPPETTA  SNC DI U. TRIPPETTA & C. - DISPENSARIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055021"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18627",
      "display" : "COMUNALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010046"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18697",
      "display" : "COMUNALE CARMIGNANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100002"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18760",
      "display" : "FARMACIA DEL VIALE DEI DOTTORI CLAUDIA PARRINO E  PAOLO PITITTO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087041"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18860",
      "display" : "Blunda srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048006"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18879",
      "display" : "FARMACIA FABBRI SAS Via Degli Olmetti 3/d",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058038"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18911",
      "display" : "COMUNALE - DR. BARBUI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016089"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18942",
      "display" : "farmacia cavallari srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014014"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "18975",
      "display" : "COMUNALE DI MISTERBIANCO D.SSA MARIA GRECO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087029"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19093",
      "display" : "San Paolo spa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046007"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19121",
      "display" : "DEVOTI TIZIANA & BAMBACE FRANCESCA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "007054"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19234",
      "display" : "FARMACIA CECCHINI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040007"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19281",
      "display" : "SAN ROCCO SNC DEI DR.I PIETRO PITTORE E LORENZO OSIMANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072027"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19331",
      "display" : "FARMACIA LE REGGIANE DELLA DOTT.SSA ANTONELLA ALBANESE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19335",
      "display" : "Farmacia del Duomo srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "047012"
        },
        {
          "code" : "provincia",
          "valueCode" : "047"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19484",
      "display" : "Farmacia Foro Boario S.r.l. Di Calderazzo Antonio Salvatore, Macrì Viviana,Scrimizzi Maria e Chindamo Antonino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035033"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19491",
      "display" : "Farmacia Colli Euganei della Dr.ssa Cesari Raffaella S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028057"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19497",
      "display" : "FARMACIA PIO X S.N.C. DEI DR. BERTIN R. E LAMON M.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028064"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19513",
      "display" : "Farmacia San Francesco dei Dottori Grosso, Ferraguto, Visaggio, Doronzo e Poli S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110002"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19523",
      "display" : "Farmacia Belvedere di A. Algieri e C. Dolce S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024104"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19535",
      "display" : "FARMACIA DEI FIORI S.N.C. DELLE DR.SSE LUGATO N. E GALLO E.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027038"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19589",
      "display" : "FARMACIA SAN BARTOLOMEO S.N.C. DELLEDOTT.SSE CAMILLA DAL BOSCO, DANIELA RIGONI E LUISA TOMAIN",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19618",
      "display" : "FARMACIA NUOVA MERLENGO S.A.S. DEI DOTTORI STEFANO ROSSO E ANDREA MERCANZIN &amp; C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026059"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19619",
      "display" : "FARMACIA AI SALICI SAS DELLA DR.SSA ANGELA DEL CAVALLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027024"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19626",
      "display" : "FARMACIA SAN MARCO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027021"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19633",
      "display" : "FARMACIA S.ANTONIO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "097083"
        },
        {
          "code" : "provincia",
          "valueCode" : "097"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19655",
      "display" : "Farmacia dei Popoli di M. Moffa e P. Nigro Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015175"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19672",
      "display" : "Farmacia Romito del Dott. Massimo Romito",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024012"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19680",
      "display" : "Farmacia Comunale di Rimini n.8",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19756",
      "display" : "Farmacia Bariola S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012034"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19765",
      "display" : "La Farmacia Di Comazzo sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098020"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19794",
      "display" : "Farmacia Mozart srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "021011"
        },
        {
          "code" : "provincia",
          "valueCode" : "021"
        },
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19936",
      "display" : "LAMA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063034"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19964",
      "display" : "NUOVA FARMACIAVIGNOLESE S.N.C. DI RUSSOANDREA E MASCELLO MAILA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036046"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "19987",
      "display" : "FARMACIA PAPA DOMENICO S.A..S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063034"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20024",
      "display" : "Farmacia Nuova S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081024"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20044",
      "display" : "Farmacia Semini S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087011"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20110",
      "display" : "Farmacia Pittulongu",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090047"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20153",
      "display" : "FARMACIA SAN GIUSEPPE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015024"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20217",
      "display" : "FARMACIA COLMELLO SNC DELLE DOTT.SSE CHIARA CESTARO E CHIARA ZANATTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027020"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20229",
      "display" : "NUOVA PALIKE' SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087032"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20336",
      "display" : "Farmacia San Rocco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015070"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20393",
      "display" : "FARMACIA LE MAGNOLIE DELLA DOTTORESSA TOTO ANGELA & FIGLI S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20469",
      "display" : "FARMACIA BENESSERE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015184"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "20583",
      "display" : "Farmacia Corrada srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108044"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-07-01"
        }
      ]
    },
    {
      "code" : "009",
      "display" : "DEL MONUMENTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "021",
      "display" : "FARMACIA SAN CARLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "038",
      "display" : "FARMACIA SAN SALVARIO S.A.S. DEI DOTTORI FREGONARA MARCO MARIA PIO E TRECCO ELENA SIGLABILE FARMACIA SAN SALVARIO S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "063",
      "display" : "DEL LEONE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "065",
      "display" : "DELLE MOLINETTE S.A.S. DI QUAGLIA MARIO E RAVIZZA DORIS & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "072",
      "display" : "SAN DARIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "109",
      "display" : "S.EMILIO DI BRUNA ROSSO DARIO MARIA e C.-SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "129",
      "display" : "FARMACIA SAN MARINO DI FARMACIA SAN GIACOMO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "147",
      "display" : "SAN GIORGIO S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "173",
      "display" : "Santa Zita s.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "191",
      "display" : "Farmacia Parella Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "203",
      "display" : "SANSOVINO DI NICOSIA DOTT. ALESSANDRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "226",
      "display" : "BREGLIO DI BRACCIO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "239",
      "display" : "DON BOSCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "247",
      "display" : "SANTA GIULIA DI SERRA DOTT. G. E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "275",
      "display" : "FARMACIA SANTA CROCE DI INTRE SAS DI PIOVANO ALBERTO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "337",
      "display" : "SAN CARLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001241"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "346",
      "display" : "COMUNALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001022"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "349",
      "display" : "TINTINELLI ROMANO DI TINTINELLI MARCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001259"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "359",
      "display" : "ROSSI SNC DI ROSSI PAOLO E SILVIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001032"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "390",
      "display" : "Farmacia Santa Caterina di Impresa s.a.s. di Mazzoleni Federica e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001221"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "398",
      "display" : "Farmacia Paschero della Dottoressa Turinetti Paola",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001166"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "399",
      "display" : "FARMACIA SANT'ANDREA della dr.ssa FRESCURA Loredana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001028"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "436",
      "display" : "FARMACIA DELL'OSPEDALE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001130"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "468",
      "display" : "SAROGLIA snc di Saroglia Pierfranco and C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001034"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "515",
      "display" : "Premi del dott. Premi Emanuele",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001156"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "519",
      "display" : "CERIANA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001156"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "530",
      "display" : "DE GRAZIA DI FABRIZIA ACTIS DATO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001156"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "544",
      "display" : "FARMACIA MORETTO CHIMICA SAS della dott.ssa MORETTO Eugenia e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001168"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "554",
      "display" : "FARMACIA BERTOTTI snc  di Dr.ssa Bertotti Silvia e Dr.ssa Bertotti Chiara",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001098"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "579",
      "display" : "MAZZINI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001066"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "608",
      "display" : "SANT'ANNA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001246"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "612",
      "display" : "Santa Marta SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001304"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "619",
      "display" : "TRON Dott. ANDREA GARRONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001242"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "628",
      "display" : "FARMACIA VASARIO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001139"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "639",
      "display" : "MELLANO SNC DI LORENZO, SABRINA E FRANCESCO MELLANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001254"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "643",
      "display" : "BRICCO snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001191"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "819",
      "display" : "FARMACIA MONTICELLO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "096035"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "966",
      "display" : "Farmacia Calderara Donatella & C. S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003076"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "974",
      "display" : "GENTILE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003055"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1095",
      "display" : "CHIERA DEL DR. VUCUSA GIUSEPPE E C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004110"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1119",
      "display" : "Farmacia Porta di Breo S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004130"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1214",
      "display" : "CRAVERO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004029"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1272",
      "display" : "NUOVA FARMACIA SAN PIETRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005005"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1433",
      "display" : "ILLENGO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006179"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1450",
      "display" : "FARMACIA MOCCAGATTA DELLA DOTT.SSA INNOCENZA MOCCAGATTA & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006173"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1484",
      "display" : "FARMACIA MOCCAGATTA S.A.S. DI LUCIANA MOCCAGATTA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006012"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1488",
      "display" : "FARMACIA ALBERA CABELLA DELLE DOTT.SSE BELFORTE SERAFINA E ODINO ELISABETTA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006148"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1498",
      "display" : "Farmacia del Santuario di Fossa Adriano & c. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006111"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1503",
      "display" : "FARMACIA CIGNOLI DI CIGNOLI TERESIO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006001"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1599",
      "display" : "Boccaleone",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1600",
      "display" : "FARMACIA S.PAOLO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016016"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1640",
      "display" : "dr max osiosotto camozzi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016153"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1663",
      "display" : "FARMACIA AL CASTELLO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016154"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1714",
      "display" : "GRIECO CARLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016155"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1741",
      "display" : "FARMACIA DI PIAZZA BREMBANA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016164"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1763",
      "display" : "CASTELLI ANGELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016084"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1779",
      "display" : "TALEGGIO DR.SSA TERESA ARTILLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016210"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1807",
      "display" : "Mazzucchelli S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017043"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "1997",
      "display" : "Farmacia Colosini Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017195"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2080",
      "display" : "Farmacia Lanzetti Dr. Andrea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013075"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2144",
      "display" : "GERLI DI TOMASO GERLI & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013242"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2156",
      "display" : "FARMACIA SONVICO DI ANNA MOLTENI E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013041"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2216",
      "display" : "SANTA TERESA ONOFRIO EVA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013134"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2227",
      "display" : "FARMACIA BONISOLI ALQUATI SNC DI BONISOLI ALQUATI CLAUDIA E ROBERTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019021"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2247",
      "display" : "Cooperativa sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019098"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2252",
      "display" : "ZAMBIASI PAOLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019109"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2261",
      "display" : "FARMACIA MELEGARI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019050"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2301",
      "display" : "FARMACIA SINELLI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019074"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2382",
      "display" : "SAN FRANCESCO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "097048"
        },
        {
          "code" : "provincia",
          "valueCode" : "097"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2409",
      "display" : "BARBIERI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098031"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2425",
      "display" : "SCARAMUZZA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098046"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2427",
      "display" : "FARMACIA ASTI SAS DI ASTI STEFANO E C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098045"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2444",
      "display" : "FARMACIA CASTELNUOVO  SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098013"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2519",
      "display" : "FARMACIA CAPRIOLI S.A.S. DI DUGARIA DOTTORESSA ZARA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020025"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2644",
      "display" : "dott.ssa daniela mattalia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2658",
      "display" : "Farmacia Sanitas SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2662",
      "display" : "Farmacia Viale Romagna srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2679",
      "display" : "FARMACIA BERTOLINI SAS DELLA DOTT.SSA BERTOLINI ISABELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2756",
      "display" : "DR.MAX ITALIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2818",
      "display" : "FARMA BONOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2852",
      "display" : "MONTAGNA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2855",
      "display" : "FARMACIA CASSIODORO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2872",
      "display" : "FARMACIA FUSCO SAS DI MONTAGNANI -MARELLI DOTT.ROSSELLA &C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2920",
      "display" : "FARMACIA CHIESA ROSSA SAS DI NORBERTO LUMINI & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2975",
      "display" : "farmacia del corso srl unipersonale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "2980",
      "display" : "FARMACIA OVIDIO S.N.C. DI GEROSA CLAUDIO E CHIARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3027",
      "display" : "ARMANDOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015096"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3078",
      "display" : "PAMBIERI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015005"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3084",
      "display" : "LUCE SIMONATTI SAS DELLA DOTT.SSA MUNARO ALESSANDRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015118"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3113",
      "display" : "FARMACIA ZINGONE SNC DI CONSUELO E ROSSELLA NANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015220"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3118",
      "display" : "CORNELIANI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015093"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3139",
      "display" : "Farmacia Zorzi srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015002"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3152",
      "display" : "Santagostino SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015011"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3209",
      "display" : "FARMACIA GHIRARDELLI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015168"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3221",
      "display" : "FARMACIA S. ADRIANO S.N.C. DEL DOTT. CAMERA CAMILLO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015024"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3245",
      "display" : "FARMACIA COMUNALE PAULLO FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015169"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3265",
      "display" : "FARMACIA COMUNALE DI VIZZOLO PREDABISSI FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015244"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3291",
      "display" : "FARMACIA COMUNALE N. 3 DI PIOLTELLO FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015175"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3308",
      "display" : "FARMACIA COMUNALE DI VIGNATE FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015237"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3343",
      "display" : "CENTRALE Gusmani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108019"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3432",
      "display" : "Farmacia Ravasi Dott.Carlo Alberto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108023"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3439",
      "display" : "FARMACIA RONDINELLA SNC DEL DR. GIORGIO PORRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015209"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3519",
      "display" : "DEI MILLE SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108012"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3537",
      "display" : "FARMACIA ALLA MADONNA S.A.S. - DR. PAOLO VINTANI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108005"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3626",
      "display" : "Farmacia Moroni della dott.ssa Antonella Pasetti & C. sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018182"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3632",
      "display" : "FARMACIA CROCE DI DOTT.SSA PASOTTI MARGHERITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018038"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3659",
      "display" : "Farmacia Morelli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018131"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3682",
      "display" : "RAVAZZANI SNC DI ARRIGONI ANDREA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018146"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3693",
      "display" : "POZZOLI DI D. DONATI & C SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018176"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3758",
      "display" : "FARMACIE EDELWEISS S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014012"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3766",
      "display" : "CAPRA SNC DI CAPRA GIULIA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014013"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3780",
      "display" : "Farmacia Dr.ssa Marisa Gusmeroli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014044"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3782",
      "display" : "FARMACIA SAN MARTINO  S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014066"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3791",
      "display" : "ROMOLI DI ROMOLI LUIGI & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014078"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3796",
      "display" : "FARMACIA LEGNANI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014045"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3936",
      "display" : "NOBILI DI DOTT. LUISA E GABRIELE NOBILI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012048"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "3993",
      "display" : "AZIENDA SPECIALE MULTISERVIZI GERENZANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012075"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4031",
      "display" : "GHEZA  SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017007"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4080",
      "display" : "BUSELLATO SNC DI BUSELLATO FRANCESCO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "021008"
        },
        {
          "code" : "provincia",
          "valueCode" : "021"
        },
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4259",
      "display" : "FARMACIA CHINAGLIA DOTT.SSA MONICA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022124"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4358",
      "display" : "ALL'OSPEDALE DI LAGO STEFANIA ANNA MARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024012"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4399",
      "display" : "FARMACIA SARTORI AI DUE GIGLI SNC DI SARTORI DOTT FRANCESCO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024014"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4464",
      "display" : "PAGANI ROBERTO del DR. ROBERTO PAGANI & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024060"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4503",
      "display" : "Lafarmacia.Grisignano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024046"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4706",
      "display" : "FARMACIA FANOLI AL LEON D'ORO SAS DELLA DOTT.SSA CARBONCINI LAURA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026086"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4939",
      "display" : "FARMACIA CASALICCHIO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027003"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4969",
      "display" : "Gruppo Starfarma S..r.l.farmacia al duomo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027006"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4970",
      "display" : "SAN PIETRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027006"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "4978",
      "display" : "AL MARE S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027008"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5027",
      "display" : "CIRILLI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028091"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5085",
      "display" : "PICCINALI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028085"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5095",
      "display" : "LAFARMACIA.SACRA FAMIGLIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5104",
      "display" : "Lafarmacia.Meltias srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028069"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5137",
      "display" : "FARMACIA PORTAVECCHIA S.N.C. ZANCHIN SERGIO, MORENO, ROBERTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028037"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5179",
      "display" : "NUOVA S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028010"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5547",
      "display" : "MADONNA DI BARBANA DELLA DR.SSA FABIA LEDRI & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "031009"
        },
        {
          "code" : "provincia",
          "valueCode" : "031"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5667",
      "display" : "FARMACIA PRESSACCO DI DE RE CHIARA & C S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030039"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5676",
      "display" : "FARMACIA MARESCHI DEL DR. SIVILOTTI STEFANO & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030099"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5721",
      "display" : "FARMACIA GODEAS SAS DEL DOTT. GODEAS ALESSANDRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030097"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5730",
      "display" : "FARMACIA SABBIADORO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030049"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5731",
      "display" : "FARMACIA SABBIADORO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030049"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5734",
      "display" : "GERGOLET",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030008"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5871",
      "display" : "ZITOMIRSKI DI POGGIO PAOLA & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008063"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5897",
      "display" : "FARMACIA INTERNAZIONALE COSTARAINERA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008024"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5901",
      "display" : "CIPRESSA DI COSTA LUISA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008021"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "5978",
      "display" : "DELLA CONCORDIA DI ZANELLO PAOLO & C. S..a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009015"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6036",
      "display" : "Farmacia Burlando di Pedrini Alessandro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6084",
      "display" : "FARMACIA DELLA MADONNINA CASTELLETTO SAS di R.Cerruti & Figli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6147",
      "display" : "Zerega",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6228",
      "display" : "Farmacia Mele di Atlantis snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010033"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6262",
      "display" : "DELLA MADONNINA CASTELLETTO SAS DI R. CERRUTI E FIGLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6366",
      "display" : "FRAMURA DI CROCI SETTIMO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011014"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6416",
      "display" : "FARMACIA Dott. CARLO BOSSI srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033014"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6430",
      "display" : "CORVI GIANNI DI CORVI DINA E LETIZIA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6446",
      "display" : "FARMACIA MERIGHI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033024"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6449",
      "display" : "Farmacia Bertuzzi della dr.ssa Bertuzzi Francesca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6452",
      "display" : "FARMACIA BONGIORNI DI DR. BONGIORNI PIERGIULIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033045"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6457",
      "display" : "FARMACIA CENTRALE Parmigiani Daniela e Stefania S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6467",
      "display" : "SCARAMUZZA DR. DANILO & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033020"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6471",
      "display" : "TIRELLI di Dott.ssa Alessandra Bronzoni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033011"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6495",
      "display" : "SAN POLO DI DEENOVA FARMACIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033035"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6516",
      "display" : "CAVOUR SRL SOCIO UNICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034014"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6541",
      "display" : "FARMACIA PILASTRO DI PELLACINI CINZIA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034018"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6638",
      "display" : "Farmacia Manfredi di Tondelli Marco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035016"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6646",
      "display" : "FARMACIA ZUCCARDI MERLI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035020"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6675",
      "display" : "FARMACIA CREMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035035"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6698",
      "display" : "Calerno Sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035039"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6741",
      "display" : "BERGAMINI FABIO E FILIPPO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036020"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6810",
      "display" : "Farmacia Magno",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036006"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6867",
      "display" : "DELLA CICOGNA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037054"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6877",
      "display" : "DELLA ROCCHETTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037031"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6906",
      "display" : "GHIRONDA - VENTURELLI DOTT. LUCA & ANDREA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037060"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6924",
      "display" : "DELLA VIA APPIA - INIZIATIVE FARMACIA CELADON SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037032"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6956",
      "display" : "PALTRINIERI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037008"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "6985",
      "display" : "dal contavalli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7046",
      "display" : "DELLA BARCA SAS BABINI DOTT. GIULIO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7061",
      "display" : "DI CASARALTA - CANTAGALLI DR.SSA CARLA E ZUCCOLI DR. MARCO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7069",
      "display" : "DE PISIS DELLA DOTT.SSA MALDARELLI ANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7140",
      "display" : "FARMACIE PASQUALI DELLA DOTT.SSA MARIA LUISA PASQUALI E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038024"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7150",
      "display" : "VIRIGLIO ALFONSO DI VIRIGLIO G & G SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038015"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7182",
      "display" : "SANTA CHIARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038004"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7206",
      "display" : "ANTICA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7208",
      "display" : "Mezzano di Reale del dr. Alberto Ferrante e C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7253",
      "display" : "FARMACIA DI BARBIANO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039009"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7256",
      "display" : "SANTA RITA DI PICCININI RITA,SGARBI GIOVANNI E VISTOLI PIERANTONIO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039001"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7290",
      "display" : "farmacia lombardi snc del dott.claudio lombardi e c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040012"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7317",
      "display" : "DELLE FONTI  SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040003"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7373",
      "display" : "FARMACIA OLIVI DI OLIVI LAURETTA E SAVELLI PAOLO S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099001"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7396",
      "display" : "VALLESI DI ELENA FOCCHI e GIOVANNI COLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7478",
      "display" : "LUIGI PATRIZIA & C. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045009"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7661",
      "display" : "FARMACIA DI IOLO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100005"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7709",
      "display" : "FRB FARMACIA DI FRANCA RICCI & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050040"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7733",
      "display" : "Farmacia Dinucci Pallone Dott.ssa Papi Lisa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7774",
      "display" : "Farmacia Sassetta del Dr. E. Ronco  & C. sas SUCCURSALE ESTIVA di Lacona Capoliveri",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049004"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7782",
      "display" : "Farmacia Pierini srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049008"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7786",
      "display" : "ATTIAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049009"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7798",
      "display" : "FERRARI DELLA DR.SSA BELOTTI FRANCESCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049009"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7834",
      "display" : "Centrale Di Fusi Vinicio & C. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049014"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7944",
      "display" : "FARMACIA DELLA SS. ANNUNZIATA DI DUCCI ANDREA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7950",
      "display" : "FARMACIA SCORTECCI SNC DI SCORTECCI IDETTA E BURICCHI T.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7958",
      "display" : "FARMACIA DELLA CHIMERA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "7990",
      "display" : "FARMACIA RUBINO SAS DELLA DOTT.SSA LUCIA RUBINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051018"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8045",
      "display" : "COMUNALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053009"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8109",
      "display" : "ANTICA FARMACIA DI SORANO S.A.S. DEL DOTT. SIMONE BRIGNALI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053026"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8137",
      "display" : "FARMACIA PERNA DEI DOTTORI MATTEO E MARIA LUISA PERNA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048015"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8178",
      "display" : "ROMA UNIVERSALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8253",
      "display" : "FARMACIA DI PELAGO DEL DR. VANNI CAMPO E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048032"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8277",
      "display" : "Farmacia DI RIMAGGIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048043"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8278",
      "display" : "Farmacia NOVA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048043"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8288",
      "display" : "MEDRI  SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048008"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8298",
      "display" : "Farmacia Amenta della D.ssa Emanuela Amenta e C. S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048014"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8379",
      "display" : "LA TINA DI ORTALLI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054013"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8385",
      "display" : "ANTICA FARMACIA CECCARELLI SAS DI CECCARELLI ALESSANDRA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054024"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8388",
      "display" : "Farmacia Eredi Cristini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054044"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8392",
      "display" : "EREDI DR.POLVERINI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054044"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8427",
      "display" : "FARMACIA CARBONI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054020"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8457",
      "display" : "FARMACIA COZZARI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8467",
      "display" : "FARMACIA BALDASSARRI S.N.C. DI BURATTA CLAUDIA E ANGELA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054055"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8469",
      "display" : "FALINI M. RITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054001"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8473",
      "display" : "PALLANTE SNC DELLA DOTT.SSA ANNA PALLANTE & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8510",
      "display" : "FARMACIE PEPPOLONI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054018"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8515",
      "display" : "FARCHIONI SNC GESTIONE FARM. COMUNALE GIANO DELL'UMBRIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054021"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8521",
      "display" : "FARMACIA CENTRALE NORCIA S.R.L. DI SERENA BASILI E VALENTINA FALCINELLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054035"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8532",
      "display" : "MARCHESE SNC DI GIOVANNA MARIA MARCHESE E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054051"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8537",
      "display" : "Bartocci Alessandro",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054051"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8573",
      "display" : "FARMACIA NADALINI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8585",
      "display" : "FARMASOCIOSANITARIA LUGNANO IN TEVERINA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055016"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8586",
      "display" : "ALBERTI DAL 1926 S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055022"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8627",
      "display" : "FARMACIA TICCHI SNC DI MARINA E GIAMPIERO TICCHI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041020"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8648",
      "display" : "ZONGO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041044"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "8831",
      "display" : "FARMACIA DUBBINI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042002"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9084",
      "display" : "ENORFARM di Enei Orsola e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9091",
      "display" : "SEVERI SILVESTRINI CORRADO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9130",
      "display" : "FARMACIA PINCHETTI SNC DEL DOTT MARCO PINCHETTI E FIGLIE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9134",
      "display" : "Farmacia Pianesi S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9143",
      "display" : "farmacia la lucchina della dottoressa maria grazia albo e Co S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9146",
      "display" : "FARMACIA WALL SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9205",
      "display" : "farmacie savelli srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9214",
      "display" : "ANTICA FARMACIA SANTA MARIA DELLA SCALA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9240",
      "display" : "FARMACIA PIRAMIDE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9244",
      "display" : "TOTINO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9292",
      "display" : "Farmacia Dott. Angelo Greco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9373",
      "display" : "RIGGIO GIUSEPPINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9382",
      "display" : "MED CARE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9505",
      "display" : "FARMACIA IRPINA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9605",
      "display" : "FARMACIA CIANCI SAS DEL DR. LUIGI CIANCI & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9665",
      "display" : "DEI QURITI DI EMILIA BERNOCCHI E C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9687",
      "display" : "farmacie savelli srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9706",
      "display" : "ANNA CAMPO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9725",
      "display" : "Cellulosa Srl Unipersonale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "9861",
      "display" : "FARMACIA MASTROMATTEO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058020"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10063",
      "display" : "Farmacia Rossi srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10065",
      "display" : "FARMACIA CASALI SAS DEL DR. EDOARDO CASALI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056026"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10073",
      "display" : "FARMACIA MORERA SNC DEI DR.RI ANTONIO E LUDOVICA MORERA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056014"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10104",
      "display" : "FARMACIA DEL PILASTRO S.A.S. DELLA DOTT.SSA PATRIZIA PUCCI E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056059"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10138",
      "display" : "CIUCCI DOTT.SSA CECCARINI VALENTINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056029"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10239",
      "display" : "FARMACIA ZARDO SAS DELLA DR.SSA MARIA CRISTINA ZARDO & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059032"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10274",
      "display" : "FARMACIA INTERNAZIONALE DI IACOVACCI CRISTINA & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10285",
      "display" : "FARMACIA ZIZZI SAS DEL DR. GIANCARLO ZIZZI & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059032"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10291",
      "display" : "DURANTE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059014"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10535",
      "display" : "Falcione Ivonne",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066005"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10697",
      "display" : "FARMACIA GANGEMI sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069047"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10818",
      "display" : "EREDI DI MIGNELLA ROBERTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068042"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "10843",
      "display" : "D'AMARIO MARGHERITA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068011"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11018",
      "display" : "farmacia Cipolla S.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070006"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11213",
      "display" : "FARMACIA SANTULLI S.A.S. DELLA DOTT.SSA SANTULLI CHIARA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064054"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11298",
      "display" : "Varrella Floriano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062048"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11396",
      "display" : "FARMACIA FERRARO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061048"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11428",
      "display" : "FARMACIA MESSINA S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061063"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11479",
      "display" : "FARMACIA DEL ROSARIO DOTT. ZACCHIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061088"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11587",
      "display" : "FARMACIE INTERNAZIONALI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11625",
      "display" : "FARMACIE INTERNAZIONALI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11642",
      "display" : "FARMACIE INTERNAZIONALI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11682",
      "display" : "FARMACIA RUGGIERO SRL UNIPERSONALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11741",
      "display" : "FARMACIA MIANO DELLA DR.SSA EVA DE ANGELIS S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "11883",
      "display" : "LA MARCA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063060"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12002",
      "display" : "FARMACIA ROMANO SNC DEL DOTTOR LUCA ROMANO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063057"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12037",
      "display" : "FARMACIE BARTOLOMEO DE IURI SAS DI BARTOLOMEO DE IURI DOMENICO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063089"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12103",
      "display" : "DR MAX ERCOLANO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063064"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12104",
      "display" : "FARMACIA CAMPOLIETO DEL DOTT.CALABRESE ANDREA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063064"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12130",
      "display" : "DR MAX TORRE ANNUNZIATA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063083"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12135",
      "display" : "DR MAX TORRE ANNUNZIATA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063083"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12210",
      "display" : "Farmacia Criscuolo srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12245",
      "display" : "Farmacia Savino Vastola srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065132"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12248",
      "display" : "Farmacia Angelina Lamberti s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065079"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12372",
      "display" : "FARMAGRISI srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065043"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12528",
      "display" : "FARMACIA SAVINO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110006"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12615",
      "display" : "SOC. FARM. EGIDI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072029"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12621",
      "display" : "FARMACIA CHIERICO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072004"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12638",
      "display" : "FARMACIE MODUGNO SNC DEI DOTTORI VINCENZO E FRANCESCO PAOLO MODUGNO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072024"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12670",
      "display" : "CALABRESE DI FRANCESCO E LUCIANO BABIS COROPULIS SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12742",
      "display" : "DEL POPOLO SNC DOTTORI VITO E MICHELE TATEO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072037"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12774",
      "display" : "FARMACIA REGATTIERI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12791",
      "display" : "Farmacia Sciannameo Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072032"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12917",
      "display" : "DE VITO SAS DEL DR. FABIO DE VITO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074017"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12956",
      "display" : "SINISCALCHI 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071008"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12957",
      "display" : "Siniscalchi 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071008"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "12971",
      "display" : "GUERRIERI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071047"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13061",
      "display" : "FARMACIA DICARO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13088",
      "display" : "San Francesco snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071011"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13110",
      "display" : "CATALANO SECONDINO DI CATALANO CARMEN & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071058"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13171",
      "display" : "FARMACIA PORTALURI & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075022"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13180",
      "display" : "4.147480752E9",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075037"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13181",
      "display" : "Martina D.ssa Maria Margiotta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13222",
      "display" : "FARMACIA GABRIELI S.A.S. DEL DR. LUIGI MARIA GABRIELI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075010"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13295",
      "display" : "FARMACIA NICOLARDI DI AMOROSO WANDA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075002"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13297",
      "display" : "Farmacia Notaro snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075024"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13322",
      "display" : "FARMACIA CASCIARO-MARIGLIANO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075081"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13327",
      "display" : "SAN GIOVANNI FARMACIA DEL DOTTOR CASCIARO CLAUDIO & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075016"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13464",
      "display" : "FARMACIA BAGNUOLI SAS DI FABRIZIO BAGNUOLI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13677",
      "display" : "FARMACIA A. LO FRANCO S.A.S. DELLA DOTT.SSA ANTONIETTA LO FRANCO & C . s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "077020"
        },
        {
          "code" : "provincia",
          "valueCode" : "077"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13746",
      "display" : "CORRADO DOTT.SSA ALIDA CORRADO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078054"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13757",
      "display" : "GIANNONI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078033"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13852",
      "display" : "Farmacia dei Bruzi SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13897",
      "display" : "FARMACIA ROSANO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078050"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "13936",
      "display" : "AIELLO DELLA DOTT.SSA CHIARINA AIELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078045"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "14058",
      "display" : "FARMACIA BARBALACE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "14077",
      "display" : "FARMACIA BARBALACE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079023"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "14422",
      "display" : "Foti Dr. Cosimo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080080"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "14578",
      "display" : "Celestri Della Dr.ssa Rosalia Taranto & C. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085003"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "14590",
      "display" : "MADRICE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085018"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "14643",
      "display" : "FARMACIA GALENO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087028"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "14803",
      "display" : "Famacia Ballaro' Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087040"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "14810",
      "display" : "Farmacia Castro Mario",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087033"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "14956",
      "display" : "Persico Giovanni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086009"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15001",
      "display" : "FARMACIA DOTT. VECE DI VECE PIETRO E. C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083049"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15013",
      "display" : "Farmacia Dott. Giovanni Flaccomio S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083005"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15046",
      "display" : "Farmacia Bombara sas di Giusepe Bombara & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083029"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15056",
      "display" : "Farmacia Baratta Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15107",
      "display" : "FARMACIA ELISIR DI ROSA DELLA MACCHIA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083098"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15149",
      "display" : "Farmacia Dott. Vece s.n.c. del dott. Pietro vece & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083049"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15154",
      "display" : "RIVETTI NADIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083075"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15163",
      "display" : "Farmacia Bombara sas di Giuseppe Bombara & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083044"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15172",
      "display" : "Farmacia British Pharmacy srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083097"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15205",
      "display" : "FARMACIA ARIOSTO SNC DELLA DOTT.SSA D'ALESSANDRO &C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15308",
      "display" : "FARMACIA SANT'ANTONIO SNC DEL DR FRANCESCO LO CASCIO E C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082050"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15311",
      "display" : "Tripi Del Dr. Francesco Miraglia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15365",
      "display" : "FARMACIA MAYMONE S.a.S DI ANGELO GIOVANNI LEONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15467",
      "display" : "FARMACIA CLEMENTE DEI DOTTORI CLEMENTE FRANCESCO E LUCIANO, EMMANUELLO CONSUELA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15479",
      "display" : "FARMACIA SAN MICHELES.N.C. DEI DOTT.ALESSANDRA PIPI ED'ALESSANDRO DAVIDE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15482",
      "display" : "Farmacia Liotta dott.ssa Alessandra & c s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15582",
      "display" : "Battaglini D. / Dr. Passanisi O.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089001"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15600",
      "display" : "FARMACIA NICASTRO S.N.C. DI NICASTRO LUCA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089002"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15748",
      "display" : "Farmacia Di Martino S.n.c. del Dr. Giuseppe Di Martino e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081011"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15776",
      "display" : "Gagliano Rosaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081006"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15827",
      "display" : "OFFISANA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15886",
      "display" : "Farmacia Pinna S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090057"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "15998",
      "display" : "FARMACIA EREDI CAPPAI DI TARAS MARCELLA ANNA E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091010"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16006",
      "display" : "Farmacia Puligheddu Franca s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091055"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16033",
      "display" : "Farmacia Fancello del Dottor Manuel Fancello & C. S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091017"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16150",
      "display" : "newco san gavino srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "106014"
        },
        {
          "code" : "provincia",
          "valueCode" : "106"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16159",
      "display" : "San Pietro Di Maria Adelaide Murru & C. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "106015"
        },
        {
          "code" : "provincia",
          "valueCode" : "106"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16160",
      "display" : "Farmacia Sundas di Elio Sundas & C. Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111075"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16187",
      "display" : "Farmacia Meloni Ortacesus  S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092044"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16204",
      "display" : "Farmacia S: Barbara S.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111035"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16248",
      "display" : "Farmacia Petromilli Cagliari snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16294",
      "display" : "Farmacia Enzo Rizzo Della Dott.ssa Claudia Rizzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16304",
      "display" : "Farmacia Mocci srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092074"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "16466",
      "display" : "FARMACIA ARTHEMALLE S.N.C. DI ARTHEMALLE MASSIMILIANO E ARTHEMALLE CARLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111086"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17039",
      "display" : "COMUNALE PESCASSEROLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066068"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17076",
      "display" : "ROMANO ARIETTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063079"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17077",
      "display" : "FARMACIA VERZE S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063021"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17095",
      "display" : "EREDI LIBERTI FRANCESCA SDF",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063005"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17178",
      "display" : "FARMACIA COMUNALE DI PESSANO CON BORNAGO FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015172"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17191",
      "display" : "FARMACIA PONTE DEL GIGLIO S.R.L",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17292",
      "display" : "FARMACIA COMUNALE DI ALBIGNANO FAR.COM SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015224"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17667",
      "display" : "FARMACIA COMUNALE DI TRECELLA FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015178"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17788",
      "display" : "ANTICA FARMACIA SUCCURSALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17811",
      "display" : "Farmacia Eredi Cristini Dispensario",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054044"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17817",
      "display" : "DISPENSARIO FARMACIA BARTOLI MONTEFALCO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054030"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17888",
      "display" : "Farmacia Caruso Rosa Maria & C. s.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087005"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17969",
      "display" : "SAN ROCCO DI E. STRAZIOTA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072030"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "17986",
      "display" : "farmacia serrati srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071029"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18050",
      "display" : "MALUVIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063060"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18137",
      "display" : "UNTERKIRCHER GUENTHER",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "021107"
        },
        {
          "code" : "provincia",
          "valueCode" : "021"
        },
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18158",
      "display" : "FARMACIA DR.MAX San Bartolomeo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108007"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18253",
      "display" : "Farmacia Il Caduceo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024055"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18308",
      "display" : "Farmacia Battista",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027024"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18350",
      "display" : "Farmacia Bassini",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015015"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18431",
      "display" : "GRAVINA MARIA ANTONIETTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071046"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18463",
      "display" : "FARMACIA COMUNALE CAPRIATE SAN GERVASIO FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016051"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18508",
      "display" : "SANTA MARIA DELLA DR.SSA MELONI LAURA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111096"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18535",
      "display" : "FARMACIA COMUNALE DI GESSATE FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015106"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18537",
      "display" : "Farmacia di Medea sas del dr Samuele Secchiero",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "031011"
        },
        {
          "code" : "provincia",
          "valueCode" : "031"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18673",
      "display" : "CIRILLI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028072"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18688",
      "display" : "FARMACIA COMUNALE DI POZZO D'ADDA FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015177"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18717",
      "display" : "BOSCO DI FB PHARMA SAS DI BOSCO MICHELA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001158"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18721",
      "display" : "Dei Portici di Laura e Annalisa Cardillo & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087041"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18796",
      "display" : "Farmacia Marginone S.a.s. della Dott.ssa Adriana Ercolani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046001"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18836",
      "display" : "FARMACIA ALL'IMMACOLATA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024119"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18886",
      "display" : "COMUNALE 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016183"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18925",
      "display" : "FARMACIA COMUNALE DI CERRO AL LAMBRO FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015071"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18939",
      "display" : "COMUNALE - DR.SSA AGOSTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016213"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "18981",
      "display" : "DISPENSARIO FARMACIA DOTT.SSA MARINO MARIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065009"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "4"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19078",
      "display" : "Dell'Osmannoro SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048043"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19117",
      "display" : "FARMACIA COMUNALE DI VAPRIO D'ADDA FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015230"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19265",
      "display" : "Farmacia Biccari S.A.S. Della Dottoressa Della Vista Annalise",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071024"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19283",
      "display" : "FARMACIA COMUNALE DI PANTIGLIATE FAR.COM. SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015167"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19313",
      "display" : "NUOVA CASALGRANDE ALTO SNC DI BARTOLI RAFFAELE E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035012"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19359",
      "display" : "Terre D'Acqua Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037053"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19394",
      "display" : "FARMACIA SAN PAOLO DI ANNA MARIA MUSSO E CONSUELO COLUSSI S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030062"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19465",
      "display" : "Farmacia Togliatti S.n.c. Di Carminio Gambacorta E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19551",
      "display" : "Farmacia San Francesco S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040007"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19605",
      "display" : "Farmacia Santa Maria della Dr.ssa Maria Grazia Polimeni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015168"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19615",
      "display" : "Farmacia Igea di Massari Raffaella e Massari Gemma snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073006"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19625",
      "display" : "Farmacia Della Corte",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015027"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19889",
      "display" : "Farmacia Sant'Alessandro S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016117"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "19968",
      "display" : "FARMACIA SANTERAMO - S.N.C. DELLA FARMACIA ANDRIULLI S.A.S. DI NI COLA ANDRIULLI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072004"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "20274",
      "display" : "Farmacia Dei Mille  SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "20294",
      "display" : "Farmacia del Poggio ArCa Farma s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085004"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "20313",
      "display" : "FARMACIA DI CONCESA DELLA DR.SSA C. PIROLA & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015221"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "20599",
      "display" : "Farmacia Comunale S.Lucia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "20617",
      "display" : "FARMAGRISI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065043"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "21036",
      "display" : "Farmacia Artemisia s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087024"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "21037",
      "display" : "VERNILE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060074"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "21038",
      "display" : "FARMACIA PAPA GIOVANNI BELMONTE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082009"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "21039",
      "display" : "FARMACIA PUCCI - FORTUNATO S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "21040",
      "display" : "Montiano Centro Storico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040028"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "21041",
      "display" : "DISPENSARIO FARMACEUTICO MAREBELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "4"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "21042",
      "display" : "FARMACIA DI PIETRANTONIO-DI MATTEO SNC DI F. DI PIETRANTONIO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067047"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "21043",
      "display" : "Farmacia Fiorine srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016077"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "21044",
      "display" : "FARMACIA IBBISU DELLE DR.SSE NERI MARIA E D'URSO PATRIZIA ANTONIA s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083048"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-06-01"
        }
      ]
    },
    {
      "code" : "023",
      "display" : "ANTICA FARMACIA BOSIO DI GPHARMA1 S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "056",
      "display" : "FARMACIA SANT'ANNA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "105",
      "display" : "FARMACIA MAZZOLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "330",
      "display" : "ACCADEMIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001024"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "372",
      "display" : "FARMACIA COLLE DELLE FINESTRE S.A.S. DI DR. CARTA MIRKO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001149"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "411",
      "display" : "FARMACIA GUERCI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001313"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "434",
      "display" : "FARMACIA CARPANI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001265"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "470",
      "display" : "FARMACIA SAN SEBASTIANO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001253"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "499",
      "display" : "FARMACIA SAN ROCCO DI AURORA SNC DEI DOTTORI KISS MADDALENA E TABASSO LUCIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001009"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "557",
      "display" : "CENTRALE SNC DI LERDA MARIA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001217"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "862",
      "display" : "Farmacie Varesio e Sgrignani srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "096073"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "968",
      "display" : "BOCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003019"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "976",
      "display" : "VERGA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1060",
      "display" : "BOTTASSO DI DOTT.SSA TOSCO CARLA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004078"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1164",
      "display" : "MUSSO FILIPPO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004244"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1407",
      "display" : "ZERBA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006174"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1474",
      "display" : "FARMACIA CANTU' SNC DI CANTU' ERNESTINA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006081"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1613",
      "display" : "FARMACIA VAGHI S.A.S. - DR. F. ALARI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1801",
      "display" : "RAFFAELLI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016153"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1804",
      "display" : "FARCOM 08 PENDOLINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1816",
      "display" : "FARCOM 06 VILLAGGIO BADIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1817",
      "display" : "FARCOM 12 BORGO TRENTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1818",
      "display" : "FARCOM 01 VIALE VENEZIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1820",
      "display" : "FARCOM 07 URAGO MELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1826",
      "display" : "FARMACIA SCHIAVO DEL DOTT. ANTONIO SCHIAVO & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1836",
      "display" : "FARCOM 10 CASAZZA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1838",
      "display" : "Farmacia Santi Pietro e Paolo di Begni Enrica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017188"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1880",
      "display" : "FARCOM 03 FOLZANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1890",
      "display" : "FARCOM 09 SAN BARTOLOMEO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1895",
      "display" : "FARCOM 02 SAN POLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1903",
      "display" : "FARCOM 04 VIA CORSICA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1904",
      "display" : "FARCOM 05 VILLAGGIO VIOLINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "1905",
      "display" : "FARCOM 11 MOMPIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2093",
      "display" : "Fois Farmacie srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013012"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2169",
      "display" : "Fois Farmacie S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013118"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2232",
      "display" : "Bruttomesso Marco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019035"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2305",
      "display" : "SARTA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "019112"
        },
        {
          "code" : "provincia",
          "valueCode" : "019"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2547",
      "display" : "FARMACIA ORLANDI DELLA DOTT.SSA ORLANDI GILIA & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020016"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2608",
      "display" : "FARMACIA SACCAVINO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061082"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2698",
      "display" : "FARMACIA CANEVA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2787",
      "display" : "COMUNALE N. 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015189"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2814",
      "display" : "COMUNALE N.4",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015189"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2907",
      "display" : "BANDI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2931",
      "display" : "FARMACIA REPUBBLICA DOTT.SSA STELLATO IDA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2933",
      "display" : "FARMACIA MONTE SANTO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "2937",
      "display" : "Dinamica sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "3008",
      "display" : "Del parco srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "3017",
      "display" : "FARMACIA CANONICA DEL DOTT.MANELLI PIERCARLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "3219",
      "display" : "COMUNALE N.3",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015189"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "3231",
      "display" : "COMUNALE N.1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015189"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "3282",
      "display" : "MARTESANA Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015108"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "3312",
      "display" : "Farmacia San Giovanni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015125"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "3876",
      "display" : "DELLA BRUNELLA DI ALDO MANDELLI CONTEGNI & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012133"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4313",
      "display" : "BARATTO GIOVANNI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025006"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4318",
      "display" : "FARMACIA CORAN S.N.C. DEI DOTTORI GIULIA E ANTONIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025006"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4321",
      "display" : "FARMACIE DOLOMITI SRL - FARMACIA DOLOMITI FARRA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025072"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4338",
      "display" : "FARMACIA ALLA MADONNA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025022"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4362",
      "display" : "FARMACIA SAN GIUSEPPE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024026"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4591",
      "display" : "farmacia di sarmede sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026078"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4645",
      "display" : "FARMACIA BASSI SAS DELLA DR.SSA CHIARA CENEDESE & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026046"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4698",
      "display" : "FARMACIA BUREI S.N.C. DELLA D.SSA BUREI BARBARA E MOTYKA M.A.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026082"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4722",
      "display" : "Farmacia Castellari srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026082"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4761",
      "display" : "FARMACIA PANCINO S.A.S. DELLA DR.SSA VALENTINA PANCINO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027009"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4773",
      "display" : "FARMACIA  S. ANTONIO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027029"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4800",
      "display" : "FARMACIA S. LUCIA DI BUCCETTI MAURO & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4816",
      "display" : "DELL'ORSO SAS del Dott. Di Martino Renato & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4855",
      "display" : "FARMACIA MENIS S.N.C. DEL DR. PAOLO MENIS & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4879",
      "display" : "FARMACIA CAVALLINO SNC DEI DOTTORI SILVIA E LUCA BONIZZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027044"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "4927",
      "display" : "FARMACIA MANZOLLI SNC DEL DOTT. STEFANO MANZOLLI  E FIGLIE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027012"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5183",
      "display" : "FARMACIA BEATA VERGINE DELLA SALUTE S.N.C. DI FASIOL DOTT.SSA FRANCESCA E TONIZZO DOTT. DIEGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029003"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5229",
      "display" : "FARMACIA NEGRELLI DEI DOTTORI SILVANO ED ANNA NEGRELLI S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029025"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5237",
      "display" : "FARMACIA COLLA SAS DI COLLA GIOVANNI, JACOPO E MICHELA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029017"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5253",
      "display" : "FARMACIA SALUS S.A.S. DEL DR. CHIEFA VINCENZO FRANCESCO SAVERIO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029002"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5258",
      "display" : "FARMACIA POZZATO DI POZZATO MARIA ROSA & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029046"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5265",
      "display" : "Farmacia Centrale di Signorini Luca e Roberto S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5278",
      "display" : "SANTA CHIARA DI PACENTI N. E S. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5338",
      "display" : "LAFARMACIA.VERONAFIERE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5374",
      "display" : "Farmacia Dott. Turri di Michele Turri e C.Sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023090"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5543",
      "display" : "FARMACIA DOTTOR PATUNA DEL DOTT. ALESSANDRO PATUNA & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032005"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5548",
      "display" : "Farmacia Fanchi sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "031010"
        },
        {
          "code" : "provincia",
          "valueCode" : "031"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5605",
      "display" : "ALLA MADONNA DE CLAUSER A.& G.SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030043"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5631",
      "display" : "Farmacia Eredi Giorgio Giordani Gestione Provvisoria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030127"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5637",
      "display" : "FARMACIA MANGANOTTI GESTIONE PROVVISORIA DI RENZA CORRADOSSI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5655",
      "display" : "Farmacia di Faedis snc delaa dr Flavia Pagnucco & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030036"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "5859",
      "display" : "RE DI SAN PIETRO FARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "008030"
        },
        {
          "code" : "provincia",
          "valueCode" : "008"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6190",
      "display" : "OPERAIA FIUMARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6309",
      "display" : "farmacia rezzoaglio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010048"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6339",
      "display" : "Le Grazie s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011022"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6345",
      "display" : "DELLA STAZIONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011015"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6492",
      "display" : "FARMACIA BESURICA SNC DEI DOTTORILOSI ELENA E LOSI LUIGI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033032"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6652",
      "display" : "OPERAIA  srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035024"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6674",
      "display" : "Farmacia Capretti di Farmacie FRARA sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035034"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6861",
      "display" : "DI CALDERARA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037009"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6916",
      "display" : "FARMACIA DI CASALFIUMANESE DEI DOTTORI FRANCA PIRAZZOLI ED ALESSANDRO BERTI S.N.C. IN BREVE FARMACIA DI CASALFIUMANESE S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037012"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "6982",
      "display" : "BETTINI SNC GOLINELLI DOTT. RUGGERO & C.Sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7055",
      "display" : "NUOVA S. RUFFILLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7088",
      "display" : "Farmacia Amato della Dott.ssa Giovanna Amato",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7092",
      "display" : "Farmacia San Pietro Dr. Anna Adele Mantovani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038008"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7122",
      "display" : "FARMACIA CANTELLI DELLA DR.SSA DANIELA CANTELLI E C.SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038004"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7252",
      "display" : "ROSSI SANT'AGATA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039017"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7449",
      "display" : "CORTESINI DI CORTESINI LUIGI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045002"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7467",
      "display" : "FARMACIA BERTOLUCCI DI SARA BERTOLUCCI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045004"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7489",
      "display" : "Lenci srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045010"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7504",
      "display" : "BINOTTI LAURA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045016"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7552",
      "display" : "TUTINO RANZANI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046017"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7564",
      "display" : "Farmacia Gaddi SNC di Bernardo Bernardi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046020"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7576",
      "display" : "FARMACIA ABETONE S.A.S DEL DOTT. FERDINANDO VELTRI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "047023"
        },
        {
          "code" : "provincia",
          "valueCode" : "047"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7583",
      "display" : "Farmacia Checchia - Società Labher",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "047022"
        },
        {
          "code" : "provincia",
          "valueCode" : "047"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7605",
      "display" : "DEL VECCHIO MERCATO DI FARMAGRUPPO PISTOIA DEL DR. G. PISTOIA & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "047012"
        },
        {
          "code" : "provincia",
          "valueCode" : "047"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7640",
      "display" : "FARMACIA DOTT. RASPA ALBERTO E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "047017"
        },
        {
          "code" : "provincia",
          "valueCode" : "047"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7688",
      "display" : "Martignoni di Martignoni Cristina &C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "045008"
        },
        {
          "code" : "provincia",
          "valueCode" : "045"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7760",
      "display" : "FARMACIA CAPONE DR.SSA ALESSIA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050038"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7847",
      "display" : "Farmacia Sassetta del Dr. E. Ronco & C. sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049019"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7877",
      "display" : "SALVIONI SNC DEL DR. ROBERTO SALVIONI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052014"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7919",
      "display" : "MINUCCI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052032"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7984",
      "display" : "BIANCHI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051017"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "7989",
      "display" : "FARMACIA RICCI DI LANFRANCO RICCI & C. s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051017"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8061",
      "display" : "EREDI DR.SSA BASTIANINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053011"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8083",
      "display" : "FARMACIA COMUNALE MASSA MARITTIMA MULTISERVIZI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053015"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8087",
      "display" : "FARMACIA S. ERASMO SAS DEL DR. PIERPAOLO TANZINI & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053016"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8177",
      "display" : "ANTICA FARMACIA MOLTENI sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8191",
      "display" : "S. ANTONINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048017"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8310",
      "display" : "FARMACIA CAPPIANO DI GIOMI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048019"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8313",
      "display" : "NATALI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048020"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8317",
      "display" : "FARMACIA CANNERI DEL DOTT. GIOVANNI BRUSCHI E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048028"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8348",
      "display" : "FARMACIA BARBIERI FONTANA S.N.C. DEL DR. BARBIERI MAURO PASQUALE E C. sede di Massarosa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046018"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8368",
      "display" : "FARMACIA CANALI SAS DI FARMACIA CANALI DI MASSIMO CANALI & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046033"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8369",
      "display" : "FARMACIA INTERNAZIONALE S.N.C. DEL Dr. Fornari Franco e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046033"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8387",
      "display" : "COMUNALE GUBBIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054024"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8413",
      "display" : "PIMPINELLI SAS DI CLAUDIA PIMPINELLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054026"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8433",
      "display" : "FARMACIA SERTORI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8455",
      "display" : "FARMACIA DI POZZUOLO S.A.S. DI CLAUDIO MARIOTTINI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054009"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8461",
      "display" : "TAVERNELLE DI LUCIANI L. & C SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054037"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8502",
      "display" : "Farmacia Santi Dott. Pietro snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054004"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8506",
      "display" : "FARMACIA EREDI ROSETTI LILIANA DI FRATTALI PIER GIORGIO S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054010"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8511",
      "display" : "FARMACIA SAN MARCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054018"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8555",
      "display" : "Bettelli Marta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055017"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8582",
      "display" : "farmacia lanfaloni snc di lanfaloni paola e maria rita",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055004"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8589",
      "display" : "CARDUCCI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055022"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "8944",
      "display" : "FARMACIA MORENI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043034"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9072",
      "display" : "FARMACIA MARINELLI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044054"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9094",
      "display" : "SANFARMA SRL FARMACIA SANT'ANTONIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9102",
      "display" : "SANFARMA SRL FARMACIA SAN STANISLAO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9105",
      "display" : "SANFARMA SRL FARMACIA SANT'ANDREA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9139",
      "display" : "SANFARMA SRL FARMACIA SAN GABRIELE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9169",
      "display" : "FARMACIA MORELLI S.A.S. DELLA DOTTORESSA SIMONETTA MORELLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9198",
      "display" : "Farmacia Tor Millina S.R.L. società unipersonale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9225",
      "display" : "FARMACIA DE ANGELIS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9337",
      "display" : "Farmacrimi Tuscolana Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9464",
      "display" : "FARMACIA MUSOLINO S.A.S. DI MASSIMO PIZZI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9488",
      "display" : "Olimpia SNC di Rizzo Mariagiovanna e Parrella Catalano Maria Francesca",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9496",
      "display" : "SANFARMA SRL FARMACIA SAN NICOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9666",
      "display" : "Farmacia Ciarcia' SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9676",
      "display" : "DE LONGIS  FAUSTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9721",
      "display" : "FARMACIA NICCOLINI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9733",
      "display" : "FARMACIA MEDAGLIE D'ORO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9744",
      "display" : "FARMACIA SCIPIONI SAS DI ROMANI LAURA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9805",
      "display" : "Farmacia Nappo di Nappo Carla Marina Rita & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058081"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9875",
      "display" : "CARICARI FABIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058104"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9878",
      "display" : "FARMACIA MORELLI SNC DELLA DRSSA ANGIOLETTA MORELLI & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058102"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "9967",
      "display" : "COMUNALE N.2 LANUVIO PASCOLARE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058050"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10246",
      "display" : "FARMACIA SANT'ANNA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059017"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10250",
      "display" : "FARMACIA MORBELLA S.A.S. DELLA DOTT.SSA CARBONE ANNAMARIA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10272",
      "display" : "FARMACIA SANT'ANTONIO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059005"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10284",
      "display" : "FARMACIA SAN PIETRO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059008"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10306",
      "display" : "FARMACIA FONTANA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10389",
      "display" : "FARMACIA INTERAMNA S.A.S DELLA DOTT.SSA MARIA ANTONIETTA FALOVO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060054"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10415",
      "display" : "farmacia sant'anna sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060044"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10585",
      "display" : "FARMACIA PIERANTONI DI PIERANTONI DANIELE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10597",
      "display" : "FARMACIA ZANNOLLI FERRARESI S.N.C DOTTORI LUCA ED ELISABETTA ZANNOLLI E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069050"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10624",
      "display" : "BUCCI DEL DR. BUCCI CARLO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069001"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10631",
      "display" : "Farmacia D'Aurizio srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069015"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10658",
      "display" : "DI CROCE MARIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069083"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10672",
      "display" : "GIOVANNELLI VINCENZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069099"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10676",
      "display" : "FARMACIA VALENTINI SNC DI MARINA EUFEMIA CAROSELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069056"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10677",
      "display" : "Farmacia Di Nardo SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069083"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10755",
      "display" : "EREDI DE VITA del dr. Antonio De Vita",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068007"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10778",
      "display" : "MARTELLA RAFFAELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10782",
      "display" : "FARMACIA DOTT.SSE PALUDI DI PALUDI MAYA & PALUDI ORIELLA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068002"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10803",
      "display" : "DE LUCA RADOCCHIA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068043"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10809",
      "display" : "FARMACIA CALDARELLI di CALDARELLI VINCENZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10814",
      "display" : "DI GIAMBERARDINO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10839",
      "display" : "Farmacia Rotondo sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10876",
      "display" : "LAVIANO FRANCESCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067040"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10902",
      "display" : "DISPENSARIO ROSINI GIUSEPPINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067013"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "10960",
      "display" : "Farmacia Massari di Elio Massari",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "094014"
        },
        {
          "code" : "provincia",
          "valueCode" : "094"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "11357",
      "display" : "FARMACIA ZAMPELLI S.R.L",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062003"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "11367",
      "display" : "FARMACIA DEL PRETE S.N.C. DEI DOTTORI MARIA TERESA E PASQUALEMANUELE DEL PRETE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061022"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "11404",
      "display" : "FARMACIA CANNAVALE S.A.S. DELLA DOTT.SSA MARIA TERESA CANNAVALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061091"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "11515",
      "display" : "ARS FARMACIE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061083"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "11750",
      "display" : "FARMACIA DOTT. PEPE LUIGI MARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "11844",
      "display" : "FARMACIA DI LULLO DI GIUSEPPE LORITO & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "11961",
      "display" : "FARMACIA MORRONE E C. DEL DR MARCO MORRONE S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063023"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12179",
      "display" : "FARMACIA IROLLA sas DELLA DOTTORESSA RITA IROLLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063053"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12207",
      "display" : "FARMACIA BOSCIA S.A.S. DEL DR. GIUSEPPE BOSCIA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065078"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12226",
      "display" : "BOTTONI BENEDETTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065137"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12438",
      "display" : "VENNERI -DEVENDE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065028"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12500",
      "display" : "FARMACIA SCATTAGLIA DEL DOTT. LOPETUSO GIUSEPPE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110001"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12672",
      "display" : "LOZUPONE VINCENZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12708",
      "display" : "Fratelli Falagario srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12722",
      "display" : "Del Sole srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072011"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12735",
      "display" : "FARMACIA MANGIOLINO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072028"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12743",
      "display" : "ANCONA DEL DOTT. ANCONA ROCCO E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072046"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12769",
      "display" : "FARMACIA CRISIGIOVANNI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072006"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12809",
      "display" : "FARMACIA SCELZI SNC DEL DOTT. NATALE SCELZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072015"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12856",
      "display" : "AFRICA ORIENTALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12866",
      "display" : "FARMACIA COLUCCI S.A.S. DELLA DR.SSA NATALIA COLUCCI & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074002"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12896",
      "display" : "de nitto emanuela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074012"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12929",
      "display" : "LEO DEL DR.LUCA LEO & C.SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074004"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "12938",
      "display" : "FARMACIA CORSO ROMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13026",
      "display" : "Giacomantonio Giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110005"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13030",
      "display" : "DE SIO del dott Luigi Prencipe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071033"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13048",
      "display" : "Farmacia Prencipe S.a.s. Del Dottor Prencipe Raffaele",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071029"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13053",
      "display" : "farmacia prencipe sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071029"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13081",
      "display" : "Farmacia san Francesco dott.ssa A.Melfi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071005"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13117",
      "display" : "FARMACIA FARES EUGENIO DELLE DOTT.SSE LIDIA E LUCIA FARES S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071028"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13145",
      "display" : "FARMACIA BENEGIAMO-PAGLIULA & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075052"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13149",
      "display" : "FARMACIA SAN CLODOMIRO S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075092"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13176",
      "display" : "Farmacia Petracca dott. Michele",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075038"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13187",
      "display" : "FARMACIA MONTAGNA DOTT.SSA PAOLA S.A.S. & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13198",
      "display" : "GIORDANO SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075093"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13203",
      "display" : "MANIERI ELIA-DE CUPERTINIS SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075052"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13235",
      "display" : "Farmacia Bianco Curto S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13241",
      "display" : "farmacia San Clodomiro dei dottori Catalano Memmo di Antonio Catalano e Antonia Memmo & c. s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075037"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13287",
      "display" : "farmacia vittorio giannelli srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075059"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13294",
      "display" : "PESCHIULLI DR.SSA ANTONELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075064"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13340",
      "display" : "Palma Mario SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075061"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13344",
      "display" : "FARMACIA del dott. Venneri Massimo Quintino & C. s.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075002"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13483",
      "display" : "FARMACIA GARGAGLIONE S.A.S. DEL DOTT. GARGAGLIONE SERAFINO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073008"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13493",
      "display" : "SANTA CHIARA S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073012"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13496",
      "display" : "la Farmacia BOCCUNI srl unipersonale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073004"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13601",
      "display" : "Tuzio Mariangela",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076019"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13703",
      "display" : "DEL LEONE DEL DOTT. ANTONIO DE LUNA E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078048"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13819",
      "display" : "FARMACIA RIZZO CORALLO DI FILIPPELLI EVA & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078157"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13841",
      "display" : "NOTO SNC DEL DOTT. GIOVANNI VINCENZO NOTO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078157"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13848",
      "display" : "Farmacia dott. Eugenio De Florio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078157"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13854",
      "display" : "BERLINGIERI ANDREA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078017"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "13917",
      "display" : "FARMACIA PELUSO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078102"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "14495",
      "display" : "Farmacia centrale del Dr.Gabriele Pace &C. s.n.c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084041"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "14573",
      "display" : "DOTT. VERSO FARMACIE della Dr.ssa Viviana Verso & C. S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085015"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "14577",
      "display" : "DOTT. VERSO FARMACIE della Dr.ssa Viviana Verso & C. S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085015"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "14597",
      "display" : "Bennici Concetta Grazia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085007"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "14625",
      "display" : "DOTT. VERSO FARMACIE della Dr.ssa Viviana Verso & C. S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085015"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "14695",
      "display" : "FARMACIA  CANIGLIA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087016"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "14938",
      "display" : "Farmacia Eredi Morgana s.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086015"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15040",
      "display" : "Farmacia Tripodo SNC di Angela, Carlo e Paola Tripodo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083066"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15148",
      "display" : "FARMACIA GENOVESE DI SCHIRO' BETTY & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083005"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15224",
      "display" : "farm. Giunta Cardinale dr. Andrea",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082001"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15288",
      "display" : "Saitta Sandra",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15328",
      "display" : "modica s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082070"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15354",
      "display" : "Giuffrè Maria Rosa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082070"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15377",
      "display" : "FARMACIA GALATI SAS DELLA FARMACIA GALATI DELLA DOTTORESSA MARIA ELISA GALATI S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15433",
      "display" : "Farmacia Giafar srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15437",
      "display" : "Farmacia Saporita s.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15514",
      "display" : "farmacia aquiletta denaro srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088005"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15585",
      "display" : "Nigro Giovanna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089012"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15626",
      "display" : "FARMACIA DOTTORI PAPPALARDO MARGHERITA E AGATINO S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15628",
      "display" : "Farmacia Zivillica SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089008"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15682",
      "display" : "FARMACIA CATANIA S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089009"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15689",
      "display" : "Farmacia Dott.ssa Gabriella Alongi S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081021"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15695",
      "display" : "Restivo Ilaria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081021"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15786",
      "display" : "farmacia ferracane sas di Maiorana Giada Mariangela e c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081006"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15852",
      "display" : "FARMACIA MAZZOCCHICADONI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104006"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15860",
      "display" : "Farmacia Pisu S.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090025"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15870",
      "display" : "FARMACIA CESARE PISANO S.N.C. DEL DOTT. EUGENIO PISANO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090064"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "15954",
      "display" : "Fertilia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090003"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16106",
      "display" : "Farmacia Dr. Puggioni Francesco SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095004"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16120",
      "display" : "farmacia della Dott.ssa Simona Sardanu",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095024"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16186",
      "display" : "Farmacia Loddo SNC della dottoressa Maria Rosaria Loddo & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "111088"
        },
        {
          "code" : "provincia",
          "valueCode" : "111"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16246",
      "display" : "FARMACIA MAMBRINI DI CAROLINA MAMBRINI E C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16729",
      "display" : "COMUNALE VIDICIATICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037033"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16848",
      "display" : "COMUNALE SERRISTORI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048016"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16887",
      "display" : "COMUNALE SERRAZZANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050027"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16893",
      "display" : "COMUNALE N.2 FORNACELLE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100003"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16902",
      "display" : "COMUNALE POGGETTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "100004"
        },
        {
          "code" : "provincia",
          "valueCode" : "100"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16938",
      "display" : "Farmacia Comunale Vaglia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048046"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "16939",
      "display" : "COMUNALE DI VAGLIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048046"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "17067",
      "display" : "Farmacia Dego Dr.ssa Cristina",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014010"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "17166",
      "display" : "FARMACIA SCELZI SNC DEL DOTT. NATALE SCELZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072028"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "17177",
      "display" : "FARMACIA FERENTE  SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075022"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "17491",
      "display" : "Dispensario F.cia S. Giacomo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013047"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "17579",
      "display" : "DI ROBECCO - DR. VERGA NICOLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018124"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "17750",
      "display" : "FIORI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023052"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "17812",
      "display" : "PIMPINELLI SAS DI CLAUDIA PIMPINELLI - DISPENSARIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054026"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18002",
      "display" : "Farmacia Angeli Custodi srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074016"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18046",
      "display" : "Comunale 1 Leccio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048035"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18237",
      "display" : "del Borgodel Dott. Fracassi Massimiliano e C S.a.s",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037020"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18326",
      "display" : "Comunale Il Castello",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033013"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18536",
      "display" : "MANDARELLI DOTT. DINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042010"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18683",
      "display" : "BRUNETTO DELLA DR.SSA M.C. BRUNETTO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084041"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18740",
      "display" : "FARMACIA SAN VITO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065050"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18742",
      "display" : "Farmacia Comunale Di Cesenatico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040008"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18781",
      "display" : "COMUNALE DI MONTEPULCIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052015"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18855",
      "display" : "Farmacia Zago S.a.s. Del Dott. Fiorenzo Zago",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027036"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "18946",
      "display" : "FARMACIA S. ANNA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "19198",
      "display" : "Nuova di Magliulo Maria E Cilurzo Giuseppe Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073008"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "19211",
      "display" : "Bartolo Longo Snc dei Dr. Vetrano Vitaliano e Morzillo Adriana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074009"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "19330",
      "display" : "FARMACIA LEVANTE DI ROSITA SANTINI & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037048"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "19343",
      "display" : "FARMACIA FINZI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "19657",
      "display" : "Farmacia Camignone SRL unipersonale Dott. Pietro Aronica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017136"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "19778",
      "display" : "Farmacia Comunale Della Salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036005"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "19825",
      "display" : "Farmacia Sant'Antonio srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065137"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "19841",
      "display" : "FARMACIA QUARTO CENTRO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063063"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "20195",
      "display" : "Farmacia Di Remondo'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018068"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "20207",
      "display" : "FARMACIA DI MANDRIOLA SNC DEL DOTTOR ROBERTO PAVANATO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028003"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "20241",
      "display" : "Farmacia Sant'Angelo SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027035"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "20247",
      "display" : "Dispensario della Fois Farmacie S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013118"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "20266",
      "display" : "Farmacia Ospedaletto s.n.c. di Isabella Gazzi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026035"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "20554",
      "display" : "FARMACIA AL CENTRO SAS DEL DR. ROBERTO MERLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028034"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "21032",
      "display" : "Farmacia Comunale 2 di Limbiate",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108019"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "21033",
      "display" : "FARMACIA DI POGGIANA  SRLS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026068"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "21034",
      "display" : "farmacia S. Antonio srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087049"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "21035",
      "display" : "PROIEZIONE FARMACEUTICA FARMACIA DE MUNARI S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052002"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "2"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-05-01"
        }
      ]
    },
    {
      "code" : "245",
      "display" : "FARMACIA POLICLINICO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "266",
      "display" : "FARMACIA PORPORA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "308",
      "display" : "FARMACIA SAN GIACOMO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001008"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "500",
      "display" : "FARMACIA AMEDEI S.N.C. DEI DOTTORI GIORGIO, CHIARA, FABIO E ALBERTO AMEDEI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001059"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "884",
      "display" : "Paduano Dr. Giovanna",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "919",
      "display" : "Farmacia Nigri Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003106"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "1076",
      "display" : "FARMACIA CIVALLERI DI CIVALLERI CLAUDIO E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004016"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "1291",
      "display" : "Farmacia dottor Palmeri e dottoressa Repetti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "005020"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "1671",
      "display" : "farmacia de roveri",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016216"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "1791",
      "display" : "FARMACIA S. ANTONIO DI DR.SSA  MARIA MARTORANA & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016097"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "1906",
      "display" : "FARMACIA PARI FRATELLI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017034"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "1934",
      "display" : "LE NUOVE FARMACIE DI OSPITALETTO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017127"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "1994",
      "display" : "GANDOSSI DI GANDOSSI GIOVANNA E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017085"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "2027",
      "display" : "CEF LA FARMACIA ITALIANA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017166"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "2065",
      "display" : "FARMACIA ROSSI DOT..SSA ROBERTA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017088"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "2408",
      "display" : "MANFRINI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098031"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "2487",
      "display" : "FARMACIA DONELLI DI DONELLI GIUSEPPE &C SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020068"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "2838",
      "display" : "Farmacia Durini Farma Acquisition S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "2923",
      "display" : "FARMACIA NUOVA INGANNI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "3292",
      "display" : "Farmacia Metanopoli Dott. Andrea Mulas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015192"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "3337",
      "display" : "CENTRALE GIANOTTI S.R.L",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108004"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "3393",
      "display" : "FARMACIA NICOLINI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108016"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "3437",
      "display" : "Farmacia Sansone srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015209"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "3486",
      "display" : "FARMACIA BURAGO MOLGORA S.A.S. DELLA DR.SSA AGNESE RICCO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108013"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "3490",
      "display" : "FARMACIA DI SEREGNO SAN SALVATORE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108030"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "3511",
      "display" : "LAFARMACIA.RENATE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108037"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "3670",
      "display" : "Marinone Snc di Marinone Patrizia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018130"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4020",
      "display" : "FARMACIA PETROBONI DEL DOTT. VERNI FONTENI MARCO S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017016"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4029",
      "display" : "FARMACIA GHIRARDI MADDALENA ESTERINA E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017083"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4053",
      "display" : "Farmacia Termeno srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "021098"
        },
        {
          "code" : "provincia",
          "valueCode" : "021"
        },
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4429",
      "display" : "FARMACIA VINCENZO TARALLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024106"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4518",
      "display" : "FARMACIA MASSAROTTO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024083"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4521",
      "display" : "FARMACIA DE ANTONI SAS DEI DOTTORI FILIPPO E FRANCESCA DE ANTONI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024103"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4686",
      "display" : "FARMACIA DI PORTOBUFFOLE' S.N.C. DELLA DR.SSA GRANDE ALESSANDRA E GRASSILLI MARCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026060"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4736",
      "display" : "FARMACIA DODI S.A.S. DEL DR. DODI ANDREA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026010"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4827",
      "display" : "FARMACIA AI DUE SAN MARCHI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4863",
      "display" : "ALLA GATTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "4974",
      "display" : "FARMACIA CUTULAKIS SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027008"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "5121",
      "display" : "FARMACIA S. GIACOMO SAS DEL DR. GIACOMO ROSSI E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028003"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "5140",
      "display" : "FARMACIA BOSCHI S.N.C. DI ANNALISA COPPOLA & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028040"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "5324",
      "display" : "Farmacia Colalto S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023070"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "5381",
      "display" : "FARMACIA MAZZON SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023044"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6051",
      "display" : "Farmacia Ribaldone srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6060",
      "display" : "FARMACIA DELL'ORO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6216",
      "display" : "CAMOGLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010007"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6257",
      "display" : "FARMACIA EUROPA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6294",
      "display" : "SAN GIOVANNI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010015"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6336",
      "display" : "Farmacia Salvan di Satta Silvia & C SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011026"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6579",
      "display" : "FARMACIA CARDINALI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034006"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6597",
      "display" : "PARENTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034051"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6650",
      "display" : "Farmacia Santa Vittoria di Farmacie FRARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035023"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6679",
      "display" : "FARMACIA SAN PAOLO s.n.c. di Margini Carlotta e Margini Elisabetta",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035038"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6726",
      "display" : "Popolare",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036010"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6731",
      "display" : "S.S. Antonio e Francesco",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036013"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6744",
      "display" : "VERONESI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036022"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6781",
      "display" : "San Bartolomeo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036030"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6833",
      "display" : "Santa Chiara",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036005"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6842",
      "display" : "DELLA SPERANZA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036005"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6858",
      "display" : "Beata Vergine del Castello",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036013"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "6964",
      "display" : "ALBERINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037039"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "7197",
      "display" : "FARMACIA DI PORTANUOVA SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "7249",
      "display" : "MCM Sas del Dr. Giulio Camanzi & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039008"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "7398",
      "display" : "FARMACIA BELLARIVA DOTT. BOCCHINI GIULIANO & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "7414",
      "display" : "FARMACIA FRATTI DI FRATTI SANDRA E C SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099014"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "7699",
      "display" : "FARMACIA DA SETTIMO S.A.S. DEL DOTTOR PAOLO BENEDETTINI E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050008"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "8081",
      "display" : "FARMACIA VISPI SNC DI FRANCESCO E ANTONIO VISPI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "053015"
        },
        {
          "code" : "provincia",
          "valueCode" : "053"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "8426",
      "display" : "Farmacia Perelli sas di Claudia Perelli E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054017"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "8609",
      "display" : "OSPEDALE 2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055032"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "8625",
      "display" : "FARMACIA PIETRAVALLE SAS DEL DR. CLAUDIO PIETRAVALLE & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041068"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "8736",
      "display" : "FARMACIA COSTANTINI LORI SAS DEI DR.RI GIANLUCA E FRANCESCA COSTANTINI LORI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041054"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "8742",
      "display" : "FARMACIA DEL CORSO DELLA FARMACIA BORGO EMILIO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042003"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "8743",
      "display" : "FARMACIA BORGO EMILIO S.R.L..",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042003"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "8803",
      "display" : "FARMACIA COMUNALE 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042017"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "8938",
      "display" : "LAFARMACIA.GRELLONI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043009"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "9014",
      "display" : "FARMACIA CUPRAMARITTIMA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044017"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "9067",
      "display" : "FARMACIA MONTEFORTINO DI ROSSI BRUNORI SUSANNA & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "109015"
        },
        {
          "code" : "provincia",
          "valueCode" : "109"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "9763",
      "display" : "FARMACIA Mazzini snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "9833",
      "display" : "FARMACIA CIPRO SAS DEL DR. TITO MARIA SERRAINO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "9952",
      "display" : "FARMACIA PALMIERI FRANCESCO & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058071"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "9987",
      "display" : "ANGELINI SNC DI ANGELINI GIULIANO ALBERTO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "10059",
      "display" : "FARMACIA CASTEL GIORGIO S.A.S. DEL DR. GIUSEPPE MENICHELLI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "055009"
        },
        {
          "code" : "provincia",
          "valueCode" : "055"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "10204",
      "display" : "FARMACIA RIZZUTI DELLE DOTTORESSE FLAVIA E RIZZUTI LIVIA SOCIETA' IN NOME COLLETTIVO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "057012"
        },
        {
          "code" : "provincia",
          "valueCode" : "057"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "10325",
      "display" : "Farmacia Cassandra Dr. Angelo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "10456",
      "display" : "FARMACIA SANT'ANNA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060019"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "10578",
      "display" : "ALBERTAZZI BRUNELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "069022"
        },
        {
          "code" : "provincia",
          "valueCode" : "069"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "10831",
      "display" : "FARMACIA MASSARI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "068028"
        },
        {
          "code" : "provincia",
          "valueCode" : "068"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11033",
      "display" : "Altieri Maria Domenica",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070024"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11068",
      "display" : "Farmacia Giuliano Michele S.R.L. Società Benefit",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070021"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11114",
      "display" : "FARMACIA LIONI DEL DOTT. ENRICO PELOSI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064044"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11186",
      "display" : "FARMACIA DEL LEONE DEI DOTTORI MAZZONE S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064008"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11280",
      "display" : "FARMACIA CUSANO SNC DI PALUMBO FELICITA E TOMMASO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062077"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11313",
      "display" : "FARMACIE DELLE TERME S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062074"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11377",
      "display" : "FARMACIA ACQUAVIVA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061022"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11536",
      "display" : "FARMACIA BOCCHINO S.A.S. DELLA DR.SSA MARIA ANGELA BOCCHINO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "061094"
        },
        {
          "code" : "provincia",
          "valueCode" : "061"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11575",
      "display" : "GI.MA.FARM. S.A.S. DEL DOTT. MASSIMO MARONE E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11722",
      "display" : "AL POLICLINICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "11786",
      "display" : "FARMACIA DR. CALCAGNO FRANCESCO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "12008",
      "display" : "FARMACIA DEL SOLE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063050"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "12445",
      "display" : "FARMACIA DOTT.SSA MARINO MARIA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065009"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "12516",
      "display" : "Farmacia Casalino srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072020"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "12738",
      "display" : "FARMACIA DICIOLLA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072032"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "12944",
      "display" : "Farmacia Santa Maria del Casale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074001"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "13514",
      "display" : "EREDI DI BIA LOREDANA S.D.F.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076064"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "13519",
      "display" : "Farmacia EREDI Dott. Palermo Roberto Vito sdf",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076067"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "13584",
      "display" : "FARMACIA DI CARLO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076079"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "13850",
      "display" : "FARMACIA BRERA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078065"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "13963",
      "display" : "FARMACIA SAN DONATO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "101026"
        },
        {
          "code" : "provincia",
          "valueCode" : "101"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "14205",
      "display" : "Farmacia Averta Giuseppe",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "102004"
        },
        {
          "code" : "provincia",
          "valueCode" : "102"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "14933",
      "display" : "FARMACIA QUATTRINO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086014"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "14954",
      "display" : "FARMACIA DEL CENTRO DEL DOTT. SAMMARCO GIUSEPPE E C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086014"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "15211",
      "display" : "Filippone Teresa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082012"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "15372",
      "display" : "Farmacia Ricupati",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082054"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "15386",
      "display" : "Farmacia Orlando sb srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "15529",
      "display" : "FARMACIA EREDI DI LOSI LUIGI DI BELLINO MARIA ANNA E C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088008"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "15615",
      "display" : "FARMACIA FAVARA T. & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "089017"
        },
        {
          "code" : "provincia",
          "valueCode" : "089"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "15835",
      "display" : "FARMACIA DIGITALIS SAS DELLA DOTT.SSA SCHIRRU ROSANNA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090039"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "15920",
      "display" : "FARMACIA DIGITALIS SAS DELLA DOTT.SSA SCHIRRU ROSANNA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "090071"
        },
        {
          "code" : "provincia",
          "valueCode" : "090"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "15937",
      "display" : "FARMACIA SUCCURSALE  DIGITALIS SAS DELLA DOTT.SSA SCHIRRU ROSANNA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104004"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "4"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "16013",
      "display" : "farmacia daddi srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "091051"
        },
        {
          "code" : "provincia",
          "valueCode" : "091"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "16088",
      "display" : "Irene Serra",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095013"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "16093",
      "display" : "Farmacia dr. Andrea Pedrazzini srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095069"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "16219",
      "display" : "FARMACIA TRUDU S.A.S. DI TRUDU NICOLETTA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "107023"
        },
        {
          "code" : "provincia",
          "valueCode" : "107"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "16286",
      "display" : "Farmacia Porcu S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "16814",
      "display" : "COMUNALE DI GABICCE MARE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041019"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "17096",
      "display" : "Marocchi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001197"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "17414",
      "display" : "Madonna Della Consolata",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "103022"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "17712",
      "display" : "FARMACIA DI RANCO DELLA DOTT.SSA R.BERTASI&C.S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012116"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "17916",
      "display" : "FARMACIA SANTA RITA SAS DELLA DOTTORESSA SPAGNUOLO LOFFREDA & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063062"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "17983",
      "display" : "Farmacia Vitillo Sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058047"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "18460",
      "display" : "FARMACIA SAVINO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058120"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "18837",
      "display" : "FARMACIA SALSANO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072011"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "19100",
      "display" : "Farmacia Di Filettole Snc Delle Dr.sse Papini F., Rafanelli S., Tintori C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050037"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "19147",
      "display" : "DEL MARE DELLA  DOTTORESSA EVITA MORESCHINI & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058116"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "19414",
      "display" : "FARMACIA FELLINI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018150"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "19485",
      "display" : "Farmacia Clementi Torre del Lago di Clementi Nicola e Lanfranco SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046033"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "19705",
      "display" : "Farmacia Zai Di Di Leva Vincenzo, Starace Miryam E Pellegrino Giuseppe Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "19748",
      "display" : "FARMACIA PONTE VECCHIO SNC DELLA DOTT.SSA CAIROLI GLORIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "097036"
        },
        {
          "code" : "provincia",
          "valueCode" : "097"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "19951",
      "display" : "FARMACIA SAN ROCCO S.N.C. DELLA DOTT.SSA ALESSIA PELATI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011013"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "20092",
      "display" : "Farmacia Madonna in Campagna S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015027"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "20492",
      "display" : "FARMACIA DELL'ASSUNTA S.A.S. DELLA DOTT.SSA ANNA-MARIA SANTANGELO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026055"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "20508",
      "display" : "Farmacia Gentile S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082049"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "20991",
      "display" : "Bella Venezia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026012"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "21024",
      "display" : "Farmacia del Leone dott.ssa Evelina Piscopo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065127"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "21025",
      "display" : "Farmacia Balanzano",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "21026",
      "display" : "FARMACIA SAPORITO ANTONIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063034"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "21027",
      "display" : "FARMACIA GRAMMERCATO MINONNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042021"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "21028",
      "display" : "FARMACIA SAN TOMMASO DI GIACOBBI BEATRICE E FEDELI MARIA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "109006"
        },
        {
          "code" : "provincia",
          "valueCode" : "109"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "21029",
      "display" : "FARMACIA LA VALLE SNC DEI DOTTORI CHIARA MARANGONI E ANDREA VERONESE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024012"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "21030",
      "display" : "FARMACIA SPATARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088003"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "21031",
      "display" : "Farmacia Centocroci",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "041029"
        },
        {
          "code" : "provincia",
          "valueCode" : "041"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-04-01"
        }
      ]
    },
    {
      "code" : "016",
      "display" : "SANTA BARBARA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "386",
      "display" : "GALLO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001116"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "428",
      "display" : "San Luca Settimo Torinese - Farmacia Policlinico Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001265"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "786",
      "display" : "FARMACIA DI SCOPELLO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "002135"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "1215",
      "display" : "FARMACIA BARBERIS S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004208"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "1248",
      "display" : "DUOMO SNC DI BOFFA MIRELLA E DRAGO ALESSANDRO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004003"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "1449",
      "display" : "FARMACIA CERRINA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006059"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "1589",
      "display" : "Farmacia Guidetti",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016024"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "1692",
      "display" : "FARMACIA DI SOLTO COLLINA S.A.S. DI DUEVI S.R.L. & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016200"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "1719",
      "display" : "FARMACIA DI MISANO S.A.S. - DR.SSA CRISTINA TOMASELLI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016135"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "1879",
      "display" : "FARMACIA MARCHI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017011"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "1922",
      "display" : "CAZZAGO SAN MARTINO SERVIZI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017046"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "2031",
      "display" : "FARMACIA DI VIA VOLTA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "2063",
      "display" : "FARMACIA VALCAMONICA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017133"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "2069",
      "display" : "FARMACIA S. GOTTARDO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017190"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "2642",
      "display" : "Farmacia Marinoni",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "2821",
      "display" : "Farmacia Comina Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "2854",
      "display" : "FARMACIA MADIA SAS DEL DR. MADIA DARIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "2925",
      "display" : "FARMACIA BLIGNY SAS DEL DR. GIOVANNI BRAMBILLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "3038",
      "display" : "farmagorà garbagnate",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015105"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "3165",
      "display" : "FARMACIA SAN FELICE S.N.C. DI CASTOLDI PAOLA E ALFIERI FRANCESCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015182"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "3223",
      "display" : "Farmagora' cernusco s.n.1 s.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015070"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "3453",
      "display" : "FARMACIA MOTTA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108033"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "3467",
      "display" : "FARMACIA BECCARELLI SAS DI MONTI ANNAMARIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108045"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "3772",
      "display" : "Farmacia Dolci Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "014018"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "3889",
      "display" : "Farmacia Olona s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012080"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "3919",
      "display" : "Farmacia Fior Di Loto Delle Dott. Francesca E Letizia Di Mino E Maria Carla Casucci S.n.c.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012127"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "3943",
      "display" : "SAN FRANCESCO-AMADEO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012122"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4214",
      "display" : "FARMACIA BETTI S.A.S. DIHIPPO 156 FARMA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "022061"
        },
        {
          "code" : "provincia",
          "valueCode" : "022"
        },
        {
          "code" : "regione",
          "valueCode" : "042"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4435",
      "display" : "FARMACIA SAN LUIGI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024118"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4602",
      "display" : "FARMACIE GT DEL DOTTOR LUIGI GIACOMELLI & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026083"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4617",
      "display" : "FARMACIE GT DEL DOTT. LUIGI GIACOMELLI & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026006"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4647",
      "display" : "Farmacia alla Madonna S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026012"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4672",
      "display" : "FARMACIA BROTTO SAS DELLA DR.SSA PIERA BROTTO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026041"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4696",
      "display" : "FARMACIA FERRARI S.A.S. DEL DR. FERRARI LORENZO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026074"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4735",
      "display" : "Farm. S. Cristina sas del Dott. Daniele Puppato e C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026064"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4945",
      "display" : "Centrale Dr. Gianluca Trevisani",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027021"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "4993",
      "display" : "AL DOGE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028032"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "5025",
      "display" : "FARMACIA LAGO S.N.C. DI MARIA GRAZIA LAGO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028100"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "5035",
      "display" : "AL REDENTORE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028016"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "5114",
      "display" : "VERONESE MARINA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028072"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "5134",
      "display" : "Farmacia Guggi Madonna della Salute",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028027"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "5350",
      "display" : "FARMACIA GIOVANNI XXIII SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023071"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "5570",
      "display" : "FARMACIA ALL'ANGELO DELLE DOTTORESSE ROSSELLA E ALESSANDRA OLIVET TI SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "031016"
        },
        {
          "code" : "provincia",
          "valueCode" : "031"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "5585",
      "display" : "ALL'ORSO BRUNO - PROVVIDENTI DOTT.SSA LAURA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "031007"
        },
        {
          "code" : "provincia",
          "valueCode" : "031"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "5608",
      "display" : "FARMACIA TOSONI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030121"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "6046",
      "display" : "SANTA CATERINA DI BEYOND PHARMA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "6501",
      "display" : "Farmacia Linardis",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034027"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "6761",
      "display" : "LAFARMACIA.SANTA FILOMENA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "7047",
      "display" : "FARMACIA DUE MADONNE SNC DELLA DR.SSA CLAUDIA SAVINI & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037006"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "7107",
      "display" : "FARMACIA MARANGONI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "038001"
        },
        {
          "code" : "provincia",
          "valueCode" : "038"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "7258",
      "display" : "BOSCHINI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "7352",
      "display" : "FARMACIA MAGNANELLIS.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040041"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "7718",
      "display" : "FARMACIA PICCININI S.N.C. DEL DOTT. ENRICO MORGANTINI E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "7728",
      "display" : "FARMACIA FEDELI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050026"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "7764",
      "display" : "FARMACIA CERRI S.N.C. DEI DOTTORI PIETRO E FRANCESCO CERRI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "050039"
        },
        {
          "code" : "provincia",
          "valueCode" : "050"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "7777",
      "display" : "FARMACIA GIORDANI S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "049006"
        },
        {
          "code" : "provincia",
          "valueCode" : "049"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "8486",
      "display" : "FARMACIA PASSAGGIO DI BETTONA DI FRANCONE DOTT.ANTONIO & C. S.N.C .",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054038"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "8504",
      "display" : "Farmacia Loreti Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054005"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "8945",
      "display" : "FARM. DI CRISTOFARO D.SSA ROBERTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "043058"
        },
        {
          "code" : "provincia",
          "valueCode" : "043"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "8969",
      "display" : "FARMACIA VALORI DI VALORI DR. PATRIZIO E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "109008"
        },
        {
          "code" : "provincia",
          "valueCode" : "109"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9024",
      "display" : "EREDI D'ANGELO PASQUALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044063"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9221",
      "display" : "GRUPPO FARMACIE IGEA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9249",
      "display" : "FARMACIA DOTTORI DAMIANI SOCIETA' A RESPONSABILITA' LIMITATA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9428",
      "display" : "FARMACIA MAZZINI SOCIETA' INNOME COLLETTIVO DEL DR. SERGIO SER RAINOE C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9485",
      "display" : "FARMACIA DELLA CAFFARELLA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9500",
      "display" : "FARMACIA ROMITA DEI DOTTORI CARMELITA E PIERLUIGI ROMITA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9514",
      "display" : "FARMACIA SAN GIUSEPPE S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9565",
      "display" : "FARMACIA DEGLI ESTENSI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9699",
      "display" : "GRUPPO FARMACIE IGEA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9742",
      "display" : "FARMACIA BALDUINA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "9973",
      "display" : "Farmacia Pavona SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058003"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "10078",
      "display" : "FARMACIA FRATERNALE SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "056030"
        },
        {
          "code" : "provincia",
          "valueCode" : "056"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "10201",
      "display" : "farmacia cantalupo s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "057010"
        },
        {
          "code" : "provincia",
          "valueCode" : "057"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "10257",
      "display" : "FIORE LUCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059007"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "10260",
      "display" : "FARMACIA SAVO FIORELLA & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059001"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "10866",
      "display" : "Iannetti-Caccia  SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "067041"
        },
        {
          "code" : "provincia",
          "valueCode" : "067"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "11317",
      "display" : "FARMACIA BALISCIANO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "062055"
        },
        {
          "code" : "provincia",
          "valueCode" : "062"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "11797",
      "display" : "FARMACIA GARZIA SAS DI GARZIA LUCIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "11897",
      "display" : "FARMACIA GARZIA SAS DI GARZIA LUCIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063045"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "11974",
      "display" : "EREDI BRUNO GUIDO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063023"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "13191",
      "display" : "Farmacia Dott.ssa Chiara Errico",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075035"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "13248",
      "display" : "GIUSTIZIERI MARIO DONATO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075029"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "13468",
      "display" : "GROTTOLI DOTT.SSA GIOVANNA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073027"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "13527",
      "display" : "FARMACIA ACERENZA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076002"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "14502",
      "display" : "Farmacia Moribondo snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084001"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "14689",
      "display" : "FARMACIA PITTARI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "14763",
      "display" : "FARMACIA DELLA PLAJA DEL DR. VENUTO PIETRO & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "15015",
      "display" : "FARMACIA GUGLIOTTA S.R.L. A SOCIO UNICO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083066"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "15044",
      "display" : "Farmacia LO BALBO della D.ssa Sidoti Pinto Alda Maria",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083078"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "15126",
      "display" : "FARMACIA FERRI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083007"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "15187",
      "display" : "Farmacia Castelli Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083049"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "15497",
      "display" : "Farmacia Curreri srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082070"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "15559",
      "display" : "Farmacia Guastella di Guastella V &C SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088012"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "15930",
      "display" : "FARMACIA F.lli Cogoni snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "104004"
        },
        {
          "code" : "provincia",
          "valueCode" : "104"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "16263",
      "display" : "Farmacia Murtas S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "16276",
      "display" : "Farmacia Murtas S.r.l",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "092009"
        },
        {
          "code" : "provincia",
          "valueCode" : "092"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "16649",
      "display" : "COMUNALE N.1 LUGO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039012"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "16956",
      "display" : "Farmacia Internazionale S.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042018"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "17147",
      "display" : "FARMACIA GARZIA SAS DI GARZIA LUCIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063023"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "18751",
      "display" : "Farmacia San Lorenzo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "096012"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "18875",
      "display" : "FARMACIE GT DEL DOTTOR LUIGI GIACOMELLI & C.  S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026006"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "18885",
      "display" : "COMUNALE CARMIGNANESE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028023"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "19197",
      "display" : "Del Sole Snc Dott.sse De Vito Luana E Lubelli Chiara Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075097"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "19634",
      "display" : "Farmacia Valle Fiorita sas del dott. Giovanni Tipaldi & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "19647",
      "display" : "Farmagorà Bovolone srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023012"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "20112",
      "display" : "FARMACIA AGELLUM SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098061"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "20254",
      "display" : "Farmacia Sant'Anna SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023006"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21013",
      "display" : "Farmacia Ponente Snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21014",
      "display" : "SO.GE.F.  S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058059"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21015",
      "display" : "FARMACIA CUSIGNANA S.N.C.DEI DR. T. GALLON E F.ZANATTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026032"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21016",
      "display" : "FARMACIA PALATTELLA-SPORTELLI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072035"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21017",
      "display" : "Farmacia Tecnopolo Tiburtino",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21018",
      "display" : "Angela Oppido",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063034"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21019",
      "display" : "Marsoner Zita",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "021020"
        },
        {
          "code" : "provincia",
          "valueCode" : "021"
        },
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21020",
      "display" : "FARMACIA SANT'ANDREA SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21021",
      "display" : "FARMACIA PONTICELLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082021"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21022",
      "display" : "FARMACIA DEL MARE S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "088010"
        },
        {
          "code" : "provincia",
          "valueCode" : "088"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "21023",
      "display" : "FARMACIA SANTA CROCE DELLA DR.SSA GIOVANNA CECCHETTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028032"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-03-01"
        }
      ]
    },
    {
      "code" : "099",
      "display" : "FARMACIA SAN DOMENICO sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "206",
      "display" : "Sardi S.N.C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "268",
      "display" : "FARMACIA SANT'AGNESE S.A.S. DELLA DOTT.SSA GUIDETTI ROBERTA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001272"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "905",
      "display" : "CASI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "003083"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1099",
      "display" : "MARRO ELEONORA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004068"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1108",
      "display" : "ANDREIS SAS DI TOMATIS MICHELA E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004043"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1113",
      "display" : "MANA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004189"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1137",
      "display" : "FARMACIA BARTOLOMEI DI BARTOLOMEI GABRIELE E C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004201"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1218",
      "display" : "VAMAS PHARMA DI MATTIA SAVIO E VALENTINA SCHIFONE S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004029"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1470",
      "display" : "FARMACIA PIEVE  DEI DOTTORI LUDOVICI GIANLUCA, RAVERA FRANCESCA E TRAVERSO CINZIA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006114"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1573",
      "display" : "FARMACIA GIANNI S.A.S. - DR. MARIO GIANNI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016096"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1581",
      "display" : "Farmacia Pagnoncelli s.a.s. Dr. Maurizio Pagnoncelli Folcieri & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016194"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1622",
      "display" : "FARMACIA REGINA PACIS DEL DOTT. GREGORIO ALFONSO & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016069"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1638",
      "display" : "CIMARELLI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016104"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1728",
      "display" : "FARMACIA GIACHERIO - DR.MARCO GIACHERIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016178"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "1783",
      "display" : "FARMACIA SAN GIOVANNI DI PIUSALUTE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016207"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "2207",
      "display" : "SAN MARTINO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "013075"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "2326",
      "display" : "farmacia Pedrani s.a.s.di Pedrani adele Carla& C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "097084"
        },
        {
          "code" : "provincia",
          "valueCode" : "097"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "2574",
      "display" : "farmacia dr.ssa raffaella tarana",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020022"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "2641",
      "display" : "PISANI 26 SAS DEL DR. POLVER ANGELO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "2806",
      "display" : "Farmacia Vigentino srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "2817",
      "display" : "FARMACIA AMBROSIANAS.N.C. DEL DR. SLAVIEROGIOVANNI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015146"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "3060",
      "display" : "FARMACIA SAN MARTINO SAS DELLA DR.SSA GIULIANA MAGISTRALI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015012"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "3340",
      "display" : "Ceccolini sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108010"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "3401",
      "display" : "Comunale N.1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108019"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "3460",
      "display" : "Farmacia Re sas della Dott.ssa Cinzia Re",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108039"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "3503",
      "display" : "FARMACIA DUSE S.N.C. DELDR. DUSE EMANUELE & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "108033"
        },
        {
          "code" : "provincia",
          "valueCode" : "108"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "3710",
      "display" : "FARMACIA CAPITELLI SNC DI CAPITELLI CARLO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018048"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "3808",
      "display" : "FARMACIA DI GAZZADA S.A.S. DEL DOTT. PONTE FRANCESCO E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012073"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "3872",
      "display" : "FARMACIA DI BOLLADELLO DEI DOTTORI UMBERTO SABBIONI E DIEGO CAGNOLA S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012029"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4023",
      "display" : "FARMACIA ROMAGNOLO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017065"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4287",
      "display" : "FARMACIE CHIMENTI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025006"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4298",
      "display" : "FARMACIE DOLOMITI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025033"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4307",
      "display" : "Farmacia Dolomiti Belluno Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025006"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4326",
      "display" : "FARMACIE CHIMENTI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025006"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4344",
      "display" : "FARMACIE DOLOMITI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025074"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4347",
      "display" : "Farmacia Dolomiti Del Dr. Alberto Da Pian & C. S.a.s.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025074"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4432",
      "display" : "FARMACIA MACCAFERRI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024113"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4624",
      "display" : "FARMACIE CHIMENTI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026024"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4641",
      "display" : "FARMACIA ZUCCHETTO SNC DEL DOTT.  ANTONIO ZUCCHETTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026087"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "4933",
      "display" : "FARMACIA ARINO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027012"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5004",
      "display" : "FARMACIA SS. SIMONE E MARISA S.A.S. DI CAVINATO TOMMASO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028063"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5058",
      "display" : "FARMACIA ALLA STAZIONE SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5072",
      "display" : "FARMACIA ARCELLA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5163",
      "display" : "FARMACIA MARTINI SNC  DEI DR. MARTINI GIULIANO E LUCA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028105"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5239",
      "display" : "FARMACIA NADALINI SAS DEL DOTT. GUIDO FRANCESCHETTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "029001"
        },
        {
          "code" : "provincia",
          "valueCode" : "029"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5269",
      "display" : "MADONNA DEL POPOLO DEL DOTT. UGOLOTTI ANTONIO E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5284",
      "display" : "FARMACIA LIO DEL DOTT. LIO GIULIANO E C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023091"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5309",
      "display" : "FARMACIA SAN GIUSEPPE DI VALENTINI PAOLA & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023069"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5385",
      "display" : "FARMACIA DE VECCHI DI ROSSIGNOLI CARLA E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023095"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5500",
      "display" : "Farmacia Aquilinia",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032003"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5505",
      "display" : "Alla Madonna-Farmacie Neri SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032006"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5528",
      "display" : "SAN ROCCO-FARMACIE NERI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "032003"
        },
        {
          "code" : "provincia",
          "valueCode" : "032"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5648",
      "display" : "ADR del dr. Alessandro Da Re & C. S.A.S. Farmacia Canova",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030013"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5788",
      "display" : "FARMACIA MADONNA DELLE GRAZIE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093033"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5818",
      "display" : "FARMACIA BORSATTI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093033"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5908",
      "display" : "FARMACIA FILIPPI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "011020"
        },
        {
          "code" : "provincia",
          "valueCode" : "011"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5931",
      "display" : "MONGRIFONE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009056"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5940",
      "display" : "Farmacia Fumagalli del dr.Alberto Fumagalli & C. snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009005"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5979",
      "display" : "FARMACIA RANALDO DI RANALDO ROBERTO E C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009068"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "5981",
      "display" : "SAN NICOLO'",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "009004"
        },
        {
          "code" : "provincia",
          "valueCode" : "009"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "6475",
      "display" : "Farmacia Maiocchi di Maiocchi Matteo e C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "033025"
        },
        {
          "code" : "provincia",
          "valueCode" : "033"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "6533",
      "display" : "ANTICA FARMACIA SIVIERO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034010"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "6554",
      "display" : "FARMACIA GUASTI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034030"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "6615",
      "display" : "FARMACIA SAN DONNINO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034014"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "6857",
      "display" : "FARMACIA SAN MICHELE SAS DELLA DR.SSA SILVANA CASALE & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036040"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "6898",
      "display" : "farmacia pian del voglio",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "037051"
        },
        {
          "code" : "provincia",
          "valueCode" : "037"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "7262",
      "display" : "FARMACIA MODERNA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "039014"
        },
        {
          "code" : "provincia",
          "valueCode" : "039"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "7327",
      "display" : "FARMACIA MONTEMAGGI DI DAVIDE E ISABELLA TAGLIAVINI S.N.C. IN B REVE FARMACIA MONTEMAGGI S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "040007"
        },
        {
          "code" : "provincia",
          "valueCode" : "040"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "7384",
      "display" : "FARMACIA MERLI DI MERLI OTELLO E FIGLI S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "099013"
        },
        {
          "code" : "provincia",
          "valueCode" : "099"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "7515",
      "display" : "FARMACIA MOLLICA DR. MOLLICA MICHELE ANTONIO E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046003"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "7535",
      "display" : "FARMACIA MOLLICA DR. MOLLICA MICHELE ANTONIO E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "046036"
        },
        {
          "code" : "provincia",
          "valueCode" : "046"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "7597",
      "display" : "Farmacia Betti dr. Francesco Pecori Vettori",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "047010"
        },
        {
          "code" : "provincia",
          "valueCode" : "047"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "7951",
      "display" : "ANTICA FARMACIA DEL CERVO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "051002"
        },
        {
          "code" : "provincia",
          "valueCode" : "051"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "8139",
      "display" : "ROSATI sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "048052"
        },
        {
          "code" : "provincia",
          "valueCode" : "048"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "8451",
      "display" : "Antica Farmacia Sas di Gruppo Bartoli Farmacie Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054039"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "8545",
      "display" : "FARMACIA BARTOLI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "054004"
        },
        {
          "code" : "provincia",
          "valueCode" : "054"
        },
        {
          "code" : "regione",
          "valueCode" : "100"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "8850",
      "display" : "FARMACIA FIORI ANSELMI FEDERICA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042014"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "8872",
      "display" : "FARMACIA TURANO SAS DEL DR.GIOACCHINO TURANO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "042048"
        },
        {
          "code" : "provincia",
          "valueCode" : "042"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "8974",
      "display" : "FARM. MONTAPPONE DR. PAOLO SARDELLINI E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "109013"
        },
        {
          "code" : "provincia",
          "valueCode" : "109"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9021",
      "display" : "AMADIO DI TRIBOTTI SIMONETTA   s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "044045"
        },
        {
          "code" : "provincia",
          "valueCode" : "044"
        },
        {
          "code" : "regione",
          "valueCode" : "110"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9111",
      "display" : "Farmacia Mostacci SNC del Dr. Franco Mostacci & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9150",
      "display" : "Guidotti SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9208",
      "display" : "FARMACIA TRE MADONNE 2 SAS DELLA DOTTSSA MARIA BEATRICE LABATE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9248",
      "display" : "FARMACIA CASINI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9268",
      "display" : "Marcello srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9286",
      "display" : "FARMACIE SANASI GIGLIOLI SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9394",
      "display" : "FARMACIA COLLI ANIENE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9643",
      "display" : "FARMACIA CASARANO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9672",
      "display" : "farmacia sanasi aurelia snc",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9690",
      "display" : "BORNEO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058091"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "9898",
      "display" : "FARMACIA STAZI SAS DI STAZI DR. UBALDO & C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058040"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "10008",
      "display" : "FARMACIA DI TULLIO DEL DOTT. DI TULLIO GIORGIO & C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "058088"
        },
        {
          "code" : "provincia",
          "valueCode" : "058"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "10229",
      "display" : "Farmacia del Centro sas di  Camporeale Clorinda",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059024"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "10281",
      "display" : "FARMACIA TERENZIO SAS DEL DR. DANIELE TERENZIO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059007"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "10323",
      "display" : "Farmacia Papagno sas di Papagno Pasquale e Co.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059011"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "10368",
      "display" : "FARMACIA TALLARICO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "060035"
        },
        {
          "code" : "provincia",
          "valueCode" : "060"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "10538",
      "display" : "FARMACIA DI VITO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "066107"
        },
        {
          "code" : "provincia",
          "valueCode" : "066"
        },
        {
          "code" : "regione",
          "valueCode" : "130"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "11029",
      "display" : "Farmacia Ferrara Dott.ssa Ida",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "070014"
        },
        {
          "code" : "provincia",
          "valueCode" : "070"
        },
        {
          "code" : "regione",
          "valueCode" : "140"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "11241",
      "display" : "FARMACIA GAMMARINO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "064093"
        },
        {
          "code" : "provincia",
          "valueCode" : "064"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "11569",
      "display" : "ASTRA DR. VINCENZO ALTIERO SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "11577",
      "display" : "Farmacia Riviera Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "11633",
      "display" : "PANTANO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "11781",
      "display" : "FARMACIA MONTEOLIVETO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063049"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "11943",
      "display" : "FARMACIA LANNA SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063011"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "12007",
      "display" : "FARMACIA INNOCENTI - RAINONE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063076"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "12158",
      "display" : "Farmacie Pisano S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063084"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "12159",
      "display" : "Farmacie Pisano S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063084"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "12171",
      "display" : "FARMACIA DEL ROSARIO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063058"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "12562",
      "display" : "GIANNONE MARIO CENTRALE",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110002"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "12840",
      "display" : "Farmacia Serio S.n.c di Serio Maria Teresa",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "072036"
        },
        {
          "code" : "provincia",
          "valueCode" : "072"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "12895",
      "display" : "FARMACIA MATARRESE DI CORSO MAZZINI S.N.C",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "074012"
        },
        {
          "code" : "provincia",
          "valueCode" : "074"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "13029",
      "display" : "FARMACIA SANSONE S.A.S. DEL DOTTOR SANSONE CARLO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "071031"
        },
        {
          "code" : "provincia",
          "valueCode" : "071"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "13043",
      "display" : "Farmacia Cirillo dott. Michele Brandi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "110010"
        },
        {
          "code" : "provincia",
          "valueCode" : "110"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "13260",
      "display" : "FARMACIA PICCIOLO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "075058"
        },
        {
          "code" : "provincia",
          "valueCode" : "075"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "13480",
      "display" : "FARMACIA SPIRITO SANTO SOCIETA' A RESPONSABILITA' LIMITATA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "073012"
        },
        {
          "code" : "provincia",
          "valueCode" : "073"
        },
        {
          "code" : "regione",
          "valueCode" : "160"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "13583",
      "display" : "CILIBRIZZI MARIA ANTONIETTA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "076077"
        },
        {
          "code" : "provincia",
          "valueCode" : "076"
        },
        {
          "code" : "regione",
          "valueCode" : "170"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "13947",
      "display" : "FARMACIA BENEDUCE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "078116"
        },
        {
          "code" : "provincia",
          "valueCode" : "078"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "14039",
      "display" : "Trimini' Giuseppe Felice Danilo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "079110"
        },
        {
          "code" : "provincia",
          "valueCode" : "079"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "14334",
      "display" : "FARMACIA D'AGOSTINO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "080093"
        },
        {
          "code" : "provincia",
          "valueCode" : "080"
        },
        {
          "code" : "regione",
          "valueCode" : "180"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "14470",
      "display" : "Farmacia Alessi srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084027"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "14488",
      "display" : "FARMACIA CALDARA DI CALDARA FRANCESCO SOCIETA' IN NOME COLLETTIVO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "084035"
        },
        {
          "code" : "provincia",
          "valueCode" : "084"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "14596",
      "display" : "farmacia clementi s.r.l.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085007"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "14613",
      "display" : "Farmacia Galeno SRL Semplificata",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "085013"
        },
        {
          "code" : "provincia",
          "valueCode" : "085"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "14676",
      "display" : "PHARMA ETNEA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087015"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "14687",
      "display" : "FARMACIA BUSCEMI S.A.S. DI BUSCEMI PAOLO ANTONIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "087039"
        },
        {
          "code" : "provincia",
          "valueCode" : "087"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "14940",
      "display" : "Farmacia Dott.ssa Mendola Cristina & C. SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "086015"
        },
        {
          "code" : "provincia",
          "valueCode" : "086"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "15083",
      "display" : "Farmacia Maria Angela Crimi Sas",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083030"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "15109",
      "display" : "FARMACIA MADONNA DELLA PROVVIDENZA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "083004"
        },
        {
          "code" : "provincia",
          "valueCode" : "083"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "15313",
      "display" : "farmacia porta guccia srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "082053"
        },
        {
          "code" : "provincia",
          "valueCode" : "082"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "15780",
      "display" : "FARMACIA ROTOLO DEL DOTT. SALVATORE SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081015"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "15805",
      "display" : "FARMACIA DR FANARA - S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "081005"
        },
        {
          "code" : "provincia",
          "valueCode" : "081"
        },
        {
          "code" : "regione",
          "valueCode" : "190"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "16086",
      "display" : "Farmacia Lisu del Dr Fabrizio Lisu",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "095026"
        },
        {
          "code" : "provincia",
          "valueCode" : "095"
        },
        {
          "code" : "regione",
          "valueCode" : "200"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "17052",
      "display" : "FARMACIA MRC MONTECORVINO-Comunale",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065073"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "17060",
      "display" : "Farmacia Il Pavone Srl",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "063035"
        },
        {
          "code" : "provincia",
          "valueCode" : "063"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "17123",
      "display" : "FARMACIA ZORLESCO SNC DI CONGI & MADIA",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "098010"
        },
        {
          "code" : "provincia",
          "valueCode" : "098"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "17195",
      "display" : "FARMACIA INTERNAZIONALE DI CONEGLIANO S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026021"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "17995",
      "display" : "San Riccardo di Dott. Pizzi Emanuele Aurelio E C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015171"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "18040",
      "display" : "Farmacia San Donato del Dr. Pietro Ciccarelli",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "065074"
        },
        {
          "code" : "provincia",
          "valueCode" : "065"
        },
        {
          "code" : "regione",
          "valueCode" : "150"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "18061",
      "display" : "FARMACIA AIOLFI DEL DR. AIOLFI EGIDIO & C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016183"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "18199",
      "display" : "FARMACIA NUOVA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017021"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "18215",
      "display" : "FARMACIA BALCONI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "023058"
        },
        {
          "code" : "provincia",
          "valueCode" : "023"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "18418",
      "display" : "FARMACIA GHIRARDI DEL DR. GHIRARDI MARIO E C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016015"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "18629",
      "display" : "FARMCIA COMUNALE DI CORBETTA N 1",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015085"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "18772",
      "display" : "FARMACIA CASTELLETTO DEL DOTT. MARINO BARBI & C. S.N.C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "006051"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "19025",
      "display" : "SANTA RITA SNC DI CARLA DAMAGINO  E ROBERTO DE RUVO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001051"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "19297",
      "display" : "FARMACIA DEI SANTI SAS DEL DOTT. CRISTIANO CORDANI",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "034051"
        },
        {
          "code" : "provincia",
          "valueCode" : "034"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "19438",
      "display" : "FARMACIA DELL'ASSUNTA S.A.S. DEL DOTTOR BENVENUTI R. & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028060"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "19486",
      "display" : "Farmacia Di Lutrano S.a.s. Del Dott. Stefano Gatto",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "026028"
        },
        {
          "code" : "provincia",
          "valueCode" : "026"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "19693",
      "display" : "Farmacia Di Sarnico Snc Del dr Luca Franco & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016193"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "19920",
      "display" : "Farmacia San Francesco Dei Dottori Cavagnini-maffezzoli-lena S.n.c",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017188"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "20362",
      "display" : "FARMACIA SAN NICOLO' DELLA FARMACIA COLOMBO S.A.S. - DR.SSA GIULIA COLOMBO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016076"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "20465",
      "display" : "Farmacia Comunale di Corbetta n.2",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "015085"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "20484",
      "display" : "Farmacia San Giacomo SNC di Dott.sse Renata e Paola Tricella",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017029"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "20497",
      "display" : "FARMACIA LA PISANA - SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "052022"
        },
        {
          "code" : "provincia",
          "valueCode" : "052"
        },
        {
          "code" : "regione",
          "valueCode" : "090"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "20598",
      "display" : "DISPENSARIO FARMACIE DOLOMITI SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "025032"
        },
        {
          "code" : "provincia",
          "valueCode" : "025"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "3"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "21012",
      "display" : "Farmacia Madonna dell'Olmo",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "059005"
        },
        {
          "code" : "provincia",
          "valueCode" : "059"
        },
        {
          "code" : "regione",
          "valueCode" : "120"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-02-01"
        }
      ]
    },
    {
      "code" : "441",
      "display" : "SANT'ALBERTO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "001130"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "1245",
      "display" : "GALLUCCI E C. S.A.S.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "004011"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "1570",
      "display" : "FARMACIA COLOMBO S.A.S. - DR.SSA GIULIA COLOMBO & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016076"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "1645",
      "display" : "FARMACIA FAPPANI DI BOLTIERE SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016029"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "1744",
      "display" : "FARMACIA CENTRALE S.N.C. - DR.RI FRANCO E GIULIA PERSONENI & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "016077"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "1887",
      "display" : "FARMACIA MAGLI DI MAGLI LAURA &C SNC",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "017125"
        },
        {
          "code" : "provincia",
          "valueCode" : "017"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "2515",
      "display" : "FARMACIA EREDI ELISA SILVESTRI DI PIZZAMIGLIO PAOLO & C. S.A.S",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "020030"
        },
        {
          "code" : "provincia",
          "valueCode" : "020"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "3615",
      "display" : "APOSTOLICO ANTONIO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "018148"
        },
        {
          "code" : "provincia",
          "valueCode" : "018"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "3814",
      "display" : "FARMACIA CONTINI S.A.S. DEL DOTT, CONTINI RAFFAELE E C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012076"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "3962",
      "display" : "FARMACIA S. ANNA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "012034"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "4132",
      "display" : "STADTAPOTHEKE STERZING O.H.G. DES DR. MAIR WALTER & C.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "021115"
        },
        {
          "code" : "provincia",
          "valueCode" : "021"
        },
        {
          "code" : "regione",
          "valueCode" : "041"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "4534",
      "display" : "Farmacia Galvan SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "024116"
        },
        {
          "code" : "provincia",
          "valueCode" : "024"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "4860",
      "display" : "ALL'ALA D'ORO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "027042"
        },
        {
          "code" : "provincia",
          "valueCode" : "027"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "5147",
      "display" : "FARMACIA ZENNARO",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "028055"
        },
        {
          "code" : "provincia",
          "valueCode" : "028"
        },
        {
          "code" : "regione",
          "valueCode" : "050"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "5697",
      "display" : "FATTOR - ADL SALUTE DI DAMIANO DE GRASSI E ANTONIETTA BIASIOLI &C. SAS",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "030129"
        },
        {
          "code" : "provincia",
          "valueCode" : "030"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "5803",
      "display" : "LAFARMACIA.ESCULAPIO SRL",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "093037"
        },
        {
          "code" : "provincia",
          "valueCode" : "093"
        },
        {
          "code" : "regione",
          "valueCode" : "060"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "6078",
      "display" : "FARMACIA GIANELLI S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "010025"
        },
        {
          "code" : "provincia",
          "valueCode" : "010"
        },
        {
          "code" : "regione",
          "valueCode" : "070"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "6697",
      "display" : "FARMACIA ALTHEA S.R.L.",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "035012"
        },
        {
          "code" : "provincia",
          "valueCode" : "035"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-01-01"
        }
      ]
    },
    {
      "code" : "6754",
      "display" : "LloydsFarmacia Comunale Viale Storchi",
      "property" : [
        {
          "code" : "comune",
          "valueCode" : "036023"
        },
        {
          "code" : "provincia",
          "valueCode" : "036"
        },
        {
          "code" : "regione",
          "valueCode" : "080"
        },
        {
          "code" : "tipologia",
          "valueCode" : "1"
        },
        {
          "code" : "dataInizio",
          "valueDateTime" : "2023-