# MDS - Esenzione dal ticket - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **MDS - Esenzione dal ticket**

## CodeSystem: MDS - Esenzione dal ticket 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/mds-esenzioni | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsEsenzioni |

 
MDS - Codici per l'esezione dal ticket 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsMinisteroSaluteEsenzioni](ValueSet-vs-mds-esenzioni.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "mds-esenzioni",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/mds-esenzioni",
  "version" : "0.1.2",
  "name" : "CsEsenzioni",
  "title" : "MDS - Esenzione dal ticket",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "MDS - Codici per l'esezione dal ticket",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 21,
  "concept" : [
    {
      "code" : "E01",
      "display" : "Cittadini di età inferiore a 6 anni e superiore a 65 anni, appartenenti ad un nucleo familiare con reddito annuo complessivo non superiore a 36.151,98 euro."
    },
    {
      "code" : "E02",
      "display" : "Disoccupati e loro familiari a carico appartenenti ad un nucleo familiare con un reddito annuo complessivo inferiore a 8.263,31 euro, incrementato fino a 11.362,05 euro in presenza del coniuge ed in ragione di ulteriori 516,46 euro per ogni figlio a carico."
    },
    {
      "code" : "E03",
      "display" : "Titolari di pensioni sociali e loro familiari a carico."
    },
    {
      "code" : "E04",
      "display" : "Titolari di pensioni al minimo di età superiore a 60 anni e loro familiari a carico, appartenenti ad un nucleo familiare con un reddito annuo complessivo inferiore a 8.263,31 euro, incrementato fino a 11.362,05 euro in presenza del coniuge ed in ragione di ulteriori 516,46 euro per ogni figlio a carico."
    },
    {
      "code" : "E52",
      "display" : "Soggetti sottoposti a trapianto (rene, cuore, polmone, fegato, pancreas, midollo, intestino)"
    },
    {
      "code" : "G01",
      "display" : "Invalidi di guerra appartenenti alle categorie dalla 1° alla 5° titolari di pensione diretta vitalizia e deportati in campi di sterminio (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "L01",
      "display" : "Grandi invalidi del lavoro dall'80% al 100% di invalidità (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "L02",
      "display" : "Invalidi del lavoro con riduzione della capacità lavorativa > 2/3 dal 67% al 79% di invalidità (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "S01",
      "display" : "Grandi invalidi per servizio appartenenti alla 1° categoria, titolati di specifica pensione (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "S02",
      "display" : "Invalidi per servizio appartenenti alle categorie dalla 2° alla 5° (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "C01",
      "display" : "Invalidi civili al 100% di invalidità senza indennità di accompagnamento (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "C02",
      "display" : "Invalidi civili al 100% di invalidità con indennità di accompagnamento (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "C03",
      "display" : "Invalidi civili con riduzione della capacità lavorativa superiore a 2/3 dal 67% al 99% di invalidità (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "C04",
      "display" : "Invalidi < di 18 anni con indennità di frequenza ex art. 1 L. 289/90 (ex art.5 D.lgs. 124/98)"
    },
    {
      "code" : "C05",
      "display" : "Ciechi assoluti o con residuo visivo non superiore a 1/10 ad entrambi gli occhi riconosciuti dalla Commissione Invalidi Ciechi Civili (art.6 DM 1.2.1991)"
    },
    {
      "code" : "C06",
      "display" : "Sordomuti (chi è colpito da sordità dalla nascita o prima dell'apprendimento della lingua parlata - art.6 DM 1.2.1991, ex art.7 L.482/68 come modificato dalla L.68/99)"
    },
    {
      "code" : "V01",
      "display" : "Vittime atti di terrorismo e stragi e familiari (L. 206/04) /vittime dovere e familiari superstiti (D.P.R. 7 luglio 2006, n. 243)"
    },
    {
      "code" : "G02",
      "display" : "Invalidi di guerra militari appartenenti alle categorie dalla 6° alla 8° (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "L03",
      "display" : "Invalidi del lavoro con riduzione della capacità lavorativa fino a 2/3 dall'1% a 66% di invalidità (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "L04",
      "display" : "Infortunati sul lavoro o affetti da malattie professionali (ex art.6 DM 1.2.1991)"
    },
    {
      "code" : "S03",
      "display" : "Invalidi per servizio appartenenti alla categoria dalla 6° all'8° (ex art.6 DM 1.2.1991)"
    }
  ]
}

```
