# MDS - ID Strutture Interne di Ricovero - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **MDS - ID Strutture Interne di Ricovero**

## CodeSystem: MDS - ID Strutture Interne di Ricovero 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/cs-mds-idStruttureInterne | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsMDSIdStruttureInterne |

 
MDS - Identificativi Strutture Interne di Ricovero 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsMinisteroSaluteIdStruttureInterne](ValueSet-minsan-idStruttureInterne.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cs-mds-idStruttureInterne",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/cs-mds-idStruttureInterne",
  "version" : "0.1.2",
  "name" : "CsMDSIdStruttureInterne",
  "title" : "MDS - ID Strutture Interne di Ricovero",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "MDS - Identificativi Strutture Interne di Ricovero",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 455,
  "concept" : [
    {
      "code" : "010030.01",
      "display" : "OSPEDALE CIVILE E.AGNELLI"
    },
    {
      "code" : "010030.03",
      "display" : "OSPEDALE DI POMARETTO"
    },
    {
      "code" : "010079.01",
      "display" : "OSPEDALE DEGLI INFERMI"
    },
    {
      "code" : "010079.02",
      "display" : "OSPEDALE CIVILE DI GIAVENO"
    },
    {
      "code" : "010079.04",
      "display" : "OSPEDALE CIVILE DI SUSA"
    },
    {
      "code" : "010079.05",
      "display" : "OSPEDALE DI VENARIA"
    },
    {
      "code" : "010079.06",
      "display" : "UNITA' AUTONOMA DI DAY SURGERY DI AVIGLI"
    },
    {
      "code" : "010019.01",
      "display" : "PRESIDIO OSPED. RIUNITO SEDE DI CIRIE'"
    },
    {
      "code" : "010019.03",
      "display" : "PRESIDIO OSPED. RIUNITO SEDE DI LANZO"
    },
    {
      "code" : "010023.01",
      "display" : "OSPEDALE CIVILE DI IVREA"
    },
    {
      "code" : "010023.02",
      "display" : "OSPEDALE CIVILE DI CUORGNE'"
    },
    {
      "code" : "010023.04",
      "display" : "SAAPA S.P.A."
    },
    {
      "code" : "010004.01",
      "display" : "OSPEDALE MAGGIORE"
    },
    {
      "code" : "010004.02",
      "display" : "OSPEDALE SANTA CROCE"
    },
    {
      "code" : "010004.03",
      "display" : "OSPEDALE SAN LORENZO"
    },
    {
      "code" : "010004.04",
      "display" : "DAY SURGERY DEL DISTRETTO DI NICHELINO"
    },
    {
      "code" : "010009.01",
      "display" : "OSPEDALE SANT'ANDREA"
    },
    {
      "code" : "010009.02",
      "display" : "OSPEDALE SS.PIETRO E PAOLO"
    },
    {
      "code" : "010005.01",
      "display" : "OSPEDALE SAN BIAGIO"
    },
    {
      "code" : "010005.02",
      "display" : "STABILIMENTO OSPEDALIERO CASTELLI"
    },
    {
      "code" : "010005.03",
      "display" : "C.O.Q. OSPEDALE MADONNA DEL POPOLO"
    },
    {
      "code" : "010124.01",
      "display" : "OSPEDALE DI MONDOVI' CN1"
    },
    {
      "code" : "010124.02",
      "display" : "NUOVO OSPEDALE DI CEVA CN1"
    },
    {
      "code" : "010126.01",
      "display" : "OSP. MAGGIORE SS. ANNUNZIATA SAVIGLIANO"
    },
    {
      "code" : "010126.02",
      "display" : "OSP. CIVILE DI SALUZZO CN1"
    },
    {
      "code" : "010120.01",
      "display" : "OSPEDALE SAN LAZZARO - ALBA"
    },
    {
      "code" : "010120.02",
      "display" : "OSPEDALE SANTO SPIRITO BRA"
    },
    {
      "code" : "010008.01",
      "display" : "PRESIDIO OSP. CARDINAL G. MASSAIA"
    },
    {
      "code" : "010008.02",
      "display" : "PRESIDIO OSPEDALIERO S. SPIRITO-VALLE BE"
    },
    {
      "code" : "010026.01",
      "display" : "OSPEDALE SANTO SPIRITO CASALE"
    },
    {
      "code" : "010026.03",
      "display" : "OSPEDALE SS. ANTONIO E MARGHERITA TORTON"
    },
    {
      "code" : "010026.04",
      "display" : "OSPEDALE SAN GIACOMO NOVI"
    },
    {
      "code" : "010026.05",
      "display" : "OSPEDALE CIVILE ACQUI"
    },
    {
      "code" : "010026.06",
      "display" : "OSPEDALE CIVILE OVADA"
    },
    {
      "code" : "010905.01",
      "display" : "OSP. MAGGIORE DELLA CARITA'"
    },
    {
      "code" : "010905.02",
      "display" : "OSPEDALE SAN ROCCO GALLIATE"
    },
    {
      "code" : "010907.01",
      "display" : "OSP.CIVILE SS.ANTONIO E BIAGIO"
    },
    {
      "code" : "010907.02",
      "display" : "OSP. INFANTILE C.ARRIGO"
    },
    {
      "code" : "010907.03",
      "display" : "CENTRO RIABILITATIVO POLIFUNZIONALE T.BO"
    },
    {
      "code" : "010909.01",
      "display" : "OSPEDALE SAN GIOVANNI BATTISTA MOLINETTE"
    },
    {
      "code" : "010909.02",
      "display" : "OSPEDALE DERMATOLOGICO SAN LAZZARO"
    },
    {
      "code" : "010909.04",
      "display" : "OSPEDALE CENTRO TRAUMATOLOGICO ORTOPEDIC"
    },
    {
      "code" : "010909.05",
      "display" : "ISTITUTO CHIRURGICO ORTOPEDICO REGINA MA"
    },
    {
      "code" : "010909.06",
      "display" : "OSPEDALE OSTETRICO GINECOLOGICO SANT'ANN"
    },
    {
      "code" : "010909.07",
      "display" : "OSPEDALE INFANTANTILE REGINA MARGHERITA"
    },
    {
      "code" : "030914",
      "display" : "OSPEDALE S. PAOLO - MILANO"
    },
    {
      "code" : "030915",
      "display" : "OSPEDALE S. CARLO BORROMEO - MILANO"
    },
    {
      "code" : "030056",
      "display" : "PRESIDIO OSPED. V. BUZZI - MILANO"
    },
    {
      "code" : "030057",
      "display" : "OSPEDALE M. MELLONI - MILANO"
    },
    {
      "code" : "030910",
      "display" : "OSPEDALE FATEBENEFRATELLI E OFTALMICO -"
    },
    {
      "code" : "030916",
      "display" : "OSPEDALE L. SACCO - MILANO"
    },
    {
      "code" : "030911",
      "display" : "ISTITUTO ORTOPEDICO GAETANO PINI - MILAN"
    },
    {
      "code" : "030912",
      "display" : "P.O. CENTRO TRAUMATOLOGICO ORTOPEDICO -"
    },
    {
      "code" : "030074",
      "display" : "OSPEDALE CIVILE G. FORNAROLI - MAGENTA"
    },
    {
      "code" : "030075",
      "display" : "OSPEDALE C.CANTU'-ABBIATEGRASSO"
    },
    {
      "code" : "030281.01",
      "display" : "OSPEDALE DI LEGNANO E CUGGIONO-LEGNANO"
    },
    {
      "code" : "030281.02",
      "display" : "OSPEDALE DI LEGNANO E CUGGIONO-LEGNANO"
    },
    {
      "code" : "030066",
      "display" : "OSPEDALE G.SALVINI-GARBAGNATE MIL.SE"
    },
    {
      "code" : "030073",
      "display" : "OSPEDALE DI CIRCOLO - RHO"
    },
    {
      "code" : "030087",
      "display" : "OSPEDALE CADUTI BOLLATESI - BOLLATE"
    },
    {
      "code" : "030283",
      "display" : "OSPEDALE G.CASATI-PASSIRANA RHO"
    },
    {
      "code" : "030051",
      "display" : "P.O.  CITTA' DI SESTO S. GIOVANNI"
    },
    {
      "code" : "030058",
      "display" : "OSPEDALE BASSINI - CINISELLO BALSAMO"
    },
    {
      "code" : "030071.01",
      "display" : "OSPEDALE S. MARIA DELLE STELLE MELZO"
    },
    {
      "code" : "030071.02",
      "display" : "OSPEDALE S. MARIA DELLE STELLE MELZO"
    },
    {
      "code" : "030072.01",
      "display" : "OSPEDALE DI  VIZZOLO PREDABISSI"
    },
    {
      "code" : "030072.02",
      "display" : "OSPEDALE DI  VIZZOLO PREDABISSI"
    },
    {
      "code" : "030085.01",
      "display" : "OSPEDALE UBOLDO - CERNUSCO S/NAVIGLIO"
    },
    {
      "code" : "030085.02",
      "display" : "OSPEDALE UBOLDO - CERNUSCO S/NAVIGLIO"
    },
    {
      "code" : "030067",
      "display" : "OSPEDALE MAGGIORE DI LODI"
    },
    {
      "code" : "030079",
      "display" : "OSPEDALE CIVICO - CODOGNO"
    },
    {
      "code" : "030080",
      "display" : "OSPEDALE ROSSI - CASALPUSTERLENGO"
    },
    {
      "code" : "030083",
      "display" : "OSPEDALE DELMATI - SANT'ANGELO LODIGIANO"
    },
    {
      "code" : "030010",
      "display" : "OSPEDALE GALMARINI - TRADATE"
    },
    {
      "code" : "030282.01",
      "display" : "PRESIDIO OSPEDALIERO DEL VERBANO"
    },
    {
      "code" : "030282.02",
      "display" : "PRESIDIO OSPEDALIERO DEL VERBANO"
    },
    {
      "code" : "030901.01",
      "display" : "PRESIDIO OSPEDALIERO DI VARESE"
    },
    {
      "code" : "030901.02",
      "display" : "PRESIDIO OSPEDALIERO DI VARESE"
    },
    {
      "code" : "030901.03",
      "display" : "PRESIDIO OSPEDALIERO DI VARESE"
    },
    {
      "code" : "030004",
      "display" : "OSPEDALE DI CIRCOLO - BUSTO ARSIZIO"
    },
    {
      "code" : "030006",
      "display" : "OSP. S. ANTONIO ABATE - GALLARATE"
    },
    {
      "code" : "030008",
      "display" : "OSP. GENERALE PROVINCIALE - SARONNO"
    },
    {
      "code" : "030009",
      "display" : "OSPEDALE A.BELLINI - SOMMA LOMBARDO"
    },
    {
      "code" : "030012",
      "display" : "OSPEDALE CARLO ONDOLI - ANGERA"
    },
    {
      "code" : "030022",
      "display" : "OSPEDALE S. ANTONIO ABATE - CANTU'"
    },
    {
      "code" : "030025",
      "display" : "OSPEDALE F. VILLA - MARIANO COMENSE"
    },
    {
      "code" : "030902",
      "display" : "OSPEDALE S. ANNA - COMO"
    },
    {
      "code" : "030026",
      "display" : "OSPEDALE ERBA-  RENALDI - MENAGGIO"
    },
    {
      "code" : "030042",
      "display" : "OSPEDALE SONDRIO"
    },
    {
      "code" : "030044",
      "display" : "OSPEDALE DI CHIAVENNA"
    },
    {
      "code" : "030045",
      "display" : "OSPEDALE  MORBEGNO"
    },
    {
      "code" : "030904",
      "display" : "OSPEDALE MORELLI - SONDALO"
    },
    {
      "code" : "030274.01",
      "display" : "OSPEDALE VALCAMONICA - ESINE"
    },
    {
      "code" : "030274.02",
      "display" : "OSPEDALE VALCAMONICA - ESINE"
    },
    {
      "code" : "030023",
      "display" : "OSPEDALE  UMBERTO I -  BELLANO"
    },
    {
      "code" : "030024",
      "display" : "OSPEDALE DI CIRCOLO S.L.MANDIC-MERATE"
    },
    {
      "code" : "030903",
      "display" : "OSPEDALE DI CIRCOLO A. MANZONI - LECCO"
    },
    {
      "code" : "030068",
      "display" : "PRESIDIO OSPEDALIERO DI DESIO"
    },
    {
      "code" : "030909",
      "display" : "OSPEDALE S.GERARDO - MONZA"
    },
    {
      "code" : "030070",
      "display" : "PRESIDIO OSPEDALIERO DI CARATE"
    },
    {
      "code" : "030078",
      "display" : "PRESIDIO OSPEDALIERO DI VIMERCATE"
    },
    {
      "code" : "030081",
      "display" : "PRESIDIO OSPEDALIERO DI GIUSSANO"
    },
    {
      "code" : "030082",
      "display" : "P.O. TRABATTONI RONZONI DI SEREGNO"
    },
    {
      "code" : "030132",
      "display" : "OSPEDALE CIVILE - S.GIOVANNI BIANCO"
    },
    {
      "code" : "030905",
      "display" : "OSPEDALE PAPA GIOVANNI XXIII - BG"
    },
    {
      "code" : "030131",
      "display" : "OSPEDALE DI TREVIGLIO E CARAVAGGIO"
    },
    {
      "code" : "030138",
      "display" : "OSP.LE SS.TRINITA'-ROMANO DI LOMBARDIA"
    },
    {
      "code" : "030133",
      "display" : "OSPEDALE PESENTI FENAROLI - ALZANO L."
    },
    {
      "code" : "030136",
      "display" : "OSPEDALE BRIOLINI - GAZZANIGA"
    },
    {
      "code" : "030137",
      "display" : "OSP.LE SS.CAPITANIO E GEROSA - LOVERE"
    },
    {
      "code" : "030140",
      "display" : "OSPEDALE BOLOGNINI - SERIATE"
    },
    {
      "code" : "030382",
      "display" : "OSPEDALE M. O. ANTONIO LOCATELLI-PIARIO"
    },
    {
      "code" : "030159",
      "display" : "PRESIDIO OSPEDALIERO DI MONTICHIARI"
    },
    {
      "code" : "030162",
      "display" : "PRESIDIO OSPEDALIERO GARDONE V.T."
    },
    {
      "code" : "030167",
      "display" : "OSPEDALE DEI BAMBINI - BRESCIA"
    },
    {
      "code" : "030906",
      "display" : "PRES.OSPEDAL.SPEDALI CIVILI BRESCIA"
    },
    {
      "code" : "030154.01",
      "display" : "PRESIDIO OSPEDALIERO DI CHIARI"
    },
    {
      "code" : "030154.02",
      "display" : "PRESIDIO OSPEDALIERO DI CHIARI"
    },
    {
      "code" : "030163",
      "display" : "PRESIDIO OSPEDALIERO DI ISEO"
    },
    {
      "code" : "030156",
      "display" : "OSPEDALE DI DESENZANO"
    },
    {
      "code" : "030157",
      "display" : "OSPEDALE CIVILE LA MEMORIA DI GAVARDO"
    },
    {
      "code" : "030158",
      "display" : "OSPEDALE DI LENO"
    },
    {
      "code" : "030161",
      "display" : "PRESIDIO OSPEDALIERO DI SALO'"
    },
    {
      "code" : "030183",
      "display" : "OSPEDALE VILLA DEI COLLI DI LONATO"
    },
    {
      "code" : "030184",
      "display" : "OSPEDALE DI MANERBIO"
    },
    {
      "code" : "030273",
      "display" : "PRESIDIO OSPEDALIERO OGLIO PO-CASALMAGGI"
    },
    {
      "code" : "030908",
      "display" : "ISTITUTI OSPITALIERI - CREMONA"
    },
    {
      "code" : "030227.01",
      "display" : "PRESIDIO OSPEDALIERO - ASOLA"
    },
    {
      "code" : "030227.02",
      "display" : "PRESIDIO OSPEDALIERO - ASOLA"
    },
    {
      "code" : "030239",
      "display" : "OSP.CIVILE DESTRA SECCHIA-PIEVE CORIANO"
    },
    {
      "code" : "030907",
      "display" : "OSPEDALE C. POMA - MANTOVA"
    },
    {
      "code" : "030209",
      "display" : "OSPEDALE MAGGIORE - CREMA"
    },
    {
      "code" : "030215",
      "display" : "OSPEDALE S. MARTA - RIVOLTA D'ADDA"
    },
    {
      "code" : "030189",
      "display" : "OSPEDALE ARNABOLDI - BRONI"
    },
    {
      "code" : "030190",
      "display" : "OSPEDALE CARLO MIRA-CASORATE PRIMO"
    },
    {
      "code" : "030191",
      "display" : "OSPEDALE S.MARTINO - MEDE"
    },
    {
      "code" : "030192",
      "display" : "OSPEDALE SS.ANNUNZIATA - VARZI"
    },
    {
      "code" : "030193",
      "display" : "OSPEDALE CIVILE - VIGEVANO"
    },
    {
      "code" : "030194",
      "display" : "OSPEDALE CIVILE - VOGHERA"
    },
    {
      "code" : "030203",
      "display" : "OSPEDALE ASILO VITTORIA - MORTARA"
    },
    {
      "code" : "030383",
      "display" : "NUOVO OSPEDALE DI BRONI E STRADELLA"
    },
    {
      "code" : "030936.01",
      "display" : "IST.AUXOLOGICO ITALIANO-I.S. S.LUCA-MILA"
    },
    {
      "code" : "030936.02",
      "display" : "IST.AUXOLOGICO ITAL.-I.S. S.MICHELE-MILA"
    },
    {
      "code" : "030936.03",
      "display" : "IRCCS OSPEDALE CAPITANIO"
    },
    {
      "code" : "042001.01",
      "display" : "PRESIDIO OSPEDALIERO S. CHIARA"
    },
    {
      "code" : "042001.03",
      "display" : "PRESIDIO OSPEDALIERO VILLA ROSA"
    },
    {
      "code" : "042001.04",
      "display" : "PRESIDIO OSPEDALIERO VILLA IGEA"
    },
    {
      "code" : "050201.01",
      "display" : "OSPEDALE S. MARTINO BELLUNO"
    },
    {
      "code" : "050201.03",
      "display" : "OSPEDALE DI AGORDO"
    },
    {
      "code" : "050201.04",
      "display" : "OSPEDALE DI PIEVE DI CADORE"
    },
    {
      "code" : "050202.01",
      "display" : "OSPEDALE DI FELTRE 'S. MARIA DEL PRATO'"
    },
    {
      "code" : "050202.02",
      "display" : "OSPEDALE DI LAMON 'CASA CHARITAS'"
    },
    {
      "code" : "050203.01",
      "display" : "OSPEDALE `SAN BASSIANO` DI BASSANO D.G."
    },
    {
      "code" : "050203.02",
      "display" : "OSPEDALE DI ASIAGO"
    },
    {
      "code" : "050205.01",
      "display" : "OSPEDALE DI ARZIGNANO"
    },
    {
      "code" : "050205.02",
      "display" : "OSPEDALE  DI LONIGO"
    },
    {
      "code" : "050205.03",
      "display" : "OSPEDALE DI MONTECCHIO"
    },
    {
      "code" : "050205.04",
      "display" : "OSPEDALE DI VALDAGNO"
    },
    {
      "code" : "050206.01",
      "display" : "PRES. OSPED. VICENZA"
    },
    {
      "code" : "050206.02",
      "display" : "PRES. OSP.  NOVENTA VICENTINA"
    },
    {
      "code" : "050140.01",
      "display" : "ASSOCIAZIONE LA NS. FAMIGLIA IRCSS MEDEA"
    },
    {
      "code" : "050140.02",
      "display" : "ASSOCIAZIONE LA NS.FAMIGLIA IRCSS MEDEA"
    },
    {
      "code" : "050207.01",
      "display" : "OSPEDALE DI CONEGLIANO"
    },
    {
      "code" : "050207.02",
      "display" : "OSPEDALE DI VITTORIO VENETO"
    },
    {
      "code" : "050208.01",
      "display" : "OSPEDALE DI CASTELFRANCO VENETO"
    },
    {
      "code" : "050208.02",
      "display" : "OSPEDALE DI MONTEBELLUNA"
    },
    {
      "code" : "050209.01",
      "display" : "OSPEDALE CA' FONCELLO"
    },
    {
      "code" : "050209.02",
      "display" : "OSPEDALE DI ODERZO"
    },
    {
      "code" : "050210.01",
      "display" : "PRESIDIO OSPEDALIERO DI PORTOGRUARO"
    },
    {
      "code" : "050210.02",
      "display" : "PRESIDIO OSPEDALIERO DI SAN DONA` DI P."
    },
    {
      "code" : "050210.03",
      "display" : "PRESIDIO OSPEDALIERO DI JESOLO"
    },
    {
      "code" : "050212.01",
      "display" : "OSPEDALE CIVILE VENEZIA"
    },
    {
      "code" : "050212.02",
      "display" : "PUNTO PRIMO INTERVENTO LIDO"
    },
    {
      "code" : "050212.04",
      "display" : "OSPEDALE DELL'ANGELO"
    },
    {
      "code" : "050213.01",
      "display" : "OSPEDALE  DI DOLO"
    },
    {
      "code" : "050213.02",
      "display" : "OSPEDALE  DI MIRANO"
    },
    {
      "code" : "050213.03",
      "display" : "OSPEDALE DI NOALE"
    },
    {
      "code" : "050215.01",
      "display" : "PRESIDIO OSPEDALIERO DI CAMPOSAMPIERO"
    },
    {
      "code" : "050215.02",
      "display" : "PRESIDIO OSPEDALIERO DI CITTADELLA"
    },
    {
      "code" : "050216.01",
      "display" : "OSPEDALE SANT`ANTONIO"
    },
    {
      "code" : "050216.05",
      "display" : "OSP. IMMACOL. CONCEZ. DI PIOVE DI SACCO"
    },
    {
      "code" : "050217.03",
      "display" : "SEDE MONTAGNANA"
    },
    {
      "code" : "050217.04",
      "display" : "SEDE CONSELVE"
    },
    {
      "code" : "050217.05",
      "display" : "OSPEDALI RIUNITI PADOVA SUD"
    },
    {
      "code" : "050218.01",
      "display" : "P.O. DI ROVIGO"
    },
    {
      "code" : "050218.02",
      "display" : "P.O. DI TRECENTA"
    },
    {
      "code" : "050220.04",
      "display" : "PRESIDIO OSP. MARZANA"
    },
    {
      "code" : "050220.05",
      "display" : "POLO OSP. DELL'EST VERONESE"
    },
    {
      "code" : "050220.06",
      "display" : "PSICHIATRIA SEZIONE B.GO TRENTO - VERONA"
    },
    {
      "code" : "050221.01",
      "display" : "OSPEDALE PER ACUTI"
    },
    {
      "code" : "050221.03",
      "display" : "OSPEDALE S.BIAGIO BOVOLONE"
    },
    {
      "code" : "050222.01",
      "display" : "OSPEDALE CIVILE ORLANDI BUSSOLENGO"
    },
    {
      "code" : "050222.02",
      "display" : "OSPEDALE ISOLA DELLA SCALA"
    },
    {
      "code" : "050222.04",
      "display" : "OSPEDALE DI MALCESINE"
    },
    {
      "code" : "050222.05",
      "display" : "OSPEDALE MAGALINI - VILLAFRANCA DI VR"
    },
    {
      "code" : "050912.01",
      "display" : "OSPEDALE CIVILE MAGGIORE"
    },
    {
      "code" : "050912.02",
      "display" : "OSPEDALE POLICLINICO"
    },
    {
      "code" : "060043.01",
      "display" : "PO Gorizia e Monfalcone sede Gorizia"
    },
    {
      "code" : "060043.02",
      "display" : "PO Gorizia e Monfalcone sede Monfalcone"
    },
    {
      "code" : "060044.01",
      "display" : "PO Latisana e Palmanova sede Latisana"
    },
    {
      "code" : "060044.02",
      "display" : "PO Latisana e Palmanova sede Palmanova"
    },
    {
      "code" : "060045.01",
      "display" : "Sede di San Daniele"
    },
    {
      "code" : "060045.02",
      "display" : "Sede di Tolmezzo"
    },
    {
      "code" : "060045.03",
      "display" : "Sede di Gemona"
    },
    {
      "code" : "060047.01",
      "display" : "PRESIDIO OSPEDALIERO SMM - SEDE UDINE"
    },
    {
      "code" : "060047.02",
      "display" : "PRESIDIO OSPEDAL. SMM - SEDE CIVIDALE"
    },
    {
      "code" : "060042.01",
      "display" : "P.O. San Vito al T. sede di S. Vito al T"
    },
    {
      "code" : "060042.02",
      "display" : "P.O. San Vito al T. sede di Spilimbergo"
    },
    {
      "code" : "070001.01",
      "display" : "STABILIMENTO OSPEDALIERO DI IMPERIA"
    },
    {
      "code" : "070001.02",
      "display" : "STABILIMENTO OSPEDALIERO DI SANREMO"
    },
    {
      "code" : "070001.03",
      "display" : "STABILIMENTO OSPEDALIERO DI BORDIGHERA"
    },
    {
      "code" : "070211.01",
      "display" : "OSPEDALE SANTA MARIA MISERICORDIA"
    },
    {
      "code" : "070211.02",
      "display" : "OSPEDALE SANTA CORONA"
    },
    {
      "code" : "070212.03",
      "display" : "OSPEDALE SAN GIUSEPPE"
    },
    {
      "code" : "070212.04",
      "display" : "OSPEDALE SAN PAOLO"
    },
    {
      "code" : "070051.01",
      "display" : "EVANGELICO Internazionale CASTELLETTO"
    },
    {
      "code" : "070051.02",
      "display" : "EVANGELICO-SAN CARLO VOLTRI"
    },
    {
      "code" : "070301.01",
      "display" : "OSPEDALE LA COLLETTA ARENZANO"
    },
    {
      "code" : "070301.03",
      "display" : "OSPEDALE PADRE ANTERO MICONE SESTRI P."
    },
    {
      "code" : "070301.04",
      "display" : "OSPEDALE VILLA SCASSI"
    },
    {
      "code" : "070301.05",
      "display" : "OSPEDALE GALLINO"
    },
    {
      "code" : "070039.01",
      "display" : "OSP. RIUNITI LEONARDI E RIBOLI LAVAGNA"
    },
    {
      "code" : "070039.02",
      "display" : "OSPEDALE CIVILE DI SESTRI LEVANTE"
    },
    {
      "code" : "070039.05",
      "display" : "OSPEDALE N.S. DI MONTALLEGRO"
    },
    {
      "code" : "070058.01",
      "display" : "OSPEDALE SANT`ANDREA LA SPEZIA"
    },
    {
      "code" : "070058.03",
      "display" : "OSPEDALE SAN NICOLO` LEVANTO"
    },
    {
      "code" : "070058.04",
      "display" : "STABILIMENTO SAN BARTOLOMEO DI SARZANA"
    },
    {
      "code" : "080004.01",
      "display" : "OSPEDALE GUGLIELMO DA SALICETO PIACENZA"
    },
    {
      "code" : "080004.02",
      "display" : "OSPEDALE BOBBIO"
    },
    {
      "code" : "080004.03",
      "display" : "OSPEDALE CASTEL SAN GIOVANNI"
    },
    {
      "code" : "080004.04",
      "display" : "OSPEDALE BORGONOVO VAL TIDONE"
    },
    {
      "code" : "080004.05",
      "display" : "OSPEDALE FIORENZUOLA D'ARDA"
    },
    {
      "code" : "080004.06",
      "display" : "CENTRO DI RECUPERO E RIABILITAZIONE FUNZ"
    },
    {
      "code" : "080013.01",
      "display" : "OSPEDALE FIDENZA"
    },
    {
      "code" : "080013.03",
      "display" : "OSPEDALE 'S.MARIA' BORGO VAL DI TARO"
    },
    {
      "code" : "080021.01",
      "display" : "OSPEDALE CIVILE GUASTALLA"
    },
    {
      "code" : "080021.02",
      "display" : "OSPEDALE S.SEBASTIANO CORREGGIO"
    },
    {
      "code" : "080021.03",
      "display" : "OSPEDALE E.FRANCHINI MONTECCHIO"
    },
    {
      "code" : "080021.04",
      "display" : "OSPEDALE G.MAGATI SCANDIANO"
    },
    {
      "code" : "080021.05",
      "display" : "OSPEDALE S.ANNA CASTELNOVO NE MONTI"
    },
    {
      "code" : "080031.04",
      "display" : "OSPEDALE B. RAMAZZINI  CARPI"
    },
    {
      "code" : "080031.05",
      "display" : "OSPEDALE SANTA MARIA BIANCA  MIRANDOLA"
    },
    {
      "code" : "080031.08",
      "display" : "OSPEDALE VIGNOLA"
    },
    {
      "code" : "080031.09",
      "display" : "OSPEDALE PAVULLO NEL FRIGNANO"
    },
    {
      "code" : "080031.10",
      "display" : "NUOVO OSPEDALE CIVILE  S.AGOSTINO - ESTE"
    },
    {
      "code" : "080053.01",
      "display" : "OSPEDALE MAGGIORE C.A. PIZZARDI"
    },
    {
      "code" : "080053.02",
      "display" : "OSPEDALE BELLARIA"
    },
    {
      "code" : "080053.03",
      "display" : "OSPEDALE DOSSETTI  BAZZANO"
    },
    {
      "code" : "080053.04",
      "display" : "OSPEDALE A. COSTA PORRETTA TERME (ALTO"
    },
    {
      "code" : "080053.05",
      "display" : "OSPEDALE VERGATO"
    },
    {
      "code" : "080053.06",
      "display" : "OSPEDALE SIMIANI LOIANO"
    },
    {
      "code" : "080053.07",
      "display" : "OSPEDALE BENTIVOGLIO"
    },
    {
      "code" : "080053.08",
      "display" : "OSPEDALE BUDRIO"
    },
    {
      "code" : "080053.09",
      "display" : "OSPEDALE S.SALVATORE  S. GIOVANNI IN P"
    },
    {
      "code" : "080044.01",
      "display" : "OSPEDALE CIVILE NUOVO S.MARIA DELLA SCA"
    },
    {
      "code" : "080044.02",
      "display" : "OSPEDALE CASTEL SAN PIETRO TERME"
    },
    {
      "code" : "080068.03",
      "display" : "OSPEDALE DEL DELTA"
    },
    {
      "code" : "080068.04",
      "display" : "OSPEDALE MAZZOLANI VANDINI ARGENTA"
    },
    {
      "code" : "080068.06",
      "display" : "STABILIMENTO OSPEDALIERO SS. ANNUNZIATA"
    },
    {
      "code" : "080085.01",
      "display" : "OSPEDALE MORGAGNI-PIERANTONI FORLI'"
    },
    {
      "code" : "080085.03",
      "display" : "OSPEDALE NEFETTI SANTA SOFIA"
    },
    {
      "code" : "080091.01",
      "display" : "OSPEDALE MAURIZIO BUFALINI CESENA"
    },
    {
      "code" : "080091.02",
      "display" : "OSPEDALE GINESIO MARCONI CESENATICO"
    },
    {
      "code" : "080091.03",
      "display" : "OSPEDALE PIETRO ANGIOLONI BAGNO DI ROM"
    },
    {
      "code" : "080095.01",
      "display" : "OSPEDALE INFERMI RIMINI"
    },
    {
      "code" : "080095.02",
      "display" : "OSPEDALE FRANCHINI SANTARCANGELO DI RO"
    },
    {
      "code" : "080095.03",
      "display" : "OSPEDALE SACRA FAMIGLIA NOVAFELTRIA"
    },
    {
      "code" : "080100.01",
      "display" : "OSPEDALE CECCARINI RICCIONE"
    },
    {
      "code" : "080100.02",
      "display" : "OSPEDALE CERVESI CATTOLICA"
    },
    {
      "code" : "080903.01",
      "display" : "AZIENDA OSPEDALIERA DI REGGIO EMILIA-S."
    },
    {
      "code" : "080903.02",
      "display" : "AZIENDA OSPEDALIERA DI REGGIO EMILIA - I"
    },
    {
      "code" : "090606.01",
      "display" : "OSPEDALE SAN JACOPO"
    },
    {
      "code" : "090606.02",
      "display" : "OSPEDALE LORENZO PACINI"
    },
    {
      "code" : "090629.01",
      "display" : "OSPEDALE S.M.ANNUNZIATA"
    },
    {
      "code" : "090629.02",
      "display" : "OSPEDALE SERRISTORI"
    },
    {
      "code" : "090632.01",
      "display" : "SANTA MARIA NUOVA"
    },
    {
      "code" : "090632.02",
      "display" : "ISTITUTO ORTOPEDICO TOSCANO"
    },
    {
      "code" : "090632.03",
      "display" : "OSP. S. GIOVANNI DI DIO TORREGALLI"
    },
    {
      "code" : "090632.06",
      "display" : "OBLATE AZIENDA SANITARIA FIRENZE"
    },
    {
      "code" : "090642.02",
      "display" : "OSPEDALE S. GIUSEPPE"
    },
    {
      "code" : "090642.03",
      "display" : "OSPEDALE SAN PIETRO IGNEO"
    },
    {
      "code" : "090642.04",
      "display" : "OSPEDALE DEGLI INFERMI"
    },
    {
      "code" : "090601.01",
      "display" : "OSP. S. ANTONIO ABATE FIVIZZANO   (MS)"
    },
    {
      "code" : "090601.02",
      "display" : "OSP. CIV. S.ANTONIO  PONTREMOLI (MS)"
    },
    {
      "code" : "090602.01",
      "display" : "STABILIMENTO OSPEDALIERO DI CARRARA"
    },
    {
      "code" : "090602.03",
      "display" : "OSPEDALE  DELLE APUANE"
    },
    {
      "code" : "090603.01",
      "display" : "OSPEDALE SANTA CROCE"
    },
    {
      "code" : "090603.02",
      "display" : "OSPEDALE SAN FRANCESCO"
    },
    {
      "code" : "090610.01",
      "display" : "P.O. F. LOTTI STABILIMENTO DI PONTEDERA"
    },
    {
      "code" : "090610.02",
      "display" : "SPDC AZIENDALE ASL5"
    },
    {
      "code" : "090236.01",
      "display" : "CASA DI CURA POGGIO DEL SOLE"
    },
    {
      "code" : "090236.02",
      "display" : "CENTRO CHIRURGICO TOSCANO SRL"
    },
    {
      "code" : "090624.02",
      "display" : "OSPEDALE DI ORBETELLO"
    },
    {
      "code" : "090624.03",
      "display" : "OSPEDALE DI PITIGLIANO"
    },
    {
      "code" : "090907.01",
      "display" : "FONDAZIONE CNR-RT G. MONASTERIO"
    },
    {
      "code" : "090907.02",
      "display" : "OSPEDALE DEL CUORE G. PASQUINUCCI"
    },
    {
      "code" : "100801.01",
      "display" : "OSPEDALE DI CITTA` DI CASTELLO"
    },
    {
      "code" : "100801.02",
      "display" : "OSPEDALE DI UMBERTIDE"
    },
    {
      "code" : "100803.01",
      "display" : "STAB.OSPEDALIERO CASTIGLIONE DEL LAGO"
    },
    {
      "code" : "100803.02",
      "display" : "STAB.OSPEDALIERO CITTA`DELLA PIEVE"
    },
    {
      "code" : "100803.03",
      "display" : "C.O.R.I. - PASSIGNANO"
    },
    {
      "code" : "100803.04",
      "display" : "STAB. OSPEDALIERO ASSISI"
    },
    {
      "code" : "100803.07",
      "display" : "STAB. OSPEDALIERO MEDIA VALLE DEL TEVERE"
    },
    {
      "code" : "100805.01",
      "display" : "OSPEDALE CIVILE SAN MATTEO DEGLI INFERMI"
    },
    {
      "code" : "100805.02",
      "display" : "OSPEDALE CIVILE DI NORCIA"
    },
    {
      "code" : "100805.03",
      "display" : "OSPEDALE S.RITA CASCIA"
    },
    {
      "code" : "100807.01",
      "display" : "STABILIMENTO OSPEDALIERO DI NARNI"
    },
    {
      "code" : "100807.02",
      "display" : "STABILIMENTO OSPEDALIERO DI AMELIA"
    },
    {
      "code" : "100807.03",
      "display" : "DOMUS GRATIAE"
    },
    {
      "code" : "100809.01",
      "display" : "OSPEDALE SAN GIOVANNI BATTISTA FOLIGNO"
    },
    {
      "code" : "100809.02",
      "display" : "STABILIMENTO DI TREVI"
    },
    {
      "code" : "110001.01",
      "display" : "OSP S. MARIA DELLA MISERICORDIA - URBINO"
    },
    {
      "code" : "110001.02",
      "display" : "OSPEDALE SS DONNINO E CARLO - PERGOLA"
    },
    {
      "code" : "110001.03",
      "display" : "OSPEDALE CELLI - CAGLI"
    },
    {
      "code" : "110001.04",
      "display" : "OSPEDALE LANCIARINI - SASSOCORVARO"
    },
    {
      "code" : "110001.05",
      "display" : "OSPEDALE CIVILE - FOSSOMBRONE"
    },
    {
      "code" : "110002.01",
      "display" : "PRESIDIO OSPEDALIERO ZT 4 - SENIGALLIA"
    },
    {
      "code" : "110002.02",
      "display" : "OSPEDALE CARLO URBANI DI JESI"
    },
    {
      "code" : "110002.03",
      "display" : "OSP. SS. BENVENUTO E ROCCO - OSIMO"
    },
    {
      "code" : "110002.04",
      "display" : "OSPEDALE CIVILE 'E.PROFILI' - FABRIANO"
    },
    {
      "code" : "110002.05",
      "display" : "OSPEDALE SANTA CASA - LORETO"
    },
    {
      "code" : "110002.06",
      "display" : "OSPEDALE GENERALE DI ZONA - CINGOLI"
    },
    {
      "code" : "110003.01",
      "display" : "OSPEDALE GENERALE DI ZONA - CIVITANOVA"
    },
    {
      "code" : "110003.02",
      "display" : "OSPEDALE GENERALE PROVINCIALE - MACERATA"
    },
    {
      "code" : "110003.03",
      "display" : "OSPEDALE S.MARIA DELLA PIETA` - CAMERINO"
    },
    {
      "code" : "110003.04",
      "display" : "OSPEDALE B.EUSTACCHIO - S. SEVERINO M."
    },
    {
      "code" : "110003.05",
      "display" : "OSPEDALE DI TREIA"
    },
    {
      "code" : "110003.06",
      "display" : "OSPEDALE DI TOLENTINO"
    },
    {
      "code" : "110003.07",
      "display" : "OSPEDALE CIVILE SANTA LUCIA - RECANATI"
    },
    {
      "code" : "110003.08",
      "display" : "OSPEDALE S.SOLLECITO - MATELICA"
    },
    {
      "code" : "110004.01",
      "display" : "OSPEDALE DI FERMO"
    },
    {
      "code" : "110004.02",
      "display" : "OSPEDALE VITTORIO EMANUELE II - AMANDOLA"
    },
    {
      "code" : "110005.01",
      "display" : "MADONNA DEL SOCCORSO - S.BENEDETTO"
    },
    {
      "code" : "110005.02",
      "display" : "OSP. GEN."
    },
    {
      "code" : "110901.01",
      "display" : "OSPEDALE SAN SALVATORE - PESARO"
    },
    {
      "code" : "110901.02",
      "display" : "OSPEDALE SANTA CROCE - FANO"
    },
    {
      "code" : "110905.01",
      "display" : "PRESIDIO OSPEDALIERO UMBERTO I°"
    },
    {
      "code" : "110905.02",
      "display" : "PRESIDIO OSPEDALIERO G.M.LANCISI"
    },
    {
      "code" : "110905.03",
      "display" : "PRESIDIO OSPEDALIERO G.SALESI"
    },
    {
      "code" : "110921.01",
      "display" : "OSPEDALE INRCA - ANCONA"
    },
    {
      "code" : "110921.02",
      "display" : "OSPEDALE INRCA - FERMO"
    },
    {
      "code" : "120204.01",
      "display" : "ALFREDO FIORINI TERRACINA"
    },
    {
      "code" : "120204.02",
      "display" : "SAN GIOVANNI DI DIO FONDI"
    },
    {
      "code" : "120204.03",
      "display" : "REGINA ELENA PRIVERNO"
    },
    {
      "code" : "120026.01",
      "display" : "OSPEDALE SANTO SPIRITO"
    },
    {
      "code" : "120026.02",
      "display" : "VILLA BETANIA"
    },
    {
      "code" : "120285.01",
      "display" : "PRESIDIO SAN FILIPPO NERI"
    },
    {
      "code" : "120285.03",
      "display" : "PRESIDIO CASSIA SANT'ANDREA"
    },
    {
      "code" : "120285.05",
      "display" : "SALUS INFIRMORUM"
    },
    {
      "code" : "120066.01",
      "display" : "OSPEDALE S.EUGENIO"
    },
    {
      "code" : "120066.02",
      "display" : "OSPEDALE CTO.A.ALESINI"
    },
    {
      "code" : "120044.01",
      "display" : "OSPEDALE SAN GIUSEPPE ALBANO L."
    },
    {
      "code" : "120044.02",
      "display" : "OSPEDALE E. DE SANTIS GENZANO"
    },
    {
      "code" : "120904.01",
      "display" : "OSPEDALE PEDIATRICO BAMBINO GESU`"
    },
    {
      "code" : "120904.02",
      "display" : "OSPEDALE PEDIATRICO BAMBINO GESU`"
    },
    {
      "code" : "120904.03",
      "display" : "OSPEDALE PEDIATRICO BAMBINO GESU`"
    },
    {
      "code" : "120905.01",
      "display" : "POLICLINICO UNIVERSITARIO A. GEMELLI"
    },
    {
      "code" : "120905.02",
      "display" : "COMPLESSO INTEGRATO COLUMBUS (C.I.C.)"
    },
    {
      "code" : "120908.01",
      "display" : "IFO - ISTITUTO REGINA ELENA"
    },
    {
      "code" : "120908.02",
      "display" : "IFO - ISTITUTO SAN GALLICANO"
    },
    {
      "code" : "140002.01",
      "display" : "OSPEDALE S. TIMOTEO- TERMOLI"
    },
    {
      "code" : "140002.02",
      "display" : "OSPEDALE G. VIETRI- LARINO"
    },
    {
      "code" : "140003.01",
      "display" : "OSPEDALE VENEZIALE- ISERNIA"
    },
    {
      "code" : "140003.02",
      "display" : "OSPEDALE CARACCIOLO AGNONE"
    },
    {
      "code" : "140003.03",
      "display" : "OSPEDALE SS. ROSARIO - VENAFRO"
    },
    {
      "code" : "150150.01",
      "display" : "OSPEDALE S.ANGELO DEI LOMBARDI"
    },
    {
      "code" : "150150.02",
      "display" : "P.SP.RIABILITATIVO DON GNOCCHI"
    },
    {
      "code" : "150418.01",
      "display" : "PO SAN GIOVANNI BOSCO"
    },
    {
      "code" : "150418.02",
      "display" : "PO LORETO MARE"
    },
    {
      "code" : "150418.05",
      "display" : "PO ASCALESI"
    },
    {
      "code" : "150418.06",
      "display" : "PRESDIO SANITARIO INTERMEDIO NAPOLI EST"
    },
    {
      "code" : "150419.01",
      "display" : "PO SAN PAOLO"
    },
    {
      "code" : "150419.02",
      "display" : "PO DEI PELLEGRINI"
    },
    {
      "code" : "150419.03",
      "display" : "PO SAN GENNARO"
    },
    {
      "code" : "150419.04",
      "display" : "PO SMDP INCURABILI"
    },
    {
      "code" : "150419.06",
      "display" : "PO  Capilupi CAPRI"
    },
    {
      "code" : "150415.01",
      "display" : "P.O. MARESCA"
    },
    {
      "code" : "150415.02",
      "display" : "P.O.  BOSCOTRECASE"
    },
    {
      "code" : "150416.01",
      "display" : "S.  LEONARDO"
    },
    {
      "code" : "150416.02",
      "display" : "NUOVO GRAGNANO"
    },
    {
      "code" : "150417.01",
      "display" : "P.O. S. MARIA DELLA MISERICORDIA"
    },
    {
      "code" : "150417.02",
      "display" : "P.O. DE LUCA E ROSSANO"
    },
    {
      "code" : "150436.01",
      "display" : "OSPEDALI RIUNITI AREA NOLANA PLESSO NOLA"
    },
    {
      "code" : "150436.02",
      "display" : "OSPED RIUNITI AREA NOLANA PLESSO POLLENA"
    },
    {
      "code" : "150154.01",
      "display" : "P.O. UMBERTO I NOCERA INFERIORE"
    },
    {
      "code" : "150154.02",
      "display" : "P.O. TORTORA PAGANI"
    },
    {
      "code" : "150902.01",
      "display" : "OSPEDALE SANTOBONO"
    },
    {
      "code" : "150902.02",
      "display" : "Ospedale Pausilipon"
    },
    {
      "code" : "150902.03",
      "display" : "P.O. S.S. Annunziata"
    },
    {
      "code" : "150903.01",
      "display" : "Azienda Ospedaliera dei Colli -P Monaldi"
    },
    {
      "code" : "150903.02",
      "display" : "Azienda Ospedaliera dei Colli -P Cotugno"
    },
    {
      "code" : "150903.03",
      "display" : "Azienda Ospedaliera dei Colli -P  CTO"
    },
    {
      "code" : "150904.01",
      "display" : "A.O. OO.RR. SANGIOVANNI DI DIO E RUGGI"
    },
    {
      "code" : "150904.02",
      "display" : "OSPEDALE AMICO G. FUCITO"
    },
    {
      "code" : "150904.03",
      "display" : "P.O. G. DA PROCIDA"
    },
    {
      "code" : "150904.04",
      "display" : "P.O. S. M. DELL'OLMO"
    },
    {
      "code" : "160161.01",
      "display" : "OSPEDALE OSTUNI"
    },
    {
      "code" : "160161.02",
      "display" : "PLESSO DI FASANO - OSPEDALE OSTUNI"
    },
    {
      "code" : "160170.01",
      "display" : "OSPEDALE PERRINO BRINDISI"
    },
    {
      "code" : "160170.02",
      "display" : "OSPEDALE BRINDISI (PLESSO MESAGNE)"
    },
    {
      "code" : "160170.03",
      "display" : "OSP.BRINDISI(PLESSO S.PIETRO VERNOTICO)"
    },
    {
      "code" : "160170.04",
      "display" : "OSP.BRINDISI (PLESSO CEGLIE MESSAPICA)"
    },
    {
      "code" : "160172.01",
      "display" : "OSPEDALE SS ANNUNZIATA - TARANTO"
    },
    {
      "code" : "160172.03",
      "display" : "OSPEDALE MOSCATI - TARANTO/STATTE"
    },
    {
      "code" : "160174.01",
      "display" : "OSPEDALE ANDRIA"
    },
    {
      "code" : "160174.02",
      "display" : "OSPEDALE ANDRIA (PLESSO CANOSA)"
    },
    {
      "code" : "160178.01",
      "display" : "OSPEDALE BISCEGLIE"
    },
    {
      "code" : "160178.02",
      "display" : "OSPEDALE BISCEGLIE (PLESSO TRANI)"
    },
    {
      "code" : "160158.01",
      "display" : "OSPEDALE SAN PAOLO-BARI"
    },
    {
      "code" : "160158.03",
      "display" : "OSPEDALE SAN PAOLO (PLESSO MOLFETTA)"
    },
    {
      "code" : "160158.04",
      "display" : "OSPEDALE SAN PAOLO (PLESSO CORATO)"
    },
    {
      "code" : "160158.05",
      "display" : "OSPEDALE SAN PAOLO (PLESSO TERLIZZI)"
    },
    {
      "code" : "160169.01",
      "display" : "OSPEDALE DI VENERE - BARI"
    },
    {
      "code" : "160169.03",
      "display" : "PLESSO TRIGGIANO-OSPEDALE DI VENERE"
    },
    {
      "code" : "160163.01",
      "display" : "OSPEDALE SAN SEVERO"
    },
    {
      "code" : "160163.07",
      "display" : "OSPEDALE SAN SEVERO (PLESSO LUCERA)"
    },
    {
      "code" : "160171.01",
      "display" : "OSPEDALE LECCE 'V FAZZI'"
    },
    {
      "code" : "160171.02",
      "display" : "PLESSO DI SAN CESARIO - OSPEDALE LECCE"
    },
    {
      "code" : "160907.01",
      "display" : "CONSORZIALE POLICLINICO BARI"
    },
    {
      "code" : "160907.02",
      "display" : "OSPEDALE GIOVANNI XXIII"
    },
    {
      "code" : "170901.01",
      "display" : "Ospedale San Carlo di Potenza"
    },
    {
      "code" : "170901.02",
      "display" : "Osp S.Francesco di Paola di Pescopagano"
    },
    {
      "code" : "180010.01",
      "display" : "Ospedale Corigliano"
    },
    {
      "code" : "180010.02",
      "display" : "Ospedale  Rossano"
    },
    {
      "code" : "180012.01",
      "display" : "Ospedale  Cetraro"
    },
    {
      "code" : "180012.02",
      "display" : "Ospedale Paola"
    },
    {
      "code" : "180912.01",
      "display" : "P.O. ANNUNZIATA"
    },
    {
      "code" : "180912.02",
      "display" : "MARIANO SANTO"
    },
    {
      "code" : "180912.03",
      "display" : "SANTA BARBARA"
    },
    {
      "code" : "180913.01",
      "display" : "Ospedale Pugliese"
    },
    {
      "code" : "180913.02",
      "display" : "Ospedale De Lellis"
    },
    {
      "code" : "180915.01",
      "display" : "Presidio Ospedaliero Riuniti"
    },
    {
      "code" : "180915.02",
      "display" : "Presidio Ospedaliero E. Morelli"
    },
    {
      "code" : "190922.01",
      "display" : "OSPEDALE GARIBALDI - CENTRO"
    },
    {
      "code" : "190922.04",
      "display" : "NUOVO OSPEDALE GARIBALDI - NESIMA"
    },
    {
      "code" : "190923.01",
      "display" : "PRESIDIO OSPEDALIERO GASPARE RODOLICO"
    },
    {
      "code" : "190923.02",
      "display" : "PRESIDIO OSPEDALIERO VITTORIO EMANUELE"
    },
    {
      "code" : "190923.03",
      "display" : "PRESIDIO OSPEDALIERO S. BAMBINO"
    },
    {
      "code" : "190926.01",
      "display" : "P.O. Villa Sofia"
    },
    {
      "code" : "190926.02",
      "display" : "C.T.O. Centro Traumatologico Ortopedico"
    },
    {
      "code" : "190926.03",
      "display" : "P.O. V. Cervello"
    },
    {
      "code" : "190927.01",
      "display" : "Ospedale Civico"
    },
    {
      "code" : "190927.02",
      "display" : "Ospedale dei Bambini G. Di Cristina"
    },
    {
      "code" : "190960.01",
      "display" : "IRCCS Centro Neurolesi"
    },
    {
      "code" : "190960.02",
      "display" : "PRESIDIO OSPEDALIERO PIEMONTE"
    },
    {
      "code" : "200056.01",
      "display" : "KINETIKA SARDEGNA s.r.l."
    },
    {
      "code" : "200056.02",
      "display" : "KINETIKA SARDEGNA s.r.l."
    },
    {
      "code" : "200056.03",
      "display" : "KINETIKA SARDEGNA s.r.l."
    },
    {
      "code" : "200904.01",
      "display" : "P. O. SAN MICHELE"
    },
    {
      "code" : "200904.02",
      "display" : "P.O. A. BUSINCO"
    },
    {
      "code" : "200904.03",
      "display" : "P.O. MICROCITEMICO"
    },
    {
      "code" : "200905.01",
      "display" : "Stabilimento Cliniche di San Pietro"
    },
    {
      "code" : "200905.02",
      "display" : "Stabilimento SS. Annunziata"
    },
    {
      "code" : "200906.01",
      "display" : "San Giovanni di Dio"
    },
    {
      "code" : "200906.02",
      "display" : "Policlinico Monserrato"
    }
  ]
}

```
