# AIFA - Indicazioni terapeutiche (Nota AIFA) - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **AIFA - Indicazioni terapeutiche (Nota AIFA)**

## CodeSystem: AIFA - Indicazioni terapeutiche (Nota AIFA) 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/aifa-nota | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsAifaNota |

 
AIFA - Indicazioni terapeutiche per le quali un determinato farmaco è rimborsabile a carico del Servizio Sanitario Nazionale. Conosciute come Note AIFA. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsNotaAifa](ValueSet-vs-aifa-nota.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "aifa-nota",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/aifa-nota",
  "version" : "0.1.2",
  "name" : "CsAifaNota",
  "title" : "AIFA - Indicazioni terapeutiche (Nota AIFA)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "AIFA - Indicazioni terapeutiche per le quali un determinato farmaco è rimborsabile a carico del Servizio Sanitario Nazionale. Conosciute come Note AIFA.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 40,
  "concept" : [
    {
      "code" : "01",
      "display" : "Farmaco in nota: pantoprazolo, omeprazolo, misoprostolo, lansoprazolo, esomeprazolo"
    },
    {
      "code" : "02",
      "display" : "Farmaco in nota: acido chenoursodesossicolico, acido tauroursodesossicolico, acido ursodesossicolico"
    },
    {
      "code" : "04",
      "display" : "Farmaco in nota: duloxetina, gabapentin, pregabalin"
    },
    {
      "code" : "08",
      "display" : "Farmaco in nota: levocarnitina"
    },
    {
      "code" : "11",
      "display" : "Farmaco in nota: Calcio folinato"
    },
    {
      "code" : "13",
      "display" : "Farmaci in Nota: Ipolipemizzanti:Fibrati: bezafibrato, fenofibrato, gemfibrozil\nStatine: simvastatina, pravastatina, fluvastatina, lovastatina, atorvastatina, rosuvastatina\nAltri: PUFA-N3, ezetimibe"
    },
    {
      "code" : "15",
      "display" : "Farmaco in nota: Albumina umana"
    },
    {
      "code" : "28",
      "display" : "Farmaco in nota: Megestrolo, Medrossiprogesterone"
    },
    {
      "code" : "31",
      "display" : "Farmaco in nota: Levodropropizina, Diidrocodeina  Acido benzoico, Diidrocodeina"
    },
    {
      "code" : "36",
      "display" : "Farmaco in nota: Testosterone"
    },
    {
      "code" : "39",
      "display" : "Farmaci in nota: somatropina, Somatrogon"
    },
    {
      "code" : "41",
      "display" : "Farmaco in nota: Calcitonina"
    },
    {
      "code" : "42",
      "display" : "Farmaco in nota: Acido etidronico, Acido clodronico"
    },
    {
      "code" : "48",
      "display" : "Farmaco in nota: Acido etidronico, Acido clodronico"
    },
    {
      "code" : "51",
      "display" : "Farmaci in nota: Analoghi del LHRH: Buserelina, Goserelina, Leuprorelina, Triptorelina Modulatori selettivi del Recettore del Progesterone: Ulipristal acetato Antagonisti dell ormone di rilascio delle gonadotropine, estrogeno e progestinico (in associazione): relugolix, estradiolo (come emiidrato) (E2), noretisterone acetato (NETA)"
    },
    {
      "code" : "55",
      "display" : "Farmaco in nota: Tobramicina, Piperacillina + Tazobactam, Piperacillina, Netilmicina, Mezlocillina, Gentamicina, Ceftazidima, Cefepime, Ampicillina + Sulbactam, Amikacina"
    },
    {
      "code" : "56",
      "display" : "Farmaco in nota: Teicoplanina, Rifabutina, Imipenem + Cilastatina, Aztreonam"
    },
    {
      "code" : "65",
      "display" : "Farmaco in nota: Glatiramer acetato - Interferone β-1a - Interferone β-1b - Teriflunomide - Dimetilfumarato - Peginterferone beta-1a"
    },
    {
      "code" : "66",
      "display" : "Farmaco in nota: Tenoxicam, Sulindac, Proglumetacina, Piroxicam, Oxaprozina, Nimesulide, Naprossene, Nabumetone, Meloxicam, Lornoxicam, Ketoprofene, Indometacina, Ibuprofene, Furprofene, Flurbiprofene, Fentiazac, Etoricoxib, Diclofenac + Misoprostolo, Diclofenac, Dexibuprofene, Codeina e ibuprofene, Cinnoxicam, Celecoxib, Amtolmetina, Acido tiaprofenico, Acido mefenamico, Acetametacina, Aceclofenac"
    },
    {
      "code" : "74",
      "display" : "Farmaco in nota: Urofollitropina, Menotropina, Lutropina alfa, Follitropina delta, Follitropina beta, Follitropina alfa/Lutropina alfa, Follitropina alfa, Coriogonadotropina alfa, Corifollitropina alfa"
    },
    {
      "code" : "75",
      "display" : "Farmaco in nota: Vardenafil, Tadalafil, Sildenafil, Avanafil, Alprostadil"
    },
    {
      "code" : "79",
      "display" : "Farmaci a carico SSN inclusi nella 79: Alendronato, Bazedoxifene, Denosumab, Ibandronato, Raloxifene, Risedronato, Romosozumab, Teriparatide, Zoledronato"
    },
    {
      "code" : "82",
      "display" : "Farmaco in nota: Zafirlukast, Montelukast"
    },
    {
      "code" : "83",
      "display" : "Farmaco in nota: Carbomer"
    },
    {
      "code" : "84",
      "display" : "Farmaco in nota: Valaciclovir, Famciclovir, Brivudina, Aciclovir"
    },
    {
      "code" : "85",
      "display" : "Farmaci a carico SSN inclusi nella 85: donepezil - galantamina - rivastigmina - memantina"
    },
    {
      "code" : "87",
      "display" : "Farmaci in Nota: fesoterodina, ossibutina, solifenacina, tolterodina"
    },
    {
      "code" : "88",
      "display" : "Farmaco in nota: Corticosteroidi, preparati dermatologici"
    },
    {
      "code" : "89",
      "display" : "Farmaco in nota: Prometazina, Oxatomide, Mizolastina, Loratadina, Levocetirizina, Ketotifene, Fexofenadina, Ebastina, Desloratadina, Cetirizina, Acrivastina, Rupatadina"
    },
    {
      "code" : "90",
      "display" : "Farmaco in nota: Naloxegol, Metilnaltrexone, Naldemedina"
    },
    {
      "code" : "91",
      "display" : "Farmaco in nota: Febuxostat"
    },
    {
      "code" : "92",
      "display" : "Farmaco in nota: Benzilpenicillina benzatinica"
    },
    {
      "code" : "93",
      "display" : "Farmaco in nota: Midazolam oromucosale"
    },
    {
      "code" : "95",
      "display" : "Farmaci in Nota : diclofenac 3% in ialuronato di sodio, 5-Fluorouracile/Acido salicilico (per la cheratosi attinica); Imiquimod crema 3,75%, 5-Fluorouracile 4%, Tirbanibulina 10 mg/g unguento (per la cheratosi attinica non ipercheratosica non ipertrofica)."
    },
    {
      "code" : "96",
      "display" : "Farmaci in Nota: colecalciferolo, colecalciferolo/Sali di calcio, calcifediolo"
    },
    {
      "code" : "97",
      "display" : "Farmaci in Nota:  AVK : Warfarin, Acenocumarolo -  NAO/DOAC : Dabigatran, Apixaban, Edoxaban, Rivaroxaban"
    },
    {
      "code" : "98",
      "display" : "Farmaci in nota: aflibercept ,  bevacizumab (L. 648/96), brolucizumab, faricimab, ranibizumab"
    },
    {
      "code" : "99",
      "display" : "Farmaci in Nota : medicinali per uso inalatorio (limitatamente ai dosaggi/formulazioni autorizzati per la terapia inalatoria di mantenimento della BPCO) a base dei seguenti principi attivi:  LABA : Formoterolo, Indacaterolo, Olodaterolo, Salmeterolo -  LAMA : Aclidinio, Glicopirronio, Tiotropio, Umeclidinio -  LABA + ICS  (unico erogatore) - Formoterolo/Beclometasone, Formoterolo/Budesonide, Salmeterolo/Fluticasone Propionato, Vilanterolo/Fluticasone Furoato -  LABA + LAMA  (unico erogatore): Indacaterolo/Glicopirronio, Vilanterolo/Umeclidinio, Olodaterolo/Tiotropio, Formoterolo/Aclidinio -  ICS + LABA + LAMA  (unico erogatore): Beclometasone Dipropionato/Formoterolo Fumarato Diidrato/Glicopirronio Bromuro, Fluticasone Furoato/ Umeclidinio Bromuro/ Vilanterolo Trifenatato, Budesonide/glicopirronio bromuro/ formoterolo fumarato diidrato."
    },
    {
      "code" : "100",
      "display" : "Farmaci in Nota: INIBITORI SGLT2: canagliflozin - dapagliflozin - empagliflozin - ertugliflozin\nAGONISTI RECETTORIALI GLP1: dulaglutide - exenatide - exenatide LAR - liraglutide - lixisenatide - semaglutide orale - semaglutide sottocutanea\nINIBITORI DPP4: alogliptin - linagliptin - saxagliptin - sitagliptin - vildagliptin\nASSOCIAZIONI PRECOSTITUITE: canagliflozin/metformina - dapagliflozin/metformina - empagliflozin/metformina - empagliflozin/linagliptin - ertugliflozin/metformina - ertugliflozin/sitagliptin - saxagliptin/dapagliflozin - degludec/liraglutide - glargine/lixisenatide - alogliptin/metformina - alogliptin/pioglitazone - linagliptin/metformina - saxagliptin/metformina - sitagliptin/metformina - vildagliptin/metformina"
    },
    {
      "code" : "101",
      "display" : "Farmaci in Nota: Anticoagulanti orali inibitori della vitamina K (AVK): warfarin - acenocumarolo\nInibitori diretti della trombina o del fattore Xa (NAO/DOAC): dabigatran - apixaban - edoxaban - rivaroxaban"
    }
  ]
}

```
