# AIFA - Gruppo di equivalenza - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **AIFA - Gruppo di equivalenza**

## CodeSystem: AIFA - Gruppo di equivalenza 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/aifa-gruppo-equivalenza | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsAifaGruppoEquivalenza |

 
AIFA - Gruppo di equivalenza 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsGruppoEquivalenza](ValueSet-aifa-ge.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "aifa-gruppo-equivalenza",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/aifa-gruppo-equivalenza",
  "version" : "0.1.2",
  "name" : "CsAifaGruppoEquivalenza",
  "title" : "AIFA - Gruppo di equivalenza",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "AIFA - Gruppo di equivalenza",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "concept" : [
    {
      "code" : "H0A",
      "display" : "ACAMPROSATO 333MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "H1A",
      "display" : "ACARBOSIO 100MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "H1B",
      "display" : "ACARBOSIO 50MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "B4A",
      "display" : "ACEBUTOLOLO 400MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "B5A",
      "display" : "ACECLOFENAC 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "B5B",
      "display" : "ACECLOFENAC 100MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "H2A",
      "display" : "ACENOCUMAROLO 1MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "H2B",
      "display" : "ACENOCUMAROLO 4MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "H3A",
      "display" : "ACETAZOLAMIDE 250MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "26A",
      "display" : "ACICLOVIR 8% 100ML USO ORALE"
    },
    {
      "code" : "26B",
      "display" : "ACICLOVIR 200MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "26C",
      "display" : "ACICLOVIR 400MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "26E",
      "display" : "ACICLOVIR 800MG 35 UNITA' USO ORALE"
    },
    {
      "code" : "26I",
      "display" : "ACICLOVIR 250MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "H4A",
      "display" : "ACIDO ACETILSALICILICO 75MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "H4B",
      "display" : "ACIDO ACETILSALICILICO 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "H4C",
      "display" : "ACIDO ACETILSALICILICO 160MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "H4D",
      "display" : "ACIDO ACETILSALICILICO 300MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "H4E",
      "display" : "ACIDO ACETILSALICILICO 1.000MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "H4F",
      "display" : "ACIDO ACETILSALICILICO 100MG 30 UNITA' POLVERE USO ORALE"
    },
    {
      "code" : "H5A",
      "display" : "ACIDO ACETILSALICILICO+MAGNESIO IDROSSIDO+ALGELDRATO 300MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "CQA",
      "display" : "ACIDO ALENDRONICO 70MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "CQB",
      "display" : "ACIDO ALENDRONICO 10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "CQC",
      "display" : "ACIDO ALENDRONICO 70MG 100ML 4 UNITA' USO ORALE"
    },
    {
      "code" : "CQD",
      "display" : "ACIDO ALENDRONICO 70MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "JBX",
      "display" : "ACIDO ALENDRONICO 70MG 4 UNITA' EFFERVESCENTI USO ORALE"
    },
    {
      "code" : "H6A",
      "display" : "ACIDO ALENDRONICO+COLECALCIFEROLO 70MG + 2.800UI 4 UNITA' USO ORALE"
    },
    {
      "code" : "H6B",
      "display" : "ACIDO ALENDRONICO+COLECALCIFEROLO 70MG + 5.600UI 4 UNITA' USO ORALE"
    },
    {
      "code" : "MKS",
      "display" : "ACIDO BEMPEDOICO 180MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MKT",
      "display" : "ACIDO BEMPEDOICO+EZETIMIBE 180MG+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "BRP",
      "display" : "ACIDO CARGLUMICO 200MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "BRQ",
      "display" : "ACIDO CARGLUMICO 200MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "KKH",
      "display" : "ACIDO CARGLUMICO 200MG 15 UNITA' USO ORALE"
    },
    {
      "code" : "LCO",
      "display" : "ACIDO CARGLUMICO 200MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "KFQ",
      "display" : "ACIDO CHENODESOSSICOLICO 250MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "38A",
      "display" : "ACIDO CLODRONICO 300MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "38B",
      "display" : "ACIDO CLODRONICO 400MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "GSG",
      "display" : "ACIDO FOLICO 400MCG 120 UNITA' USO ORALE"
    },
    {
      "code" : "H7A",
      "display" : "ACIDO FOLICO 400MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "H7B",
      "display" : "ACIDO FOLICO 5MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "H7C",
      "display" : "ACIDO FOLICO 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "H7D",
      "display" : "ACIDO FOLICO 15MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "H7E",
      "display" : "ACIDO FOLICO 5MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JHI",
      "display" : "ACIDO FOLICO 5MG 120 UNITA' USO ORALE"
    },
    {
      "code" : "F6C",
      "display" : "MICOFENOLATO SODICO 180MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "F6D",
      "display" : "MICOFENOLATO SODICO 360MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "MGY",
      "display" : "ACIDO NERIDRONICO 25MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S0A",
      "display" : "ACIDO NERIDRONICO 25MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "H8B",
      "display" : "ACIDO TAUROURSODESOSSICOLICO 250MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "H9A",
      "display" : "ACIDO TIAPROFENICO 300MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CAB",
      "display" : "ACIDO TRANEXAMICO 250MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "CAC",
      "display" : "ACIDO TRANEXAMICO 250MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CAD",
      "display" : "ACIDO TRANEXAMICO 500MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CAE",
      "display" : "ACIDO TRANEXAMICO 500MG 6 UNITA' USO PARENTERALE E ORALE"
    },
    {
      "code" : "01A",
      "display" : "ACIDO URSODESOSSICOLICO 300MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "01B",
      "display" : "ACIDO URSODESOSSICOLICO 450MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "01C",
      "display" : "ACIDO URSODESOSSICOLICO 150MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "01D",
      "display" : "ACIDO URSODESOSSICOLICO 225MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "01E",
      "display" : "ACIDO URSODESOSSICOLICO 250MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "01F",
      "display" : "ACIDO URSODESOSSICOLICO 3% 200ML USO ORALE"
    },
    {
      "code" : "LBM",
      "display" : "ACIDO URSODESOSSICOLICO 250MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LBN",
      "display" : "ACIDO URSODESOSSICOLICO 500MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "S2A",
      "display" : "ACIDO VALPROICO+SODIO VALPROATO 1.000MG 30 UNITA' USO ORALE RM"
    },
    {
      "code" : "S2B",
      "display" : "ACIDO VALPROICO+SODIO VALPROATO 100MG 30 UNITA' USO ORALE RM"
    },
    {
      "code" : "S2C",
      "display" : "ACIDO VALPROICO+SODIO VALPROATO 250MG 30 UNITA' USO ORALE RM"
    },
    {
      "code" : "S2D",
      "display" : "ACIDO VALPROICO+SODIO VALPROATO 300MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "S2F",
      "display" : "ACIDO VALPROICO+SODIO VALPROATO 500MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "S2H",
      "display" : "ACIDO VALPROICO+SODIO VALPROATO 750MG 30 UNITA' USO ORALE RM"
    },
    {
      "code" : "HAA",
      "display" : "ACITRETINA 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HAB",
      "display" : "ACITRETINA 25MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "UBA",
      "display" : "ACLIDINIO BROMURO 322MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "HSZ",
      "display" : "ACLIDINIO+FORMOTEROLO 340+12MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "40A",
      "display" : "ACQUA PER PREPARAZIONI INIETTABILI 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "40B",
      "display" : "ACQUA PER PREPARAZIONI INIETTABILI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "40C",
      "display" : "ACQUA PER PREPARAZIONI INIETTABILI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "41A",
      "display" : "ADRENALINA 0,5MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "41B",
      "display" : "ADRENALINA 1MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HBA",
      "display" : "ALBENDAZOLO 400MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "HCA",
      "display" : "ALBUMINA UMANA 20% 100ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HCB",
      "display" : "ALBUMINA UMANA 20% 50ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HCC",
      "display" : "ALBUMINA UMANA 25% 50ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JJJ",
      "display" : "ALBUTREPENONACOG ALFA 1.000UI 1 USO PARENTERALE"
    },
    {
      "code" : "JJK",
      "display" : "ALBUTREPENONACOG ALFA 2.000UI 1 USO PARENTERALE"
    },
    {
      "code" : "JJL",
      "display" : "ALBUTREPENONACOG ALFA 250UI 1 USO PARENTERALE"
    },
    {
      "code" : "JJM",
      "display" : "ALBUTREPENONACOG ALFA 500UI 1 USO PARENTERALE"
    },
    {
      "code" : "HDA",
      "display" : "ALCINONIDE 0,1% 30G CREMA USO DERMATOLOGICO"
    },
    {
      "code" : "HFA",
      "display" : "ALFACALCIDOLO 0,25MCG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HFB",
      "display" : "ALFACALCIDOLO 2MCG/ML 10ML USO ORALE"
    },
    {
      "code" : "HFC",
      "display" : "ALFACALCIDOLO 1MCG 30 UNITA' USO ORALE"
    },
    {
      "code" : "DWA",
      "display" : "ALFUZOSINA 10MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "DWB",
      "display" : "ALFUZOSINA 2,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "DCE",
      "display" : "ALIROCUMAB 150MG 1ML 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "DCH",
      "display" : "ALIROCUMAB 75MG 1ML 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWM",
      "display" : "ALIROCUMAB 75MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWN",
      "display" : "ALIROCUMAB 150MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HGA",
      "display" : "ALISKIREN 150MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HGB",
      "display" : "ALISKIREN 300MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LLJ",
      "display" : "ALIZAPRIDE 50MG 2ML 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "33A",
      "display" : "ALLOPURINOLO 300MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "33B",
      "display" : "ALLOPURINOLO 100MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "HIA",
      "display" : "ALLOPURINOLO 150MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "HJA",
      "display" : "ALMOTRIPTAN 12,5MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "HJB",
      "display" : "ALMOTRIPTAN 12,5MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "DLL",
      "display" : "ALOGLIPTIN 6,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DXT",
      "display" : "ALOGLIPTIN 12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "EIT",
      "display" : "ALOGLIPTIN 25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "GCC",
      "display" : "ALOGLIPTIN+METFORMINA 12,5MG+850MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "IYW",
      "display" : "ALOGLIPTIN+METFORMINA 12,5MG+1.000MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "GYU",
      "display" : "ALOGLIPTIN+PIOGLITAZONE 12,5MG+30MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "GYV",
      "display" : "ALOGLIPTIN+PIOGLITAZONE 25MG+30MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HKA",
      "display" : "ALOPERIDOLO 10MG/ML 15ML USO ORALE"
    },
    {
      "code" : "HKC",
      "display" : "ALOPERIDOLO 150MG/ML 3ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HKD",
      "display" : "ALOPERIDOLO 1MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HKF",
      "display" : "ALOPERIDOLO 2MG/ML 30ML USO ORALE"
    },
    {
      "code" : "HKG",
      "display" : "ALOPERIDOLO 50MG/ML 1ML 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HKH",
      "display" : "ALOPERIDOLO 5MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "HKI",
      "display" : "ALOPERIDOLO 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HKJ",
      "display" : "ALOPERIDOLO 5MG/ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HLA",
      "display" : "ALPROSTADIL 10MCG 1 UNITA' USO INTRACAVERNOSO"
    },
    {
      "code" : "HMA",
      "display" : "AMBRISENTAN 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HMB",
      "display" : "AMBRISENTAN 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "42C",
      "display" : "AMIKACINA 500MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "42D",
      "display" : "AMIKACINA 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HNA",
      "display" : "AMILORIDE+IDROCLOROTIAZIDE 5+50MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "IZL",
      "display" : "AMINOFILLINA 240MG 10ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "44B",
      "display" : "AMIODARONE 200MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "EUA",
      "display" : "AMISULPRIDE 200MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "EUB",
      "display" : "AMISULPRIDE 400MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HOA",
      "display" : "AMITRIPTILINA 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HOB",
      "display" : "AMITRIPTILINA 25MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "HOC",
      "display" : "AMITRIPTILINA 25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HOD",
      "display" : "AMITRIPTILINA 40MG/ML 20ML USO ORALE"
    },
    {
      "code" : "DOA",
      "display" : "AMLODIPINA 10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "DOB",
      "display" : "AMLODIPINA 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KIQ",
      "display" : "AMLODIPINA 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KGG",
      "display" : "AMLODIPINA+VALSARTAN 5+80MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KGH",
      "display" : "AMLODIPINA+VALSARTAN 5+160MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KGI",
      "display" : "AMLODIPINA+VALSARTAN 10+160MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXQ",
      "display" : "AMLODIPINA+VALSARTAN+IDROCLOROTIAZIDE 5+160+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MHH",
      "display" : "AMLODIPINA+VALSARTAN+IDROCLOROTIAZIDE 5+160+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MHI",
      "display" : "AMLODIPINA+VALSARTAN+IDROCLOROTIAZIDE 10+160+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MHJ",
      "display" : "AMLODIPINA+VALSARTAN+IDROCLOROTIAZIDE 10+320+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MIG",
      "display" : "AMLODIPINA+VALSARTAN+IDROCLOROTIAZIDE 10+160+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "18A",
      "display" : "AMOXICILLINA 5% 100ML USO ORALE"
    },
    {
      "code" : "18B",
      "display" : "AMOXICILLINA 1.000MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "18K",
      "display" : "AMOXICILLINA 500MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "18M",
      "display" : "AMOXICILLINA 250MG/7ML 100ML USO ORALE"
    },
    {
      "code" : "CJA",
      "display" : "AMOXICILLINA+ACIDO CLAVULANICO 875+125MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "CJB",
      "display" : "AMOXICILLINA+ACIDO CLAVULANICO 80+11,4MG/ML 35ML USO ORALE"
    },
    {
      "code" : "CJC",
      "display" : "AMOXICILLINA+ACIDO CLAVULANICO 80+11,4MG/ML 70ML USO ORALE"
    },
    {
      "code" : "CJD",
      "display" : "AMOXICILLINA+ACIDO CLAVULANICO 80+11,4MG/ML 140ML USO ORALE"
    },
    {
      "code" : "CJE",
      "display" : "AMOXICILLINA+ACIDO CLAVULANICO 400+57MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "CKA",
      "display" : "AMPICILLINA+SULBACTAM 500+250MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "CKB",
      "display" : "AMPICILLINA+SULBACTAM 1.000+500MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BRH",
      "display" : "ANAGRELIDE 0,5MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "F7A",
      "display" : "ANASTROZOLO 1MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "NOA",
      "display" : "APIXABAN 2,5MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "NOB",
      "display" : "APIXABAN 2,5MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "NOC",
      "display" : "APIXABAN 2,5MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "NOD",
      "display" : "APIXABAN 5MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "NOE",
      "display" : "APIXABAN 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HQA",
      "display" : "APOMORFINA 30MG/3ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HQB",
      "display" : "APOMORFINA 30MG/3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HRA",
      "display" : "APRACLONIDINA 5MG/ML 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "JEF",
      "display" : "APREMILAST 30MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "JEG",
      "display" : "APREMILAST 10MG 4 UNITA' + 20MG 4 UNITA' + 30MG 19 UNITA' USO ORALE"
    },
    {
      "code" : "HSA",
      "display" : "ARIPIPRAZOLO 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HSB",
      "display" : "ARIPIPRAZOLO 15MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HSC",
      "display" : "ARIPIPRAZOLO 1MG/ML 150ML USO ORALE"
    },
    {
      "code" : "HSD",
      "display" : "ARIPIPRAZOLO 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HTA",
      "display" : "ASENAPINA 10MG 60 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "HTB",
      "display" : "ASENAPINA 5MG 60 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "09A",
      "display" : "ATENOLOLO 100MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "09B",
      "display" : "ATENOLOLO 100MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "09C",
      "display" : "ATENOLOLO 50MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "09D",
      "display" : "ATENOLOLO 100MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "10A",
      "display" : "ATENOLOLO+CLORTALIDONE 100+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "10B",
      "display" : "ATENOLOLO+CLORTALIDONE 50+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "10C",
      "display" : "ATENOLOLO+CLORTALIDONE 50+12,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "10D",
      "display" : "ATENOLOLO+CLORTALIDONE 100+25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "10E",
      "display" : "ATENOLOLO+CLORTALIDONE 50+25MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "10F",
      "display" : "ATENOLOLO+CLORTALIDONE 100+25MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "CXA",
      "display" : "ATENOLOLO+INDAPAMIDE 100+2,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HUA",
      "display" : "ATOMOXETINA 10MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "HUB",
      "display" : "ATOMOXETINA 18MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HUD",
      "display" : "ATOMOXETINA 25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HUF",
      "display" : "ATOMOXETINA 40MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HUG",
      "display" : "ATOMOXETINA 40MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "HUH",
      "display" : "ATOMOXETINA 60MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JBP",
      "display" : "ATOMOXETINA 80MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "JBQ",
      "display" : "ATOMOXETINA 80MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JBS",
      "display" : "ATOMOXETINA 100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FTA",
      "display" : "ATORVASTATINA 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FTB",
      "display" : "ATORVASTATINA 20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FTC",
      "display" : "ATORVASTATINA 40MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FTD",
      "display" : "ATORVASTATINA 80MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FTE",
      "display" : "ATORVASTATINA 10MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "FTF",
      "display" : "ATORVASTATINA 20MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "KMP",
      "display" : "ATORVASTATINA 30MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KMQ",
      "display" : "ATORVASTATINA 60MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KRR",
      "display" : "ATORVASTATINA+PERINDOPRIL+AMLODIPINA 10+5+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KXY",
      "display" : "ATORVASTATINA+PERINDOPRIL+AMLODIPINA 20+5+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KXZ",
      "display" : "ATORVASTATINA+PERINDOPRIL+AMLODIPINA 20+10+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KYY",
      "display" : "ATORVASTATINA+PERINDOPRIL+AMLODIPINA 20+10+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KYZ",
      "display" : "ATORVASTATINA+PERINDOPRIL+AMLODIPINA 40+10+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "47A",
      "display" : "ATROPINA 0,5MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JHG",
      "display" : "AVANAFIL 100MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "JHH",
      "display" : "AVANAFIL 200MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "48A",
      "display" : "AZATIOPRINA 50MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "EGA",
      "display" : "AZITROMICINA 500MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "EGB",
      "display" : "AZITROMICINA 4% 37,5ML USO ORALE"
    },
    {
      "code" : "EGC",
      "display" : "AZITROMICINA 600MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "49A",
      "display" : "BACAMPICILLINA 1.200MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "F1A",
      "display" : "BACLOFENE 25MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "HYA",
      "display" : "BALSALAZIDE 750MG 112 UNITA' USO ORALE"
    },
    {
      "code" : "I0A",
      "display" : "BARNIDIPINA 10MG 28 UNITA' USO ORALE RM"
    },
    {
      "code" : "I0B",
      "display" : "BARNIDIPINA 20MG 28 UNITA' USO ORALE RM"
    },
    {
      "code" : "I1A",
      "display" : "BAZEDOXIFENE 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "50A",
      "display" : "BECLOMETASONE 50MCG 200 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "50B",
      "display" : "BECLOMETASONE 250MCG 200 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "50D",
      "display" : "BECLOMETASONE EXTRAFINE 100MCG 200 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "50G",
      "display" : "BECLOMETASONE 0,8MG 20 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "50H",
      "display" : "BECLOMETASONE 5MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "50I",
      "display" : "BECLOMETASONE 3MG/60ML 7 UNITA' USO RETTALE"
    },
    {
      "code" : "50J",
      "display" : "BECLOMETASONE 3MG/60ML 10 UNITA' USO RETTALE"
    },
    {
      "code" : "50K",
      "display" : "BECLOMETASONE 3MG 10 UNITA' USO RETTALE"
    },
    {
      "code" : "50L",
      "display" : "BECLOMETASONE 42MG 35ML USO RETTALE"
    },
    {
      "code" : "50M",
      "display" : "BECLOMETASONE 0,025% 30G USO DERMATOLOGICO"
    },
    {
      "code" : "50N",
      "display" : "BECLOMETASONE 0,025% 30G SOLUZIONE USO DERMATOLOGICO"
    },
    {
      "code" : "JGE",
      "display" : "BECLOMETASONE 100MCG 200 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "I2A",
      "display" : "BECLOMETASONE+FORMOTEROLO 100+6MCG 120 DOSI SOLUZIONE PRESSURIZZATA USO RESPIRATORIO"
    },
    {
      "code" : "I2B",
      "display" : "BECLOMETASONE+FORMOTEROLO 100+6MCG 120 DOSI POLVERE USO RESPIRATORIO"
    },
    {
      "code" : "JYV",
      "display" : "BECLOMETASONE+FORMOTEROLO 200+6MCG 120 DOSI POLVERE USO RESPIRATORIO"
    },
    {
      "code" : "JYW",
      "display" : "BECLOMETASONE+FORMOTEROLO 200+6MCG 120 DOSI SOLUZIONE PRESSURIZZATA USO RESPIRATORIO"
    },
    {
      "code" : "KNS",
      "display" : "BECLOMETASONE+FORMOTEROLO+GLICOPIRRONIO 87+5+9MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "LUS",
      "display" : "BECLOMETASONE+FORMOTEROLO+GLICOPIRRONIO 88+5+9MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "MLK",
      "display" : "BECLOMETASONE+FORMOTEROLO+GLICOPIRRONIO 172+5+9MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "I3B",
      "display" : "BECLOMETASONE+SALBUTAMOLO 250+100MCG 200 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "IAP",
      "display" : "BECLOMETASONE+SALBUTAMOLO 0,8+1,6MG 10 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "E8A",
      "display" : "BENAZEPRIL 10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "E8B",
      "display" : "BENAZEPRIL 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "EAA",
      "display" : "BENAZEPRIL+IDROCLOROTIAZIDE 10+12,5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KKX",
      "display" : "BENRALIZUMAB 30MG 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "52B",
      "display" : "BENZILPENICILLINA BENZATINA 1.200.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BRK",
      "display" : "BETAINA 180G 1 UNITA' USO ORALE"
    },
    {
      "code" : "53A",
      "display" : "BETAMETASONE 4MG 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "53B",
      "display" : "BETAMETASONE 0,5MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "53C",
      "display" : "BETAMETASONE 1MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "53D",
      "display" : "BETAMETASONE 1,5MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "53H",
      "display" : "BETAMETASONE 0,1% 100G SCHIUMA USO DERMATOLOGICO"
    },
    {
      "code" : "I5A",
      "display" : "BETAXOLOLO 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "I5B",
      "display" : "BETAXOLOLO 5MG/ML 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "TTA",
      "display" : "BEXAROTENE 75MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "EMA",
      "display" : "BEZAFIBRATO 400MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "DXA",
      "display" : "BICALUTAMIDE 50MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DXB",
      "display" : "BICALUTAMIDE 150MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "I6A",
      "display" : "BIMATOPROST 0,1MG/ML 3ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "I6C",
      "display" : "BIMATOPROST 0,3MG/ML 0,4ML 30UNITA' SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "LNU",
      "display" : "BIMATOPROST 0,1MG/ML 0,15ML 30UNITA' SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "MAH",
      "display" : "BIMATOPROST 0,3MG/ML 3ML SOLUZIONE USO OFTALMICO SENZA CONSERVANTI"
    },
    {
      "code" : "I7A",
      "display" : "BIPERIDENE 2MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "I7B",
      "display" : "BIPERIDENE 4MG 50 UNITA' USO ORALE RP"
    },
    {
      "code" : "I7C",
      "display" : "BIPERIDENE 5MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GTH",
      "display" : "BISMUTO OSSIDO+METRONIDAZOLO+TETRACICLINA CLORIDRATO 140+125+125MG 120 UNITA' USO ORALE"
    },
    {
      "code" : "CYA",
      "display" : "BISOPROLOLO 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "CYB",
      "display" : "BISOPROLOLO 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "CYC",
      "display" : "BISOPROLOLO 1,25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "CYD",
      "display" : "BISOPROLOLO 2,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "CYE",
      "display" : "BISOPROLOLO 3,75MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "CYF",
      "display" : "BISOPROLOLO 7,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "I9A",
      "display" : "BISOPROLOLO+IDROCLOROTIAZIDE 10+6,25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "I9B",
      "display" : "BISOPROLOLO+IDROCLOROTIAZIDE 2,5+6,25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "I9C",
      "display" : "BISOPROLOLO+IDROCLOROTIAZIDE 5+6,25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KBV",
      "display" : "BISOPROLOLO+PERINDOPRIL 10+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KBW",
      "display" : "BISOPROLOLO+PERINDOPRIL 10+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KBX",
      "display" : "BISOPROLOLO+PERINDOPRIL 5+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KBY",
      "display" : "BISOPROLOLO+PERINDOPRIL 5+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "IAA",
      "display" : "BORNAPRINA 4MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "IBA",
      "display" : "BOSENTAN 62,5MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "IBB",
      "display" : "BOSENTAN 125MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "LDZ",
      "display" : "BREXPIPRAZOLO 1MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "LEB",
      "display" : "BREXPIPRAZOLO 2MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LEJ",
      "display" : "BREXPIPRAZOLO 3MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LEK",
      "display" : "BREXPIPRAZOLO 4MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "ECA",
      "display" : "BRIMONIDINA 0,2% 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "JVT",
      "display" : "BRIMONIDINA 0,2% 0,35ML 60 UNITA' SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "IDA",
      "display" : "BRINZOLAMIDE 10MG/ML 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "IEA",
      "display" : "BRINZOLAMIDE+TIMOLOLO 10+5MG/ML 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "KJF",
      "display" : "BRIVARACETAM 10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KJG",
      "display" : "BRIVARACETAM 100MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KJH",
      "display" : "BRIVARACETAM 25MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KJI",
      "display" : "BRIVARACETAM 50MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KJJ",
      "display" : "BRIVARACETAM 75MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KLO",
      "display" : "BRIVARACETAM 10MG/ML 300ML USO ORALE"
    },
    {
      "code" : "IFA",
      "display" : "BRIVUDINA 125MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "17A",
      "display" : "BROMOCRIPTINA 2,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "17B",
      "display" : "BROMOCRIPTINA 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "17D",
      "display" : "BROMOCRIPTINA 10MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "C4A",
      "display" : "BUDESONIDE 200MCG 100 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "C4B",
      "display" : "BUDESONIDE 0,25MG/ML 2 ML 20 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "C4C",
      "display" : "BUDESONIDE 0,5MG/ML 2ML 20 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "C4D",
      "display" : "BUDESONIDE 400MCG 50 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "C4E",
      "display" : "BUDESONIDE 200MCG 200 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "C4F",
      "display" : "BUDESONIDE 0,025% 30G CREMA USO DERMATOLOGICO"
    },
    {
      "code" : "C4G",
      "display" : "BUDESONIDE 400MCG 60 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "C4I",
      "display" : "BUDESONIDE 100MCG 200 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "C4K",
      "display" : "BUDESONIDE 0,025% 30G UNGUENTO USO DERMATOLOGICO"
    },
    {
      "code" : "C4L",
      "display" : "BUDESONIDE 400MCG 100 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "C4M",
      "display" : "BUDESONIDE 3MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "HOY",
      "display" : "BUDESONIDE 9MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "KHQ",
      "display" : "BUDESONIDE 200MCG 60 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "LTX",
      "display" : "BUDESONIDE 1MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "MKQ",
      "display" : "BUDESONIDE 0,5MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "IHA",
      "display" : "BUDESONIDE+FORMOTEROLO 160+4,5MCG 120 DOSI USO RESPIRATORIO + TURBOHALER"
    },
    {
      "code" : "IHB",
      "display" : "BUDESONIDE+FORMOTEROLO 320+9MCG 60 DOSI USO RESPIRATORIO + TURBOHALER"
    },
    {
      "code" : "IHC",
      "display" : "BUDESONIDE+FORMOTEROLO 80+4,5MCG 120 DOSI USO RESPIRATORIO + TURBOHALER"
    },
    {
      "code" : "JNX",
      "display" : "BUDESONIDE+FORMOTEROLO 160+4,5MCG 120 DOSI USO RESPIRATORIO + SPIROMAX"
    },
    {
      "code" : "JNY",
      "display" : "BUDESONIDE+FORMOTEROLO 160+4,5MCG 120 DOSI USO RESPIRATORIO + EASYHALER"
    },
    {
      "code" : "JNZ",
      "display" : "BUDESONIDE+FORMOTEROLO 320+9MCG 60 DOSI USO RESPIRATORIO + SPIROMAX"
    },
    {
      "code" : "JOB",
      "display" : "BUDESONIDE+FORMOTEROLO 320+9MCG 60 DOSI USO RESPIRATORIO + EASYHALER"
    },
    {
      "code" : "KCF",
      "display" : "BUDESONIDE+FORMOTEROLO 160+4,5MCG 120 DOSI SPRAY USO RESPIRATORIO"
    },
    {
      "code" : "KUW",
      "display" : "BUDESONIDE+FORMOTEROLO 200+6MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "KWZ",
      "display" : "BUDESONIDE+FORMOTEROLO 80+4,5MCG 120 DOSI USO RESPIRATORIO + EASYHALER"
    },
    {
      "code" : "LRI",
      "display" : "BUDESONIDE+FORMOTEROLO 80+2,25MCG 120 DOSI SPRAY USO RESPIRATORIO"
    },
    {
      "code" : "MBS",
      "display" : "BUDESONIDE+FORMOTEROLO 160+4,5MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "MBU",
      "display" : "BUDESONIDE+FORMOTEROLO 320+9MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "MLZ",
      "display" : "BULEVIRTIDE 2MG 30 UNITA' USO PARENTERALE"
    },
    {
      "code" : "IIA",
      "display" : "BUPRENORFINA 0,2MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "IIB",
      "display" : "BUPRENORFINA 0,3MG 1ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "IIC",
      "display" : "BUPRENORFINA 20MG 35MCG/ORA 3 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "IID",
      "display" : "BUPRENORFINA 30MG 52,5MCG/ORA 3 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "IIE",
      "display" : "BUPRENORFINA 40MG 70MCG/ORA 3 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "KBR",
      "display" : "BUPRENORFINA 10MG 10MCG/ORA 4 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "KBS",
      "display" : "BUPRENORFINA 5MG 5MCG/ORA 4 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "KCO",
      "display" : "BUPRENORFINA 20MCG/ORA 4 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "MID",
      "display" : "BUPRENORFINA 15MCG/ORA 4 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "G5A",
      "display" : "BUPRENORFINA+NALOXONE 2+0,5MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "G5B",
      "display" : "BUPRENORFINA+NALOXONE 8+2MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "JER",
      "display" : "BUPRENORFINA+NALOXONE 16+4MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KWU",
      "display" : "BUPRENORFINA+NALOXONE 4+1MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "LKO",
      "display" : "BUPRENORFINA+NALOXONE 2+0,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LKP",
      "display" : "BUPRENORFINA+NALOXONE 8+2MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LQY",
      "display" : "BUPRENORFINA+NALOXONE 4+1MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LQZ",
      "display" : "BUPRENORFINA+NALOXONE 12+3MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "P1B",
      "display" : "BUPROPIONE 150MG 30 UNITA' USO ORALE RM"
    },
    {
      "code" : "P1C",
      "display" : "BUPROPIONE 300MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "IJA",
      "display" : "BUSERELIN 0,1MG/EROGAZIONE SPRAY USO NASALE"
    },
    {
      "code" : "IJB",
      "display" : "BUSERELIN 1MG/ML 5,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "IJC",
      "display" : "BUSERELIN 6,3MG 1 UNITA' USO PARENTERALE RP"
    },
    {
      "code" : "IJD",
      "display" : "BUSERELIN 9,45MG 1 UNITA' USO PARENTERALE RP"
    },
    {
      "code" : "CZA",
      "display" : "CABERGOLINA 0,5MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "CZB",
      "display" : "CABERGOLINA 0,5MG 2 UNITA' USO ORALE"
    },
    {
      "code" : "ILA",
      "display" : "CALCIFEDIOLO 1,5MG/10ML USO ORALE"
    },
    {
      "code" : "KGZ",
      "display" : "CALCIFEDIOLO 0,266MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "KHB",
      "display" : "CALCIFEDIOLO 0,266MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "INA",
      "display" : "CALCIO ACETATO+MAGNESIO CARBONATO 435+235MG 180 UNITA' USO ORALE"
    },
    {
      "code" : "03A",
      "display" : "CALCIO CARBONATO 1.000MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "AQA",
      "display" : "CALCIO CARBONATO+COLECALCIFEROLO 1.000MG+880UI 30 UNITA' USO ORALE"
    },
    {
      "code" : "AQC",
      "display" : "CALCIO CARBONATO+COLECALCIFEROLO 500MG+400UI 60 UNITA' USO ORALE"
    },
    {
      "code" : "AQD",
      "display" : "CALCIO CARBONATO+COLECALCIFEROLO 600MG+400UI 60 UNITA' USO ORALE"
    },
    {
      "code" : "MMK",
      "display" : "CALCIO CARBONATO+COLECALCIFEROLO 600MG+2.000UI 60 UNITA' USO ORALE"
    },
    {
      "code" : "IOA",
      "display" : "CALCIO FOLINATO 50MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AQZ",
      "display" : "CALCIO FOSFATO+COLECALCIFEROLO 1.200MG+880UI 30 UNITA' USO ORALE"
    },
    {
      "code" : "IPA",
      "display" : "CALCIO POLISTIRENSOLFONATO 500G USO ORALE O RETTALE"
    },
    {
      "code" : "DGA",
      "display" : "CALCIPOTRIOLO 0,005% 30G UNGUENTO USO DERMATOLOGICO"
    },
    {
      "code" : "DGB",
      "display" : "CALCIPOTRIOLO 0,005% 30ML SOLUZIONE USO DERMATOLOGICO"
    },
    {
      "code" : "IQA",
      "display" : "CALCIPOTRIOLO+BETAMETASONE 30G 50MCG/G+0,5MG/G USO DERMATOLOGICO"
    },
    {
      "code" : "IQB",
      "display" : "CALCIPOTRIOLO+BETAMETASONE 60G 50MCG/G+0,5MG/G USO DERMATOLOGICO"
    },
    {
      "code" : "KAK",
      "display" : "CALCIPOTRIOLO+BETAMETASONE 60G 50MCG/G+0,5MG/G SCHIUMA USO DERMATOLOGICO"
    },
    {
      "code" : "MOM",
      "display" : "CALCIPOTRIOLO+BETAMETASONE 60G 50MCG/G+0,5MG/G USO 2 UNITA' USO DERMATOLOGICO"
    },
    {
      "code" : "56C",
      "display" : "CALCITONINA SINTETICA DI SALMONE 100UI 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AVA",
      "display" : "CALCITRIOLO 0,25MCG 30 UNITA' USO ORALE"
    },
    {
      "code" : "AVB",
      "display" : "CALCITRIOLO 0,50MCG 30 UNITA' USO ORALE"
    },
    {
      "code" : "AVD",
      "display" : "CALCITRIOLO 3MCG/G 30G UNGUENTO USO DERMATOLOGICO"
    },
    {
      "code" : "JCR",
      "display" : "CANAGLIFLOZIN 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JCS",
      "display" : "CANAGLIFLOZIN 300MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JCN",
      "display" : "CANAGLIFLOZIN+METFORMINA 50+850MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JCO",
      "display" : "CANAGLIFLOZIN+METFORMINA 50+1.000MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JCP",
      "display" : "CANAGLIFLOZIN+METFORMINA 150+850MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JCQ",
      "display" : "CANAGLIFLOZIN+METFORMINA 150+1.000MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "FWA",
      "display" : "CANDESARTAN CILEXETIL 8MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FWB",
      "display" : "CANDESARTAN CILEXETIL 16MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FWC",
      "display" : "CANDESARTAN CILEXETIL 32MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KNT",
      "display" : "CANDESARTAN+AMLODIPINA 8+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KNU",
      "display" : "CANDESARTAN+AMLODIPINA 16+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KNV",
      "display" : "CANDESARTAN+AMLODIPINA 8+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KNW",
      "display" : "CANDESARTAN+AMLODIPINA 16+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FXA",
      "display" : "CANDESARTAN CILEXETIL+IDROCLOROTIAZIDE 16+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FXB",
      "display" : "CANDESARTAN CILEXETIL+IDROCLOROTIAZIDE 32+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FXC",
      "display" : "CANDESARTAN CILEXETIL+IDROCLOROTIAZIDE 32+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LOO",
      "display" : "CANNABIDIOLO 100MG/ML 100ML - USO ORALE"
    },
    {
      "code" : "IRA",
      "display" : "CANRENONE 100MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "IRB",
      "display" : "CANRENONE 50MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "BRI",
      "display" : "CAPECITABINA 500MG 120 UNITA' USO ORALE"
    },
    {
      "code" : "BRJ",
      "display" : "CAPECITABINA 150MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "57A",
      "display" : "CAPTOPRIL 25MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "57B",
      "display" : "CAPTOPRIL 50MG 24 UNITA' USO ORALE"
    },
    {
      "code" : "CPA",
      "display" : "CAPTOPRIL+IDROCLOROTIAZIDE 50+25MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "CPB",
      "display" : "CAPTOPRIL+IDROCLOROTIAZIDE 50+15MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "58A",
      "display" : "CARBAMAZEPINA 2% 250ML USO ORALE"
    },
    {
      "code" : "58B",
      "display" : "CARBAMAZEPINA 200MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "58C",
      "display" : "CARBAMAZEPINA 200MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "58D",
      "display" : "CARBAMAZEPINA 400MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "58E",
      "display" : "CARBAMAZEPINA 400MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "ISB",
      "display" : "CARBOMER 0,5G 30 UNITA' GEL USO OFTALMICO"
    },
    {
      "code" : "KMG",
      "display" : "CARIPRAZINA 1,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KMH",
      "display" : "CARIPRAZINA 3MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KMI",
      "display" : "CARIPRAZINA 4,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KMJ",
      "display" : "CARIPRAZINA 6MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "ITA",
      "display" : "CARTEOLOLO 1% 0,2ML 30 UNITA' SOLUZIONE USO OFTALMICO RP"
    },
    {
      "code" : "ITB",
      "display" : "CARTEOLOLO 1% 30 UNITA' SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "ITC",
      "display" : "CARTEOLOLO 1% 3ML SOLUZIONE USO OFTALMICO RP"
    },
    {
      "code" : "ITD",
      "display" : "CARTEOLOLO 1% 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "ITE",
      "display" : "CARTEOLOLO 2% 30 UNITA' 0,2ML SOLUZIONE USO OFTALMICO RP"
    },
    {
      "code" : "ITF",
      "display" : "CARTEOLOLO 2% 30 UNITA' 0,3ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "ITG",
      "display" : "CARTEOLOLO 2% 3ML SOLUZIONE USO OFTALMICO RP"
    },
    {
      "code" : "ITH",
      "display" : "CARTEOLOLO 2% 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "C2A",
      "display" : "CARVEDILOLO 6,25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "C2B",
      "display" : "CARVEDILOLO 25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "C2C",
      "display" : "CARVEDILOLO 12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "21A",
      "display" : "CEFACLORO 5% 100ML USO ORALE"
    },
    {
      "code" : "21C",
      "display" : "CEFACLORO 500MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "21D",
      "display" : "CEFACLORO 750MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "59A",
      "display" : "CEFALEXINA 5% 100ML USO ORALE"
    },
    {
      "code" : "59D",
      "display" : "CEFALEXINA 500MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "59E",
      "display" : "CEFALEXINA 1.000MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "20A",
      "display" : "CEFAZOLINA 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "IUA",
      "display" : "CEFDITOREN 200MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "IUB",
      "display" : "CEFDITOREN 400MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "IVA",
      "display" : "CEFEPIME 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "DUA",
      "display" : "CEFIXIMA 2% 100ML USO ORALE"
    },
    {
      "code" : "DUB",
      "display" : "CEFIXIMA 400MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "IWA",
      "display" : "CEFMETAZOLO 1.000MG 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "IXA",
      "display" : "CEFODIZIMA 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ASA",
      "display" : "CEFOTAXIMA 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ASC",
      "display" : "CEFOTAXIMA 500MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "FFA",
      "display" : "CEFPODOXIMA 0,8% 100ML USO ORALE"
    },
    {
      "code" : "FFB",
      "display" : "CEFPODOXIMA 100MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "FFC",
      "display" : "CEFPODOXIMA 200MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "IZA",
      "display" : "CEFPROZIL 250MG/5ML USO ORALE"
    },
    {
      "code" : "IZB",
      "display" : "CEFPROZIL 500MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "C7A",
      "display" : "CEFTAZIDIMA 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "C7B",
      "display" : "CEFTAZIDIMA 500MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "C7C",
      "display" : "CEFTAZIDIMA 250MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "J0A",
      "display" : "CEFTIBUTEN 36MG/ML - USO ORALE"
    },
    {
      "code" : "J0B",
      "display" : "CEFTIBUTEN 400MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "C0A",
      "display" : "CEFTRIAXONE 250MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "C0B",
      "display" : "CEFTRIAXONE 500MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "C0C",
      "display" : "CEFTRIAXONE 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "63B",
      "display" : "CEFUROXIMA 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "63C",
      "display" : "CEFUROXIMA 250MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "63D",
      "display" : "CEFUROXIMA 500MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "63F",
      "display" : "CEFUROXIMA 250MG/5ML 50ML USO ORALE"
    },
    {
      "code" : "63H",
      "display" : "CEFUROXIMA 500MG 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "J1A",
      "display" : "CELECOXIB 200MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "J1B",
      "display" : "CELECOXIB 100MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "J2A",
      "display" : "CELIPROLOLO 200MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LYP",
      "display" : "CENOBAMATO 200MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LYQ",
      "display" : "CENOBAMATO 200MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "LYR",
      "display" : "CENOBAMATO 25MG 14 UNITA' + 12,5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "LYS",
      "display" : "CENOBAMATO 50MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "LYT",
      "display" : "CENOBAMATO 50MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LYU",
      "display" : "CENOBAMATO 100MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "LYV",
      "display" : "CENOBAMATO 100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LYW",
      "display" : "CENOBAMATO 150MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "LYX",
      "display" : "CENOBAMATO 150MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DFA",
      "display" : "CETIRIZINA 10MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "DFB",
      "display" : "CETIRIZINA 1% 20ML USO ORALE"
    },
    {
      "code" : "B6A",
      "display" : "CIANOCOBALAMINA 1.000MCG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "B6B",
      "display" : "CIANOCOBALAMINA 20MCG/ML 15ML USO ORALE"
    },
    {
      "code" : "J3A",
      "display" : "CICLESONIDE 160MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "J3B",
      "display" : "CICLESONIDE 80MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "J4A",
      "display" : "CICLOFOSFAMIDE 50MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "DGW",
      "display" : "CICLOSPORINA 1MG/ML 30 UNITA' USO OFTALMICO"
    },
    {
      "code" : "J5A",
      "display" : "CICLOSPORINA 100MG 30 UNITA' USO ORALE PICCO EMATICO 1 - 2 ORE"
    },
    {
      "code" : "J5B",
      "display" : "CICLOSPORINA 100MG/ML 50ML USO ORALE PICCO EMATICO 1 - 6 ORE"
    },
    {
      "code" : "J5C",
      "display" : "CICLOSPORINA 10MG 50 UNITA' USO ORALE PICCO EMATICO 1 - 2 ORE"
    },
    {
      "code" : "J5D",
      "display" : "CICLOSPORINA 25MG 50 UNITA' USO ORALE PICCO EMATICO 1 - 2 ORE"
    },
    {
      "code" : "J5E",
      "display" : "CICLOSPORINA 50MG 50 UNITA' USO ORALE PICCO EMATICO 1 - 2 ORE"
    },
    {
      "code" : "J5F",
      "display" : "CICLOSPORINA 50MG/ML 5ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JCX",
      "display" : "CICLOSPORINA 25MG 50 UNITA' USO ORALE PICCO EMATICO 5 - 6 ORE"
    },
    {
      "code" : "JCY",
      "display" : "CICLOSPORINA 50MG 50 UNITA' USO ORALE PICCO EMATICO 5 - 6 ORE"
    },
    {
      "code" : "JCZ",
      "display" : "CICLOSPORINA 100MG 30 UNITA' USO ORALE PICCO EMATICO 5 - 6 ORE"
    },
    {
      "code" : "JVR",
      "display" : "CICLOSPORINA 100MG/ML 50ML USO ORALE PICCO EMATICO 1 - 2 ORE"
    },
    {
      "code" : "LCR",
      "display" : "CICLOSPORINA 1MG/ML 120 UNITA' USO OFTALMICO"
    },
    {
      "code" : "J6A",
      "display" : "CILAZAPRIL 5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "J7A",
      "display" : "CILAZAPRIL+IDROCLOROTIAZIDE 5+12,5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "J9A",
      "display" : "CINACALCET 30MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "J9B",
      "display" : "CINACALCET 60MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "J9C",
      "display" : "CINACALCET 90MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "D8A",
      "display" : "CIPROFLOXACINA 250MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "D8B",
      "display" : "CIPROFLOXACINA 500MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "D8C",
      "display" : "CIPROFLOXACINA 750MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "D8F",
      "display" : "CIPROFLOXACINA 250MG/5ML 100ML USO ORALE"
    },
    {
      "code" : "65A",
      "display" : "CIPROTERONE 300MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "65B",
      "display" : "CIPROTERONE 50MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "65C",
      "display" : "CIPROTERONE 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KPT",
      "display" : "CIPROTERONE 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "B7A",
      "display" : "CITALOPRAM 4% 15ML USO ORALE"
    },
    {
      "code" : "B7B",
      "display" : "CITALOPRAM 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "B7C",
      "display" : "CITALOPRAM 40MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "B7D",
      "display" : "CITALOPRAM 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KIJ",
      "display" : "CLADRIBINA 10MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "KRH",
      "display" : "CLADRIBINA 10MG 1 UNITA' USO ORALE"
    },
    {
      "code" : "KRI",
      "display" : "CLADRIBINA 10MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "DPA",
      "display" : "CLARITROMICINA 250MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "DPB",
      "display" : "CLARITROMICINA 500MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "DPC",
      "display" : "CLARITROMICINA 500MG 7 UNITA' - USO ORALE"
    },
    {
      "code" : "DPD",
      "display" : "CLARITROMICINA 2,5% 100ML USO ORALE"
    },
    {
      "code" : "DPE",
      "display" : "CLARITROMICINA 5% 100ML USO ORALE"
    },
    {
      "code" : "DPF",
      "display" : "CLARITROMICINA 500MG 7 UNITA' USO ORALE RP"
    },
    {
      "code" : "DPG",
      "display" : "CLARITROMICINA 250MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "67A",
      "display" : "CLINDAMICINA 600MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "67B",
      "display" : "CLINDAMICINA 600MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "67C",
      "display" : "CLINDAMICINA 150MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "LOY",
      "display" : "CLOBAZAM 150ML 5MG/5ML USO ORALE"
    },
    {
      "code" : "EVA",
      "display" : "CLOBETASOLO 500MCG/G 30G USO DERMATOLOGICO"
    },
    {
      "code" : "EVB",
      "display" : "CLOBETASOLO 500MCG/G 100G USO DERMATOLOGICO"
    },
    {
      "code" : "EVC",
      "display" : "CLOBETASOLO 500MCG/G 125ML SHAMPOO"
    },
    {
      "code" : "EYV",
      "display" : "CLOBETASOLO 500MCG/G 100ML SOLUZIONE USO DERMATOLOGICO"
    },
    {
      "code" : "JDA",
      "display" : "CLOMIFENE 50MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "68A",
      "display" : "CLOMIPRAMINA 25MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "68B",
      "display" : "CLOMIPRAMINA 10MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "68C",
      "display" : "CLOMIPRAMINA 25MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "68D",
      "display" : "CLOMIPRAMINA 75MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "JEB",
      "display" : "CLONAZEPAM 2,5MG/ML 10ML USO ORALE"
    },
    {
      "code" : "JFB",
      "display" : "CLONIDINA 2,5MG 2 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "JFD",
      "display" : "CLONIDINA 5MG 2 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "EWA",
      "display" : "CLOPIDOGREL 75MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JGA",
      "display" : "CLOPIDOGREL+ACIDO ACETILSALICILICO 75+100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JHA",
      "display" : "CLORAMBUCILE 2MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "B8A",
      "display" : "CLORPROMAZINA 25MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "B8C",
      "display" : "CLORPROMAZINA 100MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "B8D",
      "display" : "CLORPROMAZINA 50MG 2ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JLA",
      "display" : "CLORTALIDONE 25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JMA",
      "display" : "CLOTIAPINA 100MG/ML 10ML USO ORALE"
    },
    {
      "code" : "AZA",
      "display" : "CLOZAPINA 100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "AZB",
      "display" : "CLOZAPINA 25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "72A",
      "display" : "COLCHICINA 1MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JED",
      "display" : "COLECALCIFEROLO 25.000UI/2,5ML 10ML USO ORALE"
    },
    {
      "code" : "JNA",
      "display" : "COLECALCIFEROLO 10.000UI/ML 10ML USO ORALE"
    },
    {
      "code" : "JNC",
      "display" : "COLECALCIFEROLO 25.000UI/2,5ML USO ORALE"
    },
    {
      "code" : "JNF",
      "display" : "COLECALCIFEROLO 50.000UI 1 UNITA' USO ORALE"
    },
    {
      "code" : "JNG",
      "display" : "COLECALCIFEROLO 50.000UI 2 UNITA' USO ORALE"
    },
    {
      "code" : "JNH",
      "display" : "COLECALCIFEROLO 25.000UI 2 UNITA' USO ORALE"
    },
    {
      "code" : "LBW",
      "display" : "COLECALCIFEROLO 7.000UI 12 UNITA' USO ORALE"
    },
    {
      "code" : "LBX",
      "display" : "COLECALCIFEROLO 30.000UI 4 UNITA' USO ORALE"
    },
    {
      "code" : "LGZ",
      "display" : "COLECALCIFEROLO 50.000UI 2 UNITA' PREPARAZIONE SOLIDA USO ORALE"
    },
    {
      "code" : "LMB",
      "display" : "COLECALCIFEROLO 20.000UI 10 UNITA' USO ORALE"
    },
    {
      "code" : "LOK",
      "display" : "COLECALCIFEROLO 20.000UI 5 UNITA' USO ORALE"
    },
    {
      "code" : "LPC",
      "display" : "COLECALCIFEROLO 25.000UI 2 UNITA' PREPARAZIONE SOLIDA USO ORALE"
    },
    {
      "code" : "LSP",
      "display" : "COLECALCIFEROLO 100.000UI/ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LSQ",
      "display" : "COLECALCIFEROLO 300.000UI/ML 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MBR",
      "display" : "COLECALCIFEROLO 25.000UI 4 UNITA' USO ORALE"
    },
    {
      "code" : "JOA",
      "display" : "COLESTIRAMINA 4G 12 UNITA' USO ORALE"
    },
    {
      "code" : "JPA",
      "display" : "COMPLESSO PROTROMBINICO ANTIEMOFILICO UMANO ATTIVATO 1.000UF 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "TNA",
      "display" : "CORIFOLLITROPINA ALFA 100MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "TNB",
      "display" : "CORIFOLLITROPINA ALFA 150MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JSA",
      "display" : "CORIOGONADOTROPINA ALFA 250MCG/0,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JTA",
      "display" : "CORTISONE ACETATO 25MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "TRA",
      "display" : "DABIGATRAN 110MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "TRB",
      "display" : "DABIGATRAN 75MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "TRC",
      "display" : "DABIGATRAN 110MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "TRD",
      "display" : "DABIGATRAN 75MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "TRE",
      "display" : "DABIGATRAN 110MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "TRF",
      "display" : "DABIGATRAN 150MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "KZT",
      "display" : "DAMOCTOCOG ALFA PEGOL 500UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KZU",
      "display" : "DAMOCTOCOG ALFA PEGOL 1000UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KZV",
      "display" : "DAMOCTOCOG ALFA PEGOL 2000UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KZW",
      "display" : "DAMOCTOCOG ALFA PEGOL 3000UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JVA",
      "display" : "DANAZOLO 200MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JVB",
      "display" : "DANAZOLO 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "GYC",
      "display" : "DAPAGLIFLOZIN 10MG 28 UNITA' 10MG USO ORALE"
    },
    {
      "code" : "KTE",
      "display" : "DAPAGLIFLOZIN 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "EZD",
      "display" : "DAPAGLIFLOZIN+METFORMINA 5+850MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "EZE",
      "display" : "DAPAGLIFLOZIN+METFORMINA 5+1000MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "JWA",
      "display" : "DARBEPOETINA ALFA 100MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWB",
      "display" : "DARBEPOETINA ALFA 10MCG 0,4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWC",
      "display" : "DARBEPOETINA ALFA 150MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWD",
      "display" : "DARBEPOETINA ALFA 20MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWE",
      "display" : "DARBEPOETINA ALFA 300MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWF",
      "display" : "DARBEPOETINA ALFA 30MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWG",
      "display" : "DARBEPOETINA ALFA 40MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWH",
      "display" : "DARBEPOETINA ALFA 500MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWI",
      "display" : "DARBEPOETINA ALFA 50MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWJ",
      "display" : "DARBEPOETINA ALFA 60MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JWK",
      "display" : "DARBEPOETINA ALFA 80MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JXI",
      "display" : "DEFERASIROX 90MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JXJ",
      "display" : "DEFERASIROX 180MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JXK",
      "display" : "DEFERASIROX 360MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JXA",
      "display" : "DEFERIPRONE 1.000MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "JXB",
      "display" : "DEFERIPRONE 100MG/ML 250ML USO ORALE"
    },
    {
      "code" : "JXC",
      "display" : "DEFERIPRONE 500MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "73A",
      "display" : "DEFEROXAMINA 500MG 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "73B",
      "display" : "DEFEROXAMINA 2G/20ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JYA",
      "display" : "DEGARELIX 120MG 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JYB",
      "display" : "DEGARELIX 80MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "K0A",
      "display" : "DELAPRIL+INDAPAMIDE 30+2,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "K1A",
      "display" : "DELAPRIL+MANIDIPINA 30+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "AKO",
      "display" : "DENOSUMAB 120MG 1,7ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "K2A",
      "display" : "DENOSUMAB 60MG/ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "K3B",
      "display" : "DESAMETASONE 2MG/ML 10ML USO ORALE"
    },
    {
      "code" : "K3D",
      "display" : "DESAMETASONE 4MG/ML 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "K3E",
      "display" : "DESAMETASONE 8MG/2ML 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "K3F",
      "display" : "DESAMETASONE 0,1% 30G CREMA USO DERMATOLOGICO"
    },
    {
      "code" : "KIL",
      "display" : "DESAMETASONE 0,2% 30ML USO ORALE"
    },
    {
      "code" : "LAH",
      "display" : "DESAMETASONE 0,5MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "LAI",
      "display" : "DESAMETASONE 0,75MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "LBC",
      "display" : "DESAMETASONE 2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LBD",
      "display" : "DESAMETASONE 4MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LBE",
      "display" : "DESAMETASONE 8MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LDO",
      "display" : "DESAMETASONE 4MG/ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LDP",
      "display" : "DESAMETASONE 8MG/ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "G2A",
      "display" : "DESLORATADINA 5MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "EJA",
      "display" : "DESMOPRESSINA 0,1MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "EJB",
      "display" : "DESMOPRESSINA 0,2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "EJC",
      "display" : "DESMOPRESSINA 60MCG 30 UNITA' USO ORALE"
    },
    {
      "code" : "EJD",
      "display" : "DESMOPRESSINA 120MCG 30 UNITA' USO ORALE"
    },
    {
      "code" : "EJG",
      "display" : "DESMOPRESSINA 4MCG 1ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "EJH",
      "display" : "DESMOPRESSINA 4MCG 0,5ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "EJI",
      "display" : "DESMOPRESSINA 20MCG 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "K6A",
      "display" : "DESMOPRESSINA 0,125MG SPRAY USO NASALE"
    },
    {
      "code" : "BRR",
      "display" : "DESOSSIRIBONUCLEASI 2.500UI 2,5ML 6 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "K8A",
      "display" : "DEXIBUPROFENE 300MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "K8B",
      "display" : "DEXIBUPROFENE 400MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "K9A",
      "display" : "DIAZOSSIDO 100MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "K9B",
      "display" : "DIAZOSSIDO 25MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "28A",
      "display" : "DICLOFENAC 100MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "28B",
      "display" : "DICLOFENAC 100MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "28C",
      "display" : "DICLOFENAC 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "28D",
      "display" : "DICLOFENAC 75MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "28E",
      "display" : "DICLOFENAC 75MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "28F",
      "display" : "DICLOFENAC 75MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "28G",
      "display" : "DICLOFENAC 150MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "28H",
      "display" : "DICLOFENAC 75MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "28I",
      "display" : "DICLOFENAC 50MG/ML 100ML USO ORALE"
    },
    {
      "code" : "JTI",
      "display" : "DICLOFENAC 3% 60G GEL USO ESTERNO"
    },
    {
      "code" : "KGF",
      "display" : "DICLOFENAC 3% 90G GEL USO ESTERNO"
    },
    {
      "code" : "KAA",
      "display" : "DICLOFENAC+MISOPROSTOLO 50+0,2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KAB",
      "display" : "DICLOFENAC+MISOPROSTOLO 75+0,2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KBA",
      "display" : "DIDROGESTERONE 10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KCB",
      "display" : "DIFLUCORTOLONE 0,3% 20G USO DERMATOLOGICO"
    },
    {
      "code" : "KCC",
      "display" : "DIFLUCORTOLONE 0,3% 30G USO DERMATOLOGICO"
    },
    {
      "code" : "KDA",
      "display" : "DIGOSSINA 0,05MG/ML 60ML USO ORALE"
    },
    {
      "code" : "KDB",
      "display" : "DIGOSSINA 0,0625MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KDC",
      "display" : "DIGOSSINA 0,125MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KDD",
      "display" : "DIGOSSINA 0,1MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "KDE",
      "display" : "DIGOSSINA 0,25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KDG",
      "display" : "DIGOSSINA 0,5MG/2ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KEA",
      "display" : "DIIDROCHINIDINA 150MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "KFA",
      "display" : "DIIDROCODEINA 10,25MG/ML 14,63ML USO ORALE"
    },
    {
      "code" : "KGA",
      "display" : "DIIDROCODEINA+ACIDO BENZOICO 100G USO ORALE"
    },
    {
      "code" : "14A",
      "display" : "DILTIAZEM 120MG 28 UNITA' USO ORALE RM"
    },
    {
      "code" : "14B",
      "display" : "DILTIAZEM 60MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "14C",
      "display" : "DILTIAZEM 120MG 24 UNITA' USO ORALE"
    },
    {
      "code" : "14E",
      "display" : "DILTIAZEM 180MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "14G",
      "display" : "DILTIAZEM 300MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "14I",
      "display" : "DILTIAZEM 200MG 36 UNITA' USO ORALE"
    },
    {
      "code" : "14J",
      "display" : "DILTIAZEM 50MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JAO",
      "display" : "DIMETILFUMARATO 120MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "JAP",
      "display" : "DIMETILFUMARATO 240MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KPX",
      "display" : "DIMETILFUMARATO 30MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "KPY",
      "display" : "DIMETILFUMARATO 120MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "KJA",
      "display" : "DISOPIRAMIDE 100MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "KJB",
      "display" : "DISOPIRAMIDE 250MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "KKA",
      "display" : "DISULFIRAM 200MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FSA",
      "display" : "DONEPEZIL 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FSB",
      "display" : "DONEPEZIL 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FCA",
      "display" : "DORZOLAMIDE 5ML 20MG/ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "F3A",
      "display" : "DORZOLAMIDE+TIMOLOLO 2%+0,5% 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "F3B",
      "display" : "DORZOLAMIDE+TIMOLOLO 2%+0,5% 5ML SOLUZIONE USO OFTALMICO SENZA CONSERVANTI"
    },
    {
      "code" : "F3C",
      "display" : "DORZOLAMIDE+TIMOLOLO 2%+0,5% 10ML SOLUZIONE USO OFTALMICO SENZA CONSERVANTI"
    },
    {
      "code" : "DBA",
      "display" : "DOXAZOSINA 2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "DBB",
      "display" : "DOXAZOSINA 4MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "KQO",
      "display" : "DOXAZOSINA 4MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LCM",
      "display" : "DOXAZOSINA 4MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "76D",
      "display" : "DOXICICLINA 100MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "KLA",
      "display" : "DOXOFILLINA 100MG/10ML 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KLB",
      "display" : "DOXOFILLINA 20MG/ML 200ML USO ORALE"
    },
    {
      "code" : "KLC",
      "display" : "DOXOFILLINA 400MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "KMA",
      "display" : "DRONEDARONE 400MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "BWV",
      "display" : "DULAGLUTIDE 0,75MG 0,5ML 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BYO",
      "display" : "DULAGLUTIDE 1,5MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KNA",
      "display" : "DULOXETINA 30MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KNB",
      "display" : "DULOXETINA 30MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "KNC",
      "display" : "DULOXETINA 60MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LRV",
      "display" : "DULOXETINA 90MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LRW",
      "display" : "DULOXETINA 120MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LFN",
      "display" : "DUPILUMAB 300MG 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LFO",
      "display" : "DUPILUMAB 200MG 1,14 ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KOA",
      "display" : "DUTASTERIDE 0,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KOB",
      "display" : "DUTASTERIDE 0,5MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "KPA",
      "display" : "EBASTINA 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JDS",
      "display" : "EDOXABAN 15MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "JDU",
      "display" : "EDOXABAN 30MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JDX",
      "display" : "EDOXABAN 60MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "IGI",
      "display" : "EFMOROCTOCOG 250UI 3ML 1 UNITA' - USO PARENTERALE"
    },
    {
      "code" : "IHT",
      "display" : "EFMOROCTOCOG 500UI 3ML 1 UNITA' - USO PARENTERALE"
    },
    {
      "code" : "IIH",
      "display" : "EFMOROCTOCOG 1.000UI 3ML 1 UNITA' - USO PARENTERALE"
    },
    {
      "code" : "IJF",
      "display" : "EFMOROTCOCOG 1.500UI 3 ML 1 UNITA' - USO PARENTERALE"
    },
    {
      "code" : "IKW",
      "display" : "EFMOROCTOCOG 2.000UI 3 ML 1 UNITA' - USO PARENTERALE"
    },
    {
      "code" : "ILU",
      "display" : "EFMOROCTOCOG 3.000UI 3 ML 1 UNITA' - USO PARENTERALE"
    },
    {
      "code" : "JFH",
      "display" : "EFTRENONACOG 1.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JFI",
      "display" : "EFTRENONACOG 2.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JFJ",
      "display" : "EFTRENONACOG 250UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JFK",
      "display" : "EFTRENONACOG 3.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JFL",
      "display" : "EFTRENONACOG 500UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JUN",
      "display" : "ELBASVIR+GRAZOPREVIR 50MG+100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KQA",
      "display" : "ELETRIPTAN 20MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "KQB",
      "display" : "ELETRIPTAN 40MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "KQC",
      "display" : "ELETRIPTAN 40MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "LHF",
      "display" : "ELEXACAFTOR+IVACAFTOR+TEZACAFTOR 100+75+50MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "MCU",
      "display" : "ELEXACAFTOR+IVACAFTOR+TEZACAFTOR 37,5+25+50MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "JHT",
      "display" : "ELIGLUSTAT 84MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KLD",
      "display" : "EMICIZUMAB 150MG/ML 0,4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KLE",
      "display" : "EMICIZUMAB 150MG/ML 0,7ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KLF",
      "display" : "EMICIZUMAB 150MG/ML 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KLG",
      "display" : "EMICIZUMAB 30MG/ML 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "CZI",
      "display" : "EMPAGLIFLOZIN 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "CZZ",
      "display" : "EMPAGLIFLOZIN 25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LAA",
      "display" : "EMPAGLIFLOZIN+LINAGLIPTIN 10+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LAB",
      "display" : "EMPAGLIFLOZIN+LINAGLIPTIN 25+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "EEH",
      "display" : "EMPAGLIFLOZIN+METFORMINA 5+850MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "EEI",
      "display" : "EMPAGLIFLOZIN+METFORMINA 5+1000MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "EEJ",
      "display" : "EMPAGLIFLOZIN+METFORMINA 12,5+850MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "EEY",
      "display" : "EMPAGLIFLOZIN+METFORMINA 12,5+1000MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "BAA",
      "display" : "ENALAPRIL 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "BAB",
      "display" : "ENALAPRIL 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KNR",
      "display" : "ENALAPRIL 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DMA",
      "display" : "ENALAPRIL+IDROCLOROTIAZIDE 20+12,5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "DMB",
      "display" : "ENALAPRIL+IDROCLOROTIAZIDE 20+6MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KOU",
      "display" : "ENALAPRIL+IDROCLOROTIAZIDE 20+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KRN",
      "display" : "ENALAPRIL+IDROCLOROTIAZIDE 20+6MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KAP",
      "display" : "ENALAPRIL+LERCANIDIPINA 20+20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KRA",
      "display" : "ENALAPRIL+LERCANIDIPINA 20+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KFU",
      "display" : "ENOXAPARINA 2.000UI 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KFV",
      "display" : "ENOXAPARINA 4.000UI 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KHR",
      "display" : "ENOXAPARINA 4.000UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KKQ",
      "display" : "ENOXAPARINA 2.000UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KSA",
      "display" : "ENOXAPARINA 10.000UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KSB",
      "display" : "ENOXAPARINA 10.000UI 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KSC",
      "display" : "ENOXAPARINA 2.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KSD",
      "display" : "ENOXAPARINA 4.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KSE",
      "display" : "ENOXAPARINA 6.000UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KSF",
      "display" : "ENOXAPARINA 6.000UI 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KSG",
      "display" : "ENOXAPARINA 8.000UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KSH",
      "display" : "ENOXAPARINA 8.000UI 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KTA",
      "display" : "ENTACAPONE 200MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "BRS",
      "display" : "ENTECAVIR 0,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "BRT",
      "display" : "ENTECAVIR 1MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "77A",
      "display" : "EPARINA CALCICA 5.000UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "77B",
      "display" : "EPARINA CALCICA 12.500UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "78A",
      "display" : "EPARINA SODICA 5.000UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "78C",
      "display" : "EPARINA SODICA 50.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ARI",
      "display" : "EPLERENONE 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "DKA",
      "display" : "EPLERENONE 25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "ANN",
      "display" : "EPOETINA ALFA 1.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANO",
      "display" : "EPOETINA ALFA 10.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANP",
      "display" : "EPOETINA ALFA 2.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANQ",
      "display" : "EPOETINA ALFA 3.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANR",
      "display" : "EPOETINA ALFA 4.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANS",
      "display" : "EPOETINA ALFA 5.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANU",
      "display" : "EPOETINA ALFA 6.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANV",
      "display" : "EPOETINA ALFA 8.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUA",
      "display" : "EPOETINA ALFA 10.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUB",
      "display" : "EPOETINA ALFA 1.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUC",
      "display" : "EPOETINA ALFA 20.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUD",
      "display" : "EPOETINA ALFA 2.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUE",
      "display" : "EPOETINA ALFA 30.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUF",
      "display" : "EPOETINA ALFA 3.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUG",
      "display" : "EPOETINA ALFA 40.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUH",
      "display" : "EPOETINA ALFA 4.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUI",
      "display" : "EPOETINA ALFA 5.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUJ",
      "display" : "EPOETINA ALFA 6.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KUK",
      "display" : "EPOETINA ALFA 8.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JZG",
      "display" : "EPOETINA BETA 2.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JZH",
      "display" : "EPOETINA BETA 3.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JZI",
      "display" : "EPOETINA BETA 5.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JZK",
      "display" : "EPOETINA BETA 4.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JZL",
      "display" : "EPOETINA BETA 6.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KVA",
      "display" : "EPOETINA BETA 10.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KVC",
      "display" : "EPOETINA BETA 30.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANW",
      "display" : "EPOETINA TETA 1.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANX",
      "display" : "EPOETINA TETA 2.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANY",
      "display" : "EPOETINA TETA 3.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANZ",
      "display" : "EPOETINA TETA 4.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AOB",
      "display" : "EPOETINA TETA 5.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KWA",
      "display" : "EPOETINA TETA 30.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KWB",
      "display" : "EPOETINA TETA 10.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KWC",
      "display" : "EPOETINA TETA 20.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AOC",
      "display" : "EPOETINA ZETA 1.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AOD",
      "display" : "EPOETINA ZETA 10.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AOE",
      "display" : "EPOETINA ZETA 2.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AOF",
      "display" : "EPOETINA ZETA 3.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AOG",
      "display" : "EPOETINA ZETA 4.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AOH",
      "display" : "EPOETINA ZETA 5.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AOI",
      "display" : "EPOETINA ZETA 6.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AOJ",
      "display" : "EPOETINA ZETA 8.000UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXA",
      "display" : "EPOETINA ZETA 3.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXB",
      "display" : "EPOETINA ZETA 4.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXC",
      "display" : "EPOETINA ZETA 10.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXD",
      "display" : "EPOETINA ZETA 1.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXE",
      "display" : "EPOETINA ZETA 20.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXF",
      "display" : "EPOETINA ZETA 2.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXG",
      "display" : "EPOETINA ZETA 30.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXH",
      "display" : "EPOETINA ZETA 40.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXI",
      "display" : "EPOETINA ZETA 5.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXJ",
      "display" : "EPOETINA ZETA 6.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXK",
      "display" : "EPOETINA ZETA 8.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KYA",
      "display" : "EPROSARTAN 600MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KZA",
      "display" : "EPROSARTAN+IDROCLOROTIAZIDE 600+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KPZ",
      "display" : "ERENUMAB 70MG 1ML SOLUZIONE USO PARENTERALE"
    },
    {
      "code" : "KYP",
      "display" : "ERENUMAB 140MG 1ML SOLUZIONE USO PARENTERALE"
    },
    {
      "code" : "80A",
      "display" : "ERITROMICINA 500MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KXW",
      "display" : "ERTUGLIFLOZIN 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KXX",
      "display" : "ERTUGLIFLOZIN 15MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "L2A",
      "display" : "ESCITALOPRAM 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "L2B",
      "display" : "ESCITALOPRAM 15ML 20MG/ML USO ORALE"
    },
    {
      "code" : "L2C",
      "display" : "ESCITALOPRAM 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "EIH",
      "display" : "ESLICARBAZEPINA 800MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CVA",
      "display" : "ESOMEPRAZOLO 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "CVB",
      "display" : "ESOMEPRAZOLO 40MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "CVC",
      "display" : "ESOMEPRAZOLO 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JDP",
      "display" : "ESOMEPRAZOLO 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JDQ",
      "display" : "ESOMEPRAZOLO 40MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "81D",
      "display" : "ESTRADIOLO 50MCG/DIE 4 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "81F",
      "display" : "ESTRADIOLO 25MCG/DIE 8 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "81H",
      "display" : "ESTRADIOLO 50MCG/DIE 8 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "81I",
      "display" : "ESTRADIOLO 25MCG/DIE 4 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "81P",
      "display" : "ESTRADIOLO 1G 28 UNITA' GEL USO TRANSDERMICO"
    },
    {
      "code" : "8A1",
      "display" : "ESTRADIOLO 7,5MCG/24H 1 UNITA' USO GINECOLOGICO"
    },
    {
      "code" : "L4A",
      "display" : "ESTRADIOLO+DIDROGESTERONE 1+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "L4B",
      "display" : "ESTRADIOLO+DIDROGESTERONE 1MG 14 UNITA' E 1+10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "L4C",
      "display" : "ESTRADIOLO+DIDROGESTERONE 2MG 14 UNITA' E 2+10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "L5A",
      "display" : "ESTRADIOLO+DROSPIRENONE 1+2MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "L6A",
      "display" : "ESTRADIOLO+LEVONORGESTREL 50+10MCG/DIE 4 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "L6B",
      "display" : "ESTRADIOLO+LEVONORGESTREL 50+7MCG/DIE 4 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "L7A",
      "display" : "ESTRADIOLO+NOMEGESTROLO 1,5 MG 10 UNITA' + 1,5 + 3,75 MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "L8A",
      "display" : "ESTRADIOLO+NORETISTERONE 1+0,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "L9A",
      "display" : "ESTRAMUSTINA 140MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "BCA",
      "display" : "ESTRIOLO 30G CREMA USO GINECOLOGICO"
    },
    {
      "code" : "BCB",
      "display" : "ESTRIOLO 1MG 20 UNITA' USO GINECOLOGICO"
    },
    {
      "code" : "82C",
      "display" : "ETAMBUTOLO 400MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "KBD",
      "display" : "ETELCALCETIDE 10MG/2ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KBF",
      "display" : "ETELCALCETIDE 2,5MG/0,5ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KBZ",
      "display" : "ETELCALCETIDE 5MG/1ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "66A",
      "display" : "CIPROTERONE+ETINILESTRADIOLO 2+0,035MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "LDA",
      "display" : "ETOPOSIDE 100MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "LDB",
      "display" : "ETOPOSIDE 50MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "SYA",
      "display" : "ETORICOXIB 120MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "SYB",
      "display" : "ETORICOXIB 60MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "SYC",
      "display" : "ETORICOXIB 90MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "KQV",
      "display" : "ETOSUCCIMIDE 250MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "KXT",
      "display" : "ETOSUCCIMIDE 250MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "LEA",
      "display" : "ETOSUCCIMIDE 200ML 250MG/5ML USO ORALE"
    },
    {
      "code" : "LFA",
      "display" : "EVEROLIMUS 0,25MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "LFB",
      "display" : "EVEROLIMUS 0,75MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "LFC",
      "display" : "EVEROLIMUS 2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LFD",
      "display" : "EVEROLIMUS 3MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "DZU",
      "display" : "EVOLOCUMAB 140MG 1ML 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KFT",
      "display" : "EVOLOCUMAB 140MG 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "FIA",
      "display" : "EXEMESTANE 25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LGA",
      "display" : "EXENATIDE 10MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LGB",
      "display" : "EXENATIDE 5MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LGC",
      "display" : "EXENATIDE 2MG 4 UNITA' USO PARENTERALE RP"
    },
    {
      "code" : "LCU",
      "display" : "EZETIMIBE 10MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "LHA",
      "display" : "EZETIMIBE 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KGQ",
      "display" : "EZETIMIBE+ATORVASTATINA 10+40MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LNM",
      "display" : "EZETIMIBE+ATORVASTATINA 10+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LNX",
      "display" : "EZETIMIBE+ATORVASTATINA 10+20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LSJ",
      "display" : "EZETIMIBE+ATORVASTATINA 10+80MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LIA",
      "display" : "EZETIMIBE+SIMVASTATINA 10+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LIB",
      "display" : "EZETIMIBE+SIMVASTATINA 10+20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LIC",
      "display" : "EZETIMIBE+SIMVASTATINA 10+40MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "E5A",
      "display" : "FAMCICLOVIR 250MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "E5B",
      "display" : "FAMCICLOVIR 500MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "E5C",
      "display" : "FAMCICLOVIR 125MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "COA",
      "display" : "FAMOTIDINA 40MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "LLN",
      "display" : "FAMOTIDINA 40MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "LJB",
      "display" : "FATTORE IX DI COAGULAZIONE UMANO LIOFILIZZATO 1.000UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LJC",
      "display" : "FATTORE IX DI COAGULAZIONE UMANO LIOFILIZZATO 1.200UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LJD",
      "display" : "FATTORE IX DI COAGULAZIONE UMANO LIOFILIZZATO 1.500UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LJF",
      "display" : "FATTORE IX DI COAGULAZIONE UMANO LIOFILIZZATO 500UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LKA",
      "display" : "FATTORE VII DI COAGULAZIONE UMANO LIOFILIZZATO 600UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LNA",
      "display" : "FATTORE VIII DI COAGULAZIONE UMANO LIOFILIZZATO 1.000UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LNC",
      "display" : "FATTORE VIII DI COAGULAZIONE UMANO LIOFILIZZATO 500UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LLA",
      "display" : "FATTORE VIII DI COAGULAZIONE UMANO DA FRAZIONAMENTO DEL PLASMA 1.000UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LLB",
      "display" : "FATTORE VIII DI COAGULAZIONE UMANO DA FRAZIONAMENTO DEL PLASMA 250UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LLC",
      "display" : "FATTORE VIII DI COAGULAZIONE UMANO DA FRAZIONAMENTO DEL PLASMA 500UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LNB",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 250UI+300UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LOH",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 500UI+600UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LOI",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 1000UI+1200UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LRB",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 1.500UI +1800UI 15ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JYZ",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 1.000UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LOA",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 1.500UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LOB",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 1.000UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LOC",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 1.000UI 15ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LOD",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 500UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LOG",
      "display" : "FATTORE VIII UMANO DI COAGULAZIONE+FATTORE DI VON WILLEBRAND 500UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LPA",
      "display" : "FEBUXOSTAT 120MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LPB",
      "display" : "FEBUXOSTAT 80MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LQB",
      "display" : "FELBAMATO 600MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "LQC",
      "display" : "FELBAMATO 120MG/ML 230ML USO ORALE"
    },
    {
      "code" : "EBA",
      "display" : "FELODIPINA 10MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "EBB",
      "display" : "FELODIPINA 5MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "LRA",
      "display" : "FELODIPINA+RAMIPRIL 5+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MCG",
      "display" : "FENFLURAMINA 60 ML 2,2 MG/ML USO ORALE"
    },
    {
      "code" : "MCH",
      "display" : "FENFLURAMINA 120 ML 2,2 MG/ML USO ORALE"
    },
    {
      "code" : "MCI",
      "display" : "FENFLURAMINA 360 ML 2,2 MG/ML USO ORALE"
    },
    {
      "code" : "LTA",
      "display" : "FENITOINA 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "D1A",
      "display" : "FENOBARBITAL 100MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "D1B",
      "display" : "FENOBARBITAL 15MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "D1C",
      "display" : "FENOBARBITAL 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "D1D",
      "display" : "FENOBARBITAL 200MG 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BDA",
      "display" : "FENOFIBRATO 200MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "BDB",
      "display" : "FENOFIBRATO 145MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "BDC",
      "display" : "FENOFIBRATO 100MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "LUA",
      "display" : "FENOTEROLO BROMIDRATO 100MCG 10ML 1 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "LVA",
      "display" : "FENOTEROLO+IPRATROPIO BROMURO 1,25+0,5MG 20 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "LVB",
      "display" : "FENOTEROLO+IPRATROPIO BROMURO 50+20MCG 200 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "CI0",
      "display" : "FENTANIL 600MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "CI1",
      "display" : "FENTANIL 600MCG 4 UNITA' USO ORALE"
    },
    {
      "code" : "CI2",
      "display" : "FENTANIL 600MCG 15 UNITA' USO ORALE"
    },
    {
      "code" : "CI4",
      "display" : "FENTANIL 800MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "CI5",
      "display" : "FENTANIL 800MCG 4 UNITA' USO ORALE"
    },
    {
      "code" : "CI6",
      "display" : "FENTANIL 800MCG 15 UNITA' USO ORALE"
    },
    {
      "code" : "CI8",
      "display" : "FENTANIL 50MCG 10 UNITA' SPRAY USO NASALE"
    },
    {
      "code" : "CI9",
      "display" : "FENTANIL 50MCG 20 UNITA' SPRAY USO NASALE"
    },
    {
      "code" : "CIA",
      "display" : "FENTANIL 25MCG/ORA 3 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "CIB",
      "display" : "FENTANIL 50MCG/ORA 3 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "CIC",
      "display" : "FENTANIL 75MCG/ORA 3 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "CID",
      "display" : "FENTANIL 100MCG/ORA 3 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "CIE",
      "display" : "FENTANIL 12MCG/ORA 3 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "CIF",
      "display" : "FENTANIL 100MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "CIG",
      "display" : "FENTANIL 100MCG 10 DOSI SPRAY USO NASALE"
    },
    {
      "code" : "CIH",
      "display" : "FENTANIL 100MCG 20 DOSI SPRAY USO NASALE"
    },
    {
      "code" : "CII",
      "display" : "FENTANIL 100MCG 4 UNITA' USO ORALE"
    },
    {
      "code" : "CIJ",
      "display" : "FENTANIL 100MCG/EROG SPRAY USO NASALE"
    },
    {
      "code" : "CIK",
      "display" : "FENTANIL 1.200MCG 15 UNITA' USO ORALE"
    },
    {
      "code" : "CIM",
      "display" : "FENTANIL 300MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "CIN",
      "display" : "FENTANIL 1.600MCG 15 UNITA' USO ORALE"
    },
    {
      "code" : "CIP",
      "display" : "FENTANIL 200MCG 10 DOSI SPRAY USO NASALE"
    },
    {
      "code" : "CIQ",
      "display" : "FENTANIL 200MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "CIR",
      "display" : "FENTANIL 200MCG 15 UNITA' USO ORALE"
    },
    {
      "code" : "CIS",
      "display" : "FENTANIL 200MCG 20 DOSI SPRAY USO NASALE"
    },
    {
      "code" : "CIU",
      "display" : "FENTANIL 200MCG 4 UNITA' USO ORALE"
    },
    {
      "code" : "CIV",
      "display" : "FENTANIL 400MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "CIW",
      "display" : "FENTANIL 400MCG 4 UNITA' USO ORALE"
    },
    {
      "code" : "CIX",
      "display" : "FENTANIL 400MCG/EROG SPRAY USO NASALE"
    },
    {
      "code" : "CIY",
      "display" : "FENTANIL 400MCG 15 UNITA' USO ORALE"
    },
    {
      "code" : "CLO",
      "display" : "FENTANIL 100MCG/EROG 4 UNITA' SPRAY USO NASALE"
    },
    {
      "code" : "CLP",
      "display" : "FENTANIL 400MCG/EROG 4 UNITA' SPRAY USO NASALE"
    },
    {
      "code" : "J00",
      "display" : "FENTANIL 67MCG 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "J01",
      "display" : "FENTANIL 133MCG 30 UNITA' USO SUBLINGUALE."
    },
    {
      "code" : "J02",
      "display" : "FENTANIL 267MCG 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "J03",
      "display" : "FENTANIL 400MCG 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "J04",
      "display" : "FENTANIL 533MCG 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "J05",
      "display" : "FENTANIL 800MCG 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "JBG",
      "display" : "FENTANIL 67MCG 4 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "JBH",
      "display" : "FENTANIL 133MCG 4 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "JBI",
      "display" : "FENTANIL 267MCG 4 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "LGH",
      "display" : "FENTANIL 100MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LGI",
      "display" : "FENTANIL 200MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LGJ",
      "display" : "FENTANIL 400MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LGK",
      "display" : "FENTANIL 600MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LGL",
      "display" : "FENTANIL 800MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MHC",
      "display" : "FENTANIL 100MCG 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "MHD",
      "display" : "FENTANIL 200MCG 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "MHE",
      "display" : "FENTANIL 300MCG 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "MHF",
      "display" : "FENTANIL 600MCG 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "MJB",
      "display" : "FENTANIL 100MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "MJC",
      "display" : "FENTANIL 200MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "MJD",
      "display" : "FENTANIL 300MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "MJE",
      "display" : "FENTANIL 400MCG 10 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "LYA",
      "display" : "FERRO POLIMALTOSATO 50MG/ML 30ML USO ORALE"
    },
    {
      "code" : "LXA",
      "display" : "FERROSO GLICINA SOLFATO 100MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "ARA",
      "display" : "FERROSO GLUCONATO 80MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "ARB",
      "display" : "FERROSO GLUCONATO 650MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LZA",
      "display" : "FERROSO SOLFATO 105MG 40 UNITA' USO ORALE RC"
    },
    {
      "code" : "LZB",
      "display" : "FERROSO SOLFATO 80MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "E1A",
      "display" : "FEXOFENADINA 120MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "E1B",
      "display" : "FEXOFENADINA 180MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "M0A",
      "display" : "FILGRASTIM 12.000.000UI 0,2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "M0B",
      "display" : "FILGRASTIM 30.000.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "M0C",
      "display" : "FILGRASTIM 48.000.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BEA",
      "display" : "FINASTERIDE 5MG 15 UNITA' USO ORALE"
    },
    {
      "code" : "KVL",
      "display" : "FINASTERIDE 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "BRU",
      "display" : "FINGOLIMOD 0,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LCP",
      "display" : "FINGOLIMOD 0,25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KAE",
      "display" : "FITOMENADIONE 10MG 5 UNITA' USO ORALE E PARENTERALE"
    },
    {
      "code" : "M1B",
      "display" : "FITOMENADIONE 2MG 5 UNITA' USO ORALE O PARENTERALE"
    },
    {
      "code" : "DHA",
      "display" : "FLECAINIDE 100MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "JDC",
      "display" : "FLECAINIDE 50MG 30 UNITA' RILASCIO PROLUNGATO USO ORALE"
    },
    {
      "code" : "JDD",
      "display" : "FLECAINIDE 100MG 30 UNITA' RILASCIO PROLUNGATO USO ORALE"
    },
    {
      "code" : "JDE",
      "display" : "FLECAINIDE 150MG 30 UNITA' RILASCIO PROLUNGATO USO ORALE"
    },
    {
      "code" : "JDF",
      "display" : "FLECAINIDE 200MG 30 UNITA' RILASCIO PROLUNGATO USO ORALE"
    },
    {
      "code" : "LFQ",
      "display" : "FLECAINIDE 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "M6A",
      "display" : "FLOROGLUCINOLO 40MG 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "86B",
      "display" : "FLUCLOXACILLINA 1.000MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "DCA",
      "display" : "FLUCONAZOLO 100MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "DCB",
      "display" : "FLUCONAZOLO 150MG 2 UNITA' USO ORALE"
    },
    {
      "code" : "DCC",
      "display" : "FLUCONAZOLO 200MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "DCD",
      "display" : "FLUCONAZOLO 10MG/ML 350MG USO ORALE"
    },
    {
      "code" : "TSA",
      "display" : "FLUDARABINA 10MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "87B",
      "display" : "FLUNISOLIDE 0,1% 30ML USO RESPIRATORIO"
    },
    {
      "code" : "87C",
      "display" : "FLUNISOLIDE 0,05% 2ML 15 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "87D",
      "display" : "FLUNISOLIDE 0,1% 2ML 15 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "87E",
      "display" : "FLUNISOLIDE 1MG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "87F",
      "display" : "FLUNISOLIDE 0,5MG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "16A",
      "display" : "FLUOCINOLONE ACETONIDE 0,025% 30G POMATA USO DERMATOLOGICO"
    },
    {
      "code" : "LLZ",
      "display" : "FLUOROURACILE 20G 40MG/G CREMA USO DERMATOLOGICO"
    },
    {
      "code" : "KNZ",
      "display" : "FLUOROURACILE+ACIDO SALICILICO 5MG/G+100MG/G SOLUZIONE USO ESTERNO"
    },
    {
      "code" : "35A",
      "display" : "FLUOXETINA 20MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "35B",
      "display" : "FLUOXETINA 0,4% 60ML USO ORALE"
    },
    {
      "code" : "35D",
      "display" : "FLUOXETINA 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "88B",
      "display" : "FLURBIPROFENE 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "88C",
      "display" : "FLURBIPROFENE 5MG/ML 160ML USO ORALE"
    },
    {
      "code" : "27B",
      "display" : "FLUTAMIDE 250MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "JUH",
      "display" : "FLUTICASONE 500MCG 20 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "JUI",
      "display" : "FLUTICASONE 2MG 20 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "M8A",
      "display" : "FLUTICASONE 125MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "M8B",
      "display" : "FLUTICASONE 0,005% 30G USO DERMATOLOGICO"
    },
    {
      "code" : "M8C",
      "display" : "FLUTICASONE 0,05% 30G USO DERMATOLOGICO"
    },
    {
      "code" : "M8D",
      "display" : "FLUTICASONE 100MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "M8F",
      "display" : "FLUTICASONE 250MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "M8G",
      "display" : "FLUTICASONE 250MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "M8H",
      "display" : "FLUTICASONE 500MCG 10 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "M8I",
      "display" : "FLUTICASONE 500MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "M8J",
      "display" : "FLUTICASONE 50MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "BQW",
      "display" : "FLUTICASONE+FORMOTEROLO 50+5MCG 120 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "BQX",
      "display" : "FLUTICASONE+FORMOTEROLO 125+5MCG 120 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "BQY",
      "display" : "FLUTICASONE+FORMOTEROLO 250+10MCG 120 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "TRH",
      "display" : "FLUTICASONE+VILANTEROLO 1x30DOSI 92+22MCG USO INALATORIO"
    },
    {
      "code" : "TRI",
      "display" : "FLUTICASONE+VILANTEROLO 1x30DOSI 184+22MCG USO INALATORIO"
    },
    {
      "code" : "E9A",
      "display" : "FLUVASTATINA 80MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "BFA",
      "display" : "FLUVOXAMINA 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "BFB",
      "display" : "FLUVOXAMINA 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "BTE",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 75UI 0,125ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KAL",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 75UI 0,125ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KAM",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 150UI 0,25ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KAN",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 225UI 0,375ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KAO",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 300UI 0,5ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KAQ",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 450UI 0,75ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KOJ",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 300UI 0,5ML MONODOSE 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KOK",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 450UI 0,75ML MONODOSE 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "M9A",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 1.050UI/1,75ML 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "M9B",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 300UI MULTIDOSE 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "M9C",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 450UI MULTIDOSE 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "M9D",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 75UI 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "M9E",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 75UI 1ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "M9F",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 900UI MULTIDOSE 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MAC",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 150UI 0,25ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MAD",
      "display" : "FOLLITROPINA ALFA DA DNA RICOMBINANTE 225UI 0,375ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LDS",
      "display" : "FOLLITROPINA ALFA+LUTROPINA ALFA 300+150UI 0,48ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LDT",
      "display" : "FOLLITROPINA ALFA+LUTROPINA ALFA 400+225UI 0,72ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LDU",
      "display" : "FOLLITROPINA ALFA+LUTROPINA ALFA 900+450UI 1,44ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MAA",
      "display" : "FOLLITROPINA ALFA+LUTROPINA ALFA 150+75UI 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MAB",
      "display" : "FOLLITROPINA ALFA+LUTROPINA ALFA 150+75UI 1ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MBB",
      "display" : "FOLLITROPINA BETA 300UI 0,36ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MBD",
      "display" : "FOLLITROPINA BETA 600UI 0,72ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MBE",
      "display" : "FOLLITROPINA BETA 900UI 1,08ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KNI",
      "display" : "FOLLITROPINA DELTA 12 MCG 0,36 ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KNJ",
      "display" : "FOLLITROPINA DELTA 36 MCG 1,08 ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KNK",
      "display" : "FOLLITROPINA DELTA 72 MCG 2,16 ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MCA",
      "display" : "FONDAPARINUX 1,5MG 0,3ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MCB",
      "display" : "FONDAPARINUX 10MG 0,8ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MCC",
      "display" : "FONDAPARINUX 2,5MG 0,5ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MCD",
      "display" : "FONDAPARINUX 5MG 0,4ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MCE",
      "display" : "FONDAPARINUX 7,5MG 0,6ML 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "CR8",
      "display" : "FORMOTEROLO 12MCG 100 DOSI USO RESPIRATORIO SOLUZIONE"
    },
    {
      "code" : "CR9",
      "display" : "FORMOTEROLO 12MCG 100 UNITA' USO RESPIRATORIO POLVERE"
    },
    {
      "code" : "CRA",
      "display" : "FORMOTEROLO 12MCG 60 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "CRC",
      "display" : "FORMOTEROLO 4,5MCG 60 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "LTF",
      "display" : "FORMOTEROLO+GLICOPIRRONIO+BUDESONIDE 5+7,2+160MCG 120 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "EKA",
      "display" : "FOSFOMICINA 3.000MG 2 UNITA' USO ORALE"
    },
    {
      "code" : "EEA",
      "display" : "FOSINOPRIL 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "EEB",
      "display" : "FOSINOPRIL 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "E0A",
      "display" : "FOSINOPRIL+IDROCLOROTIAZIDE 20+12,5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "LBU",
      "display" : "FREMANEZUMAB 225MG 1,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LDW",
      "display" : "FREMANEZUMAB 225MG 1,5ML 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MDA",
      "display" : "FROVATRIPTAN 2,5MG 2 UNITA' USO ORALE"
    },
    {
      "code" : "MDB",
      "display" : "FROVATRIPTAN 2,5MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "89A",
      "display" : "FUROSEMIDE 20MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "89B",
      "display" : "FUROSEMIDE 250MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "89C",
      "display" : "FUROSEMIDE 500MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "89D",
      "display" : "FUROSEMIDE 25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "89E",
      "display" : "FUROSEMIDE 10MG/ML 100ML USO ORALE"
    },
    {
      "code" : "LBS",
      "display" : "FUROSEMIDE 25MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "MEA",
      "display" : "FUROSEMIDE+SPIRONOLATTONE 25+37MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "MEB",
      "display" : "FUROSEMIDE+SPIRONOLATTONE 50+20MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "MEC",
      "display" : "FUROSEMIDE+SPIRONOLATTONE 50+20MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "MFA",
      "display" : "FUROSEMIDE+TRIAMTERENE 40+25MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "C1A",
      "display" : "GABAPENTIN 400MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "C1B",
      "display" : "GABAPENTIN 100MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "C1C",
      "display" : "GABAPENTIN 300MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "G1A",
      "display" : "GALANTAMINA 8MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "G1B",
      "display" : "GALANTAMINA 16MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "G1C",
      "display" : "GALANTAMINA 24MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "KVK",
      "display" : "GALCANEZUMAB 120MG 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "15A",
      "display" : "GEMFIBROZIL 900MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "15B",
      "display" : "GEMFIBROZIL 600MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "TUA",
      "display" : "GLATIRAMER 20MG 28 UNITA' USO PARENTERALE"
    },
    {
      "code" : "TUB",
      "display" : "GLATIRAMER 40MG 12 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KCT",
      "display" : "GLECAPREVIR+PIBRENTASVIR 100MG+40MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "MHA",
      "display" : "GLIBENCLAMIDE 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KKR",
      "display" : "GLICEROLO FENILBUTIRRATO 27,5G 25ML FLACONE+ADATTATORE USO ORALE"
    },
    {
      "code" : "92A",
      "display" : "GLICLAZIDE 80MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "92B",
      "display" : "GLICLAZIDE 30MG 60 UNITA' USO ORALE RM"
    },
    {
      "code" : "92C",
      "display" : "GLICLAZIDE 60MG 30 UNITA' USO ORALE RM"
    },
    {
      "code" : "TXA",
      "display" : "GLICOPIRRONIO BROMURO 44MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "LNO",
      "display" : "GLICOPIRRONIO+FORMOTEROLO 7,2+5MCCG 1 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "CMA",
      "display" : "GLIMEPIRIDE 2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CMB",
      "display" : "GLIMEPIRIDE 3MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CMC",
      "display" : "GLIMEPIRIDE 4MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MIA",
      "display" : "GLIPIZIDE 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MJA",
      "display" : "GLIQUIDONE 30MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "LDM",
      "display" : "GLUCAGONE 3 MG 1 UNITA' USO NASALE"
    },
    {
      "code" : "MKA",
      "display" : "GLUCAGONE 1MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "93A",
      "display" : "GLUCOSIO 5% 10ML USO PARENTERALE"
    },
    {
      "code" : "93B",
      "display" : "GLUCOSIO 5% 20ML USO PARENTERALE"
    },
    {
      "code" : "93D",
      "display" : "GLUCOSIO 5% 250ML USO PARENTERALE"
    },
    {
      "code" : "93E",
      "display" : "GLUCOSIO 5% 500ML USO PARENTERALE"
    },
    {
      "code" : "93F",
      "display" : "GLUCOSIO 10% 10ML USO PARENTERALE"
    },
    {
      "code" : "93G",
      "display" : "GLUCOSIO 10% 20ML USO PARENTERALE"
    },
    {
      "code" : "93H",
      "display" : "GLUCOSIO 10% 250ML USO PARENTERALE"
    },
    {
      "code" : "93I",
      "display" : "GLUCOSIO 10% 500ML USO PARENTERALE"
    },
    {
      "code" : "93J",
      "display" : "GLUCOSIO 20% 10ML USO PARENTERALE"
    },
    {
      "code" : "93K",
      "display" : "GLUCOSIO 33% 5ML USO PARENTERALE"
    },
    {
      "code" : "93L",
      "display" : "GLUCOSIO 33% 10ML USO PARENTERALE"
    },
    {
      "code" : "MLA",
      "display" : "GONADORELINA 0,2MG/EROGAZIONE 100 EROG 2 UNITA' USO NASALE"
    },
    {
      "code" : "MNA",
      "display" : "GOSERELIN 10,8MG 1 UNITA' USO PARENTERALE RP"
    },
    {
      "code" : "MNB",
      "display" : "GOSERELIN 3,6MG 1 UNITA' USO PARENTERALE RP"
    },
    {
      "code" : "BZX",
      "display" : "GRANISETRONE 3,1MG 1 UNITA' USO TRANSDERMICO"
    },
    {
      "code" : "EFA",
      "display" : "GRANISETRONE 1MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "EFB",
      "display" : "GRANISETRONE 2MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "EFC",
      "display" : "GRANISETRONE 3MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "94A",
      "display" : "GRISEOFULVINA 125MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "94C",
      "display" : "GRISEOFULVINA 500MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "95A",
      "display" : "IBUPROFENE 400MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "95B",
      "display" : "IBUPROFENE 600MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "95C",
      "display" : "IBUPROFENE 800MG 20 UNITA' USO ORALE RP"
    },
    {
      "code" : "95D",
      "display" : "IBUPROFENE 400MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "95E",
      "display" : "IBUPROFENE 500MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KJU",
      "display" : "IBUPROFENE+CODEINA 400MG+30MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FRN",
      "display" : "IDEBENONE 150MG 180 UNITA' USO ORALE"
    },
    {
      "code" : "96A",
      "display" : "IDROCLOROTIAZIDE 25MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "KZQ",
      "display" : "IDROCORTISONE 2MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "KZR",
      "display" : "IDROCORTISONE 1MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "KZS",
      "display" : "IDROCORTISONE 0,5MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "MQD",
      "display" : "IDROCORTISONE 1G 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MRA",
      "display" : "IDROMORFONE 16MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "MRB",
      "display" : "IDROMORFONE 32MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "MRC",
      "display" : "IDROMORFONE 4MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "MRD",
      "display" : "IDROMORFONE 64MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "MRE",
      "display" : "IDROMORFONE 8MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "MUA",
      "display" : "IDROSSICLOROCHINA 200MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MSB",
      "display" : "IDROSSIPROGESTERONE 341MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MTA",
      "display" : "IDROXICARBAMIDE 500MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "MVA",
      "display" : "IDROXOCOBALAMINA 1.000MCG 6 UNITA' USO ORALE O PARENTERALE"
    },
    {
      "code" : "BRV",
      "display" : "ILOPROST 20MCG 2ML 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "BRY",
      "display" : "ILOPROST 20MCG 2ML 90 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "JNS",
      "display" : "ILOPROST 20MCG 1ML 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "KVS",
      "display" : "ILOPROST 10MCG 1ML 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "BRZ",
      "display" : "IMATINIB 100MG 120 UNITA' USO ORALE"
    },
    {
      "code" : "JNJ",
      "display" : "IMATINIB 400MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JTD",
      "display" : "IMIQUIMOD 3,75% 250MG 28 UNITA' USO DERMATOLOGICO"
    },
    {
      "code" : "MWA",
      "display" : "IMIQUIMOD 5% 250MG 12 UNITA' CREMA USO DERMATOLOGICO"
    },
    {
      "code" : "MZB",
      "display" : "IMMUNOGLOBULINA UMANA ANTI-D 300MCG (1500UI) 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MZC",
      "display" : "IMMUNOGLOBULINA UMANA ANTI-D 625UI 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MZD",
      "display" : "IMMUNOGLOBULINA UMANA ANTI-D 625UI 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MXA",
      "display" : "IMMUNOGLOBULINA UMANA ANTIEPATITE B 1.000UI 3ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MXB",
      "display" : "IMMUNOGLOBULINA UMANA ANTIEPATITE B 1.000UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MXC",
      "display" : "IMMUNOGLOBULINA UMANA ANTIEPATITE B 180UI 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MXD",
      "display" : "IMMUNOGLOBULINA UMANA ANTIEPATITE B 500UI 1ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MXE",
      "display" : "IMMUNOGLOBULINA UMANA ANTIEPATITE B 540UI 3ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MXF",
      "display" : "IMMUNOGLOBULINA UMANA ANTIEPATITE B 600UI 3ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MYA",
      "display" : "IMMUNOGLOBULINA UMANA ANTITETANICA 250UI 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MYC",
      "display" : "IMMUNOGLOBULINA UMANA ANTITETANICA 500UI 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LSO",
      "display" : "INCLISIRAN 284MG 1,5ML SOLUZIONE USO PARENTERALE"
    },
    {
      "code" : "N0A",
      "display" : "INDACATEROLO 150MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "N0B",
      "display" : "INDACATEROLO 300MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "GYF",
      "display" : "INDACATEROLO+GLICOPIRRONIO 85+43MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "LKN",
      "display" : "INDACATEROLO+GLICOPIRRONIO+MOMETASONE 114+46+136MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "LQX",
      "display" : "INDACATEROLO+MOMETASONE 125+62,5MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "LRQ",
      "display" : "INDACATEROLO+MOMETASONE 125+127,5MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "LRR",
      "display" : "INDACATEROLO+MOMETASONE 125+260MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "06A",
      "display" : "INDAPAMIDE 2,5MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "06B",
      "display" : "INDAPAMIDE 2,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "06C",
      "display" : "INDAPAMIDE 1,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "N1A",
      "display" : "INDOMETACINA 25MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "N1B",
      "display" : "INDOMETACINA 50MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "N1C",
      "display" : "INDOMETACINA 50MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KLM",
      "display" : "INSULINA ASPART FASTER 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N2A",
      "display" : "INSULINA ASPART 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N2B",
      "display" : "INSULINA ASPART SOLUBILE+INSULINA ASPART PROTAMINO CRISTALLIZZATA 30/70 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N2C",
      "display" : "INSULINA ASPART SOLUBILE+INSULINA ASPART PROTAMINO CRISTALLIZZATA 50/50 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N2D",
      "display" : "INSULINA ASPART SOLUBILE+INSULINA ASPART PROTAMINO CRISTALLIZZATA 70/30 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N3B",
      "display" : "INSULINA DEGLUDEC 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KDX",
      "display" : "INSULINA DEGLUDEC + LIRAGLUTIDE 100U/ML + 3,6MG/ML 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N3A",
      "display" : "INSULINA DETEMIR 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N4A",
      "display" : "INSULINA GLARGINE 1.000U 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N4B",
      "display" : "INSULINA GLARGINE 100U/ML 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NA1",
      "display" : "INSULINA GLARGINE 300U/ML 1,5ML 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KHY",
      "display" : "INSULINA GLARGINE+LIXISENATIDE 100U/ML+33MCG 3ML 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KHZ",
      "display" : "INSULINA GLARGINE+LIXISENATIDE 100U/ML+50MCG/ML 3ML 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N5A",
      "display" : "INSULINA GLULISINA 1.000U 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N5B",
      "display" : "INSULINA GLULISINA 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N7A",
      "display" : "INSULINA LISPRO DA DNA RICOMBINANTE+INSULINA LISPRO PROTAMINA 25 1.000U 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N7B",
      "display" : "INSULINA LISPRO DA DNA RICOMBINANTE+INSULINA LISPRO PROTAMINA 25 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N7C",
      "display" : "INSULINA LISPRO DA DNA RICOMBINANTE+INSULINA LISPRO PROTAMINA 50 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HZI",
      "display" : "INSULINA LISPRO DA DNA RICOMBINANTE 200U/ML 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KNH",
      "display" : "INSULINA LISPRO DA DNA RICOMBINANTE 300U 3ML 5 UNITA' 0,5-30U USO PARENTERALE"
    },
    {
      "code" : "N6A",
      "display" : "INSULINA LISPRO DA DNA RICOMBINANTE 1.000U 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N6B",
      "display" : "INSULINA LISPRO DA DNA RICOMBINANTE 300U 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N9A",
      "display" : "INSULINA UMANA DA DNA RICOMBINANTE 1.000UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "N9B",
      "display" : "INSULINA UMANA DA DNA RICOMBINANTE 300UI 3ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NAA",
      "display" : "INSULINA UMANA DNA RICOMB+INSULINA UMANA ISOFANO DNA RICOMB 30/70 1.000UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NBA",
      "display" : "INSULINA UMANA ISOFANO DA DNA RICOMBINANTE 1.000UI 10ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NGA",
      "display" : "INTERFERONE BETA 1A 22MCG 12 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NGB",
      "display" : "INTERFERONE BETA 1A 66MCG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NGC",
      "display" : "INTERFERONE BETA 1A 30MCG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NGD",
      "display" : "INTERFERONE BETA 1A 44MCG 12 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NGE",
      "display" : "INTERFERONE BETA 1A 132MCG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NGF",
      "display" : "INTERFERONE BETA 1A 8,8MCG 6 UNITA' + 22MCG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NHA",
      "display" : "INTERFERONE BETA 1B 250MCG/ML 15 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NIA",
      "display" : "IPRATROPIO BROMURO 0,025% 2ML 10 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "NJA",
      "display" : "IRBESARTAN 150MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "NJB",
      "display" : "IRBESARTAN 300MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LWL",
      "display" : "IRBESARTAN+AMLODIPINA 150+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LWM",
      "display" : "IRBESARTAN+AMLODIPINA 150+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LWN",
      "display" : "IRBESARTAN+AMLODIPINA 300+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LWQ",
      "display" : "IRBESARTAN+AMLODIPINA 300+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "NKA",
      "display" : "IRBESARTAN+IDROCLOROTIAZIDE 150+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "NKB",
      "display" : "IRBESARTAN+IDROCLOROTIAZIDE 300+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "NKC",
      "display" : "IRBESARTAN+IDROCLOROTIAZIDE 300+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "GXY",
      "display" : "ISAVUCONAZOLO 100MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "98B",
      "display" : "ISONIAZIDE 200MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "98C",
      "display" : "ISONIAZIDE 500MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NLA",
      "display" : "ISONIAZIDE+PIRAZINAMIDE+RIFAMPICINA 50+300+120MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "NMB",
      "display" : "ISOSORBIDE DINITRATO 40MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "NMC",
      "display" : "ISOSORBIDE DINITRATO 5MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "05A",
      "display" : "ISOSORBIDE MONONITRATO 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "05C",
      "display" : "ISOSORBIDE MONONITRATO 20MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "05D",
      "display" : "ISOSORBIDE MONONITRATO 40MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "05E",
      "display" : "ISOSORBIDE MONONITRATO 60MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "05H",
      "display" : "ISOSORBIDE MONONITRATO 80MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "C3A",
      "display" : "ISOTRETINOINA 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "C3B",
      "display" : "ISOTRETINOINA 20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KOQ",
      "display" : "ISOTRETINOINA 30MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "NNA",
      "display" : "ISRADIPINA 5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "CBA",
      "display" : "ITRACONAZOLO 100MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "CBB",
      "display" : "ITRACONAZOLO 150ML 10MG/ML USO ORALE"
    },
    {
      "code" : "KPV",
      "display" : "ITRACONAZOLO 50MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "KIP",
      "display" : "IVABRADINA 2,5MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "NPA",
      "display" : "IVABRADINA 5MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "NPB",
      "display" : "IVABRADINA 7,5MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "IDX",
      "display" : "IVACAFTOR 150MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KIS",
      "display" : "IVACAFTOR 75MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KIT",
      "display" : "IVACAFTOR 50MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KRP",
      "display" : "IVACAFTOR 150MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MCV",
      "display" : "IVACAFTOR 75MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KRO",
      "display" : "IVACAFTOR+TEZACAFTOR 150 MG + 100 MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FTQ",
      "display" : "KETOKONAZOLO 200MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "31A",
      "display" : "KETOPROFENE 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "31B",
      "display" : "KETOPROFENE 100MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "31C",
      "display" : "KETOPROFENE 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "31D",
      "display" : "KETOPROFENE 200MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "31E",
      "display" : "KETOPROFENE 200MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "31F",
      "display" : "KETOPROFENE 80MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "31G",
      "display" : "KETOPROFENE 320MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "31Z",
      "display" : "KETOPROFENE 160MG 2ML 6 UNITA' USO PARENTERALE IM IV"
    },
    {
      "code" : "BHA",
      "display" : "KETOROLAC 30MG 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LKQ",
      "display" : "KETOROLAC 30MG/ML 1 ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AUA",
      "display" : "KETOTIFENE 2MG 15 UNITA' USO ORALE"
    },
    {
      "code" : "AUB",
      "display" : "KETOTIFENE 0,2MG/ML 200ML USO ORALE"
    },
    {
      "code" : "AUC",
      "display" : "KETOTIFENE 2MG/ML 20ML USO ORALE"
    },
    {
      "code" : "NQA",
      "display" : "LABETALOLO 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "NQB",
      "display" : "LABETALOLO 200MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FMA",
      "display" : "LACIDIPINA 4MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FMB",
      "display" : "LACIDIPINA 6MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "MBL",
      "display" : "LACOSAMIDE 10MG/ML 200ML - USO ORALE"
    },
    {
      "code" : "NRA",
      "display" : "LACOSAMIDE 100MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "NRB",
      "display" : "LACOSAMIDE 100MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "NRC",
      "display" : "LACOSAMIDE 150MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "NRD",
      "display" : "LACOSAMIDE 150MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "NRE",
      "display" : "LACOSAMIDE 200MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "NRF",
      "display" : "LACOSAMIDE 50MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "NRG",
      "display" : "LACOSAMIDE 50MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "F0A",
      "display" : "LAMIVUDINA 100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "F0B",
      "display" : "LAMIVUDINA 5MG/ML 240ML USO ORALE"
    },
    {
      "code" : "CLA",
      "display" : "LAMOTRIGINA 25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "CLB",
      "display" : "LAMOTRIGINA 50MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "CLC",
      "display" : "LAMOTRIGINA 100MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "CLD",
      "display" : "LAMOTRIGINA 200MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "HQJ",
      "display" : "LAMOTRIGINA 2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LAK",
      "display" : "LAMOTRIGINA 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LDR",
      "display" : "LANADELUMAB 300MG 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NSA",
      "display" : "LANREOTIDE 120MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NSC",
      "display" : "LANREOTIDE 60MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NSD",
      "display" : "LANREOTIDE 90MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "CDA",
      "display" : "LANSOPRAZOLO 15MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "CDB",
      "display" : "LANSOPRAZOLO 30MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KBT",
      "display" : "LANSOPRAZOLO 15MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KBU",
      "display" : "LANSOPRAZOLO 30MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "NTA",
      "display" : "LANTANIO 1.000MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "NTB",
      "display" : "LANTANIO 500MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "NTC",
      "display" : "LANTANIO 750MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "EXA",
      "display" : "LATANOPROST 50MCG/ML 2,5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "EXB",
      "display" : "LATANOPROST 50MCG/ML 0,2ML 30 UNITA' SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "LZO",
      "display" : "LATANOPROST 50MCG/ML 6ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "FYA",
      "display" : "LATANOPROST+TIMOLOLO 50MCG/ML+5MG/ML 2,5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "GYI",
      "display" : "LATANOPROST+TIMOLOLO 0,005+0,5% 30 UNITA' USO OFTALMICO"
    },
    {
      "code" : "NUA",
      "display" : "LATTITOLO 200G USO ORALE EPS"
    },
    {
      "code" : "NUB",
      "display" : "LATTITOLO 66,67% 500ML USO ORALE EPS"
    },
    {
      "code" : "BIA",
      "display" : "LATTULOSIO 66,7% 180ML USO ORALE EPS"
    },
    {
      "code" : "BIB",
      "display" : "LATTULOSIO 66,7% 200ML USO ORALE EPS"
    },
    {
      "code" : "BID",
      "display" : "LATTULOSIO 65% 400ML USO ORALE EPS"
    },
    {
      "code" : "LWI",
      "display" : "LATTULOSIO 65% 200ML USO ORALE EPS"
    },
    {
      "code" : "FRA",
      "display" : "LEFLUNOMIDE 20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FRB",
      "display" : "LEFLUNOMIDE 100MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "NVA",
      "display" : "LENOGRASTIM 33.600.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "EPA",
      "display" : "LERCANIDIPINA 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "EPB",
      "display" : "LERCANIDIPINA 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KNN",
      "display" : "LETERMOVIR 240MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KNO",
      "display" : "LETERMOVIR 480MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FLA",
      "display" : "LETROZOLO 2,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JZP",
      "display" : "LEUPRORELINA 22,5MG 1 UNITA' USO PARENTERALE RP - INTRAMUSCOLARE"
    },
    {
      "code" : "NWA",
      "display" : "LEUPRORELINA 11,25MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NWB",
      "display" : "LEUPRORELINA 22,5MG 1 UNITA' USO PARENTERALE RP - SOTTOCUTANEO"
    },
    {
      "code" : "NWC",
      "display" : "LEUPRORELINA 3,6MG IMPIANTO USO PARENTERALE"
    },
    {
      "code" : "NWD",
      "display" : "LEUPRORELINA 3,75MG 1 UNITA' USO PARENTERALE RP - INTRAMUSCOLO E SOTTOCUTANEO"
    },
    {
      "code" : "NWE",
      "display" : "LEUPRORELINA 5MG IMPIANTO USO PARENTERALE"
    },
    {
      "code" : "NWF",
      "display" : "LEUPRORELINA 7,5MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NWG",
      "display" : "LEUPRORELINA 45MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NWH",
      "display" : "LEUPRORELINA 3,75MG 1 UNITA' USO PARENTERALE RP - INTRAMUSCOLO"
    },
    {
      "code" : "G3A",
      "display" : "LEVETIRACETAM 1.000MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "G3B",
      "display" : "LEVETIRACETAM 500MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "G3C",
      "display" : "LEVETIRACETAM 100MG/ML 300ML USO ORALE"
    },
    {
      "code" : "G3D",
      "display" : "LEVETIRACETAM 100MG/ML 150ML CON SIRINGA 3ML USO ORALE"
    },
    {
      "code" : "G3E",
      "display" : "LEVETIRACETAM 100MG/ML 150ML CON SIRINGA 1ML USO ORALE"
    },
    {
      "code" : "G3F",
      "display" : "LEVETIRACETAM 250MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "GAW",
      "display" : "LEVETIRACETAM 750MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LBT",
      "display" : "LEVETIRACETAM 1.500MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "NXB",
      "display" : "LEVOBUNOLOLO 0,5% 0,4ML 60 UNITA' SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "BJA",
      "display" : "LEVOCARNITINA 2.000MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "ESA",
      "display" : "LEVOCETIRIZINA 5MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "ESB",
      "display" : "LEVOCETIRIZINA 5MG/ML 20ML USO ORALE"
    },
    {
      "code" : "FBA",
      "display" : "LEVODOPA+BENSERAZIDE 200+50MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "FBB",
      "display" : "LEVODOPA+BENSERAZIDE 100+25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FBC",
      "display" : "LEVODOPA+BENSERAZIDE 100+25MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "34A",
      "display" : "LEVODOPA+CARBIDOPA 250+25MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "34B",
      "display" : "LEVODOPA+CARBIDOPA 100+25MG 50 UNITA' USO ORALE RP"
    },
    {
      "code" : "34C",
      "display" : "LEVODOPA+CARBIDOPA 200+50MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "34D",
      "display" : "LEVODOPA+CARBIDOPA 100+25MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "NYA",
      "display" : "LEVODOPA+CARBIDOPA+ENTACAPONE 100+25+200MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "NYB",
      "display" : "LEVODOPA+CARBIDOPA+ENTACAPONE 125+31,25+200MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "NYC",
      "display" : "LEVODOPA+CARBIDOPA+ENTACAPONE 150+37,5+200MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "NYD",
      "display" : "LEVODOPA+CARBIDOPA+ENTACAPONE 200+50+200MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "NYE",
      "display" : "LEVODOPA+CARBIDOPA+ENTACAPONE 50+12,5+200MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "NYF",
      "display" : "LEVODOPA+CARBIDOPA+ENTACAPONE 75+18,75+200MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "NZA",
      "display" : "LEVODROPROPIZINA 6% 30ML USO ORALE"
    },
    {
      "code" : "NZB",
      "display" : "LEVODROPROPIZINA 0,6% 200ML USO ORALE"
    },
    {
      "code" : "FGA",
      "display" : "LEVOFLOXACINA 250MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "FGB",
      "display" : "LEVOFLOXACINA 500MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "KZB",
      "display" : "LEVOFLOXACINA 500MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "O0A",
      "display" : "LEVOMEPROMAZINA 100MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "O0B",
      "display" : "LEVOMEPROMAZINA 25MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "O1A",
      "display" : "LEVOSULPIRIDE 25MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "O1B",
      "display" : "LEVOSULPIRIDE 50MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BKA",
      "display" : "LEVOTIROXINA 100MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "BKB",
      "display" : "LEVOTIROXINA 25MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "BKC",
      "display" : "LEVOTIROXINA 50MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "BKD",
      "display" : "LEVOTIROXINA 75MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "BKE",
      "display" : "LEVOTIROXINA 125MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "BKF",
      "display" : "LEVOTIROXINA 150MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "BKG",
      "display" : "LEVOTIROXINA 175MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "BKH",
      "display" : "LEVOTIROXINA 200MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "BKI",
      "display" : "LEVOTIROXINA 25MCG/ML 1ML 30 UNITA' USO ORALE (ETANOLO)"
    },
    {
      "code" : "BKJ",
      "display" : "LEVOTIROXINA 50MCG/ML 1ML 30 UNITA' USO ORALE (ETANOLO)"
    },
    {
      "code" : "BKK",
      "display" : "LEVOTIROXINA 75MCG/ML 1ML 30 UNITA' USO ORALE"
    },
    {
      "code" : "BKL",
      "display" : "LEVOTIROXINA 100MCG/ML 1ML 30 UNITA' USO ORALE (ETANOLO)"
    },
    {
      "code" : "BKM",
      "display" : "LEVOTIROXINA 100MCG/ML 20ML USO ORALE"
    },
    {
      "code" : "KWW",
      "display" : "LEVOTIROXINA 100MCG/5ML 75ML 2 UNITA' USO ORALE"
    },
    {
      "code" : "LKB",
      "display" : "LEVOTIROXINA 88MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "LKC",
      "display" : "LEVOTIROXINA 112MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "LKD",
      "display" : "LEVOTIROXINA 137MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "LPH",
      "display" : "LEVOTIROXINA 13MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPI",
      "display" : "LEVOTIROXINA 88MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPJ",
      "display" : "LEVOTIROXINA 112MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPK",
      "display" : "LEVOTIROXINA 125MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPL",
      "display" : "LEVOTIROXINA 137MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPM",
      "display" : "LEVOTIROXINA 150MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPN",
      "display" : "LEVOTIROXINA 175MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPO",
      "display" : "LEVOTIROXINA 200MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPS",
      "display" : "LEVOTIROXINA 25MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPT",
      "display" : "LEVOTIROXINA 50MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPU",
      "display" : "LEVOTIROXINA 75MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "LPV",
      "display" : "LEVOTIROXINA 100MCG/ML 1ML 30 UNITA' USO ORALE (GLICEROLO)"
    },
    {
      "code" : "TZA",
      "display" : "LIDOCAINA 700MG 10 UNITA' USO TOPICO"
    },
    {
      "code" : "TZB",
      "display" : "LIDOCAINA 700MG 30 UNITA' USO TOPICO"
    },
    {
      "code" : "SLA",
      "display" : "LIMECICLINA 408MG (300MG TETRACICLINA) 28 UNITA' USO ORALE"
    },
    {
      "code" : "IWG",
      "display" : "LINAGLIPTIN 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "O2A",
      "display" : "LINCOMICINA 500MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "O2B",
      "display" : "LINCOMICINA 600MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BSC",
      "display" : "LINEZOLID 100MG/5ML 1 UNITA' USO ORALE"
    },
    {
      "code" : "BSD",
      "display" : "LINEZOLID 600MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "O3A",
      "display" : "LIOTIRONINA 20MCG/ML 20ML USO ORALE"
    },
    {
      "code" : "O3C",
      "display" : "LIOTIRONINA 10MCG/ML 30UNITA' USO ORALE"
    },
    {
      "code" : "O3D",
      "display" : "LIOTIRONINA 15MCG/ML 30UNITA' USO ORALE"
    },
    {
      "code" : "O3E",
      "display" : "LIOTIRONINA 20MCG/ML 30UNITA' USO ORALE"
    },
    {
      "code" : "CGX",
      "display" : "LIPEGFILGRASTIM 6MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PKA",
      "display" : "LIPIDI DI SOIA+FOSFOLIPIDI DI TUORLO D'UOVO 20% 500ML USO PARENTERALE"
    },
    {
      "code" : "O4A",
      "display" : "LIRAGLUTIDE 6MG/ML 3ML 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "DIA",
      "display" : "LISINOPRIL 5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "DIB",
      "display" : "LISINOPRIL 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KOV",
      "display" : "LISINOPRIL 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KOW",
      "display" : "LISINOPRIL 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "EDA",
      "display" : "LISINOPRIL+IDROCLOROTIAZIDE 20+12,5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KWK",
      "display" : "LISINOPRIL+IDROCLOROTIAZIDE 20+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "99A",
      "display" : "LITIO CARBONATO 300MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "99B",
      "display" : "LITIO CARBONATO 150MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "ROW",
      "display" : "LIXISENATIDE 10MCG 3ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ROX",
      "display" : "LIXISENATIDE 20MCG 3ML 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "O6A",
      "display" : "LOMEFLOXACINA 400MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "FAC",
      "display" : "LOMITAPIDE 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FAI",
      "display" : "LOMITAPIDE 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FAV",
      "display" : "LOMITAPIDE 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KBG",
      "display" : "LONOCTOCOG ALFA 1.000UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KBH",
      "display" : "LONOCTOCOG ALFA 1.500UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KBI",
      "display" : "LONOCTOCOG ALFA 2.000UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KBK",
      "display" : "LONOCTOCOG ALFA 250UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KBL",
      "display" : "LONOCTOCOG ALFA 3.000UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KBM",
      "display" : "LONOCTOCOG ALFA 500UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "DLA",
      "display" : "LORATADINA 10MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "EQA",
      "display" : "LOSARTAN 12,5MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "EQB",
      "display" : "LOSARTAN 50MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "EQC",
      "display" : "LOSARTAN 100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "ERA",
      "display" : "LOSARTAN+IDROCLOROTIAZIDE 100+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "ERB",
      "display" : "LOSARTAN+IDROCLOROTIAZIDE 50+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "GZW",
      "display" : "LOSARTAN+IDROCLOROTIAZIDE 100+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FAA",
      "display" : "LOVASTATINA 20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FAB",
      "display" : "LOVASTATINA 40MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HQH",
      "display" : "LUMACAFTOR+IVACAFTOR 200+125MG 112 UNITA' USO ORALE"
    },
    {
      "code" : "KKY",
      "display" : "LUMACAFTOR+IVACAFTOR 100+125MG 112 UNITA' USO ORALE"
    },
    {
      "code" : "KYV",
      "display" : "LUMACAFTOR+IVACAFTOR 100+125MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KYW",
      "display" : "LUMACAFTOR+IVACAFTOR 150+188MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KFM",
      "display" : "LURASIDONE 18,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KFN",
      "display" : "LURASIDONE 37MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KFO",
      "display" : "LURASIDONE 74MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LSM",
      "display" : "LUSPATERCEPT 25MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LSN",
      "display" : "LUSPATERCEPT 75MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "O8A",
      "display" : "LUTROPINA ALFA 75UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "O8B",
      "display" : "LUTROPINA ALFA 75UI 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GLY",
      "display" : "MACITENTAN 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "BMA",
      "display" : "MAGALDRATO 8% 250ML USO ORALE"
    },
    {
      "code" : "BMB",
      "display" : "MAGALDRATO 800MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "F9A",
      "display" : "MANIDIPINA 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MNC",
      "display" : "MARIBAVIR 200MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "OBA",
      "display" : "MEBENDAZOLO 100MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "OBB",
      "display" : "MEBENDAZOLO 20MG/ML 30ML USO ORALE"
    },
    {
      "code" : "OBC",
      "display" : "MEBENDAZOLO 500MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OCC",
      "display" : "MEDROSSIPROGESTERONE 150MG/ML 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OCD",
      "display" : "MEDROSSIPROGESTERONE 150MG/ML 3,4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OCE",
      "display" : "MEDROSSIPROGESTERONE 250MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OCF",
      "display" : "MEDROSSIPROGESTERONE 500MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OCH",
      "display" : "MEDROSSIPROGESTERONE 5MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "ODA",
      "display" : "MEFLOCHINA 250MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "C5A",
      "display" : "MEGESTROLO 160MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OEC",
      "display" : "MELEVODOPA+CARBIDOPA 12,5+125MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "OED",
      "display" : "MELEVODOPA+CARBIDOPA 25+100MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "OFA",
      "display" : "MELFALAN 2MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "CWA",
      "display" : "MELOXICAM 15MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CWB",
      "display" : "MELOXICAM 7,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CWC",
      "display" : "MELOXICAM 15MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OGA",
      "display" : "MEMANTINA 10MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "OGB",
      "display" : "MEMANTINA 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "OGC",
      "display" : "MEMANTINA 5MG/EROGAZIONE 50G USO ORALE"
    },
    {
      "code" : "JTT",
      "display" : "MENOTROPINA 75UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JTU",
      "display" : "MENOTROPINA 75UI 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JTV",
      "display" : "MENOTROPINA 150UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JTW",
      "display" : "MENOTROPINA 150UI 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OHA",
      "display" : "MENOTROPINA 1.200UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OHB",
      "display" : "MENOTROPINA 600UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OHC",
      "display" : "MENOTROPINA 75UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JVN",
      "display" : "MEPOLIZUMAB 100MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MFG",
      "display" : "MEPOLIZUMAB 100MG 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BSE",
      "display" : "MERCAPTAMINA 50MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "BSF",
      "display" : "MERCAPTAMINA 150MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "KSR",
      "display" : "MERCAPTAMINA 5MG/ML 3,8ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "KKV",
      "display" : "MERCAPTOPURINA 100ML 20MG/ML USO ORALE"
    },
    {
      "code" : "TOA",
      "display" : "MERCAPTOPURINA 50MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "02A",
      "display" : "MESALAZINA 800MG 24 UNITA' USO ORALE"
    },
    {
      "code" : "02B",
      "display" : "MESALAZINA 400MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "02D",
      "display" : "MESALAZINA 500MG 20 UNITA' USO RETTALE"
    },
    {
      "code" : "02E",
      "display" : "MESALAZINA 2.000MG 7 UNITA' USO RETTALE"
    },
    {
      "code" : "02F",
      "display" : "MESALAZINA 4.000MG 7 UNITA' USO RETTALE"
    },
    {
      "code" : "02G",
      "display" : "MESALAZINA 500MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "02H",
      "display" : "MESALAZINA 800MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "02I",
      "display" : "MESALAZINA 1.000MG 28 UNITA' USO RETTALE"
    },
    {
      "code" : "02J",
      "display" : "MESALAZINA 500MG 50 UNITA' USO ORALE RM"
    },
    {
      "code" : "02L",
      "display" : "MESALAZINA 400MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "02M",
      "display" : "MESALAZINA 1.200MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "02N",
      "display" : "MESALAZINA 1.200MG 120 UNITA' USO ORALE RP"
    },
    {
      "code" : "02P",
      "display" : "MESALAZINA 1,5G 20 UNITA' USO RETTALE"
    },
    {
      "code" : "02Q",
      "display" : "MESALAZINA 2.000MG/DOSE 14G USO RETTALE"
    },
    {
      "code" : "02R",
      "display" : "MESALAZINA 4.000MG/DOSE 28G USO RETTALE"
    },
    {
      "code" : "02S",
      "display" : "MESALAZINA 1.200MG 60 UNITA' USO ORALE RM"
    },
    {
      "code" : "02U",
      "display" : "MESALAZINA 1.200MG 120 UNITA' USO ORALE RM"
    },
    {
      "code" : "KYH",
      "display" : "MESALAZINA 1.000MG 60 UNITA' USO ORALE RM"
    },
    {
      "code" : "OJA",
      "display" : "MESNA 400MG 15 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BNA",
      "display" : "METADONE 0,1% 20ML USO ORALE"
    },
    {
      "code" : "BNB",
      "display" : "METADONE 0,1% 40ML USO ORALE"
    },
    {
      "code" : "BND",
      "display" : "METADONE 0,1% 5ML USO ORALE"
    },
    {
      "code" : "BNE",
      "display" : "METADONE 0,1% 10ML USO ORALE"
    },
    {
      "code" : "BNF",
      "display" : "METADONE 0,1% 100ML USO ORALE"
    },
    {
      "code" : "BNH",
      "display" : "METADONE 0,5% 5ML USO ORALE"
    },
    {
      "code" : "BNI",
      "display" : "METADONE 0,5% 10ML USO ORALE"
    },
    {
      "code" : "BNJ",
      "display" : "METADONE 0,5% 20ML USO ORALE"
    },
    {
      "code" : "LCS",
      "display" : "METADONE 0,5% 60ML USO ORALE"
    },
    {
      "code" : "LCT",
      "display" : "METADONE 0,5% 100ML USO ORALE"
    },
    {
      "code" : "A1A",
      "display" : "METFORMINA 500MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "A1B",
      "display" : "METFORMINA 850MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "A1C",
      "display" : "METFORMINA 1.000MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "A1D",
      "display" : "METFORMINA 500MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "A1E",
      "display" : "METFORMINA 850MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "GLO",
      "display" : "METFORMINA 1.000MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "GLP",
      "display" : "METFORMINA 500MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "GLQ",
      "display" : "METFORMINA 750MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "KXU",
      "display" : "ERTUGLIFLOZIN+METFORMINA 2,5MG+1.000MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "KXV",
      "display" : "ERTUGLIFLOZIN+METFORMINA 7,5MG+1.000MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "FEA",
      "display" : "METFORMINA+GLIBENCLAMIDE 500+5MG 36 UNITA' USO ORALE"
    },
    {
      "code" : "FEB",
      "display" : "METFORMINA+GLIBENCLAMIDE 400+2,5MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "FEC",
      "display" : "METFORMINA+GLIBENCLAMIDE 400+5MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "UAA",
      "display" : "METFORMINA+LINAGLIPTIN 850+2,5MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "UAB",
      "display" : "METFORMINA+LINAGLIPTIN 1.000+2,5MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "ONA",
      "display" : "METILDOPA 500MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "A2A",
      "display" : "METILERGOMETRINA 0,2MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "A2D",
      "display" : "METILERGOMETRINA 0,125MG 15 UNITA' USO ORALE"
    },
    {
      "code" : "OOA",
      "display" : "METILFENIDATO 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OOB",
      "display" : "METILFENIDATO 20MG 30 UNITA' USO ORALE RM 50%-50%"
    },
    {
      "code" : "OOC",
      "display" : "METILFENIDATO 30MG 30 UNITA' USO ORALE RM 50%-50%"
    },
    {
      "code" : "OOD",
      "display" : "METILFENIDATO 10MG 30 UNITA' USO ORALE RM 50%-50%"
    },
    {
      "code" : "OOE",
      "display" : "METILFENIDATO 40MG 30 UNITA' USO ORALE RM 50%-50%"
    },
    {
      "code" : "OOF",
      "display" : "METILFENIDATO 5MG 30 UNITA' USO ORALE RM 50%-50%"
    },
    {
      "code" : "OOG",
      "display" : "METILFENIDATO 10MG 30 UNITA' USO ORALE RM 30%-70%"
    },
    {
      "code" : "OOH",
      "display" : "METILFENIDATO 20MG 30 UNITA' USO ORALE RM 30%-70%"
    },
    {
      "code" : "OOI",
      "display" : "METILFENIDATO 30MG 30 UNITA' USO ORALE RM 30%-70%"
    },
    {
      "code" : "OPA",
      "display" : "METILNALTREXONE 12MG 7 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GMG",
      "display" : "METILPREDNISOLONE 4MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MEO",
      "display" : "METILPREDNISOLONE 16MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OQA",
      "display" : "METILPREDNISOLONE 16MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "OQB",
      "display" : "METILPREDNISOLONE 4MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "OQF",
      "display" : "METILPREDNISOLONE ACEPONATO 0,1% 50G USO DERMATOLOGICO"
    },
    {
      "code" : "ORA",
      "display" : "METILPREDNISOLONE ACETATO 40MG 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OSA",
      "display" : "METILPREDNISOLONE EMISUCCINATO 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OSB",
      "display" : "METILPREDNISOLONE EMISUCCINATO 125MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OSD",
      "display" : "METILPREDNISOLONE EMISUCCINATO 500MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GEB",
      "display" : "METIRAPONE 250MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "A3A",
      "display" : "METOCLOPRAMIDE 10MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "OTA",
      "display" : "METOLAZONE 10MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "OTB",
      "display" : "METOLAZONE 5MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "08A",
      "display" : "METOPROLOLO 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "08C",
      "display" : "METOPROLOLO 100MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "08D",
      "display" : "METOPROLOLO 100MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "08E",
      "display" : "METOPROLOLO 200MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "08G",
      "display" : "METOPROLOLO 200MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "OUA",
      "display" : "METOSSIPOLIETILENGLICOLE-EPOETINA BETA 100MCG USO PARENTERALE"
    },
    {
      "code" : "OUB",
      "display" : "METOSSIPOLIETILENGLICOLE-EPOETINA BETA 120MCG USO PARENTERALE"
    },
    {
      "code" : "OUC",
      "display" : "METOSSIPOLIETILENGLICOLE-EPOETINA BETA 150MCG USO PARENTERALE"
    },
    {
      "code" : "OUD",
      "display" : "METOSSIPOLIETILENGLICOLE-EPOETINA BETA 200MCG USO PARENTERALE"
    },
    {
      "code" : "OUE",
      "display" : "METOSSIPOLIETILENGLICOLE-EPOETINA BETA 250MCG USO PARENTERALE"
    },
    {
      "code" : "OUF",
      "display" : "METOSSIPOLIETILENGLICOLE-EPOETINA BETA 30MCG USO PARENTERALE"
    },
    {
      "code" : "OUG",
      "display" : "METOSSIPOLIETILENGLICOLE-EPOETINA BETA 360MCG USO PARENTERALE"
    },
    {
      "code" : "OUH",
      "display" : "METOSSIPOLIETILENGLICOLE-EPOETINA BETA 50MCG USO PARENTERALE"
    },
    {
      "code" : "OUI",
      "display" : "METOSSIPOLIETILENGLICOLE-EPOETINA BETA 75MCG USO PARENTERALE"
    },
    {
      "code" : "A4G",
      "display" : "METOTREXATO 2,5MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "A4H",
      "display" : "METOTREXATO 7,5MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "A4I",
      "display" : "METOTREXATO 10MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "A4J",
      "display" : "METOTREXATO 15MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "A4K",
      "display" : "METOTREXATO 20MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "A4L",
      "display" : "METOTREXATO 25MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "HKZ",
      "display" : "METOTREXATO 12,5MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "HZM",
      "display" : "METOTREXATO 7,5MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "HZP",
      "display" : "METOTREXATO 10MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "HZR",
      "display" : "METOTREXATO 15MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "HZT",
      "display" : "METOTREXATO 20MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "JGX",
      "display" : "METOTREXATO 17,5MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "JSG",
      "display" : "METOTREXATO 22,5MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "KJN",
      "display" : "METOTREXATO 27,5MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "KJO",
      "display" : "METOTREXATO 30MG 4 UNITA' USO PARENTERALE - SOTTOCUTANEO"
    },
    {
      "code" : "LDE",
      "display" : "METOTREXATO 2,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "A5A",
      "display" : "METRONIDAZOLO 500MG 100ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "A5B",
      "display" : "METRONIDAZOLO 250MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "OVA",
      "display" : "MIANSERINA 30MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "F6A",
      "display" : "MICOFENOLATO MOFETILE 500MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "F6B",
      "display" : "MICOFENOLATO MOFETILE 250MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "OWA",
      "display" : "MICONAZOLO 500MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "OWB",
      "display" : "MICONAZOLO 50MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "BRC",
      "display" : "MIDAZOLAM 2,5MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "BRD",
      "display" : "MIDAZOLAM 5MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "BRE",
      "display" : "MIDAZOLAM 7,5MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "BRF",
      "display" : "MIDAZOLAM 10MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "JWR",
      "display" : "MIGALASTAT 123MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "OXA",
      "display" : "MIGLUSTAT 100MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "OYA",
      "display" : "MINOCICLINA 100MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "C8A",
      "display" : "MIRTAZAPINA 30MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "C8B",
      "display" : "MIRTAZAPINA 30MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "P0A",
      "display" : "MISOPROSTOLO 200MCG 50 UNITA' USO ORALE"
    },
    {
      "code" : "BSH",
      "display" : "MITOTANO 500MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "P1A",
      "display" : "MIZOLASTINA 10MG 20 UNITA' USO ORALE RM"
    },
    {
      "code" : "P2A",
      "display" : "MODAFINIL 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "P4A",
      "display" : "MOEXIPRIL+IDROCLOROTIAZIDE 25+15MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "GPT",
      "display" : "MOMETASONE 0,1% 30G CREMA USO DERMATOLOGICO"
    },
    {
      "code" : "GPU",
      "display" : "MOMETASONE 0,1% 30G SOLUZIONE USO DERMATOLOGICO"
    },
    {
      "code" : "JEE",
      "display" : "MOMETASONE 1MG/G 100G CREMA USO DERMATOLOGICO"
    },
    {
      "code" : "JHF",
      "display" : "MOMETASONE 1MG/G 100G SOLUZIONE USO DERMATOLOGICO"
    },
    {
      "code" : "JYK",
      "display" : "MOMETASONE 1MG/G 70G CREMA USO DERMATOLOGICO"
    },
    {
      "code" : "P5A",
      "display" : "MOMETASONE 200MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "P5B",
      "display" : "MOMETASONE 400MCG 30 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "P6A",
      "display" : "MONTELUKAST 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "P6B",
      "display" : "MONTELUKAST 4MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "P6C",
      "display" : "MONTELUKAST 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "BPA",
      "display" : "MORFINA CLORIDRATO 10MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BPB",
      "display" : "MORFINA CLORIDRATO 20MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BPC",
      "display" : "MORFINA CLORIDRATO 10MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BPD",
      "display" : "MORFINA CLORIDRATO 20MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BPE",
      "display" : "MORFINA CLORIDRATO 50MG 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "P8A",
      "display" : "MORFINA SOLFATO 100MG 16 UNITA' USO ORALE RP"
    },
    {
      "code" : "P8B",
      "display" : "MORFINA SOLFATO 10MG 16 UNITA' USO ORALE RP"
    },
    {
      "code" : "P8C",
      "display" : "MORFINA SOLFATO 10MG/5ML 20 UNITA' USO ORALE"
    },
    {
      "code" : "P8D",
      "display" : "MORFINA SOLFATO 20MG/ML 20ML USO ORALE"
    },
    {
      "code" : "P8E",
      "display" : "MORFINA SOLFATO 2MG/ML 100ML USO ORALE"
    },
    {
      "code" : "P8F",
      "display" : "MORFINA SOLFATO 30MG 16 UNITA' USO ORALE RP"
    },
    {
      "code" : "P8G",
      "display" : "MORFINA SOLFATO 30MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "P8H",
      "display" : "MORFINA SOLFATO 60MG 16 UNITA' USO ORALE RP"
    },
    {
      "code" : "LMC",
      "display" : "MOROCTOCOG ALFA 1.000UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMF",
      "display" : "MOROCTOCOG ALFA 2.000UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMI",
      "display" : "MOROCTOCOG ALFA 250UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMM",
      "display" : "MOROCTOCOG ALFA 500UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMT",
      "display" : "MOROCTOCOG ALFA 3.000UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "P9A",
      "display" : "MOXIFLOXACINA 400MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "EIA",
      "display" : "MOXONIDINA 0,2MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "EIB",
      "display" : "MOXONIDINA 0,4MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "D2A",
      "display" : "NABUMETONE 1.000MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "D3A",
      "display" : "NADROPARINA 2.850UI aXa/0,3ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "D3B",
      "display" : "NADROPARINA 3.800UI 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "D3C",
      "display" : "NADROPARINA 5.700UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "D3D",
      "display" : "NADROPARINA 7.600UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "D3E",
      "display" : "NADROPARINA 9.500UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "D3F",
      "display" : "NADROPARINA 11.400UI 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "D3G",
      "display" : "NADROPARINA 15.200UI 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "D3H",
      "display" : "NADROPARINA 19.000UI 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LBB",
      "display" : "NALDEMEDINA 200MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JTO",
      "display" : "NALOXEGOL 25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FOA",
      "display" : "NALTREXONE 50MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "FOC",
      "display" : "NALTREXONE 50MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "30A",
      "display" : "NAPROXENE 500MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "30C",
      "display" : "NAPROXENE 750MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "EZA",
      "display" : "NEBIVOLOLO 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PAA",
      "display" : "NEBIVOLOLO+IDROCLOROTIAZIDE 5+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PAB",
      "display" : "NEBIVOLOLO+IDROCLOROTIAZIDE 5+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PCA",
      "display" : "NEOSTIGMINA 0,5MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PDA",
      "display" : "NETILMICINA 100MG 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PDB",
      "display" : "NETILMICINA 150MG 1,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PDC",
      "display" : "NETILMICINA 200MG 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PDD",
      "display" : "NETILMICINA 300MG 3ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PDE",
      "display" : "NETILMICINA 50MG 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "11A",
      "display" : "NICARDIPINA 40MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "PEA",
      "display" : "NICLOSAMIDE 50MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "12A",
      "display" : "NIFEDIPINA 30MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "12B",
      "display" : "NIFEDIPINA 60MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "12D",
      "display" : "NIFEDIPINA 20MG 50 UNITA' USO ORALE RP"
    },
    {
      "code" : "12E",
      "display" : "NIFEDIPINA 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "12G",
      "display" : "NIFEDIPINA 2% 30ML USO ORALE"
    },
    {
      "code" : "12X",
      "display" : "NIFEDIPINA 30MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "12Y",
      "display" : "NIFEDIPINA 60MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "NAX",
      "display" : "NIFEDIPINA 30MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "NAY",
      "display" : "NIFEDIPINA 60MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "32A",
      "display" : "NIMESULIDE 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "32Z",
      "display" : "NIMESULIDE BETACICLODESTRINA 400MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "PGA",
      "display" : "NISTATINA 100.000UI/ML 100ML USO ORALE"
    },
    {
      "code" : "JUR",
      "display" : "NITISINONE 4MG/ML 90 ML USO ORALE"
    },
    {
      "code" : "JUS",
      "display" : "NITISINONE 20MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "TMA",
      "display" : "NITISINONE 2MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "TMB",
      "display" : "NITISINONE 5MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "TMC",
      "display" : "NITISINONE 10MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "A7B",
      "display" : "NITROFURANTOINA 50MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "GUU",
      "display" : "NITROFURANTOINA 100MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "A8A",
      "display" : "NITROGLICERINA 5MG/DIE 15 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "A8B",
      "display" : "NITROGLICERINA 10MG/DIE 15 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "A8C",
      "display" : "NITROGLICERINA 15MG/DIE 15 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "EOA",
      "display" : "NOMEGESTROLO 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "PHA",
      "display" : "NONACOG ALFA 1.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PHB",
      "display" : "NONACOG ALFA 2.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PHC",
      "display" : "NONACOG ALFA 250UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PHD",
      "display" : "NONACOG ALFA 500UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PHE",
      "display" : "NONACOG ALFA 3.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MBW",
      "display" : "NONACOG BETA PEGOL (FATTORE XIII DI COAGULAZIONE, RICOMBINANTE) 500UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MBX",
      "display" : "NONACOG BETA PEGOL (FATTORE XIII DI COAGULAZIONE, RICOMBINANTE) 2.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MBY",
      "display" : "NONACOG BETA PEGOL (FATTORE XIII DI COAGULAZIONE, RICOMBINANTE) 1.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KEG",
      "display" : "NONACOG GAMMA 1.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KEH",
      "display" : "NONACOG GAMMA 2.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KEI",
      "display" : "NONACOG GAMMA 250UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KEJ",
      "display" : "NONACOG GAMMA 3.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KEK",
      "display" : "NONACOG GAMMA 500UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PIA",
      "display" : "NORETISTERONE 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "A9B",
      "display" : "NORFLOXACINA 400MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "MCO",
      "display" : "NORTRIPTILINA 25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MCP",
      "display" : "NORTRIPTILINA 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LMA",
      "display" : "OCTOCOG ALFA II GENERAZIONE 1.000UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMD",
      "display" : "OCTOCOG ALFA III GENERAZIONE 1.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LME",
      "display" : "OCTOCOG ALFA III GENERAZIONE 1.500UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMG",
      "display" : "OCTOCOG ALFA II GENERAZIONE 2.000UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMH",
      "display" : "OCTOCOG ALFA II GENERAZIONE 250UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMJ",
      "display" : "OCTOCOG ALFA III GENERAZIONE 250UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMK",
      "display" : "OCTOCOG ALFA II GENERAZIONE 3.000UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LML",
      "display" : "OCTOCOG ALFA II GENERAZIONE 500UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMN",
      "display" : "OCTOCOG ALFA III GENERAZIONE 500UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMO",
      "display" : "OCTOCOG ALFA III GENERAZIONE 2.000UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMP",
      "display" : "OCTOCOG ALFA III GENERAZIONE 3.000UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMQ",
      "display" : "OCTOCOG ALFA I GENERAZIONE 250UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMR",
      "display" : "OCTOCOG ALFA I GENERAZIONE 500UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMS",
      "display" : "OCTOCOG ALFA I GENERAZIONE 1.000UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2A",
      "display" : "OCTREOTIDE 100MCG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2B",
      "display" : "OCTREOTIDE 50MCG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2C",
      "display" : "OCTREOTIDE 1MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2D",
      "display" : "OCTREOTIDE 500MCG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2F",
      "display" : "OCTREOTIDE 10MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2G",
      "display" : "OCTREOTIDE 20MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2H",
      "display" : "OCTREOTIDE 30MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2I",
      "display" : "OCTREOTIDE 0,05MG 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2J",
      "display" : "OCTREOTIDE 0,1MG 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E2K",
      "display" : "OCTREOTIDE 0,5MG 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "FNA",
      "display" : "OLANZAPINA 2,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FNB",
      "display" : "OLANZAPINA 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FNC",
      "display" : "OLANZAPINA 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PLA",
      "display" : "OLMESARTAN MEDOXOMIL 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PLB",
      "display" : "OLMESARTAN MEDOXOMIL 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PLC",
      "display" : "OLMESARTAN MEDOXOMIL 40MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PMA",
      "display" : "OLMESARTAN MEDOXOMIL+AMLODIPINA 20+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PMB",
      "display" : "OLMESARTAN MEDOXOMIL+AMLODIPINA 40+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PMC",
      "display" : "OLMESARTAN MEDOXOMIL+AMLODIPINA 40+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KGR",
      "display" : "OLMESARTAN MEDOXOMIL+AMLODIPINA+IDROCLOROTIAZIDE 20+5+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXR",
      "display" : "OLMESARTAN MEDOXOMIL+AMLODIPINA+IDROCLOROTIAZIDE 40+5+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXS",
      "display" : "OLMESARTAN MEDOXOMIL+AMLODIPINA+IDROCLOROTIAZIDE 40+5+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXT",
      "display" : "OLMESARTAN MEDOXOMIL+AMLODIPINA+IDROCLOROTIAZIDE 40+10+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXU",
      "display" : "OLMESARTAN MEDOXOMIL+AMLODIPINA+IDROCLOROTIAZIDE 40+10+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PNA",
      "display" : "OLMESARTAN MEDOXOMIL+IDROCLOROTIAZIDE 20+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PNB",
      "display" : "OLMESARTAN MEDOXOMIL+IDROCLOROTIAZIDE 20+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PNC",
      "display" : "OLMESARTAN MEDOXOMIL+IDROCLOROTIAZIDE 40+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PND",
      "display" : "OLMESARTAN MEDOXOMIL+IDROCLOROTIAZIDE 40+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DXY",
      "display" : "OLODATEROLO 2,5MCG 30 UNITA' - USO RESPIRATORIO"
    },
    {
      "code" : "BGE",
      "display" : "OMALIZUMAB 150MG 1ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BGG",
      "display" : "OMALIZUMAB 75MG 0,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "EXI",
      "display" : "OMEGA POLIENOICI 1.000MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "POC",
      "display" : "OMEGA POLIENOICI 1.000MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "CSA",
      "display" : "OMEPRAZOLO 10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "CSB",
      "display" : "OMEPRAZOLO 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "JOJ",
      "display" : "OMEPRAZOLO 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JZD",
      "display" : "OMEPRAZOLO 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DZC",
      "display" : "ONDANSETRONE 4MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "DZD",
      "display" : "ONDANSETRONE 8MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "DZE",
      "display" : "ONDANSETRONE 4MG/5ML 50ML USO ORALE"
    },
    {
      "code" : "KLW",
      "display" : "OPICAPONE 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "PQA",
      "display" : "ORFENADRINA 50MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "LDJ",
      "display" : "OSILODROSTAT 10MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "LDK",
      "display" : "OSILODROSTAT 1MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "LDL",
      "display" : "OSILODROSTAT 5MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "KHC",
      "display" : "OSSICODONE 10MG 1ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KHD",
      "display" : "OSSICODONE 20MG 2ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KHE",
      "display" : "OSSICODONE 200MG 20ML 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KHF",
      "display" : "OSSICODONE 200MG 20ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KHG",
      "display" : "OSSICODONE 50MG 1ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PUA",
      "display" : "OSSICODONE 10MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PUB",
      "display" : "OSSICODONE 20MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PUC",
      "display" : "OSSICODONE 40MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PUD",
      "display" : "OSSICODONE 5MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PUE",
      "display" : "OSSICODONE 80MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PUF",
      "display" : "OSSICODONE 60MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "LNG",
      "display" : "OSSICODONE+NALOXONE 30+15MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PVA",
      "display" : "OSSICODONE+NALOXONE 10+5MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PVB",
      "display" : "OSSICODONE+NALOXONE 20+10MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PVC",
      "display" : "OSSICODONE+NALOXONE 40+20MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PVD",
      "display" : "OSSICODONE+NALOXONE 5+2,5MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PWA",
      "display" : "OSSICODONE+PARACETAMOLO 10+325MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PWB",
      "display" : "OSSICODONE+PARACETAMOLO 20+325MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PWC",
      "display" : "OSSICODONE+PARACETAMOLO 5+325MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JAQ",
      "display" : "OSSIDROSSIDO SUCROFERRICO 500MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "2.0",
      "display" : "OSSIGENO GAS COMPRESSO 150 BAR 7 LT METRI CUBI SVOLTI 1,16"
    },
    {
      "code" : "5.0",
      "display" : "OSSIGENO GAS COMPRESSO 150 BAR 14 LT METRI CUBI SVOLTI 2,32"
    },
    {
      "code" : "9.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 5 LT METRI CUBI SVOLTI 1,10"
    },
    {
      "code" : "10.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 7 LT METRI CUBI SVOLTI 1,54"
    },
    {
      "code" : "11.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 10 LT METRI CUBI SVOLTI 2,2"
    },
    {
      "code" : "12.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 11 LT METRI CUBI SVOLTI 2,42"
    },
    {
      "code" : "13.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 12 LT METRI CUBI SVOLTI 2,64"
    },
    {
      "code" : "14.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 14 LT METRI CUBI SVOLTI 3,08"
    },
    {
      "code" : "15.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 15 LT METRI CUBI SVOLTI 3,30"
    },
    {
      "code" : "16.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 17 LT METRI CUBI SVOLTI 3,74"
    },
    {
      "code" : "17.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 18 LT METRI CUBI SVOLTI 3,96"
    },
    {
      "code" : "18.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 20 LT METRI CUBI SVOLTI 4,40"
    },
    {
      "code" : "19.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 24 LT METRI CUBI SVOLTI 5,28"
    },
    {
      "code" : "20.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 27 LT METRI CUBI SVOLTI 5,94"
    },
    {
      "code" : "21.0",
      "display" : "OSSIGENO GAS COMPRESSO 200 BAR 30 LT METRI CUBI SVOLTI 6,60"
    },
    {
      "code" : "22.0",
      "display" : "OSSIGENO GAS CRIOGENICO 25 LT METRI CUBI SVOLTI 21,38"
    },
    {
      "code" : "23.0",
      "display" : "OSSIGENO GAS CRIOGENICO 25,5 LT METRI CUBI SVOLTI 21,81"
    },
    {
      "code" : "24.0",
      "display" : "OSSIGENO GAS CRIOGENICO 29 LT METRI CUBI SVOLTI 24,81"
    },
    {
      "code" : "25.0",
      "display" : "OSSIGENO GAS CRIOGENICO 30 LT METRI CUBI SVOLTI 25,66"
    },
    {
      "code" : "26.0",
      "display" : "OSSIGENO GAS CRIOGENICO 31 LT METRI CUBI SVOLTI 26,52"
    },
    {
      "code" : "27.0",
      "display" : "OSSIGENO GAS CRIOGENICO 31,5 LT METRI CUBI SVOLTI 26,94"
    },
    {
      "code" : "28.0",
      "display" : "OSSIGENO GAS CRIOGENICO 32 LT METRI CUBI SVOLTI 27,37"
    },
    {
      "code" : "29.0",
      "display" : "OSSIGENO GAS CRIOGENICO 33 LT METRI CUBI SVOLTI 28,23"
    },
    {
      "code" : "30.0",
      "display" : "OSSIGENO GAS CRIOGENICO 36 LT METRI CUBI SVOLTI 30,79"
    },
    {
      "code" : "31.0",
      "display" : "OSSIGENO GAS CRIOGENICO 37 LT METRI CUBI SVOLTI 31,65"
    },
    {
      "code" : "32.0",
      "display" : "OSSIGENO GAS CRIOGENICO 38 LT METRI CUBI SVOLTI 32,51"
    },
    {
      "code" : "33.0",
      "display" : "OSSIGENO GAS CRIOGENICO 40 LT METRI CUBI SVOLTI 34,22"
    },
    {
      "code" : "34.0",
      "display" : "OSSIGENO GAS CRIOGENICO 41 LT METRI CUBI SVOLTI 35,07"
    },
    {
      "code" : "35.0",
      "display" : "OSSIGENO GAS CRIOGENICO 44 LT METRI CUBI SVOLTI 37,64"
    },
    {
      "code" : "36.0",
      "display" : "OSSIGENO GAS CRIOGENICO 45 LT METRI CUBI SVOLTI 38,49"
    },
    {
      "code" : "37.0",
      "display" : "OSSIGENO GAS CRIOGENICO 46 LT METRI CUBI SVOLTI 39,35"
    },
    {
      "code" : "78.0",
      "display" : "OSSIGENO GAS CRIOGENICO 44 LT METRI CUBI SVOLTI 36,50"
    },
    {
      "code" : "79.0",
      "display" : "OSSIGENO GAS CRIOGENICO 32 LT METRI CUBI SVOLTI 26,50"
    },
    {
      "code" : "80.0",
      "display" : "OSSIGENO GAS CRIOGENICO 33 LT METRI CUBI SVOLTI 27,50"
    },
    {
      "code" : "99.0",
      "display" : "OSSIGENO GAS COMPRESSO 300 BAR 10 LT METRI CUBI SVOLTI 3,15"
    },
    {
      "code" : "100.0",
      "display" : "OSSIGENO GAS COMPRESSO 300 BAR 14 LT METRI CUBI SVOLTI 4,41"
    },
    {
      "code" : "106.0",
      "display" : "OSSIGENO GAS COMPRESSO 300 BAR 18 LT METRI CUBI SVOLTI 5,67"
    },
    {
      "code" : "156.0",
      "display" : "OSSIGENO GAS COMPRESSO 300 BAR 20 LT METRI CUBI SVOLTI 6,30"
    },
    {
      "code" : "157.0",
      "display" : "OSSIGENO GAS COMPRESSO 300 BAR 27 LT METRI CUBI SVOLTI 8,51"
    },
    {
      "code" : "PRA",
      "display" : "OXACILLINA 1G/5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "PTA",
      "display" : "OXATOMIDE 2,5% 30ML USO ORALE"
    },
    {
      "code" : "PTB",
      "display" : "OXATOMIDE 30MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "DNA",
      "display" : "OXCARBAZEPINA 300MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "DNB",
      "display" : "OXCARBAZEPINA 600MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "C9A",
      "display" : "OSSIBUTININA CLORIDRATO 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LPP",
      "display" : "OZANIMOD 0,23MG 4 UNITA' + 0,46MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "LPQ",
      "display" : "OZANIMOD 0,92MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "PZA",
      "display" : "PALIPERIDONE 3MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PZB",
      "display" : "PALIPERIDONE 6MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "PZC",
      "display" : "PALIPERIDONE 9MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "BHG",
      "display" : "PALIVIZUMAB 100MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BHH",
      "display" : "PALIVIZUMAB 50MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LBP",
      "display" : "PANCRELIPASI 420MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "Q0A",
      "display" : "PANCRELIPASI 150MG 100 UNITA' USO ORALE RM"
    },
    {
      "code" : "CTA",
      "display" : "PANTOPRAZOLO 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "CTB",
      "display" : "PANTOPRAZOLO 40MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "HCF",
      "display" : "PANTOPRAZOLO 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HCJ",
      "display" : "PANTOPRAZOLO 40MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "Q1A",
      "display" : "PARACALCITOLO 1MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "Q1B",
      "display" : "PARACALCITOLO 2MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "Q1C",
      "display" : "PARACALCITOLO 5MCG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "QAC",
      "display" : "PARACALCITOLO 5MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "Q2A",
      "display" : "PARACETAMOLO+CODEINA 500+30MG 16 UNITA' USO ORALE"
    },
    {
      "code" : "Q3A",
      "display" : "PARNAPARINA 3.200UI AXA 0,3ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "Q3B",
      "display" : "PARNAPARINA 4.250UI AXA 0,4ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "Q3C",
      "display" : "PARNAPARINA 6.400UI AXA 0,6ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "Q3D",
      "display" : "PARNAPARINA 8.500UI AXA 0,8ML 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "D4A",
      "display" : "PAROMOMICINA 250MG 16 UNITA' USO ORALE"
    },
    {
      "code" : "AXA",
      "display" : "PAROXETINA 20MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "AXB",
      "display" : "PAROXETINA 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "AXC",
      "display" : "PAROXETINA 2MG/ML 150 ML USO ORALE"
    },
    {
      "code" : "AXD",
      "display" : "PAROXETINA 10MG/ML 60 ML USO ORALE"
    },
    {
      "code" : "AXE",
      "display" : "PAROXETINA 33,1MG/ML 18,5ML USO ORALE"
    },
    {
      "code" : "GWD",
      "display" : "PASIREOTIDE 20MG 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GWM",
      "display" : "PASIREOTIDE 40MG 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GWX",
      "display" : "PASIREOTIDE 60MG 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GYR",
      "display" : "PASIREOTIDE 0,3MG 1ML 60 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GYS",
      "display" : "PASIREOTIDE 0,6MG 1ML 60 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GYT",
      "display" : "PASIREOTIDE 0,9MG 1ML 60 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LPY",
      "display" : "PATIROMER 8,4G 30 UNITA' - USO ORALE"
    },
    {
      "code" : "LPZ",
      "display" : "PATIROMER 16,8G 30 UNITA' - USO ORALE"
    },
    {
      "code" : "Q5A",
      "display" : "PEGFILGRASTIM 6MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NDA",
      "display" : "INTERFERONE ALFA 2A PEGILATO 135MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NDB",
      "display" : "INTERFERONE ALFA 2A PEGILATO 180MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NDC",
      "display" : "INTERFERONE ALFA 2A PEGILATO 90MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NBB",
      "display" : "INTERFERONE BETA 1A PEGILATO 63MCG 1 UNITA' + 94MCG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "NBC",
      "display" : "INTERFERONE BETA 1A PEGILATO 125MCG 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BQL",
      "display" : "PEGVISOMANT 20MG 30 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BQM",
      "display" : "PEGVISOMANT 10MG 30 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BQN",
      "display" : "PEGVISOMANT 15MG 30 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JHJ",
      "display" : "PEGVISOMANT 25MG 30 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JHK",
      "display" : "PEGVISOMANT 30MG 30 UNITA' USO PARENTERALE"
    },
    {
      "code" : "Q6A",
      "display" : "PENTAERITRITILE TETRANITRATO 80MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "Q7A",
      "display" : "PENTAMIDINA 300MG 1 UNITA' USO PARENTERALE O RESPIRATORIO"
    },
    {
      "code" : "JCH",
      "display" : "PERAMPANEL 2MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "JCI",
      "display" : "PERAMPANEL 4MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JCJ",
      "display" : "PERAMPANEL 6MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JCK",
      "display" : "PERAMPANEL 8MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JCL",
      "display" : "PERAMPANEL 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JCM",
      "display" : "PERAMPANEL 12MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KZP",
      "display" : "PERAMPANEL 170MG 140ML USO ORALE"
    },
    {
      "code" : "QAA",
      "display" : "PERICIAZINA 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "QAB",
      "display" : "PERICIAZINA 2% 10ML USO ORALE"
    },
    {
      "code" : "EHA",
      "display" : "PERINDOPRIL 4MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "EHB",
      "display" : "PERINDOPRIL 8MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "QBA",
      "display" : "PERINDOPRIL+AMLODIPINA 8+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "QBB",
      "display" : "PERINDOPRIL+AMLODIPINA 8+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "QBC",
      "display" : "PERINDOPRIL+AMLODIPINA 4+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "QBD",
      "display" : "PERINDOPRIL+AMLODIPINA 4+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "ELA",
      "display" : "PERINDOPRIL+INDAPAMIDE 2+0,625MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "ELB",
      "display" : "PERINDOPRIL+INDAPAMIDE 4+1,25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "ELC",
      "display" : "PERINDOPRIL+INDAPAMIDE 8+2,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LGO",
      "display" : "PERINDOPRIL+INDAPAMIDE+AMLODIPINA 4+1,25+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LGP",
      "display" : "PERINDOPRIL+INDAPAMIDE+AMLODIPINA 4+1,25+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LGQ",
      "display" : "PERINDOPRIL+INDAPAMIDE+AMLODIPINA 8+2,5+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LGR",
      "display" : "PERINDOPRIL+INDAPAMIDE+AMLODIPINA 8+2,5+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OAI",
      "display" : "PERINDOPRIL+INDAPAMIDE+AMLODIPINA 5+1,25+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OAJ",
      "display" : "PERINDOPRIL+INDAPAMIDE+AMLODIPINA 5+1,25+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OAK",
      "display" : "PERINDOPRIL+INDAPAMIDE+AMLODIPINA 10+2,5+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "OAL",
      "display" : "PERINDOPRIL+INDAPAMIDE+AMLODIPINA 10+2,5+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "36C",
      "display" : "PILOCARPINA 2% 10ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "36E",
      "display" : "PILOCARPINA 5MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "QCA",
      "display" : "PIMOZIDE 4MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "QDA",
      "display" : "PINDOLOLO 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "QEA",
      "display" : "PIOGLITAZONE 15MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "QEB",
      "display" : "PIOGLITAZONE 30MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "QEC",
      "display" : "PIOGLITAZONE 45MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "QFA",
      "display" : "PIOGLITAZONE+GLIMEPIRIDE 30+4MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "QFB",
      "display" : "PIOGLITAZONE+GLIMEPIRIDE 30+2MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "QGA",
      "display" : "PIOGLITAZONE+METFORMINA 15+850MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "19A",
      "display" : "PIPERACILLINA 1.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "19B",
      "display" : "PIPERACILLINA 2.000MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E7A",
      "display" : "PIPERACILLINA+TAZOBACTAM 2+0,25G 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E7B",
      "display" : "PIPERACILLINA+TAZOBACTAM 2+0,25G 1 UNITA' USO PARENTERALE EV"
    },
    {
      "code" : "QLA",
      "display" : "PIRIDOSTIGMINA 180MG 50 UNITA' USO ORALE RP"
    },
    {
      "code" : "QLB",
      "display" : "PIRIDOSTIGMINA 60MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "29A",
      "display" : "PIROXICAM 20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "29B",
      "display" : "PIROXICAM 20MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "29E",
      "display" : "PIROXICAM 20MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "JTG",
      "display" : "PITOLISANT 4,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JTH",
      "display" : "PITOLISANT 18MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "HJW",
      "display" : "POLLINE GRAMINACEE 75.000SQ-T 30 UNITA' USO ORALE"
    },
    {
      "code" : "HJS",
      "display" : "POLLINE GRAMIN(DACTYLIS GLOMER+ANTHOXANTHUM ODOR+LOLIUM PEREN+POA PRAT+PHLEUM P) 100 IR-300 IR 30 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "HJT",
      "display" : "POLLINE GRAMIN(DACTYLIS GLOMER+ANTHOXANTHUM ODOR+LOLIUM PEREN+POA PRAT+PHLEUM P) 100 IR-300 IR 31 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "HJU",
      "display" : "POLLINE GRAMIN(DACTYLIS GLOMER+ANTHOXANTHUM ODOR+LOLIUM PEREN+POA PRAT+PHLEUM P) 100 IR-300 IR 90 UNITA' USO SUBLINGUALE"
    },
    {
      "code" : "LWD",
      "display" : "PONESIMOD 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXX",
      "display" : "PONESIMOD 14 UNITA' USO ORALE"
    },
    {
      "code" : "BSI",
      "display" : "POSACONAZOLO 40MG/ML 105ML USO ORALE"
    },
    {
      "code" : "DWN",
      "display" : "POSACONAZOLO 100MG 24 UNITA' USO ORALE"
    },
    {
      "code" : "B0A",
      "display" : "POTASSIO CANRENOATO 100MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "B0B",
      "display" : "POTASSIO CANRENOATO 200MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "QNA",
      "display" : "POTASSIO CANRENOATO+BUTIZIDE 50+5MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "QOA",
      "display" : "POTASSIO CLORURO 600MG 40 UNITA' USO ORALE RP"
    },
    {
      "code" : "QQA",
      "display" : "PRALIDOXIMA 200MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "F4A",
      "display" : "PRAMIPEXOLO 0,18MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "F4B",
      "display" : "PRAMIPEXOLO 0,7MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "F4C",
      "display" : "PRAMIPEXOLO 0,26MG 10 UNITA' USO ORALE RP"
    },
    {
      "code" : "F4D",
      "display" : "PRAMIPEXOLO 0,52MG 10 UNITA' USO ORALE RP"
    },
    {
      "code" : "F4E",
      "display" : "PRAMIPEXOLO 1,05MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "F4F",
      "display" : "PRAMIPEXOLO 2,1MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "F4G",
      "display" : "PRAMIPEXOLO 3,15MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "QRA",
      "display" : "PRASUGREL 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "QRB",
      "display" : "PRASUGREL 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DQA",
      "display" : "PRAVASTATINA 20MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "DQB",
      "display" : "PRAVASTATINA 40MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KSV",
      "display" : "PRAVASTATINA 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KSW",
      "display" : "PRAVASTATINA 40MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LGY",
      "display" : "PREDNISONE 20MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "QTA",
      "display" : "PREDNISONE 1MG 30 UNITA' USO ORALE RM"
    },
    {
      "code" : "QTB",
      "display" : "PREDNISONE 25MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "QTC",
      "display" : "PREDNISONE 2MG 30 UNITA' USO ORALE RM"
    },
    {
      "code" : "QTD",
      "display" : "PREDNISONE 5MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "QTE",
      "display" : "PREDNISONE 5MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "QTF",
      "display" : "PREDNISONE 5MG 30 UNITA' USO ORALE RM"
    },
    {
      "code" : "RAC",
      "display" : "PREDNISONE 25MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "KZX",
      "display" : "PREGABALIN 20MG/ML 250ML USO ORALE"
    },
    {
      "code" : "QUA",
      "display" : "PREGABALIN 150MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "QUB",
      "display" : "PREGABALIN 150MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "QUC",
      "display" : "PREGABALIN 25MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "QUD",
      "display" : "PREGABALIN 300MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "QUE",
      "display" : "PREGABALIN 75MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "QUF",
      "display" : "PREGABALIN 75MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "QVA",
      "display" : "PRIMIDONE 250MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "BSJ",
      "display" : "PROCARBAZINA 50MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "D5A",
      "display" : "PROGESTERONE 200MG 15 UNITA' USO ORALE O VAGINALE"
    },
    {
      "code" : "D5B",
      "display" : "PROGESTERONE 100MG 30 UNITA' USO ORALE O VAGINALE"
    },
    {
      "code" : "D5C",
      "display" : "PROGESTERONE 8% 15 UNITA' GEL USO VAGINALE"
    },
    {
      "code" : "D5D",
      "display" : "PROGESTERONE 200MG 12 UNITA' USO VAGINALE"
    },
    {
      "code" : "D5F",
      "display" : "PROGESTERONE 100MG 1ML 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LBO",
      "display" : "PROGESTERONE 400MG 15 UNITA' USO VAGINALE"
    },
    {
      "code" : "QYA",
      "display" : "PROMETAZINA 50MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "QYB",
      "display" : "PROMETAZINA 25MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "ABA",
      "display" : "PROPAFENONE 150MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "ABB",
      "display" : "PROPAFENONE 300MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "ABC",
      "display" : "PROPAFENONE 325MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "ABD",
      "display" : "PROPAFENONE 425MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "ABE",
      "display" : "PROPAFENONE 70MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "QZA",
      "display" : "PROPRANOLOLO 40MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "QZC",
      "display" : "PROPRANOLOLO 120ML 3,75MG/ML 1 UNITA' USO ORALE"
    },
    {
      "code" : "ACA",
      "display" : "PROTAMINA 1% 50MG 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JJX",
      "display" : "PROTEINA DEL PLASMA UMANO ANTIANGIOEDEMA 1.500U 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MBQ",
      "display" : "PROTEINA DEL PLASMA UMANO ANTIANGIOEDEMA 2.000U 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MJN",
      "display" : "PROTEINA DEL PLASMA UMANO ANTIANGIOEDEMA 3.000U 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "R0A",
      "display" : "PROTEINA DEL PLASMA UMANO ANTIANGIOEDEMA 500U 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "R0B",
      "display" : "PROTEINA DEL PLASMA UMANO ANTIANGIOEDEMA 500U 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "R1A",
      "display" : "PRULIFLOXACINA 600MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "R1B",
      "display" : "PRULIFLOXACINA 600MG 1 UNITA' USO ORALE"
    },
    {
      "code" : "FVA",
      "display" : "QUETIAPINA 25MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "FVB",
      "display" : "QUETIAPINA 25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FVC",
      "display" : "QUETIAPINA 100MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "FVD",
      "display" : "QUETIAPINA 200MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "FVE",
      "display" : "QUETIAPINA 300MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "FVF",
      "display" : "QUETIAPINA 50MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "FVG",
      "display" : "QUETIAPINA 200MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "FVH",
      "display" : "QUETIAPINA 300MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "FVI",
      "display" : "QUETIAPINA 400MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "FVJ",
      "display" : "QUETIAPINA 150MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "LFU",
      "display" : "QUETIAPINA 50MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "DDA",
      "display" : "QUINAPRIL 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DDB",
      "display" : "QUINAPRIL 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "DEA",
      "display" : "QUINAPRIL+IDROCLOROTIAZIDE 20+12,5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "CUA",
      "display" : "RABEPRAZOLO 10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "CUB",
      "display" : "RABEPRAZOLO 20MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KOX",
      "display" : "RABEPRAZOLO 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KOY",
      "display" : "RABEPRAZOLO 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "R2A",
      "display" : "RALOXIFENE 60MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "R2B",
      "display" : "RALOXIFENE 60MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DRA",
      "display" : "RAMIPRIL 5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "DRB",
      "display" : "RAMIPRIL 2,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DRC",
      "display" : "RAMIPRIL 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KJW",
      "display" : "RAMIPRIL 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JAD",
      "display" : "RAMIPRIL+AMLODIPINA 5MG+5MG 30UNITA' USO ORALE"
    },
    {
      "code" : "JAE",
      "display" : "RAMIPRIL+AMLODIPINA 10MG+5MG 30UNITA' USO ORALE"
    },
    {
      "code" : "JAF",
      "display" : "RAMIPRIL+AMLODIPINA 5MG+10MG 30UNITA' USO ORALE"
    },
    {
      "code" : "JAG",
      "display" : "RAMIPRIL+AMLODIPINA 10MG+10MG 30UNITA' USO ORALE"
    },
    {
      "code" : "JCT",
      "display" : "RAMIPRIL+AMLODIPINA 5MG+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JCU",
      "display" : "RAMIPRIL+AMLODIPINA 10MG+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JCV",
      "display" : "RAMIPRIL+AMLODIPINA 5MG+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JCW",
      "display" : "RAMIPRIL+AMLODIPINA 10MG+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MLD",
      "display" : "RAMIPRIL+AMLODIPINA+ATORVASTATINA 5+5+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MLE",
      "display" : "RAMIPRIL+AMLODIPINA+ATORVASTATINA 5+5+20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MLF",
      "display" : "RAMIPRIL+AMLODIPINA+ATORVASTATINA 10+10+20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MLG",
      "display" : "RAMIPRIL+AMLODIPINA+ATORVASTATINA 10+5+20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MLH",
      "display" : "RAMIPRIL+AMLODIPINA+ATORVASTATINA 10+10+40MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LTK",
      "display" : "RAMIPRIL+AMLODIPINA+IDROCLOROTIAZIDE 5MG+5MG+12,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LTL",
      "display" : "RAMIPRIL+AMLODIPINA+IDROCLOROTIAZIDE 5MG+5MG+25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LTM",
      "display" : "RAMIPRIL+AMLODIPINA+IDROCLOROTIAZIDE 10MG+5MG+25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LTN",
      "display" : "RAMIPRIL+AMLODIPINA+IDROCLOROTIAZIDE 10MG+10MG+25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LXL",
      "display" : "RAMIPRIL+AMLODIPINA+IDROCLOROTIAZIDE 5MG+5MG+12,5 MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXM",
      "display" : "RAMIPRIL+AMLODIPINA+IDROCLOROTIAZIDE 5MG+5MG+25 MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXO",
      "display" : "RAMIPRIL+AMLODIPINA+IDROCLOROTIAZIDE 10MG+5MG+25 MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXP",
      "display" : "RAMIPRIL+AMLODIPINA+IDROCLOROTIAZIDE 10MG+10MG+25 MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DSA",
      "display" : "RAMIPRIL+IDROCLOROTIAZIDE 2,5+12,5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "DSB",
      "display" : "RAMIPRIL+IDROCLOROTIAZIDE 5+25MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "KJX",
      "display" : "RAMIPRIL+IDROCLOROTIAZIDE 5+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KJY",
      "display" : "RAMIPRIL+IDROCLOROTIAZIDE 2,5+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KQH",
      "display" : "RAMIPRIL+IDROCLOROTIAZIDE 10+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KQI",
      "display" : "RAMIPRIL+IDROCLOROTIAZIDE 10+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "R3A",
      "display" : "RAMIPRIL+PIRETANIDE 5+6MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "R4A",
      "display" : "RANOLAZINA 375MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "R4B",
      "display" : "RANOLAZINA 500MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "R4C",
      "display" : "RANOLAZINA 750MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "R5A",
      "display" : "RASAGILINA 1MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "R6A",
      "display" : "REBOXETINA 4MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "R6B",
      "display" : "REBOXETINA 4MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "HAD",
      "display" : "REGORAFENIB 40MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "LVC",
      "display" : "RELUGOLIX+ESTRADIOLO+NORETISTERONE 40MG+1MG+0,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "EYA",
      "display" : "REPAGLINIDE 0,5MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "EYB",
      "display" : "REPAGLINIDE 1MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "EYC",
      "display" : "REPAGLINIDE 2MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "F5A",
      "display" : "RIBAVIRINA 200MG 140 UNITA' USO ORALE"
    },
    {
      "code" : "F5I",
      "display" : "RIBAVIRINA 40MG/ML 100ML USO ORALE"
    },
    {
      "code" : "R8A",
      "display" : "RIFABUTINA 150MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MMZ",
      "display" : "RIFAMICINA 200MG 12 UNITA' USO ORALE RM"
    },
    {
      "code" : "ADA",
      "display" : "RIFAMPICINA 2% 60ML USO ORALE"
    },
    {
      "code" : "ADC",
      "display" : "RIFAMPICINA 300MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "ADD",
      "display" : "RIFAMPICINA 450MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "ADF",
      "display" : "RIFAMPICINA 600MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "R9B",
      "display" : "RIFAMPICINA+ISONIAZIDE 300+150MG 24 UNITA' USO ORALE"
    },
    {
      "code" : "FDA",
      "display" : "RIFAXIMINA 200MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "FDB",
      "display" : "RIFAXIMINA 60ML 100MG/ML USO ORALE"
    },
    {
      "code" : "JHN",
      "display" : "RIFAXIMINA 550MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "G4A",
      "display" : "RILUZOLO 50MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "GYK",
      "display" : "RILUZOLO 300ML 5MG/ML USO ORALE"
    },
    {
      "code" : "HWI",
      "display" : "RIOCIGUAT 0,5MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "IAV",
      "display" : "RIOCIGUAT 1MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "IGN",
      "display" : "RIOCIGUAT 1MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "IGO",
      "display" : "RIOCIGUAT 1,5MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "INW",
      "display" : "RIOCIGUAT 1,5MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "IXX",
      "display" : "RIOCIGUAT 2MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "IXY",
      "display" : "RIOCIGUAT 2MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "IXZ",
      "display" : "RIOCIGUAT 2,5MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "IYB",
      "display" : "RIOCIGUAT 2,5MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "DTA",
      "display" : "RISPERIDONE 0,1% 100ML USO ORALE"
    },
    {
      "code" : "DTB",
      "display" : "RISPERIDONE 1MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "DTC",
      "display" : "RISPERIDONE 2MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "DTD",
      "display" : "RISPERIDONE 3MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "DTE",
      "display" : "RISPERIDONE 4MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "RBB",
      "display" : "RITODRINA 50MG 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KHW",
      "display" : "RIVAROXABAN 2,5MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "LTU",
      "display" : "RIVAROXABAN 51,7MG 1MG/ML SOLUZIONE USO ORALE"
    },
    {
      "code" : "LTV",
      "display" : "RIVAROXABAN 103,40MG 1MG/ML SOLUZIONE USO ORALE"
    },
    {
      "code" : "RCA",
      "display" : "RIVAROXABAN 10MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "RCB",
      "display" : "RIVAROXABAN 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RCD",
      "display" : "RIVAROXABAN 15MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "RCE",
      "display" : "RIVAROXABAN 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RDA",
      "display" : "RIVASTIGMINA 1,5MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "RDB",
      "display" : "RIVASTIGMINA 3MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "RDC",
      "display" : "RIVASTIGMINA 4,5MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "RDD",
      "display" : "RIVASTIGMINA 4,6MG/DIE 30 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "RDE",
      "display" : "RIVASTIGMINA 6MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "RDF",
      "display" : "RIVASTIGMINA 9,5MG/DIE 30 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "RDG",
      "display" : "RIVASTIGMINA 13,3MG/DIE 30 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "REA",
      "display" : "RIZATRIPTAN 10MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "REC",
      "display" : "RIZATRIPTAN 10MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "REE",
      "display" : "RIZATRIPTAN 5MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "RFA",
      "display" : "ROFLUMILAST 500MCG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RFB",
      "display" : "ROFLUMILAST 250MCG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LWV",
      "display" : "ROMOSOZUMAB 105MG 1,17ML 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "E6A",
      "display" : "ROPINIROLO 0,25MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "E6B",
      "display" : "ROPINIROLO 0,5MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "E6C",
      "display" : "ROPINIROLO 1MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "E6D",
      "display" : "ROPINIROLO 2MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "E6E",
      "display" : "ROPINIROLO 5MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "E6F",
      "display" : "ROPINIROLO 2MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "E6G",
      "display" : "ROPINIROLO 4MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "E6H",
      "display" : "ROPINIROLO 8MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "LQI",
      "display" : "ROSUVASTATINA 15MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LQJ",
      "display" : "ROSUVASTATINA 30MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RGA",
      "display" : "ROSUVASTATINA 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RGB",
      "display" : "ROSUVASTATINA 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RGC",
      "display" : "ROSUVASTATINA 40MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RGD",
      "display" : "ROSUVASTATINA 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXE",
      "display" : "ROSUVASTATINA CALCIO+ACIDO ACETILSALICILICO 10+100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXF",
      "display" : "ROSUVASTATINA CALCIO+ACIDO ACETILSALICILICO 20+100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LXG",
      "display" : "ROSUVASTATINA CALCIO+ACIDO ACETILSALICILICO 5+100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LYD",
      "display" : "ROSUVASTATINA CALCIO+ACIDO ACETILSALICILICO 5+100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LYE",
      "display" : "ROSUVASTATINA CALCIO+ACIDO ACETILSALICILICO 10+100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LYF",
      "display" : "ROSUVASTATINA CALCIO+ACIDO ACETILSALICILICO 20+100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MCQ",
      "display" : "ROSUVASTATINA CALCIO+AMLODIPINA 10MG+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MCR",
      "display" : "ROSUVASTATINA CALCIO+AMLODIPINA 10MG+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MCS",
      "display" : "ROSUVASTATINA CALCIO+AMLODIPINA 20MG+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MCT",
      "display" : "ROSUVASTATINA CALCIO+AMLODIPINA 20MG+5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RGE",
      "display" : "ROSUVASTATINA CALCIO+AMLODIPINA 20MG+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RGF",
      "display" : "ROSUVASTATINA CALCIO+AMLODIPINA 20MG+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RGG",
      "display" : "ROSUVASTATINA CALCIO+AMLODIPINA 10MG+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RGH",
      "display" : "ROSUVASTATINA CALCIO+AMLODIPINA 10MG+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KIW",
      "display" : "ROSUVASTATINA ZINCO+EZETIMIBE 10+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KIX",
      "display" : "ROSUVASTATINA ZINCO+EZETIMIBE 20+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KQJ",
      "display" : "ROSUVASTATINA ZINCO+EZETIMIBE 5+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KSX",
      "display" : "ROSUVASTATINA+EZETIMIBE 10+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KSY",
      "display" : "ROSUVASTATINA+EZETIMIBE 20+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KSZ",
      "display" : "ROSUVASTATINA+EZETIMIBE 5+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "KYL",
      "display" : "ROSUVASTATINA+EZETIMIBE 10+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KYT",
      "display" : "ROSUVASTATINA+EZETIMIBE 20+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KYU",
      "display" : "ROSUVASTATINA+EZETIMIBE 5+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MMN",
      "display" : "ROSUVASTATINA+EZETIMIBE 40+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MPC",
      "display" : "ROSUVASTATINA/RAMIPRIL 10+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MPD",
      "display" : "ROSUVASTATINA/RAMIPRIL 10+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MPE",
      "display" : "ROSUVASTATINA/RAMIPRIL 20+5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "MPF",
      "display" : "ROSUVASTATINA/RAMIPRIL 20+10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RHA",
      "display" : "ROTIGOTINA 2MG/DIE 28 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "RHC",
      "display" : "ROTIGOTINA 4MG/DIE 28 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "RHE",
      "display" : "ROTIGOTINA 6MG/DIE 28 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "RHG",
      "display" : "ROTIGOTINA 8MG/DIE 28 CEROTTI USO TRANSDERMICO"
    },
    {
      "code" : "MKU",
      "display" : "ROXADUSTAT 20MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "MKV",
      "display" : "ROXADUSTAT 50MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "MKW",
      "display" : "ROXADUSTAT 70MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "MKX",
      "display" : "ROXADUSTAT 100MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "MKY",
      "display" : "ROXADUSTAT 150MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "RJA",
      "display" : "ROXITROMICINA 150MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "RJB",
      "display" : "ROXITROMICINA 300MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "RJC",
      "display" : "ROXITROMICINA 50MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "RKA",
      "display" : "RUFINAMIDE 100MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "RKB",
      "display" : "RUFINAMIDE 200MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "RKC",
      "display" : "RUFINAMIDE 400MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "RLA",
      "display" : "RUFLOXACINA 200MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "RMA",
      "display" : "RUPATADINA 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RMB",
      "display" : "RUPATADINA 120ML 1MG/ML USO ORALE"
    },
    {
      "code" : "KZK",
      "display" : "RURIOCTOCOG ALFA PEGOL 250UI 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KZL",
      "display" : "RURIOCTOCOG ALFA PEGOL 500UI 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KZM",
      "display" : "RURIOCTOCOG ALFA PEGOL 1000UI 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KZN",
      "display" : "RURIOCTOCOG ALFA PEGOL 2000UI 5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "HPF",
      "display" : "SACUBITRIL+VALSARTAN 24+26MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HPG",
      "display" : "SACUBITRIL+VALSARTAN 49+51MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HPT",
      "display" : "SACUBITRIL+VALSARTAN 49+51MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "HPY",
      "display" : "SACUBITRIL+VALSARTAN 97+103MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "GWK",
      "display" : "SAFINAMIDE 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "GWL",
      "display" : "SAFINAMIDE 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "AEB",
      "display" : "SALBUTAMOLO 100MCG 200 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "AED",
      "display" : "SALBUTAMOLO 75MG 15ML USO RESPIRATORIO"
    },
    {
      "code" : "RNA",
      "display" : "SALBUTAMOLO+FLUNISOLIDE 0,5+0,5MG 20 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "DYA",
      "display" : "SALBUTAMOLO+IPRATROPIO BROMURO 0,375%+0,075% 15ML USO RESPIRATORIO E ORALE"
    },
    {
      "code" : "DYC",
      "display" : "SALBUTAMOLO+IPRATROPIO BROMURO 0,5ML 1,875+0,375MG 30 UNITA' USO RESPIRATORIO E ORALE"
    },
    {
      "code" : "DYD",
      "display" : "SALBUTAMOLO+IPRATROPIO BROMURO 0,5MG+2,5MG 2,5ML 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "D6A",
      "display" : "SALMETEROLO 50MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "D6B",
      "display" : "SALMETEROLO 25MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "RPA",
      "display" : "SALMETEROLO+FLUTICASONE 25+125MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "RPB",
      "display" : "SALMETEROLO+FLUTICASONE 25+50MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "RPC",
      "display" : "SALMETEROLO+FLUTICASONE 50+100MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "RPD",
      "display" : "SALMETEROLO+FLUTICASONE 25+250MCG 120 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "RPE",
      "display" : "SALMETEROLO+FLUTICASONE 50+250MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "RPF",
      "display" : "SALMETEROLO+FLUTICASONE 50+500MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "RPG",
      "display" : "SALMETEROLO+FLUTICASONE 50+250MCG 60 MONODOSI USO RESPIRATORIO + HELPENHALER"
    },
    {
      "code" : "RPH",
      "display" : "SALMETEROLO+FLUTICASONE 50+500MCG 60 MONODOSI USO RESPIRATORIO + HELPENHALER"
    },
    {
      "code" : "RPJ",
      "display" : "SALMETEROLO+FLUTICASONE 50+500MCG 60 DOSI USO RESPIRATORIO + EASYHALER"
    },
    {
      "code" : "RPK",
      "display" : "SALMETEROLO+FLUTICASONE 50+250MCG 60 DOSI USO RESPIRATORIO + EASYHALER"
    },
    {
      "code" : "RQA",
      "display" : "SAPROPTERINA 100MG 120 UNITA' USO ORALE"
    },
    {
      "code" : "RQB",
      "display" : "SAPROPTERINA 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RRA",
      "display" : "SAXAGLIPTIN 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RRB",
      "display" : "SAXAGLIPTIN 2,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KJZ",
      "display" : "SAXAGLIPTIN+DAPAGLIFLOZIN PROPANEDIOLO 5MG+10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "GXU",
      "display" : "SAXAGLIPTIN + METFORMINA 2,5 + 850MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "GXV",
      "display" : "SAXAGLIPTIN + METFORMINA 2,5 + 1.000MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "DVA",
      "display" : "SCOPOLAMINA BUTILBROMURO 20MG 6 UNITA' USO PARENTERALE"
    },
    {
      "code" : "RSA",
      "display" : "SELEGILINA 10MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "RSB",
      "display" : "SELEGILINA 5MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "JFY",
      "display" : "SELEXIPAG 200MCG 140 UNITA' USO ORALE"
    },
    {
      "code" : "JKM",
      "display" : "SELEXIPAG 800MCG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JKN",
      "display" : "SELEXIPAG 600MCG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JKO",
      "display" : "SELEXIPAG 400MCG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JKP",
      "display" : "SELEXIPAG 200MCG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JKQ",
      "display" : "SELEXIPAG 1.600MCG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JKR",
      "display" : "SELEXIPAG 1.400MCG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JKS",
      "display" : "SELEXIPAG 1.200MCG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JKT",
      "display" : "SELEXIPAG 1.000MCG 60 UNITA' USO ORALE"
    },
    {
      "code" : "KTB",
      "display" : "SEMAGLUTIDE 0,25MG/DOSE 1,5 ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KTC",
      "display" : "SEMAGLUTIDE 0,50MG/DOSE 1,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KTD",
      "display" : "SEMAGLUTIDE 1MG/DOSE 3 ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LPE",
      "display" : "SEMAGLUTIDE 3MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LPF",
      "display" : "SEMAGLUTIDE 7MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LPG",
      "display" : "SEMAGLUTIDE 14MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CGA",
      "display" : "SERTRALINA 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CGB",
      "display" : "SERTRALINA 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CGC",
      "display" : "SERTRALINA 50MG 15 UNITA' USO ORALE"
    },
    {
      "code" : "CGD",
      "display" : "SERTRALINA 100MG 15 UNITA' USO ORALE"
    },
    {
      "code" : "CGE",
      "display" : "SERTRALINA 1.200MG 60ML USO ORALE"
    },
    {
      "code" : "RTA",
      "display" : "SEVELAMER 2,4G 60 UNITA' USO ORALE"
    },
    {
      "code" : "RTB",
      "display" : "SEVELAMER 800MG 180 UNITA' USO ORALE"
    },
    {
      "code" : "BQJ",
      "display" : "SILDENAFIL 10MG/ML 112ML USO ORALE"
    },
    {
      "code" : "BQV",
      "display" : "SILDENAFIL 25MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "BSK",
      "display" : "SILDENAFIL 20MG 90 UNITA' USO ORALE"
    },
    {
      "code" : "RUA",
      "display" : "SILODOSINA 4MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RUB",
      "display" : "SILODOSINA 8MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LMU",
      "display" : "SIMOCTOCOG ALFA 250UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMV",
      "display" : "SIMOCTOCOG ALFA 500UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMW",
      "display" : "SIMOCTOCOG ALFA 1.000UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LMX",
      "display" : "SIMOCTOCOG ALFA 2.000UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MKE",
      "display" : "SIMOCTOCOG ALFA 1.500UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "RAE",
      "display" : "SIMOCTOCOG ALFA 2500UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "RAF",
      "display" : "SIMOCTOCOG ALFA 3000UI 2,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "DAA",
      "display" : "SIMVASTATINA 20MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "DAB",
      "display" : "SIMVASTATINA 40MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "DAC",
      "display" : "SIMVASTATINA 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DAD",
      "display" : "SIMVASTATINA 40MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "DAE",
      "display" : "SIMVASTATINA 10MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "KXL",
      "display" : "SIMVASTATINA 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LKK",
      "display" : "SIPONIMOD 2MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LKL",
      "display" : "SIPONIMOD 0,25MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "LKM",
      "display" : "SIPONIMOD 0,25MG 120 UNITA' USO ORALE"
    },
    {
      "code" : "MMF",
      "display" : "SIPONIMOD 1MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RVA",
      "display" : "SIROLIMUS 1MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "RVB",
      "display" : "SIROLIMUS 1MG/ML 60ML USO ORALE"
    },
    {
      "code" : "RVC",
      "display" : "SIROLIMUS 2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "RVD",
      "display" : "SIROLIMUS 0,5MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "RWA",
      "display" : "SITAGLIPTIN 100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RWB",
      "display" : "SITAGLIPTIN 25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RWC",
      "display" : "SITAGLIPTIN 50MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LZP",
      "display" : "ERTUGLIFLOZIN+SITAGLIPTIN 5MG+100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LZQ",
      "display" : "ERTUGLIFLOZIN+SITAGLIPTIN 15MG+100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "RXA",
      "display" : "SITAGLIPTIN+METFORMINA 50+1.000MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "RXB",
      "display" : "SITAGLIPTIN+METFORMINA 50+850MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "AFA",
      "display" : "SODIO CLORURO 0,9% 2ML USO PARENTERALE"
    },
    {
      "code" : "AFB",
      "display" : "SODIO CLORURO 0,9% 5ML USO PARENTERALE"
    },
    {
      "code" : "AFC",
      "display" : "SODIO CLORURO 0,9% 10ML USO PARENTERALE"
    },
    {
      "code" : "AFE",
      "display" : "SODIO CLORURO 0,9% 250ML USO PARENTERALE"
    },
    {
      "code" : "AFF",
      "display" : "SODIO CLORURO 0,9% 500ML USO PARENTERALE"
    },
    {
      "code" : "BTG",
      "display" : "SODIO FENILBUTIRRATO 174G 483MG/G USO ORALE"
    },
    {
      "code" : "RZA",
      "display" : "SODIO FERRIGLUCONATO 781,2MG/100ML 240ML USO ORALE"
    },
    {
      "code" : "BSN",
      "display" : "SODIO IBANDRONATO 50MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FZA",
      "display" : "SODIO IBANDRONATO 150MG 1 UNITA' USO ORALE"
    },
    {
      "code" : "JUK",
      "display" : "SODIO IBANDRONATO 150MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "S1A",
      "display" : "SODIO POLISTIRENSOLFONATO 100MG/G 454G 1 UNITA' USO RETTALE"
    },
    {
      "code" : "F2A",
      "display" : "SODIO RISEDRONATO 35MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "F2B",
      "display" : "SODIO RISEDRONATO 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "F2C",
      "display" : "SODIO RISEDRONATO 75MG 2 UNITA' USO ORALE"
    },
    {
      "code" : "GTZ",
      "display" : "SODIO RISEDRONATO 35MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "39A",
      "display" : "ACIDO VALPROICO (SALE DI SODIO) 20% 40ML USO ORALE"
    },
    {
      "code" : "39B",
      "display" : "ACIDO VALPROICO (SALE DI SODIO) 200MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "39C",
      "display" : "ACIDO VALPROICO (SALE DI SODIO) 500MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "LOS",
      "display" : "SODIO ZIRCONIO CICLOSILICATO 5G 30 UNITA' USO ORALE"
    },
    {
      "code" : "LOT",
      "display" : "SODIO ZIRCONIO CICLOSILICATO 10G 30 UNITA' USO ORALE"
    },
    {
      "code" : "JYD",
      "display" : "SOFOSBUVIR+VELPATASVIR 400+100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KJE",
      "display" : "SOFOSBUVIR+VELPATASVIR+VOXILAPREVIR 400+100+100MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "ICV",
      "display" : "SOLIFENACINA 10MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "ICW",
      "display" : "SOLIFENACINA 5MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "ICX",
      "display" : "SOLIFENACINA 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LKI",
      "display" : "SOLRIAMFETOLO 150MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "LKJ",
      "display" : "SOLRIAMFETOLO 75MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "MIT",
      "display" : "SOMATROGON 24MG 1,2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "MIU",
      "display" : "SOMATROGON 60MG 1,2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "IFL",
      "display" : "SOMATROPINA 24MG 3,15ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3A",
      "display" : "SOMATROPINA 0,2MG 7 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3B",
      "display" : "SOMATROPINA 0,4MG 7 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3C",
      "display" : "SOMATROPINA 0,6MG 7 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3D",
      "display" : "SOMATROPINA 0,8MG 7 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3E",
      "display" : "SOMATROPINA 1,2MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3G",
      "display" : "SOMATROPINA 1,4MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3H",
      "display" : "SOMATROPINA 1,6MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3I",
      "display" : "SOMATROPINA 1,8MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3J",
      "display" : "SOMATROPINA 10MG 1,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3K",
      "display" : "SOMATROPINA 10MG 2ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3L",
      "display" : "SOMATROPINA 12MG 3,15ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3M",
      "display" : "SOMATROPINA 15MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3N",
      "display" : "SOMATROPINA 1MG 7 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3O",
      "display" : "SOMATROPINA 2MG 4 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3P",
      "display" : "SOMATROPINA 4MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3Q",
      "display" : "SOMATROPINA 5,3MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3R",
      "display" : "SOMATROPINA 5MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3T",
      "display" : "SOMATROPINA 6MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3V",
      "display" : "SOMATROPINA 6MG 1,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3W",
      "display" : "SOMATROPINA 12MG 1,5ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "S3Y",
      "display" : "SOMATROPINA 12MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "SAI",
      "display" : "SOMATROPINA 20MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "07A",
      "display" : "SOTALOLO 80MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "07C",
      "display" : "SOTALOLO 80MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "07D",
      "display" : "SOTALOLO 160MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "AWA",
      "display" : "SPIRAMICINA 3.000.000UI 12 UNITA' USO ORALE"
    },
    {
      "code" : "S4A",
      "display" : "SPIRONOLATTONE 100MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "S4B",
      "display" : "SPIRONOLATTONE 25MG 16 UNITA' USO ORALE"
    },
    {
      "code" : "S4C",
      "display" : "SPIRONOLATTONE 50MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "S5A",
      "display" : "SPIRONOLATTONE+IDROCLOROTIAZIDE 25+25MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "AHB",
      "display" : "SUCRALFATO 1.000MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "AHC",
      "display" : "SUCRALFATO 2.000MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "AHD",
      "display" : "SUCRALFATO 20% 200ML USO ORALE"
    },
    {
      "code" : "OIA",
      "display" : "SULFASALAZINA 500MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "BVA",
      "display" : "SUMATRIPTAN 6MG 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BVB",
      "display" : "SUMATRIPTAN 100MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "BVC",
      "display" : "SUMATRIPTAN 50MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "BVD",
      "display" : "SUMATRIPTAN 20MG 2 UNITA' SPRAY USO NASALE"
    },
    {
      "code" : "BWA",
      "display" : "TACALCITOLO 4MCG/G 20G USO DERMATOLOGICO"
    },
    {
      "code" : "BWB",
      "display" : "TACALCITOLO 4MCG/G 50G USO DERMATOLOGICO"
    },
    {
      "code" : "FDJ",
      "display" : "TACROLIMUS 1MG/DIE 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "FHA",
      "display" : "TACROLIMUS 0,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FHB",
      "display" : "TACROLIMUS 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FHC",
      "display" : "TACROLIMUS 1MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "FHD",
      "display" : "TACROLIMUS 0,03% 30G UNGUENTO USO DERMATOLOGICO"
    },
    {
      "code" : "FHE",
      "display" : "TACROLIMUS 0,1% 30G UNGUENTO USO DERMATOLOGICO"
    },
    {
      "code" : "FHF",
      "display" : "TACROLIMUS 0,03% 10G UNGUENTO USO DERMATOLOGICO"
    },
    {
      "code" : "FHG",
      "display" : "TACROLIMUS 0,1% 10G UNGUENTO USO DERMATOLOGICO"
    },
    {
      "code" : "FHH",
      "display" : "TACROLIMUS 5MG 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "FHI",
      "display" : "TACROLIMUS 0,5MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "FHJ",
      "display" : "TACROLIMUS 1MG 60 UNITA' USO ORALE RP"
    },
    {
      "code" : "FHK",
      "display" : "TACROLIMUS 5MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "FHL",
      "display" : "TACROLIMUS 3MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "FIX",
      "display" : "TACROLIMUS 0,75MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "FJM",
      "display" : "TACROLIMUS 4MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "GUZ",
      "display" : "TACROLIMUS 0,75MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "GVU",
      "display" : "TACROLIMUS 2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "LPD",
      "display" : "TACROLIMUS 2MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "GSW",
      "display" : "TADALAFIL 20MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "S8A",
      "display" : "TADALAFIL 20MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "LOU",
      "display" : "TAFLUPROST 15MCG 3ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "S9A",
      "display" : "TAFLUPROST 4,5MCG 30 UNITA' SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "IOR",
      "display" : "TAFLUPROST+TIMOLOLO 15MCG+5MG/ML 0,3ML 30UNITA' USO OFTALMICO"
    },
    {
      "code" : "KEV",
      "display" : "TAFLUPROST+TIMOLOLO 15MCG+5MG/ML 0,3ML 90 UNITA' USO OFTALMICO"
    },
    {
      "code" : "MIN",
      "display" : "TAFLUPROST+TIMOLOLO 15MCG+5MG/ML 3ML 1UNITA' USO OFTALMICO"
    },
    {
      "code" : "MIO",
      "display" : "TAFLUPROST+TIMOLOLO 15MCG+5MG/ML 7ML 1UNITA' USO OFTALMICO"
    },
    {
      "code" : "AJA",
      "display" : "TAMOXIFENE 10MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "AJB",
      "display" : "TAMOXIFENE 20MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "AJC",
      "display" : "TAMOXIFENE 20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CNA",
      "display" : "TAMSULOSINA 0,4MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "KQP",
      "display" : "TAMSULOSINA 0,4 MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "SAA",
      "display" : "TAPENTADOLO 100MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "SAB",
      "display" : "TAPENTADOLO 150MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "SAC",
      "display" : "TAPENTADOLO 200MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "SAD",
      "display" : "TAPENTADOLO 250MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "SAE",
      "display" : "TAPENTADOLO 50MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "SAF",
      "display" : "TAPENTADOLO 25MG 40 UNITA' USO ORALE RP"
    },
    {
      "code" : "JTS",
      "display" : "TE' VERDE FOGLIE ESTRATTO 10% 30G UNGUENTO USO DERMATOLOGICO"
    },
    {
      "code" : "JXX",
      "display" : "TEDIZOLID 200MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "IWJ",
      "display" : "TEGAFUR+GIMERACIL+OTERACIL 15+4,35+11,8MG 126 UNITA' USO ORALE"
    },
    {
      "code" : "IWK",
      "display" : "TEGAFUR+GIMERACIL+OTERACIL 15+4,35+11,8MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "IWL",
      "display" : "TEGAFUR+GIMERACIL+OTERACIL 20+5,8+15,8MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "IWM",
      "display" : "TEGAFUR+GIMERACIL+OTERACIL 20+5,8+15,8MG 84 UNITA' USO ORALE"
    },
    {
      "code" : "SCA",
      "display" : "TEICOPLANINA 200MG 1 UNITA' USO PARENTERALE O ORALE"
    },
    {
      "code" : "SEA",
      "display" : "TELMISARTAN 20MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "SEB",
      "display" : "TELMISARTAN 40MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "SEC",
      "display" : "TELMISARTAN 80MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "SFA",
      "display" : "TELMISARTAN+IDROCLOROTIAZIDE 40+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "SFB",
      "display" : "TELMISARTAN+IDROCLOROTIAZIDE 80+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "SFC",
      "display" : "TELMISARTAN+IDROCLOROTIAZIDE 80+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "F8A",
      "display" : "TEMOZOLOMIDE 100MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "F8B",
      "display" : "TEMOZOLOMIDE 140MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "F8C",
      "display" : "TEMOZOLOMIDE 180MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "F8D",
      "display" : "TEMOZOLOMIDE 20MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "F8E",
      "display" : "TEMOZOLOMIDE 250MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "F8F",
      "display" : "TEMOZOLOMIDE 5MG 5 UNITA' USO ORALE"
    },
    {
      "code" : "JZY",
      "display" : "TENOFOVIR ALAFENAMIDE 25MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "CHA",
      "display" : "TENOXICAM 20MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "D7A",
      "display" : "TEOFILLINA 200MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "D7B",
      "display" : "TEOFILLINA 300MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "D7C",
      "display" : "TEOFILLINA 350MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "AYA",
      "display" : "TERAZOSINA 2MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "AYB",
      "display" : "TERAZOSINA 5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "AYC",
      "display" : "TERAZOSINA 2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "AYD",
      "display" : "TERAZOSINA 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "CEA",
      "display" : "TERBINAFINA 250MG 8 UNITA' USO ORALE"
    },
    {
      "code" : "DQY",
      "display" : "TERIFLUNOMIDE 14MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "SHA",
      "display" : "TERIPARATIDE 20MCG/80MCL 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "IIF",
      "display" : "TESTOSTERONE 2% 60G GEL USO ESTERNO"
    },
    {
      "code" : "KPN",
      "display" : "TESTOSTERONE 20MG/G 85,5G GEL USO ESTERNO"
    },
    {
      "code" : "SIA",
      "display" : "TESTOSTERONE PROPIONATO 100MG 2 UNITA' USO PARENTERALE"
    },
    {
      "code" : "SKA",
      "display" : "TETRABENAZINA 25MG 112 UNITA' USO ORALE"
    },
    {
      "code" : "SMA",
      "display" : "TIAGABINA 10MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "SMB",
      "display" : "TIAGABINA 15MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "SMC",
      "display" : "TIAGABINA 5MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "SNA",
      "display" : "TIAMAZOLO 5MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "SOA",
      "display" : "TIAPRIDE 100MG 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "SPA",
      "display" : "TIBOLONE 2,5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "SQA",
      "display" : "TICAGRELOR 90MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "SQB",
      "display" : "TICAGRELOR 60MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "04A",
      "display" : "TICLOPIDINA 250MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "37A",
      "display" : "TIMOLOLO 0,25% 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "37B",
      "display" : "TIMOLOLO 0,5% 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "37C",
      "display" : "TIMOLOLO 0,25% 5ML SOLUZIONE USO OFTALMICO SENZA CONSERVANTI"
    },
    {
      "code" : "37D",
      "display" : "TIMOLOLO 0,5% 5ML SOLUZIONE USO OFTALMICO SENZA CONSERVANTI"
    },
    {
      "code" : "37E",
      "display" : "TIMOLOLO 10MG 40 UNITA' USO ORALE"
    },
    {
      "code" : "37F",
      "display" : "TIMOLOLO 0,4MG 30 DOSI GEL USO OFTALMICO"
    },
    {
      "code" : "SRA",
      "display" : "BIMATOPROST+TIMOLOLO 0,3MG/ML+5MG/ML 3ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "SRB",
      "display" : "BIMATOPROST+TIMOLOLO 0,3MG/ML+5MG/ML 30 UNITA' SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "SRC",
      "display" : "BIMATOPROST+TIMOLOLO 0,3MG/ML+5MG/ML 3ML SOLUZIONE USO OFTALMICO SENZA CONSERVANTI"
    },
    {
      "code" : "SSA",
      "display" : "BRIMONIDINA+TIMOLOLO 0,2%+0,5% 5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "MLY",
      "display" : "TIMOLOLO+TRAVOPROST 40MCG/ML+5MG/ML 30 UNITA' SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "STA",
      "display" : "TIMOLOLO+TRAVOPROST 100MCG+12,5MG SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "LHQ",
      "display" : "TINZAPARINA 2.500UI AXA 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LHR",
      "display" : "TINZAPARINA 3.500UI AXA 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LHS",
      "display" : "TINZAPARINA 4.500UI AXA 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LHT",
      "display" : "TINZAPARINA 8.000UI AXA 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LHU",
      "display" : "TINZAPARINA 10.000UI AXA 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LHV",
      "display" : "TINZAPARINA 12.000UI AXA 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LHW",
      "display" : "TINZAPARINA 14.000UI AXA 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LHX",
      "display" : "TINZAPARINA 16.000UI AXA 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LHY",
      "display" : "TINZAPARINA 18.000UI AXA 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "SUA",
      "display" : "TIOGUANINA 40MG 25 UNITA' USO ORALE"
    },
    {
      "code" : "SVA",
      "display" : "TIOTROPIO 10MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "SVB",
      "display" : "TIOTROPIO 2,5MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "SVC",
      "display" : "TIOTROPIO+OLODATEROLO 2,5+2,5MCG 60 DOSI USO RESPIRATORIO"
    },
    {
      "code" : "MHW",
      "display" : "TIRBANIBULINA 10MG/G 250MG 5 UNITA' USO DERMATOLOGICO"
    },
    {
      "code" : "ANA",
      "display" : "TOBRAMICINA 100MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANB",
      "display" : "TOBRAMICINA 150MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ANC",
      "display" : "TOBRAMICINA 40MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "AND",
      "display" : "TOBRAMICINA 20MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JRA",
      "display" : "TOBRAMICINA 300MG 56 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "SWA",
      "display" : "TOLCAPONE 100MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "IMM",
      "display" : "TOLTERODINA 2MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "IMN",
      "display" : "TOLTERODINA 4MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "KEQ",
      "display" : "TOLVAPTAN 15MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "KER",
      "display" : "TOLVAPTAN 30MG 7 UNITA' USO ORALE"
    },
    {
      "code" : "KES",
      "display" : "TOLVAPTAN 15MG 28 UNITA' + 45MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KET",
      "display" : "TOLVAPTAN 30MG 28 UNITA' + 60MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "KEU",
      "display" : "TOLVAPTAN 30MG 28 UNITA' + 90MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "ENA",
      "display" : "TOPIRAMATO 25MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "ENB",
      "display" : "TOPIRAMATO 50MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "ENC",
      "display" : "TOPIRAMATO 100MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "END",
      "display" : "TOPIRAMATO 200MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "ENE",
      "display" : "TOPIRAMATO 15MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "BSQ",
      "display" : "TOPOTECAN 1MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "C6A",
      "display" : "TORASEMIDE 10MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "C6B",
      "display" : "TORASEMIDE 10MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "SXA",
      "display" : "TOREMIFENE 60MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "BZA",
      "display" : "TRAMADOLO 50MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "BZC",
      "display" : "TRAMADOLO 100MG 2ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BZD",
      "display" : "TRAMADOLO 100MG/ML 10ML USO ORALE"
    },
    {
      "code" : "BZE",
      "display" : "TRAMADOLO 100MG 20 UNITA' USO ORALE RP"
    },
    {
      "code" : "BZF",
      "display" : "TRAMADOLO 150MG 10 UNITA' USO ORALE RP"
    },
    {
      "code" : "BZG",
      "display" : "TRAMADOLO 50MG 1ML 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BZH",
      "display" : "TRAMADOLO 200MG 10 UNITA' USO ORALE RP"
    },
    {
      "code" : "BZI",
      "display" : "TRAMADOLO 100MG/ML 30ML USO ORALE"
    },
    {
      "code" : "BZJ",
      "display" : "TRAMADOLO 50MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "BZK",
      "display" : "TRAMADOLO 100MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "BZL",
      "display" : "TRAMADOLO 150MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "BZM",
      "display" : "TRAMADOLO 200MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "MJH",
      "display" : "TRAMADOLO 100MG/ML 10ML USO ORALE"
    },
    {
      "code" : "MJI",
      "display" : "TRAMADOLO 150MG 10 UNITA' USO ORALE RP"
    },
    {
      "code" : "MJJ",
      "display" : "TRAMADOLO 200MG 10 UNITA' USO ORALE RP"
    },
    {
      "code" : "MJK",
      "display" : "TRAMADOLO 100MG 20 UNITA' USO ORALE RP"
    },
    {
      "code" : "MJL",
      "display" : "TRAMADOLO 50MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "E4A",
      "display" : "TRANDOLAPRIL 2MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "E4B",
      "display" : "TRANDOLAPRIL 0,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "JUX",
      "display" : "TRAVOPROST 75MG 2,5ML SOLUZIONE USO OFTALMICO"
    },
    {
      "code" : "JYP",
      "display" : "TRAVOPROST 40MCG/ML 0,1ML 30 UNITA' SOLUZIONE USO OFTALMICO MONODOSE"
    },
    {
      "code" : "LWA",
      "display" : "TRAVOPROST 100MCG 2,5ML SOLUZIONE USO OFTALMICO MULTIDOSE"
    },
    {
      "code" : "SZA",
      "display" : "TRAZODONE 100MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "SZB",
      "display" : "TRAZODONE 150MG 20 UNITA' USO ORALE RP"
    },
    {
      "code" : "SZC",
      "display" : "TRAZODONE 50MG 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "SZD",
      "display" : "TRAZODONE 50MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "SZF",
      "display" : "TRAZODONE 75MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "SZG",
      "display" : "TRAZODONE 60MG/ML 30ML USO ORALE"
    },
    {
      "code" : "SZH",
      "display" : "TRAZODONE 150MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "SZI",
      "display" : "TRAZODONE 300MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "T0A",
      "display" : "TRETINOINA 10MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "CFA",
      "display" : "TRIAMCINOLONE 40MG 3 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KRT",
      "display" : "TRIENTINA 150MG 72 UNITA' USO ORALE"
    },
    {
      "code" : "MAY",
      "display" : "TRIENTINA 200MG 100 UNITA' USO ORALE"
    },
    {
      "code" : "T1A",
      "display" : "TRIESIFENIDILE 2MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "T2A",
      "display" : "TRIFLUOPERAZINA 1MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "T2B",
      "display" : "TRIFLUOPERAZINA 2MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "JJY",
      "display" : "TRIFLURIDINA+TIPIRACIL 15MG+6,14MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "JJZ",
      "display" : "TRIFLURIDINA+TIPIRACIL 15MG+6,14MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "JKB",
      "display" : "TRIFLURIDINA+TIPIRACIL 20MG+8,19MG 20 UNITA' USO ORALE"
    },
    {
      "code" : "JKC",
      "display" : "TRIFLURIDINA+TIPIRACIL 20MG+8,19MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "KRJ",
      "display" : "TRIMETOPRIM+SULFAMETOXAZOLO 80+400MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "T3B",
      "display" : "TRIMETOPRIM+SULFAMETOXAZOLO 160+800MG 16 UNITA' USO ORALE"
    },
    {
      "code" : "T4C",
      "display" : "TRIMIPRAMINA 800MG 20ML USO ORALE"
    },
    {
      "code" : "BYA",
      "display" : "TRIPTORELINA 3,75MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "BYB",
      "display" : "TRIPTORELINA 11,25MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "KOH",
      "display" : "TRIPTORELINA 22,5MG 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JAR",
      "display" : "TUROCTOCOG ALFA 250UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JAS",
      "display" : "TUROCTOCOG ALFA 500UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JAT",
      "display" : "TUROCTOCOG ALFA 1.000UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JAU",
      "display" : "TUROCTOCOG ALFA 1.500UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JAV",
      "display" : "TUROCTOCOG ALFA 2.000UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "JAW",
      "display" : "TUROCTOCOG ALFA 3.000UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LCB",
      "display" : "TUROCTOCOG ALFA PEGILATO 1.000UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LCC",
      "display" : "TUROCTOCOG ALFA PEGILATO 1.500UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LCD",
      "display" : "TUROCTOCOG ALFA PEGILATO 2.000UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LCE",
      "display" : "TUROCTOCOG ALFA PEGILATO 3.000UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LCF",
      "display" : "TUROCTOCOG ALFA PEGILATO 500UI 4ML 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "IUX",
      "display" : "ULIPRISTAL 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "GBF",
      "display" : "UMECLIDINIO 55MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "GCD",
      "display" : "UMECLIDINIO+VILANTEROLO 55MCG+22MCG 30 UNITA' USO RESPIRATORIO"
    },
    {
      "code" : "GDZ",
      "display" : "UROFOLLITROPINA 300UI 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GEF",
      "display" : "UROFOLLITROPINA 225UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GEL",
      "display" : "UROFOLLITROPINA 300UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GEP",
      "display" : "UROFOLLITROPINA 150UI 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GET",
      "display" : "UROFOLLITROPINA 225UI 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "GZV",
      "display" : "UROFOLLITROPINA 150UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "T6A",
      "display" : "UROFOLLITROPINA 75UI 1 UNITA' USO PARENTERALE"
    },
    {
      "code" : "T6B",
      "display" : "UROFOLLITROPINA 75UI 10 UNITA' USO PARENTERALE"
    },
    {
      "code" : "ETA",
      "display" : "VALACICLOVIR 1.000MG 21 UNITA' USO ORALE"
    },
    {
      "code" : "ETB",
      "display" : "VALACICLOVIR 500MG 42 UNITA' USO ORALE"
    },
    {
      "code" : "T7A",
      "display" : "VALGANCICLOVIR 450MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "T7B",
      "display" : "VALGANCICLOVIR 5.500MG 1 UNITA' USO ORALE"
    },
    {
      "code" : "T8A",
      "display" : "VALPROMIDE 300MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "FPA",
      "display" : "VALSARTAN 40MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "FPB",
      "display" : "VALSARTAN 80MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FPC",
      "display" : "VALSARTAN 160MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FPD",
      "display" : "VALSARTAN 320MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FQA",
      "display" : "VALSARTAN+IDROCLOROTIAZIDE 80+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FQB",
      "display" : "VALSARTAN+IDROCLOROTIAZIDE 160+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FQC",
      "display" : "VALSARTAN+IDROCLOROTIAZIDE 160+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FQD",
      "display" : "VALSARTAN+IDROCLOROTIAZIDE 320+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FQE",
      "display" : "VALSARTAN+IDROCLOROTIAZIDE 320+25MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "T9A",
      "display" : "VANCOMICINA 250MG 4 UNITA' USO ORALE"
    },
    {
      "code" : "KBQ",
      "display" : "VARDENAFIL 20MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "ITU",
      "display" : "VARENICLINA 0,5MG 11 UNITA'+1MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "ITV",
      "display" : "VARENICLINA 1MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "ITW",
      "display" : "VARENICLINA 1MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "E3A",
      "display" : "VENLAFAXINA 75MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "E3B",
      "display" : "VENLAFAXINA 150MG 10 UNITA' USO ORALE RP"
    },
    {
      "code" : "E3C",
      "display" : "VENLAFAXINA 37,5MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "E3E",
      "display" : "VENLAFAXINA 37,5MG 7 UNITA' USO ORALE RP"
    },
    {
      "code" : "E3F",
      "display" : "VENLAFAXINA 225MG 14 UNITA' USO ORALE RP"
    },
    {
      "code" : "E3G",
      "display" : "VENLAFAXINA 4.500MG 60ML USO ORALE"
    },
    {
      "code" : "KQS",
      "display" : "VENLAFAXINA 75MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "KQT",
      "display" : "VENLAFAXINA 150MG 28 UNITA' USO ORALE RP"
    },
    {
      "code" : "KWJ",
      "display" : "VENLAFAXINA 150MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "KYG",
      "display" : "VENLAFAXINA 300MG 10 UNITA' USO ORALE"
    },
    {
      "code" : "MMG",
      "display" : "VENLAFAXINA 300MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "13A",
      "display" : "VERAPAMIL 120MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "13B",
      "display" : "VERAPAMIL 240MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "13C",
      "display" : "VERAPAMIL 80MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "13D",
      "display" : "VERAPAMIL 40MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "13E",
      "display" : "VERAPAMIL 180MG 30 UNITA' USO ORALE RP"
    },
    {
      "code" : "13F",
      "display" : "VERAPAMIL 5MG 5 UNITA' USO PARENTERALE"
    },
    {
      "code" : "LUD",
      "display" : "VERICIGUAT 2,5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "LUE",
      "display" : "VERICIGUAT 5MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "LUF",
      "display" : "VERICIGUAT 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "TAA",
      "display" : "VIGABATRIN 500MG 50 UNITA' USO ORALE"
    },
    {
      "code" : "KPM",
      "display" : "FLUTICASONE+UMECLIDINIO+VILANTEROLO 92+55+22MCG 30 DOSI USO INALATORIO"
    },
    {
      "code" : "TBA",
      "display" : "VILDAGLIPTIN 50MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "TCA",
      "display" : "VILDAGLIPTIN+METFORMINA 50+1.000MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "TCB",
      "display" : "VILDAGLIPTIN+METFORMINA 50+850MG 60 UNITA' USO ORALE"
    },
    {
      "code" : "BSR",
      "display" : "VINORELBINA 20MG 1 UNITA' USO ORALE"
    },
    {
      "code" : "BSS",
      "display" : "VINORELBINA 30MG 1 UNITA' USO ORALE"
    },
    {
      "code" : "MMO",
      "display" : "VOCLOSPORINA 7,9MG 180 UNITA' USO ORALE"
    },
    {
      "code" : "BST",
      "display" : "VORICONAZOLO 50MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "BSU",
      "display" : "VORICONAZOLO 200MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "BSV",
      "display" : "VORICONAZOLO 40MG/ML 45G USO ORALE"
    },
    {
      "code" : "HZD",
      "display" : "VORTIOXETINA 5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HZE",
      "display" : "VORTIOXETINA 10MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "HZF",
      "display" : "VORTIOXETINA 20MG/ML 15ML USO ORALE"
    },
    {
      "code" : "TDA",
      "display" : "WARFARIN 5MG 30 UNITA' USO ORALE"
    },
    {
      "code" : "BSX",
      "display" : "ZINCO ACETATO 25MG 250 UNITA' USO ORALE"
    },
    {
      "code" : "BSY",
      "display" : "ZINCO ACETATO 50MG 250 UNITA' USO ORALE"
    },
    {
      "code" : "TGA",
      "display" : "ZIPRASIDONE 20MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "TGB",
      "display" : "ZIPRASIDONE 40MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "TGC",
      "display" : "ZIPRASIDONE 60MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "FJA",
      "display" : "ZOFENOPRIL 30MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FJB",
      "display" : "ZOFENOPRIL 7,5MG 12 UNITA' USO ORALE"
    },
    {
      "code" : "THA",
      "display" : "ZOFENOPRIL+IDROCLOROTIAZIDE 30+12,5MG 28 UNITA' USO ORALE"
    },
    {
      "code" : "FUA",
      "display" : "ZOLMITRIPTAN 2,5MG 3 UNITA' USO ORALE"
    },
    {
      "code" : "FUB",
      "display" : "ZOLMITRIPTAN 2,5MG 6 UNITA' USO ORALE"
    },
    {
      "code" : "TIA",
      "display" : "ZONISAMIDE 100MG 56 UNITA' USO ORALE"
    },
    {
      "code" : "TIB",
      "display" : "ZONISAMIDE 25MG 14 UNITA' USO ORALE"
    },
    {
      "code" : "TIC",
      "display" : "ZONISAMIDE 50MG 28 UNITA' USO ORALE"
    }
  ]
}

```
