# AIFA - ATC - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* [**Indice Artefatti**](artifacts.md)
* **AIFA - ATC**

## CodeSystem: AIFA - ATC 

| | |
| :--- | :--- |
| *Official URL*:https://www.hl7.it/fhir/terminology/CodeSystem/aifa-atc | *Version*:0.1.2 |
| Active as of 2025-11-12 | *Computable Name*:CsAtcPrincipio |

 
AIFA - ATC 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "aifa-atc",
  "url" : "https://www.hl7.it/fhir/terminology/CodeSystem/aifa-atc",
  "version" : "0.1.2",
  "name" : "CsAtcPrincipio",
  "title" : "AIFA - ATC",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-12T13:44:06+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "AIFA - ATC",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "concept" : [
    {
      "code" : "A10BF01",
      "display" : "Acarbosio"
    },
    {
      "code" : "M01AB16",
      "display" : "Aceclofenac"
    },
    {
      "code" : "J05AB01",
      "display" : "Aciclovir"
    },
    {
      "code" : "B01AC06",
      "display" : "Acido acetilsalicilico"
    },
    {
      "code" : "M05BA04",
      "display" : "Acido alendronico"
    },
    {
      "code" : "M05BB03",
      "display" : "Acido alendronico + Colecalciferolo"
    },
    {
      "code" : "A16AA05",
      "display" : "Acido carglumico"
    },
    {
      "code" : "M05BA02",
      "display" : "Acido clodronico"
    },
    {
      "code" : "B03BB01",
      "display" : "Acido folico"
    },
    {
      "code" : "L04AA06",
      "display" : "Acido Micofenolico"
    },
    {
      "code" : "B02AA02",
      "display" : "Acido tranexamico"
    },
    {
      "code" : "A05AA02",
      "display" : "Acido ursodesossicolico"
    },
    {
      "code" : "N03AG01",
      "display" : "Acido valproico (sale di sodio)"
    },
    {
      "code" : "D05BB02",
      "display" : "Acitretina"
    },
    {
      "code" : "V07AB",
      "display" : "Acqua per preparazioni iniettabili"
    },
    {
      "code" : "C01CA24",
      "display" : "Adrenalina"
    },
    {
      "code" : "G04CA01",
      "display" : "Alfuzosina"
    },
    {
      "code" : "M04AA01",
      "display" : "Allopurinolo"
    },
    {
      "code" : "N02CC05",
      "display" : "Almotriptan"
    },
    {
      "code" : "N05AD01",
      "display" : "Aloperidolo"
    },
    {
      "code" : "C02KX02",
      "display" : "Ambrisentan"
    },
    {
      "code" : "J01GB06",
      "display" : "Amikacina"
    },
    {
      "code" : "C01BD01",
      "display" : "Amiodarone"
    },
    {
      "code" : "N05AL05",
      "display" : "Amisulpride"
    },
    {
      "code" : "N06AA09",
      "display" : "Amitriptilina"
    },
    {
      "code" : "C08CA01",
      "display" : "Amlodipina"
    },
    {
      "code" : "C09DB01",
      "display" : "Amlodipina + Valsartan"
    },
    {
      "code" : "C09DX01",
      "display" : "Amlodipina+ Valsartan + Idroclorotiazide"
    },
    {
      "code" : "J01CA04",
      "display" : "Amoxicillina"
    },
    {
      "code" : "J01CR02",
      "display" : "Amoxicillina + Acido clavulanico"
    },
    {
      "code" : "L01XX35",
      "display" : "Anagrelide"
    },
    {
      "code" : "L02BG03",
      "display" : "Anastrozolo"
    },
    {
      "code" : "N05AX12",
      "display" : "Aripiprazolo"
    },
    {
      "code" : "C07AB03",
      "display" : "Atenololo"
    },
    {
      "code" : "C07CB03",
      "display" : "Atenololo + Clortalidone"
    },
    {
      "code" : "C10AA05",
      "display" : "Atorvastatina"
    },
    {
      "code" : "A03BA01",
      "display" : "Atropina"
    },
    {
      "code" : "L04AX01",
      "display" : "Azatioprina"
    },
    {
      "code" : "J01FA10",
      "display" : "Azitromicina"
    },
    {
      "code" : "M03BX01",
      "display" : "Baclofene"
    },
    {
      "code" : "A07EA07",
      "display" : "Beclometasone"
    },
    {
      "code" : "R03BA01",
      "display" : "Beclometasone/Formoterolo"
    },
    {
      "code" : "R03AK08",
      "display" : "Benazepril"
    },
    {
      "code" : "C09AA07",
      "display" : "Benazepril + Idroclorotiazide"
    },
    {
      "code" : "C09BA07",
      "display" : "Betametasone"
    },
    {
      "code" : "H02AB01",
      "display" : "Bicalutamide"
    },
    {
      "code" : "L02BB03",
      "display" : "Bimatoprost"
    },
    {
      "code" : "S01EE03",
      "display" : "Bimatoprost + Timololo"
    },
    {
      "code" : "S01ED51",
      "display" : "Bisoprololo"
    },
    {
      "code" : "C07AB07",
      "display" : "Bisoprololo + Idroclorotiazide"
    },
    {
      "code" : "C07BB07",
      "display" : "Bosentan"
    },
    {
      "code" : "C02KX01",
      "display" : "Brimonidina"
    },
    {
      "code" : "S01EA05",
      "display" : "Brimonidina + Timololo"
    },
    {
      "code" : "S01EC04",
      "display" : "Brinzolamide"
    },
    {
      "code" : "S01EC54",
      "display" : "Brinzolamide + Timololo"
    },
    {
      "code" : "J05AB15",
      "display" : "Brivudina"
    },
    {
      "code" : "G02CB01",
      "display" : "Bromocriptina"
    },
    {
      "code" : "R03BA02",
      "display" : "Budesonide"
    },
    {
      "code" : "A07EA06",
      "display" : "Budesonide + Formoterolo"
    },
    {
      "code" : "R03AK07",
      "display" : "Buprenorfina"
    },
    {
      "code" : "N02AE01",
      "display" : "Bupropione"
    },
    {
      "code" : "N06AX12",
      "display" : "Cabergolina"
    },
    {
      "code" : "G02CB03",
      "display" : "Calcifediolo"
    },
    {
      "code" : "A11CC06",
      "display" : "Calcio carbonato"
    },
    {
      "code" : "A12AA04",
      "display" : "Calcio carbonato + Colecalciferolo"
    },
    {
      "code" : "A12AA20",
      "display" : "Calcio fosfato + Colecalciferolo"
    },
    {
      "code" : "A12AX",
      "display" : "Calcipotriolo"
    },
    {
      "code" : "D05AX02",
      "display" : "Calcipotriolo + Betametasone"
    },
    {
      "code" : "D05AX52",
      "display" : "Calcitriolo"
    },
    {
      "code" : "A11CC04",
      "display" : "Candesartan cilexetil"
    },
    {
      "code" : "C09CA06",
      "display" : "Candesartan cilexetil + Amlodipina"
    },
    {
      "code" : "C09DB07",
      "display" : "Candesartan cilexetil + Idroclorotiazide"
    },
    {
      "code" : "C09DA06",
      "display" : "Capecitabina"
    },
    {
      "code" : "L01BC06",
      "display" : "Captopril"
    },
    {
      "code" : "C09AA01",
      "display" : "Captopril + Idroclorotiazide"
    },
    {
      "code" : "C09BA01",
      "display" : "Carbamazepina"
    },
    {
      "code" : "N03AF01",
      "display" : "Carvedilolo"
    },
    {
      "code" : "C07AG02",
      "display" : "Cefaclor"
    },
    {
      "code" : "J01DC04",
      "display" : "Cefazolina"
    },
    {
      "code" : "J01DB04",
      "display" : "Cefixima"
    },
    {
      "code" : "J01DD08",
      "display" : "Cefotaxima"
    },
    {
      "code" : "J01DD01",
      "display" : "Cefpodoxima"
    },
    {
      "code" : "J01DD13",
      "display" : "Ceftazidima"
    },
    {
      "code" : "J01DD02",
      "display" : "Ceftriaxone"
    },
    {
      "code" : "J01DD04",
      "display" : "Cefuroxima"
    },
    {
      "code" : "J01DC02",
      "display" : "Celecoxib"
    },
    {
      "code" : "M01AH01",
      "display" : "Cetirizina"
    },
    {
      "code" : "R06AE07",
      "display" : "Ciclosporina"
    },
    {
      "code" : "L04AD01",
      "display" : "Cinacalcet"
    },
    {
      "code" : "H05BX01",
      "display" : "Ciprofloxacina"
    },
    {
      "code" : "J01MA02",
      "display" : "Ciproterone + Etinilestradiolo"
    },
    {
      "code" : "G03HB01",
      "display" : "Citalopram"
    },
    {
      "code" : "N06AB04",
      "display" : "Claritromicina"
    },
    {
      "code" : "J01FA09",
      "display" : "Clobetasolo"
    },
    {
      "code" : "D07AD01",
      "display" : "Clopidogrel"
    },
    {
      "code" : "B01AC04",
      "display" : "Clopidogrel + Acido acetilsalicilico"
    },
    {
      "code" : "B01AC30",
      "display" : "Clozapina"
    },
    {
      "code" : "N05AH02",
      "display" : "Colecalciferolo"
    },
    {
      "code" : "A11CC05",
      "display" : "Deferasirox"
    },
    {
      "code" : "V03AC03",
      "display" : "Deferiprone"
    },
    {
      "code" : "V03AC02",
      "display" : "Deferoxamina"
    },
    {
      "code" : "V03AC01",
      "display" : "Desametasone"
    },
    {
      "code" : "H02AB02",
      "display" : "Desloratadina"
    },
    {
      "code" : "R06AX27",
      "display" : "Diclofenac"
    },
    {
      "code" : "M01AB05",
      "display" : "Diltiazem"
    },
    {
      "code" : "D11AX18",
      "display" : "Donepezil"
    },
    {
      "code" : "C08DB01",
      "display" : "Dorzolamide"
    },
    {
      "code" : "N06DA02",
      "display" : "Dorzolamide + Timololo"
    },
    {
      "code" : "S01EC03",
      "display" : "Doxazosin"
    },
    {
      "code" : "G04CA",
      "display" : "Doxiciclina"
    },
    {
      "code" : "C02CA04",
      "display" : "Dronedarone"
    },
    {
      "code" : "J01AA02",
      "display" : "Duloxetina"
    },
    {
      "code" : "C01BD07",
      "display" : "Dutasteride"
    },
    {
      "code" : "N06AX21",
      "display" : "Ebastina"
    },
    {
      "code" : "G04CB02",
      "display" : "Eletriptan"
    },
    {
      "code" : "R06AX22",
      "display" : "Enalapril"
    },
    {
      "code" : "N02CC06",
      "display" : "Enalapril + Idroclorotiazide"
    },
    {
      "code" : "C09AA02",
      "display" : "Enalapril + Lercanidipina"
    },
    {
      "code" : "C09BA02",
      "display" : "Entecavir"
    },
    {
      "code" : "C09BB02",
      "display" : "Eparina calcica"
    },
    {
      "code" : "J05AF10",
      "display" : "Eparina sodica"
    },
    {
      "code" : "B01AB01",
      "display" : "Eplerenone"
    },
    {
      "code" : "C03DA04",
      "display" : "Escitalopram"
    },
    {
      "code" : "N06AB10",
      "display" : "Eslicarbazepina"
    },
    {
      "code" : "N03AF04",
      "display" : "Esomeprazolo"
    },
    {
      "code" : "A02BC05",
      "display" : "Estradiolo"
    },
    {
      "code" : "G03CA03",
      "display" : "Estradiolo + Drospirenone"
    },
    {
      "code" : "G03FA17",
      "display" : "Etoricoxib"
    },
    {
      "code" : "M01AH05",
      "display" : "Exemestane"
    },
    {
      "code" : "L02BG06",
      "display" : "Ezetimibe"
    },
    {
      "code" : "C10AX09",
      "display" : "Ezetimibe + Atorvastatina"
    },
    {
      "code" : "C10BA05",
      "display" : "Ezetimibe + Atorvastatina"
    },
    {
      "code" : "C10BA02",
      "display" : "Ezetimibe + Simvastatina"
    },
    {
      "code" : "J05AB09",
      "display" : "Famciclovir"
    },
    {
      "code" : "M04AA03",
      "display" : "Febuxostat"
    },
    {
      "code" : "C08CA02",
      "display" : "Felodipina"
    },
    {
      "code" : "C10AB05",
      "display" : "Fenofibrato"
    },
    {
      "code" : "N02AB03",
      "display" : "Fentanil"
    },
    {
      "code" : "B03AA03",
      "display" : "Ferroso gluconato"
    },
    {
      "code" : "R06AX26",
      "display" : "Fexofenadina"
    },
    {
      "code" : "G04CB01",
      "display" : "Finasteride"
    },
    {
      "code" : "C01BC04",
      "display" : "Flecainide"
    },
    {
      "code" : "J02AC01",
      "display" : "Fluconazolo"
    },
    {
      "code" : "R03BA03",
      "display" : "Flunisolide"
    },
    {
      "code" : "N06AB03",
      "display" : "Fluoxetina"
    },
    {
      "code" : "R03BA05",
      "display" : "Fluticasone"
    },
    {
      "code" : "D07AC17",
      "display" : "Fluvastatina"
    },
    {
      "code" : "C10AA04",
      "display" : "Fluvoxamina"
    },
    {
      "code" : "N06AB08",
      "display" : "Formoterolo"
    },
    {
      "code" : "R03AC13",
      "display" : "Fosfomicina"
    },
    {
      "code" : "J01XX01",
      "display" : "Fosinopril"
    },
    {
      "code" : "C09AA09",
      "display" : "Fosinopril + Idroclorotiazide"
    },
    {
      "code" : "C09BA09",
      "display" : "Frovatriptan"
    },
    {
      "code" : "N02CC07",
      "display" : "Furosemide"
    },
    {
      "code" : "C03CA01",
      "display" : "Gabapentin"
    },
    {
      "code" : "N02BF01",
      "display" : "Galantamina"
    },
    {
      "code" : "N06DA04",
      "display" : "Gemfibrozil"
    },
    {
      "code" : "C10AB04",
      "display" : "Glatiramer"
    },
    {
      "code" : "L03AX13",
      "display" : "Gliclazide"
    },
    {
      "code" : "A10BB09",
      "display" : "Glimepiride"
    },
    {
      "code" : "A10BB12",
      "display" : "Glucosio"
    },
    {
      "code" : "B05BA03",
      "display" : "Granisetrone"
    },
    {
      "code" : "A04AA02",
      "display" : "Griseofulvina"
    },
    {
      "code" : "D01BA01",
      "display" : "Ibuprofene"
    },
    {
      "code" : "M01AE01",
      "display" : "Idroclorotiazide"
    },
    {
      "code" : "C03AA03",
      "display" : "Idrossiclorochina"
    },
    {
      "code" : "P01BA02",
      "display" : "Iloprost"
    },
    {
      "code" : "B01AC11",
      "display" : "Imatinib"
    },
    {
      "code" : "L01EA01",
      "display" : "Imiquimod"
    },
    {
      "code" : "D06BB10",
      "display" : "Indapamide"
    },
    {
      "code" : "C03BA11",
      "display" : "Ipratropio bromuro"
    },
    {
      "code" : "R03BB01",
      "display" : "Irbesartan"
    },
    {
      "code" : "C09CA04",
      "display" : "Irbesartan + Idroclorotiazide"
    },
    {
      "code" : "C09DA04",
      "display" : "Isosorbide mononitrato"
    },
    {
      "code" : "C01DA14",
      "display" : "Isotretinoina"
    },
    {
      "code" : "D10BA01",
      "display" : "Itraconazolo"
    },
    {
      "code" : "J02AC02",
      "display" : "Ivabradina"
    },
    {
      "code" : "C01EB17",
      "display" : "Ketoprofene"
    },
    {
      "code" : "M01AE03",
      "display" : "Ketorolac"
    },
    {
      "code" : "M01AB15",
      "display" : "Ketotifene"
    },
    {
      "code" : "R06AX17",
      "display" : "Lacidipina"
    },
    {
      "code" : "C08CA09",
      "display" : "Lacosamide"
    },
    {
      "code" : "N03AX18",
      "display" : "Lamivudina"
    },
    {
      "code" : "J05AF05",
      "display" : "Lamotrigina"
    },
    {
      "code" : "N03AX09",
      "display" : "Lanreotide"
    },
    {
      "code" : "H01CB03",
      "display" : "Lansoprazolo"
    },
    {
      "code" : "A02BC03",
      "display" : "Latanoprost"
    },
    {
      "code" : "S01EE01",
      "display" : "Latanoprost + Timololo"
    },
    {
      "code" : "L04AA13",
      "display" : "Leflunomide"
    },
    {
      "code" : "C08CA13",
      "display" : "Lercanidipina"
    },
    {
      "code" : "L02BG04",
      "display" : "Letrozolo"
    },
    {
      "code" : "N03AX14",
      "display" : "Levetiracetam"
    },
    {
      "code" : "A16AA01",
      "display" : "Levocarnitina"
    },
    {
      "code" : "R06AE09",
      "display" : "Levocetirizina"
    },
    {
      "code" : "N04BA02",
      "display" : "Levodopa + Carbidopa"
    },
    {
      "code" : "N04BA03",
      "display" : "Levodopa/carbidopa/entacapone"
    },
    {
      "code" : "J01MA12",
      "display" : "Levofloxacina"
    },
    {
      "code" : "H03AA01",
      "display" : "Levotiroxina"
    },
    {
      "code" : "J01XX08",
      "display" : "Linezolid"
    },
    {
      "code" : "C09AA03",
      "display" : "Lisinopril"
    },
    {
      "code" : "C09BA03",
      "display" : "Lisinopril + Idroclorotiazide"
    },
    {
      "code" : "R06AX13",
      "display" : "Loratadina"
    },
    {
      "code" : "C09CA01",
      "display" : "Losartan"
    },
    {
      "code" : "C09DA01",
      "display" : "Losartan + Idroclorotiazide"
    },
    {
      "code" : "C10AA02",
      "display" : "Lovastatina"
    },
    {
      "code" : "A02AD02",
      "display" : "Magaldrato"
    },
    {
      "code" : "C08CA11",
      "display" : "Manidipina"
    },
    {
      "code" : "L02AB01",
      "display" : "Megestrolo"
    },
    {
      "code" : "M01AC06",
      "display" : "Meloxicam"
    },
    {
      "code" : "N06DX01",
      "display" : "Memantina"
    },
    {
      "code" : "A07EC02",
      "display" : "Mesalazina"
    },
    {
      "code" : "A10BA02",
      "display" : "Metformina"
    },
    {
      "code" : "A10BD02",
      "display" : "Metformina + Glibenclamide"
    },
    {
      "code" : "H02AB04",
      "display" : "Metilprednisolone"
    },
    {
      "code" : "A03FA01",
      "display" : "Metoclopramide"
    },
    {
      "code" : "C07AB02",
      "display" : "Metoprololo"
    },
    {
      "code" : "L04AX03",
      "display" : "Metotrexato"
    },
    {
      "code" : "P01AB01",
      "display" : "Metronidazolo"
    },
    {
      "code" : "A16AX06",
      "display" : "Micofenolato mofetile"
    },
    {
      "code" : "N06AX11",
      "display" : "Miglustat"
    },
    {
      "code" : "R03DC03",
      "display" : "Mirtazapina"
    },
    {
      "code" : "N02AA01",
      "display" : "Montelukast"
    },
    {
      "code" : "J01MA14",
      "display" : "Morfina solfato"
    },
    {
      "code" : "C02AC05",
      "display" : "Moxifloxacina"
    },
    {
      "code" : "N07BB04",
      "display" : "Moxonidina"
    },
    {
      "code" : "M01AE02",
      "display" : "Naltrexone"
    },
    {
      "code" : "C07AB12",
      "display" : "Naprossene"
    },
    {
      "code" : "C07BB12",
      "display" : "Nebivololo"
    },
    {
      "code" : "C08CA05",
      "display" : "Nebivololo + Idroclorotiazide"
    },
    {
      "code" : "M01AX17",
      "display" : "Nifedipina"
    },
    {
      "code" : "A16AX04",
      "display" : "Nimesulide"
    },
    {
      "code" : "J01XE01",
      "display" : "Nitisinone"
    },
    {
      "code" : "C01DA02",
      "display" : "Nitrofurantoina"
    },
    {
      "code" : "J01MA06",
      "display" : "Nitroglicerina"
    },
    {
      "code" : "H01CB02",
      "display" : "Norfloxacina"
    },
    {
      "code" : "N05AH03",
      "display" : "Octreotide"
    },
    {
      "code" : "C09DX03",
      "display" : "Olanzapina"
    },
    {
      "code" : "C09CA08",
      "display" : "Olmesartan medoximil + Amlodipina + Idroclorotiazide"
    },
    {
      "code" : "C09DB02",
      "display" : "Olmesartan medoxomil"
    },
    {
      "code" : "C09DA08",
      "display" : "Olmesartan medoxomil + Amlodipina"
    },
    {
      "code" : "C10AX06",
      "display" : "Olmesartan medoxomil + Idroclorotiazide"
    },
    {
      "code" : "A02BC01",
      "display" : "Omega polienoici (esteri etilici di acidi grassi polinsaturi)"
    },
    {
      "code" : "A04AA01",
      "display" : "Omeprazolo"
    },
    {
      "code" : "G04BD04",
      "display" : "Ondansetrone"
    },
    {
      "code" : "N02AA05",
      "display" : "Ossibutinina cloridrato"
    },
    {
      "code" : "N02AA55",
      "display" : "Ossicodone (oxicodone) cloridrato"
    },
    {
      "code" : "N02AJ17",
      "display" : "Ossicodone (oxicodone) cloridrato/naloxone cloridrato diidrato"
    },
    {
      "code" : "N03AF02",
      "display" : "Ossicodone (oxicodone) cloridrato/paracetamolo"
    },
    {
      "code" : "N05AX13",
      "display" : "Oxcarbazepina"
    },
    {
      "code" : "A02BC02",
      "display" : "Paliperidone"
    },
    {
      "code" : "H05BX02",
      "display" : "Pantoprazolo"
    },
    {
      "code" : "N02AJ06",
      "display" : "Paracalcitolo"
    },
    {
      "code" : "A07AA06",
      "display" : "Paracetamolo+Codeina fosfato"
    },
    {
      "code" : "N06AB05",
      "display" : "Paromicina"
    },
    {
      "code" : "C09AA04",
      "display" : "Paroxetina"
    },
    {
      "code" : "C09BB04",
      "display" : "Perindopril"
    },
    {
      "code" : "C09BA04",
      "display" : "Perindopril + Amlodipina"
    },
    {
      "code" : "C09BX01",
      "display" : "Perindopril + indapamide"
    },
    {
      "code" : "A10BG03",
      "display" : "Perindopril + Indapamide + Amlodipina"
    },
    {
      "code" : "A10BD05",
      "display" : "Pioglitazone"
    },
    {
      "code" : "J01CA12",
      "display" : "Pioglitazone + Metformina"
    },
    {
      "code" : "J01CR05",
      "display" : "Piperacillina"
    },
    {
      "code" : "M01AC01",
      "display" : "Piperacillina + Tazobactam"
    },
    {
      "code" : "J02AC04",
      "display" : "Piroxicam"
    },
    {
      "code" : "C03DA02",
      "display" : "Posaconazolo"
    },
    {
      "code" : "N04BC05",
      "display" : "Potassio canrenoato"
    },
    {
      "code" : "B01AC22",
      "display" : "Pramipexolo"
    },
    {
      "code" : "C10AA03",
      "display" : "Prasugrel"
    },
    {
      "code" : "H02AB07",
      "display" : "Pravastatina"
    },
    {
      "code" : "N02BF02",
      "display" : "Prednisone"
    },
    {
      "code" : "G03DA04",
      "display" : "Pregabalin"
    },
    {
      "code" : "C01BC03",
      "display" : "Progesterone"
    },
    {
      "code" : "N05AH04",
      "display" : "Propafenone"
    },
    {
      "code" : "C09AA06",
      "display" : "Quetiapina"
    },
    {
      "code" : "C09BA06",
      "display" : "Quinapril"
    },
    {
      "code" : "A02BC04",
      "display" : "Quinapril + Idroclorotiazide"
    },
    {
      "code" : "G03XC01",
      "display" : "Rabeprazolo"
    },
    {
      "code" : "C09AA05",
      "display" : "Raloxifene"
    },
    {
      "code" : "C09BX03",
      "display" : "Ramipril"
    },
    {
      "code" : "C09BA05",
      "display" : "Ramipril + Amlodipina + Idroclorotiazide"
    },
    {
      "code" : "C09BB07",
      "display" : "Ramipril + Idroclorotiazide"
    },
    {
      "code" : "C01EB18",
      "display" : "Ramipril/Amlodipina"
    },
    {
      "code" : "N04BD02",
      "display" : "Ranolazina"
    },
    {
      "code" : "A10BX02",
      "display" : "Rasagilina"
    },
    {
      "code" : "N07XX02",
      "display" : "Repaglinide"
    },
    {
      "code" : "N05AX08",
      "display" : "Riluzolo"
    },
    {
      "code" : "N06DA03",
      "display" : "Risperidone"
    },
    {
      "code" : "N02CC04",
      "display" : "Rivastigmina"
    },
    {
      "code" : "N04BC04",
      "display" : "Rizatriptan"
    },
    {
      "code" : "C10AA07",
      "display" : "Ropinirolo"
    },
    {
      "code" : "C10BX09",
      "display" : "Rosuvastatina"
    },
    {
      "code" : "C10BA06",
      "display" : "Rosuvastatina (sale di calcio) + Amlodipina"
    },
    {
      "code" : "R06AX28",
      "display" : "Rosuvastatina + Ezetimibe"
    },
    {
      "code" : "R03AC02",
      "display" : "Rupatadina"
    },
    {
      "code" : "R03AL02",
      "display" : "Salbutamolo"
    },
    {
      "code" : "R03AC12",
      "display" : "Salbutamolo + Ipratropio bromuro"
    },
    {
      "code" : "R03AK06",
      "display" : "Salmeterolo"
    },
    {
      "code" : "A16AX07",
      "display" : "Salmeterolo/fluticasone"
    },
    {
      "code" : "N04BD01",
      "display" : "Sapropterina"
    },
    {
      "code" : "N06AB06",
      "display" : "Selegilina"
    },
    {
      "code" : "V03AE02",
      "display" : "Sertralina"
    },
    {
      "code" : "G04BE03",
      "display" : "Sevelamer"
    },
    {
      "code" : "G04CA04",
      "display" : "Sildenafil"
    },
    {
      "code" : "C10AA01",
      "display" : "Silodosina"
    },
    {
      "code" : "A10BH01",
      "display" : "Simvastatina"
    },
    {
      "code" : "A10BD07",
      "display" : "Sitagliptin"
    },
    {
      "code" : "B05BB01",
      "display" : "Sitagliptin + Metformina"
    },
    {
      "code" : "M05BA06",
      "display" : "Sodio cloruro"
    },
    {
      "code" : "M05BA07",
      "display" : "Sodio ibandronato"
    },
    {
      "code" : "G04BD08",
      "display" : "Sodio risedronato"
    },
    {
      "code" : "C07AA07",
      "display" : "Solifenacina"
    },
    {
      "code" : "J01FA02",
      "display" : "Sotalolo"
    },
    {
      "code" : "C03DA01",
      "display" : "Spiramicina"
    },
    {
      "code" : "A02BX02",
      "display" : "Spironolattone"
    },
    {
      "code" : "N02CC01",
      "display" : "Sucralfato"
    },
    {
      "code" : "D11AH01",
      "display" : "Sumatriptan"
    },
    {
      "code" : "L04AD02",
      "display" : "Tacrolimus"
    },
    {
      "code" : "G04BE08",
      "display" : "Tadalafil"
    },
    {
      "code" : "L02BA01",
      "display" : "Tamoxifene"
    },
    {
      "code" : "G04CA02",
      "display" : "Tamsulosina"
    },
    {
      "code" : "J01XA02",
      "display" : "Teicoplanina"
    },
    {
      "code" : "C09CA07",
      "display" : "Telmisartan"
    },
    {
      "code" : "C09DA07",
      "display" : "Telmisartan + Idroclorotiazide"
    },
    {
      "code" : "L01AX03",
      "display" : "Temozolomide"
    },
    {
      "code" : "G04CA03",
      "display" : "Terazosina"
    },
    {
      "code" : "C02CA",
      "display" : "Terbinafina"
    },
    {
      "code" : "D01BA02",
      "display" : "Teriflunomide"
    },
    {
      "code" : "L04AA31",
      "display" : "Teriparatide"
    },
    {
      "code" : "H05AA02",
      "display" : "Tetrabenazina"
    },
    {
      "code" : "N07XX06",
      "display" : "Tibolone"
    },
    {
      "code" : "G03CX01",
      "display" : "Ticlopidina"
    },
    {
      "code" : "B01AC05",
      "display" : "Timololo"
    },
    {
      "code" : "S01ED01",
      "display" : "Tiotropio"
    },
    {
      "code" : "R03BB04",
      "display" : "Tobramicina"
    },
    {
      "code" : "J01GB01",
      "display" : "Tolvaptan"
    },
    {
      "code" : "C03XA01",
      "display" : "Topiramato"
    },
    {
      "code" : "N03AX11",
      "display" : "Torasemide"
    },
    {
      "code" : "C03CA04",
      "display" : "Tramadolo cloridrato"
    },
    {
      "code" : "N02AX02",
      "display" : "Trandolapril"
    },
    {
      "code" : "C09AA10",
      "display" : "Travoprost"
    },
    {
      "code" : "S01EE04",
      "display" : "Travoprost + Timololo"
    },
    {
      "code" : "J05AB11",
      "display" : "Valaciclovir"
    },
    {
      "code" : "J05AB14",
      "display" : "Valganciclovir"
    },
    {
      "code" : "C09CA03",
      "display" : "Valsartan"
    },
    {
      "code" : "C09DA03",
      "display" : "Valsartan + Idroclorotiazide"
    },
    {
      "code" : "G04BE09",
      "display" : "Vardenafil"
    },
    {
      "code" : "N06AX16",
      "display" : "Venlafaxina"
    },
    {
      "code" : "C08DA01",
      "display" : "Verapamil"
    },
    {
      "code" : "A10BH02",
      "display" : "Vildagliptin"
    },
    {
      "code" : "A10BD08",
      "display" : "Vildagliptin + Metformina"
    },
    {
      "code" : "L01CA04",
      "display" : "Vinorelbina"
    },
    {
      "code" : "J02AC03",
      "display" : "Voriconazolo"
    },
    {
      "code" : "C09AA15",
      "display" : "Zofenopril"
    },
    {
      "code" : "C09BA15",
      "display" : "Zofenopril + Idroclorotiazide"
    },
    {
      "code" : "N02CC03",
      "display" : "Zolmitriptan"
    },
    {
      "code" : "N03AX15",
      "display" : "Zonisamide"
    }
  ]
}

```
