# hl7.fhir.it.lab-report#0.2.0: HL7 FHIR Implementation Guide Laboratory Report

## Pages

* [Home](index.md)
* [Modelli Logici](modelliLogici.md)
* [Downloads](downloads.md)
* [Artifacts Summary](artifacts.md)

## Resources

### CodeSystems

* [HL7 Italia - AdministrativeGender (translation)](CodeSystem-administrative-gender.md)
* [AIFA - Autorizzazione Immissione in Commercio](CodeSystem-aifa-aic.md)
* [MDS - ASL](CodeSystem-cs-asl.md)
* [MDS - ID Strutture Interne di Ricovero](CodeSystem-cs-mds-idStruttureInterne.md)
* [ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG)](CodeSystem-dug.md)
* [ISTAT - Comuni](CodeSystem-istat-comuni.md)
* [ISTAT - Continente](CodeSystem-istat-continente.md)
* [ISTAT - Classificazione dei titoli di studio italiani](CodeSystem-istat-ctsi03.md)
* [ISTAT - Classificazione delle professioni](CodeSystem-istat-professioni.md)
* [ISTAT - Ripartizione Geografica](CodeSystem-istat-ripartizione-geografica.md)
* [ISTAT - Stato Civile](CodeSystem-istat-statoCivile.md)
* [ISTAT - Unità Amministrative Territoriali](CodeSystem-istat-unitaAmministrativeTerritoriali.md)
* [ISTAT - Unita Amministrative Territoriali Estere](CodeSystem-istat-unitaAmministrativeTerritorialiEstere.md)
* [HL7 Italia - HL7 V3 RoleCode (estensione)](CodeSystem-it-V3RoleCode.md)
* [HL7 Italia - Tipi di identificatore](CodeSystem-it-identifier-type.md)
* [HL7 Italia - Tipo di Entità](CodeSystem-it-tipoEntita.md)
* [MDS - Tipo di Struttura per Srutture di ricovero](CodeSystem-mds-tipo-struttura.md)
* [MDS - Strutture di Ricovero](CodeSystem-minsan-hsp.md)
* [MDS - Codici Regioni / PPAA](CodeSystem-minsan-regione.md)
* [ISTAT - Province](CodeSystem-province-istat.md)
* [HL7 Italia - v3 Code System MaritalStatus (translation)](CodeSystem-v3-MaritalStatus.md)

### ValueSets

* [Identificativi per codici STP regionali](ValueSet-URI-idStp.md)
* [Tipo identificatore](ValueSet-VstipoIdentificatore.md)
* [Additivo Campione](ValueSet-additivo-campione-it.md)
* [AIFA AIC](ValueSet-aifa-aic.md)
* [Container Campione](ValueSet-campione-container-lab-it.md)
* [ISO 3166 - EHIC Country Codes](ValueSet-iso-ehicCountryCode.md)
* [ISTAT - Cittadinanza](ValueSet-istat-cittadinanza.md)
* [ISTAT - Comuni](ValueSet-istat-comune.md)
* [ISTAT - DUG](ValueSet-istat-dug.md)
* [ISTAT - Comune/Stato di Nascita](ValueSet-istat-luogoNascita.md)
* [ISTAT - Professioni](ValueSet-istat-professione.md)
* [ISTAT - Province](ValueSet-istat-provincia.md)
* [ISTAT - Stati](ValueSet-istat-stato.md)
* [ISTAT - Stato Civile](ValueSet-istat-statoCivile-vs.md)
* [ISTAT - Titolo Studio](ValueSet-istat-titoloStudio.md)
* [Codice Richiesta esame di Laboratorio [LOINC]](ValueSet-lab-orderCodes-it-lab.md)
* [MDS - ASL](ValueSet-minsan-asl.md)
* [MDS - Esenzioni](ValueSet-minsan-esenzioni.md)
* [MDS - ID Aziende Ospedaliere](ValueSet-minsan-idAziendeOspedaliere.md)
* [MDS - ID Strutture Ricovero](ValueSet-minsan-idStrutture.md)
* [MDS - ID Strutture Interne di Ricovero](ValueSet-minsan-idStruttureInterne.md)
* [MDS - Codici Regionali](ValueSet-minsan-regione.md)
* [Tipo medico di famiglia](ValueSet-mmgOrPls.md)
* [EHIC Personal ID (system IDs - oid)](ValueSet-oid-ehicPersonalId.md)
* [Risultato osservazione codificato - microorganismo IPS di SNOMED CT](ValueSet-results-microorganism-snomed-ct-ips-free-set.md)
* [Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT](ValueSet-results-observation-bloodgroup.md)
* [Risultato osservazione codificato -  presenza/assenza IPS di SNOMED CT](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md)
* [Tipo Osservazione](ValueSet-risultato-osservazione.md)
* [Sezioni Composition Lab Report](ValueSet-sezione-referto-laboratorio.md)
* [Stato Civile](ValueSet-statoCivile.md)
* [Tipo campione](ValueSet-tipo-campione-lab-it.md)
* [Tipo Campione](ValueSet-tipo-campione.md)
* [Tipo certificatore](ValueSet-tipoCertificatore.md)
* [Tipo organizzazione socio-sanitaria](ValueSet-tipoOrgSocioSanitaria.md)
* [Tipo organizzazione (esempio)](ValueSet-tipoOrganizzazione.md)
* [Identificativi regionali per ASL (3 char)](ValueSet-uri-idAslRegione.md)
* [Identificativi per codici ENI regionali](ValueSet-uri-idEni.md)
* [Risultato osservazione codificato gruppo sanguigno](ValueSet-valueset-observation-value-bloodgroup.md)
* [Risultato osservazione codificato microorganismi](ValueSet-valueset-observation-value-microorganism.md)
* [Risultato osservazione codificato presenza/assenza](ValueSet-valueset-observation-value-presence-absence.md)
* [Observation status code](ValueSet-valueset-status-obs-it.md)
* [Risultato osservazione codificato](ValueSet-valueset-valuecodeableconcept-obs-it.md)
* [Anagrafi Regionali](ValueSet-vs-anagrafi-regionali.md)
* [WHO ICD-9-CM](ValueSet-who-icd9cm.md)

### Logicals

* [A.1.5 - Autore](StructureDefinition-Autore.md)
* [A.4 - Informazioni sul Campione](StructureDefinition-Campione.md)
* [A.1.4 - Informazioni Destinatario](StructureDefinition-Destinatario.md)
* [A.1.6 - Firmatario](StructureDefinition-Firmatario.md)
* [A.6 - Organizer](StructureDefinition-Organizer.md)
* [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)
* [A.2,A.3 - Richiesta](StructureDefinition-Richiesta.md)
* [A.5 - Risultato](StructureDefinition-Risultato.md)
* [A.1.1, A.1.2 - Soggetto delle cure](StructureDefinition-SoggettoCura.md)
* [A.1.7 - Validatore](StructureDefinition-Validatore.md)

### Complex-type Profiles

* [Address - ITA](StructureDefinition-address-it.md)
* [Quantity - Lab Report](StructureDefinition-quantity-it-lab.md)

### Resource Profiles

* [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md)
* [Composition - Lab Report](StructureDefinition-composition-it-lab.md)
* [Device - Lab Report](StructureDefinition-device-it-lab.md)
* [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md)
* [Encounter - Lab Report](StructureDefinition-encounter-it-lab.md)
* [Location - Lab Report](StructureDefinition-location-it-lab.md)
* [Media - Lab Report](StructureDefinition-media-it-lab.md)
* [Observation Document - Lab Report](StructureDefinition-observation-doc-it-lab.md)
* [Observation battery - Lab Report](StructureDefinition-observation-grouping-it-lab.md)
* [Observation - Lab Report](StructureDefinition-observation-it-lab.md)
* [Organization - Lab Report](StructureDefinition-organization-it-lab.md)
* [Organization operatore sanitario/socio sanitario - Lab Report](StructureDefinition-organizationOperatore-it-lab.md)
* [Patient - Lab Report](StructureDefinition-patient-it-lab.md)
* [Practitioner - Lab Report](StructureDefinition-practitioner-it-lab.md)
* [PractitionerRole MMG/PLS - Lab Report](StructureDefinition-practitionerrole-MMGPLS-it-lab.md)
* [PractitionerRole - Lab Report](StructureDefinition-practitionerrole-it-lab.md)
* [ServiceRequest - Lab Report](StructureDefinition-servicerequest-it-lab.md)
* [Specimen - Lab Report](StructureDefinition-specimen-it-lab.md)
* [Substance (specimen additive) - Lab Report](StructureDefinition-substance-additive-specimen-it-lab.md)

### Extensions

* [DUG (Denominazione Urbanistica Generica)](StructureDefinition-address-dug.md)
* [IndirizzoUfficiale](StructureDefinition-address-official.md)
* [Address Birth Place](StructureDefinition-birth-place-ita.md)
* [DataEnterer](StructureDefinition-composition-dataenterer-it.md)
* [TempoCompilazione](StructureDefinition-dataEnterer-time.md)
* [Codice comune e/o stato di nascita](StructureDefinition-patient-codeableBirthPlace.md)
* [Professione del paziente](StructureDefinition-patient-occupation-it.md)
* [Titolo di Studio del paziente](StructureDefinition-patient-qualification-it.md)
* [Certificazione](StructureDefinition-recordCertification.md)

### ConceptMaps

* [Mapping fra VS HL7 e Tabella ISTAT Stato Civile](ConceptMap-ConceptMap-statoCivile.md)

### ImplementationGuides

* [HL7 FHIR Implementation Guide Laboratory Report](index.md)

### Examples

* [Bundle-Lab-Esempio-2 (Bundle)](Bundle-Bundle-Lab-Esempio-2.md)
* [Bundle-Lab-Esempio (Bundle)](Bundle-Bundle-Lab-Esempio.md)
* [Referto di Laboratorio (Composition)](Composition-2ae95a5c-9094-41a3-a437-ce6d34c55a54.md)
* [168d4960-0a0b-43af-8025-180f0965f324 (Device)](Device-168d4960-0a0b-43af-8025-180f0965f324.md)
* [56f19992-e73e-45b5-bbdd-6d9aeb60b15a (DiagnosticReport)](DiagnosticReport-56f19992-e73e-45b5-bbdd-6d9aeb60b15a.md)
* [7b06368c-7089-4f66-acc8-29e1fcbd31f6 (Encounter)](Encounter-7b06368c-7089-4f66-acc8-29e1fcbd31f6.md)
* [Policlinico di Roma (Location)](Location-f148e54a-2046-4534-b9e9-54e7e9632224.md)
* [059927b1-7e17-409e-ae60-68cc3c0b3aea (Media)](Media-059927b1-7e17-409e-ae60-68cc3c0b3aea.md)
* [5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c (Observation)](Observation-5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c.md)
* [7e2f354b-de83-4472-bd07-1571cdb50fde (Observation)](Observation-7e2f354b-de83-4472-bd07-1571cdb50fde.md)
* [9474efca-8c8a-436d-a1a4-5706a1dd057a (Observation)](Observation-9474efca-8c8a-436d-a1a4-5706a1dd057a.md)
* [Observation-Lab-Esempio-Group (Observation)](Observation-Observation-Lab-Esempio-Group.md)
* [a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244 (Observation)](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244.md)
* [a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245 (Observation)](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245.md)
* [a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246 (Observation)](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246.md)
* [a8a27a81-4543-45a9-8859-fa17053d963e (Observation)](Observation-a8a27a81-4543-45a9-8859-fa17053d963e.md)
* [Azienda Sanitara Locale Roma 1 (Organization)](Organization-5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8.md)
* [AZIENDA U.S.L. VALLE D'AOSTA (Organization)](Organization-ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8.md)
* [8472931c-fbd0-437b-9ed1-4f66472c78b5 (Patient)](Patient-8472931c-fbd0-437b-9ed1-4f66472c78b5.md)
* [134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c (Practitioner)](Practitioner-134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c.md)
* [dc5842a1-83b6-43c7-b063-75ae989b803d (Practitioner)](Practitioner-dc5842a1-83b6-43c7-b063-75ae989b803d.md)
* [dc5842a1-83b6-43c7-b063-75ae989b803c (PractitionerRole)](PractitionerRole-dc5842a1-83b6-43c7-b063-75ae989b803c.md)
* [dc5842a1-83b6-43c7-b063-75ae989b803k (PractitionerRole)](PractitionerRole-dc5842a1-83b6-43c7-b063-75ae989b803k.md)
* [463ae6fe-60d4-4b38-84b3-1008e0925678 (ServiceRequest)](ServiceRequest-463ae6fe-60d4-4b38-84b3-1008e0925678.md)
* [168d4960-0a0b-43af-8025-180f0965f325 (Specimen)](Specimen-168d4960-0a0b-43af-8025-180f0965f325.md)
* [168d4960-0a0b-43af-8025-180f0965f326 (Substance)](Substance-168d4960-0a0b-43af-8025-180f0965f326.md)
