# Home - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ImplementationGuide/hl7.fhir.it.lab-report | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:HL7ITLabReport |

### Scopo

L'obiettivo della seguente guida è quello di definire, secondo lo standard HL7 FHIR versione R4, le specifiche per l'implementazione dei profili che verranno utilizzati nel referto di medicina di laboratorio nel contesto italiano.

### Definizione del Referto di Medicina di Laboratorio

Il referto di laboratorio appartiene al nucleo minimo dei documenti del Fascicolo Sanitario Elettronico. Ai sensi dell'articolo 27, comma 1, lettera d), del decreto n. 178 del 29 settembre 2015, il referto di laboratorio e' il documento redatto dal medico di medicina di laboratorio. Il contenuto informativo del Referto di Laboratorio è disciplinato all'art.2 dal Decreto del 18 maggio 2022 del Ministero della Salute ([Decreto Contenuti](https://www.gazzettaufficiale.it/eli/id/2022/07/11/22A03960)).

### Contesto

La guida intende fornire delle specifiche adeguate al contesto italiano secondo lo standard HL7 FHIR, per assicurare l’accuratezza dei risultati degli esami di laboratorio e la trasmissione degli stessi, al paziente o ad altra figura professionale, in modo chiaro e corretto. Questa guida implementativa è stata creata per descrivere in modo più completo gli elementi standard necessari per supportare lo scambio sia semantico che sintattico di informazioni inerenti al referto di laboratorio e viene sviluppata considerando come soggetto la risorsa Patient.

La guida può essere utilizzata per descrivere i risultati di laboratorio nei settori chiave della diagnostica in vitro, come:

* biochimica clinica
* ematologia
* medicina trasfusionale
* microbiologia
* immunologia.

### Navigazione

Questa guida implementativa utilizza come metodo di pubblicazione i tool web-based offerti dallo standard FHIR. Ciò consente una facile navigazione tra le varie risorse, i data type, i set di valori e altri componenti offerti dallo standard FHIR. Questo approccio consente inoltre agli implementatori di accedere facilmente alle informazioni necessarie per lo sviluppo di sistemi di interoperabilità.

### Dipendenze







### Details

#### Cross-Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.it.lab-report.r4)](package.r4.tgz) and [R4B (hl7.fhir.it.lab-report.r4b)](package.r4b.tgz) are available.

### Autori e contributori

| | | | |
| :--- | :--- | :--- | :--- |
| Autore | Leonardo Alcaro | HL7 Italia | leonardo.alcaro@teamdigitale.governo.it |
| Autore | Mario Sicuranza | HL7 Italia | mario.sicuranza@icar.cnr.it |
| Autore | Davide Spanu | EY Advisory S.p.A. | davide.spanu@it.ey.com |
| Autore | Valeria Cesaro' | EY Advisory S.p.A. | valeria.cesaro@it.ey.com |
| Autore | Maria Giovanna Antida Preziosi | SOGEI | mpreziosi@sogei.it |
| Contributore | Giorgio Cangioli | HL7 Italia | giorgio.cangioli@gmail.com |

### Intellectual Property Statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [contactRole2](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0131.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md) and [Patient/8472931c-fbd0-437b-9ed1-4f66472c78b5](Patient-8472931c-fbd0-437b-9ed1-4f66472c78b5.md)


* ISO Maintains the copyright on the country codes, and controls it's use carefully. For futher details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.3.0/CodeSystem-ISO3166Part1.html): [AddressItBase](StructureDefinition-address-it.md), [Autore](StructureDefinition-Autore.md)...Show 105 more,[BirthPlaceIta](StructureDefinition-birth-place-ita.md),[BundleRefertoLabIt](StructureDefinition-bundle-it-lab.md),[CSItTipoEntita](CodeSystem-it-tipoEntita.md),[Campione](StructureDefinition-Campione.md),[CompositionRefertoLabIt](StructureDefinition-composition-it-lab.md),[CsAifaAic](CodeSystem-aifa-aic.md),[CsContinente](CodeSystem-istat-continente.md),[CsIstatComuni](CodeSystem-istat-comuni.md),[CsIstatDug](CodeSystem-dug.md),[CsIstatEstere](CodeSystem-istat-unitaAmministrativeTerritorialiEstere.md),[CsIstatProfessioni](CodeSystem-istat-professioni.md),[CsIstatStatoCivile](CodeSystem-istat-statoCivile.md),[CsIstatTitoliStudio](CodeSystem-istat-ctsi03.md),[CsIstatUnitaAmministrativeTerritoriali](CodeSystem-istat-unitaAmministrativeTerritoriali.md),[CsItIdentifierType](CodeSystem-it-identifier-type.md),[CsItRoleCode](CodeSystem-it-V3RoleCode.md),[CsMDSASL](CodeSystem-cs-asl.md),[CsMDSIdStruttureInterne](CodeSystem-cs-mds-idStruttureInterne.md),[CsMDStruttureRicovero](CodeSystem-minsan-hsp.md),[CsMinSanRegioni](CodeSystem-minsan-regione.md),[CsProvinceISTAT](CodeSystem-province-istat.md),[CsRipartizionegeografica](CodeSystem-istat-ripartizione-geografica.md),[CsSupItAdministrativeGender](CodeSystem-administrative-gender.md),[CsSupItV3MaritalStatus](CodeSystem-v3-MaritalStatus.md),[CsTipoStruttura](CodeSystem-mds-tipo-struttura.md),[Destinatario](StructureDefinition-Destinatario.md),[DeviceRefertoLabIt](StructureDefinition-device-it-lab.md),[DiagnosticReportRefertoLabIt](StructureDefinition-diagnosticreport-it-lab.md),[EncounterRefertoLabIt](StructureDefinition-encounter-it-lab.md),[ExtCodeableBirthPlace](StructureDefinition-patient-codeableBirthPlace.md),[ExtDataEnterer](StructureDefinition-composition-dataenterer-it.md),[ExtDataEntererTIME](StructureDefinition-dataEnterer-time.md),[ExtDug](StructureDefinition-address-dug.md),[ExtProfessionePaziente](StructureDefinition-patient-occupation-it.md),[ExtRecordCertification](StructureDefinition-recordCertification.md),[ExtTitoloStudioPaziente](StructureDefinition-patient-qualification-it.md),[Firmatario](StructureDefinition-Firmatario.md),[HL7ITLabReport](index.md),[HL7_ISTAT_StatoCivile](ConceptMap-ConceptMap-statoCivile.md),[LabOrderCodes](ValueSet-lab-orderCodes-it-lab.md),[LocationRefertoLabIt](StructureDefinition-location-it-lab.md),[MediaRefertoLabIt](StructureDefinition-media-it-lab.md),[ObservationDocRefertoLabIt](StructureDefinition-observation-doc-it-lab.md),[ObservationGroupingRefertoLabIt](StructureDefinition-observation-grouping-it-lab.md),[ObservationRefertoLabIt](StructureDefinition-observation-it-lab.md),[ObservationStatusCodeLabReport](ValueSet-valueset-status-obs-it.md),[OfficialAddress](StructureDefinition-address-official.md),[OrganizationOperatoreSanitarioRefertoLabIt](StructureDefinition-organizationOperatore-it-lab.md),[OrganizationRefertoLabIt](StructureDefinition-organization-it-lab.md),[Organizer](StructureDefinition-Organizer.md),[PatientRefertoLabIt](StructureDefinition-patient-it-lab.md),[PractitionerRefertoLabIt](StructureDefinition-practitioner-it-lab.md),[PractitionerRoleMMGPLSRefertoLabIt](StructureDefinition-practitionerrole-MMGPLS-it-lab.md),[PractitionerRoleRefertoLabIt](StructureDefinition-practitionerrole-it-lab.md),[QuantityLab](StructureDefinition-quantity-it-lab.md),[RefertoLaboratorio](StructureDefinition-RefertoLaboratorio.md),[ResultLabEhn](StructureDefinition-Risultato.md),[Richiesta](StructureDefinition-Richiesta.md),[ServiceRequestRefertoLabIt](StructureDefinition-servicerequest-it-lab.md),[SoggettoCura](StructureDefinition-SoggettoCura.md),[SpecimenAdditiveSubstanceRefertoLabIt](StructureDefinition-substance-additive-specimen-it-lab.md),[SpecimenRefertoLabIt](StructureDefinition-specimen-it-lab.md),[UriIdEni](ValueSet-uri-idEni.md),[ValidatorLabEhn](StructureDefinition-Validatore.md),[VsAic](ValueSet-aifa-aic.md),[VsAnagrafiRegionali](ValueSet-vs-anagrafi-regionali.md),[VsEHICCountryCodes](ValueSet-iso-ehicCountryCode.md),[VsEHICPersonalIdOid](ValueSet-oid-ehicPersonalId.md),[VsGruppoSanguigno](ValueSet-results-observation-bloodgroup.md),[VsIcd9cm](ValueSet-who-icd9cm.md),[VsIstatCittadinanza](ValueSet-istat-cittadinanza.md),[VsIstatComune](ValueSet-istat-comune.md),[VsIstatDug](ValueSet-istat-dug.md),[VsIstatLuogoNascita](ValueSet-istat-luogoNascita.md),[VsIstatProfessionePaziente](ValueSet-istat-professione.md),[VsIstatProvincia](ValueSet-istat-provincia.md),[VsIstatStato](ValueSet-istat-stato.md),[VsIstatStatoCivile](ValueSet-istat-statoCivile-vs.md),[VsIstatTitoloStudio](ValueSet-istat-titoloStudio.md),[VsLabSpecimenAdditiveIt](ValueSet-additivo-campione-it.md),[VsLabSpecimenContainerIt](ValueSet-campione-container-lab-it.md),[VsLabSpecimenTypesIt](ValueSet-tipo-campione-lab-it.md),[VsMicroorganismiOsservazioni](ValueSet-results-microorganism-snomed-ct-ips-free-set.md),[VsMinisteroSaluteAsl](ValueSet-minsan-asl.md),[VsMinisteroSaluteEsenzioni](ValueSet-minsan-esenzioni.md),[VsMinisteroSaluteIdAziendeOspedaliere](ValueSet-minsan-idAziendeOspedaliere.md),[VsMinisteroSaluteIdStrutture](ValueSet-minsan-idStrutture.md),[VsMinisteroSaluteIdStruttureInterne](ValueSet-minsan-idStruttureInterne.md),[VsMinsanregione](ValueSet-minsan-regione.md),[VsMmgPlsRoles](ValueSet-mmgOrPls.md),[VsObservationBloodGroup](ValueSet-valueset-observation-value-bloodgroup.md),[VsObservationMicroorganismi](ValueSet-valueset-observation-value-microorganism.md),[VsObservationPresenzaAssenza](ValueSet-valueset-observation-value-presence-absence.md),[VsObservationValueCodeableConcept](ValueSet-valueset-valuecodeableconcept-obs-it.md),[VsResultsLaboratoryObservation](ValueSet-risultato-osservazione.md),[VsResultsPresenceAbsenceSnomedCtIpsFreeSet](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md),[VsSezioniRefertoLaboratorio](ValueSet-sezione-referto-laboratorio.md),[VsStatoCivile](ValueSet-statoCivile.md),[VsTipoCampione](ValueSet-tipo-campione.md),[VsTipoCertificatore](ValueSet-tipoCertificatore.md),[VsTipoOrgSocioSanitaria](ValueSet-tipoOrgSocioSanitaria.md),[VsTipoOrganizzazione](ValueSet-tipoOrganizzazione.md),[VsURIIdStp](ValueSet-URI-idStp.md),[VsUriIdAslRegione](ValueSet-uri-idAslRegione.md)and[VstipoIdentificatore](ValueSet-VstipoIdentificatore.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/5.3.0/CodeSystem-v3-ucum.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 8 more,[Observation/5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c](Observation-5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c.md),[Observation/7e2f354b-de83-4472-bd07-1571cdb50fde](Observation-7e2f354b-de83-4472-bd07-1571cdb50fde.md),[Observation/9474efca-8c8a-436d-a1a4-5706a1dd057a](Observation-9474efca-8c8a-436d-a1a4-5706a1dd057a.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246.md),[Observation/a8a27a81-4543-45a9-8859-fa17053d963e](Observation-a8a27a81-4543-45a9-8859-fa17053d963e.md)and[QuantityLab](StructureDefinition-quantity-it-lab.md)


* The information in the various pages of the WHO web site is issued by the World Health Organization for general distribution. The information presented is protected under the Berne Convention for the Protection of Literature and Artistic works, under other international conventions and under national laws on copyright and neighbouring rights. Extracts of the information in the web site may be reviewed, reproduced or translated for research or private study but not for sale or for use in conjunction with commercial purposes. Any use of information in the web site should be accompanied by an acknowledgment of WHO as the source, citing the uniform resource locator (URL) of the article. Reproduction or translation of substantial portions of the web site, or any use other than for educational or other non-commercial purposes, require explicit, prior authorization in writing. Applications and enquiries should be addressed to the programme responsible for the page used. The designations employed and the presentation of the material in this publication do not imply the expression of any opinion whatsoever on the part of the World Health Organization concerning the legal status of any country, territory, city or area or of its authorities, or concerning the delimitation of its frontiers or boundaries. Dotted and dashed lines on maps represent approximate border lines for which there may not yet be full agreement. The mention of specific companies or of certain manufacturers' products does not imply that they are endorsed or recommended by the World Health Organization in preference to others of a similar nature that are not mentioned. Errors and omissions excepted, the names of proprietary products are distinguished by initial capital letters. The World Health Organization does not warrant that the information contained in the web site is complete and correct and shall not be liable whatsoever for any damages incurred as a result of its use.

* [ICD-9-CM](http://tx.fhir.org/r4/ValueSet/icd-9-cm): [VsIcd9cm](ValueSet-who-icd9cm.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.3.0/CodeSystem-v3-loinc.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 18 more,[Composition/2ae95a5c-9094-41a3-a437-ce6d34c55a54](Composition-2ae95a5c-9094-41a3-a437-ce6d34c55a54.md),[CompositionRefertoLabIt](StructureDefinition-composition-it-lab.md),[DiagnosticReport/56f19992-e73e-45b5-bbdd-6d9aeb60b15a](DiagnosticReport-56f19992-e73e-45b5-bbdd-6d9aeb60b15a.md),[DiagnosticReportRefertoLabIt](StructureDefinition-diagnosticreport-it-lab.md),[LabOrderCodes](ValueSet-lab-orderCodes-it-lab.md),[Observation/5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c](Observation-5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c.md),[Observation/7e2f354b-de83-4472-bd07-1571cdb50fde](Observation-7e2f354b-de83-4472-bd07-1571cdb50fde.md),[Observation/9474efca-8c8a-436d-a1a4-5706a1dd057a](Observation-9474efca-8c8a-436d-a1a4-5706a1dd057a.md),[Observation/Observation-Lab-Esempio-Group](Observation-Observation-Lab-Esempio-Group.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246.md),[Observation/a8a27a81-4543-45a9-8859-fa17053d963e](Observation-a8a27a81-4543-45a9-8859-fa17053d963e.md),[ObservationGroupingRefertoLabIt](StructureDefinition-observation-grouping-it-lab.md),[ObservationRefertoLabIt](StructureDefinition-observation-it-lab.md),[ServiceRequestRefertoLabIt](StructureDefinition-servicerequest-it-lab.md),[VsResultsLaboratoryObservation](ValueSet-risultato-osservazione.md)and[VsSezioniRefertoLaboratorio](ValueSet-sezione-referto-laboratorio.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 19 more,[DeviceRefertoLabIt](StructureDefinition-device-it-lab.md),[DiagnosticReport/56f19992-e73e-45b5-bbdd-6d9aeb60b15a](DiagnosticReport-56f19992-e73e-45b5-bbdd-6d9aeb60b15a.md),[ObservationRefertoLabIt](StructureDefinition-observation-it-lab.md),[PractitionerRole/dc5842a1-83b6-43c7-b063-75ae989b803c](PractitionerRole-dc5842a1-83b6-43c7-b063-75ae989b803c.md),[PractitionerRoleRefertoLabIt](StructureDefinition-practitionerrole-it-lab.md),[ServiceRequest/463ae6fe-60d4-4b38-84b3-1008e0925678](ServiceRequest-463ae6fe-60d4-4b38-84b3-1008e0925678.md),[Specimen/168d4960-0a0b-43af-8025-180f0965f325](Specimen-168d4960-0a0b-43af-8025-180f0965f325.md),[SpecimenAdditiveSubstanceRefertoLabIt](StructureDefinition-substance-additive-specimen-it-lab.md),[SpecimenRefertoLabIt](StructureDefinition-specimen-it-lab.md),[Substance/168d4960-0a0b-43af-8025-180f0965f326](Substance-168d4960-0a0b-43af-8025-180f0965f326.md),[VsGruppoSanguigno](ValueSet-results-observation-bloodgroup.md),[VsLabSpecimenAdditiveIt](ValueSet-additivo-campione-it.md),[VsLabSpecimenContainerIt](ValueSet-campione-container-lab-it.md),[VsLabSpecimenTypesIt](ValueSet-tipo-campione-lab-it.md),[VsMicroorganismiOsservazioni](ValueSet-results-microorganism-snomed-ct-ips-free-set.md),[VsObservationBloodGroup](ValueSet-valueset-observation-value-bloodgroup.md),[VsObservationMicroorganismi](ValueSet-valueset-observation-value-microorganism.md),[VsObservationPresenzaAssenza](ValueSet-valueset-observation-value-presence-absence.md)and[VsResultsPresenceAbsenceSnomedCtIpsFreeSet](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Observation Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 11 more,[Observation/5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c](Observation-5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c.md),[Observation/7e2f354b-de83-4472-bd07-1571cdb50fde](Observation-7e2f354b-de83-4472-bd07-1571cdb50fde.md),[Observation/9474efca-8c8a-436d-a1a4-5706a1dd057a](Observation-9474efca-8c8a-436d-a1a4-5706a1dd057a.md),[Observation/Observation-Lab-Esempio-Group](Observation-Observation-Lab-Esempio-Group.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246.md),[Observation/a8a27a81-4543-45a9-8859-fa17053d963e](Observation-a8a27a81-4543-45a9-8859-fa17053d963e.md),[ObservationDocRefertoLabIt](StructureDefinition-observation-doc-it-lab.md),[ObservationGroupingRefertoLabIt](StructureDefinition-observation-grouping-it-lab.md)and[ObservationRefertoLabIt](StructureDefinition-observation-it-lab.md)
* [Practitioner role](http://terminology.hl7.org/7.0.0/CodeSystem-practitioner-role.html): [PractitionerRoleRefertoLabIt](StructureDefinition-practitionerrole-it-lab.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [PatientRefertoLabIt](StructureDefinition-patient-it-lab.md) and [VstipoIdentificatore](ValueSet-VstipoIdentificatore.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md), [Encounter/7b06368c-7089-4f66-acc8-29e1fcbd31f6](Encounter-7b06368c-7089-4f66-acc8-29e1fcbd31f6.md) and [EncounterRefertoLabIt](StructureDefinition-encounter-it-lab.md)
* [Confidentiality](http://terminology.hl7.org/7.0.0/CodeSystem-v3-Confidentiality.html): [CompositionRefertoLabIt](StructureDefinition-composition-it-lab.md)
* [MaritalStatus](http://terminology.hl7.org/7.0.0/CodeSystem-v3-MaritalStatus.html): [CsSupItV3MaritalStatus](CodeSystem-v3-MaritalStatus.md) and [VsStatoCivile](ValueSet-statoCivile.md)
* [NullFlavor](http://terminology.hl7.org/7.0.0/CodeSystem-v3-NullFlavor.html): [VsIstatComune](ValueSet-istat-comune.md), [VsIstatProvincia](ValueSet-istat-provincia.md) and [VsStatoCivile](ValueSet-statoCivile.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ObservationInterpretation.html): [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)
* [ParticipationType](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ParticipationType.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md) and [Encounter/7b06368c-7089-4f66-acc8-29e1fcbd31f6](Encounter-7b06368c-7089-4f66-acc8-29e1fcbd31f6.md)
* [RoleCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-RoleCode.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 4 more,[ExtRecordCertification](StructureDefinition-recordCertification.md),[LocationRefertoLabIt](StructureDefinition-location-it-lab.md),[Policlinico di Roma](Location-f148e54a-2046-4534-b9e9-54e7e9632224.md)and[VsTipoCertificatore](ValueSet-tipoCertificatore.md)
* [SpecimenType](http://terminology.hl7.org/7.0.0/CodeSystem-v3-SpecimenType.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md), [Specimen/168d4960-0a0b-43af-8025-180f0965f325](Specimen-168d4960-0a0b-43af-8025-180f0965f325.md), [SpecimenRefertoLabIt](StructureDefinition-specimen-it-lab.md) and [VsTipoCampione](ValueSet-tipo-campione.md)


