# Observation status code - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation status code**

## ValueSet: Observation status code 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/valueset-status-obs-it | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:ObservationStatusCodeLabReport |

 
Valueset contenente i codici di di stato per la risorsa Observation Document - Lab Report. 

 **References** 

* [Observation Document - Lab Report](StructureDefinition-observation-doc-it-lab.md)

### Logical Definition (CLD)

Profile: [Shareable ValueSet](http://hl7.org/fhir/R4/shareablevalueset.html)

This value set includes codes based on the following rules:

* Include all codes defined in [`http://hl7.org/fhir/observation-status`](http://hl7.org/fhir/R4/codesystem-observation-status.html)version 📦4.0.1

This value set excludes codes based on the following rules:

* Exclude these codes as defined in [`http://hl7.org/fhir/observation-status`](http://hl7.org/fhir/R4/codesystem-observation-status.html)version 📦4.0.1

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "valueset-status-obs-it",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/valueset-status-obs-it",
  "version" : "0.2.0",
  "name" : "ObservationStatusCodeLabReport",
  "title" : "Observation status code",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset contenente i codici di di stato per la risorsa Observation Document - Lab Report.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/observation-status"
      }
    ],
    "exclude" : [
      {
        "system" : "http://hl7.org/fhir/observation-status",
        "concept" : [
          {
            "code" : "registered"
          },
          {
            "code" : "cancelled"
          },
          {
            "code" : "unknown"
          },
          {
            "code" : "entered-in-error"
          }
        ]
      }
    ]
  }
}

```
