# Risultato osservazione codificato - microorganismo IPS di SNOMED CT - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risultato osservazione codificato - microorganismo IPS di SNOMED CT**

## ValueSet: Risultato osservazione codificato - microorganismo IPS di SNOMED CT 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/results-microorganism-snomed-ct-ips-free-set | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:VsMicroorganismiOsservazioni |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Valueset che include i codici per i microrganismi dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set has 1,343 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "results-microorganism-snomed-ct-ips-free-set",
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/results-microorganism-snomed-ct-ips-free-set",
  "version" : "0.2.0",
  "name" : "VsMicroorganismiOsservazioni",
  "title" : "Risultato osservazione codificato - microorganismo IPS di SNOMED CT",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset che include i codici per i microrganismi dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "646165971000087107",
            "display" : "Shigella flexneri 5a (organism)"
          },
          {
            "code" : "840533007",
            "display" : "Severe acute respiratory syndrome coronavirus 2 (organism)"
          },
          {
            "code" : "767451000",
            "display" : "Trichinella nelsoni (organism)"
          },
          {
            "code" : "767450004",
            "display" : "Trichinella nativa (organism)"
          },
          {
            "code" : "767285001",
            "display" : "Streptococcus pneumoniae Danish serotype 42 (organism)"
          },
          {
            "code" : "767284002",
            "display" : "Streptococcus pneumoniae Danish serotype 43 (organism)"
          },
          {
            "code" : "767283008",
            "display" : "Streptococcus pneumoniae Danish serotype 44 (organism)"
          },
          {
            "code" : "767282003",
            "display" : "Streptococcus pneumoniae Danish serotype 45 (organism)"
          },
          {
            "code" : "767281005",
            "display" : "Streptococcus pneumoniae Danish serotype 46 (organism)"
          },
          {
            "code" : "767275002",
            "display" : "Streptococcus pneumoniae Danish serotype 48 (organism)"
          },
          {
            "code" : "767274003",
            "display" : "Streptococcus pneumoniae Danish serotype 40 (organism)"
          },
          {
            "code" : "767208001",
            "display" : "Streptococcus pneumoniae Danish serotype 39 (organism)"
          },
          {
            "code" : "767204004",
            "display" : "Streptococcus pneumoniae Danish serotype 38 (organism)"
          },
          {
            "code" : "767202000",
            "display" : "Streptococcus pneumoniae serogroup 20 (organism)"
          },
          {
            "code" : "767201007",
            "display" : "Streptococcus pneumoniae Danish serotype 34 (organism)"
          },
          {
            "code" : "736946001",
            "display" : "Cryptococcus gattii genotype VGI (organism)"
          },
          {
            "code" : "736945002",
            "display" : "Cryptococcus gattii genotype VGIII (organism)"
          },
          {
            "code" : "736944003",
            "display" : "Cryptococcus neoformans var. grubii genotype VNI (organism)"
          },
          {
            "code" : "736943009",
            "display" : "Cryptococcus neoformans var. grubii genotype VNII (organism)"
          },
          {
            "code" : "733595003",
            "display" : "Enterohemorrhagic Escherichia coli serogroup O:nonmotile (organism)"
          },
          {
            "code" : "732254006",
            "display" : "Yersinia enterocolitica serogroup O:19,8 (organism)"
          },
          {
            "code" : "732253000",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:19,8 (organism)"
          },
          {
            "code" : "732210000",
            "display" : "Measles virus genotype G1 (organism)"
          },
          {
            "code" : "732209005",
            "display" : "Measles virus genotype B1 (organism)"
          },
          {
            "code" : "732208002",
            "display" : "Measles virus genotype D1 (organism)"
          },
          {
            "code" : "732207007",
            "display" : "Measles virus genotype E (organism)"
          },
          {
            "code" : "732206003",
            "display" : "Measles virus genotype F (organism)"
          },
          {
            "code" : "726499009",
            "display" : "Fluoroquinolone resistant Shigella (organism)"
          },
          {
            "code" : "726497006",
            "display" : "Fluoroquinolone resistant Campylobacter (organism)"
          },
          {
            "code" : "726495003",
            "display" : "Ampicillin resistant Haemophilus influenzae (organism)"
          },
          {
            "code" : "725473009",
            "display" : "Human alphaherpesvirus 3 clade 5 (organism)"
          },
          {
            "code" : "725472004",
            "display" : "Human alphaherpesvirus 3 clade 4 (organism)"
          },
          {
            "code" : "725471006",
            "display" : "Human alphaherpesvirus 3 clade 3 (organism)"
          },
          {
            "code" : "725470007",
            "display" : "Human alphaherpesvirus 3 clade 2 (organism)"
          },
          {
            "code" : "725469006",
            "display" : "Human alphaherpesvirus 3 clade 1 (organism)"
          },
          {
            "code" : "725454005",
            "display" : "Mumps genotype N (organism)"
          },
          {
            "code" : "725453004",
            "display" : "Mumps genotype L (organism)"
          },
          {
            "code" : "725452009",
            "display" : "Mumps genotype K (organism)"
          },
          {
            "code" : "725451002",
            "display" : "Mumps genotype J (organism)"
          },
          {
            "code" : "725450001",
            "display" : "Mumps genotype I (organism)"
          },
          {
            "code" : "725449001",
            "display" : "Mumps genotype H (organism)"
          },
          {
            "code" : "725448009",
            "display" : "Mumps genotype G (organism)"
          },
          {
            "code" : "725447004",
            "display" : "Mumps genotype F (organism)"
          },
          {
            "code" : "725446008",
            "display" : "Mumps genotype D (organism)"
          },
          {
            "code" : "725445007",
            "display" : "Mumps genotype C (organism)"
          },
          {
            "code" : "725444006",
            "display" : "Mumps genotype B (organism)"
          },
          {
            "code" : "725443000",
            "display" : "Mumps genotype A (organism)"
          },
          {
            "code" : "722808002",
            "display" : "Vibrio vulnificus biotype 3 (organism)"
          },
          {
            "code" : "722807007",
            "display" : "Vibrio vulnificus biotype 2 (organism)"
          },
          {
            "code" : "722806003",
            "display" : "Vibrio vulnificus biotype 1 (organism)"
          },
          {
            "code" : "722789000",
            "display" : "Toxigenic Corynebacterium diphtheriae type belfanti (organism)"
          },
          {
            "code" : "722356002",
            "display" : "Neisseria meningitidis, beta lactamase positive (organism)"
          },
          {
            "code" : "722355003",
            "display" : "Neisseria meningitidis, beta lactamase negative (organism)"
          },
          {
            "code" : "722353005",
            "display" : "Haemophilus influenzae, beta lactamase positive (organism)"
          },
          {
            "code" : "722351007",
            "display" : "Haemophilus influenzae, beta lactamase negative (organism)"
          },
          {
            "code" : "722350008",
            "display" : "Toxigenic Corynebacterium diphtheriae type mitis (organism)"
          },
          {
            "code" : "722349008",
            "display" : "Toxigenic Corynebacterium diphtheriae type intermedius (organism)"
          },
          {
            "code" : "722346001",
            "display" : "Toxigenic Corynebacterium diphtheriae type gravis (organism)"
          },
          {
            "code" : "722251009",
            "display" : "Mycobacterium simiae complex (organism)"
          },
          {
            "code" : "722246003",
            "display" : "Toxigenic Corynebacterium pseudotuberculosis (organism)"
          },
          {
            "code" : "721980008",
            "display" : "Shigella flexneri serovar 6 biotype Manchester (organism)"
          },
          {
            "code" : "721920006",
            "display" : "Orthopoxvirus species, not Variola virus (organism)"
          },
          {
            "code" : "721911002",
            "display" : "ESBL Shigella sonnei (organism)"
          },
          {
            "code" : "720871003",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:4,33 (organism)"
          },
          {
            "code" : "720870002",
            "display" : "Yersinia enterocolitica serogroup O:4,33 (organism)"
          },
          {
            "code" : "720869003",
            "display" : "Yersinia enterocolitica biotype 3 non-serotypable (organism)"
          },
          {
            "code" : "720805006",
            "display" : "Yersinia enterocolitica biotype 5 serotype O:2,3 (organism)"
          },
          {
            "code" : "720804005",
            "display" : "Yersinia enterocolitica biotype 4 serotype O:3 (organism)"
          },
          {
            "code" : "720803004",
            "display" : "Yersinia enterocolitica biotype 3 serotype O:5,27 (organism)"
          },
          {
            "code" : "720802009",
            "display" : "Yersinia enterocolitica biotype 3 serotype O:3 (organism)"
          },
          {
            "code" : "720801002",
            "display" : "Yersinia enterocolitica biotype 3 serotype O:1,2,3 (organism)"
          },
          {
            "code" : "720800001",
            "display" : "Yersinia enterocolitica biotype 2 serotype O:9 (organism)"
          },
          {
            "code" : "720799000",
            "display" : "Yersinia enterocolitica biotype 2 serotype O:5,27 (organism)"
          },
          {
            "code" : "720798008",
            "display" : "Yersinia enterocolitica biotype 1B serotype O:21 (organism)"
          },
          {
            "code" : "720797003",
            "display" : "Yersinia enterocolitica biotype 1B serotype O:20 (organism)"
          },
          {
            "code" : "720796007",
            "display" : "Yersinia enterocolitica biotype 1B serotype O:18 (organism)"
          },
          {
            "code" : "720795006",
            "display" : "Yersinia enterocolitica biotype 1B serotype O:13a,13b (organism)"
          },
          {
            "code" : "720794005",
            "display" : "Yersinia enterocolitica biotype 1B serotype O:8 (organism)"
          },
          {
            "code" : "720793004",
            "display" : "Yersinia enterocolitica biotype 1B non-serotypable (organism)"
          },
          {
            "code" : "720792009",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:57 (organism)"
          },
          {
            "code" : "720791002",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:36 (organism)"
          },
          {
            "code" : "720790001",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:22 (organism)"
          },
          {
            "code" : "720788002",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:16 (organism)"
          },
          {
            "code" : "720787007",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:14 (organism)"
          },
          {
            "code" : "720786003",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:10 (organism)"
          },
          {
            "code" : "720785004",
            "display" : "Yersinia enterocolitica serogroup O:7,13 (organism)"
          },
          {
            "code" : "720784000",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:7,13 (organism)"
          },
          {
            "code" : "720782001",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:7,8 (organism)"
          },
          {
            "code" : "720781008",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:6,31 (organism)"
          },
          {
            "code" : "720780009",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:6,30 (organism)"
          },
          {
            "code" : "720779006",
            "display" : "Yersinia enterocolitica biotype 1A serotype O:5 (organism)"
          },
          {
            "code" : "720778003",
            "display" : "Yersinia enterocolitica biotype 1A serotype O rough (organism)"
          },
          {
            "code" : "720777008",
            "display" : "Yersinia enterocolitica biotype 1A non-serotypable (organism)"
          },
          {
            "code" : "720776004",
            "display" : "Yersinia enterocolitica serogroup O:2,3 (organism)"
          },
          {
            "code" : "720775000",
            "display" : "Yersinia enterocolitica serogroup O:1,2,3 (organism)"
          },
          {
            "code" : "720774001",
            "display" : "Yersinia enterocolitica serogroup O:18 (organism)"
          },
          {
            "code" : "720773007",
            "display" : "Yersinia enterocolitica serogroup O:57 (organism)"
          },
          {
            "code" : "720772002",
            "display" : "Yersinia enterocolitica serogroup O:36 (organism)"
          },
          {
            "code" : "720771009",
            "display" : "Yersinia enterocolitica serogroup O:22 (organism)"
          },
          {
            "code" : "720769009",
            "display" : "Yersinia enterocolitica serogroup O:16 (organism)"
          },
          {
            "code" : "720768001",
            "display" : "Yersinia enterocolitica serogroup O:10 (organism)"
          },
          {
            "code" : "720767006",
            "display" : "Yersinia enterocolitica serogroup O:7,8 (organism)"
          },
          {
            "code" : "720766002",
            "display" : "Yersinia enterocolitica serogroup O:6,31 (organism)"
          },
          {
            "code" : "720765003",
            "display" : "Yersinia enterocolitica serogroup O:6,30 (organism)"
          },
          {
            "code" : "720764004",
            "display" : "Yersinia enterocolitica serogroup O rough (organism)"
          },
          {
            "code" : "720763005",
            "display" : "Yersinia enterocolitica biotype 5 (organism)"
          },
          {
            "code" : "720762000",
            "display" : "Yersinia enterocolitica biotype 4 (organism)"
          },
          {
            "code" : "720761007",
            "display" : "Yersinia enterocolitica biotype 3 (organism)"
          },
          {
            "code" : "720760008",
            "display" : "Yersinia enterocolitica biotype 2 (organism)"
          },
          {
            "code" : "720759003",
            "display" : "Yersinia enterocolitica biotype 1B (organism)"
          },
          {
            "code" : "720758006",
            "display" : "Yersinia enterocolitica biotype 1A (organism)"
          },
          {
            "code" : "720723009",
            "display" : "Clostridium botulinum Group II type E and F (organism)"
          },
          {
            "code" : "720722004",
            "display" : "Clostridium botulinum Group II type B and E (organism)"
          },
          {
            "code" : "720721006",
            "display" : "Clostridium botulinum Group II type B and F (organism)"
          },
          {
            "code" : "720720007",
            "display" : "Clostridium botulinum Group II type F (organism)"
          },
          {
            "code" : "720719001",
            "display" : "Clostridium botulinum Group II type E (organism)"
          },
          {
            "code" : "720718009",
            "display" : "Clostridium botulinum Group II type B (organism)"
          },
          {
            "code" : "720717004",
            "display" : "Clostridium botulinum Group I type B and F (organism)"
          },
          {
            "code" : "720716008",
            "display" : "Clostridium botulinum Group I type A and F (organism)"
          },
          {
            "code" : "720715007",
            "display" : "Clostridium botulinum Group I type A and B (organism)"
          },
          {
            "code" : "720714006",
            "display" : "Clostridium botulinum Group I type F (organism)"
          },
          {
            "code" : "720713000",
            "display" : "Clostridium botulinum Group I type B (organism)"
          },
          {
            "code" : "720712005",
            "display" : "Clostridium botulinum Group I type A (organism)"
          },
          {
            "code" : "720711003",
            "display" : "Clostridium botulinum Group IV (organism)"
          },
          {
            "code" : "720710002",
            "display" : "Clostridium botulinum Group III (organism)"
          },
          {
            "code" : "720709007",
            "display" : "Clostridium botulinum Group II (organism)"
          },
          {
            "code" : "720708004",
            "display" : "Clostridium botulinum Group I (organism)"
          },
          {
            "code" : "720325000",
            "display" : "Clostridium botulinum type G (organism)"
          },
          {
            "code" : "720324001",
            "display" : "Clostridium botulinum Group IV type G (organism)"
          },
          {
            "code" : "720323007",
            "display" : "Clostridium botulinum Group III type D (organism)"
          },
          {
            "code" : "720312008",
            "display" : "Clostridium botulinum Group III type C (organism)"
          },
          {
            "code" : "719913002",
            "display" : "Toxigenic Corynebacterium ulcerans (organism)"
          },
          {
            "code" : "719028004",
            "display" : "Streptococcus pneumoniae Danish serotype 6D (organism)"
          },
          {
            "code" : "718809000",
            "display" : "Mycobacterium parakoreense (organism)"
          },
          {
            "code" : "718808008",
            "display" : "Mycobacterium minnesotense (organism)"
          },
          {
            "code" : "716531008",
            "display" : "Multiple drug resistant methicillin resistant Staphylococcus aureus (organism)"
          },
          {
            "code" : "716530009",
            "display" : "Non-multiple drug resistant methicillin resistant Staphylococcus aureus (organism)"
          },
          {
            "code" : "715358008",
            "display" : "Streptococcus agalactiae serotype IX (organism)"
          },
          {
            "code" : "715357003",
            "display" : "Streptococcus agalactiae serotype VI (organism)"
          },
          {
            "code" : "715335005",
            "display" : "Vibrio cholerae serogroup O141 (organism)"
          },
          {
            "code" : "715307006",
            "display" : "Carbapenem resistant Escherichia coli (organism)"
          },
          {
            "code" : "713924007",
            "display" : "Non-hemolytic Streptococcus agalactiae (organism)"
          },
          {
            "code" : "713611009",
            "display" : "Mycobacterium chlorophenolicum (organism)"
          },
          {
            "code" : "712913003",
            "display" : "Mycobacterium europaeum (organism)"
          },
          {
            "code" : "712912008",
            "display" : "Mycobacterium heraklionense (organism)"
          },
          {
            "code" : "712911001",
            "display" : "Mycobacterium kyorinense (organism)"
          },
          {
            "code" : "712910000",
            "display" : "Mycobacterium riyadhense (organism)"
          },
          {
            "code" : "712909005",
            "display" : "Mycobacterium vulneris (organism)"
          },
          {
            "code" : "712666003",
            "display" : "Vancomycin intermediate Enterococcus faecium (organism)"
          },
          {
            "code" : "712665004",
            "display" : "Vancomycin resistant Enterococcus faecium (organism)"
          },
          {
            "code" : "712664000",
            "display" : "Vancomycin intermediate Enterococcus faecalis (organism)"
          },
          {
            "code" : "712663006",
            "display" : "Vancomycin resistant Enterococcus faecalis (organism)"
          },
          {
            "code" : "710891006",
            "display" : "Methicillin resistant Staphylococcus (organism)"
          },
          {
            "code" : "710564002",
            "display" : "Panton-Valentine leukocidin producing Staphylococcus aureus (organism)"
          },
          {
            "code" : "710347001",
            "display" : "Toxigenic Vibrio cholerae, O1 (organism)"
          },
          {
            "code" : "710346005",
            "display" : "Nontoxigenic Vibrio cholerae, O1 (organism)"
          },
          {
            "code" : "710334006",
            "display" : "Vancomycin resistant enterococcus vanB strain (organism)"
          },
          {
            "code" : "710333000",
            "display" : "Vancomycin resistant enterococcus vanA strain (organism)"
          },
          {
            "code" : "710331003",
            "display" : "Anaerobic Campylobacter species (organism)"
          },
          {
            "code" : "709682006",
            "display" : "Mycobacterium iranicum (organism)"
          },
          {
            "code" : "708352002",
            "display" : "Mycobacterium algericum (organism)"
          },
          {
            "code" : "708346003",
            "display" : "Mycobacterium florentinum (organism)"
          },
          {
            "code" : "708341008",
            "display" : "Mycobacterium llatzerense (organism)"
          },
          {
            "code" : "708336000",
            "display" : "Mycobacterium mantenii (organism)"
          },
          {
            "code" : "708333008",
            "display" : "Mycobacterium paragordonae (organism)"
          },
          {
            "code" : "708329001",
            "display" : "Mycobacterium senuense (organism)"
          },
          {
            "code" : "708324006",
            "display" : "Mycobacterium setense (organism)"
          },
          {
            "code" : "708319008",
            "display" : "Mycobacterium timonense (organism)"
          },
          {
            "code" : "707769000",
            "display" : "Enterococcus faecium genotype vanB (organism)"
          },
          {
            "code" : "707768008",
            "display" : "Enterococcus faecium genotype vanA (organism)"
          },
          {
            "code" : "707767003",
            "display" : "Vancomycin resistant vanB2 and vanB3 Enterococcus (organism)"
          },
          {
            "code" : "707328006",
            "display" : "Mycobacterium paraterrae (organism)"
          },
          {
            "code" : "706997008",
            "display" : "Escherichia coli serotype O112:H2 (organism)"
          },
          {
            "code" : "705167005",
            "display" : "Yersinia enterocolitica subsp. palearctica (organism)"
          },
          {
            "code" : "705166001",
            "display" : "Yersinia enterocolitica subsp. enterocolitica (organism)"
          },
          {
            "code" : "705094007",
            "display" : "Mycobacteroides abscessus subspecies bolletii (organism)"
          },
          {
            "code" : "704995002",
            "display" : "Mycobacteroides abscessus subspecies abscessus (organism)"
          },
          {
            "code" : "703893002",
            "display" : "Hepatitis B virus genotype H (organism)"
          },
          {
            "code" : "703892007",
            "display" : "Hepatitis B virus genotype G (organism)"
          },
          {
            "code" : "703891000",
            "display" : "Hepatitis B virus genotype F (organism)"
          },
          {
            "code" : "703890004",
            "display" : "Hepatitis B virus genotype E (organism)"
          },
          {
            "code" : "703889008",
            "display" : "Hepatitis B virus genotype D (organism)"
          },
          {
            "code" : "703888000",
            "display" : "Hepatitis B virus genotype C (organism)"
          },
          {
            "code" : "703887005",
            "display" : "Hepatitis B virus genotype B (organism)"
          },
          {
            "code" : "703886001",
            "display" : "Hepatitis B virus genotype A (organism)"
          },
          {
            "code" : "703759007",
            "display" : "Taenia solium adult (organism)"
          },
          {
            "code" : "703632006",
            "display" : "Genus Taenia egg (organism)"
          },
          {
            "code" : "703075004",
            "display" : "Mycobacterium avium subspecies hominissuis (organism)"
          },
          {
            "code" : "699562002",
            "display" : "Plasmodium malariae schizont (organism)"
          },
          {
            "code" : "699561009",
            "display" : "Plasmodium malariae merozoite (organism)"
          },
          {
            "code" : "699560005",
            "display" : "Plasmodium vivax schizont (organism)"
          },
          {
            "code" : "699559000",
            "display" : "Plasmodium vivax merozoite (organism)"
          },
          {
            "code" : "699557003",
            "display" : "Plasmodium ovale schizont (organism)"
          },
          {
            "code" : "699555006",
            "display" : "Plasmodium ovale merozoite (organism)"
          },
          {
            "code" : "699553004",
            "display" : "Plasmodium falciparum schizont (organism)"
          },
          {
            "code" : "699550001",
            "display" : "Plasmodium falciparum merozoite (organism)"
          },
          {
            "code" : "699434006",
            "display" : "Genus Cyclospora oocyst (organism)"
          },
          {
            "code" : "699416007",
            "display" : "Entamoeba histolytica-Entamoeba dispar complex cyst (organism)"
          },
          {
            "code" : "699415006",
            "display" : "Entamoeba histolytica-Entamoeba dispar complex trophozoite (organism)"
          },
          {
            "code" : "698216001",
            "display" : "Vancomycin susceptible Staphylococcus aureus (organism)"
          },
          {
            "code" : "698215002",
            "display" : "Rickettsia species 364D (organism)"
          },
          {
            "code" : "698204007",
            "display" : "Measles virus genotype D11 (organism)"
          },
          {
            "code" : "698203001",
            "display" : "Rubella virus genotype 1J (organism)"
          },
          {
            "code" : "698202006",
            "display" : "Rubella virus genotype 1I (organism)"
          },
          {
            "code" : "698201004",
            "display" : "Rubella virus genotype 1H (organism)"
          },
          {
            "code" : "698181009",
            "display" : "Streptococcus agalactiae serotype VIII (organism)"
          },
          {
            "code" : "698180005",
            "display" : "Streptococcus agalactiae serotype VII (organism)"
          },
          {
            "code" : "698179007",
            "display" : "Streptococcus agalactiae serotype V/R (organism)"
          },
          {
            "code" : "698178004",
            "display" : "Streptococcus agalactiae serotype V/c (organism)"
          },
          {
            "code" : "698177009",
            "display" : "Streptococcus agalactiae serotype V (organism)"
          },
          {
            "code" : "698174002",
            "display" : "Streptococcus agalactiae serotype IV (organism)"
          },
          {
            "code" : "698173008",
            "display" : "Streptococcus agalactiae serotype III/R (organism)"
          },
          {
            "code" : "698172003",
            "display" : "Streptococcus agalactiae serotype III/c (organism)"
          },
          {
            "code" : "698171005",
            "display" : "Streptococcus agalactiae serotype III (organism)"
          },
          {
            "code" : "698170006",
            "display" : "Streptococcus agalactiae serotype II/R (organism)"
          },
          {
            "code" : "698169005",
            "display" : "Streptococcus agalactiae serotype II/c (organism)"
          },
          {
            "code" : "698168002",
            "display" : "Streptococcus agalactiae serotype II (organism)"
          },
          {
            "code" : "698167007",
            "display" : "Streptococcus agalactiae serotype Ib/c (organism)"
          },
          {
            "code" : "698166003",
            "display" : "Streptococcus agalactiae serotype Ib (organism)"
          },
          {
            "code" : "698165004",
            "display" : "Streptococcus agalactiae serotype Ia/c (organism)"
          },
          {
            "code" : "698164000",
            "display" : "Streptococcus agalactiae serotype Ia (organism)"
          },
          {
            "code" : "698162001",
            "display" : "Neisseria meningitidis serogroup E (organism)"
          },
          {
            "code" : "698160009",
            "display" : "Streptococcus pyogenes type emm110 (organism)"
          },
          {
            "code" : "698159004",
            "display" : "Streptococcus pyogenes type emm109 (organism)"
          },
          {
            "code" : "698158007",
            "display" : "Streptococcus pyogenes type emm108 (organism)"
          },
          {
            "code" : "698157002",
            "display" : "Streptococcus pyogenes type emm107 (organism)"
          },
          {
            "code" : "698156006",
            "display" : "Streptococcus pyogenes type emm106 (organism)"
          },
          {
            "code" : "698155005",
            "display" : "Streptococcus pyogenes type emm105 (organism)"
          },
          {
            "code" : "698154009",
            "display" : "Streptococcus pyogenes type emm104 (organism)"
          },
          {
            "code" : "698153003",
            "display" : "Streptococcus pyogenes type emm103 (organism)"
          },
          {
            "code" : "698152008",
            "display" : "Streptococcus pyogenes type emm102 (organism)"
          },
          {
            "code" : "698151001",
            "display" : "Streptococcus pyogenes type emm101 (organism)"
          },
          {
            "code" : "698150000",
            "display" : "Listeria monocytogenes serotype 4bx (organism)"
          },
          {
            "code" : "698148008",
            "display" : "Streptococcus pneumoniae Danish serotype 47F (organism)"
          },
          {
            "code" : "698147003",
            "display" : "Streptococcus pneumoniae Danish serotype 47A (organism)"
          },
          {
            "code" : "698146007",
            "display" : "Streptococcus pneumoniae serogroup 47 (organism)"
          },
          {
            "code" : "698140001",
            "display" : "Streptococcus pneumoniae Danish serotype 41F (organism)"
          },
          {
            "code" : "698139003",
            "display" : "Streptococcus pneumoniae Danish serotype 41A (organism)"
          },
          {
            "code" : "698138006",
            "display" : "Streptococcus pneumoniae serogroup 41 (organism)"
          },
          {
            "code" : "698137001",
            "display" : "Streptococcus pneumoniae Danish serotype 37 (organism)"
          },
          {
            "code" : "698136005",
            "display" : "Streptococcus pneumoniae Danish serotype 36 (organism)"
          },
          {
            "code" : "698135009",
            "display" : "Streptococcus pneumoniae Danish serotype 35F (organism)"
          },
          {
            "code" : "698134008",
            "display" : "Streptococcus pneumoniae Danish serotype 35C (organism)"
          },
          {
            "code" : "698133002",
            "display" : "Streptococcus pneumoniae Danish serotype 35B (organism)"
          },
          {
            "code" : "698132007",
            "display" : "Streptococcus pneumoniae Danish serotype 35A (organism)"
          },
          {
            "code" : "698131000",
            "display" : "Streptococcus pneumoniae Danish serotype 33D (organism)"
          },
          {
            "code" : "698130004",
            "display" : "Streptococcus pneumoniae Danish serotype 33C (organism)"
          },
          {
            "code" : "698129009",
            "display" : "Streptococcus pneumoniae Danish serotype 33B (organism)"
          },
          {
            "code" : "698128001",
            "display" : "Streptococcus pneumoniae Danish serotype 32F (organism)"
          },
          {
            "code" : "698127006",
            "display" : "Streptococcus pneumoniae Danish serotype 32A (organism)"
          },
          {
            "code" : "698126002",
            "display" : "Streptococcus pneumoniae serogroup 32 (organism)"
          },
          {
            "code" : "698125003",
            "display" : "Streptococcus pneumoniae Danish serotype 27 (organism)"
          },
          {
            "code" : "698124004",
            "display" : "Streptococcus pneumoniae Danish serotype 25F (organism)"
          },
          {
            "code" : "698123005",
            "display" : "Streptococcus pneumoniae Danish serotype 25A (organism)"
          },
          {
            "code" : "698122000",
            "display" : "Streptococcus pneumoniae serogroup 25 (organism)"
          },
          {
            "code" : "698121007",
            "display" : "Streptococcus pneumoniae Danish serotype 24F (organism)"
          },
          {
            "code" : "698120008",
            "display" : "Streptococcus pneumoniae Danish serotype 24B (organism)"
          },
          {
            "code" : "698119002",
            "display" : "Streptococcus pneumoniae Danish serotype 24A (organism)"
          },
          {
            "code" : "698118005",
            "display" : "Streptococcus pneumoniae Danish serotype 19C (organism)"
          },
          {
            "code" : "698117000",
            "display" : "Streptococcus pneumoniae Danish serotype 19B (organism)"
          },
          {
            "code" : "698116009",
            "display" : "Streptococcus pneumoniae Danish serotype 18F (organism)"
          },
          {
            "code" : "698115008",
            "display" : "Streptococcus pneumoniae Danish serotype 18B (organism)"
          },
          {
            "code" : "698114007",
            "display" : "Streptococcus pneumoniae Danish serotype 18A (organism)"
          },
          {
            "code" : "698113001",
            "display" : "Streptococcus pneumoniae Danish serotype 17A (organism)"
          },
          {
            "code" : "698112006",
            "display" : "Streptococcus pneumoniae Danish serotype 16F (organism)"
          },
          {
            "code" : "698111004",
            "display" : "Streptococcus pneumoniae Danish serotype 16A (organism)"
          },
          {
            "code" : "698110003",
            "display" : "Streptococcus pneumoniae Danish serotype 15F (organism)"
          },
          {
            "code" : "698109008",
            "display" : "Streptococcus pneumoniae Danish serotype 12B (organism)"
          },
          {
            "code" : "698108000",
            "display" : "Streptococcus pneumoniae Danish serotype 12A (organism)"
          },
          {
            "code" : "698107005",
            "display" : "Streptococcus pneumoniae Danish serotype 11F (organism)"
          },
          {
            "code" : "698106001",
            "display" : "Streptococcus pneumoniae Danish serotype 11D (organism)"
          },
          {
            "code" : "698105002",
            "display" : "Streptococcus pneumoniae Danish serotype 11C (organism)"
          },
          {
            "code" : "698104003",
            "display" : "Streptococcus pneumoniae Danish serotype 11B (organism)"
          },
          {
            "code" : "698103009",
            "display" : "Streptococcus pneumoniae Danish serotype 10C (organism)"
          },
          {
            "code" : "698102004",
            "display" : "Streptococcus pneumoniae Danish serotype 7B (organism)"
          },
          {
            "code" : "698099004",
            "display" : "Streptococcus pneumoniae serogroup 24 (organism)"
          },
          {
            "code" : "698098007",
            "display" : "Streptococcus pneumoniae Danish serotype 23A (organism)"
          },
          {
            "code" : "698097002",
            "display" : "Streptococcus pneumoniae Danish serotype 21 (organism)"
          },
          {
            "code" : "698096006",
            "display" : "Streptococcus pneumoniae Danish serotype 7C (organism)"
          },
          {
            "code" : "698095005",
            "display" : "Streptococcus pneumoniae Danish serotype 6C (organism)"
          },
          {
            "code" : "609075007",
            "display" : "Trichinella spiralis larva (organism)"
          },
          {
            "code" : "609074006",
            "display" : "Genus Trichinella larva (organism)"
          },
          {
            "code" : "609056002",
            "display" : "Trichinella spiralis adult (organism)"
          },
          {
            "code" : "609055003",
            "display" : "Genus Trichinella adult (organism)"
          },
          {
            "code" : "608966000",
            "display" : "Plasmodium vivax gametocyte (organism)"
          },
          {
            "code" : "608965001",
            "display" : "Plasmodium ovale gametocyte (organism)"
          },
          {
            "code" : "608964002",
            "display" : "Plasmodium malariae gametocyte (organism)"
          },
          {
            "code" : "608963008",
            "display" : "Plasmodium falciparum gametocyte (organism)"
          },
          {
            "code" : "608962003",
            "display" : "Genus Plasmodium gametocyte (organism)"
          },
          {
            "code" : "608958009",
            "display" : "Cyclospora cayetanensis oocyst (organism)"
          },
          {
            "code" : "608957004",
            "display" : "Genus Cryptosporidium oocyst (organism)"
          },
          {
            "code" : "608956008",
            "display" : "Toxoplasma gondii trophozoite (organism)"
          },
          {
            "code" : "608948005",
            "display" : "Giardia lamblia cyst (organism)"
          },
          {
            "code" : "608946009",
            "display" : "Genus Giardia cyst (organism)"
          },
          {
            "code" : "608938008",
            "display" : "Plasmodium vivax trophozoite (organism)"
          },
          {
            "code" : "608937003",
            "display" : "Plasmodium ovale trophozoite (organism)"
          },
          {
            "code" : "608936007",
            "display" : "Plasmodium malariae trophozoite (organism)"
          },
          {
            "code" : "608935006",
            "display" : "Plasmodium falciparum trophozoite (organism)"
          },
          {
            "code" : "608934005",
            "display" : "Genus Plasmodium trophozoite (organism)"
          },
          {
            "code" : "608932009",
            "display" : "Giardia lamblia trophozoite (organism)"
          },
          {
            "code" : "608931002",
            "display" : "Genus Giardia trophozoite (organism)"
          },
          {
            "code" : "608927008",
            "display" : "Genus Cryptosporidium trophozoite (organism)"
          },
          {
            "code" : "608923007",
            "display" : "Genus Babesia trophozoite (organism)"
          },
          {
            "code" : "603433009",
            "display" : "Hepatitis C virus subtype 4e (organism)"
          },
          {
            "code" : "603432004",
            "display" : "Hepatitis C virus subtype 4d (organism)"
          },
          {
            "code" : "603431006",
            "display" : "Hepatitis C virus subtype 4c (organism)"
          },
          {
            "code" : "603430007",
            "display" : "Hepatitis C virus subtype 4b (organism)"
          },
          {
            "code" : "603429002",
            "display" : "Hepatitis C virus subtype 2c (organism)"
          },
          {
            "code" : "603428005",
            "display" : "Hepatitis C virus subtype 1c (organism)"
          },
          {
            "code" : "603427000",
            "display" : "Hepatitis C virus genotype 6 (organism)"
          },
          {
            "code" : "603426009",
            "display" : "Hepatitis C virus genotype 5 (organism)"
          },
          {
            "code" : "603425008",
            "display" : "Hepatitis C virus genotype 4 (organism)"
          },
          {
            "code" : "603424007",
            "display" : "Hepatitis C virus genotype 3 (organism)"
          },
          {
            "code" : "603423001",
            "display" : "Hepatitis C virus genotype 2 (organism)"
          },
          {
            "code" : "603422006",
            "display" : "Hepatitis C virus genotype 1 (organism)"
          },
          {
            "code" : "603421004",
            "display" : "Hepatitis C virus subtype 4a (organism)"
          },
          {
            "code" : "603420003",
            "display" : "Hepatitis C virus subtype 6a (organism)"
          },
          {
            "code" : "603419009",
            "display" : "Hepatitis C virus subtype 5a (organism)"
          },
          {
            "code" : "603418001",
            "display" : "Hepatitis C virus subtype 3b (organism)"
          },
          {
            "code" : "603417006",
            "display" : "Hepatitis C virus subtype 3a (organism)"
          },
          {
            "code" : "603416002",
            "display" : "Hepatitis C virus subtype 2b (organism)"
          },
          {
            "code" : "603415003",
            "display" : "Hepatitis C virus subtype 2a (organism)"
          },
          {
            "code" : "603414004",
            "display" : "Hepatitis C virus subtype 1b (organism)"
          },
          {
            "code" : "603413005",
            "display" : "Hepatitis C virus subtype 1a (organism)"
          },
          {
            "code" : "450963008",
            "display" : "Cocal virus (organism)"
          },
          {
            "code" : "450862004",
            "display" : "Cryptococcus gattii (organism)"
          },
          {
            "code" : "450622000",
            "display" : "Lujo virus (organism)"
          },
          {
            "code" : "450611004",
            "display" : "Legionella bozemanae (organism)"
          },
          {
            "code" : "450597006",
            "display" : "Bundibugyo ebolavirus (organism)"
          },
          {
            "code" : "450548002",
            "display" : "Listeria monocytogenes serotype 7 (organism)"
          },
          {
            "code" : "450547007",
            "display" : "Listeria monocytogenes serotype 4e (organism)"
          },
          {
            "code" : "450546003",
            "display" : "Listeria monocytogenes serotype 4d (organism)"
          },
          {
            "code" : "450545004",
            "display" : "Listeria monocytogenes serotype 4ab (organism)"
          },
          {
            "code" : "450544000",
            "display" : "Listeria monocytogenes serotype 4c (organism)"
          },
          {
            "code" : "450543006",
            "display" : "Listeria monocytogenes serotype 4a (organism)"
          },
          {
            "code" : "450542001",
            "display" : "Listeria monocytogenes serotype 3c (organism)"
          },
          {
            "code" : "450541008",
            "display" : "Listeria monocytogenes serotype 3b (organism)"
          },
          {
            "code" : "450540009",
            "display" : "Listeria monocytogenes serotype 3a (organism)"
          },
          {
            "code" : "450539007",
            "display" : "Listeria monocytogenes serotype 4b (organism)"
          },
          {
            "code" : "450538004",
            "display" : "Listeria monocytogenes serotype 1/2c (organism)"
          },
          {
            "code" : "450537009",
            "display" : "Listeria monocytogenes serotype 1/2b (organism)"
          },
          {
            "code" : "450536000",
            "display" : "Listeria monocytogenes serotype 1/2a (organism)"
          },
          {
            "code" : "449411006",
            "display" : "Brucella inopinata (organism)"
          },
          {
            "code" : "449024000",
            "display" : "Pandemic influenza A (H1N1) 2009 (organism)"
          },
          {
            "code" : "448945001",
            "display" : "Campylobacter lari subspecies lari (organism)"
          },
          {
            "code" : "448403005",
            "display" : "Campylobacter sputorum biovar paraureolyticus (organism)"
          },
          {
            "code" : "448130009",
            "display" : "Campylobacter avium (organism)"
          },
          {
            "code" : "447797004",
            "display" : "Campylobacter peloridis (organism)"
          },
          {
            "code" : "447728001",
            "display" : "Campylobacter cuniculorum (organism)"
          },
          {
            "code" : "447727006",
            "display" : "Campylobacter canadensis (organism)"
          },
          {
            "code" : "446396002",
            "display" : "Influenza A virus subtype H1 (organism)"
          },
          {
            "code" : "446191000",
            "display" : "Campylobacter lari subspecies concheus (organism)"
          },
          {
            "code" : "445776001",
            "display" : "Campylobacter subantarcticus (organism)"
          },
          {
            "code" : "444353005",
            "display" : "Streptococcus pneumoniae Danish serotype 28F (organism)"
          },
          {
            "code" : "444352000",
            "display" : "Streptococcus pneumoniae Danish serotype 28A (organism)"
          },
          {
            "code" : "443670000",
            "display" : "Streptococcus pneumoniae Danish serotype 31 (organism)"
          },
          {
            "code" : "443401009",
            "display" : "Nontoxigenic Corynebacterium diphtheriae (organism)"
          },
          {
            "code" : "443377006",
            "display" : "Toxigenic Corynebacterium diphtheriae (organism)"
          },
          {
            "code" : "443240001",
            "display" : "Streptococcus pneumoniae Danish serotype 15C (organism)"
          },
          {
            "code" : "443239003",
            "display" : "Streptococcus pneumoniae Danish serotype 15A (organism)"
          },
          {
            "code" : "443156004",
            "display" : "Streptococcus pneumoniae Danish serotype 6A (organism)"
          },
          {
            "code" : "443155000",
            "display" : "Streptococcus pneumoniae serogroup 28 (organism)"
          },
          {
            "code" : "443060003",
            "display" : "Streptococcus pyogenes type emm11 (organism)"
          },
          {
            "code" : "443059008",
            "display" : "Streptococcus pyogenes type emm111 (organism)"
          },
          {
            "code" : "443057005",
            "display" : "Streptococcus pyogenes type emm30 (organism)"
          },
          {
            "code" : "443056001",
            "display" : "Streptococcus pyogenes type emm31 (organism)"
          },
          {
            "code" : "443055002",
            "display" : "Streptococcus pyogenes type emm32 (organism)"
          },
          {
            "code" : "443054003",
            "display" : "Streptococcus pyogenes type emm33 (organism)"
          },
          {
            "code" : "443053009",
            "display" : "Streptococcus pyogenes type emm100 (organism)"
          },
          {
            "code" : "443052004",
            "display" : "Streptococcus pyogenes type emm7 (organism)"
          },
          {
            "code" : "443035003",
            "display" : "Streptococcus pyogenes type emm83 (organism)"
          },
          {
            "code" : "443034004",
            "display" : "Streptococcus pyogenes type emm84 (organism)"
          },
          {
            "code" : "443033005",
            "display" : "Streptococcus pyogenes type emm85 (organism)"
          },
          {
            "code" : "443032000",
            "display" : "Streptococcus pyogenes type emm86 (organism)"
          },
          {
            "code" : "443031007",
            "display" : "Streptococcus pyogenes type emm70 (organism)"
          },
          {
            "code" : "443028006",
            "display" : "Streptococcus pyogenes type emm10 (organism)"
          },
          {
            "code" : "443027001",
            "display" : "Streptococcus pyogenes type emm60 (organism)"
          },
          {
            "code" : "443026005",
            "display" : "Streptococcus pyogenes type emm8 (organism)"
          },
          {
            "code" : "443010009",
            "display" : "Streptococcus pyogenes type emm117 (organism)"
          },
          {
            "code" : "443009004",
            "display" : "Streptococcus pyogenes type emm53 (organism)"
          },
          {
            "code" : "443008007",
            "display" : "Streptococcus pyogenes type emm54 (organism)"
          },
          {
            "code" : "443007002",
            "display" : "Streptococcus pyogenes type emm55 (organism)"
          },
          {
            "code" : "442998009",
            "display" : "Streptococcus pyogenes type emm18 (organism)"
          },
          {
            "code" : "442996008",
            "display" : "Streptococcus pyogenes type emm78 (organism)"
          },
          {
            "code" : "442995007",
            "display" : "Streptococcus pyogenes type emm119 (organism)"
          },
          {
            "code" : "442991003",
            "display" : "Streptococcus pyogenes type emm69 (organism)"
          },
          {
            "code" : "442988003",
            "display" : "Streptococcus pyogenes type emm15 (organism)"
          },
          {
            "code" : "442985000",
            "display" : "Streptococcus pyogenes type emm52 (organism)"
          },
          {
            "code" : "442977009",
            "display" : "Streptococcus pyogenes type emm92 (organism)"
          },
          {
            "code" : "442976000",
            "display" : "Streptococcus pyogenes type emm93 (organism)"
          },
          {
            "code" : "442975001",
            "display" : "Streptococcus pyogenes type emm94 (organism)"
          },
          {
            "code" : "442974002",
            "display" : "Streptococcus pyogenes type emm95 (organism)"
          },
          {
            "code" : "442969005",
            "display" : "Streptococcus pyogenes type emm22 (organism)"
          },
          {
            "code" : "442968002",
            "display" : "Streptococcus pyogenes type emm23 (organism)"
          },
          {
            "code" : "442967007",
            "display" : "Streptococcus pyogenes type emm24 (organism)"
          },
          {
            "code" : "442966003",
            "display" : "Streptococcus pyogenes type emm25 (organism)"
          },
          {
            "code" : "442962001",
            "display" : "Streptococcus pyogenes type emm112 (organism)"
          },
          {
            "code" : "442961008",
            "display" : "Streptococcus pyogenes type emm74 (organism)"
          },
          {
            "code" : "442956006",
            "display" : "Streptococcus pyogenes type emm120 (organism)"
          },
          {
            "code" : "442955005",
            "display" : "Streptococcus pyogenes type emm121 (organism)"
          },
          {
            "code" : "442954009",
            "display" : "Streptococcus pyogenes type emm71 (organism)"
          },
          {
            "code" : "442953003",
            "display" : "Streptococcus pyogenes type emm72 (organism)"
          },
          {
            "code" : "442948008",
            "display" : "Streptococcus pyogenes type emm62 (organism)"
          },
          {
            "code" : "442947003",
            "display" : "Streptococcus pyogenes type emm63 (organism)"
          },
          {
            "code" : "442940001",
            "display" : "Streptococcus pyogenes type emm79 (organism)"
          },
          {
            "code" : "442935009",
            "display" : "Streptococcus pyogenes type emm64 (organism)"
          },
          {
            "code" : "442934008",
            "display" : "Streptococcus pyogenes type emm65 (organism)"
          },
          {
            "code" : "442933002",
            "display" : "Streptococcus pyogenes type emm66 (organism)"
          },
          {
            "code" : "442932007",
            "display" : "Streptococcus pyogenes type emm67 (organism)"
          },
          {
            "code" : "442930004",
            "display" : "Streptococcus pyogenes type emm42 (organism)"
          },
          {
            "code" : "442929009",
            "display" : "Streptococcus pyogenes type emm43 (organism)"
          },
          {
            "code" : "442923005",
            "display" : "Streptococcus pyogenes type emm19 (organism)"
          },
          {
            "code" : "442922000",
            "display" : "Streptococcus pyogenes type emm20 (organism)"
          },
          {
            "code" : "442906001",
            "display" : "Streptococcus pyogenes type emm82 (organism)"
          },
          {
            "code" : "442905002",
            "display" : "Streptococcus pyogenes type emm56 (organism)"
          },
          {
            "code" : "442904003",
            "display" : "Streptococcus pyogenes type emm57 (organism)"
          },
          {
            "code" : "442897000",
            "display" : "Streptococcus pyogenes type emm16 (organism)"
          },
          {
            "code" : "442896009",
            "display" : "Streptococcus pyogenes type emm17 (organism)"
          },
          {
            "code" : "442895008",
            "display" : "Streptococcus pyogenes type emm21 (organism)"
          },
          {
            "code" : "442882003",
            "display" : "Streptococcus pyogenes type emm13 (organism)"
          },
          {
            "code" : "442879008",
            "display" : "Streptococcus pyogenes type emm115 (organism)"
          },
          {
            "code" : "442873009",
            "display" : "Streptococcus pyogenes type emm59 (organism)"
          },
          {
            "code" : "442872004",
            "display" : "Streptococcus pyogenes type emm6 (organism)"
          },
          {
            "code" : "442863007",
            "display" : "Streptococcus pyogenes type emm116 (organism)"
          },
          {
            "code" : "442862002",
            "display" : "Streptococcus pyogenes type emm68 (organism)"
          },
          {
            "code" : "442857003",
            "display" : "Streptococcus pyogenes type emm80 (organism)"
          },
          {
            "code" : "442856007",
            "display" : "Streptococcus pyogenes type emm81 (organism)"
          },
          {
            "code" : "442853004",
            "display" : "Streptococcus pyogenes type emm47 (organism)"
          },
          {
            "code" : "442852009",
            "display" : "Streptococcus pyogenes type emm49 (organism)"
          },
          {
            "code" : "442851002",
            "display" : "Streptococcus pyogenes type emm50 (organism)"
          },
          {
            "code" : "442850001",
            "display" : "Streptococcus pyogenes type emm51 (organism)"
          },
          {
            "code" : "442846008",
            "display" : "Streptococcus pyogenes type emm75 (organism)"
          },
          {
            "code" : "442839004",
            "display" : "Streptococcus pyogenes type emm87 (organism)"
          },
          {
            "code" : "442838007",
            "display" : "Streptococcus pyogenes type emm88 (organism)"
          },
          {
            "code" : "442835005",
            "display" : "Streptococcus pyogenes type emm113 (organism)"
          },
          {
            "code" : "442834009",
            "display" : "Streptococcus pyogenes type emm114 (organism)"
          },
          {
            "code" : "442827007",
            "display" : "Streptococcus pyogenes type emm29 (organism)"
          },
          {
            "code" : "442826003",
            "display" : "Streptococcus pyogenes type emm34 (organism)"
          },
          {
            "code" : "442825004",
            "display" : "Streptococcus pyogenes type emm35 (organism)"
          },
          {
            "code" : "442824000",
            "display" : "Streptococcus pyogenes type emm36 (organism)"
          },
          {
            "code" : "442821008",
            "display" : "Streptococcus pyogenes type emm9 (organism)"
          },
          {
            "code" : "442820009",
            "display" : "Streptococcus pyogenes type emm91 (organism)"
          },
          {
            "code" : "442816005",
            "display" : "Streptococcus pyogenes type emm46 (organism)"
          },
          {
            "code" : "442815009",
            "display" : "Streptococcus pyogenes type emm96 (organism)"
          },
          {
            "code" : "442814008",
            "display" : "Streptococcus pyogenes type emm97 (organism)"
          },
          {
            "code" : "442813002",
            "display" : "Streptococcus pyogenes type emm3 (organism)"
          },
          {
            "code" : "442812007",
            "display" : "Streptococcus pyogenes type emm37 (organism)"
          },
          {
            "code" : "442810004",
            "display" : "Streptococcus pyogenes type emm98 (organism)"
          },
          {
            "code" : "442809009",
            "display" : "Streptococcus pyogenes type emm99 (organism)"
          },
          {
            "code" : "442802000",
            "display" : "Streptococcus pyogenes type emm38 (organism)"
          },
          {
            "code" : "442801007",
            "display" : "Streptococcus pyogenes type emm39 (organism)"
          },
          {
            "code" : "442800008",
            "display" : "Streptococcus pyogenes type emm40 (organism)"
          },
          {
            "code" : "442799009",
            "display" : "Streptococcus pyogenes type emm41 (organism)"
          },
          {
            "code" : "442794004",
            "display" : "Streptococcus pyogenes type emm45 (organism)"
          },
          {
            "code" : "442786006",
            "display" : "Streptococcus pyogenes type emm26 (organism)"
          },
          {
            "code" : "442785005",
            "display" : "Streptococcus pyogenes type emm27 (organism)"
          },
          {
            "code" : "442615006",
            "display" : "Bermejo virus (organism)"
          },
          {
            "code" : "442513007",
            "display" : "Araraquara virus (organism)"
          },
          {
            "code" : "442505006",
            "display" : "Chlamydia trachomatis, serotype Ja (organism)"
          },
          {
            "code" : "442352004",
            "display" : "Influenza A virus subtype H1N1 (organism)"
          },
          {
            "code" : "442049002",
            "display" : "Streptococcus pneumoniae Danish serotype 33A (organism)"
          },
          {
            "code" : "442001008",
            "display" : "Andes orthohantavirus (organism)"
          },
          {
            "code" : "441723002",
            "display" : "Streptococcus pyogenes type emm76 (organism)"
          },
          {
            "code" : "441666003",
            "display" : "Castelo dos Sonhos virus (organism)"
          },
          {
            "code" : "441618005",
            "display" : "Amur virus (organism)"
          },
          {
            "code" : "441602004",
            "display" : "Streptococcus pneumoniae Danish serotype 10F (organism)"
          },
          {
            "code" : "441566007",
            "display" : "Streptococcus pneumoniae Danish serotype 22A (organism)"
          },
          {
            "code" : "441523000",
            "display" : "Streptococcus pneumoniae serogroup 7 (organism)"
          },
          {
            "code" : "439294004",
            "display" : "Streptococcus pyogenes type emm61 (organism)"
          },
          {
            "code" : "438978005",
            "display" : "Streptococcus pyogenes type emm44 (organism)"
          },
          {
            "code" : "438977000",
            "display" : "Streptococcus pyogenes type emm118 (organism)"
          },
          {
            "code" : "437823001",
            "display" : "Rickettsia slovaca (organism)"
          },
          {
            "code" : "437822006",
            "display" : "Rickettsia honei (organism)"
          },
          {
            "code" : "433669003",
            "display" : "Grimontia hollisae (organism)"
          },
          {
            "code" : "433053006",
            "display" : "Listeria ivanovii subspecies ivanovii (organism)"
          },
          {
            "code" : "433052001",
            "display" : "Legionella gresilensis (organism)"
          },
          {
            "code" : "433050009",
            "display" : "Legionella busanensis (organism)"
          },
          {
            "code" : "433048001",
            "display" : "Legionella taurinensis (organism)"
          },
          {
            "code" : "432832005",
            "display" : "Francisella tularensis subspecies novicida (organism)"
          },
          {
            "code" : "432830002",
            "display" : "Francisella tularensis subspecies japonica (organism)"
          },
          {
            "code" : "432714000",
            "display" : "Legionella beliardensis (organism)"
          },
          {
            "code" : "432713006",
            "display" : "Legionella rowbothamii (organism)"
          },
          {
            "code" : "432712001",
            "display" : "Legionella drozanskii (organism)"
          },
          {
            "code" : "432580000",
            "display" : "Leptospira fainei (organism)"
          },
          {
            "code" : "432579003",
            "display" : "Leptospira alexanderi (organism)"
          },
          {
            "code" : "432537009",
            "display" : "Campylobacter lanienae (organism)"
          },
          {
            "code" : "432460004",
            "display" : "Campylobacter insulaenigrae (organism)"
          },
          {
            "code" : "432459009",
            "display" : "Campylobacter hyointestinalis subspecies lawsonii (organism)"
          },
          {
            "code" : "432453005",
            "display" : "Legionella fallonii (organism)"
          },
          {
            "code" : "432325006",
            "display" : "Legionella drancourtii (organism)"
          },
          {
            "code" : "431990001",
            "display" : "Tetragenococcus solitarius (organism)"
          },
          {
            "code" : "430983003",
            "display" : "Brucella abortus strain RB51 (organism)"
          },
          {
            "code" : "430982008",
            "display" : "Brucella abortus, vaccinal strain 19 (organism)"
          },
          {
            "code" : "430914003",
            "display" : "Mycobacterium pinnipedii (organism)"
          },
          {
            "code" : "430579009",
            "display" : "Mycobacterium caprae (organism)"
          },
          {
            "code" : "429569005",
            "display" : "Streptococcus pneumoniae serogroup 35 (organism)"
          },
          {
            "code" : "429337002",
            "display" : "Streptococcus pyogenes type emm89 (organism)"
          },
          {
            "code" : "429336006",
            "display" : "Streptococcus pyogenes type emm5 (organism)"
          },
          {
            "code" : "428855006",
            "display" : "Streptococcus pyogenes type emm90 (organism)"
          },
          {
            "code" : "428854005",
            "display" : "Streptococcus pyogenes type emm1 (organism)"
          },
          {
            "code" : "428793005",
            "display" : "Streptococcus pyogenes type emm12 (organism)"
          },
          {
            "code" : "428765006",
            "display" : "Mycobacterium terrae complex (organism)"
          },
          {
            "code" : "428542004",
            "display" : "Streptococcus pyogenes type emm77 (organism)"
          },
          {
            "code" : "428541006",
            "display" : "Streptococcus pyogenes type emm14 (organism)"
          },
          {
            "code" : "428366009",
            "display" : "Streptococcus pneumoniae Danish serotype 13 (organism)"
          },
          {
            "code" : "428254000",
            "display" : "Streptococcus pyogenes type emm58 (organism)"
          },
          {
            "code" : "428238003",
            "display" : "Streptococcus pyogenes type emm2 (organism)"
          },
          {
            "code" : "428139002",
            "display" : "Yersinia enterocolitica, serogroup O:14 (organism)"
          },
          {
            "code" : "428124003",
            "display" : "Streptococcus pneumoniae Danish serotype 10B (organism)"
          },
          {
            "code" : "427823008",
            "display" : "Streptococcus pyogenes type emm73 (organism)"
          },
          {
            "code" : "427822003",
            "display" : "Streptococcus pyogenes type emm4 (organism)"
          },
          {
            "code" : "427821005",
            "display" : "Streptococcus pyogenes type emm48 (organism)"
          },
          {
            "code" : "427814005",
            "display" : "Streptococcus pyogenes type emm28 (organism)"
          },
          {
            "code" : "427741005",
            "display" : "Streptococcus pneumoniae Danish serotype 23B (organism)"
          },
          {
            "code" : "427706006",
            "display" : "Measles virus genotype D5 (organism)"
          },
          {
            "code" : "427559006",
            "display" : "Rubella virus genotype 1D (organism)"
          },
          {
            "code" : "427398000",
            "display" : "Rubella virus genotype 1C (organism)"
          },
          {
            "code" : "427353006",
            "display" : "Measles virus genotype D7 (organism)"
          },
          {
            "code" : "427329000",
            "display" : "Rubella virus genotype 2C (organism)"
          },
          {
            "code" : "427290009",
            "display" : "Measles virus genotype D8 (organism)"
          },
          {
            "code" : "427263000",
            "display" : "Measles virus genotype D10 (organism)"
          },
          {
            "code" : "427182003",
            "display" : "Measles virus genotype C2 (organism)"
          },
          {
            "code" : "427073007",
            "display" : "Measles virus genotype B3 (organism)"
          },
          {
            "code" : "426654002",
            "display" : "Measles virus genotype B2 (organism)"
          },
          {
            "code" : "426640005",
            "display" : "Measles virus genotype D2 (organism)"
          },
          {
            "code" : "426612000",
            "display" : "Rubella virus genotype 2B (organism)"
          },
          {
            "code" : "426558008",
            "display" : "Measles virus genotype A (organism)"
          },
          {
            "code" : "426535005",
            "display" : "Measles virus genotype D9 (organism)"
          },
          {
            "code" : "426424002",
            "display" : "Measles virus genotype H2 (organism)"
          },
          {
            "code" : "426367009",
            "display" : "Rubella virus genotype 1F (organism)"
          },
          {
            "code" : "426261008",
            "display" : "Measles virus genotype D4 (organism)"
          },
          {
            "code" : "426209008",
            "display" : "Rubella virus genotype 1G (organism)"
          },
          {
            "code" : "426188007",
            "display" : "Measles virus genotype C1 (organism)"
          },
          {
            "code" : "426091009",
            "display" : "Measles virus genotype G2 (organism)"
          },
          {
            "code" : "426085007",
            "display" : "Rubella virus genotype 1E (organism)"
          },
          {
            "code" : "426028006",
            "display" : "Measles virus genotype D6 (organism)"
          },
          {
            "code" : "425970007",
            "display" : "Measles virus genotype D3 (organism)"
          },
          {
            "code" : "425966004",
            "display" : "Measles virus genotype H1 (organism)"
          },
          {
            "code" : "425891000",
            "display" : "Rubella virus genotype 2A (organism)"
          },
          {
            "code" : "425872000",
            "display" : "Rubella virus genotype 1a (organism)"
          },
          {
            "code" : "425684000",
            "display" : "Measles virus genotype G3 (organism)"
          },
          {
            "code" : "425415004",
            "display" : "Rubella virus genotype 1B (organism)"
          },
          {
            "code" : "425092008",
            "display" : "Zaire virus (organism)"
          },
          {
            "code" : "424421007",
            "display" : "Genus Marburgvirus (organism)"
          },
          {
            "code" : "424206003",
            "display" : "Ebolavirus (organism)"
          },
          {
            "code" : "424116003",
            "display" : "Sudan ebolavirus (organism)"
          },
          {
            "code" : "423042009",
            "display" : "Ivory Coast ebolavirus (organism)"
          },
          {
            "code" : "422839008",
            "display" : "Lake Victoria marburgvirus (organism)"
          },
          {
            "code" : "422448009",
            "display" : "Reston ebolavirus (organism)"
          },
          {
            "code" : "420364006",
            "display" : "Anaplasma phagocytophilum (organism)"
          },
          {
            "code" : "420216004",
            "display" : "Streptococcus pneumoniae Danish serotype 22F (organism)"
          },
          {
            "code" : "420148006",
            "display" : "Streptococcus pneumoniae Danish serotype 33F (organism)"
          },
          {
            "code" : "420138009",
            "display" : "Streptococcus pneumoniae Danish serotype 17F (organism)"
          },
          {
            "code" : "419915004",
            "display" : "Streptococcus pneumoniae Danish serotype 19F (organism)"
          },
          {
            "code" : "419871001",
            "display" : "Streptococcus pneumoniae Danish serotype 5 (organism)"
          },
          {
            "code" : "419527005",
            "display" : "Streptococcus pneumoniae Danish serotype 2 (organism)"
          },
          {
            "code" : "419305002",
            "display" : "Streptococcus pneumoniae Danish serotype 12F (organism)"
          },
          {
            "code" : "419167001",
            "display" : "Streptococcus pneumoniae Danish serotype 9A (organism)"
          },
          {
            "code" : "419071000",
            "display" : "Streptococcus pneumoniae Danish serotype 11A (organism)"
          },
          {
            "code" : "418909007",
            "display" : "Bacillus anthracis - virulent strain (organism)"
          },
          {
            "code" : "418902003",
            "display" : "Streptococcus pneumoniae Danish serotype 6B (organism)"
          },
          {
            "code" : "418883007",
            "display" : "Streptococcus pneumoniae Danish serotype 9L (organism)"
          },
          {
            "code" : "418759005",
            "display" : "Streptococcus pneumoniae Danish serotype 8 (organism)"
          },
          {
            "code" : "418451009",
            "display" : "Streptococcus pneumoniae Danish serotype 18C (organism)"
          },
          {
            "code" : "418322006",
            "display" : "Streptococcus pneumoniae Danish serotype 9V (organism)"
          },
          {
            "code" : "418217008",
            "display" : "Streptococcus pneumoniae Danish serotype 23F (organism)"
          },
          {
            "code" : "418147001",
            "display" : "Streptococcus pneumoniae serogroup 18 (organism)"
          },
          {
            "code" : "418101009",
            "display" : "Babesia EU1 (organism)"
          },
          {
            "code" : "417943000",
            "display" : "Methicillin susceptible Staphylococcus aureus (organism)"
          },
          {
            "code" : "417797007",
            "display" : "Human respiratory syncytial virus B4 (organism)"
          },
          {
            "code" : "417796003",
            "display" : "Human respiratory syncytial virus B3 (organism)"
          },
          {
            "code" : "417795004",
            "display" : "Human respiratory syncytial virus B2 (organism)"
          },
          {
            "code" : "417794000",
            "display" : "Human respiratory syncytial virus B1 (organism)"
          },
          {
            "code" : "417793006",
            "display" : "Human respiratory syncytial virus A7 (organism)"
          },
          {
            "code" : "417792001",
            "display" : "Human respiratory syncytial virus A6 (organism)"
          },
          {
            "code" : "417791008",
            "display" : "Human respiratory syncytial virus A5 (organism)"
          },
          {
            "code" : "417790009",
            "display" : "Human respiratory syncytial virus A4 (organism)"
          },
          {
            "code" : "417774009",
            "display" : "Human respiratory syncytial virus A3 (organism)"
          },
          {
            "code" : "417773003",
            "display" : "Human respiratory syncytial virus A2 (organism)"
          },
          {
            "code" : "417772008",
            "display" : "Human respiratory syncytial virus A1 (organism)"
          },
          {
            "code" : "417771001",
            "display" : "Human respiratory syncytial virus B (organism)"
          },
          {
            "code" : "417770000",
            "display" : "Human respiratory syncytial virus A (organism)"
          },
          {
            "code" : "417722006",
            "display" : "Cryptosporidium hominis (organism)"
          },
          {
            "code" : "417657001",
            "display" : "Bartonella vinsonii subsp. arupensis (organism)"
          },
          {
            "code" : "417542000",
            "display" : "Rotavirus (organism)"
          },
          {
            "code" : "417443008",
            "display" : "Klebsiella granulomatis (organism)"
          },
          {
            "code" : "417270004",
            "display" : "Streptococcus pneumoniae serogroup 9 (organism)"
          },
          {
            "code" : "417207000",
            "display" : "Escherichia coli, inactive (organism)"
          },
          {
            "code" : "416961000",
            "display" : "Cryptosporidium felis (organism)"
          },
          {
            "code" : "416762004",
            "display" : "Cryptosporidium canis (organism)"
          },
          {
            "code" : "416679003",
            "display" : "Campylobacter hominis (organism)"
          },
          {
            "code" : "416551001",
            "display" : "Borrelia afzelii (organism)"
          },
          {
            "code" : "416435006",
            "display" : "Measles virus, viral envelope M protein variant (organism)"
          },
          {
            "code" : "416138003",
            "display" : "Rotavirus group A (organism)"
          },
          {
            "code" : "415983007",
            "display" : "Babesia duncani (organism)"
          },
          {
            "code" : "415981009",
            "display" : "Babesia MO1 (organism)"
          },
          {
            "code" : "415979007",
            "display" : "Babesia CA3 (organism)"
          },
          {
            "code" : "415904003",
            "display" : "Cryptococcus neoformans serotype A (organism)"
          },
          {
            "code" : "415864001",
            "display" : "Yersinia enterocolitica, not O:3; O:8; or O:5,27 (organism)"
          },
          {
            "code" : "415863007",
            "display" : "Yersinia enterocolitica serogroup O:5, 27 (organism)"
          },
          {
            "code" : "415862002",
            "display" : "Yersinia enterocolitica serogroup O:4,32 (organism)"
          },
          {
            "code" : "415861009",
            "display" : "Yersinia enterocolitica serogroup O:2a,3 (organism)"
          },
          {
            "code" : "415860005",
            "display" : "Yersinia enterocolitica serogroup O:21 (organism)"
          },
          {
            "code" : "415859000",
            "display" : "Yersinia enterocolitica serogroup O:20 (organism)"
          },
          {
            "code" : "415858008",
            "display" : "Yersinia enterocolitica serogroup O:19 (organism)"
          },
          {
            "code" : "415857003",
            "display" : "Yersinia enterocolitica serogroup O:13a,13b (organism)"
          },
          {
            "code" : "415856007",
            "display" : "Yersinia enterocolitica serogroup O:12, 25 (organism)"
          },
          {
            "code" : "415855006",
            "display" : "Yersinia enterocolitica serogroup O:1,2a,3 (organism)"
          },
          {
            "code" : "415854005",
            "display" : "Yersinia enterocolitica non-serogroupable (organism)"
          },
          {
            "code" : "415820009",
            "display" : "Vibrio cholerae, non-O139 (organism)"
          },
          {
            "code" : "415819003",
            "display" : "Vibrio cholerae, non-O1/non-O139 (organism)"
          },
          {
            "code" : "415621005",
            "display" : "Streptococcus pneumoniae serogroup 10 (organism)"
          },
          {
            "code" : "415619000",
            "display" : "Streptococcus pneumoniae Danish serotype 7A (organism)"
          },
          {
            "code" : "415618008",
            "display" : "Streptococcus pneumoniae serogroup 6 (organism)"
          },
          {
            "code" : "415616007",
            "display" : "Streptococcus pneumoniae Danish serotype 4 (organism)"
          },
          {
            "code" : "415614005",
            "display" : "Streptococcus pneumoniae serogroup 33 (organism)"
          },
          {
            "code" : "415613004",
            "display" : "Streptococcus pneumoniae serogroup 23 (organism)"
          },
          {
            "code" : "415611002",
            "display" : "Streptococcus pneumoniae Danish serotype 19A (organism)"
          },
          {
            "code" : "415610001",
            "display" : "Streptococcus pneumoniae Danish serotype 15B (organism)"
          },
          {
            "code" : "415609006",
            "display" : "Streptococcus pneumoniae serogroup 15 (organism)"
          },
          {
            "code" : "415608003",
            "display" : "Streptococcus pneumoniae Danish serotype 10A (organism)"
          },
          {
            "code" : "415607008",
            "display" : "Streptococcus pneumoniae Danish serotype 1 (organism)"
          },
          {
            "code" : "415534000",
            "display" : "Small-colony-forming beta-hemolytic group A streptococci (organism)"
          },
          {
            "code" : "415360003",
            "display" : "SARS coronavirus (organism)"
          },
          {
            "code" : "415343008",
            "display" : "Rickettsia, typhus group (organism)"
          },
          {
            "code" : "415342003",
            "display" : "Rickettsia, spotted fever group (organism)"
          },
          {
            "code" : "415341005",
            "display" : "Rickettsia felis (organism)"
          },
          {
            "code" : "414810006",
            "display" : "Neisseria meningitidis non-groupable (organism)"
          },
          {
            "code" : "414809001",
            "display" : "Neisseria gonorrhoeae, beta lactamase negative (organism)"
          },
          {
            "code" : "414790002",
            "display" : "Mycoplasma species, not Mycoplasma pneumoniae (organism)"
          },
          {
            "code" : "414789006",
            "display" : "Mycobacterium canettii (organism)"
          },
          {
            "code" : "414754009",
            "display" : "Mold resembling Coccidioides immitis (organism)"
          },
          {
            "code" : "414577006",
            "display" : "Large-colony-forming beta-hemolytic group A streptococci (organism)"
          },
          {
            "code" : "413880008",
            "display" : "Clostridium botulinum, non-toxin production (organism)"
          },
          {
            "code" : "413643004",
            "display" : "Beta-hemolytic Streptococcus, group A (organism)"
          },
          {
            "code" : "409807008",
            "display" : "Penicillin resistant Streptococcus pneumoniae (organism)"
          },
          {
            "code" : "409806004",
            "display" : "Multiple drug-resistant Streptococcus pneumoniae (organism)"
          },
          {
            "code" : "409805000",
            "display" : "Fluoroquinolone-resistant Neisseria gonorrhoeae (organism)"
          },
          {
            "code" : "407479009",
            "display" : "Influenza A virus (organism)"
          },
          {
            "code" : "407359000",
            "display" : "Norovirus (organism)"
          },
          {
            "code" : "407310004",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O rough:H9 (organism)"
          },
          {
            "code" : "407308001",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O172:nonmotile (organism)"
          },
          {
            "code" : "407306002",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O165:H25 (organism)"
          },
          {
            "code" : "407305003",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O165:nonmotile (organism)"
          },
          {
            "code" : "407303005",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O163:H19 (organism)"
          },
          {
            "code" : "407301007",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O153:H25 (organism)"
          },
          {
            "code" : "407300008",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O153:H2 (organism)"
          },
          {
            "code" : "407299000",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O145:nonmotile (organism)"
          },
          {
            "code" : "407298008",
            "display" : "Escherichia coli serogroup O145 (organism)"
          },
          {
            "code" : "407297003",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O137:H41 (organism)"
          },
          {
            "code" : "407295006",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O128:H45 (organism)"
          },
          {
            "code" : "407294005",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O128:nonmotile (organism)"
          },
          {
            "code" : "407293004",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O121:H19 (organism)"
          },
          {
            "code" : "407292009",
            "display" : "Escherichia coli serogroup O121 (organism)"
          },
          {
            "code" : "407291002",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O118:H16 (organism)"
          },
          {
            "code" : "407290001",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O118:H12 (organism)"
          },
          {
            "code" : "407289005",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O118:H2 (organism)"
          },
          {
            "code" : "407287007",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O113:H21 (organism)"
          },
          {
            "code" : "407285004",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O111:H8 (organism)"
          },
          {
            "code" : "407284000",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O104:H21 (organism)"
          },
          {
            "code" : "407283006",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O104:nonmotile (organism)"
          },
          {
            "code" : "407281008",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O103:H2 (organism)"
          },
          {
            "code" : "407280009",
            "display" : "Escherichia coli serogroup O103 (organism)"
          },
          {
            "code" : "407279006",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O91:H21 (organism)"
          },
          {
            "code" : "407278003",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O91:H10 (organism)"
          },
          {
            "code" : "407277008",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O91:nonmotile (organism)"
          },
          {
            "code" : "407275000",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O83:H1 (organism)"
          },
          {
            "code" : "407273007",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O79:H7 (organism)"
          },
          {
            "code" : "407271009",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O50:H7 (organism)"
          },
          {
            "code" : "407269009",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O48:H21 (organism)"
          },
          {
            "code" : "407267006",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O45:H2 (organism)"
          },
          {
            "code" : "407266002",
            "display" : "Escherichia coli serogroup O45 (organism)"
          },
          {
            "code" : "407265003",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O26:H11 (organism)"
          },
          {
            "code" : "407264004",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O26:nonmotile (organism)"
          },
          {
            "code" : "407263005",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O22:H8 (organism)"
          },
          {
            "code" : "407262000",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O22:H5 (organism)"
          },
          {
            "code" : "407260008",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O14:nonmotile (organism)"
          },
          {
            "code" : "407258006",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O9:nonmotile (organism)"
          },
          {
            "code" : "407256005",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O5:nonmotile (organism)"
          },
          {
            "code" : "407254008",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O2:H7 (organism)"
          },
          {
            "code" : "407253002",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O2:H6 (organism)"
          },
          {
            "code" : "407251000",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O1:nonmotile (organism)"
          },
          {
            "code" : "407222004",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O128:H2 (organism)"
          },
          {
            "code" : "407199008",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O55:H7 (organism)"
          },
          {
            "code" : "407160000",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O111:H2 (organism)"
          },
          {
            "code" : "407159005",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O111:nonmotile (organism)"
          },
          {
            "code" : "406962002",
            "display" : "Vancomycin intermediate Staphylococcus aureus (organism)"
          },
          {
            "code" : "406645005",
            "display" : "Coccidioides posadasii (organism)"
          },
          {
            "code" : "406504006",
            "display" : "Shigella sonnei (Subgroup D) (organism)"
          },
          {
            "code" : "406503000",
            "display" : "Shigella flexneri serotype undetermined (Subgroup B) (organism)"
          },
          {
            "code" : "406502005",
            "display" : "Shigella flexneri 5b [V:7,8] (organism)"
          },
          {
            "code" : "406501003",
            "display" : "Shigella flexneri 5a [V:3,4] (organism)"
          },
          {
            "code" : "406500002",
            "display" : "Shigella flexneri 4c [IV:7,8] (organism)"
          },
          {
            "code" : "406498003",
            "display" : "Shigella dysenteriae 14 (organism)"
          },
          {
            "code" : "406497008",
            "display" : "Shigella dysenteriae 15 (organism)"
          },
          {
            "code" : "406496004",
            "display" : "Shigella dysenteriae 13 (organism)"
          },
          {
            "code" : "406495000",
            "display" : "Shigella dysenteriae 12 (organism)"
          },
          {
            "code" : "406494001",
            "display" : "Shigella dysenteriae 11 (organism)"
          },
          {
            "code" : "406493007",
            "display" : "Shigella boydii serotype undetermined (Subgroup C) (organism)"
          },
          {
            "code" : "406492002",
            "display" : "Shigella boydii 20 [Provisional Serotype SH108(99-4528)] (organism)"
          },
          {
            "code" : "406491009",
            "display" : "Shigella boydii 19 [Provisional Serotype E16553] (organism)"
          },
          {
            "code" : "406490005",
            "display" : "Shigella boydii 18 (organism)"
          },
          {
            "code" : "406489001",
            "display" : "Shigella boydii 17 (organism)"
          },
          {
            "code" : "406488009",
            "display" : "Shigella boydii 16 (organism)"
          },
          {
            "code" : "406487004",
            "display" : "Provisional shigella Y394 (organism)"
          },
          {
            "code" : "406486008",
            "display" : "Provisional shigella E670/74 (organism)"
          },
          {
            "code" : "406485007",
            "display" : "Provisional shigella E28938 (organism)"
          },
          {
            "code" : "406484006",
            "display" : "Provisional shigella 96-265 (organism)"
          },
          {
            "code" : "406483000",
            "display" : "Provisional shigella 96-204 (organism)"
          },
          {
            "code" : "406482005",
            "display" : "Provisional shigella 93-119 (organism)"
          },
          {
            "code" : "406481003",
            "display" : "Provisional shigella 89-141 (organism)"
          },
          {
            "code" : "406480002",
            "display" : "Provisional shigella 88-893 [-: (6)] (organism)"
          },
          {
            "code" : "406479000",
            "display" : "Provisional shigella 3162-96 (organism)"
          },
          {
            "code" : "406478008",
            "display" : "Provisional shigella 3065-93 (organism)"
          },
          {
            "code" : "404680007",
            "display" : "Vancomycin resistant Staphylococcus aureus (organism)"
          },
          {
            "code" : "401198008",
            "display" : "Legionella serotype (organism)"
          },
          {
            "code" : "398620001",
            "display" : "Salmonella enterica subsp. indica (organism)"
          },
          {
            "code" : "398559003",
            "display" : "Salmonella group O:9 (organism)"
          },
          {
            "code" : "398508004",
            "display" : "Salmonella enterica subsp. enterica (organism)"
          },
          {
            "code" : "398506000",
            "display" : "Vibrio cholerae, non-O1 (organism)"
          },
          {
            "code" : "398488004",
            "display" : "Salmonella enterica subsp. salamae (organism)"
          },
          {
            "code" : "398467008",
            "display" : "Salmonella group O:4 (organism)"
          },
          {
            "code" : "398436006",
            "display" : "Salmonella group O:3,10 (organism)"
          },
          {
            "code" : "398429005",
            "display" : "Salmonella group O:11 (organism)"
          },
          {
            "code" : "398428002",
            "display" : "Salmonella enterica subsp. diarizonae (organism)"
          },
          {
            "code" : "398426003",
            "display" : "Salmonella group O:2 (organism)"
          },
          {
            "code" : "398393000",
            "display" : "Salmonella bongori (organism)"
          },
          {
            "code" : "398371005",
            "display" : "Salmonella enterica subsp. houtenae (organism)"
          },
          {
            "code" : "398367007",
            "display" : "Non-cholerae vibrio (organism)"
          },
          {
            "code" : "398364000",
            "display" : "Salmonella group O:8 (organism)"
          },
          {
            "code" : "398349000",
            "display" : "Salmonella group O:13 (organism)"
          },
          {
            "code" : "397502001",
            "display" : "Salmonella enterica subsp. arizonae (organism)"
          },
          {
            "code" : "397426001",
            "display" : "Toxigenic Corynebacterium (organism)"
          },
          {
            "code" : "387798006",
            "display" : "Photobacterium damselae (organism)"
          },
          {
            "code" : "385509008",
            "display" : "Mycobacterium elephantis (organism)"
          },
          {
            "code" : "385508000",
            "display" : "Mycobacterium septicum (organism)"
          },
          {
            "code" : "385507005",
            "display" : "Mycobacterium mageritense (organism)"
          },
          {
            "code" : "385506001",
            "display" : "Mycobacterium murale (organism)"
          },
          {
            "code" : "372926008",
            "display" : "Chlamydophila (organism)"
          },
          {
            "code" : "363769000",
            "display" : "Entamoeba histolytica/Entamoeba dispar complex (organism)"
          },
          {
            "code" : "363768008",
            "display" : "Streptococcus pneumoniae serogroup 11 (organism)"
          },
          {
            "code" : "363767003",
            "display" : "Streptococcus pneumoniae serogroup 22 (organism)"
          },
          {
            "code" : "363762009",
            "display" : "Yersinia enterocolitica serogroup O:48 (organism)"
          },
          {
            "code" : "333873003",
            "display" : "Mycobacterium fortuitum subsp fortuitum (organism)"
          },
          {
            "code" : "312411000",
            "display" : "Variola minor virus (organism)"
          },
          {
            "code" : "312410004",
            "display" : "Variola major virus (organism)"
          },
          {
            "code" : "312330004",
            "display" : "Rickettsia peacockii (organism)"
          },
          {
            "code" : "311508002",
            "display" : "Sabia virus (organism)"
          },
          {
            "code" : "311506003",
            "display" : "Guanarito virus (organism)"
          },
          {
            "code" : "302561004",
            "display" : "Mycobacterium borstelense (organism)"
          },
          {
            "code" : "277504006",
            "display" : "Spectinomycin-resistant Neisseria gonorrhoeae (organism)"
          },
          {
            "code" : "277503000",
            "display" : "Cephalosporin-resistant Neisseria gonorrhoeae (organism)"
          },
          {
            "code" : "277502005",
            "display" : "Tetracycline-resistant Neisseria gonorrhoeae (organism)"
          },
          {
            "code" : "277501003",
            "display" : "Penicillinase-producing Neisseria gonorrhoeae (organism)"
          },
          {
            "code" : "243639005",
            "display" : "Gerstmann-Straussler syndrome agent (organism)"
          },
          {
            "code" : "243638002",
            "display" : "Human spongiform encephalopathy agent (organism)"
          },
          {
            "code" : "243617008",
            "display" : "California serogroup Orthobunyavirus (organism)"
          },
          {
            "code" : "243604005",
            "display" : "Dengue virus subgroup (organism)"
          },
          {
            "code" : "243601002",
            "display" : "Eastern equine encephalitis virus (organism)"
          },
          {
            "code" : "243568000",
            "display" : "Variola virus (organism)"
          },
          {
            "code" : "243509006",
            "display" : "Histoplasma capsulatum var capsulatum (organism)"
          },
          {
            "code" : "243468002",
            "display" : "Cryptococcus neoformans var neoformans (organism)"
          },
          {
            "code" : "243378003",
            "display" : "Mycobacterium fortuitum (organism)"
          },
          {
            "code" : "243377008",
            "display" : "Mycobacteroides chelonae (organism)"
          },
          {
            "code" : "243376004",
            "display" : "Mycobacterium avium brunese (organism)"
          },
          {
            "code" : "243373007",
            "display" : "Mycobacterium tuberculosis African II variant (organism)"
          },
          {
            "code" : "243372002",
            "display" : "Mycobacterium tuberculosis African I variant (organism)"
          },
          {
            "code" : "243371009",
            "display" : "Mycobacterium tuberculosis Asian variant (organism)"
          },
          {
            "code" : "243370005",
            "display" : "Mycobacterium tuberculosis classical variant (organism)"
          },
          {
            "code" : "243360008",
            "display" : "Ehrlichia ewingii (organism)"
          },
          {
            "code" : "243357001",
            "display" : "Campylobacter sputorum biovar fecalis (organism)"
          },
          {
            "code" : "243352007",
            "display" : "Bartonella bacilliformis (organism)"
          },
          {
            "code" : "243284003",
            "display" : "Listeria ivanovii londoniensis (organism)"
          },
          {
            "code" : "243255007",
            "display" : "Corynebacterium diphtheriae var belfanti (organism)"
          },
          {
            "code" : "131363003",
            "display" : "Streptococcus pneumoniae Danish serotype 29 (organism)"
          },
          {
            "code" : "131362008",
            "display" : "Streptococcus pneumoniae serogroup 16 (organism)"
          },
          {
            "code" : "131361001",
            "display" : "Streptococcus pneumoniae serogroup 17 (organism)"
          },
          {
            "code" : "131326007",
            "display" : "Legionella pneumophilia serogroup 14 (organism)"
          },
          {
            "code" : "131325006",
            "display" : "Legionella pneumophilia serogroup 13 (organism)"
          },
          {
            "code" : "131324005",
            "display" : "Legionella pneumophilia serogroup 12 (organism)"
          },
          {
            "code" : "131323004",
            "display" : "Legionella pneumophilia serogroup 11 (organism)"
          },
          {
            "code" : "131322009",
            "display" : "Legionella pneumophilia serogroup 10 (organism)"
          },
          {
            "code" : "131261003",
            "display" : "Escherichia coli serogroup O111 (organism)"
          },
          {
            "code" : "131260002",
            "display" : "Escherichia coli serogroup O26 (organism)"
          },
          {
            "code" : "127541006",
            "display" : "Streptococcus pneumoniae serogroup 19 (organism)"
          },
          {
            "code" : "127523003",
            "display" : "Mycobacterium wolinskyi (organism)"
          },
          {
            "code" : "127522008",
            "display" : "Mycobacterium goodii (organism)"
          },
          {
            "code" : "127512002",
            "display" : "Haemophilus influenzae, biotype VIII (organism)"
          },
          {
            "code" : "127511009",
            "display" : "Haemophilus influenzae, biotype VII (organism)"
          },
          {
            "code" : "127510005",
            "display" : "Haemophilus influenzae, biotype VI (organism)"
          },
          {
            "code" : "127509000",
            "display" : "Haemophilus influenzae, biotype V (organism)"
          },
          {
            "code" : "127508008",
            "display" : "Haemophilus influenzae, biotype IV (organism)"
          },
          {
            "code" : "127507003",
            "display" : "Haemophilus influenzae, biotype III (organism)"
          },
          {
            "code" : "127506007",
            "display" : "Haemophilus influenzae, biotype II (organism)"
          },
          {
            "code" : "127505006",
            "display" : "Haemophilus influenzae, biotype I (organism)"
          },
          {
            "code" : "125048009",
            "display" : "Vibrio cholerae serogroup O139 (organism)"
          },
          {
            "code" : "125042005",
            "display" : "Neisseria meningitidis serogroup Z (organism)"
          },
          {
            "code" : "125041003",
            "display" : "Neisseria meningitidis serogroup X (organism)"
          },
          {
            "code" : "125036006",
            "display" : "Shigella boydii, serovar 15 (organism)"
          },
          {
            "code" : "125035005",
            "display" : "Shigella boydii, serovar 14 (organism)"
          },
          {
            "code" : "125034009",
            "display" : "Shigella boydii, serovar 13 (organism)"
          },
          {
            "code" : "125033003",
            "display" : "Shigella boydii, serovar 12 (organism)"
          },
          {
            "code" : "125032008",
            "display" : "Shigella boydii, serovar 11 (organism)"
          },
          {
            "code" : "125031001",
            "display" : "Shigella boydii, serovar 10 (organism)"
          },
          {
            "code" : "125030000",
            "display" : "Shigella boydii, serovar 9 (organism)"
          },
          {
            "code" : "125029005",
            "display" : "Shigella boydii, serovar 8 (organism)"
          },
          {
            "code" : "125028002",
            "display" : "Shigella boydii, serovar 7 (organism)"
          },
          {
            "code" : "125027007",
            "display" : "Shigella boydii, serovar 6 (organism)"
          },
          {
            "code" : "125026003",
            "display" : "Shigella boydii, serovar 5 (organism)"
          },
          {
            "code" : "125025004",
            "display" : "Shigella boydii, serovar 4 (organism)"
          },
          {
            "code" : "125024000",
            "display" : "Shigella boydii, serovar 3 (organism)"
          },
          {
            "code" : "125023006",
            "display" : "Shigella boydii, serovar 2 (organism)"
          },
          {
            "code" : "125022001",
            "display" : "Shigella boydii, serovar 1 (organism)"
          },
          {
            "code" : "125021008",
            "display" : "Shigella flexneri, serovar Y (organism)"
          },
          {
            "code" : "125020009",
            "display" : "Shigella flexneri, serovar X (organism)"
          },
          {
            "code" : "125019003",
            "display" : "Shigella flexneri, serovar 6 (organism)"
          },
          {
            "code" : "125018006",
            "display" : "Shigella flexneri, serovar 5 (organism)"
          },
          {
            "code" : "125017001",
            "display" : "Shigella flexneri, serovar 4b (organism)"
          },
          {
            "code" : "125016005",
            "display" : "Shigella flexneri, serovar 4a (organism)"
          },
          {
            "code" : "125015009",
            "display" : "Shigella flexneri, serovar 4 (organism)"
          },
          {
            "code" : "125014008",
            "display" : "Shigella flexneri, serovar 3c (organism)"
          },
          {
            "code" : "125013002",
            "display" : "Shigella flexneri, serovar 3b (organism)"
          },
          {
            "code" : "125012007",
            "display" : "Shigella flexneri, serovar 3a (organism)"
          },
          {
            "code" : "125011000",
            "display" : "Shigella flexneri, serovar 3 (organism)"
          },
          {
            "code" : "125010004",
            "display" : "Shigella flexneri, serovar 2b (organism)"
          },
          {
            "code" : "125009009",
            "display" : "Shigella flexneri, serovar 2a (organism)"
          },
          {
            "code" : "125008001",
            "display" : "Shigella flexneri, serovar 2 (organism)"
          },
          {
            "code" : "125007006",
            "display" : "Shigella flexneri, serovar 1b (organism)"
          },
          {
            "code" : "125006002",
            "display" : "Shigella flexneri, serovar 1a (organism)"
          },
          {
            "code" : "125005003",
            "display" : "Shigella flexneri, serovar 1 (organism)"
          },
          {
            "code" : "125004004",
            "display" : "Shigella dysenteriae, serovar 10 (organism)"
          },
          {
            "code" : "125003005",
            "display" : "Shigella dysenteriae, serovar 9 (organism)"
          },
          {
            "code" : "125002000",
            "display" : "Shigella dysenteriae, serovar 8 (organism)"
          },
          {
            "code" : "125001007",
            "display" : "Shigella dysenteriae, serovar 7 (organism)"
          },
          {
            "code" : "125000008",
            "display" : "Shigella dysenteriae, serovar 6 (organism)"
          },
          {
            "code" : "124999008",
            "display" : "Shigella dysenteriae, serovar 5 (organism)"
          },
          {
            "code" : "124998000",
            "display" : "Shigella dysenteriae, serovar 4 (organism)"
          },
          {
            "code" : "124997005",
            "display" : "Shigella dysenteriae, serovar 3 (organism)"
          },
          {
            "code" : "124996001",
            "display" : "Shigella dysenteriae, serovar 2 (organism)"
          },
          {
            "code" : "124995002",
            "display" : "Shigella dysenteriae, serovar 1 (organism)"
          },
          {
            "code" : "124994003",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O157:non-motile (organism)"
          },
          {
            "code" : "116665009",
            "display" : "Bayou virus (organism)"
          },
          {
            "code" : "116664008",
            "display" : "Black Creek Canal virus (organism)"
          },
          {
            "code" : "116663002",
            "display" : "Sin Nombre virus (organism)"
          },
          {
            "code" : "116662007",
            "display" : "Dobrava-Belgrade virus (organism)"
          },
          {
            "code" : "116503007",
            "display" : "Yersinia enterocoltica, serogroup O:8,14 (organism)"
          },
          {
            "code" : "116502002",
            "display" : "Yersinia enterocolitica, serogroup O:13 (organism)"
          },
          {
            "code" : "116500005",
            "display" : "Streptococcus pneumoniae serogroup 12 (organism)"
          },
          {
            "code" : "116495007",
            "display" : "Scotochromogenic mycobacteria (organism)"
          },
          {
            "code" : "116494006",
            "display" : "Rapid growing mycobacteria (organism)"
          },
          {
            "code" : "116492005",
            "display" : "Photochromogenic mycobacteria (organism)"
          },
          {
            "code" : "116401006",
            "display" : "Leptospira interrogans (organism)"
          },
          {
            "code" : "116399000",
            "display" : "Burkholderia pseudomallei (organism)"
          },
          {
            "code" : "116395006",
            "display" : "Enterohemorrhagic Escherichia coli (organism)"
          },
          {
            "code" : "116386003",
            "display" : "Campylobacter lari (organism)"
          },
          {
            "code" : "116380009",
            "display" : "Legionella micdadei (organism)"
          },
          {
            "code" : "116379006",
            "display" : "Legionella maceachernii (organism)"
          },
          {
            "code" : "116037008",
            "display" : "Campylobacter curvus (organism)"
          },
          {
            "code" : "115517006",
            "display" : "Legionella, non-pneumophia species (organism)"
          },
          {
            "code" : "115516002",
            "display" : "Legionella longbeachae, serogroup 2 (organism)"
          },
          {
            "code" : "115515003",
            "display" : "Legionella longbeachae, serogroup 1 (organism)"
          },
          {
            "code" : "115407004",
            "display" : "Haemophilus influenzae, not b (organism)"
          },
          {
            "code" : "115329001",
            "display" : "Methicillin resistant Staphylococcus aureus (organism)"
          },
          {
            "code" : "115328009",
            "display" : "Chlamydia trachomatis, serotype H (organism)"
          },
          {
            "code" : "115319008",
            "display" : "Chlamydia trachomatis, serotype G (organism)"
          },
          {
            "code" : "115318000",
            "display" : "Chlamydia trachomatis, serotype L3 (organism)"
          },
          {
            "code" : "115301004",
            "display" : "Chlamydia trachomatis, serotype L2 (organism)"
          },
          {
            "code" : "115300003",
            "display" : "Chlamydia trachomatis, serotype L1 (organism)"
          },
          {
            "code" : "115299006",
            "display" : "Chlamydia trachomatis, serotype L (organism)"
          },
          {
            "code" : "115298003",
            "display" : "Chlamydia trachomatis, serotype K (organism)"
          },
          {
            "code" : "115297008",
            "display" : "Chlamydia trachomatis, serotype J (organism)"
          },
          {
            "code" : "115296004",
            "display" : "Chlamydia trachomatis, serotype I (organism)"
          },
          {
            "code" : "115295000",
            "display" : "Chlamydia trachomatis, serotype F (organism)"
          },
          {
            "code" : "115294001",
            "display" : "Chlamydia trachomatis, serotype E (organism)"
          },
          {
            "code" : "115293007",
            "display" : "Chlamydia trachomatis, serotype D (organism)"
          },
          {
            "code" : "115292002",
            "display" : "Chlamydia trachomatis, serotype C (organism)"
          },
          {
            "code" : "115291009",
            "display" : "Chlamydia trachomatis, serotype Ba (organism)"
          },
          {
            "code" : "115290005",
            "display" : "Chlamydia trachomatis, serotype B (organism)"
          },
          {
            "code" : "115289001",
            "display" : "Chlamydia trachomatis, serotype A (organism)"
          },
          {
            "code" : "114229008",
            "display" : "Bartonella vinsonii ss vinsonii (organism)"
          },
          {
            "code" : "114228000",
            "display" : "Bartonella vinsonii ss berkhoffii (organism)"
          },
          {
            "code" : "114221006",
            "display" : "Rickettsia massiliae (organism)"
          },
          {
            "code" : "114220007",
            "display" : "Rickettsia japonica (organism)"
          },
          {
            "code" : "114219001",
            "display" : "Rickettsia helvetica (organism)"
          },
          {
            "code" : "114218009",
            "display" : "Rickettsia africae (organism)"
          },
          {
            "code" : "114217004",
            "display" : "Rickettsia aeschlimannii (organism)"
          },
          {
            "code" : "113961008",
            "display" : "Staphylococcus aureus ss aureus (organism)"
          },
          {
            "code" : "113861009",
            "display" : "Mycobacterium tuberculosis (organism)"
          },
          {
            "code" : "113860005",
            "display" : "Mycobacterium triplex (organism)"
          },
          {
            "code" : "113859000",
            "display" : "Mycobacterium peregrinum (organism)"
          },
          {
            "code" : "113858008",
            "display" : "Mycobacterium tuberculosis complex (organism)"
          },
          {
            "code" : "113857003",
            "display" : "Mycobacterium novocastrense (organism)"
          },
          {
            "code" : "113856007",
            "display" : "Mycobacterium mucogenicum (organism)"
          },
          {
            "code" : "113854005",
            "display" : "Mycobacterium madagascariense (organism)"
          },
          {
            "code" : "113853004",
            "display" : "Mycobacterium lentiflavum (organism)"
          },
          {
            "code" : "113852009",
            "display" : "Mycobacterium intermedium (organism)"
          },
          {
            "code" : "113851002",
            "display" : "Mycobacterium interjectum (organism)"
          },
          {
            "code" : "113850001",
            "display" : "Mycobacterium hodleri (organism)"
          },
          {
            "code" : "113849001",
            "display" : "Mycobacterium hiberniae (organism)"
          },
          {
            "code" : "113848009",
            "display" : "Mycobacterium hassiacum (organism)"
          },
          {
            "code" : "113847004",
            "display" : "Mycobacterium cookii (organism)"
          },
          {
            "code" : "113846008",
            "display" : "Mycobacterium conspicuum (organism)"
          },
          {
            "code" : "113845007",
            "display" : "Mycobacterium confluentis (organism)"
          },
          {
            "code" : "113844006",
            "display" : "Mycobacterium brumae (organism)"
          },
          {
            "code" : "113842005",
            "display" : "Mycobacterium avium ss silvaticum (organism)"
          },
          {
            "code" : "113841003",
            "display" : "Mycobacterium avium ss paratuberculosis (organism)"
          },
          {
            "code" : "113840002",
            "display" : "Mycobacterium avium ss avium (organism)"
          },
          {
            "code" : "113839004",
            "display" : "Mycobacterium alvei (organism)"
          },
          {
            "code" : "113838007",
            "display" : "Mycobacteroides abscessus (organism)"
          },
          {
            "code" : "113816005",
            "display" : "Leptospira weilii (organism)"
          },
          {
            "code" : "113815009",
            "display" : "Leptospira santarosai (organism)"
          },
          {
            "code" : "113813002",
            "display" : "Leptospira noguchii (organism)"
          },
          {
            "code" : "113812007",
            "display" : "Leptospira meyeri (organism)"
          },
          {
            "code" : "113811000",
            "display" : "Leptospira kirschneri (organism)"
          },
          {
            "code" : "113810004",
            "display" : "Leptospira inadai (organism)"
          },
          {
            "code" : "113809009",
            "display" : "Leptospira borgpetersenii (organism)"
          },
          {
            "code" : "113808001",
            "display" : "Legionella waltersii (organism)"
          },
          {
            "code" : "113807006",
            "display" : "Legionella quateirensis (organism)"
          },
          {
            "code" : "113806002",
            "display" : "Legionella lytica (organism)"
          },
          {
            "code" : "113727004",
            "display" : "Vancomycin resistant Enterococcus (organism)"
          },
          {
            "code" : "113724006",
            "display" : "Enterococcus dispar (organism)"
          },
          {
            "code" : "113720002",
            "display" : "Legionella dumoffii (organism)"
          },
          {
            "code" : "113674000",
            "display" : "Burkholderia mallei (organism)"
          },
          {
            "code" : "113565009",
            "display" : "Clostridium argentiense (organism)"
          },
          {
            "code" : "113528007",
            "display" : "Campylobacter gracilis (organism)"
          },
          {
            "code" : "113527002",
            "display" : "Campylobacter hyointestinalis ss hyointestinalis (organism)"
          },
          {
            "code" : "113526006",
            "display" : "Campylobacter showae (organism)"
          },
          {
            "code" : "113525005",
            "display" : "Campylobacter rectus (organism)"
          },
          {
            "code" : "113524009",
            "display" : "Campylobacter jejuni ss jejuni (organism)"
          },
          {
            "code" : "113523003",
            "display" : "Campylobacter jejuni ss doylei (organism)"
          },
          {
            "code" : "113522008",
            "display" : "Campylobacter helveticus (organism)"
          },
          {
            "code" : "113503004",
            "display" : "Borrelia valaisiana (organism)"
          },
          {
            "code" : "113497007",
            "display" : "Borrelia garinii (organism)"
          },
          {
            "code" : "113377003",
            "display" : "Acinetobacter genospecies 3 (organism)"
          },
          {
            "code" : "113376007",
            "display" : "Acinetobacter calcoaceticus-Acinetobacter baumannii complex (organism)"
          },
          {
            "code" : "112351003",
            "display" : "Vibrio cholerae serotype Inaba (organism)"
          },
          {
            "code" : "112283007",
            "display" : "Escherichia coli (organism)"
          },
          {
            "code" : "112277009",
            "display" : "Borrelia (organism)"
          },
          {
            "code" : "110390006",
            "display" : "Entamoeba histolytica cyst (organism)"
          },
          {
            "code" : "110389002",
            "display" : "Entamoeba histolytica trophozoite (organism)"
          },
          {
            "code" : "110379001",
            "display" : "Mycobacterium, non-TB (organism)"
          },
          {
            "code" : "110378009",
            "display" : "Salmonella enterica (organism)"
          },
          {
            "code" : "103561005",
            "display" : "Cyclospora cayetanensis (organism)"
          },
          {
            "code" : "103560006",
            "display" : "Cyclospora (organism)"
          },
          {
            "code" : "103525000",
            "display" : "Prospect Hill virus (organism)"
          },
          {
            "code" : "103513003",
            "display" : "Bartonella elizabethae (organism)"
          },
          {
            "code" : "103512008",
            "display" : "Bartonella vinsonii (organism)"
          },
          {
            "code" : "103511001",
            "display" : "Bartonella quintana (organism)"
          },
          {
            "code" : "103510000",
            "display" : "Bartonella henselae (organism)"
          },
          {
            "code" : "103509005",
            "display" : "Coxiella burnetii, phase II (organism)"
          },
          {
            "code" : "103508002",
            "display" : "Coxiella burnetii, phase I (organism)"
          },
          {
            "code" : "103500009",
            "display" : "Streptococcus pneumoniae Danish serotype 9N (organism)"
          },
          {
            "code" : "103499000",
            "display" : "Streptococcus pneumoniae Danish serotype 7F (organism)"
          },
          {
            "code" : "103498008",
            "display" : "Streptococcus pneumoniae Danish serotype 14 (organism)"
          },
          {
            "code" : "103497003",
            "display" : "Streptococcus pneumoniae Danish serotype 3 (organism)"
          },
          {
            "code" : "103483006",
            "display" : "Neisseria meningitidis serogroup W (organism)"
          },
          {
            "code" : "103482001",
            "display" : "Neisseria meningitidis serogroup Y (organism)"
          },
          {
            "code" : "103481008",
            "display" : "Neisseria meningitidis serogroup C (organism)"
          },
          {
            "code" : "103480009",
            "display" : "Neisseria meningitidis serogroup B (organism)"
          },
          {
            "code" : "103479006",
            "display" : "Neisseria meningitidis serogroup A (organism)"
          },
          {
            "code" : "103476004",
            "display" : "Mycobacterium genavense (organism)"
          },
          {
            "code" : "103474001",
            "display" : "Mycobacterium fortuitum complex (organism)"
          },
          {
            "code" : "103471009",
            "display" : "Legionella pneumophila serogroup 9 (organism)"
          },
          {
            "code" : "103470005",
            "display" : "Legionella pneumophila serogroup 8 (organism)"
          },
          {
            "code" : "103469009",
            "display" : "Legionella pneumophila serogroup 7 (organism)"
          },
          {
            "code" : "103468001",
            "display" : "Legionella pneumophila serogroup 6 (organism)"
          },
          {
            "code" : "103467006",
            "display" : "Legionella pneumophila serogroup 5 (organism)"
          },
          {
            "code" : "103466002",
            "display" : "Legionella pneumophila serogroup 4 (organism)"
          },
          {
            "code" : "103465003",
            "display" : "Legionella pneumophila serogroup 3 (organism)"
          },
          {
            "code" : "103464004",
            "display" : "Legionella pneumophila serogroup 2 (organism)"
          },
          {
            "code" : "103463005",
            "display" : "Legionella pneumophila serogroup 1 (organism)"
          },
          {
            "code" : "103462000",
            "display" : "Legionella worsleiensis (organism)"
          },
          {
            "code" : "103461007",
            "display" : "Legionella tucsonensis (organism)"
          },
          {
            "code" : "103460008",
            "display" : "Legionella shakespearei (organism)"
          },
          {
            "code" : "103459003",
            "display" : "Legionella quinlivanii (organism)"
          },
          {
            "code" : "103458006",
            "display" : "Legionella pneumophila ss. pneumophila (organism)"
          },
          {
            "code" : "103457001",
            "display" : "Legionella pneumophila ss. pascullei (organism)"
          },
          {
            "code" : "103456005",
            "display" : "Legionella pneumophila ss. fraseri (organism)"
          },
          {
            "code" : "103455009",
            "display" : "Legionella nautarum (organism)"
          },
          {
            "code" : "103454008",
            "display" : "Legionella moravica (organism)"
          },
          {
            "code" : "103453002",
            "display" : "Legionella londiniensis (organism)"
          },
          {
            "code" : "103452007",
            "display" : "Legionella lansingensis (organism)"
          },
          {
            "code" : "103451000",
            "display" : "Legionella gratiana (organism)"
          },
          {
            "code" : "103450004",
            "display" : "Legionella geestiana (organism)"
          },
          {
            "code" : "103449004",
            "display" : "Legionella fairfieldensis (organism)"
          },
          {
            "code" : "103448007",
            "display" : "Legionella brunensis (organism)"
          },
          {
            "code" : "103447002",
            "display" : "Legionella adelaidensis (organism)"
          },
          {
            "code" : "103446006",
            "display" : "Haemophilus influenzae type f (organism)"
          },
          {
            "code" : "103445005",
            "display" : "Haemophilus influenzae type e (organism)"
          },
          {
            "code" : "103444009",
            "display" : "Haemophilus influenzae type d (organism)"
          },
          {
            "code" : "103443003",
            "display" : "Haemophilus influenzae type c (organism)"
          },
          {
            "code" : "103442008",
            "display" : "Haemophilus influenzae type b (organism)"
          },
          {
            "code" : "103441001",
            "display" : "Haemophilus influenzae type a (organism)"
          },
          {
            "code" : "103437000",
            "display" : "Enterococcus raffinosus (organism)"
          },
          {
            "code" : "103436009",
            "display" : "Enterococcus pseudoavium (organism)"
          },
          {
            "code" : "103433001",
            "display" : "Yersinia enterocolitica serogroup O:9 (organism)"
          },
          {
            "code" : "103432006",
            "display" : "Yersinia enterocolitica serogroup O:8 (organism)"
          },
          {
            "code" : "103431004",
            "display" : "Yersinia enterocolitica serogroup O:5 (organism)"
          },
          {
            "code" : "103430003",
            "display" : "Yersinia enterocolitica serogroup O:3 (organism)"
          },
          {
            "code" : "103429008",
            "display" : "Enterohemorrhagic Escherichia coli, serotype O157:H7 (organism)"
          },
          {
            "code" : "103428000",
            "display" : "Corynebacterium ulcerans (organism)"
          },
          {
            "code" : "103427005",
            "display" : "Campylobacter upsaliensis (organism)"
          },
          {
            "code" : "91524009",
            "display" : "Campylobacter sputorum (organism)"
          },
          {
            "code" : "91508008",
            "display" : "Francisella tularensis ss. tularensis (organism)"
          },
          {
            "code" : "91336002",
            "display" : "Mycobacterium porcinum (organism)"
          },
          {
            "code" : "91288006",
            "display" : "Acinetobacter baumannii (organism)"
          },
          {
            "code" : "90530002",
            "display" : "Yersinia pseudotuberculosis (organism)"
          },
          {
            "code" : "90272000",
            "display" : "Enterococcus faecium (organism)"
          },
          {
            "code" : "89896008",
            "display" : "Mycobacterium chitae (organism)"
          },
          {
            "code" : "89709001",
            "display" : "Legionella jamestowniensis (organism)"
          },
          {
            "code" : "89605004",
            "display" : "Legionella longbeachae (organism)"
          },
          {
            "code" : "89331006",
            "display" : "Rotavirus group B (organism)"
          },
          {
            "code" : "89293008",
            "display" : "Human immunodeficiency virus type I (organism)"
          },
          {
            "code" : "88520007",
            "display" : "Creutzfeldt-Jakob agent (organism)"
          },
          {
            "code" : "88274000",
            "display" : "Trypanosoma cruzi (organism)"
          },
          {
            "code" : "88227009",
            "display" : "Rotavirus group D (organism)"
          },
          {
            "code" : "87919008",
            "display" : "Trivittatus virus (organism)"
          },
          {
            "code" : "87875008",
            "display" : "Enterococcus avium (organism)"
          },
          {
            "code" : "87402003",
            "display" : "Campylobacter mucosalis (organism)"
          },
          {
            "code" : "87271006",
            "display" : "Legionella sainthelens (organism)"
          },
          {
            "code" : "86432002",
            "display" : "Babesia divergens (organism)"
          },
          {
            "code" : "85944001",
            "display" : "Lassa virus (organism)"
          },
          {
            "code" : "85908006",
            "display" : "Salmonella Paratyphi B (organism)"
          },
          {
            "code" : "85738007",
            "display" : "Rickettsia parkeri (organism)"
          },
          {
            "code" : "85729005",
            "display" : "Shigella flexneri (organism)"
          },
          {
            "code" : "85288000",
            "display" : "Rickettsia sibirica (organism)"
          },
          {
            "code" : "84955006",
            "display" : "Lumbo virus (organism)"
          },
          {
            "code" : "84210007",
            "display" : "Campylobacter fetus (organism)"
          },
          {
            "code" : "84180005",
            "display" : "Mycobacterium simiae (organism)"
          },
          {
            "code" : "83841006",
            "display" : "Mycobacterium intracellulare (organism)"
          },
          {
            "code" : "83821001",
            "display" : "Cryptosporidium (organism)"
          },
          {
            "code" : "83723009",
            "display" : "Mycobacterium avium (organism)"
          },
          {
            "code" : "83675005",
            "display" : "Corynebacterium diphtheriae type gravis (organism)"
          },
          {
            "code" : "83617006",
            "display" : "Hepatitis D virus (organism)"
          },
          {
            "code" : "83358009",
            "display" : "Rotavirus group F (organism)"
          },
          {
            "code" : "83285000",
            "display" : "Enteropathogenic Escherichia coli (organism)"
          },
          {
            "code" : "83088009",
            "display" : "Acinetobacter lwoffii (organism)"
          },
          {
            "code" : "82550008",
            "display" : "Acinetobacter calcoaceticus (organism)"
          },
          {
            "code" : "81951003",
            "display" : "Histoplasma (organism)"
          },
          {
            "code" : "81701001",
            "display" : "Vesicular stomatitis virus (organism)"
          },
          {
            "code" : "81665004",
            "display" : "Hepatitis B virus (organism)"
          },
          {
            "code" : "80897008",
            "display" : "Legionella pneumophila (organism)"
          },
          {
            "code" : "80166006",
            "display" : "Streptococcus pyogenes (organism)"
          },
          {
            "code" : "79875007",
            "display" : "Crimean-Congo hemorrhagic fever virus (organism)"
          },
          {
            "code" : "79817008",
            "display" : "Mycobacterium shimoidei (organism)"
          },
          {
            "code" : "79437004",
            "display" : "Rickettsia rhipicephali (organism)"
          },
          {
            "code" : "79284001",
            "display" : "Rickettsia typhi (organism)"
          },
          {
            "code" : "79128009",
            "display" : "Salmonella Paratyphi A (organism)"
          },
          {
            "code" : "78981005",
            "display" : "Genus Mycoplasma (organism)"
          },
          {
            "code" : "78475006",
            "display" : "Hepatitis E virus (organism)"
          },
          {
            "code" : "78444002",
            "display" : "Mycobacterium sphagni (organism)"
          },
          {
            "code" : "78181009",
            "display" : "Giardia lamblia (organism)"
          },
          {
            "code" : "78167007",
            "display" : "Cysticercus (organism)"
          },
          {
            "code" : "78112006",
            "display" : "Mycobacterium phlei (organism)"
          },
          {
            "code" : "78065002",
            "display" : "Enterococcus faecalis (organism)"
          },
          {
            "code" : "77712002",
            "display" : "Francisella novicida (organism)"
          },
          {
            "code" : "77352002",
            "display" : "Shigella (organism)"
          },
          {
            "code" : "77235003",
            "display" : "San Angelo virus (organism)"
          },
          {
            "code" : "77199003",
            "display" : "Rickettsia montanensis (organism)"
          },
          {
            "code" : "77045006",
            "display" : "Acinetobacter haemolyticus (organism)"
          },
          {
            "code" : "76828008",
            "display" : "Babesia microti (organism)"
          },
          {
            "code" : "76776000",
            "display" : "Rickettsia bellii (organism)"
          },
          {
            "code" : "76327009",
            "display" : "Borrelia burgdorferi (organism)"
          },
          {
            "code" : "75356003",
            "display" : "Mycobacterium fortuitum ss. acetamidolytica (organism)"
          },
          {
            "code" : "75032006",
            "display" : "Klebsiella (organism)"
          },
          {
            "code" : "74917007",
            "display" : "Mycobacterium gadium (organism)"
          },
          {
            "code" : "74746009",
            "display" : "Plasmodium vivax (organism)"
          },
          {
            "code" : "74212009",
            "display" : "Mycobacterium senegalense (organism)"
          },
          {
            "code" : "74028009",
            "display" : "Mycobacterium paratuberculosis (organism)"
          },
          {
            "code" : "73852008",
            "display" : "Enterococcus hirae (organism)"
          },
          {
            "code" : "73576007",
            "display" : "Mycobacterium malmoense (organism)"
          },
          {
            "code" : "73525009",
            "display" : "Salmonella Enteritidis (organism)"
          },
          {
            "code" : "73517007",
            "display" : "Bhanja virus (organism)"
          },
          {
            "code" : "72904005",
            "display" : "Treponema pallidum (organism)"
          },
          {
            "code" : "72829003",
            "display" : "Brucella melitensis (organism)"
          },
          {
            "code" : "72814000",
            "display" : "Legionella santicrucis (organism)"
          },
          {
            "code" : "72477006",
            "display" : "Mycobacterium tokaiense (organism)"
          },
          {
            "code" : "72130005",
            "display" : "Mycobacterium rhodesiae (organism)"
          },
          {
            "code" : "71489006",
            "display" : "Machupo virus (organism)"
          },
          {
            "code" : "70876001",
            "display" : "Corynebacterium diphtheriae type intermedius (organism)"
          },
          {
            "code" : "70801007",
            "display" : "Mycobacterium microti (organism)"
          },
          {
            "code" : "70463000",
            "display" : "Mycobacterium gastri (organism)"
          },
          {
            "code" : "68704007",
            "display" : "Neisseria gonorrhoeae (organism)"
          },
          {
            "code" : "68684004",
            "display" : "Hazara virus (organism)"
          },
          {
            "code" : "68638009",
            "display" : "Bovine spongiform encephalopathy agent (organism)"
          },
          {
            "code" : "67732000",
            "display" : "Khasan virus (organism)"
          },
          {
            "code" : "67168003",
            "display" : "Cryptococcus neoformans (organism)"
          },
          {
            "code" : "66940008",
            "display" : "Mycobacterium aichiense (organism)"
          },
          {
            "code" : "66838002",
            "display" : "Mycobacterium duvalii (organism)"
          },
          {
            "code" : "66635002",
            "display" : "Vibrio cholerae serotype Ogawa (organism)"
          },
          {
            "code" : "66543000",
            "display" : "Campylobacter jejuni (organism)"
          },
          {
            "code" : "65615007",
            "display" : "Blastomyces dermatitidis (organism)"
          },
          {
            "code" : "65613000",
            "display" : "Mycobacterium szulgai (organism)"
          },
          {
            "code" : "65255000",
            "display" : "Yersinia enterocolitica (organism)"
          },
          {
            "code" : "65205008",
            "display" : "Blastomyces (organism)"
          },
          {
            "code" : "65186004",
            "display" : "Klebsiella pneumoniae ss. ozaenae (organism)"
          },
          {
            "code" : "64979004",
            "display" : "California encephalitis virus (organism)"
          },
          {
            "code" : "64930007",
            "display" : "Legionella spiritensis (organism)"
          },
          {
            "code" : "64889004",
            "display" : "Haemophilus ducreyi (organism)"
          },
          {
            "code" : "64694002",
            "display" : "Human rotavirus (organism)"
          },
          {
            "code" : "64589009",
            "display" : "Campylobacter fetus ss. fetus (organism)"
          },
          {
            "code" : "63938009",
            "display" : "Chlamydia trachomatis (organism)"
          },
          {
            "code" : "62987004",
            "display" : "Vibrio cholerae, O1 (organism)"
          },
          {
            "code" : "62944002",
            "display" : "Hepatitis C virus (organism)"
          },
          {
            "code" : "62748005",
            "display" : "Borrelia hermsii (organism)"
          },
          {
            "code" : "62644004",
            "display" : "Mycobacterium pulveris (organism)"
          },
          {
            "code" : "62587007",
            "display" : "Jerry Slough virus (organism)"
          },
          {
            "code" : "62496009",
            "display" : "Bartonella (organism)"
          },
          {
            "code" : "62065006",
            "display" : "Rickettsia (organism)"
          },
          {
            "code" : "61949005",
            "display" : "Toxoplasma (organism)"
          },
          {
            "code" : "61708000",
            "display" : "Mycobacterium farcinogenes (organism)"
          },
          {
            "code" : "61419001",
            "display" : "Giardia (organism)"
          },
          {
            "code" : "61399004",
            "display" : "Keystone virus (organism)"
          },
          {
            "code" : "60927005",
            "display" : "Chlamydophila psittaci variant felis (organism)"
          },
          {
            "code" : "60817000",
            "display" : "Campylobacter fetus ss. venerealis (organism)"
          },
          {
            "code" : "60588009",
            "display" : "Dengue virus, type 1 (organism)"
          },
          {
            "code" : "60558000",
            "display" : "Mycobacterium thamnophis (organism)"
          },
          {
            "code" : "60502008",
            "display" : "Francisella tularensis ss. holarctica (organism)"
          },
          {
            "code" : "59881000",
            "display" : "Rabies virus (organism)"
          },
          {
            "code" : "59774002",
            "display" : "Monkeypox virus (organism)"
          },
          {
            "code" : "59250001",
            "display" : "Ehrlichia chaffeensis (organism)"
          },
          {
            "code" : "59083001",
            "display" : "Neisseria (organism)"
          },
          {
            "code" : "58939000",
            "display" : "Legionella hackeliae (organism)"
          },
          {
            "code" : "58928003",
            "display" : "Campylobacter sputorum ss. sputorum (organism)"
          },
          {
            "code" : "58923007",
            "display" : "Legionella cincinnatiensis (organism)"
          },
          {
            "code" : "58869008",
            "display" : "Mycobacterium marinum (organism)"
          },
          {
            "code" : "58768005",
            "display" : "Mycobacterium poriferae (organism)"
          },
          {
            "code" : "58663006",
            "display" : "Mycobacterium xenopi (organism)"
          },
          {
            "code" : "58503001",
            "display" : "Mycobacterium, avium-intracellulare group (organism)"
          },
          {
            "code" : "58432001",
            "display" : "St. Louis encephalitis virus (organism)"
          },
          {
            "code" : "58242002",
            "display" : "Mycobacterium leprae (organism)"
          },
          {
            "code" : "58234003",
            "display" : "Arenavirus (organism)"
          },
          {
            "code" : "57311007",
            "display" : "West Nile virus (organism)"
          },
          {
            "code" : "56596006",
            "display" : "Histoplasma capsulatum (organism)"
          },
          {
            "code" : "56415008",
            "display" : "Klebsiella pneumoniae (organism)"
          },
          {
            "code" : "56395006",
            "display" : "Plasmodium malariae (organism)"
          },
          {
            "code" : "55905000",
            "display" : "Vibrio vulnificus (organism)"
          },
          {
            "code" : "55462008",
            "display" : "Shigella boydii (organism)"
          },
          {
            "code" : "55288009",
            "display" : "Genus Vesiculovirus (organism)"
          },
          {
            "code" : "55174004",
            "display" : "Human poliovirus 2 (organism)"
          },
          {
            "code" : "55032007",
            "display" : "Listeria ivanovii (organism)"
          },
          {
            "code" : "54925005",
            "display" : "Mycobacterium vaccae (organism)"
          },
          {
            "code" : "54365000",
            "display" : "Yersinia pestis (organism)"
          },
          {
            "code" : "53447008",
            "display" : "Rickettsia australis (organism)"
          },
          {
            "code" : "53233007",
            "display" : "Enterococcus gallinarum (organism)"
          },
          {
            "code" : "53114006",
            "display" : "Mycobacterium smegmatis (organism)"
          },
          {
            "code" : "52779006",
            "display" : "Hantaan virus (organism)"
          },
          {
            "code" : "52584002",
            "display" : "Measles morbillivirus (organism)"
          },
          {
            "code" : "52462004",
            "display" : "Legionella cherrii (organism)"
          },
          {
            "code" : "51526001",
            "display" : "Francisella tularensis (organism)"
          },
          {
            "code" : "51504002",
            "display" : "Cryptosporidium parvum (organism)"
          },
          {
            "code" : "51459000",
            "display" : "Mycobacterium neoaurum (organism)"
          },
          {
            "code" : "51320008",
            "display" : "Mycobacterium africanum (organism)"
          },
          {
            "code" : "50471002",
            "display" : "Zika virus (organism)"
          },
          {
            "code" : "50384007",
            "display" : "Mumps virus (organism)"
          },
          {
            "code" : "50269000",
            "display" : "Staphylococcus aureus ss. anaerobius (organism)"
          },
          {
            "code" : "50255000",
            "display" : "Francisella (organism)"
          },
          {
            "code" : "50136005",
            "display" : "Salmonella Typhimurium (organism)"
          },
          {
            "code" : "49918008",
            "display" : "Plasmodium knowlesi (organism)"
          },
          {
            "code" : "49445003",
            "display" : "Genus Hantavirus (organism)"
          },
          {
            "code" : "48317004",
            "display" : "Brucella suis (organism)"
          },
          {
            "code" : "48134004",
            "display" : "Mycobacterium aurum (organism)"
          },
          {
            "code" : "47465002",
            "display" : "Vesicular stomatitis New Jersey virus (organism)"
          },
          {
            "code" : "46665004",
            "display" : "Cryptosporidium meleagridis (organism)"
          },
          {
            "code" : "46466005",
            "display" : "Bordetella (organism)"
          },
          {
            "code" : "46464008",
            "display" : "Enterococcus durans (organism)"
          },
          {
            "code" : "45838003",
            "display" : "Powassan virus (organism)"
          },
          {
            "code" : "45749000",
            "display" : "Vibrio alginolyticus (organism)"
          },
          {
            "code" : "45662006",
            "display" : "Mycobacterium terrae (organism)"
          },
          {
            "code" : "44760001",
            "display" : "Mycobacterium asiaticum (organism)"
          },
          {
            "code" : "44470000",
            "display" : "Haemophilus influenzae (organism)"
          },
          {
            "code" : "44172002",
            "display" : "Human poliovirus (organism)"
          },
          {
            "code" : "44106000",
            "display" : "Treponema pallidum ss. endemicum (organism)"
          },
          {
            "code" : "44081006",
            "display" : "Kuru agent (organism)"
          },
          {
            "code" : "43612004",
            "display" : "Shigella dysenteriae (organism)"
          },
          {
            "code" : "43492007",
            "display" : "Group B streptococcus (organism)"
          },
          {
            "code" : "43454006",
            "display" : "Treponema pallidum ss. pallidum (organism)"
          },
          {
            "code" : "43199008",
            "display" : "Vibrio fluvialis (organism)"
          },
          {
            "code" : "43091008",
            "display" : "Listeria seeligeri (organism)"
          },
          {
            "code" : "41704008",
            "display" : "Borrelia parkeri (organism)"
          },
          {
            "code" : "41328007",
            "display" : "Dengue virus, type 2 (organism)"
          },
          {
            "code" : "41304005",
            "display" : "Mycobacterium obuense (organism)"
          },
          {
            "code" : "41109008",
            "display" : "South River virus (organism)"
          },
          {
            "code" : "41090000",
            "display" : "Chlamydophila psittaci variant bovis (organism)"
          },
          {
            "code" : "40886007",
            "display" : "Klebsiella oxytoca (organism)"
          },
          {
            "code" : "40754006",
            "display" : "Puumala virus (organism)"
          },
          {
            "code" : "40740003",
            "display" : "Genus Trypanosoma (organism)"
          },
          {
            "code" : "40713003",
            "display" : "Mycobacterium ulcerans (organism)"
          },
          {
            "code" : "40614002",
            "display" : "Campylobacter coli (organism)"
          },
          {
            "code" : "40333002",
            "display" : "Mycobacterium triviale (organism)"
          },
          {
            "code" : "40039007",
            "display" : "Vesicular stomatitis virus, Argentina (organism)"
          },
          {
            "code" : "39739007",
            "display" : "Legionella jordanis (organism)"
          },
          {
            "code" : "38324000",
            "display" : "Entamoeba (organism)"
          },
          {
            "code" : "38322001",
            "display" : "Legionella parisiensis (organism)"
          },
          {
            "code" : "38004008",
            "display" : "Enterococcus mundtii (organism)"
          },
          {
            "code" : "37900004",
            "display" : "Trichinella (organism)"
          },
          {
            "code" : "37220005",
            "display" : "Histoplasma duboisii (organism)"
          },
          {
            "code" : "37081000",
            "display" : "Clostridium botulinum, type D (organism)"
          },
          {
            "code" : "36833002",
            "display" : "Rotavirus group G (organism)"
          },
          {
            "code" : "36764009",
            "display" : "Vibrio cincinnatiensis (organism)"
          },
          {
            "code" : "36700002",
            "display" : "Dengue virus, type 4 (organism)"
          },
          {
            "code" : "36354002",
            "display" : "Mycobacterium tuberculosis hominis (organism)"
          },
          {
            "code" : "36249008",
            "display" : "Mycobacterium komossence (organism)"
          },
          {
            "code" : "36115006",
            "display" : "Human immunodeficiency virus type 2 (organism)"
          },
          {
            "code" : "36094007",
            "display" : "Listeria monocytogenes (organism)"
          },
          {
            "code" : "35439004",
            "display" : "Seoul virus (organism)"
          },
          {
            "code" : "35408001",
            "display" : "Campylobacter (organism)"
          },
          {
            "code" : "35029001",
            "display" : "Babesia (organism)"
          },
          {
            "code" : "34872001",
            "display" : "Vibrio (organism)"
          },
          {
            "code" : "34706006",
            "display" : "Plasmodium (organism)"
          },
          {
            "code" : "34348001",
            "display" : "Dengue virus (organism)"
          },
          {
            "code" : "34212000",
            "display" : "Colorado tick fever virus (organism)"
          },
          {
            "code" : "33610009",
            "display" : "Attenuated Mycobacterium bovis (organism)"
          },
          {
            "code" : "32829006",
            "display" : "Clostridium botulinum, type F (organism)"
          },
          {
            "code" : "32691002",
            "display" : "Rickettsia conorii (organism)"
          },
          {
            "code" : "32488009",
            "display" : "Salmonella Paratyphi C (organism)"
          },
          {
            "code" : "32452004",
            "display" : "HAV - Hepatitis A virus (organism)"
          },
          {
            "code" : "32178004",
            "display" : "Serra do Navio virus (organism)"
          },
          {
            "code" : "31551005",
            "display" : "Rotavirus group C (organism)"
          },
          {
            "code" : "31169007",
            "display" : "Clostridium baratii (organism)"
          },
          {
            "code" : "30974007",
            "display" : "Rickettsia canadensis (organism)"
          },
          {
            "code" : "30949009",
            "display" : "Enterococcus casseliflavus (organism)"
          },
          {
            "code" : "30917009",
            "display" : "Clostridium tetani (organism)"
          },
          {
            "code" : "30769009",
            "display" : "Rickettsia akari (organism)"
          },
          {
            "code" : "30434006",
            "display" : "La Crosse virus (organism)"
          },
          {
            "code" : "30345008",
            "display" : "Treponema (organism)"
          },
          {
            "code" : "30020004",
            "display" : "Plasmodium falciparum (organism)"
          },
          {
            "code" : "29724001",
            "display" : "Orthopoxvirus (organism)"
          },
          {
            "code" : "29680004",
            "display" : "Ureaplasma (organism)"
          },
          {
            "code" : "29111009",
            "display" : "Mycobacterium agri (organism)"
          },
          {
            "code" : "28732002",
            "display" : "Snowshoe hare virus (organism)"
          },
          {
            "code" : "28625000",
            "display" : "Taenia (organism)"
          },
          {
            "code" : "28499009",
            "display" : "Rickettsia prowazekii (organism)"
          },
          {
            "code" : "28382009",
            "display" : "Vibrio metschnikovii (organism)"
          },
          {
            "code" : "28335002",
            "display" : "Rift Valley fever virus (organism)"
          },
          {
            "code" : "28109006",
            "display" : "Legionella erythra (organism)"
          },
          {
            "code" : "27365009",
            "display" : "Mycobacterium austroafricanum (organism)"
          },
          {
            "code" : "27334000",
            "display" : "Ehrlichia (organism)"
          },
          {
            "code" : "27268008",
            "display" : "Salmonella (organism)"
          },
          {
            "code" : "27142009",
            "display" : "Mycobacterium bovis (organism)"
          },
          {
            "code" : "26764003",
            "display" : "Leptospira (organism)"
          },
          {
            "code" : "26733000",
            "display" : "Mycobacterium lepraemurium (organism)"
          },
          {
            "code" : "26630006",
            "display" : "Yellow fever virus (organism)"
          },
          {
            "code" : "26352009",
            "display" : "Junin virus (organism)"
          },
          {
            "code" : "26250004",
            "display" : "Brucella (organism)"
          },
          {
            "code" : "24986006",
            "display" : "Borrelia turicatae (organism)"
          },
          {
            "code" : "24940009",
            "display" : "Non group A rotavirus (organism)"
          },
          {
            "code" : "24871004",
            "display" : "Mycobacterium gordonae (organism)"
          },
          {
            "code" : "24763006",
            "display" : "Vibrio cholerae serotype Hikojima (organism)"
          },
          {
            "code" : "24618002",
            "display" : "Mycobacterium gilvum (organism)"
          },
          {
            "code" : "24224000",
            "display" : "Brucella abortus (organism)"
          },
          {
            "code" : "23930001",
            "display" : "Francisella tularensis ss. mediasiatica (organism)"
          },
          {
            "code" : "23566007",
            "display" : "Listeria (organism)"
          },
          {
            "code" : "23498004",
            "display" : "Vesicular stomatitis Indiana virus (organism)"
          },
          {
            "code" : "23439005",
            "display" : "Coccidioides immitis (organism)"
          },
          {
            "code" : "22592008",
            "display" : "Legionella birminghamensis (organism)"
          },
          {
            "code" : "22580008",
            "display" : "Human poliovirus 1 (organism)"
          },
          {
            "code" : "22533000",
            "display" : "Coxiella burnetii (organism)"
          },
          {
            "code" : "21996001",
            "display" : "Mycobacterium haemophilum (organism)"
          },
          {
            "code" : "21927003",
            "display" : "Bacillus anthracis (organism)"
          },
          {
            "code" : "21433000",
            "display" : "Mycobacterium nonchromogenicum (organism)"
          },
          {
            "code" : "20973006",
            "display" : "Mycobacterium thermoresistibile (organism)"
          },
          {
            "code" : "20785008",
            "display" : "Clostridium botulinum, type B (organism)"
          },
          {
            "code" : "20498000",
            "display" : "Mycobacterium chubuense (organism)"
          },
          {
            "code" : "20141004",
            "display" : "Mycobacterium scrofulaceum (organism)"
          },
          {
            "code" : "20017000",
            "display" : "Clostridium botulinum, type C (organism)"
          },
          {
            "code" : "19965007",
            "display" : "Human herpes simplex virus (organism)"
          },
          {
            "code" : "19708001",
            "display" : "Melao virus (organism)"
          },
          {
            "code" : "19551004",
            "display" : "Human alphaherpesvirus 3 (organism)"
          },
          {
            "code" : "19084008",
            "display" : "Clostridium butyricum (organism)"
          },
          {
            "code" : "19030005",
            "display" : "Human immunodeficiency virus (organism)"
          },
          {
            "code" : "18508006",
            "display" : "Plasmodium ovale (organism)"
          },
          {
            "code" : "18400002",
            "display" : "Klebsiella pneumoniae ss. pneumoniae (organism)"
          },
          {
            "code" : "18279000",
            "display" : "Chlamydophila psittaci variant ovis (organism)"
          },
          {
            "code" : "18214000",
            "display" : "Legionella anisa (organism)"
          },
          {
            "code" : "18065004",
            "display" : "Clostridium botulinum, type A (organism)"
          },
          {
            "code" : "18054009",
            "display" : "Rickettsia rickettsii (organism)"
          },
          {
            "code" : "17966003",
            "display" : "Taenia solium (organism)"
          },
          {
            "code" : "17894007",
            "display" : "Cysticercus cellulosae (organism)"
          },
          {
            "code" : "17872004",
            "display" : "Neisseria meningitidis (organism)"
          },
          {
            "code" : "17688001",
            "display" : "Klebsiella pneumoniae ss. rhinoscleromatis (organism)"
          },
          {
            "code" : "17579001",
            "display" : "Cryptococcus (organism)"
          },
          {
            "code" : "17298000",
            "display" : "Legionella rubrilucens (organism)"
          },
          {
            "code" : "17083009",
            "display" : "Legionella feeleii (organism)"
          },
          {
            "code" : "16914000",
            "display" : "Mycobacterium piscium (organism)"
          },
          {
            "code" : "16439004",
            "display" : "Trichinella spiralis (organism)"
          },
          {
            "code" : "16362001",
            "display" : "Human poliovirus 3 (organism)"
          },
          {
            "code" : "16241000",
            "display" : "Chlamydia (organism)"
          },
          {
            "code" : "15302007",
            "display" : "Human alphaherpesvirus 1 (organism)"
          },
          {
            "code" : "14590003",
            "display" : "Chlamydophila psittaci (organism)"
          },
          {
            "code" : "14121003",
            "display" : "Legionella steigerwaltii (organism)"
          },
          {
            "code" : "13953004",
            "display" : "Vesicular stomatitis virus, Brazil (organism)"
          },
          {
            "code" : "13879009",
            "display" : "Acinetobacter junii (organism)"
          },
          {
            "code" : "13755001",
            "display" : "Corynebacterium diphtheriae type mitis (organism)"
          },
          {
            "code" : "13687007",
            "display" : "Human alphaherpesvirus 2 (organism)"
          },
          {
            "code" : "13126002",
            "display" : "Vaccinia virus (organism)"
          },
          {
            "code" : "13080008",
            "display" : "Clostridium botulinum (organism)"
          },
          {
            "code" : "12220009",
            "display" : "Coxiella (organism)"
          },
          {
            "code" : "12006007",
            "display" : "Ureaplasma urealyticum (organism)"
          },
          {
            "code" : "11776003",
            "display" : "Vibrio mimicus (organism)"
          },
          {
            "code" : "11736008",
            "display" : "Vibrio parahaemolyticus (organism)"
          },
          {
            "code" : "11428003",
            "display" : "Western equine encephalomyelitis virus (organism)"
          },
          {
            "code" : "10514003",
            "display" : "Norwalk virus (organism)"
          },
          {
            "code" : "10262005",
            "display" : "Enterococcus malodoratus (organism)"
          },
          {
            "code" : "9939008",
            "display" : "Mycobacterium fallax (organism)"
          },
          {
            "code" : "9892000",
            "display" : "Campylobacter concisus (organism)"
          },
          {
            "code" : "9861002",
            "display" : "Streptococcus pneumoniae (organism)"
          },
          {
            "code" : "9679001",
            "display" : "Mycobacterium moriokaense (organism)"
          },
          {
            "code" : "9194001",
            "display" : "Jamestown Canyon virus (organism)"
          },
          {
            "code" : "9041007",
            "display" : "Campylobacter hyointestinalis (organism)"
          },
          {
            "code" : "8672004",
            "display" : "Coccidioides (organism)"
          },
          {
            "code" : "8467002",
            "display" : "Dengue virus, type 3 (organism)"
          },
          {
            "code" : "8386006",
            "display" : "Clostridium botulinum, type E (organism)"
          },
          {
            "code" : "8147000",
            "display" : "Legionella wadsworthii (organism)"
          },
          {
            "code" : "7757008",
            "display" : "Acinetobacter (organism)"
          },
          {
            "code" : "7527002",
            "display" : "Legionella (organism)"
          },
          {
            "code" : "6895004",
            "display" : "Tahyna virus (organism)"
          },
          {
            "code" : "6415009",
            "display" : "Human respiratory syncytial virus (organism)"
          },
          {
            "code" : "6387008",
            "display" : "Vibrio furnissii (organism)"
          },
          {
            "code" : "6246005",
            "display" : "Treponema pallidum ss. pertenue (organism)"
          },
          {
            "code" : "6199007",
            "display" : "Mycobacterium diernhoferi (organism)"
          },
          {
            "code" : "5885000",
            "display" : "Mycobacterium flavescens (organism)"
          },
          {
            "code" : "5851001",
            "display" : "Corynebacterium diphtheriae (organism)"
          },
          {
            "code" : "5595000",
            "display" : "Salmonella enterica subspecies enterica serovar Typhi (organism)"
          },
          {
            "code" : "5247005",
            "display" : "Bordetella pertussis (organism)"
          },
          {
            "code" : "5210005",
            "display" : "Rubella virus (organism)"
          },
          {
            "code" : "5056007",
            "display" : "Mycoplasma genitalium (organism)"
          },
          {
            "code" : "4779006",
            "display" : "Cryptosporidium muris (organism)"
          },
          {
            "code" : "4716008",
            "display" : "Entamoeba histolytica (organism)"
          },
          {
            "code" : "4668009",
            "display" : "Yersinia (organism)"
          },
          {
            "code" : "4649006",
            "display" : "Toxoplasma gondii (organism)"
          },
          {
            "code" : "4298009",
            "display" : "Shigella sonnei (organism)"
          },
          {
            "code" : "3351007",
            "display" : "Anaplasma (organism)"
          },
          {
            "code" : "3128001",
            "display" : "Legionella israelensis (organism)"
          },
          {
            "code" : "3092008",
            "display" : "Staphylococcus aureus (organism)"
          },
          {
            "code" : "2864009",
            "display" : "Rotavirus group E (organism)"
          },
          {
            "code" : "2785000",
            "display" : "Enterococcus (organism)"
          },
          {
            "code" : "2423009",
            "display" : "Chikungunya virus (organism)"
          },
          {
            "code" : "1507005",
            "display" : "Mycobacterium kansasii (organism)"
          },
          {
            "code" : "1290001",
            "display" : "Mycoplasma hominis (organism)"
          },
          {
            "code" : "909007",
            "display" : "Mycobacterium parafortuitum (organism)"
          },
          {
            "code" : "638008",
            "display" : "Legionella oakridgensis (organism)"
          },
          {
            "code" : "252000",
            "display" : "Acinetobacter johnsonii (organism)"
          }
        ]
      }
    ]
  }
}

```
