# Identificativi per codici STP regionali - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Identificativi per codici STP regionali**

## ValueSet: Identificativi per codici STP regionali 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/URI-idStp | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:VsURIIdStp |

 
Identificativi per codici STP regionali. 

 **References** 

* [Patient - Lab Report](StructureDefinition-patient-it-lab.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on codesystem unknown version n/a

This value set contains 21 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "URI-idStp",
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/URI-idStp",
  "version" : "0.2.0",
  "name" : "VsURIIdStp",
  "title" : "Identificativi per codici STP regionali",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Identificativi per codici STP regionali.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "urn:ietf:rfc:3986",
        "concept" : [
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.10.4.1.1",
            "display" : "Codici STP - Piemonte"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.20.4.1.1",
            "display" : "Codici STP - Valle d`aosta"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.30.4.1.1",
            "display" : "Codici STP - Lombardia"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.41.4.1.1",
            "display" : "Codici STP - prov. auton. bolzan"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.42.4.1.1",
            "display" : "Codici STP - prov. auton. trento"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.50.4.1.1",
            "display" : "Codici STP - Veneto"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.60.4.1.1",
            "display" : "Codici STP - Friuli venezia giulia"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.70.4.1.1",
            "display" : "Codici STP - Liguria"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.80.4.1.1",
            "display" : "Codici STP - Emilia romagna"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.90.4.1.1",
            "display" : "Codici STP - Toscana"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.100.4.1.1",
            "display" : "Codici STP - Umbria"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.110.4.1.1",
            "display" : "Codici STP - Marche"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.120.4.1.1",
            "display" : "Codici STP - Lazio"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.130.4.1.1",
            "display" : "Codici STP - Abruzzo"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.140.4.1.1",
            "display" : "Codici STP - Molise"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.150.4.1.1",
            "display" : "Codici STP - Campania"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.160.4.1.1",
            "display" : "Codici STP - Puglia"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.170.4.1.1",
            "display" : "Codici STP - Basilicata"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.180.4.1.1",
            "display" : "Codici STP - Calabria"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.190.4.1.1",
            "display" : "Codici STP - Sicilia"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.200.4.1.1",
            "display" : "Codici STP - Sardegna"
          }
        ]
      }
    ]
  }
}

```
