# Certificazione - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Certificazione**

## Extension: Certificazione 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/recordCertification | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:ExtRecordCertification |

Estensione usata per indicare che l'informazione associata è stata certificata (od autocertificata) da una certa entità (persona, organizzazione). L'estensione è caratterizzata da: (a) una data di certificazione o da una periodo di validità (b) un codice od un riferimento al certificatore.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Address - ITA](StructureDefinition-address-it.md) and [Patient - Lab Report](StructureDefinition-patient-it-lab.md)
* Examples for this Extension: [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md), [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md) and [Patient/8472931c-fbd0-437b-9ed1-4f66472c78b5](Patient-8472931c-fbd0-437b-9ed1-4f66472c78b5.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/recordCertification)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-recordCertification.csv), [Excel](StructureDefinition-recordCertification.xlsx), [Schematron](StructureDefinition-recordCertification.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "recordCertification",
  "url" : "http://hl7.it/fhir/StructureDefinition/recordCertification",
  "version" : "0.2.0",
  "name" : "ExtRecordCertification",
  "title" : "Certificazione",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Estensione usata per indicare che l'informazione associata è stata certificata (od autocertificata) da una certa entità (persona, organizzazione).  L'estensione è caratterizzata da: (a) una data di certificazione o da una periodo di validità (b) un codice od un riferimento al certificatore.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address"
    },
    {
      "type" : "element",
      "expression" : "Patient"
    },
    {
      "type" : "element",
      "expression" : "Patient.identifier"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Certificazione del record",
        "definition" : "Identifica che un certo record paziente, o codice fiscale od indirizzo di residenza è stato certificato da una specifica entità (e.g. MEF)."
      },
      {
        "id" : "Extension.extension:when",
        "path" : "Extension.extension",
        "sliceName" : "when",
        "short" : "Data/Periodo  di certificazione",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:when.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:when.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "when"
      },
      {
        "id" : "Extension.extension:when.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Extension.extension:who",
        "path" : "Extension.extension",
        "sliceName" : "who",
        "short" : "Entità Certificante",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:who.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:who.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "who"
      },
      {
        "id" : "Extension.extension:who.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/tipoCertificatore"
        }
      },
      {
        "id" : "Extension.extension:rank",
        "path" : "Extension.extension",
        "sliceName" : "rank",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:rank.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:rank.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "rank"
      },
      {
        "id" : "Extension.extension:rank.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "decimal"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.it/fhir/StructureDefinition/recordCertification"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
