# Quantity - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Quantity - Lab Report**

## Data Type Profile: Quantity - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/quantity-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:QuantityLab |

 
Descrizione del valore ottenuto da una misurazione. 

**Usages:**

* Use this DataType Profile: [Observation battery - Lab Report](StructureDefinition-observation-grouping-it-lab.md) and [Observation - Lab Report](StructureDefinition-observation-it-lab.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/quantity-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-quantity-it-lab.csv), [Excel](StructureDefinition-quantity-it-lab.xlsx), [Schematron](StructureDefinition-quantity-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "quantity-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/quantity-it-lab",
  "version" : "0.2.0",
  "name" : "QuantityLab",
  "title" : "Quantity - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione del valore ottenuto da una misurazione.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Quantity",
  "baseDefinition" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Quantity-eu-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Quantity.value",
        "path" : "Quantity.value",
        "short" : "Valore della misurazione."
      },
      {
        "id" : "Quantity.unit",
        "path" : "Quantity.unit",
        "short" : "Descrizione testuale dell'unità di misura."
      },
      {
        "id" : "Quantity.code",
        "path" : "Quantity.code",
        "short" : "Descrizione codificata dell'unità di misura secondo UCUM.",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ucum-units"
        }
      }
    ]
  }
}

```
