# PractitionerRole MMG/PLS - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractitionerRole MMG/PLS - Lab Report**

## Resource Profile: PractitionerRole MMG/PLS - Lab Report 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-MMGPLS-it-lab | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:PractitionerRoleMMGPLSRefertoLabIt |

 
Descrizione delle informazioni del MMG/PLS tramite il profilo della risorsa PractitionerRole per il referto di laboratorio. 

**Usages:**

* Refer to this Profile: [Patient - Lab Report](StructureDefinition-patient-it-lab.md)
* Examples for this Profile: [PractitionerRole/dc5842a1-83b6-43c7-b063-75ae989b803k](PractitionerRole-dc5842a1-83b6-43c7-b063-75ae989b803k.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/practitionerrole-MMGPLS-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-practitionerrole-MMGPLS-it-lab.csv), [Excel](StructureDefinition-practitionerrole-MMGPLS-it-lab.xlsx), [Schematron](StructureDefinition-practitionerrole-MMGPLS-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "practitionerrole-MMGPLS-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/PractitionerRole-eu-lab"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-MMGPLS-it-lab",
  "version" : "0.2.0",
  "name" : "PractitionerRoleMMGPLSRefertoLabIt",
  "title" : "PractitionerRole MMG/PLS - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione delle informazioni del MMG/PLS tramite il profilo della risorsa PractitionerRole per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "short" : "PractitionerRole MMG/PLS Referto di Laboratorio"
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/organizationOperatore-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/mmgOrPls"
        }
      }
    ]
  }
}

```
