# Practitioner - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner - Lab Report**

## Resource Profile: Practitioner - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PractitionerRefertoLabIt |

 
Descrizione dei dati del professionista sanitario tramite il profilo della risorsa Practitioner per il referto di laboratorio. 

**Usages:**

* Use this Profile: [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md)
* Refer to this Profile: [DataEnterer](StructureDefinition-composition-dataenterer-it.md), [Composition - Lab Report](StructureDefinition-composition-it-lab.md), [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md), [Encounter - Lab Report](StructureDefinition-encounter-it-lab.md)...Show 4 more,[Media - Lab Report](StructureDefinition-media-it-lab.md),[Observation - Lab Report](StructureDefinition-observation-it-lab.md),[Patient - Lab Report](StructureDefinition-patient-it-lab.md)and[PractitionerRole - Lab Report](StructureDefinition-practitionerrole-it-lab.md)
* Examples for this Profile: [Practitioner/134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c](Practitioner-134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c.md) and [Practitioner/dc5842a1-83b6-43c7-b063-75ae989b803d](Practitioner-dc5842a1-83b6-43c7-b063-75ae989b803d.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/practitioner-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-practitioner-it-lab.csv), [Excel](StructureDefinition-practitioner-it-lab.xlsx), [Schematron](StructureDefinition-practitioner-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "practitioner-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Practitioner-eu-lab"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab",
  "version" : "0.2.0",
  "name" : "PractitionerRefertoLabIt",
  "title" : "Practitioner - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione dei dati del professionista sanitario tramite il profilo della risorsa Practitioner per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "short" : "Practitioner Referto di Laboratorio"
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "description" : "Slice based on the identifier pattern",
          "rules" : "open"
        },
        "short" : "Identificativo dell'operatore sanitario"
      },
      {
        "id" : "Practitioner.identifier:codiceFiscale",
        "path" : "Practitioner.identifier",
        "sliceName" : "codiceFiscale",
        "short" : "Codice fiscale dell'operatore sanitario.",
        "min" : 0,
        "max" : "1",
        "patternIdentifier" : {
          "system" : "http://hl7.it/sid/codiceFiscale"
        }
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "short" : "Nome dell'operatore sanitario: include le informazioni minime per descrivere un operatore sanitario",
        "min" : 1
      }
    ]
  }
}

```
