# Patient - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient - Lab Report**

## Resource Profile: Patient - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PatientRefertoLabIt |

 
Descrizione delle informazioni del paziente nei documenti FHIR. 

**Usages:**

* Use this Profile: [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md)
* Refer to this Profile: [Composition - Lab Report](StructureDefinition-composition-it-lab.md), [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md), [Encounter - Lab Report](StructureDefinition-encounter-it-lab.md), [Media - Lab Report](StructureDefinition-media-it-lab.md)...Show 3 more,[Observation - Lab Report](StructureDefinition-observation-it-lab.md),[ServiceRequest - Lab Report](StructureDefinition-servicerequest-it-lab.md)and[Specimen - Lab Report](StructureDefinition-specimen-it-lab.md)
* Examples for this Profile: [Patient/8472931c-fbd0-437b-9ed1-4f66472c78b5](Patient-8472931c-fbd0-437b-9ed1-4f66472c78b5.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/patient-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-it-lab.csv), [Excel](StructureDefinition-patient-it-lab.xlsx), [Schematron](StructureDefinition-patient-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Patient-eu-lab"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab",
  "version" : "0.2.0",
  "name" : "PatientRefertoLabIt",
  "title" : "Patient - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione delle informazioni del paziente nei documenti FHIR.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient",
        "short" : "Patient Referto di Laboratorio"
      },
      {
        "id" : "Patient.extension",
        "path" : "Patient.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.extension:luogoNascita",
        "path" : "Patient.extension",
        "sliceName" : "luogoNascita",
        "short" : "Luogo di nascita.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/birth-place-ita"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:certificazione",
        "path" : "Patient.extension",
        "sliceName" : "certificazione",
        "short" : "Indica che i dati presenti nella risorsa sono stati certificati da una specifica entità",
        "definition" : "Indica che i dati presenti nella risorsa (non quelli referenziati) sono stati certificati da una specifica entità",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.extension:luogoNascitaCodeable",
        "path" : "Patient.extension",
        "sliceName" : "luogoNascitaCodeable",
        "short" : "Codice del comune e/o dello stato di nascita",
        "definition" : "Codice del comune e/o dello stato di nascita del paziente. In via eccezionle, può essere usato per indicare comune e/o stato di nascita in forma testuale",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace"
            ]
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/istat-luogoNascita"
        }
      },
      {
        "id" : "Patient.extension:cittadinanza",
        "path" : "Patient.extension",
        "sliceName" : "cittadinanza",
        "short" : "Cittadinanza",
        "definition" : "Indica la cittadinanza del cittadino attraverso lo stato di provenienza",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
            ]
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/istat-cittadinanza"
        }
      },
      {
        "id" : "Patient.extension:professione",
        "path" : "Patient.extension",
        "sliceName" : "professione",
        "short" : "Professione",
        "definition" : "Indica la professione del cittadino come semplice CodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/StructureDefinition/patient-occupation-it"
            ]
          }
        ],
        "mustSupport" : false,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/istat-professione"
        }
      },
      {
        "id" : "Patient.extension:titoloStudio",
        "path" : "Patient.extension",
        "sliceName" : "titoloStudio",
        "short" : "Titolo di studio",
        "definition" : "Indica il titolo di studio del cittadino come semplice CodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/StructureDefinition/patient-qualification-it"
            ]
          }
        ],
        "mustSupport" : false,
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/istat-titoloStudio"
        }
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this.system"
            }
          ],
          "rules" : "open"
        },
        "short" : "Identificativo del paziente.",
        "min" : 1
      },
      {
        "id" : "Patient.identifier.extension:certificazioneId",
        "path" : "Patient.identifier.extension",
        "sliceName" : "certificazioneId",
        "short" : "Identificativo certificato (tipicamente per CF)",
        "definition" : "Indica che questo identificativo è stato certificato. Usato tipicamente per il Codice Fiscale.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.identifier.type",
        "path" : "Patient.identifier.type",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/VstipoIdentificatore"
        }
      },
      {
        "id" : "Patient.identifier.value",
        "path" : "Patient.identifier.value",
        "short" : "ID del paziente (e.g. Codice Fiscale).",
        "definition" : "Identifictivo del paziente.",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:codiceFiscale",
        "path" : "Patient.identifier",
        "sliceName" : "codiceFiscale",
        "short" : "Codice Fiscale.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:codiceFiscale.extension:certificazioneId",
        "path" : "Patient.identifier.extension",
        "sliceName" : "certificazioneId",
        "short" : "Identificativo certificato (tipicamente per CF)",
        "definition" : "Indica che questo identificativo è stato certificato. Usato tipicamente per il Codice Fiscale.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.identifier:codiceFiscale.system",
        "path" : "Patient.identifier.system",
        "short" : "Namespace per il valore dell'identifier.",
        "min" : 1,
        "fixedUri" : "http://hl7.it/sid/codiceFiscale"
      },
      {
        "id" : "Patient.identifier:codiceFiscale.value",
        "path" : "Patient.identifier.value",
        "short" : "Valore dell'identifier.",
        "constraint" : [
          {
            "key" : "pat-id-cf-1",
            "severity" : "error",
            "human" : "Il Codice Fiscale deve essere di 16 caratteri alfanumerici (3 per il cognome; 3 per il nome; 2 caratteri numerici per l'anno di nascita; 1 per il mese di nascita; 2 caratteri numerici per il giorno di nascita ed il sesso; 4 associati al Comune oppure allo Stato estero di nascita. 1 carattere di controllo.",
            "expression" : "matches('^[A-Za-z]{6}[0-9LMNPQRSTUV]{2}[A-Za-z]{1}[0-9LMNPQRSTUV]{2}[A-Za-z]{1}[0-9LMNPQRSTUV]{3}[A-Za-z]{1}$')",
            "xpath" : "matches(@value,'^[A-Za-z]{6}[0-9LMNPQRSTUV]{2}[A-Za-z]{1}[0-9LMNPQRSTUV]{2}[A-Za-z]{1}[0-9LMNPQRSTUV]{3}[A-Za-z]{1}$')",
            "source" : "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
          }
        ]
      },
      {
        "id" : "Patient.identifier:anpr",
        "path" : "Patient.identifier",
        "sliceName" : "anpr",
        "short" : "Identificativo del paziente nell'Anagrafe nazionale della popolazione residente.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:anpr.extension:certificazioneId",
        "path" : "Patient.identifier.extension",
        "sliceName" : "certificazioneId",
        "short" : "Identificativo certificato (tipicamente per CF)",
        "definition" : "Indica che questo identificativo è stato certificato. Usato tipicamente per il Codice Fiscale.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.identifier:anpr.system",
        "path" : "Patient.identifier.system",
        "short" : "Namespace per il valore dell'identifier.",
        "min" : 1,
        "patternUri" : "http://hl7.it/sid/anpr"
      },
      {
        "id" : "Patient.identifier:idRegionale",
        "path" : "Patient.identifier",
        "sliceName" : "idRegionale",
        "short" : "Identificativo Regionale.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:idRegionale.extension:certificazioneId",
        "path" : "Patient.identifier.extension",
        "sliceName" : "certificazioneId",
        "short" : "Identificativo certificato (tipicamente per CF)",
        "definition" : "Indica che questo identificativo è stato certificato. Usato tipicamente per il Codice Fiscale.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.identifier:idRegionale.system",
        "path" : "Patient.identifier.system",
        "short" : "Namespace per il valore dell'identifier.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/vs-anagrafi-regionali"
        }
      },
      {
        "id" : "Patient.identifier:codiceENI",
        "path" : "Patient.identifier",
        "sliceName" : "codiceENI",
        "short" : "Codice ENI.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:codiceENI.extension:certificazioneId",
        "path" : "Patient.identifier.extension",
        "sliceName" : "certificazioneId",
        "short" : "Identificativo certificato (tipicamente per CF)",
        "definition" : "Indica che questo identificativo è stato certificato. Usato tipicamente per il Codice Fiscale.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.identifier:codiceENI.system",
        "path" : "Patient.identifier.system",
        "short" : "Namespace per il valore dell'identifier.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/uri-idEni"
        }
      },
      {
        "id" : "Patient.identifier:codiceANA",
        "path" : "Patient.identifier",
        "sliceName" : "codiceANA",
        "short" : "Codice ANA.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:codiceANA.extension:certificazioneId",
        "path" : "Patient.identifier.extension",
        "sliceName" : "certificazioneId",
        "short" : "Identificativo certificato (tipicamente per CF)",
        "definition" : "Indica che questo identificativo è stato certificato. Usato tipicamente per il Codice Fiscale.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.identifier:codiceANA.system",
        "path" : "Patient.identifier.system",
        "short" : "Namespace per il valore dell'identifier.",
        "min" : 1,
        "patternUri" : "urn:oid:2.16.840.1.113883.2.9.4.3.15"
      },
      {
        "id" : "Patient.identifier:tesseraTEAM",
        "path" : "Patient.identifier",
        "sliceName" : "tesseraTEAM",
        "short" : "Tessera TEAM.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:tesseraTEAM.extension:certificazioneId",
        "path" : "Patient.identifier.extension",
        "sliceName" : "certificazioneId",
        "short" : "Identificativo certificato (tipicamente per CF)",
        "definition" : "Indica che questo identificativo è stato certificato. Usato tipicamente per il Codice Fiscale.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.identifier:tesseraTEAM.system",
        "path" : "Patient.identifier.system",
        "short" : "Namespace per il valore dell'identifier.",
        "min" : 1,
        "patternUri" : "urn:oid:2.16.840.1.113883.2.9.4.3.7"
      },
      {
        "id" : "Patient.identifier:codiceSTP",
        "path" : "Patient.identifier",
        "sliceName" : "codiceSTP",
        "short" : "Codice STP.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:codiceSTP.extension:certificazioneId",
        "path" : "Patient.identifier.extension",
        "sliceName" : "certificazioneId",
        "short" : "Identificativo certificato (tipicamente per CF)",
        "definition" : "Indica che questo identificativo è stato certificato. Usato tipicamente per il Codice Fiscale.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Patient.identifier:codiceSTP.system",
        "path" : "Patient.identifier.system",
        "short" : "Namespace per il valore dell'identifier.",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/URI-idStp"
        }
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "short" : "Nome associato al paziente.",
        "min" : 1,
        "constraint" : [
          {
            "key" : "it-pat-name-1",
            "severity" : "warning",
            "human" : "Il nome deve contenere almeno una delle aprti che compongono il nome (nome, cognome)",
            "expression" : "family.exists() or given.exists()",
            "xpath" : "f:given or f:family",
            "source" : "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
          }
        ]
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "min" : 1
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/address-it"
            ]
          }
        ]
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "$this.resolve()"
            }
          ],
          "rules" : "open"
        },
        "short" : "Principale fornitore di cure del paziente."
      },
      {
        "id" : "Patient.generalPractitioner:mmgPlsRole",
        "path" : "Patient.generalPractitioner",
        "sliceName" : "mmgPlsRole",
        "short" : "Reference al ruolo MMG/PLS.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-MMGPLS-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Patient.generalPractitioner:mmgPls",
        "path" : "Patient.generalPractitioner",
        "sliceName" : "mmgPls",
        "short" : "Reference al MMG/PLS.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Patient.generalPractitioner:aziendaAssistenza",
        "path" : "Patient.generalPractitioner",
        "sliceName" : "aziendaAssistenza",
        "short" : "Reference all'azienda che assiste il paziente.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/organizationOperatore-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Patient.managingOrganization",
        "path" : "Patient.managingOrganization",
        "short" : "Organizzazione a cui è lasciata la custodia del dei dati del paziente.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab"
            ]
          }
        ]
      }
    ]
  }
}

```
