# Organization operatore sanitario/socio sanitario - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization operatore sanitario/socio sanitario - Lab Report**

## Resource Profile: Organization operatore sanitario/socio sanitario - Lab Report 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/organizationOperatore-it-lab | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:OrganizationOperatoreSanitarioRefertoLabIt |

 
Descrizione delle informazioni relative all'operatore socio/sanitario tramite il profilo della risorsa Organization per il referto di laboratorio. 

**Usages:**

* Refer to this Profile: [Patient - Lab Report](StructureDefinition-patient-it-lab.md) and [PractitionerRole MMG/PLS - Lab Report](StructureDefinition-practitionerrole-MMGPLS-it-lab.md)
* Examples for this Profile: [AZIENDA U.S.L. VALLE D'AOSTA](Organization-ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/organizationOperatore-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-organizationOperatore-it-lab.csv), [Excel](StructureDefinition-organizationOperatore-it-lab.xlsx), [Schematron](StructureDefinition-organizationOperatore-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "organizationOperatore-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/organizationOperatore-it-lab",
  "version" : "0.2.0",
  "name" : "OrganizationOperatoreSanitarioRefertoLabIt",
  "title" : "Organization operatore sanitario/socio sanitario - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione delle informazioni relative all'operatore socio/sanitario tramite il profilo della risorsa Organization per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "short" : "Organization operatore sanitario/socio sanitario Referto di Laboratorio"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this.system"
            },
            {
              "type" : "value",
              "path" : "$this.value"
            }
          ],
          "description" : "Slice based on the identifier pattern",
          "rules" : "open"
        }
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:asl",
        "path" : "Organization.identifier",
        "sliceName" : "asl",
        "short" : "Identificativo Azienda Sanitaria Locale (FLS 11 - 6 char)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:asl.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/fls"
      },
      {
        "id" : "Organization.identifier:asl.value",
        "path" : "Organization.identifier.value",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/minsan-asl"
        }
      },
      {
        "id" : "Organization.identifier:aslRegione",
        "path" : "Organization.identifier",
        "sliceName" : "aslRegione",
        "short" : "Identificativo Regionale Azienda Sanitaria Locale (FLS 11 - 3 char)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:aslRegione.system",
        "path" : "Organization.identifier.system",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/uri-idAslRegione"
        }
      },
      {
        "id" : "Organization.identifier:aziendaOspedaliera",
        "path" : "Organization.identifier",
        "sliceName" : "aziendaOspedaliera",
        "short" : "Identificativo Azienda Ospedaliera",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:aziendaOspedaliera.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/hsp"
      },
      {
        "id" : "Organization.identifier:aziendaOspedaliera.value",
        "path" : "Organization.identifier.value",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/minsan-idAziendeOspedaliere"
        }
      },
      {
        "id" : "Organization.identifier:struttura",
        "path" : "Organization.identifier",
        "sliceName" : "struttura",
        "short" : "Identificativo Struttura di Ricovero",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:struttura.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/hsp"
      },
      {
        "id" : "Organization.identifier:struttura.value",
        "path" : "Organization.identifier.value",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/minsan-idStrutture"
        }
      },
      {
        "id" : "Organization.identifier:partitaIva",
        "path" : "Organization.identifier",
        "sliceName" : "partitaIva",
        "short" : "Partita IVA Organizzazione",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:partitaIva.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/partitaIva"
      },
      {
        "id" : "Organization.identifier:codiceFiscale",
        "path" : "Organization.identifier",
        "sliceName" : "codiceFiscale",
        "short" : "Codice Fiscale Organizzazione",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:codiceFiscale.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/codiceFiscale"
      },
      {
        "id" : "Organization.identifier:strutturaInterna",
        "path" : "Organization.identifier",
        "sliceName" : "strutturaInterna",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:strutturaInterna.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/hsp"
      },
      {
        "id" : "Organization.identifier:strutturaInterna.value",
        "path" : "Organization.identifier.value",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/minsan-idStruttureInterne"
        }
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/tipoOrgSocioSanitaria"
        }
      }
    ]
  }
}

```
