# Observation battery - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation battery - Lab Report**

## Resource Profile: Observation battery - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/observation-grouping-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ObservationGroupingRefertoLabIt |

 
Descrizione di un inseme di esami tramite il profilo della risorsa Observation per il referto di laboratorio. 

**Usages:**

* Refer to this Profile: [Composition - Lab Report](StructureDefinition-composition-it-lab.md)
* Examples for this Profile: [Observation/Observation-Lab-Esempio-Group](Observation-Observation-Lab-Esempio-Group.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/observation-grouping-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-observation-grouping-it-lab.csv), [Excel](StructureDefinition-observation-grouping-it-lab.xlsx), [Schematron](StructureDefinition-observation-grouping-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "observation-grouping-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-grouping-it-lab",
  "version" : "0.2.0",
  "name" : "ObservationGroupingRefertoLabIt",
  "title" : "Observation battery - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione di un inseme di esami tramite il profilo della risorsa Observation per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Observation battery Referto di Laboratorio"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Codice che identifica la tipologia dell'insieme di esami.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/sezione-referto-laboratorio"
        }
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "max" : "0"
      },
      {
        "id" : "Observation.value[x]:valueString",
        "path" : "Observation.value[x]",
        "sliceName" : "valueString",
        "max" : "0",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueRange",
        "path" : "Observation.value[x]",
        "sliceName" : "valueRange",
        "max" : "0",
        "type" : [
          {
            "code" : "Range",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Range-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueRatio",
        "path" : "Observation.value[x]",
        "sliceName" : "valueRatio",
        "max" : "0",
        "type" : [
          {
            "code" : "Ratio",
            "profile" : [
              "http://hl7.eu/fhir/laboratory/StructureDefinition/Ratio-eu-lab"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueTime",
        "path" : "Observation.value[x]",
        "sliceName" : "valueTime",
        "max" : "0",
        "type" : [
          {
            "code" : "time"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueDateTime",
        "path" : "Observation.value[x]",
        "sliceName" : "valueDateTime",
        "max" : "0",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valuePeriod",
        "path" : "Observation.value[x]",
        "sliceName" : "valuePeriod",
        "max" : "0",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "max" : "0",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/quantity-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "max" : "0",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Observation.interpretation",
        "path" : "Observation.interpretation",
        "max" : "0"
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "max" : "0"
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "short" : "Osservazioni contenenti i risultati degli esami svolti.",
        "min" : 1
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "max" : "0"
      }
    ]
  }
}

```
