# Media - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Media - Lab Report**

## Resource Profile: Media - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/media-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:MediaRefertoLabIt |

 
Descrizione dei contenuti multimediali tramite il profilo della risorsa Media per il referto di laboratorio. 

 
Questa risorsa viene utilizzata per illustrare i contenuti multimediali legati al Referto di Laboratorio. 

**Usages:**

* Use this Profile: [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md)
* Refer to this Profile: [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md) and [Observation - Lab Report](StructureDefinition-observation-it-lab.md)
* Examples for this Profile: [Media/059927b1-7e17-409e-ae60-68cc3c0b3aea](Media-059927b1-7e17-409e-ae60-68cc3c0b3aea.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/media-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-media-it-lab.csv), [Excel](StructureDefinition-media-it-lab.xlsx), [Schematron](StructureDefinition-media-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "media-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/media-it-lab",
  "version" : "0.2.0",
  "name" : "MediaRefertoLabIt",
  "title" : "Media - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione dei contenuti multimediali tramite il profilo della risorsa Media per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "purpose" : "Questa risorsa viene utilizzata per illustrare i contenuti multimediali legati al Referto di Laboratorio.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "dicom",
      "uri" : "http://nema.org/dicom",
      "name" : "DICOM Tag Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Media",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Media",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Media",
        "path" : "Media",
        "short" : "Media Referto di Laboratorio"
      },
      {
        "id" : "Media.status",
        "path" : "Media.status",
        "short" : "Stato del valore del risultato."
      },
      {
        "id" : "Media.type",
        "path" : "Media.type",
        "short" : "Descrizione attributo: Tipo di contenuto multimediale. Possibili valori: image | video | audio",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/media-type"
        }
      },
      {
        "id" : "Media.subject",
        "path" : "Media.subject",
        "short" : "Reference al soggetto del  file multimediali.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Media.subject.reference",
        "path" : "Media.subject.reference",
        "short" : "Reference Literal, Relative, URL interno o assoluto.",
        "min" : 1
      },
      {
        "id" : "Media.operator",
        "path" : "Media.operator",
        "short" : "Operatore che ha generato il contenuto multimediale.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab",
              "http://hl7.org/fhir/StructureDefinition/CareTeam",
              "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/device-it-lab",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Media.device",
        "path" : "Media.device",
        "short" : "Dispositivo utilizzato per raccogliere i file multimediali.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/device-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Media.content",
        "path" : "Media.content",
        "short" : "Contenuto multimediale."
      }
    ]
  }
}

```
