# Location - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Location - Lab Report**

## Resource Profile: Location - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/location-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LocationRefertoLabIt |

 
Descrizione delle informazioni relative alle strutture fisiche tramite il profilo della risorsa Location per il referto di laboratorio. 

**Usages:**

* Use this Profile: [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md)
* Refer to this Profile: [Encounter - Lab Report](StructureDefinition-encounter-it-lab.md)
* Examples for this Profile: [Policlinico di Roma](Location-f148e54a-2046-4534-b9e9-54e7e9632224.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/location-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-location-it-lab.csv), [Excel](StructureDefinition-location-it-lab.xlsx), [Schematron](StructureDefinition-location-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "location-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/location-it-lab",
  "version" : "0.2.0",
  "name" : "LocationRefertoLabIt",
  "title" : "Location - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione delle informazioni relative alle strutture fisiche tramite il profilo della risorsa Location per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location",
        "short" : "Location Referto di Laboratorio."
      },
      {
        "id" : "Location.identifier",
        "path" : "Location.identifier",
        "short" : "Identificativo della struttura (luogo).",
        "min" : 1
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "short" : "Nome della struttura (luogo)."
      },
      {
        "id" : "Location.type",
        "path" : "Location.type",
        "short" : "Tipo di struttura sulla base dei servizi offerti.",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ServiceDeliveryLocationRoleType"
        }
      },
      {
        "id" : "Location.address",
        "path" : "Location.address",
        "short" : "Indirizzo fisico della struttura (luogo)."
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "short" : "Organizzazione responsabile della gestione della struttura (provisioning e manutenzione).",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab"
            ]
          }
        ]
      }
    ]
  }
}

```
