# Composition - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition - Lab Report**

## Resource Profile: Composition - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/composition-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CompositionRefertoLabIt |

 
Descrizione del referto di laboratorio tramite il profilo della risorsa Composition per il referto di laboratorio. 

**Usages:**

* Use this Profile: [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md)
* Refer to this Profile: [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md)
* Examples for this Profile: [Composition/2ae95a5c-9094-41a3-a437-ce6d34c55a54](Composition-2ae95a5c-9094-41a3-a437-ce6d34c55a54.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/composition-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-composition-it-lab.csv), [Excel](StructureDefinition-composition-it-lab.xlsx), [Schematron](StructureDefinition-composition-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "composition-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/composition-it-lab",
  "version" : "0.2.0",
  "name" : "CompositionRefertoLabIt",
  "title" : "Composition - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione del referto di laboratorio tramite il profilo della risorsa Composition per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Composition-eu-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Composition Referto di Laboratorio"
      },
      {
        "id" : "Composition.language",
        "path" : "Composition.language",
        "short" : "Metadato che indica la lingua utilizzata per descrivere la risorsa.",
        "min" : 1,
        "patternCode" : "it-IT"
      },
      {
        "id" : "Composition.text",
        "path" : "Composition.text",
        "short" : "Sintesi testuale della sezione, per l'interpretazione dell'utente."
      },
      {
        "id" : "Composition.extension:information-recipient",
        "path" : "Composition.extension",
        "sliceName" : "information-recipient",
        "short" : "Professionisti sanitari che ricevono una copia del documento (es. MMG/PLS)."
      },
      {
        "id" : "Composition.extension:dataEnterer",
        "path" : "Composition.extension",
        "sliceName" : "dataEnterer",
        "short" : "Persona o dispositivo che trasforma un testo dettato nel documento FHIR.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/StructureDefinition/composition-dataenterer-it"
            ]
          }
        ]
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "Identificativo indipendente dalla versione.",
        "comment" : "Composition.identifier DEVE essere uguale ad uno dei DiagnosticReport.identifier, se ne esiste almeno uno.",
        "min" : 1
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "Stato del Referto",
        "definition" : "Lo stato della Composition si sviluppa generalmente solo attraverso questo elenco: passa da preliminary a final e poi può passare a amended (ovvero modificato). ",
        "comment" : "DiagnosticReport.status e Composition.status devono essere coerenti, vedi http://hl7.eu/fhir/laboratory/ConceptMap/ConceptMap-eu-diagRptStatus2CompStatus per il mapping."
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "short" : "Referto di Laboratorio",
        "definition" : "Specifica che il documento è un Referto di Laboratorio",
        "comment" : "DiagnosticReport.code e Composition.type devono essere allineati."
      },
      {
        "id" : "Composition.category",
        "path" : "Composition.category",
        "definition" : "Specifies the Report Category: usually Laboratory",
        "comment" : "DiagnosticReport.category e Composition.category  devono essere allineati."
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "comment" : "DiagnosticReport e Composition devono avere lo stesso subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "short" : "Evento sanitario a cui si riferisce il Referto di Laboratorio (es. al momento della prescrizione).",
        "definition" : "Evento sanitario a cui si riferisce il Referto di Laboratorio (es. al momento della prescrizione).",
        "comment" : "This will typically be the encounter the event occurred within, but some events may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. pre-admission laboratory tests).\n  DiagnosticReport e Composition devono referenziare lo stesso encounter.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/encounter-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "Data di modifica della risorsa Composition."
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "Chi e/o cosa è l'autore del referto di laboratorio.",
        "comment" : "Se DiagnosticReport.resultsInterpreter esiste, anche Composition.author deve essere valorizzato. Altrimenti DiagnosticReport.performer dovrebbe essere un autore.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "short" : "Titolo o nome human-readable della Composition.",
        "patternString" : "Referto di Laboratorio"
      },
      {
        "id" : "Composition.confidentiality",
        "path" : "Composition.confidentiality",
        "short" : "Codice di confidenzialità della Composition.",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-Confidentiality"
        }
      },
      {
        "id" : "Composition.attester",
        "path" : "Composition.attester",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "mode"
            }
          ],
          "description" : "Professionisti che attestano la validità del documento.",
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Professionisti che attestano la validità del documento. Se la risorsa è creata a fine documentale uno degli attester dovrebbe essere il firmatario, ovvero chi allega la firma digitale al documento.",
        "min" : 1
      },
      {
        "id" : "Composition.attester:legalAuthenticator",
        "path" : "Composition.attester",
        "sliceName" : "legalAuthenticator",
        "short" : "Firmatario del documento FHIR.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.attester:legalAuthenticator.mode",
        "path" : "Composition.attester.mode",
        "patternCode" : "legal"
      },
      {
        "id" : "Composition.attester:legalAuthenticator.time",
        "path" : "Composition.attester.time",
        "short" : "Riferimento temporale della firma.",
        "min" : 1
      },
      {
        "id" : "Composition.attester:legalAuthenticator.party",
        "path" : "Composition.attester.party",
        "short" : "Riferimento al firmatario.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Composition.attester:authenticator",
        "path" : "Composition.attester",
        "sliceName" : "authenticator",
        "short" : "Validatore del documento FHIR.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.attester:authenticator.mode",
        "path" : "Composition.attester.mode",
        "patternCode" : "professional"
      },
      {
        "id" : "Composition.attester:authenticator.party",
        "path" : "Composition.attester.party",
        "short" : "Riferimento al validatore.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Composition.custodian",
        "path" : "Composition.custodian",
        "short" : "Organizzazione che si occupa della conservazione del documento FHIR.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section"
      },
      {
        "id" : "Composition.section.title",
        "path" : "Composition.section.title",
        "short" : "Titolo della sezione."
      },
      {
        "id" : "Composition.section.code",
        "path" : "Composition.section.code",
        "short" : "Codice della sezione."
      },
      {
        "id" : "Composition.section:lab-no-subsections",
        "path" : "Composition.section",
        "sliceName" : "lab-no-subsections",
        "short" : "Variante 1: questa sezione presenta solo entry senza sottosezioni."
      },
      {
        "id" : "Composition.section:lab-no-subsections.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:lab-no-subsections.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/sezione-referto-laboratorio"
        }
      },
      {
        "id" : "Composition.section:lab-no-subsections.text",
        "path" : "Composition.section.text",
        "short" : "Sintesi testuale della sezione, per l'interpretazione dell'utente."
      },
      {
        "id" : "Composition.section:lab-no-subsections.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/observation-grouping-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/observation-doc-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:lab-subsections",
        "path" : "Composition.section",
        "sliceName" : "lab-subsections",
        "short" : "Variante 2: questa sezione presenta sottosezioni senza entry"
      },
      {
        "id" : "Composition.section:lab-subsections.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:lab-subsections.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/sezione-referto-laboratorio"
        }
      },
      {
        "id" : "Composition.section:lab-subsections.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/observation-grouping-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/observation-doc-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:lab-subsections.section",
        "path" : "Composition.section.section",
        "short" : "Sottosezione strutturata della sezione principale."
      },
      {
        "id" : "Composition.section:annotations",
        "path" : "Composition.section",
        "sliceName" : "annotations",
        "short" : "Commenti testuali",
        "definition" : "Rappresentazione testuale dei commenti che accompagnano il referto, come suggerimenti per la valutazione, note tecniche del laboratorio, ecc."
      },
      {
        "id" : "Composition.section:annotations.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:annotations.code",
        "path" : "Composition.section.code",
        "min" : 1
      },
      {
        "id" : "Composition.section:annotations.text",
        "path" : "Composition.section.text",
        "short" : "Sintesi testuale della sezione, per l'interpretazione dell'utente."
      }
    ]
  }
}

```
