# DataEnterer - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DataEnterer**

## Extension: DataEnterer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/composition-dataenterer-it | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:ExtDataEnterer |

Persona o dispositivo che trasforma un testo dettato nel documento FHIR.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Composition - Lab Report](StructureDefinition-composition-it-lab.md)
* Examples for this Extension: [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md), [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md) and [Composition/2ae95a5c-9094-41a3-a437-ce6d34c55a54](Composition-2ae95a5c-9094-41a3-a437-ce6d34c55a54.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/composition-dataenterer-it)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-composition-dataenterer-it.csv), [Excel](StructureDefinition-composition-dataenterer-it.xlsx), [Schematron](StructureDefinition-composition-dataenterer-it.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "composition-dataenterer-it",
  "url" : "http://hl7.it/fhir/StructureDefinition/composition-dataenterer-it",
  "version" : "0.2.0",
  "name" : "ExtDataEnterer",
  "title" : "DataEnterer",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Persona o dispositivo che trasforma un testo dettato nel documento FHIR.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Composition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "DataEnterer",
        "definition" : "Persona o dispositivo che trasforma un testo dettato nel documento FHIR."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 1
      },
      {
        "id" : "Extension.extension:dataEnterer",
        "path" : "Extension.extension",
        "sliceName" : "dataEnterer",
        "short" : "Informazioni sulla persona e sull'organizzazione che ha inserito i dati.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:dataEnterer.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:dataEnterer.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "dataEnterer"
      },
      {
        "id" : "Extension.extension:dataEnterer.value[x]",
        "path" : "Extension.extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.extension:dataEnterer.value[x]:valueReference",
        "path" : "Extension.extension.value[x]",
        "sliceName" : "valueReference",
        "short" : "Compilatore dei dati presenti in Composition.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ]
          }
        ]
      },
      {
        "id" : "Extension.extension:tempoCompilazione",
        "path" : "Extension.extension",
        "sliceName" : "tempoCompilazione",
        "short" : "Data e ora di compilazione dei dati.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/dataEnterer-time"]
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.it/fhir/StructureDefinition/composition-dataenterer-it"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
