# Bundle - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle - Lab Report**

## Resource Profile: Bundle - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/bundle-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BundleRefertoLabIt |

 
Descrizione del contenuto informativo del report tramite il profilo della risorsa Bundle per il referto di laboratorio. 

**Usages:**

* Examples for this Profile: [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/bundle-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-bundle-it-lab.csv), [Excel](StructureDefinition-bundle-it-lab.xlsx), [Schematron](StructureDefinition-bundle-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "bundle-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/bundle-it-lab",
  "version" : "0.2.0",
  "name" : "BundleRefertoLabIt",
  "title" : "Bundle - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione del contenuto informativo del report tramite il profilo della risorsa Bundle per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Bundle-eu-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "Bundle Referto di Laboratorio",
        "definition" : "La creazione di un FHIR Document prevede la costruzione di una Bundle con le seguenti caratteristiche:\n - ′type′=document\n - identifier obbligatorio\n - prima risorsa referenziata ′Composition′ di cui ′identifier′ opzionale e ′date′ obbligatorio\n - ′timestamp′ obbligatorio\n"
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "short" : "Identificativo del FHIR Document.",
        "definition" : "L'identificativo è dipendente dalla versione della Bundle, e per soddisfare i requisiti di persistenza deve essere unico."
      },
      {
        "id" : "Bundle.identifier.system",
        "path" : "Bundle.identifier.system",
        "short" : "Sistema di codifica che contiene il codice identificativo.",
        "min" : 1
      },
      {
        "id" : "Bundle.identifier.value",
        "path" : "Bundle.identifier.value",
        "short" : "Valore univoco di identificazione della bundle.",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "short" : "Tipologia di Bundle."
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "short" : "Quando la Bundle è stata creata."
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "short" : "Risorse contenute nel documento FHIR.",
        "min" : 3
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition"
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/composition-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:diagnosticReport",
        "path" : "Bundle.entry",
        "sliceName" : "diagnosticReport"
      },
      {
        "id" : "Bundle.entry:diagnosticReport.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DiagnosticReport",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/diagnosticreport-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "min" : 1
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation",
        "path" : "Bundle.entry",
        "sliceName" : "observation"
      },
      {
        "id" : "Bundle.entry:observation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/observation-doc-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:specimen",
        "path" : "Bundle.entry",
        "sliceName" : "specimen"
      },
      {
        "id" : "Bundle.entry:specimen.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Specimen",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/specimen-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:serviceRequest",
        "path" : "Bundle.entry",
        "sliceName" : "serviceRequest"
      },
      {
        "id" : "Bundle.entry:serviceRequest.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "ServiceRequest",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/servicerequest-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization"
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner"
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitionerRole",
        "path" : "Bundle.entry",
        "sliceName" : "practitionerRole"
      },
      {
        "id" : "Bundle.entry:practitionerRole.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "PractitionerRole",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:encounter",
        "path" : "Bundle.entry",
        "sliceName" : "encounter"
      },
      {
        "id" : "Bundle.entry:encounter.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Encounter",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/encounter-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:location",
        "path" : "Bundle.entry",
        "sliceName" : "location"
      },
      {
        "id" : "Bundle.entry:location.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Location",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/location-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:media",
        "path" : "Bundle.entry",
        "sliceName" : "media",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:media.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Media",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/media-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:substance",
        "path" : "Bundle.entry",
        "sliceName" : "substance",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:substance.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Substance",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/substance-additive-specimen-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.signature",
        "path" : "Bundle.signature",
        "short" : "Firma digitale del documento."
      }
    ]
  }
}

```
