# A.5 - Risultato - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.5 - Risultato**

## Logical Model: A.5 - Risultato 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/Risultato | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:ResultLabEhn |

 
Risultato dell'esame. 

**Usages:**

* Use this Logical Model: [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/Risultato)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Risultato.csv), [Excel](StructureDefinition-Risultato.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Risultato",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/Risultato",
  "version" : "0.2.0",
  "name" : "ResultLabEhn",
  "title" : "A.5 - Risultato",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Risultato dell'esame.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Lab Result model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/Risultato",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Risultato",
        "path" : "Risultato",
        "short" : "A.5 - Risultato",
        "definition" : "Risultato dell'esame.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/ObservationRefertoLabIt')"
          }
        ]
      },
      {
        "id" : "Risultato.bloccoNarrativo",
        "path" : "Risultato.bloccoNarrativo",
        "short" : "A.5.1 Parte Narrativa del Referto di Laboratorio",
        "definition" : "A.5.1 Parte Narrativa del Referto di Laboratorio",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.section.section.text"
          },
          {
            "identity" : "fhir",
            "map" : "Composition.section.text"
          },
          {
            "identity" : "fhir",
            "map" : "Composition.text"
          }
        ]
      },
      {
        "id" : "Risultato.bloccoNarrativo.report",
        "path" : "Risultato.bloccoNarrativo.report",
        "short" : "A.5.1.1 Report",
        "definition" : "Referto completo (sintesi testuale del documento del Referto di laboratorio) così come emesso dal laboratorio.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Narrative"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.section.section.text"
          },
          {
            "identity" : "fhir",
            "map" : "Composition.section.text"
          },
          {
            "identity" : "fhir",
            "map" : "Composition.text"
          }
        ]
      },
      {
        "id" : "Risultato.bloccoNarrativo.note",
        "path" : "Risultato.bloccoNarrativo.note",
        "short" : "A.5.1.2 Commenti, interpretazione e raccomandazioni",
        "definition" : "Commenti, ad esempio un'interpretazione testuale o consigli che accompagnano il rapporto sui risultati.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Narrative"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.section:annotations.text"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione",
        "path" : "Risultato.osservazione",
        "short" : "A.5.2 Dettagli dell'osservazione",
        "definition" : "A.5.2 Dettagli dell'osservazione (il rapporto può consistere di più osservazioni) ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/ObservationRefertoLabIt')"
          },
          {
            "identity" : "fhir",
            "map" : "Observation.hasMember.resolve()"
          },
          {
            "identity" : "fhir",
            "map" : "Observation.component"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.data",
        "path" : "Risultato.osservazione.data",
        "short" : "A.5.2.1 Data dell'osservazione",
        "definition" : "Data e ora dell'osservazione - Sistema di codifica: ISO 8601",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.effective[x]"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.codice",
        "path" : "Risultato.osservazione.codice",
        "short" : "A.5.2.3 Codice dell'osservazione",
        "definition" : "Codice che rappresenta l'osservazione utilizzando i sistemi di codici concordati.\n- Sistema/i preferito/i: LOINC\n- Sistema/i preferito/i: NPU\n- Sistema/i preferito/i: SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.code"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.codice.nome",
        "path" : "Risultato.osservazione.codice.nome",
        "short" : "A.5.2.3.1 Nome dell'osservazione",
        "definition" : "Nome completo dell'osservazione in base allo standard di codifica utilizzato.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.code.coding.display"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.codice.nomeConvenzionale",
        "path" : "Risultato.osservazione.codice.nomeConvenzionale",
        "short" : "A.5.2.3.2 Nome originale dell'osservazione",
        "definition" : "Nome originale (convenzionale) dell'osservazione utilizzato dal laboratorio.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.code.text"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.codice.displayName",
        "path" : "Risultato.osservazione.codice.displayName",
        "short" : "A.5.2.3.3 Nome visualizzato dell'osservazione",
        "definition" : "Nome dell'osservazione semplificato (nome breve dell'osservazione) per la visualizzazione",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.code.coding.display.extension('translation')"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.metodo",
        "path" : "Risultato.osservazione.metodo",
        "short" : "A.5.2.4 Metodo di osservazione",
        "definition" : "Metodo di osservazione (principio di misurazione) per ottenere il risultato.\n- Sistema/i preferito/i: SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.method"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.device",
        "path" : "Risultato.osservazione.device",
        "short" : "A.5.2.5 Dispositivo utilizzato per l'osservazione",
        "definition" : "Informazioni sul dispositivo (analizzatore), sul kit utilizzato per il test di laboratorio e sul calibratore  (identificatore, tipo, nome, modello, produttore)\n- Sistema/i preferito/i: SNOMED CT\n - Sistema/i preferito/i: EMDN",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.device.resolve()"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.ordine",
        "path" : "Risultato.osservazione.ordine",
        "short" : "A.5.2.8 Ordine",
        "definition" : "Identifica l'esame e chi effettua l'esame.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.basedOn.resolve().ofType(ServiceRequest)"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.esecutore",
        "path" : "Risultato.osservazione.esecutore",
        "short" : "A.5.2.9 Esecutore",
        "definition" : "Identifica l'autore e fornisce informazioni sulla provenienza dei dati (del risultato) che potrebbero non essere derivati dal referto di laboratorio stessp. ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.performer.resolve()"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.reporter",
        "path" : "Risultato.osservazione.reporter",
        "short" : "A.5.2.10 Reporter",
        "definition" : "A seguito dei risultati ottenuti, ci può essere un interprete o una persona responsabile della convalida.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.risultato",
        "path" : "Risultato.osservazione.risultato",
        "short" : "A.5.2.11 Risultato dell'osservazione",
        "definition" : "Risultato e codifica della misura relativa all'osservazione inclusi testo, risultati numerici e codificati. Il contenuto del risultato dell'osservazione varierà a seconda del tipo di osservazione.\n- Sistema/i preferito/i: SNOMED CT (per i risultati in scala ordinale o nominale e codifica dei risultati)\n- Sistema/i preferito/i: UCUM (per unità)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.value[x]"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.interprete",
        "path" : "Risultato.osservazione.interprete",
        "short" : "A.5.2.12 Interpretazione dell'osservazione",
        "definition" : "Informazioni sugli intervalli di riferimento e sull'interpretazione dei risultati.\n - Sistema/i preferito/i: SNOMED CT\n - Sistema/i preferito/i: HL7 v3 Code System ObservationInterpretation",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.interpretation"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.descrizione",
        "path" : "Risultato.osservazione.descrizione",
        "short" : "A.5.2.13 Descrizione del risultato",
        "definition" : "Commenti e rappresentazione narrativa del risultato dell'osservazione e dei risultati.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Narrative"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.text"
          },
          {
            "identity" : "fhir",
            "map" : "Observation.note"
          }
        ]
      },
      {
        "id" : "Risultato.osservazione.statoAccreditamento",
        "path" : "Risultato.osservazione.statoAccreditamento",
        "short" : "A.5.2.14 Stato di accreditamento",
        "definition" : "Stato di accreditamento del laboratorio per la particolare osservazione.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      }
    ]
  }
}

```
