# A.2,A.3 - Richiesta - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2,A.3 - Richiesta**

## Logical Model: A.2,A.3 - Richiesta 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/Richiesta | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:Richiesta |

 
Informazioni sulla richiesta (A.2) e motivazioni (A3). 

**Usages:**

* Use this Logical Model: [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/Richiesta)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Richiesta.csv), [Excel](StructureDefinition-Richiesta.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Richiesta",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/Richiesta",
  "version" : "0.2.0",
  "name" : "Richiesta",
  "title" : "A.2,A.3 - Richiesta",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Informazioni sulla richiesta (A.2) e motivazioni (A3).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Lab Modello Logico Richiesta - FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/Richiesta",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Richiesta",
        "path" : "Richiesta",
        "short" : "A.2,A.3 - Richiesta",
        "definition" : "Informazioni sulla richiesta (A.2) e motivazioni (A3)."
      },
      {
        "id" : "Richiesta.dettagliRichiesta",
        "path" : "Richiesta.dettagliRichiesta",
        "short" : "A.2 Informazioni sulla richiesta",
        "definition" : "A.2 Informazioni sulla richiesta (Laboratory Result Report could respond to multiple test orders) ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Richiesta.dettagliRichiesta.identificativo",
        "path" : "Richiesta.dettagliRichiesta.identificativo",
        "short" : "A.2.1 Identificativo della richiesta",
        "definition" : "Identificativo della richiesta dell'esame di laboratorio. Ad un unico identificativo possono corrispondere più richieste.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "ServiceRequest.identifier"
          }
        ]
      },
      {
        "id" : "Richiesta.dettagliRichiesta.dateTime",
        "path" : "Richiesta.dettagliRichiesta.dateTime",
        "short" : "A.2.2 Data ed ora della richiesta",
        "definition" : "Data ed orario in cui è stata effettuata la richiesta - Preferred system(s): ISO 8601",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "ServiceRequest.authoredOn"
          }
        ]
      },
      {
        "id" : "Richiesta.dettagliRichiesta.mittenteRichiesta",
        "path" : "Richiesta.dettagliRichiesta.mittenteRichiesta",
        "short" : "A.2.3 Mittente della richiesta",
        "definition" : "Operatore sanitario che invia la richiesta.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "ServiceRequest.performer"
          }
        ]
      },
      {
        "id" : "Richiesta.dettagliRichiesta.codicePriorita",
        "path" : "Richiesta.dettagliRichiesta.codicePriorita",
        "short" : "A.2.7 Codice priorità",
        "definition" : "Priorità della richiesta",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "ServiceRequest.priority"
          }
        ]
      },
      {
        "id" : "Richiesta.quesitoDiagnostico",
        "path" : "Richiesta.quesitoDiagnostico",
        "short" : "A.3 Motivazione della richiesta",
        "definition" : "A.3 Motivazione della richiesta (Laboratory Result Report could respond to multiple reasons) ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "ServiceRequest.reasonCode"
          }
        ]
      },
      {
        "id" : "Richiesta.quesitoDiagnostico.code",
        "path" : "Richiesta.quesitoDiagnostico.code",
        "short" : "A.3.1 Quesito diagnostico associato alla richiesta",
        "definition" : "Condizioni di salute che incidono sulla salute del paziente e sono importanti da conoscere per un professionista sanitario durante un incontro sanitario. Condizioni cliniche del soggetto rilevanti per l'interpretazione dei risultati.\n- Sistema/i preferito/i: ICD-10 (ICD-11 when available)\n- Sistema/i preferito/i: SNOMED CT\n- Sistema/i preferito/i: Orphacode",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "ServiceRequest.reasonCode"
          }
        ]
      }
    ]
  }
}

```
