# A - Referto di Laboratorio - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A - Referto di Laboratorio**

## Logical Model: A - Referto di Laboratorio 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/RefertoLaboratorio | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:RefertoLaboratorio |

 
Referto di Laboratorio. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/RefertoLaboratorio)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RefertoLaboratorio.csv), [Excel](StructureDefinition-RefertoLaboratorio.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RefertoLaboratorio",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/RefertoLaboratorio",
  "version" : "0.2.0",
  "name" : "RefertoLaboratorio",
  "title" : "A - Referto di Laboratorio",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Referto di Laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Modello Logico RefertoLaboratorio - FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/RefertoLaboratorio",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "RefertoLaboratorio",
        "path" : "RefertoLaboratorio",
        "short" : "A - Referto di Laboratorio",
        "definition" : "Referto di Laboratorio.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Bundle.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/bundle-it-lab')"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header",
        "path" : "RefertoLaboratorio.header",
        "short" : "A.1 header del Referto di Laboratorio",
        "definition" : "A.1 header del Referto di Laboratorio.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/composition-it-lab')"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.soggettoReferto",
        "path" : "RefertoLaboratorio.header.soggettoReferto",
        "short" : "A.1.1 - A1.2 Paziente/Soggetto del Referto di Laboratorio",
        "definition" : "A.1.1 Identificativo del Paziente/Soggetto e A.1.2 relative informazioni sui contatti del Paziente/Soggetto ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/SoggettoCura"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.subject"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.destinatario",
        "path" : "RefertoLaboratorio.header.destinatario",
        "short" : "A.1.4 Destinatario delle informazioni",
        "definition" : "A.1.4 Destinatario delle informazioni (destinatario o destinatari del Referto di Laboratorio, potrebbero essere identificati ulteriori destinatari, ad esempio medico di base, altro specialista), se applicabile",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/Destinatario"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.org/fhir/StructureDefinition/cqf-receivingOrganization')"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.autore",
        "path" : "RefertoLaboratorio.header.autore",
        "short" : "A.1.5 Autore",
        "definition" : "A.1.5 Autore (da cui è stato redatto il referto dei risultati di laboratorio o un sottoinsieme dei risultati)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/Autore"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.author"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.firmatario",
        "path" : "RefertoLaboratorio.header.firmatario",
        "short" : "A.1.6 Firmatario del documento",
        "definition" : "A.1.6 Firmatario del documento (La persona che si assume la responsabilità di validare a livello legale il contenuto del documento)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/Firmatario"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.attester.where(mode=http://hl7.org/fhir/composition-attestation-mode#legal)"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.validatore",
        "path" : "RefertoLaboratorio.header.validatore",
        "short" : "A.1.7 Validatore del documento",
        "definition" : "A.1.7 Validatore del documento",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/Validatore"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.attester.where(mode=http://hl7.org/fhir/composition-attestation-mode#professional)"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.metadati",
        "path" : "RefertoLaboratorio.header.metadati",
        "short" : "A.1.8 Metadata del Referto di Laboratorio",
        "definition" : "A.1.8 Metadata del Referto di Laboratorio",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.metadati.tipo",
        "path" : "RefertoLaboratorio.header.metadati.tipo",
        "short" : "A.1.8.1 Tipo di documento",
        "definition" : "Codice che identifica il tipo di documento. Valore fisso \"\"Referto di medicina di laboratorio\"\" - Dizionario di codifica: LOINC",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.type"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.metadati.stato",
        "path" : "RefertoLaboratorio.header.metadati.stato",
        "short" : "A.1.8.2 Stato del Referto",
        "definition" : "Stato del Referto . Ad esempio, preliminare, finale. - Sistema di Codifica: hl7:DiagnosticReportStatus",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.status"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.metadati.data",
        "path" : "RefertoLaboratorio.header.metadati.data",
        "short" : "A.1.8.3 Data e ora della creazione del referto",
        "definition" : "Data e ora della creazione del report dei risultati. - Sistema di Codifica: ISO 8601",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Bundle.timestamp"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.metadati.titolo",
        "path" : "RefertoLaboratorio.header.metadati.titolo",
        "short" : "A.1.8.4 Titolo del documento",
        "definition" : "Titolo del documento, ad esempio \"\"Rapporto sui risultati di laboratorio\"\" - Sistema di Codifica: ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.title"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.header.metadati.custode",
        "path" : "RefertoLaboratorio.header.metadati.custode",
        "short" : "A.1.8.5 Custode del referto",
        "definition" : "Organizzazione incaricata della conservazione del referto di laboratorio - Sistema di Codifica: ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.custodian"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.ordine",
        "path" : "RefertoLaboratorio.ordine",
        "short" : "A.2-A.3 Ordine",
        "definition" : "A.2 Informazioni sull'ordine A.3 Motivo dell'ordine",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/Richiesta"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "DiagnosticReport.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/diagnosticreport-it-lab').basedOn.resolve()"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.campione",
        "path" : "RefertoLaboratorio.campione",
        "short" : "A.4 Informazioni sul campione",
        "definition" : "A.4 Informazioni sul campione",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/Campione"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/ObservationRefertoLabIt').specimen.resolve()"
          },
          {
            "identity" : "fhir",
            "map" : "DiagnosticReport.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/diagnosticreport-it-lab').specimen.resolve()"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.risultato",
        "path" : "RefertoLaboratorio.risultato",
        "short" : "A.5 Risultati dell'esame",
        "definition" : "A.5 Risultati dell'esame",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/Risultato"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.section:lab-no-subsections.entry.resolve()"
          },
          {
            "identity" : "fhir",
            "map" : "Composition.section:lab-subsections.section.entry.resolve()"
          },
          {
            "identity" : "fhir",
            "map" : "DiagnosticReport.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/diagnosticreport-it-lab').result.resolve()"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.organizer",
        "path" : "RefertoLaboratorio.organizer",
        "short" : "A.5 Batteria di esami",
        "definition" : "A.5 Batteria di esami",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/Organizer"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.section:lab-no-subsections.entry.resolve()"
          },
          {
            "identity" : "fhir",
            "map" : "Composition.section:lab-subsections.section.entry.resolve()"
          },
          {
            "identity" : "fhir",
            "map" : "DiagnosticReport.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/diagnosticreport-it-lab').result.resolve()"
          }
        ]
      },
      {
        "id" : "RefertoLaboratorio.organizer.risultato",
        "path" : "RefertoLaboratorio.organizer.risultato",
        "short" : "A.5 Risultati dell'esame",
        "definition" : "A.5 Risultati dell'esame",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/lab-report/StructureDefinition/Risultato"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.section:lab-no-subsections.entry.resolve().hasMember()"
          },
          {
            "identity" : "fhir",
            "map" : "Composition.section:lab-subsections.section.entry.resolve().hasMember()"
          }
        ]
      }
    ]
  }
}

```
