# Observation-Lab-Esempio-Glucosio - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation-Lab-Esempio-Glucosio**

## Example Observation: Observation-Lab-Esempio-Glucosio

Profile: [Observation Document - Lab Report](StructureDefinition-observation-doc-it-lab.md)

**status**: Final

**category**: Laboratory

**code**: Hematology studies (set)

**subject**: [Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2023-02-25 11:45:00+0100 --> 2023-02-25 12:45:00+0100](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-7b06368c-7089-4f66-acc8-29e1fcbd31f6)

**effective**: 2022-10-25 13:35:00+0100

**performer**: [PractitionerRole Generalist Medical Practitioners](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c)

**value**: 70 mg/dL(Details: UCUM codemg/dL = 'mg/dL')

**specimen**: [Specimen: type = Whole blood](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-168d4960-0a0b-43af-8025-180f0965f325)

**device**: [Device](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-168d4960-0a0b-43af-8025-180f0965f324)

**derivedFrom**: [Media: status = completed; type = Image; created[x] = 2023-06-21; issued = 2023-06-21 14:56:18+0000; height = 128; width = 128](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-059927b1-7e17-409e-ae60-68cc3c0b3aea)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "7e2f354b-de83-4472-bd07-1571cdb50fde",
  "meta" : {
    "profile" : [
      "http://hl7.it/fhir/lab-report/StructureDefinition/observation-doc-it-lab"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "18723-7",
        "display" : "Hematology studies (set)"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
  },
  "encounter" : {
    "reference" : "urn:uuid:7b06368c-7089-4f66-acc8-29e1fcbd31f6"
  },
  "effectiveDateTime" : "2022-10-25T13:35:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c"
    }
  ],
  "valueQuantity" : {
    "value" : 70,
    "unit" : "mg/dL",
    "system" : "http://unitsofmeasure.org",
    "code" : "mg/dL"
  },
  "specimen" : {
    "reference" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f325"
  },
  "device" : {
    "reference" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f324"
  },
  "derivedFrom" : [
    {
      "reference" : "urn:uuid:059927b1-7e17-409e-ae60-68cc3c0b3aea"
    }
  ]
}

```
