# Referto di Laboratorio - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Referto di Laboratorio**

## Example Composition: Referto di Laboratorio

Language: it-IT

Profile: [Composition - Lab Report](StructureDefinition-composition-it-lab.md)

> **DataEnterer**
* dataEnterer: [Practitioner Prova Medico](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803d)
* http://hl7.it/fhir/StructureDefinition/dataEnterer-time: 2023-02-25 10:45:00+0100

**identifier**: urn:uuid:10b545ea-725c-446d-9b95-8aeb444eddf3 (use: official, )

**status**: Final

**type**: Referto di laboratorio

**category**: Hematology studies (set)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2023-02-25 11:45:00+0100 --> 2023-02-25 12:45:00+0100](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-7b06368c-7089-4f66-acc8-29e1fcbd31f6)

**date**: 2022-03-30 11:24:26+0100

**author**: [PractitionerRole Generalist Medical Practitioners](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c)

**title**: Referto di Laboratorio

**confidentiality**: normal

### Attesters

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Mode** | **Time** | **Party** |
| * | Legal | 2023-02-25 12:45:00+0100 | [PractitionerRole Generalist Medical Practitioners](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c) |

**custodian**: [Organization Azienda Sanitara Locale Roma 1](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8)



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "2ae95a5c-9094-41a3-a437-ce6d34c55a54",
  "meta" : {
    "profile" : [
      "http://hl7.it/fhir/lab-report/StructureDefinition/composition-it-lab"
    ]
  },
  "language" : "it-IT",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "dataEnterer",
          "valueReference" : {
            "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803d"
          }
        },
        {
          "url" : "http://hl7.it/fhir/StructureDefinition/dataEnterer-time",
          "valueDateTime" : "2023-02-25T10:45:00+01:00"
        }
      ],
      "url" : "http://hl7.it/fhir/StructureDefinition/composition-dataenterer-it"
    }
  ],
  "identifier" : {
    "use" : "official",
    "value" : "urn:uuid:10b545ea-725c-446d-9b95-8aeb444eddf3",
    "assigner" : {
      "display" : "Regione Lazio"
    }
  },
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11502-2",
        "display" : "Laboratory report"
      }
    ],
    "text" : "Referto di laboratorio"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "18723-7",
          "display" : "Hematology studies (set)"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
  },
  "encounter" : {
    "reference" : "urn:uuid:7b06368c-7089-4f66-acc8-29e1fcbd31f6"
  },
  "date" : "2022-03-30T11:24:26+01:00",
  "author" : [
    {
      "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c"
    }
  ],
  "title" : "Referto di Laboratorio",
  "confidentiality" : "N",
  "attester" : [
    {
      "mode" : "legal",
      "time" : "2023-02-25T12:45:00+01:00",
      "party" : {
        "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c"
      }
    }
  ],
  "custodian" : {
    "reference" : "urn:uuid:5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8"
  },
  "section" : [
    {
      "title" : "Laboratory studies (set)",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "26436-6",
            "display" : "Laboratory studies (set)"
          }
        ]
      },
      "section" : [
        {
          "title" : "Esame del sangue",
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "18723-7",
                "display" : "Hematology studies (set)"
              }
            ]
          },
          "text" : {
            "status" : "generated",
            "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li><table id=\"nota1\"><thead><tr><th>Esame</th><th>Metodo utilizzato per l'esame</th><th>Materiale utilizzato per l'esame</th><th>Risultato dell'esame</th><th>Commenti e note</th><th>Unità di Misura</th><th>Range di Riferimento</th><th>Criteri per il range di riferimento</th><th>Interpretazione</th><th>Allegati multimediali</th></tr></thead><tbody><tr><td>Microalbumina massa/volume in urine</td><td/><td>Urine</td><td>20</td><td/><td>mg/L</td><td>0 - 20</td><td/><td>N</td><td/></tr></tbody></table></li></ul></div>"
          },
          "entry" : [
            {
              "reference" : "urn:uuid:7e2f354b-de83-4472-bd07-1571cdb50fde"
            }
          ]
        }
      ]
    }
  ]
}

```
