# ISTAT - Unità Amministrative Territoriali - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISTAT - Unità Amministrative Territoriali**

## CodeSystem: ISTAT - Unità Amministrative Territoriali 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/CodeSystem/istat-unitaAmministrativeTerritoriali | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:CsIstatUnitaAmministrativeTerritoriali |

 
ISTAT - Unità Amministrative Territoriali 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsIstatComune](ValueSet-istat-comune.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "istat-unitaAmministrativeTerritoriali",
  "url" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-unitaAmministrativeTerritoriali",
  "version" : "0.2.0",
  "name" : "CsIstatUnitaAmministrativeTerritoriali",
  "title" : "ISTAT - Unità Amministrative Territoriali",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "ISTAT - Unità Amministrative Territoriali",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "filter" : [
    {
      "code" : "regione",
      "description" : "Permette di ricercare i codici secondo il codice della regione",
      "operator" : ["="],
      "value" : "code"
    },
    {
      "code" : "flagCapoluogo",
      "description" : "Flag Comune capoluogo di provincia/città metropolitana/libero consorzio",
      "operator" : ["="],
      "value" : "boolean value"
    }
  ],
  "property" : [
    {
      "code" : "regione",
      "description" : "Proprietà che identifica la regione di appartenenza della unità amministrative territoriale",
      "type" : "code"
    },
    {
      "code" : "flagCapoluogo",
      "description" : "Flag Comune capoluogo di provincia/città metropolitana/libero consorzio",
      "type" : "boolean"
    },
    {
      "code" : "comune",
      "description" : "Proprietà che identifica il comune di appartenenza della unità amministrative territoriale",
      "type" : "code"
    },
    {
      "code" : "provincia",
      "description" : "Proprietà che identifica la provincia di appartenenza della unità amministrative territoriale",
      "type" : "code"
    },
    {
      "code" : "ripartizioneGeografica",
      "description" : "Proprietà che identifica la collocazione geografica della unità amministrative territoriale",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "001001",
      "display" : "Agliè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "001002",
      "display" : "Airasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "001003",
      "display" : "Ala di Stura",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "001004",
      "display" : "Albiano d'Ivrea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "001006",
      "display" : "Almese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "001007",
      "display" : "Alpette",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "001008",
      "display" : "Alpignano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "001009",
      "display" : "Andezeno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "001010",
      "display" : "Andrate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "001011",
      "display" : "Angrogna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "001012",
      "display" : "Arignano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "001013",
      "display" : "Avigliana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "001014",
      "display" : "Azeglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "001015",
      "display" : "Bairo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "001016",
      "display" : "Balangero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "001017",
      "display" : "Baldissero Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "001018",
      "display" : "Baldissero Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "001019",
      "display" : "Balme",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "001020",
      "display" : "Banchette",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "001021",
      "display" : "Barbania",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "001022",
      "display" : "Bardonecchia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "001023",
      "display" : "Barone Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "001024",
      "display" : "Beinasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "001025",
      "display" : "Bibiana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "001026",
      "display" : "Bobbio Pellice",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "001027",
      "display" : "Bollengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "001028",
      "display" : "Borgaro Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "001029",
      "display" : "Borgiallo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "001030",
      "display" : "Borgofranco d'Ivrea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "001031",
      "display" : "Borgomasino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "001032",
      "display" : "Borgone Susa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "001033",
      "display" : "Bosconero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "001034",
      "display" : "Brandizzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "001035",
      "display" : "Bricherasio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "001036",
      "display" : "Brosso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "001037",
      "display" : "Brozolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "001038",
      "display" : "Bruino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "001039",
      "display" : "Brusasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "001040",
      "display" : "Bruzolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "001041",
      "display" : "Buriasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "001042",
      "display" : "Burolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "001043",
      "display" : "Busano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "001044",
      "display" : "Bussoleno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "001045",
      "display" : "Buttigliera Alta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "001046",
      "display" : "Cafasse",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "001047",
      "display" : "Caluso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "001048",
      "display" : "Cambiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "001049",
      "display" : "Campiglione Fenile",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "001050",
      "display" : "Candia Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "001051",
      "display" : "Candiolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "001052",
      "display" : "Canischio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "001053",
      "display" : "Cantalupa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "001054",
      "display" : "Cantoira",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "001055",
      "display" : "Caprie",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "001056",
      "display" : "Caravino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "001057",
      "display" : "Carema",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "001058",
      "display" : "Carignano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "001059",
      "display" : "Carmagnola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "001060",
      "display" : "Casalborgone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "001061",
      "display" : "Cascinette d'Ivrea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "001062",
      "display" : "Caselette",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "001063",
      "display" : "Caselle Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "001064",
      "display" : "Castagneto Po",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "001065",
      "display" : "Castagnole Piemonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "001066",
      "display" : "Castellamonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "001067",
      "display" : "Castelnuovo Nigra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "001068",
      "display" : "Castiglione Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "001069",
      "display" : "Cavagnolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "001070",
      "display" : "Cavour",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "001071",
      "display" : "Cercenasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "001072",
      "display" : "Ceres",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "001073",
      "display" : "Ceresole Reale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "001074",
      "display" : "Cesana Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "001075",
      "display" : "Chialamberto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "001076",
      "display" : "Chianocco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "001077",
      "display" : "Chiaverano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "001078",
      "display" : "Chieri",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "001079",
      "display" : "Chiesanuova",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "001080",
      "display" : "Chiomonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "080"
        }
      ]
    },
    {
      "code" : "001081",
      "display" : "Chiusa di San Michele",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "081"
        }
      ]
    },
    {
      "code" : "001082",
      "display" : "Chivasso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "001083",
      "display" : "Ciconio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "001084",
      "display" : "Cintano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "084"
        }
      ]
    },
    {
      "code" : "001085",
      "display" : "Cinzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "001086",
      "display" : "Ciriè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "086"
        }
      ]
    },
    {
      "code" : "001087",
      "display" : "Claviere",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "001088",
      "display" : "Coassolo Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "001089",
      "display" : "Coazze",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "089"
        }
      ]
    },
    {
      "code" : "001090",
      "display" : "Collegno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "001091",
      "display" : "Colleretto Castelnuovo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "001092",
      "display" : "Colleretto Giacosa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "092"
        }
      ]
    },
    {
      "code" : "001093",
      "display" : "Condove",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "001094",
      "display" : "Corio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "094"
        }
      ]
    },
    {
      "code" : "001095",
      "display" : "Cossano Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "095"
        }
      ]
    },
    {
      "code" : "001096",
      "display" : "Cuceglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "096"
        }
      ]
    },
    {
      "code" : "001097",
      "display" : "Cumiana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "001098",
      "display" : "Cuorgnè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "098"
        }
      ]
    },
    {
      "code" : "001099",
      "display" : "Druento",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "099"
        }
      ]
    },
    {
      "code" : "001100",
      "display" : "Exilles",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "100"
        }
      ]
    },
    {
      "code" : "001101",
      "display" : "Favria",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "101"
        }
      ]
    },
    {
      "code" : "001102",
      "display" : "Feletto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "102"
        }
      ]
    },
    {
      "code" : "001103",
      "display" : "Fenestrelle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "103"
        }
      ]
    },
    {
      "code" : "001104",
      "display" : "Fiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "104"
        }
      ]
    },
    {
      "code" : "001105",
      "display" : "Fiorano Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "105"
        }
      ]
    },
    {
      "code" : "001106",
      "display" : "Foglizzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "106"
        }
      ]
    },
    {
      "code" : "001107",
      "display" : "Forno Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "107"
        }
      ]
    },
    {
      "code" : "001108",
      "display" : "Frassinetto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "001109",
      "display" : "Front",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "109"
        }
      ]
    },
    {
      "code" : "001110",
      "display" : "Frossasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "110"
        }
      ]
    },
    {
      "code" : "001111",
      "display" : "Garzigliana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "111"
        }
      ]
    },
    {
      "code" : "001112",
      "display" : "Gassino Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "112"
        }
      ]
    },
    {
      "code" : "001113",
      "display" : "Germagnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "113"
        }
      ]
    },
    {
      "code" : "001114",
      "display" : "Giaglione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "114"
        }
      ]
    },
    {
      "code" : "001115",
      "display" : "Giaveno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "115"
        }
      ]
    },
    {
      "code" : "001116",
      "display" : "Givoletto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "116"
        }
      ]
    },
    {
      "code" : "001117",
      "display" : "Gravere",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "117"
        }
      ]
    },
    {
      "code" : "001118",
      "display" : "Groscavallo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "118"
        }
      ]
    },
    {
      "code" : "001119",
      "display" : "Grosso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "119"
        }
      ]
    },
    {
      "code" : "001120",
      "display" : "Grugliasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "120"
        }
      ]
    },
    {
      "code" : "001121",
      "display" : "Ingria",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "121"
        }
      ]
    },
    {
      "code" : "001122",
      "display" : "Inverso Pinasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "122"
        }
      ]
    },
    {
      "code" : "001123",
      "display" : "Isolabella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "123"
        }
      ]
    },
    {
      "code" : "001124",
      "display" : "Issiglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "124"
        }
      ]
    },
    {
      "code" : "001125",
      "display" : "Ivrea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "125"
        }
      ]
    },
    {
      "code" : "001126",
      "display" : "La Cassa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "126"
        }
      ]
    },
    {
      "code" : "001127",
      "display" : "La Loggia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "127"
        }
      ]
    },
    {
      "code" : "001128",
      "display" : "Lanzo Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "128"
        }
      ]
    },
    {
      "code" : "001129",
      "display" : "Lauriano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "129"
        }
      ]
    },
    {
      "code" : "001130",
      "display" : "Leini",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "130"
        }
      ]
    },
    {
      "code" : "001131",
      "display" : "Lemie",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "131"
        }
      ]
    },
    {
      "code" : "001132",
      "display" : "Lessolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "132"
        }
      ]
    },
    {
      "code" : "001133",
      "display" : "Levone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "133"
        }
      ]
    },
    {
      "code" : "001134",
      "display" : "Locana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "134"
        }
      ]
    },
    {
      "code" : "001135",
      "display" : "Lombardore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "135"
        }
      ]
    },
    {
      "code" : "001136",
      "display" : "Lombriasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "136"
        }
      ]
    },
    {
      "code" : "001137",
      "display" : "Loranzè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "137"
        }
      ]
    },
    {
      "code" : "001139",
      "display" : "Luserna San Giovanni",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "139"
        }
      ]
    },
    {
      "code" : "001140",
      "display" : "Lusernetta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "140"
        }
      ]
    },
    {
      "code" : "001141",
      "display" : "Lusigliè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "141"
        }
      ]
    },
    {
      "code" : "001142",
      "display" : "Macello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "142"
        }
      ]
    },
    {
      "code" : "001143",
      "display" : "Maglione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "143"
        }
      ]
    },
    {
      "code" : "001144",
      "display" : "Marentino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "144"
        }
      ]
    },
    {
      "code" : "001145",
      "display" : "Massello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "145"
        }
      ]
    },
    {
      "code" : "001146",
      "display" : "Mathi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "146"
        }
      ]
    },
    {
      "code" : "001147",
      "display" : "Mattie",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "147"
        }
      ]
    },
    {
      "code" : "001148",
      "display" : "Mazzè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "148"
        }
      ]
    },
    {
      "code" : "001149",
      "display" : "Meana di Susa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "149"
        }
      ]
    },
    {
      "code" : "001150",
      "display" : "Mercenasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "150"
        }
      ]
    },
    {
      "code" : "001152",
      "display" : "Mezzenile",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "152"
        }
      ]
    },
    {
      "code" : "001153",
      "display" : "Mombello di Torino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "153"
        }
      ]
    },
    {
      "code" : "001154",
      "display" : "Mompantero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "154"
        }
      ]
    },
    {
      "code" : "001155",
      "display" : "Monastero di Lanzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "155"
        }
      ]
    },
    {
      "code" : "001156",
      "display" : "Moncalieri",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "156"
        }
      ]
    },
    {
      "code" : "001157",
      "display" : "Moncenisio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "157"
        }
      ]
    },
    {
      "code" : "001158",
      "display" : "Montaldo Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "158"
        }
      ]
    },
    {
      "code" : "001159",
      "display" : "Montalenghe",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "159"
        }
      ]
    },
    {
      "code" : "001160",
      "display" : "Montalto Dora",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "160"
        }
      ]
    },
    {
      "code" : "001161",
      "display" : "Montanaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "161"
        }
      ]
    },
    {
      "code" : "001162",
      "display" : "Monteu da Po",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "162"
        }
      ]
    },
    {
      "code" : "001163",
      "display" : "Moriondo Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "163"
        }
      ]
    },
    {
      "code" : "001164",
      "display" : "Nichelino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "164"
        }
      ]
    },
    {
      "code" : "001165",
      "display" : "Noasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "165"
        }
      ]
    },
    {
      "code" : "001166",
      "display" : "Nole",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "166"
        }
      ]
    },
    {
      "code" : "001167",
      "display" : "Nomaglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "167"
        }
      ]
    },
    {
      "code" : "001168",
      "display" : "None",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "168"
        }
      ]
    },
    {
      "code" : "001169",
      "display" : "Novalesa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "169"
        }
      ]
    },
    {
      "code" : "001170",
      "display" : "Oglianico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "170"
        }
      ]
    },
    {
      "code" : "001171",
      "display" : "Orbassano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "171"
        }
      ]
    },
    {
      "code" : "001172",
      "display" : "Orio Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "172"
        }
      ]
    },
    {
      "code" : "001173",
      "display" : "Osasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "173"
        }
      ]
    },
    {
      "code" : "001174",
      "display" : "Osasio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "174"
        }
      ]
    },
    {
      "code" : "001175",
      "display" : "Oulx",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "175"
        }
      ]
    },
    {
      "code" : "001176",
      "display" : "Ozegna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "176"
        }
      ]
    },
    {
      "code" : "001177",
      "display" : "Palazzo Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "177"
        }
      ]
    },
    {
      "code" : "001178",
      "display" : "Pancalieri",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "178"
        }
      ]
    },
    {
      "code" : "001179",
      "display" : "Parella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "179"
        }
      ]
    },
    {
      "code" : "001180",
      "display" : "Pavarolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "180"
        }
      ]
    },
    {
      "code" : "001181",
      "display" : "Pavone Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "181"
        }
      ]
    },
    {
      "code" : "001183",
      "display" : "Pecetto Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "183"
        }
      ]
    },
    {
      "code" : "001184",
      "display" : "Perosa Argentina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "184"
        }
      ]
    },
    {
      "code" : "001185",
      "display" : "Perosa Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "185"
        }
      ]
    },
    {
      "code" : "001186",
      "display" : "Perrero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "186"
        }
      ]
    },
    {
      "code" : "001187",
      "display" : "Pertusio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "187"
        }
      ]
    },
    {
      "code" : "001188",
      "display" : "Pessinetto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "188"
        }
      ]
    },
    {
      "code" : "001189",
      "display" : "Pianezza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "189"
        }
      ]
    },
    {
      "code" : "001190",
      "display" : "Pinasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "190"
        }
      ]
    },
    {
      "code" : "001191",
      "display" : "Pinerolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "191"
        }
      ]
    },
    {
      "code" : "001192",
      "display" : "Pino Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "192"
        }
      ]
    },
    {
      "code" : "001193",
      "display" : "Piobesi Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "193"
        }
      ]
    },
    {
      "code" : "001194",
      "display" : "Piossasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "194"
        }
      ]
    },
    {
      "code" : "001195",
      "display" : "Piscina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "195"
        }
      ]
    },
    {
      "code" : "001196",
      "display" : "Piverone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "196"
        }
      ]
    },
    {
      "code" : "001197",
      "display" : "Poirino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "197"
        }
      ]
    },
    {
      "code" : "001198",
      "display" : "Pomaretto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "198"
        }
      ]
    },
    {
      "code" : "001199",
      "display" : "Pont Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "199"
        }
      ]
    },
    {
      "code" : "001200",
      "display" : "Porte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "200"
        }
      ]
    },
    {
      "code" : "001201",
      "display" : "Pragelato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "201"
        }
      ]
    },
    {
      "code" : "001202",
      "display" : "Prali",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "202"
        }
      ]
    },
    {
      "code" : "001203",
      "display" : "Pralormo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "203"
        }
      ]
    },
    {
      "code" : "001204",
      "display" : "Pramollo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "204"
        }
      ]
    },
    {
      "code" : "001205",
      "display" : "Prarostino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "205"
        }
      ]
    },
    {
      "code" : "001206",
      "display" : "Prascorsano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "206"
        }
      ]
    },
    {
      "code" : "001207",
      "display" : "Pratiglione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "207"
        }
      ]
    },
    {
      "code" : "001208",
      "display" : "Quagliuzzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "208"
        }
      ]
    },
    {
      "code" : "001209",
      "display" : "Quassolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "209"
        }
      ]
    },
    {
      "code" : "001210",
      "display" : "Quincinetto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "210"
        }
      ]
    },
    {
      "code" : "001211",
      "display" : "Reano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "211"
        }
      ]
    },
    {
      "code" : "001212",
      "display" : "Ribordone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "212"
        }
      ]
    },
    {
      "code" : "001213",
      "display" : "Rivalba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "213"
        }
      ]
    },
    {
      "code" : "001214",
      "display" : "Rivalta di Torino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "214"
        }
      ]
    },
    {
      "code" : "001215",
      "display" : "Riva presso Chieri",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "215"
        }
      ]
    },
    {
      "code" : "001216",
      "display" : "Rivara",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "216"
        }
      ]
    },
    {
      "code" : "001217",
      "display" : "Rivarolo Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "217"
        }
      ]
    },
    {
      "code" : "001218",
      "display" : "Rivarossa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "218"
        }
      ]
    },
    {
      "code" : "001219",
      "display" : "Rivoli",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "219"
        }
      ]
    },
    {
      "code" : "001220",
      "display" : "Robassomero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "220"
        }
      ]
    },
    {
      "code" : "001221",
      "display" : "Rocca Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "221"
        }
      ]
    },
    {
      "code" : "001222",
      "display" : "Roletto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "222"
        }
      ]
    },
    {
      "code" : "001223",
      "display" : "Romano Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "223"
        }
      ]
    },
    {
      "code" : "001224",
      "display" : "Ronco Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "224"
        }
      ]
    },
    {
      "code" : "001225",
      "display" : "Rondissone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "225"
        }
      ]
    },
    {
      "code" : "001226",
      "display" : "Rorà",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "226"
        }
      ]
    },
    {
      "code" : "001227",
      "display" : "Roure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "227"
        }
      ]
    },
    {
      "code" : "001228",
      "display" : "Rosta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "228"
        }
      ]
    },
    {
      "code" : "001229",
      "display" : "Rubiana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "229"
        }
      ]
    },
    {
      "code" : "001230",
      "display" : "Rueglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "230"
        }
      ]
    },
    {
      "code" : "001231",
      "display" : "Salassa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "231"
        }
      ]
    },
    {
      "code" : "001232",
      "display" : "Salbertrand",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "232"
        }
      ]
    },
    {
      "code" : "001233",
      "display" : "Salerano Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "233"
        }
      ]
    },
    {
      "code" : "001234",
      "display" : "Salza di Pinerolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "234"
        }
      ]
    },
    {
      "code" : "001235",
      "display" : "Samone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "235"
        }
      ]
    },
    {
      "code" : "001236",
      "display" : "San Benigno Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "236"
        }
      ]
    },
    {
      "code" : "001237",
      "display" : "San Carlo Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "237"
        }
      ]
    },
    {
      "code" : "001238",
      "display" : "San Colombano Belmonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "238"
        }
      ]
    },
    {
      "code" : "001239",
      "display" : "San Didero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "239"
        }
      ]
    },
    {
      "code" : "001240",
      "display" : "San Francesco al Campo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "240"
        }
      ]
    },
    {
      "code" : "001241",
      "display" : "Sangano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "241"
        }
      ]
    },
    {
      "code" : "001242",
      "display" : "San Germano Chisone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "242"
        }
      ]
    },
    {
      "code" : "001243",
      "display" : "San Gillio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "243"
        }
      ]
    },
    {
      "code" : "001244",
      "display" : "San Giorgio Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "244"
        }
      ]
    },
    {
      "code" : "001245",
      "display" : "San Giorio di Susa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "245"
        }
      ]
    },
    {
      "code" : "001246",
      "display" : "San Giusto Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "246"
        }
      ]
    },
    {
      "code" : "001247",
      "display" : "San Martino Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "247"
        }
      ]
    },
    {
      "code" : "001248",
      "display" : "San Maurizio Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "248"
        }
      ]
    },
    {
      "code" : "001249",
      "display" : "San Mauro Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "249"
        }
      ]
    },
    {
      "code" : "001250",
      "display" : "San Pietro Val Lemina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "250"
        }
      ]
    },
    {
      "code" : "001251",
      "display" : "San Ponso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "251"
        }
      ]
    },
    {
      "code" : "001252",
      "display" : "San Raffaele Cimena",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "252"
        }
      ]
    },
    {
      "code" : "001253",
      "display" : "San Sebastiano da Po",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "253"
        }
      ]
    },
    {
      "code" : "001254",
      "display" : "San Secondo di Pinerolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "254"
        }
      ]
    },
    {
      "code" : "001255",
      "display" : "Sant'Ambrogio di Torino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "255"
        }
      ]
    },
    {
      "code" : "001256",
      "display" : "Sant'Antonino di Susa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "256"
        }
      ]
    },
    {
      "code" : "001257",
      "display" : "Santena",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "257"
        }
      ]
    },
    {
      "code" : "001258",
      "display" : "Sauze di Cesana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "258"
        }
      ]
    },
    {
      "code" : "001259",
      "display" : "Sauze d'Oulx",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "259"
        }
      ]
    },
    {
      "code" : "001260",
      "display" : "Scalenghe",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "260"
        }
      ]
    },
    {
      "code" : "001261",
      "display" : "Scarmagno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "261"
        }
      ]
    },
    {
      "code" : "001262",
      "display" : "Sciolze",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "262"
        }
      ]
    },
    {
      "code" : "001263",
      "display" : "Sestriere",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "263"
        }
      ]
    },
    {
      "code" : "001264",
      "display" : "Settimo Rottaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "264"
        }
      ]
    },
    {
      "code" : "001265",
      "display" : "Settimo Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "265"
        }
      ]
    },
    {
      "code" : "001266",
      "display" : "Settimo Vittone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "266"
        }
      ]
    },
    {
      "code" : "001267",
      "display" : "Sparone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "267"
        }
      ]
    },
    {
      "code" : "001268",
      "display" : "Strambinello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "268"
        }
      ]
    },
    {
      "code" : "001269",
      "display" : "Strambino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "269"
        }
      ]
    },
    {
      "code" : "001270",
      "display" : "Susa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "270"
        }
      ]
    },
    {
      "code" : "001271",
      "display" : "Tavagnasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "271"
        }
      ]
    },
    {
      "code" : "001272",
      "display" : "Torino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "272"
        }
      ]
    },
    {
      "code" : "001273",
      "display" : "Torrazza Piemonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "273"
        }
      ]
    },
    {
      "code" : "001274",
      "display" : "Torre Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "274"
        }
      ]
    },
    {
      "code" : "001275",
      "display" : "Torre Pellice",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "275"
        }
      ]
    },
    {
      "code" : "001276",
      "display" : "Trana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "276"
        }
      ]
    },
    {
      "code" : "001278",
      "display" : "Traversella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "278"
        }
      ]
    },
    {
      "code" : "001279",
      "display" : "Traves",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "279"
        }
      ]
    },
    {
      "code" : "001280",
      "display" : "Trofarello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "280"
        }
      ]
    },
    {
      "code" : "001281",
      "display" : "Usseaux",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "281"
        }
      ]
    },
    {
      "code" : "001282",
      "display" : "Usseglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "282"
        }
      ]
    },
    {
      "code" : "001283",
      "display" : "Vaie",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "283"
        }
      ]
    },
    {
      "code" : "001284",
      "display" : "Val della Torre",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "284"
        }
      ]
    },
    {
      "code" : "001285",
      "display" : "Valgioie",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "285"
        }
      ]
    },
    {
      "code" : "001286",
      "display" : "Vallo Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "286"
        }
      ]
    },
    {
      "code" : "001287",
      "display" : "Valperga",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "287"
        }
      ]
    },
    {
      "code" : "001288",
      "display" : "Valprato Soana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "288"
        }
      ]
    },
    {
      "code" : "001289",
      "display" : "Varisella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "289"
        }
      ]
    },
    {
      "code" : "001290",
      "display" : "Vauda Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "290"
        }
      ]
    },
    {
      "code" : "001291",
      "display" : "Venaus",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "291"
        }
      ]
    },
    {
      "code" : "001292",
      "display" : "Venaria Reale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "292"
        }
      ]
    },
    {
      "code" : "001293",
      "display" : "Verolengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "293"
        }
      ]
    },
    {
      "code" : "001294",
      "display" : "Verrua Savoia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "294"
        }
      ]
    },
    {
      "code" : "001295",
      "display" : "Vestignè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "295"
        }
      ]
    },
    {
      "code" : "001296",
      "display" : "Vialfrè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "296"
        }
      ]
    },
    {
      "code" : "001298",
      "display" : "Vidracco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "298"
        }
      ]
    },
    {
      "code" : "001299",
      "display" : "Vigone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "299"
        }
      ]
    },
    {
      "code" : "001300",
      "display" : "Villafranca Piemonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "300"
        }
      ]
    },
    {
      "code" : "001301",
      "display" : "Villanova Canavese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "301"
        }
      ]
    },
    {
      "code" : "001302",
      "display" : "Villarbasse",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "302"
        }
      ]
    },
    {
      "code" : "001303",
      "display" : "Villar Dora",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "303"
        }
      ]
    },
    {
      "code" : "001304",
      "display" : "Villareggia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "304"
        }
      ]
    },
    {
      "code" : "001305",
      "display" : "Villar Focchiardo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "305"
        }
      ]
    },
    {
      "code" : "001306",
      "display" : "Villar Pellice",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "306"
        }
      ]
    },
    {
      "code" : "001307",
      "display" : "Villar Perosa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "307"
        }
      ]
    },
    {
      "code" : "001308",
      "display" : "Villastellone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "308"
        }
      ]
    },
    {
      "code" : "001309",
      "display" : "Vinovo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "309"
        }
      ]
    },
    {
      "code" : "001310",
      "display" : "Virle Piemonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "310"
        }
      ]
    },
    {
      "code" : "001311",
      "display" : "Vische",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "311"
        }
      ]
    },
    {
      "code" : "001312",
      "display" : "Vistrorio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "312"
        }
      ]
    },
    {
      "code" : "001313",
      "display" : "Viù",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "313"
        }
      ]
    },
    {
      "code" : "001314",
      "display" : "Volpiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "314"
        }
      ]
    },
    {
      "code" : "001315",
      "display" : "Volvera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "315"
        }
      ]
    },
    {
      "code" : "001316",
      "display" : "Mappano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "316"
        }
      ]
    },
    {
      "code" : "001317",
      "display" : "Val di Chy",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "317"
        }
      ]
    },
    {
      "code" : "001318",
      "display" : "Valchiusa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "001"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "318"
        }
      ]
    },
    {
      "code" : "002002",
      "display" : "Alagna Valsesia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "002003",
      "display" : "Albano Vercellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "002004",
      "display" : "Alice Castello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "002006",
      "display" : "Arborio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "002007",
      "display" : "Asigliano Vercellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "002008",
      "display" : "Balmuccia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "002009",
      "display" : "Balocco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "002011",
      "display" : "Bianzè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "002014",
      "display" : "Boccioleto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "002015",
      "display" : "Borgo d'Ale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "002016",
      "display" : "Borgosesia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "002017",
      "display" : "Borgo Vercelli",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "002021",
      "display" : "Buronzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "002025",
      "display" : "Campertogno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "002029",
      "display" : "Carcoforo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "002030",
      "display" : "Caresana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "002031",
      "display" : "Caresanablot",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "002032",
      "display" : "Carisio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "002033",
      "display" : "Casanova Elvo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "002035",
      "display" : "San Giacomo Vercellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "002041",
      "display" : "Cervatto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "002042",
      "display" : "Cigliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "002043",
      "display" : "Civiasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "002045",
      "display" : "Collobiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "002047",
      "display" : "Costanzana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "002048",
      "display" : "Cravagliana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "002049",
      "display" : "Crescentino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "002052",
      "display" : "Crova",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "002054",
      "display" : "Desana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "002057",
      "display" : "Fobello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "002058",
      "display" : "Fontanetto Po",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "002059",
      "display" : "Formigliana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "002061",
      "display" : "Gattinara",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "002062",
      "display" : "Ghislarengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "002065",
      "display" : "Greggio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "002066",
      "display" : "Guardabosone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "002067",
      "display" : "Lamporo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "002068",
      "display" : "Lenta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "002070",
      "display" : "Lignana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "002071",
      "display" : "Livorno Ferraris",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "002072",
      "display" : "Lozzolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "002078",
      "display" : "Mollia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "002079",
      "display" : "Moncrivello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "002082",
      "display" : "Motta de' Conti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "002088",
      "display" : "Olcenengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "002089",
      "display" : "Oldenico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "089"
        }
      ]
    },
    {
      "code" : "002090",
      "display" : "Palazzolo Vercellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "002091",
      "display" : "Pertengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "002093",
      "display" : "Pezzana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "002096",
      "display" : "Pila",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "096"
        }
      ]
    },
    {
      "code" : "002097",
      "display" : "Piode",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "002102",
      "display" : "Postua",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "102"
        }
      ]
    },
    {
      "code" : "002104",
      "display" : "Prarolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "104"
        }
      ]
    },
    {
      "code" : "002107",
      "display" : "Quarona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "107"
        }
      ]
    },
    {
      "code" : "002108",
      "display" : "Quinto Vercellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "002110",
      "display" : "Rassa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "110"
        }
      ]
    },
    {
      "code" : "002113",
      "display" : "Rimella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "113"
        }
      ]
    },
    {
      "code" : "002115",
      "display" : "Rive",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "115"
        }
      ]
    },
    {
      "code" : "002116",
      "display" : "Roasio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "116"
        }
      ]
    },
    {
      "code" : "002118",
      "display" : "Ronsecco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "118"
        }
      ]
    },
    {
      "code" : "002121",
      "display" : "Rossa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "121"
        }
      ]
    },
    {
      "code" : "002122",
      "display" : "Rovasenda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "122"
        }
      ]
    },
    {
      "code" : "002126",
      "display" : "Salasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "126"
        }
      ]
    },
    {
      "code" : "002127",
      "display" : "Sali Vercellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "127"
        }
      ]
    },
    {
      "code" : "002128",
      "display" : "Saluggia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "128"
        }
      ]
    },
    {
      "code" : "002131",
      "display" : "San Germano Vercellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "131"
        }
      ]
    },
    {
      "code" : "002133",
      "display" : "Santhià",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "133"
        }
      ]
    },
    {
      "code" : "002134",
      "display" : "Scopa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "134"
        }
      ]
    },
    {
      "code" : "002135",
      "display" : "Scopello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "135"
        }
      ]
    },
    {
      "code" : "002137",
      "display" : "Serravalle Sesia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "137"
        }
      ]
    },
    {
      "code" : "002142",
      "display" : "Stroppiana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "142"
        }
      ]
    },
    {
      "code" : "002147",
      "display" : "Tricerro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "147"
        }
      ]
    },
    {
      "code" : "002148",
      "display" : "Trino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "148"
        }
      ]
    },
    {
      "code" : "002150",
      "display" : "Tronzano Vercellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "150"
        }
      ]
    },
    {
      "code" : "002152",
      "display" : "Valduggia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "152"
        }
      ]
    },
    {
      "code" : "002156",
      "display" : "Varallo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "156"
        }
      ]
    },
    {
      "code" : "002158",
      "display" : "Vercelli",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "158"
        }
      ]
    },
    {
      "code" : "002163",
      "display" : "Villarboit",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "163"
        }
      ]
    },
    {
      "code" : "002164",
      "display" : "Villata",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "164"
        }
      ]
    },
    {
      "code" : "002166",
      "display" : "Vocca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "166"
        }
      ]
    },
    {
      "code" : "002170",
      "display" : "Alto Sermenza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "170"
        }
      ]
    },
    {
      "code" : "002171",
      "display" : "Cellio con Breia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "002"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "171"
        }
      ]
    },
    {
      "code" : "003001",
      "display" : "Agrate Conturbia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "003002",
      "display" : "Ameno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "003006",
      "display" : "Armeno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "003008",
      "display" : "Arona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "003012",
      "display" : "Barengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "003016",
      "display" : "Bellinzago Novarese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "003018",
      "display" : "Biandrate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "003019",
      "display" : "Boca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "003021",
      "display" : "Bogogno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "003022",
      "display" : "Bolzano Novarese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "003023",
      "display" : "Borgolavezzaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "003024",
      "display" : "Borgomanero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "003025",
      "display" : "Borgo Ticino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "003026",
      "display" : "Briga Novarese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "003027",
      "display" : "Briona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "003030",
      "display" : "Caltignaga",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "003032",
      "display" : "Cameri",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "003036",
      "display" : "Carpignano Sesia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "003037",
      "display" : "Casalbeltrame",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "003039",
      "display" : "Casaleggio Novara",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "003040",
      "display" : "Casalino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "003041",
      "display" : "Casalvolone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "003042",
      "display" : "Castellazzo Novarese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "003043",
      "display" : "Castelletto sopra Ticino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "003044",
      "display" : "Cavaglietto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "003045",
      "display" : "Cavaglio d'Agogna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "003047",
      "display" : "Cavallirio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "003049",
      "display" : "Cerano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "003051",
      "display" : "Colazza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "003052",
      "display" : "Comignago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "003055",
      "display" : "Cressa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "003058",
      "display" : "Cureggio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "003060",
      "display" : "Divignano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "003062",
      "display" : "Dormelletto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "003065",
      "display" : "Fara Novarese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "003066",
      "display" : "Fontaneto d'Agogna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "003068",
      "display" : "Galliate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "003069",
      "display" : "Garbagna Novarese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "003070",
      "display" : "Gargallo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "003073",
      "display" : "Ghemme",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "003076",
      "display" : "Gozzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "003077",
      "display" : "Granozzo con Monticello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "003079",
      "display" : "Grignasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "003082",
      "display" : "Invorio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "003083",
      "display" : "Landiona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "003084",
      "display" : "Lesa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "084"
        }
      ]
    },
    {
      "code" : "003088",
      "display" : "Maggiora",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "003090",
      "display" : "Mandello Vitta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "003091",
      "display" : "Marano Ticino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "003093",
      "display" : "Massino Visconti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "003095",
      "display" : "Meina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "095"
        }
      ]
    },
    {
      "code" : "003097",
      "display" : "Mezzomerico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "003098",
      "display" : "Miasino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "098"
        }
      ]
    },
    {
      "code" : "003100",
      "display" : "Momo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "100"
        }
      ]
    },
    {
      "code" : "003103",
      "display" : "Nebbiuno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "103"
        }
      ]
    },
    {
      "code" : "003104",
      "display" : "Nibbiola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "104"
        }
      ]
    },
    {
      "code" : "003106",
      "display" : "Novara",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "106"
        }
      ]
    },
    {
      "code" : "003108",
      "display" : "Oleggio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "003109",
      "display" : "Oleggio Castello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "109"
        }
      ]
    },
    {
      "code" : "003112",
      "display" : "Orta San Giulio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "112"
        }
      ]
    },
    {
      "code" : "003114",
      "display" : "Paruzzaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "114"
        }
      ]
    },
    {
      "code" : "003115",
      "display" : "Pella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "115"
        }
      ]
    },
    {
      "code" : "003116",
      "display" : "Pettenasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "116"
        }
      ]
    },
    {
      "code" : "003119",
      "display" : "Pisano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "119"
        }
      ]
    },
    {
      "code" : "003120",
      "display" : "Pogno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "120"
        }
      ]
    },
    {
      "code" : "003121",
      "display" : "Pombia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "121"
        }
      ]
    },
    {
      "code" : "003122",
      "display" : "Prato Sesia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "122"
        }
      ]
    },
    {
      "code" : "003129",
      "display" : "Recetto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "129"
        }
      ]
    },
    {
      "code" : "003130",
      "display" : "Romagnano Sesia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "130"
        }
      ]
    },
    {
      "code" : "003131",
      "display" : "Romentino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "131"
        }
      ]
    },
    {
      "code" : "003133",
      "display" : "San Maurizio d'Opaglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "133"
        }
      ]
    },
    {
      "code" : "003134",
      "display" : "San Nazzaro Sesia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "134"
        }
      ]
    },
    {
      "code" : "003135",
      "display" : "San Pietro Mosezzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "135"
        }
      ]
    },
    {
      "code" : "003138",
      "display" : "Sillavengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "138"
        }
      ]
    },
    {
      "code" : "003139",
      "display" : "Sizzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "139"
        }
      ]
    },
    {
      "code" : "003140",
      "display" : "Soriso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "140"
        }
      ]
    },
    {
      "code" : "003141",
      "display" : "Sozzago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "141"
        }
      ]
    },
    {
      "code" : "003143",
      "display" : "Suno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "143"
        }
      ]
    },
    {
      "code" : "003144",
      "display" : "Terdobbiate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "144"
        }
      ]
    },
    {
      "code" : "003146",
      "display" : "Tornaco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "146"
        }
      ]
    },
    {
      "code" : "003149",
      "display" : "Trecate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "149"
        }
      ]
    },
    {
      "code" : "003153",
      "display" : "Vaprio d'Agogna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "153"
        }
      ]
    },
    {
      "code" : "003154",
      "display" : "Varallo Pombia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "154"
        }
      ]
    },
    {
      "code" : "003158",
      "display" : "Vespolate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "158"
        }
      ]
    },
    {
      "code" : "003159",
      "display" : "Vicolungo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "159"
        }
      ]
    },
    {
      "code" : "003164",
      "display" : "Vinzaglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "164"
        }
      ]
    },
    {
      "code" : "003166",
      "display" : "Gattico-Veruno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "003"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "166"
        }
      ]
    },
    {
      "code" : "004001",
      "display" : "Acceglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "004002",
      "display" : "Aisone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "004003",
      "display" : "Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "004004",
      "display" : "Albaretto della Torre",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "004005",
      "display" : "Alto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "004006",
      "display" : "Argentera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "004007",
      "display" : "Arguello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "004008",
      "display" : "Bagnasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "004009",
      "display" : "Bagnolo Piemonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "004010",
      "display" : "Baldissero d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "004011",
      "display" : "Barbaresco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "004012",
      "display" : "Barge",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "004013",
      "display" : "Barolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "004014",
      "display" : "Bastia Mondovì",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "004015",
      "display" : "Battifollo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "004016",
      "display" : "Beinette",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "004017",
      "display" : "Bellino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "004018",
      "display" : "Belvedere Langhe",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "004019",
      "display" : "Bene Vagienna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "004020",
      "display" : "Benevello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "004021",
      "display" : "Bergolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "004022",
      "display" : "Bernezzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "004023",
      "display" : "Bonvicino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "004024",
      "display" : "Borgomale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "004025",
      "display" : "Borgo San Dalmazzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "004026",
      "display" : "Bosia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "004027",
      "display" : "Bossolasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "004028",
      "display" : "Boves",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "004029",
      "display" : "Bra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "004030",
      "display" : "Briaglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "004031",
      "display" : "Briga Alta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "004032",
      "display" : "Brondello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "004033",
      "display" : "Brossasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "004034",
      "display" : "Busca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "004035",
      "display" : "Camerana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "004037",
      "display" : "Canale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "004038",
      "display" : "Canosio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "004039",
      "display" : "Caprauna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "004040",
      "display" : "Caraglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "004041",
      "display" : "Caramagna Piemonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "004042",
      "display" : "Cardè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "004043",
      "display" : "Carrù",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "004044",
      "display" : "Cartignano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "004045",
      "display" : "Casalgrasso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "004046",
      "display" : "Castagnito",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "004047",
      "display" : "Casteldelfino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "004049",
      "display" : "Castelletto Stura",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "004050",
      "display" : "Castelletto Uzzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "004051",
      "display" : "Castellinaldo d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "004052",
      "display" : "Castellino Tanaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "004053",
      "display" : "Castelmagno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "004054",
      "display" : "Castelnuovo di Ceva",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "004055",
      "display" : "Castiglione Falletto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "004056",
      "display" : "Castiglione Tinella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "004057",
      "display" : "Castino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "004058",
      "display" : "Cavallerleone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "004059",
      "display" : "Cavallermaggiore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "004060",
      "display" : "Celle di Macra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "004061",
      "display" : "Centallo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "004062",
      "display" : "Ceresole Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "004063",
      "display" : "Cerretto Langhe",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "004064",
      "display" : "Cervasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "004065",
      "display" : "Cervere",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "004066",
      "display" : "Ceva",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "004067",
      "display" : "Cherasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "004068",
      "display" : "Chiusa di Pesio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "004069",
      "display" : "Cigliè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "004070",
      "display" : "Cissone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "004071",
      "display" : "Clavesana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "004072",
      "display" : "Corneliano d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "004073",
      "display" : "Cortemilia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "004074",
      "display" : "Cossano Belbo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "004075",
      "display" : "Costigliole Saluzzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "004076",
      "display" : "Cravanzana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "004077",
      "display" : "Crissolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "004078",
      "display" : "Cuneo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "004079",
      "display" : "Demonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "004080",
      "display" : "Diano d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "080"
        }
      ]
    },
    {
      "code" : "004081",
      "display" : "Dogliani",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "081"
        }
      ]
    },
    {
      "code" : "004082",
      "display" : "Dronero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "004083",
      "display" : "Elva",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "004084",
      "display" : "Entracque",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "084"
        }
      ]
    },
    {
      "code" : "004085",
      "display" : "Envie",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "004086",
      "display" : "Farigliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "086"
        }
      ]
    },
    {
      "code" : "004087",
      "display" : "Faule",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "004088",
      "display" : "Feisoglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "004089",
      "display" : "Fossano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "089"
        }
      ]
    },
    {
      "code" : "004090",
      "display" : "Frabosa Soprana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "004091",
      "display" : "Frabosa Sottana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "004092",
      "display" : "Frassino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "092"
        }
      ]
    },
    {
      "code" : "004093",
      "display" : "Gaiola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "004094",
      "display" : "Gambasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "094"
        }
      ]
    },
    {
      "code" : "004095",
      "display" : "Garessio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "095"
        }
      ]
    },
    {
      "code" : "004096",
      "display" : "Genola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "096"
        }
      ]
    },
    {
      "code" : "004097",
      "display" : "Gorzegno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "004098",
      "display" : "Gottasecca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "098"
        }
      ]
    },
    {
      "code" : "004099",
      "display" : "Govone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "099"
        }
      ]
    },
    {
      "code" : "004100",
      "display" : "Grinzane Cavour",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "100"
        }
      ]
    },
    {
      "code" : "004101",
      "display" : "Guarene",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "101"
        }
      ]
    },
    {
      "code" : "004102",
      "display" : "Igliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "102"
        }
      ]
    },
    {
      "code" : "004103",
      "display" : "Isasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "103"
        }
      ]
    },
    {
      "code" : "004104",
      "display" : "Lagnasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "104"
        }
      ]
    },
    {
      "code" : "004105",
      "display" : "La Morra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "105"
        }
      ]
    },
    {
      "code" : "004106",
      "display" : "Lequio Berria",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "106"
        }
      ]
    },
    {
      "code" : "004107",
      "display" : "Lequio Tanaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "107"
        }
      ]
    },
    {
      "code" : "004108",
      "display" : "Lesegno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "004109",
      "display" : "Levice",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "109"
        }
      ]
    },
    {
      "code" : "004110",
      "display" : "Limone Piemonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "110"
        }
      ]
    },
    {
      "code" : "004111",
      "display" : "Lisio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "111"
        }
      ]
    },
    {
      "code" : "004112",
      "display" : "Macra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "112"
        }
      ]
    },
    {
      "code" : "004113",
      "display" : "Magliano Alfieri",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "113"
        }
      ]
    },
    {
      "code" : "004114",
      "display" : "Magliano Alpi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "114"
        }
      ]
    },
    {
      "code" : "004115",
      "display" : "Mango",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "115"
        }
      ]
    },
    {
      "code" : "004116",
      "display" : "Manta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "116"
        }
      ]
    },
    {
      "code" : "004117",
      "display" : "Marene",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "117"
        }
      ]
    },
    {
      "code" : "004118",
      "display" : "Margarita",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "118"
        }
      ]
    },
    {
      "code" : "004119",
      "display" : "Marmora",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "119"
        }
      ]
    },
    {
      "code" : "004120",
      "display" : "Marsaglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "120"
        }
      ]
    },
    {
      "code" : "004121",
      "display" : "Martiniana Po",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "121"
        }
      ]
    },
    {
      "code" : "004122",
      "display" : "Melle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "122"
        }
      ]
    },
    {
      "code" : "004123",
      "display" : "Moiola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "123"
        }
      ]
    },
    {
      "code" : "004124",
      "display" : "Mombarcaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "124"
        }
      ]
    },
    {
      "code" : "004125",
      "display" : "Mombasiglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "125"
        }
      ]
    },
    {
      "code" : "004126",
      "display" : "Monastero di Vasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "126"
        }
      ]
    },
    {
      "code" : "004127",
      "display" : "Monasterolo Casotto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "127"
        }
      ]
    },
    {
      "code" : "004128",
      "display" : "Monasterolo di Savigliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "128"
        }
      ]
    },
    {
      "code" : "004129",
      "display" : "Monchiero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "129"
        }
      ]
    },
    {
      "code" : "004130",
      "display" : "Mondovì",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "130"
        }
      ]
    },
    {
      "code" : "004131",
      "display" : "Monesiglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "131"
        }
      ]
    },
    {
      "code" : "004132",
      "display" : "Monforte d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "132"
        }
      ]
    },
    {
      "code" : "004133",
      "display" : "Montà",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "133"
        }
      ]
    },
    {
      "code" : "004134",
      "display" : "Montaldo di Mondovì",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "134"
        }
      ]
    },
    {
      "code" : "004135",
      "display" : "Montaldo Roero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "135"
        }
      ]
    },
    {
      "code" : "004136",
      "display" : "Montanera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "136"
        }
      ]
    },
    {
      "code" : "004137",
      "display" : "Montelupo Albese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "137"
        }
      ]
    },
    {
      "code" : "004138",
      "display" : "Montemale di Cuneo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "138"
        }
      ]
    },
    {
      "code" : "004139",
      "display" : "Monterosso Grana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "139"
        }
      ]
    },
    {
      "code" : "004140",
      "display" : "Monteu Roero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "140"
        }
      ]
    },
    {
      "code" : "004141",
      "display" : "Montezemolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "141"
        }
      ]
    },
    {
      "code" : "004142",
      "display" : "Monticello d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "142"
        }
      ]
    },
    {
      "code" : "004143",
      "display" : "Moretta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "143"
        }
      ]
    },
    {
      "code" : "004144",
      "display" : "Morozzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "144"
        }
      ]
    },
    {
      "code" : "004145",
      "display" : "Murazzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "145"
        }
      ]
    },
    {
      "code" : "004146",
      "display" : "Murello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "146"
        }
      ]
    },
    {
      "code" : "004147",
      "display" : "Narzole",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "147"
        }
      ]
    },
    {
      "code" : "004148",
      "display" : "Neive",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "148"
        }
      ]
    },
    {
      "code" : "004149",
      "display" : "Neviglie",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "149"
        }
      ]
    },
    {
      "code" : "004150",
      "display" : "Niella Belbo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "150"
        }
      ]
    },
    {
      "code" : "004151",
      "display" : "Niella Tanaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "151"
        }
      ]
    },
    {
      "code" : "004152",
      "display" : "Novello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "152"
        }
      ]
    },
    {
      "code" : "004153",
      "display" : "Nucetto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "153"
        }
      ]
    },
    {
      "code" : "004154",
      "display" : "Oncino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "154"
        }
      ]
    },
    {
      "code" : "004155",
      "display" : "Ormea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "155"
        }
      ]
    },
    {
      "code" : "004156",
      "display" : "Ostana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "156"
        }
      ]
    },
    {
      "code" : "004157",
      "display" : "Paesana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "157"
        }
      ]
    },
    {
      "code" : "004158",
      "display" : "Pagno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "158"
        }
      ]
    },
    {
      "code" : "004159",
      "display" : "Pamparato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "159"
        }
      ]
    },
    {
      "code" : "004160",
      "display" : "Paroldo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "160"
        }
      ]
    },
    {
      "code" : "004161",
      "display" : "Perletto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "161"
        }
      ]
    },
    {
      "code" : "004162",
      "display" : "Perlo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "162"
        }
      ]
    },
    {
      "code" : "004163",
      "display" : "Peveragno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "163"
        }
      ]
    },
    {
      "code" : "004164",
      "display" : "Pezzolo Valle Uzzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "164"
        }
      ]
    },
    {
      "code" : "004165",
      "display" : "Pianfei",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "165"
        }
      ]
    },
    {
      "code" : "004166",
      "display" : "Piasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "166"
        }
      ]
    },
    {
      "code" : "004167",
      "display" : "Pietraporzio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "167"
        }
      ]
    },
    {
      "code" : "004168",
      "display" : "Piobesi d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "168"
        }
      ]
    },
    {
      "code" : "004169",
      "display" : "Piozzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "169"
        }
      ]
    },
    {
      "code" : "004170",
      "display" : "Pocapaglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "170"
        }
      ]
    },
    {
      "code" : "004171",
      "display" : "Polonghera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "171"
        }
      ]
    },
    {
      "code" : "004172",
      "display" : "Pontechianale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "172"
        }
      ]
    },
    {
      "code" : "004173",
      "display" : "Pradleves",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "173"
        }
      ]
    },
    {
      "code" : "004174",
      "display" : "Prazzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "174"
        }
      ]
    },
    {
      "code" : "004175",
      "display" : "Priero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "175"
        }
      ]
    },
    {
      "code" : "004176",
      "display" : "Priocca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "176"
        }
      ]
    },
    {
      "code" : "004177",
      "display" : "Priola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "177"
        }
      ]
    },
    {
      "code" : "004178",
      "display" : "Prunetto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "178"
        }
      ]
    },
    {
      "code" : "004179",
      "display" : "Racconigi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "179"
        }
      ]
    },
    {
      "code" : "004180",
      "display" : "Revello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "180"
        }
      ]
    },
    {
      "code" : "004181",
      "display" : "Rifreddo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "181"
        }
      ]
    },
    {
      "code" : "004182",
      "display" : "Rittana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "182"
        }
      ]
    },
    {
      "code" : "004183",
      "display" : "Roaschia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "183"
        }
      ]
    },
    {
      "code" : "004184",
      "display" : "Roascio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "184"
        }
      ]
    },
    {
      "code" : "004185",
      "display" : "Robilante",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "185"
        }
      ]
    },
    {
      "code" : "004186",
      "display" : "Roburent",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "186"
        }
      ]
    },
    {
      "code" : "004187",
      "display" : "Roccabruna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "187"
        }
      ]
    },
    {
      "code" : "004188",
      "display" : "Rocca Cigliè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "188"
        }
      ]
    },
    {
      "code" : "004189",
      "display" : "Rocca de' Baldi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "189"
        }
      ]
    },
    {
      "code" : "004190",
      "display" : "Roccaforte Mondovì",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "190"
        }
      ]
    },
    {
      "code" : "004191",
      "display" : "Roccasparvera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "191"
        }
      ]
    },
    {
      "code" : "004192",
      "display" : "Roccavione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "192"
        }
      ]
    },
    {
      "code" : "004193",
      "display" : "Rocchetta Belbo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "193"
        }
      ]
    },
    {
      "code" : "004194",
      "display" : "Roddi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "194"
        }
      ]
    },
    {
      "code" : "004195",
      "display" : "Roddino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "195"
        }
      ]
    },
    {
      "code" : "004196",
      "display" : "Rodello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "196"
        }
      ]
    },
    {
      "code" : "004197",
      "display" : "Rossana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "197"
        }
      ]
    },
    {
      "code" : "004198",
      "display" : "Ruffia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "198"
        }
      ]
    },
    {
      "code" : "004199",
      "display" : "Sale delle Langhe",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "199"
        }
      ]
    },
    {
      "code" : "004200",
      "display" : "Sale San Giovanni",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "200"
        }
      ]
    },
    {
      "code" : "004201",
      "display" : "Saliceto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "201"
        }
      ]
    },
    {
      "code" : "004202",
      "display" : "Salmour",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "202"
        }
      ]
    },
    {
      "code" : "004203",
      "display" : "Saluzzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "203"
        }
      ]
    },
    {
      "code" : "004204",
      "display" : "Sambuco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "204"
        }
      ]
    },
    {
      "code" : "004205",
      "display" : "Sampeyre",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "205"
        }
      ]
    },
    {
      "code" : "004206",
      "display" : "San Benedetto Belbo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "206"
        }
      ]
    },
    {
      "code" : "004207",
      "display" : "San Damiano Macra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "207"
        }
      ]
    },
    {
      "code" : "004208",
      "display" : "Sanfrè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "208"
        }
      ]
    },
    {
      "code" : "004209",
      "display" : "Sanfront",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "209"
        }
      ]
    },
    {
      "code" : "004210",
      "display" : "San Michele Mondovì",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "210"
        }
      ]
    },
    {
      "code" : "004211",
      "display" : "Sant'Albano Stura",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "211"
        }
      ]
    },
    {
      "code" : "004212",
      "display" : "Santa Vittoria d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "212"
        }
      ]
    },
    {
      "code" : "004213",
      "display" : "Santo Stefano Belbo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "213"
        }
      ]
    },
    {
      "code" : "004214",
      "display" : "Santo Stefano Roero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "214"
        }
      ]
    },
    {
      "code" : "004215",
      "display" : "Savigliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "215"
        }
      ]
    },
    {
      "code" : "004216",
      "display" : "Scagnello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "216"
        }
      ]
    },
    {
      "code" : "004217",
      "display" : "Scarnafigi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "217"
        }
      ]
    },
    {
      "code" : "004218",
      "display" : "Serralunga d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "218"
        }
      ]
    },
    {
      "code" : "004219",
      "display" : "Serravalle Langhe",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "219"
        }
      ]
    },
    {
      "code" : "004220",
      "display" : "Sinio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "220"
        }
      ]
    },
    {
      "code" : "004221",
      "display" : "Somano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "221"
        }
      ]
    },
    {
      "code" : "004222",
      "display" : "Sommariva del Bosco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "222"
        }
      ]
    },
    {
      "code" : "004223",
      "display" : "Sommariva Perno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "223"
        }
      ]
    },
    {
      "code" : "004224",
      "display" : "Stroppo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "224"
        }
      ]
    },
    {
      "code" : "004225",
      "display" : "Tarantasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "225"
        }
      ]
    },
    {
      "code" : "004226",
      "display" : "Torre Bormida",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "226"
        }
      ]
    },
    {
      "code" : "004227",
      "display" : "Torre Mondovì",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "227"
        }
      ]
    },
    {
      "code" : "004228",
      "display" : "Torre San Giorgio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "228"
        }
      ]
    },
    {
      "code" : "004229",
      "display" : "Torresina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "229"
        }
      ]
    },
    {
      "code" : "004230",
      "display" : "Treiso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "230"
        }
      ]
    },
    {
      "code" : "004231",
      "display" : "Trezzo Tinella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "231"
        }
      ]
    },
    {
      "code" : "004232",
      "display" : "Trinità",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "232"
        }
      ]
    },
    {
      "code" : "004233",
      "display" : "Valdieri",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "233"
        }
      ]
    },
    {
      "code" : "004234",
      "display" : "Valgrana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "234"
        }
      ]
    },
    {
      "code" : "004235",
      "display" : "Valloriate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "235"
        }
      ]
    },
    {
      "code" : "004237",
      "display" : "Venasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "237"
        }
      ]
    },
    {
      "code" : "004238",
      "display" : "Verduno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "238"
        }
      ]
    },
    {
      "code" : "004239",
      "display" : "Vernante",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "239"
        }
      ]
    },
    {
      "code" : "004240",
      "display" : "Verzuolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "240"
        }
      ]
    },
    {
      "code" : "004241",
      "display" : "Vezza d'Alba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "241"
        }
      ]
    },
    {
      "code" : "004242",
      "display" : "Vicoforte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "242"
        }
      ]
    },
    {
      "code" : "004243",
      "display" : "Vignolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "243"
        }
      ]
    },
    {
      "code" : "004244",
      "display" : "Villafalletto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "244"
        }
      ]
    },
    {
      "code" : "004245",
      "display" : "Villanova Mondovì",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "245"
        }
      ]
    },
    {
      "code" : "004246",
      "display" : "Villanova Solaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "246"
        }
      ]
    },
    {
      "code" : "004247",
      "display" : "Villar San Costanzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "247"
        }
      ]
    },
    {
      "code" : "004248",
      "display" : "Vinadio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "248"
        }
      ]
    },
    {
      "code" : "004249",
      "display" : "Viola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "249"
        }
      ]
    },
    {
      "code" : "004250",
      "display" : "Vottignasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "004"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "250"
        }
      ]
    },
    {
      "code" : "005001",
      "display" : "Agliano Terme",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "005002",
      "display" : "Albugnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "005003",
      "display" : "Antignano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "005004",
      "display" : "Aramengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "005005",
      "display" : "Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "005006",
      "display" : "Azzano d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "005007",
      "display" : "Baldichieri d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "005008",
      "display" : "Belveglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "005009",
      "display" : "Berzano di San Pietro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "005010",
      "display" : "Bruno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "005011",
      "display" : "Bubbio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "005012",
      "display" : "Buttigliera d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "005013",
      "display" : "Calamandrana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "005014",
      "display" : "Calliano Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "005015",
      "display" : "Calosso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "005016",
      "display" : "Camerano Casasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "005017",
      "display" : "Canelli",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "005018",
      "display" : "Cantarana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "005019",
      "display" : "Capriglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "005020",
      "display" : "Casorzo Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "005021",
      "display" : "Cassinasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "005022",
      "display" : "Castagnole delle Lanze",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "005023",
      "display" : "Castagnole Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "005024",
      "display" : "Castel Boglione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "005025",
      "display" : "Castell'Alfero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "005026",
      "display" : "Castellero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "005027",
      "display" : "Castelletto Molina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "005028",
      "display" : "Castello di Annone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "005029",
      "display" : "Castelnuovo Belbo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "005030",
      "display" : "Castelnuovo Calcea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "005031",
      "display" : "Castelnuovo Don Bosco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "005032",
      "display" : "Castel Rocchero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "005033",
      "display" : "Cellarengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "005034",
      "display" : "Celle Enomondo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "005035",
      "display" : "Cerreto d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "005036",
      "display" : "Cerro Tanaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "005037",
      "display" : "Cessole",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "005038",
      "display" : "Chiusano d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "005039",
      "display" : "Cinaglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "005040",
      "display" : "Cisterna d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "005041",
      "display" : "Coazzolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "005042",
      "display" : "Cocconato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "005044",
      "display" : "Corsione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "005045",
      "display" : "Cortandone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "005046",
      "display" : "Cortanze",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "005047",
      "display" : "Cortazzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "005048",
      "display" : "Cortiglione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "005049",
      "display" : "Cossombrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "005050",
      "display" : "Costigliole d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "005051",
      "display" : "Cunico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "005052",
      "display" : "Dusino San Michele",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "005053",
      "display" : "Ferrere",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "005054",
      "display" : "Fontanile",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "005055",
      "display" : "Frinco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "005056",
      "display" : "Grana Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "005057",
      "display" : "Grazzano Badoglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "005058",
      "display" : "Incisa Scapaccino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "005059",
      "display" : "Isola d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "005060",
      "display" : "Loazzolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "005061",
      "display" : "Maranzana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "005062",
      "display" : "Maretto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "005063",
      "display" : "Moasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "005064",
      "display" : "Mombaldone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "005065",
      "display" : "Mombaruzzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "005066",
      "display" : "Mombercelli",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "005067",
      "display" : "Monale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "005068",
      "display" : "Monastero Bormida",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "005069",
      "display" : "Moncalvo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "005070",
      "display" : "Moncucco Torinese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "005071",
      "display" : "Mongardino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "005072",
      "display" : "Montabone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "005073",
      "display" : "Montafia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "005074",
      "display" : "Montaldo Scarampi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "005075",
      "display" : "Montechiaro d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "005076",
      "display" : "Montegrosso d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "005077",
      "display" : "Montemagno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "005080",
      "display" : "Nizza Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "080"
        }
      ]
    },
    {
      "code" : "005081",
      "display" : "Olmo Gentile",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "081"
        }
      ]
    },
    {
      "code" : "005082",
      "display" : "Passerano Marmorito",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "005083",
      "display" : "Penango",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "005084",
      "display" : "Piea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "084"
        }
      ]
    },
    {
      "code" : "005085",
      "display" : "Pino d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "005086",
      "display" : "Piovà Massaia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "086"
        }
      ]
    },
    {
      "code" : "005087",
      "display" : "Portacomaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "005088",
      "display" : "Quaranti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "005089",
      "display" : "Refrancore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "089"
        }
      ]
    },
    {
      "code" : "005090",
      "display" : "Revigliasco d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "005091",
      "display" : "Roatto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "005092",
      "display" : "Robella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "092"
        }
      ]
    },
    {
      "code" : "005093",
      "display" : "Rocca d'Arazzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "005094",
      "display" : "Roccaverano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "094"
        }
      ]
    },
    {
      "code" : "005095",
      "display" : "Rocchetta Palafea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "095"
        }
      ]
    },
    {
      "code" : "005096",
      "display" : "Rocchetta Tanaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "096"
        }
      ]
    },
    {
      "code" : "005097",
      "display" : "San Damiano d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "005098",
      "display" : "San Giorgio Scarampi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "098"
        }
      ]
    },
    {
      "code" : "005099",
      "display" : "San Martino Alfieri",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "099"
        }
      ]
    },
    {
      "code" : "005100",
      "display" : "San Marzano Oliveto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "100"
        }
      ]
    },
    {
      "code" : "005101",
      "display" : "San Paolo Solbrito",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "101"
        }
      ]
    },
    {
      "code" : "005103",
      "display" : "Scurzolengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "103"
        }
      ]
    },
    {
      "code" : "005104",
      "display" : "Serole",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "104"
        }
      ]
    },
    {
      "code" : "005105",
      "display" : "Sessame",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "105"
        }
      ]
    },
    {
      "code" : "005106",
      "display" : "Settime",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "106"
        }
      ]
    },
    {
      "code" : "005107",
      "display" : "Soglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "107"
        }
      ]
    },
    {
      "code" : "005108",
      "display" : "Tigliole",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "005109",
      "display" : "Tonco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "109"
        }
      ]
    },
    {
      "code" : "005111",
      "display" : "Vaglio Serra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "111"
        }
      ]
    },
    {
      "code" : "005112",
      "display" : "Valfenera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "112"
        }
      ]
    },
    {
      "code" : "005113",
      "display" : "Vesime",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "113"
        }
      ]
    },
    {
      "code" : "005114",
      "display" : "Viale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "114"
        }
      ]
    },
    {
      "code" : "005115",
      "display" : "Viarigi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "115"
        }
      ]
    },
    {
      "code" : "005116",
      "display" : "Vigliano d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "116"
        }
      ]
    },
    {
      "code" : "005117",
      "display" : "Villafranca d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "117"
        }
      ]
    },
    {
      "code" : "005118",
      "display" : "Villanova d'Asti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "118"
        }
      ]
    },
    {
      "code" : "005119",
      "display" : "Villa San Secondo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "119"
        }
      ]
    },
    {
      "code" : "005120",
      "display" : "Vinchio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "120"
        }
      ]
    },
    {
      "code" : "005121",
      "display" : "Montiglio Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "121"
        }
      ]
    },
    {
      "code" : "005122",
      "display" : "Moransengo-Tonengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "005"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "122"
        }
      ]
    },
    {
      "code" : "006001",
      "display" : "Acqui Terme",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "006002",
      "display" : "Albera Ligure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "006003",
      "display" : "Alessandria",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "006004",
      "display" : "Alfiano Natta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "006005",
      "display" : "Alice Bel Colle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "006007",
      "display" : "Altavilla Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "006008",
      "display" : "Alzano Scrivia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "006009",
      "display" : "Arquata Scrivia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "006010",
      "display" : "Avolasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "006011",
      "display" : "Balzola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "006012",
      "display" : "Basaluzzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "006013",
      "display" : "Bassignana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "006014",
      "display" : "Belforte Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "006015",
      "display" : "Bergamasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "006016",
      "display" : "Berzano di Tortona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "006017",
      "display" : "Bistagno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "006018",
      "display" : "Borghetto di Borbera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "006019",
      "display" : "Borgoratto Alessandrino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "006020",
      "display" : "Borgo San Martino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "006021",
      "display" : "Bosco Marengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "006022",
      "display" : "Bosio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "006023",
      "display" : "Bozzole",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "006024",
      "display" : "Brignano-Frascata",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "006025",
      "display" : "Cabella Ligure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "006026",
      "display" : "Camagna Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "006027",
      "display" : "Camino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "006028",
      "display" : "Cantalupo Ligure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "006029",
      "display" : "Capriata d'Orba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "006030",
      "display" : "Carbonara Scrivia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "006031",
      "display" : "Carentino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "006032",
      "display" : "Carezzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "006033",
      "display" : "Carpeneto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "006034",
      "display" : "Carrega Ligure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "006035",
      "display" : "Carrosio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "006036",
      "display" : "Cartosio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "006037",
      "display" : "Casal Cermelli",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "006038",
      "display" : "Casaleggio Boiro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "006039",
      "display" : "Casale Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "006040",
      "display" : "Casalnoceto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "006041",
      "display" : "Casasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "006043",
      "display" : "Cassine",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "006044",
      "display" : "Cassinelle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "006045",
      "display" : "Castellania Coppi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "006046",
      "display" : "Castellar Guidobono",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "006047",
      "display" : "Castellazzo Bormida",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "006048",
      "display" : "Castelletto d'Erro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "006049",
      "display" : "Castelletto d'Orba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "006050",
      "display" : "Castelletto Merli",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "006051",
      "display" : "Castelletto Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "006052",
      "display" : "Castelnuovo Bormida",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "006053",
      "display" : "Castelnuovo Scrivia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "006054",
      "display" : "Castelspina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "006055",
      "display" : "Cavatore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "006056",
      "display" : "Cella Monte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "006057",
      "display" : "Cereseto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "006058",
      "display" : "Cerreto Grue",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "006059",
      "display" : "Cerrina Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "006060",
      "display" : "Coniolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "006061",
      "display" : "Conzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "006062",
      "display" : "Costa Vescovato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "006063",
      "display" : "Cremolino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "006065",
      "display" : "Denice",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "006066",
      "display" : "Dernice",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "006067",
      "display" : "Fabbrica Curone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "006068",
      "display" : "Felizzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "006069",
      "display" : "Fraconalto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "006070",
      "display" : "Francavilla Bisio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "006071",
      "display" : "Frascaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "006072",
      "display" : "Frassinello Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "006073",
      "display" : "Frassineto Po",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "006074",
      "display" : "Fresonara",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "006075",
      "display" : "Frugarolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "006076",
      "display" : "Fubine Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "006077",
      "display" : "Gabiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "006078",
      "display" : "Gamalero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "006079",
      "display" : "Garbagna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "006081",
      "display" : "Gavi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "081"
        }
      ]
    },
    {
      "code" : "006082",
      "display" : "Giarole",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "006083",
      "display" : "Gremiasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "006084",
      "display" : "Grognardo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "084"
        }
      ]
    },
    {
      "code" : "006085",
      "display" : "Grondona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "006086",
      "display" : "Guazzora",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "086"
        }
      ]
    },
    {
      "code" : "006087",
      "display" : "Isola Sant'Antonio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "006088",
      "display" : "Lerma",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "006090",
      "display" : "Malvicino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "006091",
      "display" : "Masio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "006092",
      "display" : "Melazzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "092"
        }
      ]
    },
    {
      "code" : "006093",
      "display" : "Merana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "006094",
      "display" : "Mirabello Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "094"
        }
      ]
    },
    {
      "code" : "006095",
      "display" : "Molare",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "095"
        }
      ]
    },
    {
      "code" : "006096",
      "display" : "Molino dei Torti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "096"
        }
      ]
    },
    {
      "code" : "006097",
      "display" : "Mombello Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "006098",
      "display" : "Momperone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "098"
        }
      ]
    },
    {
      "code" : "006099",
      "display" : "Moncestino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "099"
        }
      ]
    },
    {
      "code" : "006100",
      "display" : "Mongiardino Ligure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "100"
        }
      ]
    },
    {
      "code" : "006101",
      "display" : "Monleale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "101"
        }
      ]
    },
    {
      "code" : "006102",
      "display" : "Montacuto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "102"
        }
      ]
    },
    {
      "code" : "006103",
      "display" : "Montaldeo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "103"
        }
      ]
    },
    {
      "code" : "006104",
      "display" : "Montaldo Bormida",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "104"
        }
      ]
    },
    {
      "code" : "006105",
      "display" : "Montecastello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "105"
        }
      ]
    },
    {
      "code" : "006106",
      "display" : "Montechiaro d'Acqui",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "106"
        }
      ]
    },
    {
      "code" : "006107",
      "display" : "Montegioco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "107"
        }
      ]
    },
    {
      "code" : "006108",
      "display" : "Montemarzino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "006109",
      "display" : "Morano sul Po",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "109"
        }
      ]
    },
    {
      "code" : "006110",
      "display" : "Morbello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "110"
        }
      ]
    },
    {
      "code" : "006111",
      "display" : "Mornese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "111"
        }
      ]
    },
    {
      "code" : "006112",
      "display" : "Morsasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "112"
        }
      ]
    },
    {
      "code" : "006113",
      "display" : "Murisengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "113"
        }
      ]
    },
    {
      "code" : "006114",
      "display" : "Novi Ligure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "114"
        }
      ]
    },
    {
      "code" : "006115",
      "display" : "Occimiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "115"
        }
      ]
    },
    {
      "code" : "006116",
      "display" : "Odalengo Grande",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "116"
        }
      ]
    },
    {
      "code" : "006117",
      "display" : "Odalengo Piccolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "117"
        }
      ]
    },
    {
      "code" : "006118",
      "display" : "Olivola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "118"
        }
      ]
    },
    {
      "code" : "006119",
      "display" : "Orsara Bormida",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "119"
        }
      ]
    },
    {
      "code" : "006120",
      "display" : "Ottiglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "120"
        }
      ]
    },
    {
      "code" : "006121",
      "display" : "Ovada",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "121"
        }
      ]
    },
    {
      "code" : "006122",
      "display" : "Oviglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "122"
        }
      ]
    },
    {
      "code" : "006123",
      "display" : "Ozzano Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "123"
        }
      ]
    },
    {
      "code" : "006124",
      "display" : "Paderna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "124"
        }
      ]
    },
    {
      "code" : "006125",
      "display" : "Pareto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "125"
        }
      ]
    },
    {
      "code" : "006126",
      "display" : "Parodi Ligure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "126"
        }
      ]
    },
    {
      "code" : "006127",
      "display" : "Pasturana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "127"
        }
      ]
    },
    {
      "code" : "006128",
      "display" : "Pecetto di Valenza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "128"
        }
      ]
    },
    {
      "code" : "006129",
      "display" : "Pietra Marazzi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "129"
        }
      ]
    },
    {
      "code" : "006131",
      "display" : "Pomaro Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "131"
        }
      ]
    },
    {
      "code" : "006132",
      "display" : "Pontecurone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "132"
        }
      ]
    },
    {
      "code" : "006133",
      "display" : "Pontestura",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "133"
        }
      ]
    },
    {
      "code" : "006134",
      "display" : "Ponti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "134"
        }
      ]
    },
    {
      "code" : "006135",
      "display" : "Ponzano Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "135"
        }
      ]
    },
    {
      "code" : "006136",
      "display" : "Ponzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "136"
        }
      ]
    },
    {
      "code" : "006137",
      "display" : "Pozzol Groppo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "137"
        }
      ]
    },
    {
      "code" : "006138",
      "display" : "Pozzolo Formigaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "138"
        }
      ]
    },
    {
      "code" : "006139",
      "display" : "Prasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "139"
        }
      ]
    },
    {
      "code" : "006140",
      "display" : "Predosa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "140"
        }
      ]
    },
    {
      "code" : "006141",
      "display" : "Quargnento",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "141"
        }
      ]
    },
    {
      "code" : "006142",
      "display" : "Quattordio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "142"
        }
      ]
    },
    {
      "code" : "006143",
      "display" : "Ricaldone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "143"
        }
      ]
    },
    {
      "code" : "006144",
      "display" : "Rivalta Bormida",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "144"
        }
      ]
    },
    {
      "code" : "006145",
      "display" : "Rivarone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "145"
        }
      ]
    },
    {
      "code" : "006146",
      "display" : "Roccaforte Ligure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "146"
        }
      ]
    },
    {
      "code" : "006147",
      "display" : "Rocca Grimalda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "147"
        }
      ]
    },
    {
      "code" : "006148",
      "display" : "Rocchetta Ligure",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "148"
        }
      ]
    },
    {
      "code" : "006149",
      "display" : "Rosignano Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "149"
        }
      ]
    },
    {
      "code" : "006150",
      "display" : "Sala Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "150"
        }
      ]
    },
    {
      "code" : "006151",
      "display" : "Sale",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "151"
        }
      ]
    },
    {
      "code" : "006152",
      "display" : "San Cristoforo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "152"
        }
      ]
    },
    {
      "code" : "006153",
      "display" : "San Giorgio Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "153"
        }
      ]
    },
    {
      "code" : "006154",
      "display" : "San Salvatore Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "154"
        }
      ]
    },
    {
      "code" : "006155",
      "display" : "San Sebastiano Curone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "155"
        }
      ]
    },
    {
      "code" : "006156",
      "display" : "Sant'Agata Fossili",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "156"
        }
      ]
    },
    {
      "code" : "006157",
      "display" : "Sardigliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "157"
        }
      ]
    },
    {
      "code" : "006158",
      "display" : "Sarezzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "158"
        }
      ]
    },
    {
      "code" : "006159",
      "display" : "Serralunga di Crea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "159"
        }
      ]
    },
    {
      "code" : "006160",
      "display" : "Serravalle Scrivia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "160"
        }
      ]
    },
    {
      "code" : "006161",
      "display" : "Sezzadio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "161"
        }
      ]
    },
    {
      "code" : "006162",
      "display" : "Silvano d'Orba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "162"
        }
      ]
    },
    {
      "code" : "006163",
      "display" : "Solero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "163"
        }
      ]
    },
    {
      "code" : "006164",
      "display" : "Solonghello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "164"
        }
      ]
    },
    {
      "code" : "006165",
      "display" : "Spigno Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "165"
        }
      ]
    },
    {
      "code" : "006166",
      "display" : "Spineto Scrivia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "166"
        }
      ]
    },
    {
      "code" : "006167",
      "display" : "Stazzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "167"
        }
      ]
    },
    {
      "code" : "006168",
      "display" : "Strevi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "168"
        }
      ]
    },
    {
      "code" : "006169",
      "display" : "Tagliolo Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "169"
        }
      ]
    },
    {
      "code" : "006170",
      "display" : "Tassarolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "170"
        }
      ]
    },
    {
      "code" : "006171",
      "display" : "Terruggia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "171"
        }
      ]
    },
    {
      "code" : "006172",
      "display" : "Terzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "172"
        }
      ]
    },
    {
      "code" : "006173",
      "display" : "Ticineto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "173"
        }
      ]
    },
    {
      "code" : "006174",
      "display" : "Tortona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "174"
        }
      ]
    },
    {
      "code" : "006175",
      "display" : "Treville",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "175"
        }
      ]
    },
    {
      "code" : "006176",
      "display" : "Trisobbio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "176"
        }
      ]
    },
    {
      "code" : "006177",
      "display" : "Valenza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "177"
        }
      ]
    },
    {
      "code" : "006178",
      "display" : "Valmacca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "178"
        }
      ]
    },
    {
      "code" : "006179",
      "display" : "Vignale Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "179"
        }
      ]
    },
    {
      "code" : "006180",
      "display" : "Vignole Borbera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "180"
        }
      ]
    },
    {
      "code" : "006181",
      "display" : "Viguzzolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "181"
        }
      ]
    },
    {
      "code" : "006182",
      "display" : "Villadeati",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "182"
        }
      ]
    },
    {
      "code" : "006183",
      "display" : "Villalvernia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "183"
        }
      ]
    },
    {
      "code" : "006184",
      "display" : "Villamiroglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "184"
        }
      ]
    },
    {
      "code" : "006185",
      "display" : "Villanova Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "185"
        }
      ]
    },
    {
      "code" : "006186",
      "display" : "Villaromagnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "186"
        }
      ]
    },
    {
      "code" : "006187",
      "display" : "Visone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "187"
        }
      ]
    },
    {
      "code" : "006188",
      "display" : "Volpedo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "188"
        }
      ]
    },
    {
      "code" : "006189",
      "display" : "Volpeglino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "189"
        }
      ]
    },
    {
      "code" : "006190",
      "display" : "Voltaggio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "190"
        }
      ]
    },
    {
      "code" : "006191",
      "display" : "Cassano Spinola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "191"
        }
      ]
    },
    {
      "code" : "006192",
      "display" : "Alluvioni Piovera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "192"
        }
      ]
    },
    {
      "code" : "006193",
      "display" : "Lu e Cuccaro Monferrato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "006"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "193"
        }
      ]
    },
    {
      "code" : "096001",
      "display" : "Ailoche",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "096002",
      "display" : "Andorno Micca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "096003",
      "display" : "Benna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "096004",
      "display" : "Biella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "096005",
      "display" : "Bioglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "096006",
      "display" : "Borriana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "096007",
      "display" : "Brusnengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "096008",
      "display" : "Callabiana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "096009",
      "display" : "Camandona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "096010",
      "display" : "Camburzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "096012",
      "display" : "Candelo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "096013",
      "display" : "Caprile",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "096014",
      "display" : "Casapinta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "096015",
      "display" : "Castelletto Cervo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "096016",
      "display" : "Cavaglià",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "096018",
      "display" : "Cerrione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "096019",
      "display" : "Coggiola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "096020",
      "display" : "Cossato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "096021",
      "display" : "Crevacuore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "096023",
      "display" : "Curino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "096024",
      "display" : "Donato",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "096025",
      "display" : "Dorzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "096026",
      "display" : "Gaglianico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "096027",
      "display" : "Gifflenga",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "096028",
      "display" : "Graglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "096030",
      "display" : "Magnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "096031",
      "display" : "Massazza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "096032",
      "display" : "Masserano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "096033",
      "display" : "Mezzana Mortigliengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "096034",
      "display" : "Miagliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "096035",
      "display" : "Mongrando",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "096037",
      "display" : "Mottalciata",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "096038",
      "display" : "Muzzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "096039",
      "display" : "Netro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "096040",
      "display" : "Occhieppo Inferiore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "096041",
      "display" : "Occhieppo Superiore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "096042",
      "display" : "Pettinengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "096043",
      "display" : "Piatto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "096044",
      "display" : "Piedicavallo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "096046",
      "display" : "Pollone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "096047",
      "display" : "Ponderano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "096048",
      "display" : "Portula",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "096049",
      "display" : "Pralungo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "096050",
      "display" : "Pray",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "096053",
      "display" : "Ronco Biellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "096054",
      "display" : "Roppolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "096055",
      "display" : "Rosazza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "096056",
      "display" : "Sagliano Micca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "096057",
      "display" : "Sala Biellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "096058",
      "display" : "Salussola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "096059",
      "display" : "Sandigliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "096063",
      "display" : "Sordevolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "096064",
      "display" : "Sostegno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "096065",
      "display" : "Strona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "096066",
      "display" : "Tavigliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "096067",
      "display" : "Ternengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "096068",
      "display" : "Tollegno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "096069",
      "display" : "Torrazzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "096071",
      "display" : "Valdengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "096072",
      "display" : "Vallanzengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "096074",
      "display" : "Valle San Nicolao",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "096075",
      "display" : "Veglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "096076",
      "display" : "Verrone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "096077",
      "display" : "Vigliano Biellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "096078",
      "display" : "Villa del Bosco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "096079",
      "display" : "Villanova Biellese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "096080",
      "display" : "Viverone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "080"
        }
      ]
    },
    {
      "code" : "096081",
      "display" : "Zimone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "081"
        }
      ]
    },
    {
      "code" : "096082",
      "display" : "Zubiena",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "096083",
      "display" : "Zumaglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "096085",
      "display" : "Lessona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "096086",
      "display" : "Campiglia Cervo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "086"
        }
      ]
    },
    {
      "code" : "096087",
      "display" : "Quaregna Cerreto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "096088",
      "display" : "Valdilana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "096"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "103001",
      "display" : "Antrona Schieranco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "103002",
      "display" : "Anzola d'Ossola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "103003",
      "display" : "Arizzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "103004",
      "display" : "Arola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "103005",
      "display" : "Aurano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "103006",
      "display" : "Baceno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "103007",
      "display" : "Bannio Anzino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "103008",
      "display" : "Baveno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "103009",
      "display" : "Bee",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "103010",
      "display" : "Belgirate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "103011",
      "display" : "Beura-Cardezza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "103012",
      "display" : "Bognanco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "103013",
      "display" : "Brovello-Carpugnino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "103014",
      "display" : "Calasca-Castiglione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "103015",
      "display" : "Cambiasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "103016",
      "display" : "Cannero Riviera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "103017",
      "display" : "Cannobio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "103018",
      "display" : "Caprezzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "103019",
      "display" : "Casale Corte Cerro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "103021",
      "display" : "Ceppo Morelli",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "103022",
      "display" : "Cesara",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "103023",
      "display" : "Cossogno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "103024",
      "display" : "Craveggia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "103025",
      "display" : "Crevoladossola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "103026",
      "display" : "Crodo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "103028",
      "display" : "Domodossola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "103029",
      "display" : "Druogno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "103031",
      "display" : "Formazza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "103032",
      "display" : "Germagno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "103033",
      "display" : "Ghiffa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "103034",
      "display" : "Gignese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "103035",
      "display" : "Gravellona Toce",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "103036",
      "display" : "Gurro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "103037",
      "display" : "Intragna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "103038",
      "display" : "Loreglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "103039",
      "display" : "Macugnaga",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "103040",
      "display" : "Madonna del Sasso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "103041",
      "display" : "Malesco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "103042",
      "display" : "Masera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "103043",
      "display" : "Massiola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "103044",
      "display" : "Mergozzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "103045",
      "display" : "Miazzina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "103046",
      "display" : "Montecrestese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "103047",
      "display" : "Montescheno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "103048",
      "display" : "Nonio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "103049",
      "display" : "Oggebbio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "103050",
      "display" : "Omegna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "103051",
      "display" : "Ornavasso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "103052",
      "display" : "Pallanzeno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "103053",
      "display" : "Piedimulera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "103054",
      "display" : "Pieve Vergonte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "103055",
      "display" : "Premeno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "103056",
      "display" : "Premia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "103057",
      "display" : "Premosello-Chiovenda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "103058",
      "display" : "Quarna Sopra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "103059",
      "display" : "Quarna Sotto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "103060",
      "display" : "Re",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "103061",
      "display" : "San Bernardino Verbano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "103062",
      "display" : "Santa Maria Maggiore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "103064",
      "display" : "Stresa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "103065",
      "display" : "Toceno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "103066",
      "display" : "Trarego Viggiona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "103067",
      "display" : "Trasquera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "103068",
      "display" : "Trontano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "103069",
      "display" : "Valstrona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "103070",
      "display" : "Vanzone con San Carlo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "103071",
      "display" : "Varzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "103072",
      "display" : "Verbania",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "103074",
      "display" : "Vignone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "103075",
      "display" : "Villadossola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "103076",
      "display" : "Villette",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "103077",
      "display" : "Vogogna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "103078",
      "display" : "Borgomezzavalle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "103079",
      "display" : "Valle Cannobina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "010"
        },
        {
          "code" : "provincia",
          "valueCode" : "103"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "007001",
      "display" : "Allein",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "007002",
      "display" : "Antey-Saint-André",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "007003",
      "display" : "Aosta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "007004",
      "display" : "Arnad",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "007005",
      "display" : "Arvier",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "007006",
      "display" : "Avise",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "007007",
      "display" : "Ayas",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "007008",
      "display" : "Aymavilles",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "007009",
      "display" : "Bard",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "007010",
      "display" : "Bionaz",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "007011",
      "display" : "Brissogne",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "007012",
      "display" : "Brusson",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "007013",
      "display" : "Challand-Saint-Anselme",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "007014",
      "display" : "Challand-Saint-Victor",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "007015",
      "display" : "Chambave",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "007016",
      "display" : "Chamois",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "007017",
      "display" : "Champdepraz",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "007018",
      "display" : "Champorcher",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "007019",
      "display" : "Charvensod",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "007020",
      "display" : "Châtillon",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "007021",
      "display" : "Cogne",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "007022",
      "display" : "Courmayeur",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "007023",
      "display" : "Donnas",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "007024",
      "display" : "Doues",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "007025",
      "display" : "Emarèse",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "007026",
      "display" : "Etroubles",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "007027",
      "display" : "Fénis",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "007028",
      "display" : "Fontainemore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "007029",
      "display" : "Gaby",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "007030",
      "display" : "Gignod",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "007031",
      "display" : "Gressan",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "007032",
      "display" : "Gressoney-La-Trinité",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "007033",
      "display" : "Gressoney-Saint-Jean",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "007034",
      "display" : "Hône",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "007035",
      "display" : "Introd",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "007036",
      "display" : "Issime",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "007037",
      "display" : "Issogne",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "007038",
      "display" : "Jovençan",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "007039",
      "display" : "La Magdeleine",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "007040",
      "display" : "La Salle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "007041",
      "display" : "La Thuile",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "007042",
      "display" : "Lillianes",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "007043",
      "display" : "Montjovet",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "007044",
      "display" : "Morgex",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "007045",
      "display" : "Nus",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "007046",
      "display" : "Ollomont",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "007047",
      "display" : "Oyace",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "007048",
      "display" : "Perloz",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "007049",
      "display" : "Pollein",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "007050",
      "display" : "Pontboset",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "007051",
      "display" : "Pontey",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "007052",
      "display" : "Pont-Saint-Martin",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "007053",
      "display" : "Pré-Saint-Didier",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "007054",
      "display" : "Quart",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "007055",
      "display" : "Rhêmes-Notre-Dame",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "007056",
      "display" : "Rhêmes-Saint-Georges",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "007057",
      "display" : "Roisan",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "007058",
      "display" : "Saint-Christophe",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "007059",
      "display" : "Saint-Denis",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "007060",
      "display" : "Saint-Marcel",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "007061",
      "display" : "Saint-Nicolas",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "007062",
      "display" : "Saint-Oyen",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "007063",
      "display" : "Saint-Pierre",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "007064",
      "display" : "Saint-Rhémy-en-Bosses",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "007065",
      "display" : "Saint-Vincent",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "007066",
      "display" : "Sarre",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "007067",
      "display" : "Torgnon",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "007068",
      "display" : "Valgrisenche",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "007069",
      "display" : "Valpelline",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "007070",
      "display" : "Valsavarenche",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "007071",
      "display" : "Valtournenche",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "007072",
      "display" : "Verrayes",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "007073",
      "display" : "Verrès",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "007074",
      "display" : "Villeneuve",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "020"
        },
        {
          "code" : "provincia",
          "valueCode" : "007"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "012001",
      "display" : "Agra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "012002",
      "display" : "Albizzate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "012003",
      "display" : "Angera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "012004",
      "display" : "Arcisate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "012005",
      "display" : "Arsago Seprio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "012006",
      "display" : "Azzate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "012007",
      "display" : "Azzio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "012008",
      "display" : "Barasso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "012010",
      "display" : "Bedero Valcuvia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "012011",
      "display" : "Besano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "012012",
      "display" : "Besnate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "012013",
      "display" : "Besozzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "012014",
      "display" : "Biandronno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "012015",
      "display" : "Bisuschio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "012016",
      "display" : "Bodio Lomnago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "012017",
      "display" : "Brebbia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "012019",
      "display" : "Brenta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "012020",
      "display" : "Brezzo di Bedero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "012021",
      "display" : "Brinzio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "012022",
      "display" : "Brissago-Valtravaglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "012023",
      "display" : "Brunello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "012024",
      "display" : "Brusimpiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "012025",
      "display" : "Buguggiate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "012026",
      "display" : "Busto Arsizio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "012027",
      "display" : "Cadegliano-Viconago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "012029",
      "display" : "Cairate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "012030",
      "display" : "Cantello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "012031",
      "display" : "Caravate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "012032",
      "display" : "Cardano al Campo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "012033",
      "display" : "Carnago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "012034",
      "display" : "Caronno Pertusella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "012035",
      "display" : "Caronno Varesino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "012036",
      "display" : "Casale Litta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "012037",
      "display" : "Casalzuigno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "012038",
      "display" : "Casciago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "012039",
      "display" : "Casorate Sempione",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "012040",
      "display" : "Cassano Magnago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "012041",
      "display" : "Cassano Valcuvia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "012042",
      "display" : "Castellanza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "012043",
      "display" : "Castello Cabiaglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "012044",
      "display" : "Castelseprio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "012045",
      "display" : "Castelveccana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "012046",
      "display" : "Castiglione Olona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "012047",
      "display" : "Castronno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "012048",
      "display" : "Cavaria con Premezzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "012049",
      "display" : "Cazzago Brabbia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "012050",
      "display" : "Cislago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "012051",
      "display" : "Cittiglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "012052",
      "display" : "Clivio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "012053",
      "display" : "Cocquio-Trevisago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "012054",
      "display" : "Comabbio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "012055",
      "display" : "Comerio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "012056",
      "display" : "Cremenaga",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "012057",
      "display" : "Crosio della Valle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "012058",
      "display" : "Cuasso al Monte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "012059",
      "display" : "Cugliate-Fabiasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "012060",
      "display" : "Cunardo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "012061",
      "display" : "Curiglia con Monteviasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "012062",
      "display" : "Cuveglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "012063",
      "display" : "Cuvio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "012064",
      "display" : "Daverio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "012065",
      "display" : "Dumenza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "012066",
      "display" : "Duno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "012067",
      "display" : "Fagnano Olona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "012068",
      "display" : "Ferno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "012069",
      "display" : "Ferrera di Varese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "012070",
      "display" : "Gallarate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "012071",
      "display" : "Galliate Lombardo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "012072",
      "display" : "Gavirate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "012073",
      "display" : "Gazzada Schianno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "012074",
      "display" : "Gemonio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "012075",
      "display" : "Gerenzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "012076",
      "display" : "Germignaga",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "012077",
      "display" : "Golasecca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "012078",
      "display" : "Gorla Maggiore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "012079",
      "display" : "Gorla Minore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "012080",
      "display" : "Gornate Olona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "080"
        }
      ]
    },
    {
      "code" : "012081",
      "display" : "Grantola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "081"
        }
      ]
    },
    {
      "code" : "012082",
      "display" : "Inarzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "012083",
      "display" : "Induno Olona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "012084",
      "display" : "Ispra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "084"
        }
      ]
    },
    {
      "code" : "012085",
      "display" : "Jerago con Orago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "012086",
      "display" : "Lavena Ponte Tresa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "086"
        }
      ]
    },
    {
      "code" : "012087",
      "display" : "Laveno-Mombello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "012088",
      "display" : "Leggiuno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "012089",
      "display" : "Lonate Ceppino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "089"
        }
      ]
    },
    {
      "code" : "012090",
      "display" : "Lonate Pozzolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "012091",
      "display" : "Lozza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "012092",
      "display" : "Luino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "092"
        }
      ]
    },
    {
      "code" : "012093",
      "display" : "Luvinate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "012096",
      "display" : "Malnate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "096"
        }
      ]
    },
    {
      "code" : "012097",
      "display" : "Marchirolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "012098",
      "display" : "Marnate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "098"
        }
      ]
    },
    {
      "code" : "012099",
      "display" : "Marzio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "099"
        }
      ]
    },
    {
      "code" : "012100",
      "display" : "Masciago Primo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "100"
        }
      ]
    },
    {
      "code" : "012101",
      "display" : "Mercallo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "101"
        }
      ]
    },
    {
      "code" : "012102",
      "display" : "Mesenzana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "102"
        }
      ]
    },
    {
      "code" : "012103",
      "display" : "Montegrino Valtravaglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "103"
        }
      ]
    },
    {
      "code" : "012104",
      "display" : "Monvalle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "104"
        }
      ]
    },
    {
      "code" : "012105",
      "display" : "Morazzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "105"
        }
      ]
    },
    {
      "code" : "012106",
      "display" : "Mornago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "106"
        }
      ]
    },
    {
      "code" : "012107",
      "display" : "Oggiona con Santo Stefano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "107"
        }
      ]
    },
    {
      "code" : "012108",
      "display" : "Olgiate Olona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "012109",
      "display" : "Origgio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "109"
        }
      ]
    },
    {
      "code" : "012110",
      "display" : "Orino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "110"
        }
      ]
    },
    {
      "code" : "012113",
      "display" : "Porto Ceresio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "113"
        }
      ]
    },
    {
      "code" : "012114",
      "display" : "Porto Valtravaglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "114"
        }
      ]
    },
    {
      "code" : "012115",
      "display" : "Rancio Valcuvia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "115"
        }
      ]
    },
    {
      "code" : "012116",
      "display" : "Ranco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "116"
        }
      ]
    },
    {
      "code" : "012117",
      "display" : "Saltrio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "117"
        }
      ]
    },
    {
      "code" : "012118",
      "display" : "Samarate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "118"
        }
      ]
    },
    {
      "code" : "012119",
      "display" : "Saronno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "119"
        }
      ]
    },
    {
      "code" : "012120",
      "display" : "Sesto Calende",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "120"
        }
      ]
    },
    {
      "code" : "012121",
      "display" : "Solbiate Arno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "121"
        }
      ]
    },
    {
      "code" : "012122",
      "display" : "Solbiate Olona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "122"
        }
      ]
    },
    {
      "code" : "012123",
      "display" : "Somma Lombardo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "123"
        }
      ]
    },
    {
      "code" : "012124",
      "display" : "Sumirago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "124"
        }
      ]
    },
    {
      "code" : "012125",
      "display" : "Taino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "125"
        }
      ]
    },
    {
      "code" : "012126",
      "display" : "Ternate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "126"
        }
      ]
    },
    {
      "code" : "012127",
      "display" : "Tradate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "127"
        }
      ]
    },
    {
      "code" : "012128",
      "display" : "Travedona-Monate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "128"
        }
      ]
    },
    {
      "code" : "012129",
      "display" : "Tronzano Lago Maggiore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "129"
        }
      ]
    },
    {
      "code" : "012130",
      "display" : "Uboldo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "130"
        }
      ]
    },
    {
      "code" : "012131",
      "display" : "Valganna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "131"
        }
      ]
    },
    {
      "code" : "012132",
      "display" : "Varano Borghi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "132"
        }
      ]
    },
    {
      "code" : "012133",
      "display" : "Varese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "133"
        }
      ]
    },
    {
      "code" : "012134",
      "display" : "Vedano Olona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "134"
        }
      ]
    },
    {
      "code" : "012136",
      "display" : "Venegono Inferiore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "136"
        }
      ]
    },
    {
      "code" : "012137",
      "display" : "Venegono Superiore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "137"
        }
      ]
    },
    {
      "code" : "012138",
      "display" : "Vergiate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "138"
        }
      ]
    },
    {
      "code" : "012139",
      "display" : "Viggiù",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "139"
        }
      ]
    },
    {
      "code" : "012140",
      "display" : "Vizzola Ticino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "140"
        }
      ]
    },
    {
      "code" : "012141",
      "display" : "Sangiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "141"
        }
      ]
    },
    {
      "code" : "012142",
      "display" : "Maccagno con Pino e Veddasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "142"
        }
      ]
    },
    {
      "code" : "012143",
      "display" : "Cadrezzate con Osmate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "143"
        }
      ]
    },
    {
      "code" : "012144",
      "display" : "Bardello con Malgesso e Bregano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "012"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "144"
        }
      ]
    },
    {
      "code" : "013003",
      "display" : "Albavilla",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "013004",
      "display" : "Albese con Cassano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "013005",
      "display" : "Albiolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "013006",
      "display" : "Alserio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "013007",
      "display" : "Alzate Brianza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "013009",
      "display" : "Anzano del Parco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "013010",
      "display" : "Appiano Gentile",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "013011",
      "display" : "Argegno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "013012",
      "display" : "Arosio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "013013",
      "display" : "Asso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "013015",
      "display" : "Barni",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "013021",
      "display" : "Bene Lario",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "013022",
      "display" : "Beregazzo con Figliaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "013023",
      "display" : "Binago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "013024",
      "display" : "Bizzarone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "013025",
      "display" : "Blessagno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "013026",
      "display" : "Blevio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "013028",
      "display" : "Bregnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "013029",
      "display" : "Brenna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "013030",
      "display" : "Brienno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "013032",
      "display" : "Brunate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "013034",
      "display" : "Bulgarograsso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "013035",
      "display" : "Cabiate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "013036",
      "display" : "Cadorago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "013037",
      "display" : "Caglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "013040",
      "display" : "Campione d'Italia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "013041",
      "display" : "Cantù",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "013042",
      "display" : "Canzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "013043",
      "display" : "Capiago Intimiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "013044",
      "display" : "Carate Urio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "013045",
      "display" : "Carbonate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "013046",
      "display" : "Carimate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "013047",
      "display" : "Carlazzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "013048",
      "display" : "Carugo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "013052",
      "display" : "Caslino d'Erba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "013053",
      "display" : "Casnate con Bernate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "013055",
      "display" : "Cassina Rizzardi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "013058",
      "display" : "Castelmarte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "013059",
      "display" : "Castelnuovo Bozzente",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "013062",
      "display" : "Cavargna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "013063",
      "display" : "Cerano d'Intelvi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "013064",
      "display" : "Cermenate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "013065",
      "display" : "Cernobbio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "013068",
      "display" : "Cirimido",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "013071",
      "display" : "Claino con Osteno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "013074",
      "display" : "Colonno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "013075",
      "display" : "Como",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "013077",
      "display" : "Corrido",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "013083",
      "display" : "Cremia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "013084",
      "display" : "Cucciago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "084"
        }
      ]
    },
    {
      "code" : "013085",
      "display" : "Cusino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "013087",
      "display" : "Dizzasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "013089",
      "display" : "Domaso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "089"
        }
      ]
    },
    {
      "code" : "013090",
      "display" : "Dongo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "013092",
      "display" : "Dosso del Liro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "092"
        }
      ]
    },
    {
      "code" : "013095",
      "display" : "Erba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "095"
        }
      ]
    },
    {
      "code" : "013097",
      "display" : "Eupilio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "013098",
      "display" : "Faggeto Lario",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "098"
        }
      ]
    },
    {
      "code" : "013099",
      "display" : "Faloppio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "099"
        }
      ]
    },
    {
      "code" : "013100",
      "display" : "Fenegrò",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "100"
        }
      ]
    },
    {
      "code" : "013101",
      "display" : "Figino Serenza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "101"
        }
      ]
    },
    {
      "code" : "013102",
      "display" : "Fino Mornasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "102"
        }
      ]
    },
    {
      "code" : "013106",
      "display" : "Garzeno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "106"
        }
      ]
    },
    {
      "code" : "013107",
      "display" : "Gera Lario",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "107"
        }
      ]
    },
    {
      "code" : "013110",
      "display" : "Grandate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "110"
        }
      ]
    },
    {
      "code" : "013111",
      "display" : "Grandola ed Uniti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "111"
        }
      ]
    },
    {
      "code" : "013113",
      "display" : "Griante",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "113"
        }
      ]
    },
    {
      "code" : "013114",
      "display" : "Guanzate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "114"
        }
      ]
    },
    {
      "code" : "013118",
      "display" : "Inverigo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "118"
        }
      ]
    },
    {
      "code" : "013119",
      "display" : "Laglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "119"
        }
      ]
    },
    {
      "code" : "013120",
      "display" : "Laino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "120"
        }
      ]
    },
    {
      "code" : "013121",
      "display" : "Lambrugo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "121"
        }
      ]
    },
    {
      "code" : "013123",
      "display" : "Lasnigo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "123"
        }
      ]
    },
    {
      "code" : "013126",
      "display" : "Lezzeno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "126"
        }
      ]
    },
    {
      "code" : "013128",
      "display" : "Limido Comasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "128"
        }
      ]
    },
    {
      "code" : "013129",
      "display" : "Lipomo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "129"
        }
      ]
    },
    {
      "code" : "013130",
      "display" : "Livo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "130"
        }
      ]
    },
    {
      "code" : "013131",
      "display" : "Locate Varesino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "131"
        }
      ]
    },
    {
      "code" : "013133",
      "display" : "Lomazzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "133"
        }
      ]
    },
    {
      "code" : "013134",
      "display" : "Longone al Segrino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "134"
        }
      ]
    },
    {
      "code" : "013135",
      "display" : "Luisago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "135"
        }
      ]
    },
    {
      "code" : "013136",
      "display" : "Lurago d'Erba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "136"
        }
      ]
    },
    {
      "code" : "013137",
      "display" : "Lurago Marinone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "137"
        }
      ]
    },
    {
      "code" : "013138",
      "display" : "Lurate Caccivio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "138"
        }
      ]
    },
    {
      "code" : "013139",
      "display" : "Magreglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "139"
        }
      ]
    },
    {
      "code" : "013143",
      "display" : "Mariano Comense",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "143"
        }
      ]
    },
    {
      "code" : "013144",
      "display" : "Maslianico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "144"
        }
      ]
    },
    {
      "code" : "013145",
      "display" : "Menaggio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "145"
        }
      ]
    },
    {
      "code" : "013147",
      "display" : "Merone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "147"
        }
      ]
    },
    {
      "code" : "013152",
      "display" : "Moltrasio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "152"
        }
      ]
    },
    {
      "code" : "013153",
      "display" : "Monguzzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "153"
        }
      ]
    },
    {
      "code" : "013154",
      "display" : "Montano Lucino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "154"
        }
      ]
    },
    {
      "code" : "013155",
      "display" : "Montemezzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "155"
        }
      ]
    },
    {
      "code" : "013157",
      "display" : "Montorfano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "157"
        }
      ]
    },
    {
      "code" : "013159",
      "display" : "Mozzate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "159"
        }
      ]
    },
    {
      "code" : "013160",
      "display" : "Musso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "160"
        }
      ]
    },
    {
      "code" : "013161",
      "display" : "Nesso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "161"
        }
      ]
    },
    {
      "code" : "013163",
      "display" : "Novedrate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "163"
        }
      ]
    },
    {
      "code" : "013165",
      "display" : "Olgiate Comasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "165"
        }
      ]
    },
    {
      "code" : "013169",
      "display" : "Oltrona di San Mamette",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "169"
        }
      ]
    },
    {
      "code" : "013170",
      "display" : "Orsenigo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "170"
        }
      ]
    },
    {
      "code" : "013178",
      "display" : "Peglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "178"
        }
      ]
    },
    {
      "code" : "013183",
      "display" : "Pianello del Lario",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "183"
        }
      ]
    },
    {
      "code" : "013184",
      "display" : "Pigra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "184"
        }
      ]
    },
    {
      "code" : "013185",
      "display" : "Plesio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "185"
        }
      ]
    },
    {
      "code" : "013186",
      "display" : "Pognana Lario",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "186"
        }
      ]
    },
    {
      "code" : "013187",
      "display" : "Ponna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "187"
        }
      ]
    },
    {
      "code" : "013188",
      "display" : "Ponte Lambro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "188"
        }
      ]
    },
    {
      "code" : "013189",
      "display" : "Porlezza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "189"
        }
      ]
    },
    {
      "code" : "013192",
      "display" : "Proserpio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "192"
        }
      ]
    },
    {
      "code" : "013193",
      "display" : "Pusiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "193"
        }
      ]
    },
    {
      "code" : "013195",
      "display" : "Rezzago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "195"
        }
      ]
    },
    {
      "code" : "013197",
      "display" : "Rodero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "197"
        }
      ]
    },
    {
      "code" : "013199",
      "display" : "Ronago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "199"
        }
      ]
    },
    {
      "code" : "013201",
      "display" : "Rovellasca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "201"
        }
      ]
    },
    {
      "code" : "013202",
      "display" : "Rovello Porro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "202"
        }
      ]
    },
    {
      "code" : "013203",
      "display" : "Sala Comacina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "203"
        }
      ]
    },
    {
      "code" : "013204",
      "display" : "San Bartolomeo Val Cavargna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "204"
        }
      ]
    },
    {
      "code" : "013206",
      "display" : "San Fermo della Battaglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "206"
        }
      ]
    },
    {
      "code" : "013207",
      "display" : "San Nazzaro Val Cavargna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "207"
        }
      ]
    },
    {
      "code" : "013211",
      "display" : "Schignano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "211"
        }
      ]
    },
    {
      "code" : "013212",
      "display" : "Senna Comasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "212"
        }
      ]
    },
    {
      "code" : "013216",
      "display" : "Sorico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "216"
        }
      ]
    },
    {
      "code" : "013217",
      "display" : "Sormano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "217"
        }
      ]
    },
    {
      "code" : "013218",
      "display" : "Stazzona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "218"
        }
      ]
    },
    {
      "code" : "013222",
      "display" : "Tavernerio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "222"
        }
      ]
    },
    {
      "code" : "013223",
      "display" : "Torno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "223"
        }
      ]
    },
    {
      "code" : "013226",
      "display" : "Trezzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "226"
        }
      ]
    },
    {
      "code" : "013227",
      "display" : "Turate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "227"
        }
      ]
    },
    {
      "code" : "013228",
      "display" : "Uggiate-Trevano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "228"
        }
      ]
    },
    {
      "code" : "013229",
      "display" : "Valbrona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "229"
        }
      ]
    },
    {
      "code" : "013232",
      "display" : "Valmorea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "232"
        }
      ]
    },
    {
      "code" : "013233",
      "display" : "Val Rezzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "233"
        }
      ]
    },
    {
      "code" : "013234",
      "display" : "Valsolda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "234"
        }
      ]
    },
    {
      "code" : "013236",
      "display" : "Veleso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "236"
        }
      ]
    },
    {
      "code" : "013238",
      "display" : "Veniano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "238"
        }
      ]
    },
    {
      "code" : "013239",
      "display" : "Vercana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "239"
        }
      ]
    },
    {
      "code" : "013242",
      "display" : "Vertemate con Minoprio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "242"
        }
      ]
    },
    {
      "code" : "013245",
      "display" : "Villa Guardia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "245"
        }
      ]
    },
    {
      "code" : "013246",
      "display" : "Zelbio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "246"
        }
      ]
    },
    {
      "code" : "013248",
      "display" : "San Siro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "248"
        }
      ]
    },
    {
      "code" : "013249",
      "display" : "Gravedona ed Uniti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "249"
        }
      ]
    },
    {
      "code" : "013250",
      "display" : "Bellagio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "250"
        }
      ]
    },
    {
      "code" : "013251",
      "display" : "Colverde",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "251"
        }
      ]
    },
    {
      "code" : "013252",
      "display" : "Tremezzina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "252"
        }
      ]
    },
    {
      "code" : "013253",
      "display" : "Alta Valle Intelvi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "253"
        }
      ]
    },
    {
      "code" : "013254",
      "display" : "Centro Valle Intelvi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "254"
        }
      ]
    },
    {
      "code" : "013255",
      "display" : "Solbiate con Cagno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "013"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "255"
        }
      ]
    },
    {
      "code" : "014001",
      "display" : "Albaredo per San Marco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "014002",
      "display" : "Albosaggia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "014003",
      "display" : "Andalo Valtellino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "014004",
      "display" : "Aprica",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "014005",
      "display" : "Ardenno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "014006",
      "display" : "Bema",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "014007",
      "display" : "Berbenno di Valtellina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "014008",
      "display" : "Bianzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "014009",
      "display" : "Bormio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "014010",
      "display" : "Buglio in Monte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "014011",
      "display" : "Caiolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "014012",
      "display" : "Campodolcino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "014013",
      "display" : "Caspoggio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "014014",
      "display" : "Castello dell'Acqua",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "014015",
      "display" : "Castione Andevenno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "014016",
      "display" : "Cedrasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "014017",
      "display" : "Cercino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "014018",
      "display" : "Chiavenna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "014019",
      "display" : "Chiesa in Valmalenco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "014020",
      "display" : "Chiuro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "014021",
      "display" : "Cino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "014022",
      "display" : "Civo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "014023",
      "display" : "Colorina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "014024",
      "display" : "Cosio Valtellino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "014025",
      "display" : "Dazio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "014026",
      "display" : "Delebio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "014027",
      "display" : "Dubino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "014028",
      "display" : "Faedo Valtellino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "014029",
      "display" : "Forcola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "014030",
      "display" : "Fusine",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "014031",
      "display" : "Gerola Alta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "014032",
      "display" : "Gordona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "014033",
      "display" : "Grosio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "014034",
      "display" : "Grosotto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "014035",
      "display" : "Madesimo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "014036",
      "display" : "Lanzada",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "014037",
      "display" : "Livigno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "014038",
      "display" : "Lovero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "014039",
      "display" : "Mantello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "039"
        }
      ]
    },
    {
      "code" : "014040",
      "display" : "Mazzo di Valtellina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "014041",
      "display" : "Mello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "014043",
      "display" : "Mese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "014044",
      "display" : "Montagna in Valtellina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "014045",
      "display" : "Morbegno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "045"
        }
      ]
    },
    {
      "code" : "014046",
      "display" : "Novate Mezzola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "014047",
      "display" : "Pedesina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "014048",
      "display" : "Piantedo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "014049",
      "display" : "Piateda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "014050",
      "display" : "Piuro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "014051",
      "display" : "Poggiridenti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "014052",
      "display" : "Ponte in Valtellina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "014053",
      "display" : "Postalesio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "014054",
      "display" : "Prata Camportaccio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "054"
        }
      ]
    },
    {
      "code" : "014055",
      "display" : "Rasura",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "014056",
      "display" : "Rogolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "014057",
      "display" : "Samolaco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "014058",
      "display" : "San Giacomo Filippo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "014059",
      "display" : "Sernio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "014060",
      "display" : "Sondalo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "014061",
      "display" : "Sondrio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "014062",
      "display" : "Spriana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "014063",
      "display" : "Talamona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "014064",
      "display" : "Tartano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "014065",
      "display" : "Teglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "014066",
      "display" : "Tirano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "014067",
      "display" : "Torre di Santa Maria",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "014068",
      "display" : "Tovo di Sant'Agata",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "014069",
      "display" : "Traona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "014070",
      "display" : "Tresivio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "014071",
      "display" : "Valdidentro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "014072",
      "display" : "Valdisotto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "014073",
      "display" : "Valfurva",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "014074",
      "display" : "Val Masino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "014075",
      "display" : "Verceia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "014076",
      "display" : "Vervio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "014077",
      "display" : "Villa di Chiavenna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "014078",
      "display" : "Villa di Tirano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "014"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "015002",
      "display" : "Abbiategrasso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "015005",
      "display" : "Albairate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "015007",
      "display" : "Arconate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "015009",
      "display" : "Arese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "015010",
      "display" : "Arluno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "015011",
      "display" : "Assago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "015012",
      "display" : "Bareggio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "015014",
      "display" : "Basiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "015015",
      "display" : "Basiglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "015016",
      "display" : "Bellinzago Lombardo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "015019",
      "display" : "Bernate Ticino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "015022",
      "display" : "Besate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "015024",
      "display" : "Binasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "015026",
      "display" : "Boffalora sopra Ticino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "015027",
      "display" : "Bollate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "015032",
      "display" : "Bresso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "015035",
      "display" : "Bubbiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "015036",
      "display" : "Buccinasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "015038",
      "display" : "Buscate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "015040",
      "display" : "Bussero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "015041",
      "display" : "Busto Garolfo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "015042",
      "display" : "Calvignasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "015044",
      "display" : "Cambiago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "015046",
      "display" : "Canegrate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "015050",
      "display" : "Carpiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "015051",
      "display" : "Carugate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "015055",
      "display" : "Casarile",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "015058",
      "display" : "Casorezzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "015059",
      "display" : "Cassano d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "015060",
      "display" : "Cassina de' Pecchi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "015061",
      "display" : "Cassinetta di Lugagnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "015062",
      "display" : "Castano Primo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "015070",
      "display" : "Cernusco sul Naviglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "015071",
      "display" : "Cerro al Lambro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "015072",
      "display" : "Cerro Maggiore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "015074",
      "display" : "Cesano Boscone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "015076",
      "display" : "Cesate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "015077",
      "display" : "Cinisello Balsamo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "015078",
      "display" : "Cisliano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "015081",
      "display" : "Cologno Monzese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "081"
        }
      ]
    },
    {
      "code" : "015082",
      "display" : "Colturano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "015085",
      "display" : "Corbetta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "015086",
      "display" : "Cormano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "086"
        }
      ]
    },
    {
      "code" : "015087",
      "display" : "Cornaredo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "015093",
      "display" : "Corsico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "015096",
      "display" : "Cuggiono",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "096"
        }
      ]
    },
    {
      "code" : "015097",
      "display" : "Cusago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "015098",
      "display" : "Cusano Milanino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "098"
        }
      ]
    },
    {
      "code" : "015099",
      "display" : "Dairago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "099"
        }
      ]
    },
    {
      "code" : "015101",
      "display" : "Dresano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "101"
        }
      ]
    },
    {
      "code" : "015103",
      "display" : "Gaggiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "103"
        }
      ]
    },
    {
      "code" : "015105",
      "display" : "Garbagnate Milanese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "105"
        }
      ]
    },
    {
      "code" : "015106",
      "display" : "Gessate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "106"
        }
      ]
    },
    {
      "code" : "015108",
      "display" : "Gorgonzola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "015110",
      "display" : "Grezzago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "110"
        }
      ]
    },
    {
      "code" : "015112",
      "display" : "Gudo Visconti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "112"
        }
      ]
    },
    {
      "code" : "015113",
      "display" : "Inveruno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "113"
        }
      ]
    },
    {
      "code" : "015114",
      "display" : "Inzago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "114"
        }
      ]
    },
    {
      "code" : "015115",
      "display" : "Lacchiarella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "115"
        }
      ]
    },
    {
      "code" : "015116",
      "display" : "Lainate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "116"
        }
      ]
    },
    {
      "code" : "015118",
      "display" : "Legnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "118"
        }
      ]
    },
    {
      "code" : "015122",
      "display" : "Liscate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "122"
        }
      ]
    },
    {
      "code" : "015125",
      "display" : "Locate di Triulzi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "125"
        }
      ]
    },
    {
      "code" : "015130",
      "display" : "Magenta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "130"
        }
      ]
    },
    {
      "code" : "015131",
      "display" : "Magnago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "131"
        }
      ]
    },
    {
      "code" : "015134",
      "display" : "Marcallo con Casone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "134"
        }
      ]
    },
    {
      "code" : "015136",
      "display" : "Masate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "136"
        }
      ]
    },
    {
      "code" : "015139",
      "display" : "Mediglia",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "139"
        }
      ]
    },
    {
      "code" : "015140",
      "display" : "Melegnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "140"
        }
      ]
    },
    {
      "code" : "015142",
      "display" : "Melzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "142"
        }
      ]
    },
    {
      "code" : "015144",
      "display" : "Mesero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "144"
        }
      ]
    },
    {
      "code" : "015146",
      "display" : "Milano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "146"
        }
      ]
    },
    {
      "code" : "015150",
      "display" : "Morimondo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "150"
        }
      ]
    },
    {
      "code" : "015151",
      "display" : "Motta Visconti",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "151"
        }
      ]
    },
    {
      "code" : "015154",
      "display" : "Nerviano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "154"
        }
      ]
    },
    {
      "code" : "015155",
      "display" : "Nosate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "155"
        }
      ]
    },
    {
      "code" : "015157",
      "display" : "Novate Milanese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "157"
        }
      ]
    },
    {
      "code" : "015158",
      "display" : "Noviglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "158"
        }
      ]
    },
    {
      "code" : "015159",
      "display" : "Opera",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "159"
        }
      ]
    },
    {
      "code" : "015164",
      "display" : "Ossona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "164"
        }
      ]
    },
    {
      "code" : "015165",
      "display" : "Ozzero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "165"
        }
      ]
    },
    {
      "code" : "015166",
      "display" : "Paderno Dugnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "166"
        }
      ]
    },
    {
      "code" : "015167",
      "display" : "Pantigliate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "167"
        }
      ]
    },
    {
      "code" : "015168",
      "display" : "Parabiago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "168"
        }
      ]
    },
    {
      "code" : "015169",
      "display" : "Paullo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "169"
        }
      ]
    },
    {
      "code" : "015170",
      "display" : "Pero",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "170"
        }
      ]
    },
    {
      "code" : "015171",
      "display" : "Peschiera Borromeo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "171"
        }
      ]
    },
    {
      "code" : "015172",
      "display" : "Pessano con Bornago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "172"
        }
      ]
    },
    {
      "code" : "015173",
      "display" : "Pieve Emanuele",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "173"
        }
      ]
    },
    {
      "code" : "015175",
      "display" : "Pioltello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "175"
        }
      ]
    },
    {
      "code" : "015176",
      "display" : "Pogliano Milanese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "176"
        }
      ]
    },
    {
      "code" : "015177",
      "display" : "Pozzo d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "177"
        }
      ]
    },
    {
      "code" : "015178",
      "display" : "Pozzuolo Martesana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "178"
        }
      ]
    },
    {
      "code" : "015179",
      "display" : "Pregnana Milanese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "179"
        }
      ]
    },
    {
      "code" : "015181",
      "display" : "Rescaldina",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "181"
        }
      ]
    },
    {
      "code" : "015182",
      "display" : "Rho",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "182"
        }
      ]
    },
    {
      "code" : "015183",
      "display" : "Robecchetto con Induno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "183"
        }
      ]
    },
    {
      "code" : "015184",
      "display" : "Robecco sul Naviglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "184"
        }
      ]
    },
    {
      "code" : "015185",
      "display" : "Rodano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "185"
        }
      ]
    },
    {
      "code" : "015188",
      "display" : "Rosate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "188"
        }
      ]
    },
    {
      "code" : "015189",
      "display" : "Rozzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "189"
        }
      ]
    },
    {
      "code" : "015191",
      "display" : "San Colombano al Lambro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "191"
        }
      ]
    },
    {
      "code" : "015192",
      "display" : "San Donato Milanese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "192"
        }
      ]
    },
    {
      "code" : "015194",
      "display" : "San Giorgio su Legnano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "194"
        }
      ]
    },
    {
      "code" : "015195",
      "display" : "San Giuliano Milanese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "195"
        }
      ]
    },
    {
      "code" : "015200",
      "display" : "Santo Stefano Ticino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "200"
        }
      ]
    },
    {
      "code" : "015201",
      "display" : "San Vittore Olona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "201"
        }
      ]
    },
    {
      "code" : "015202",
      "display" : "San Zenone al Lambro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "202"
        }
      ]
    },
    {
      "code" : "015204",
      "display" : "Sedriano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "204"
        }
      ]
    },
    {
      "code" : "015205",
      "display" : "Segrate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "205"
        }
      ]
    },
    {
      "code" : "015206",
      "display" : "Senago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "206"
        }
      ]
    },
    {
      "code" : "015209",
      "display" : "Sesto San Giovanni",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "209"
        }
      ]
    },
    {
      "code" : "015210",
      "display" : "Settala",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "210"
        }
      ]
    },
    {
      "code" : "015211",
      "display" : "Settimo Milanese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "211"
        }
      ]
    },
    {
      "code" : "015213",
      "display" : "Solaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "213"
        }
      ]
    },
    {
      "code" : "015219",
      "display" : "Trezzano Rosa",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "219"
        }
      ]
    },
    {
      "code" : "015220",
      "display" : "Trezzano sul Naviglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "220"
        }
      ]
    },
    {
      "code" : "015221",
      "display" : "Trezzo sull'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "221"
        }
      ]
    },
    {
      "code" : "015222",
      "display" : "Tribiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "222"
        }
      ]
    },
    {
      "code" : "015224",
      "display" : "Truccazzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "224"
        }
      ]
    },
    {
      "code" : "015226",
      "display" : "Turbigo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "226"
        }
      ]
    },
    {
      "code" : "015229",
      "display" : "Vanzago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "229"
        }
      ]
    },
    {
      "code" : "015230",
      "display" : "Vaprio d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "230"
        }
      ]
    },
    {
      "code" : "015236",
      "display" : "Vernate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "236"
        }
      ]
    },
    {
      "code" : "015237",
      "display" : "Vignate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "237"
        }
      ]
    },
    {
      "code" : "015242",
      "display" : "Vimodrone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "242"
        }
      ]
    },
    {
      "code" : "015243",
      "display" : "Vittuone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "243"
        }
      ]
    },
    {
      "code" : "015244",
      "display" : "Vizzolo Predabissi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "244"
        }
      ]
    },
    {
      "code" : "015247",
      "display" : "Zibido San Giacomo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "247"
        }
      ]
    },
    {
      "code" : "015248",
      "display" : "Villa Cortese",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "248"
        }
      ]
    },
    {
      "code" : "015249",
      "display" : "Vanzaghello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "249"
        }
      ]
    },
    {
      "code" : "015250",
      "display" : "Baranzate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "250"
        }
      ]
    },
    {
      "code" : "015251",
      "display" : "Vermezzo con Zelo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "015"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "251"
        }
      ]
    },
    {
      "code" : "016001",
      "display" : "Adrara San Martino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "001"
        }
      ]
    },
    {
      "code" : "016002",
      "display" : "Adrara San Rocco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "002"
        }
      ]
    },
    {
      "code" : "016003",
      "display" : "Albano Sant'Alessandro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "003"
        }
      ]
    },
    {
      "code" : "016004",
      "display" : "Albino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "004"
        }
      ]
    },
    {
      "code" : "016005",
      "display" : "Almè",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "005"
        }
      ]
    },
    {
      "code" : "016006",
      "display" : "Almenno San Bartolomeo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "006"
        }
      ]
    },
    {
      "code" : "016007",
      "display" : "Almenno San Salvatore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "007"
        }
      ]
    },
    {
      "code" : "016008",
      "display" : "Alzano Lombardo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "008"
        }
      ]
    },
    {
      "code" : "016009",
      "display" : "Ambivere",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "009"
        }
      ]
    },
    {
      "code" : "016010",
      "display" : "Antegnate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "010"
        }
      ]
    },
    {
      "code" : "016011",
      "display" : "Arcene",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "011"
        }
      ]
    },
    {
      "code" : "016012",
      "display" : "Ardesio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "012"
        }
      ]
    },
    {
      "code" : "016013",
      "display" : "Arzago d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "013"
        }
      ]
    },
    {
      "code" : "016014",
      "display" : "Averara",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "014"
        }
      ]
    },
    {
      "code" : "016015",
      "display" : "Aviatico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "015"
        }
      ]
    },
    {
      "code" : "016016",
      "display" : "Azzano San Paolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "016"
        }
      ]
    },
    {
      "code" : "016017",
      "display" : "Azzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "017"
        }
      ]
    },
    {
      "code" : "016018",
      "display" : "Bagnatica",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "018"
        }
      ]
    },
    {
      "code" : "016019",
      "display" : "Barbata",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "019"
        }
      ]
    },
    {
      "code" : "016020",
      "display" : "Bariano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "020"
        }
      ]
    },
    {
      "code" : "016021",
      "display" : "Barzana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "021"
        }
      ]
    },
    {
      "code" : "016022",
      "display" : "Bedulita",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "022"
        }
      ]
    },
    {
      "code" : "016023",
      "display" : "Berbenno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "023"
        }
      ]
    },
    {
      "code" : "016024",
      "display" : "Bergamo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : true
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "024"
        }
      ]
    },
    {
      "code" : "016025",
      "display" : "Berzo San Fermo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "025"
        }
      ]
    },
    {
      "code" : "016026",
      "display" : "Bianzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "026"
        }
      ]
    },
    {
      "code" : "016027",
      "display" : "Blello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "027"
        }
      ]
    },
    {
      "code" : "016028",
      "display" : "Bolgare",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "028"
        }
      ]
    },
    {
      "code" : "016029",
      "display" : "Boltiere",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "029"
        }
      ]
    },
    {
      "code" : "016030",
      "display" : "Bonate Sopra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "030"
        }
      ]
    },
    {
      "code" : "016031",
      "display" : "Bonate Sotto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "031"
        }
      ]
    },
    {
      "code" : "016032",
      "display" : "Borgo di Terzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "032"
        }
      ]
    },
    {
      "code" : "016033",
      "display" : "Bossico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "033"
        }
      ]
    },
    {
      "code" : "016034",
      "display" : "Bottanuco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "034"
        }
      ]
    },
    {
      "code" : "016035",
      "display" : "Bracca",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "035"
        }
      ]
    },
    {
      "code" : "016036",
      "display" : "Branzi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "036"
        }
      ]
    },
    {
      "code" : "016037",
      "display" : "Brembate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "037"
        }
      ]
    },
    {
      "code" : "016038",
      "display" : "Brembate di Sopra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "038"
        }
      ]
    },
    {
      "code" : "016040",
      "display" : "Brignano Gera d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "040"
        }
      ]
    },
    {
      "code" : "016041",
      "display" : "Brumano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "041"
        }
      ]
    },
    {
      "code" : "016042",
      "display" : "Brusaporto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "042"
        }
      ]
    },
    {
      "code" : "016043",
      "display" : "Calcinate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "043"
        }
      ]
    },
    {
      "code" : "016044",
      "display" : "Calcio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "044"
        }
      ]
    },
    {
      "code" : "016046",
      "display" : "Calusco d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "046"
        }
      ]
    },
    {
      "code" : "016047",
      "display" : "Calvenzano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "047"
        }
      ]
    },
    {
      "code" : "016048",
      "display" : "Camerata Cornello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "048"
        }
      ]
    },
    {
      "code" : "016049",
      "display" : "Canonica d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "049"
        }
      ]
    },
    {
      "code" : "016050",
      "display" : "Capizzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "050"
        }
      ]
    },
    {
      "code" : "016051",
      "display" : "Capriate San Gervasio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "051"
        }
      ]
    },
    {
      "code" : "016052",
      "display" : "Caprino Bergamasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "052"
        }
      ]
    },
    {
      "code" : "016053",
      "display" : "Caravaggio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "053"
        }
      ]
    },
    {
      "code" : "016055",
      "display" : "Carobbio degli Angeli",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "055"
        }
      ]
    },
    {
      "code" : "016056",
      "display" : "Carona",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "056"
        }
      ]
    },
    {
      "code" : "016057",
      "display" : "Carvico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "057"
        }
      ]
    },
    {
      "code" : "016058",
      "display" : "Casazza",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "058"
        }
      ]
    },
    {
      "code" : "016059",
      "display" : "Casirate d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "059"
        }
      ]
    },
    {
      "code" : "016060",
      "display" : "Casnigo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "060"
        }
      ]
    },
    {
      "code" : "016061",
      "display" : "Cassiglio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "061"
        }
      ]
    },
    {
      "code" : "016062",
      "display" : "Castelli Calepio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "062"
        }
      ]
    },
    {
      "code" : "016063",
      "display" : "Castel Rozzone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "063"
        }
      ]
    },
    {
      "code" : "016064",
      "display" : "Castione della Presolana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "064"
        }
      ]
    },
    {
      "code" : "016065",
      "display" : "Castro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "065"
        }
      ]
    },
    {
      "code" : "016066",
      "display" : "Cavernago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "066"
        }
      ]
    },
    {
      "code" : "016067",
      "display" : "Cazzano Sant'Andrea",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "067"
        }
      ]
    },
    {
      "code" : "016068",
      "display" : "Cenate Sopra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "068"
        }
      ]
    },
    {
      "code" : "016069",
      "display" : "Cenate Sotto",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "069"
        }
      ]
    },
    {
      "code" : "016070",
      "display" : "Cene",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "070"
        }
      ]
    },
    {
      "code" : "016071",
      "display" : "Cerete",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "071"
        }
      ]
    },
    {
      "code" : "016072",
      "display" : "Chignolo d'Isola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "072"
        }
      ]
    },
    {
      "code" : "016073",
      "display" : "Chiuduno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "073"
        }
      ]
    },
    {
      "code" : "016074",
      "display" : "Cisano Bergamasco",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "074"
        }
      ]
    },
    {
      "code" : "016075",
      "display" : "Ciserano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "075"
        }
      ]
    },
    {
      "code" : "016076",
      "display" : "Cividate al Piano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "076"
        }
      ]
    },
    {
      "code" : "016077",
      "display" : "Clusone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "077"
        }
      ]
    },
    {
      "code" : "016078",
      "display" : "Colere",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "078"
        }
      ]
    },
    {
      "code" : "016079",
      "display" : "Cologno al Serio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "079"
        }
      ]
    },
    {
      "code" : "016080",
      "display" : "Colzate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "080"
        }
      ]
    },
    {
      "code" : "016081",
      "display" : "Comun Nuovo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "081"
        }
      ]
    },
    {
      "code" : "016082",
      "display" : "Corna Imagna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "082"
        }
      ]
    },
    {
      "code" : "016083",
      "display" : "Cortenuova",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "083"
        }
      ]
    },
    {
      "code" : "016084",
      "display" : "Costa di Mezzate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "084"
        }
      ]
    },
    {
      "code" : "016085",
      "display" : "Costa Valle Imagna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "085"
        }
      ]
    },
    {
      "code" : "016086",
      "display" : "Costa Volpino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "086"
        }
      ]
    },
    {
      "code" : "016087",
      "display" : "Covo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "087"
        }
      ]
    },
    {
      "code" : "016088",
      "display" : "Credaro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "088"
        }
      ]
    },
    {
      "code" : "016089",
      "display" : "Curno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "089"
        }
      ]
    },
    {
      "code" : "016090",
      "display" : "Cusio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "090"
        }
      ]
    },
    {
      "code" : "016091",
      "display" : "Dalmine",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "091"
        }
      ]
    },
    {
      "code" : "016092",
      "display" : "Dossena",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "092"
        }
      ]
    },
    {
      "code" : "016093",
      "display" : "Endine Gaiano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "093"
        }
      ]
    },
    {
      "code" : "016094",
      "display" : "Entratico",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "094"
        }
      ]
    },
    {
      "code" : "016096",
      "display" : "Fara Gera d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "096"
        }
      ]
    },
    {
      "code" : "016097",
      "display" : "Fara Olivana con Sola",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "097"
        }
      ]
    },
    {
      "code" : "016098",
      "display" : "Filago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "098"
        }
      ]
    },
    {
      "code" : "016099",
      "display" : "Fino del Monte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "099"
        }
      ]
    },
    {
      "code" : "016100",
      "display" : "Fiorano al Serio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "100"
        }
      ]
    },
    {
      "code" : "016101",
      "display" : "Fontanella",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "101"
        }
      ]
    },
    {
      "code" : "016102",
      "display" : "Fonteno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "102"
        }
      ]
    },
    {
      "code" : "016103",
      "display" : "Foppolo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "103"
        }
      ]
    },
    {
      "code" : "016104",
      "display" : "Foresto Sparso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "104"
        }
      ]
    },
    {
      "code" : "016105",
      "display" : "Fornovo San Giovanni",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "105"
        }
      ]
    },
    {
      "code" : "016106",
      "display" : "Fuipiano Valle Imagna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "106"
        }
      ]
    },
    {
      "code" : "016107",
      "display" : "Gandellino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "107"
        }
      ]
    },
    {
      "code" : "016108",
      "display" : "Gandino",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "108"
        }
      ]
    },
    {
      "code" : "016109",
      "display" : "Gandosso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "109"
        }
      ]
    },
    {
      "code" : "016110",
      "display" : "Gaverina Terme",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "110"
        }
      ]
    },
    {
      "code" : "016111",
      "display" : "Gazzaniga",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "111"
        }
      ]
    },
    {
      "code" : "016113",
      "display" : "Ghisalba",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "113"
        }
      ]
    },
    {
      "code" : "016114",
      "display" : "Gorlago",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "114"
        }
      ]
    },
    {
      "code" : "016115",
      "display" : "Gorle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "115"
        }
      ]
    },
    {
      "code" : "016116",
      "display" : "Gorno",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "116"
        }
      ]
    },
    {
      "code" : "016117",
      "display" : "Grassobbio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "117"
        }
      ]
    },
    {
      "code" : "016118",
      "display" : "Gromo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "118"
        }
      ]
    },
    {
      "code" : "016119",
      "display" : "Grone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "119"
        }
      ]
    },
    {
      "code" : "016120",
      "display" : "Grumello del Monte",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "120"
        }
      ]
    },
    {
      "code" : "016121",
      "display" : "Isola di Fondra",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "121"
        }
      ]
    },
    {
      "code" : "016122",
      "display" : "Isso",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "122"
        }
      ]
    },
    {
      "code" : "016123",
      "display" : "Lallio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "123"
        }
      ]
    },
    {
      "code" : "016124",
      "display" : "Leffe",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "124"
        }
      ]
    },
    {
      "code" : "016125",
      "display" : "Lenna",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "125"
        }
      ]
    },
    {
      "code" : "016126",
      "display" : "Levate",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "126"
        }
      ]
    },
    {
      "code" : "016127",
      "display" : "Locatello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "127"
        }
      ]
    },
    {
      "code" : "016128",
      "display" : "Lovere",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "128"
        }
      ]
    },
    {
      "code" : "016129",
      "display" : "Lurano",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "129"
        }
      ]
    },
    {
      "code" : "016130",
      "display" : "Luzzana",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "130"
        }
      ]
    },
    {
      "code" : "016131",
      "display" : "Madone",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "131"
        }
      ]
    },
    {
      "code" : "016132",
      "display" : "Mapello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "132"
        }
      ]
    },
    {
      "code" : "016133",
      "display" : "Martinengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "133"
        }
      ]
    },
    {
      "code" : "016134",
      "display" : "Mezzoldo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "134"
        }
      ]
    },
    {
      "code" : "016135",
      "display" : "Misano di Gera d'Adda",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "135"
        }
      ]
    },
    {
      "code" : "016136",
      "display" : "Moio de' Calvi",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "136"
        }
      ]
    },
    {
      "code" : "016137",
      "display" : "Monasterolo del Castello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "137"
        }
      ]
    },
    {
      "code" : "016139",
      "display" : "Montello",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "139"
        }
      ]
    },
    {
      "code" : "016140",
      "display" : "Morengo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "140"
        }
      ]
    },
    {
      "code" : "016141",
      "display" : "Mornico al Serio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "141"
        }
      ]
    },
    {
      "code" : "016142",
      "display" : "Mozzanica",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "142"
        }
      ]
    },
    {
      "code" : "016143",
      "display" : "Mozzo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "143"
        }
      ]
    },
    {
      "code" : "016144",
      "display" : "Nembro",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "144"
        }
      ]
    },
    {
      "code" : "016145",
      "display" : "Olmo al Brembo",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "145"
        }
      ]
    },
    {
      "code" : "016146",
      "display" : "Oltre il Colle",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "146"
        }
      ]
    },
    {
      "code" : "016147",
      "display" : "Oltressenda Alta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "147"
        }
      ]
    },
    {
      "code" : "016148",
      "display" : "Oneta",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "148"
        }
      ]
    },
    {
      "code" : "016149",
      "display" : "Onore",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "149"
        }
      ]
    },
    {
      "code" : "016150",
      "display" : "Orio al Serio",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "150"
        }
      ]
    },
    {
      "code" : "016151",
      "display" : "Ornica",
      "property" : [
        {
          "code" : "flagCapoluogo",
          "valueBoolean" : false
        },
        {
          "code" : "regione",
          "valueCode" : "030"
        },
        {
          "code" : "provincia",
          "valueCode" : "016"
        },
        {
          "code" : "ripartizioneGeografica",
          "valueCode" : "1"
        },
        {
          "code" : "comune",
          "valueCode" : "151"
        }
      ]
    },
    {
      "code" :